

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetCopySubclientAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetCopySubclientAssociation.sp,v $ $Id: RptGetCopySubclientAssociation.sp,v 1.3.36.3 2018/11/18 03:52:31 skatz Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetCopySubclientAssociation')
BEGIN
	print '>>> Drop Stored Procedure: RptGetCopySubclientAssociation <<<'
	drop procedure RptGetCopySubclientAssociation
END
IF EXISTS (select * from GxQscripts where name='RptGetCopySubclientAssociation')
	delete from GxQscripts where name = 'RptGetCopySubclientAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCopySubclientAssociation')
	delete from GXDBVersions where aliasname = 'RptGetCopySubclientAssociation'
GO
print '... Creating Procedure: RptGetCopySubclientAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetCopySubclientAssociation
  @i_policyIdsXml xml
AS
  DECLARE @o_archGroupId integer;
  DECLARE @o_policyName NVARCHAR(255);
  DECLARE @o_copyId integer;
  DECLARE @o_copyName NVARCHAR(255);
  DECLARE @o_clientId integer;
  DECLARE @o_clientName nvarchar(255);
  DECLARE @o_appTypeId integer;
  DECLARE @o_appTypeName varchar(255);
  DECLARE @o_instanceId integer;
  DECLARE @o_instanceName nvarchar(255);
  DECLARE @o_backupSetId integer;
  DECLARE @o_backupSetName nvarchar(255);
  DECLARE @o_subclientId integer;
  DECLARE @o_subclientName nvarchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #tempPolicyIds (archGroupId int)
INSERT	INTO #tempPolicyIds
SELECT	T.c.value('@policyId', 'int')
FROM	@i_policyIdsXml.nodes('/r/h') T(c)
SELECT	G.id,			G.name,
		C.id,			C.name,
		A.clientId,		(CASE ISNULL(A.clientId, 0) WHEN 0 THEN '' ELSE (select name = displayName from APP_Client where id = A.clientId) END),
		A.appTypeId,	(CASE ISNULL(A.appTypeId, 0) WHEN 0 THEN '' ELSE (select name from APP_iDAType where type = A.appTypeId) END),
		A.instanceId,	(CASE ISNULL(A.instanceId, 0) WHEN 0 THEN '' ELSE (select name from APP_InstanceName where id = A.instanceId) END),
		A.backupSetId,	(CASE ISNULL(A.backupSetId, 0) WHEN 0 THEN '' ELSE (select name from APP_BackupSetName where id = A.backupSetId) END),
		A.subClientId,	(CASE ISNULL(A.subClientId, 0) WHEN 0 THEN '' ELSE (select subClientName from APP_Application where id = A.subClientId) END)
FROM	#tempPolicyIds T
		INNER JOIN archGroup G ON G.id = T.archGroupId
INNER JOIN archGroupCopy C ON C.archGroupId = T.archGroupId AND C.type <> 5
		LEFT  JOIN archCopyToApp A ON A.copyId = C.id
ORDER BY G.name, C.name
DROP TABLE #tempPolicyIds
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCopySubclientAssociation')
	delete from GxQscripts where name = 'RptGetCopySubclientAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCopySubclientAssociation')
	delete from GXDBVersions where aliasname = 'RptGetCopySubclientAssociation'
GO

insert into GXDBVersions values(2, 'RptGetCopySubclientAssociation',  '00010003003600030000', 'RptGetCopySubclientAssociation', '00010003003600030000')
GO

