

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetCopyRetention.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetCopyRetention.sp,v $ $Id: rptGetCopyRetention.sp,v 1.14.86.2 2018/03/22 03:06:04 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Cursor: "rptGetCopyRetention"			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetCopyRetention')
BEGIN
	print '>>> Drop Stored Procedure: rptGetCopyRetention <<<'
	drop procedure rptGetCopyRetention
END
IF EXISTS (select * from GxQscripts where name='rptGetCopyRetention')
	delete from GxQscripts where name = 'rptGetCopyRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetCopyRetention')
	delete from GXDBVersions where aliasname = 'rptGetCopyRetention'
GO
print '... Creating Procedure: rptGetCopyRetention'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetCopyRetention
  @i_clientId INTEGER,
  @i_appTypeId INTEGER,
  @i_instanceId INTEGER,
  @i_backupSetId INTEGER,
  @i_subclientId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @o_copyId integer;
  DECLARE @o_copyName NVARCHAR(255);
  DECLARE @o_retentionDays integer;
  DECLARE @o_retentionCycles integer;
  DECLARE @o_flags integer;
  DECLARE @o_weekStart integer;
  DECLARE @o_monthStart integer;
  DECLARE @o_yearStart integer;
  DECLARE @o_archiverRetDays integer;
  DECLARE @o_extDays integer;
  DECLARE @o_extRuleId integer;
  DECLARE @o_TimeZoneType integer;
  DECLARE @o_GraceDays integer;
  DECLARE @o_retentionJobs integer;
  DECLARE @o_dayStart varchar(10);
  DECLARE @o_EveryXHours integer;
  DECLARE @o_calendarName NVARCHAR(255);;
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
 SET NOCOUNT ON
IF object_id('tempdb.dbo.#temp_copy_list') IS NOT null DROP TABLE #temp_copy_list
CREATE TABLE #temp_copy_list(
	m_id						INT,
	m_name					NVARCHAR(256),
	m_archGroupId		INT,
	m_flag					INT,
	m_TimeZoneType	INT,
	m_calendarId		INT,
	m_calendarName	NVARCHAR(2048)
)
IF @i_copyId > 0
	INSERT INTO #temp_copy_list
	SELECT id, name, archGroupId, 0, 0, calendarId, 'NO NAME'
	FROM archGroupcopy WITH (NOLOCK)
	WHERE id = @i_copyId
ELSE
	BEGIN
		INSERT INTO #temp_copy_list
		SELECT	C.id, C.name, C.archGroupId, 0, 0, C.calendarId, 'NO NAME'
		FROM	APP_Application A, archGroupCopy C
		WHERE	C.id > 0
		AND 	A.id = @i_subclientId
		AND 	(A.dataArchGrpId = C.archGroupId OR A.logArchGrpId = C.archGroupId)
		UPDATE	#temp_copy_list
		SET m_flag=1
		FROM	#temp_copy_list T, ArchCopyToApp A
		WHERE	T.m_flag = 0
		AND 	T.m_id = A.copyId
		AND 	A.clientId = @i_clientId
		AND 	(A.appTypeId = 0 OR (A.appTypeId = @i_appTypeId
		AND 	(A.instanceId = 0 OR (A.instanceId = @i_instanceId
		AND 	(A.backupSetId = 0 OR (A.backupSetId = @i_backupSetId
		AND 	(A.subclientId = 0 OR A.subclientId = @i_subclientId)))))))
	END
	UPDATE	#temp_copy_list
	SET m_flag = 1
	WHERE	m_id IN (SELECT defaultCopy FROM archGroup WHERE id = #temp_copy_list.m_archGroupId)
	OR 		NOT EXISTS (SELECT * FROM ArchCopyToApp WHERE copyId = #temp_copy_list.m_id)
	UPDATE #temp_copy_list
	SET m_TimeZoneType = AG.TimeZoneType
	FROM #temp_copy_list T, archGroup AG WITH (NOLOCK)
	WHERE T.m_archGroupId = AG.id
	--Get Calendar Name
	UPDATE #temp_copy_list
	SET m_calendarName = CC.name
	FROM #temp_copy_list T, APP_CustomCalendar CC WITH (NOLOCK)
	WHERE T.m_calendarId = CC.id
	SELECT	DISTINCT m_Id, m_name,
					R.retentionDays, R.fullCycles, R.flags,
					R.weekStart, R.monthStart, R.yearStart,
					R.archiverRetDays, E.retentionDays, E.retentionRule,
					m_TimeZoneType, E.GraceDays, R.retentionJobs,
					STUFF(RIGHT(CONVERT(VARCHAR(26), DATEADD(MINUTE, R.minutesSinceDayStarts, 0), 109), 15), 7, 7, ' '),
					E.EveryXHours, m_calendarName
	FROM	#temp_copy_list
	LEFT JOIN archAgingRule R ON m_Id = R.copyId
	LEFT JOIN archAgingRuleExtended E ON m_Id = E.copyId
	--WHERE	m_flag = 1
	ORDER BY E.retentionRule asc
	DROP TABLE #temp_copy_list
 SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCopyRetention')
	delete from GxQscripts where name = 'RptGetCopyRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCopyRetention')
	delete from GXDBVersions where aliasname = 'RptGetCopyRetention'
GO

insert into GXDBVersions values(2, 'RptGetCopyRetention',  '00010014008600020000', 'RptGetCopyRetention', '00010014008600020000')
GO

