

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetContentIndexingProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetContentIndexingProp.sp,v $ $Id: RptGetContentIndexingProp.sp,v 1.1.278.4 2018/11/18 03:49:40 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : ""			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetContentIndexingProp')
BEGIN
	print '>>> Drop Stored Procedure: RptGetContentIndexingProp <<<'
	drop procedure RptGetContentIndexingProp
END
IF EXISTS (select * from GxQscripts where name='RptGetContentIndexingProp')
	delete from GxQscripts where name = 'RptGetContentIndexingProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetContentIndexingProp')
	delete from GXDBVersions where aliasname = 'RptGetContentIndexingProp'
GO
print '... Creating Procedure: RptGetContentIndexingProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetContentIndexingProp
  @i_policyIdsXml xml
AS
  DECLARE @o_archGroupId integer;
  DECLARE @o_policyName NVARCHAR(255);
  DECLARE @o_serverName nvarchar(255);
  DECLARE @o_sourceCopyName NVARCHAR(255);
  DECLARE @o_enabled integer;
  DECLARE @o_type integer;
  DECLARE @o_flags integer;
  DECLARE @o_deferredDays integer;
  DECLARE @o_retentionDays integer;
  DECLARE @o_numPeriod integer;
  DECLARE @o_dayNumber integer;
  DECLARE @o_minDocSizeKB integer;
  DECLARE @o_maxDocSizeKB integer;
  DECLARE @o_includeDocTypes nvarchar(MAX);
  DECLARE @o_excludeDocTypes nvarchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #tempPolicyIds (archGroupId int)
INSERT	INTO #tempPolicyIds
SELECT	T.c.value('@policyId', 'int')
FROM	@i_policyIdsXml.nodes('/r/h') T(c)
CREATE TABLE #tempCIProp (
		archGroupId int, enabled int, type int, flags int, cloudId int, startTime int, sourceCopyId int,
		deferredDays int, retentionDays int, numPeriod int, dayNumber int, minDocSizeKB int, maxDocSizeKB int,
		includeDocTypes nvarchar(max), excludeDocTypes nvarchar(max))
INSERT	INTO #tempCIProp
SELECT	R.archGroupId, R.enabled, R.type, R.flags, R.cloudId, R.startTime, R.sourceCopyId,
		R.deferredDays, R.retentionDays, R.numPeriod, R.dayNumber, R.minDocSizeKB, R.maxDocSizeKB,
		R.includeDocTypes, R.excludeDocTypes
FROM	archContentIndexingRules R, #tempPolicyIds P
WHERE	R.archGroupId = P.archGroupId AND R.operationType = 1
SELECT	PolicyId	= AG.id,
		PolicyName	= AG.name,
		ServerName	= CL.displayName,
		SourceCopy	= CASE WHEN CI.SourceCopyId > 0 THEN (SELECT name FROM archGroupCopy WHERE id = CI.SourceCopyId) ELSE '' END,
		CI.enabled,
		CI.type,
		CI.flags,
		CI.deferredDays,
		CI.retentionDays,
		CI.numPeriod,
		CI.dayNumber,
		CI.minDocSizeKB,
		CI.maxDocSizeKB,
		CI.includeDocTypes,
		CI.excludeDocTypes
FROM	#tempCIProp CI, APP_Client CL, APP_ComponentProp CP, archGroup AG
WHERE	AG.id = CI.archGroupId
	AND CL.id = CP.longVal
	AND CP.componentId = CI.cloudId
AND CP.componentType = 2
AND CP.propertyTypeId = 1008
	AND CP.modified = 0
ORDER BY AG.name
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetContentIndexingProp')
	delete from GxQscripts where name = 'RptGetContentIndexingProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetContentIndexingProp')
	delete from GXDBVersions where aliasname = 'RptGetContentIndexingProp'
GO

insert into GXDBVersions values(2, 'RptGetContentIndexingProp',  '00010001027800040000', 'RptGetContentIndexingProp', '00010001027800040000')
GO

