

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetCommCellGroupsXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetCommCellGroupsXML')
BEGIN
	print '>>> Drop Stored Procedure: RptGetCommCellGroupsXML <<<'
	drop procedure RptGetCommCellGroupsXML
END
IF EXISTS (select * from GxQscripts where name='RptGetCommCellGroupsXML')
	delete from GxQscripts where name = 'RptGetCommCellGroupsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCommCellGroupsXML')
	delete from GXDBVersions where aliasname = 'RptGetCommCellGroupsXML'
GO
print '... Creating Procedure: RptGetCommCellGroupsXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetCommCellGroupsXML
  @i_GroupName NVARCHAR(1024) = '',
  @i_outputType INT = 0,			--0:XML, 1:CSV
  @i_groupType INT = 1				-- 0:All(applicable only for csv output type), 1:App_ClientGroup, 2:UMGroup
AS
  DECLARE @o_CCGroups XML
SET NOCOUNT ON
SET @i_GroupName = ISNULL( @i_GroupName ,'')
SET @i_outputType = ISNULL(@i_outputType, 0)
SET @i_groupType = ISNULL(@i_groupType, 1)
IF object_id('tempdb.dbo.#CommCellGroups') is not null  DROP TABLE #CommCellGroups
CREATE TABLE #CommCellGroups(GroupId INT, GroupName NVARCHAR(512), modifiedBy INT DEFAULT 0, createdBy INT, isProfileEnabled INT DEFAULT 0)
IF object_id('tempdb.dbo.#CommCellGroupClient') is not null  DROP TABLE #CommCellGroupClient
CREATE TABLE #CommCellGroupClient(GroupId INT, ClientGUID VARCHAR(256))
IF object_id('tempdb.dbo.#companies') IS NOT NULL DROP TABLE #companies
CREATE TABLE #companies(userGroupId INT, userGroupName NVARCHAR(510), clientGroupId INT DEFAULT 0)
DECLARE @assocCGId INT = 0
DECLARE @assocCGName NVARCHAR(1024) = ''
IF (@i_groupType IN (0, 2)) --Usergroup based CommCell Group (companies)
BEGIN
	INSERT INTO #companies(userGroupId, userGroupName)
	SELECT DISTINCT G.id, G.name
	FROM UMGroups G WITH(NOLOCK)
		INNER JOIN UMGroupsProp GP WITH(NOLOCK)
		ON G.id = GP.componentNameId AND GP.modified = 0
		AND (G.name = @i_GroupName OR @i_GroupName = '')
AND GP.attrName IN ('Customer User Group', 'customer subuser groups')
WHERE ((GP.attrName = 'Customer User Group'  AND CAST(attrVal AS BIGINT) > 1)
OR (GP.attrName = 'customer subuser groups' AND CAST(attrVal AS BIGINT) > 0))
	UPDATE C SET C.clientGroupId = GP.attrVal
	FROM #companies C
		INNER JOIN UMGroupsProp GP WITH(NOLOCK)
			ON C.userGroupId  = GP.componentNameId
			AND GP.attrName = 'Company CommCell Group'
			AND GP.modified = 0
	IF LEN(@i_GroupName) > 0
	BEGIN
		SELECT @assocCGId = G.id, @assocCGName = G.name FROM APP_ClientGroup G WITH(NOLOCk) WHERE G.id IN (SELECT C.clientGroupId FROM #companies C)
	END
END
IF (@i_groupType IN (0, 1) OR @assocCGId > 0) --Classic App_ClientGroup based CommCell group or company with associated client group
BEGIN
	INSERT INTO #CommCellGroups(GroupId, GroupName, createdBy)
	SELECT
		g.id, g.name, g.userId
	FROM APP_ClientGroup g WITH (NOLOCK)
	WHERE (g.flag & 0x40000 = 0x40000) --Conside only those commcells with CommCell group flag set CV_FLAG_COMMCELL_GROUP
			AND ((@assocCGId <= 0 AND (g.name = @i_GroupName OR @i_GroupName = '')) OR (g.id = @assocCGId))
	INSERT INTO #CommCellGroupClient(GroupId, ClientGUID)
	SELECT g.GroupId, ISNULL(cc.csGUID, '')
	FROM	#CommCellGroups g
		INNER JOIN APP_ClientGroupAssoc a WITH (NOLOCK)
			ON g.GroupId = a.clientGroupId
		INNER JOIN APP_Client c WITH (NOLOCK)
			ON a.clientId = c.id
		INNER JOIN APP_CommCell cc WITH (NOLOCK)
			ON cc.clientId = c.id
	IF object_id('tempdb.dbo.#CGModfyUser') IS NOT null	DROP TABLE #CGModfyUser
	CREATE TABLE #CGModfyUser  (evMsgId BIGINT,userId INT,GroupName VARCHAR(512))
	INSERT INTO #CGModfyUser (evMsgId ,userId ,GroupName)
	SELECT clientgrpOp.evMsgId,clientgrpOp.userId ,param.data as GroupName FROM
	(SELECT auditparam.evMsgId as evMsgId,msg.userId  FROM EvGuiAuditParameter (NOLOCK) auditparam
		INNER JOIN EvGuiAuditOperation  (NOLOCK) op
		ON op.id = auditparam.opId
		INNER JOIN evMsg   (NOLOCK) msg
		ON msg.id = op.evMsgId
AND  messageId in ((350 | (CAST(POWER(2, 24) AS BIGINT) * 84)),(349 | (CAST(POWER(2, 24) AS BIGINT) * 84)), (179 | (CAST(POWER(2, 24) AS BIGINT) * 84)),(279 | (CAST(POWER(2, 24) AS BIGINT) * 84)))
	) clientgrpOp
	INNER JOIN
		(SELECT max(param.evMsgId)as evMsgId ,param.data as data FROM evParam (NOLOCK) param
			INNER JOIN evMsg(NOLOCK) msg
				ON param.evMsgId = msg.id
AND messageId = ((222 | (CAST(POWER(2, 24) AS BIGINT) * 85)))
				AND ((param.data =  @i_GroupName OR '' =  @i_GroupName) OR  (@assocCGId > 0 AND param.data = @assocCGName))
			group by param.data
		)param
	on clientgrpOp.evMsgId = param.evMsgId
	UNION
	select EE.ID as evMsgId , ee.userID as userId ,sub.groupName from evMsg(NOLOCK) ee
	inner join
	(
	select max(op.evMsgId) groupevMsgId, CG.name  as groupName
	from
		EvGuiAuditOperation  (NOLOCK) op
		INNER JOIN evMsg   (NOLOCK) msg
			ON msg.id = op.evMsgId
			AND  messageId in ((350 | (CAST(POWER(2, 24) AS BIGINT) * 84)),(349 | (CAST(POWER(2, 24) AS BIGINT) * 84)), (179 | (CAST(POWER(2, 24) AS BIGINT) * 84)),(279 | (CAST(POWER(2, 24) AS BIGINT) * 84)))
			and op.EntityType = 28
		INNER JOIN APP_ClientGroup CG ON
			CG.ID = OP.EntityId
			AND ((CG.name  =  @i_GroupName OR '' =  @i_GroupName) OR (@assocCGId > 0 AND CG.name = @assocCGName))
		group by  CG.name
	)sub on
	sub.groupevMsgId = ee.id
	UPDATE gg
	set modifiedBy = prop.longVal
	FROM #CommCellGroups gg
	INNER JOIN APP_ComponentProp prop with (nolock)
		ON componentType=8 --CV_COMPONENT_TYPE_CLIENTGROUP
		AND propertyTypeId=3200
		AND componentId=gg.GroupId
		AND ((@assocCGId <= 0 AND (gg.GroupName = @i_GroupName OR '' = @i_GroupName)) OR  (@assocCGId > 0 AND gg.GroupName = @assocCGName))
		AND modified = 0
	UPDATE gg
	set modifiedBy = lastOp.userId
	FROM #CommCellGroups gg INNER JOIN
		(
		select clientgrpOp.groupName,clientgrpOp.userId
		FROM #CGModfyUser clientgrpOp
		INNER JOIN
			(	SELECT  clientgrpOp.groupName ,max(clientgrpOp.evMsgId) emsgid
			FROM #CGModfyUser clientgrpOp
			GROUP BY clientgrpOp.groupName) lastop
			ON lastop.emsgid = clientgrpOp.evMsgId
		)lastOp
	ON lastOp.groupName = GG.GroupName
	and gg.modifiedBy =0
	UPDATE gg SET isProfileEnabled = 1 FROM #CommCellGroups gg
	INNER JOIN ProfileCustomerInfo c WITH (NOLOCK)
		ON c.ccGroupId = gg.GroupId
		AND c.status = 0
	IF object_id('tempdb.dbo.#CGModfyUser') is not null  DROP TABLE #CGModfyUser
END
IF @i_outputType = 0 AND @i_groupType = 2--return as xml for UMGroups
BEGIN
	SELECT @o_CCGroups =
	(SELECT
		c.userGroupId AS 'company/@userGroupId',
		c.userGroupName AS 'company/@userGroupName',
		c.clientGroupId AS 'commcellGroup/@clientGroupId',
		(SELECT
			grp.id AS '@GroupId',
			REPLACE(grp.name, '''', '') AS '@GroupName',
			REPLACE(grp.description, '''', '') AS '@GroupDescription',
			grp.modified AS '@GroupModified',
			g.modifiedBy AS '@modifiedBy',
			grp.refTime AS '@GroupCreated',
			g.createdBy AS '@createdBy',
			ISNULL((SELECT CASE WHEN name IS NULL OR len(name)<1 THEN login ELSE name END  from UMUsers(nolock) where id  = g.modifiedBy),'') AS '@modifiedByUser',
			ISNULL((SELECT CASE WHEN name IS NULL OR len(name)<1 THEN login ELSE name END  from UMUsers(nolock) where id  = g.createdBy),'') AS '@createdByUser',
			g.isProfileEnabled AS '@isProfileEnabled',
			grp.flag AS '@Flag',
			grp.status AS '@Status',
			(SELECT ClientGUID AS '@ClientGUID' FROM #CommCellGroupClient WHERE GroupId = grp.id FOR XML PATH('Client'), TYPE)
		FROM #CommCellGroups g
			INNER JOIN APP_ClientGroup grp WITH (NOLOCK)
				ON g.GroupId = grp.id
		FOR XML PATH ('UpdatedGroup'), TYPE)
	FROM #companies c
	FOR XML PATH ('companies'), TYPE)
	SELECT ISNULL(@o_CCGroups, '')
END
ELSE IF @i_outputType = 0 AND @i_groupType = 1 --return as xml for App_ClientGroups
	BEGIN
	IF LEN(@i_GroupName) > 0
		SET @o_CCGroups =
		(SELECT
				grp.id AS '@GroupId',
				REPLACE(grp.name, '''', '') AS '@GroupName',
				REPLACE(grp.description, '''', '') AS '@GroupDescription',
				grp.modified AS '@GroupModified',
				g.modifiedBy AS '@modifiedBy',
				grp.refTime AS '@GroupCreated',
				g.createdBy AS '@createdBy',
				ISNULL((SELECT CASE WHEN name IS NULL OR len(name)<1 THEN login ELSE name END  from UMUsers(nolock) where id  = g.modifiedBy),'') AS '@modifiedByUser',
				ISNULL((SELECT CASE WHEN name IS NULL OR len(name)<1 THEN login ELSE name END  from UMUsers(nolock) where id  = g.createdBy),'') AS '@createdByUser',
				g.isProfileEnabled AS '@isProfileEnabled',
				grp.flag AS '@Flag',
				grp.status AS '@Status',
				(SELECT ClientGUID AS '@ClientGUID' FROM #CommCellGroupClient WHERE GroupId = grp.id FOR XML PATH('Client'), TYPE)
		FROM #CommCellGroups g
			INNER JOIN APP_ClientGroup grp WITH (NOLOCK)
				ON g.GroupId = grp.id
		FOR XML PATH ('UpdatedGroup'))
	ELSE
		SET @o_CCGroups =
		(SELECT
				grp.id AS '@GroupId',
				REPLACE(grp.name, '''', '') AS '@GroupName',
				REPLACE(grp.description, '''', '') AS '@GroupDescription',
				grp.modified AS '@GroupModified',
				g.modifiedBy AS '@modifiedBy',
				grp.refTime AS '@GroupCreated',
				g.createdBy AS '@createdBy',
				ISNULL((SELECT CASE WHEN name IS NULL OR len(name)<1 THEN login ELSE name END  from UMUsers(nolock) where id  = g.modifiedBy),'') AS '@modifiedByUser',
				ISNULL((SELECT CASE WHEN name IS NULL OR len(name)<1 THEN login ELSE name END  from UMUsers(nolock) where id  = g.createdBy),'') AS '@createdByUser',
				g.isProfileEnabled AS '@isProfileEnabled',
				grp.flag AS '@Flag',
				grp.status AS '@Status',
				(SELECT ClientGUID AS '@ClientGUID' FROM #CommCellGroupClient WHERE GroupId = grp.id FOR XML PATH('Client'), TYPE)
		FROM #CommCellGroups g
			INNER JOIN APP_ClientGroup grp WITH (NOLOCK)
				ON g.GroupId = grp.id
		FOR XML PATH ('GroupAssociation'))
	SELECT ISNULL(@o_CCGroups, '')
END
ELSE IF @i_outputType = 1 --return as csv
BEGIN
	SELECT
		1 AS 'GroupType',
		grp.id AS 'GroupId',
		REPLACE(grp.name, '''', '') AS 'GroupName',
		REPLACE(grp.description, '''', '') AS 'GroupDescription',
		grp.modified AS 'GroupModified',
		g.modifiedBy AS 'modifiedBy',
		grp.refTime AS 'GroupCreated',
		g.createdBy AS 'createdBy',
		ISNULL((SELECT CASE WHEN name IS NULL OR len(name)<1 THEN login ELSE name END  from UMUsers(nolock) where id  = g.modifiedBy),'') AS 'modifiedByUser',
		ISNULL((SELECT CASE WHEN name IS NULL OR len(name)<1 THEN login ELSE name END  from UMUsers(nolock) where id  = g.createdBy),'') AS 'createdByUser',
		g.isProfileEnabled AS 'isProfileEnabled',
		grp.flag AS 'Flag',
		grp.status AS 'Status',
		c.ClientGUID AS 'ClientGUID',
		-1 AS 'AssocClientGroupId'					--Not Applicable
	FROM #CommCellGroups g
		INNER JOIN APP_ClientGroup grp WITH (NOLOCK)
			ON g.GroupId = grp.id
		LEFT OUTER JOIN #CommCellGroupClient c
			ON c.GroupId = grp.id
	UNION
	SELECT
		2 AS 'GroupType',
		c.userGroupId AS 'GroupId',
		REPLACE(c.userGroupName, '''', '') AS 'GroupName',
		'' AS 'GroupDescription',					--Not Applicable
		0 AS 'GroupModified',						--Not Applicable
		0 AS 'modifiedBy',							--Not Applicable
		0 AS 'GroupCreated',						--Not Applicable
		0 AS 'createdBy',							--Not Applicable
		'' AS 'modifiedByUser',						--Not Applicable
		'' AS 'createdByUser',						--Not Applicable
		0 AS 'isProfileEnabled',					--Not Applicable
		0 AS 'Flag',								--Not Applicable
		0 AS 'Status',								--Not Applicable
		'' AS 'ClientGUID',							--Not Applicable
		c.clientGroupId AS 'AssocClientGroupId'
	FROM #companies c
END
IF object_id('tempdb.dbo.#CommCellGroupClient') is not null  DROP TABLE #CommCellGroupClient
IF object_id('tempdb.dbo.#CommCellGroups') is not null  DROP TABLE #CommCellGroups
IF object_id('tempdb.dbo.#companies') IS NOT NULL DROP TABLE #companies
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCommCellGroupsXML')
	delete from GxQscripts where name = 'RptGetCommCellGroupsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCommCellGroupsXML')
	delete from GXDBVersions where aliasname = 'RptGetCommCellGroupsXML'
GO

insert into GXDBVersions values(2, 'RptGetCommCellGroupsXML',  '00000000000000000000', 'RptGetCommCellGroupsXML', '00000000000000000000')
GO

