

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetClients.sp,v $ $Id: RptGetClients.sp,v 1.40.12.13 2020/07/25 14:15:06 bgeorge Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptGetClients"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetClients')
BEGIN
	print '>>> Drop Stored Procedure: rptGetClients <<<'
	drop procedure rptGetClients
END
IF EXISTS (select * from GxQscripts where name='rptGetClients')
	delete from GxQscripts where name = 'rptGetClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetClients')
	delete from GXDBVersions where aliasname = 'rptGetClients'
GO
print '... Creating Procedure: rptGetClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetClients
  @i_jobId integer
AS
  DECLARE @o_id integer;
  DECLARE @o_name nvarchar(255);
  DECLARE @o_simSystemOSId integer;
  DECLARE @o_netHostName nvarchar(255);
  DECLARE @o_description nvarchar(3072);
  DECLARE @o_cvdPort integer;
  DECLARE @o_evMgrcPort integer;
  DECLARE @o_status integer;
  DECLARE @o_releaseId integer;
  DECLARE @o_OSId integer;
  DECLARE @o_simOSInfo nvarchar(255);
  DECLARE @o_OSName nvarchar(255);
  DECLARE @o_hwId integer;
  DECLARE @o_hwName nvarchar(255);
  DECLARE @o_bkpEnabled integer;
  DECLARE @o_rstEnabled integer;
  DECLARE @o_agingEnabled integer;
  DECLARE @o_lastKnownOnlineTime integer;
  DECLARE @o_priority integer;
  DECLARE @o_deleted integer;
  DECLARE @o_encryption integer;
  DECLARE @o_encKeyLen integer;
  DECLARE @o_restoreAccess integer;
  DECLARE @o_drtoolAccess integer;
  DECLARE @o_rsaPubKey nvarchar(255);
  DECLARE @o_rsaPriKeySF nvarchar(255);
  DECLARE @o_isVirtual integer;
  DECLARE @o_isVSDC integer;
  DECLARE @o_isMiniSRM integer;
  DECLARE @o_QinetixInstallDir varchar(255);
  DECLARE @o_release nvarchar(255);
  DECLARE @o_buildId varchar(255);
  DECLARE @o_userGroups varchar(MAX);
  DECLARE @o_UpdateCache varchar(MAX);
  DECLARE @o_displayname nvarchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @optAppType	integer
DECLARE @tblOptAT	TABLE (t_id int)
DECLARE @optClient	integer
DECLARE @tblOptCl	TABLE (t_id int)
IF object_id('tempdb.dbo.#tblClients') is not null	DROP TABLE #tblClients
CREATE TABLE #tblClients
	 (
	r_id			int,
	r_name			nvarchar(255),
	r_simSystemOSId		int,
	r_net_hostName		nvarchar(255),
r_desc			nvarchar(3072),
	r_cvdPort		int,
	r_evMgrcPort		int,
	r_status		int,
	r_releaseId		int,
	r_OSId			int,
	r_simOSInfo		nvarchar(255),
	r_OSName		varchar(255)	default(''),
	r_hwId			int		default(0),
	r_hwName		varchar(255)	default(''),
	r_updateCache	varchar(255)	default(''),
    r_displayname   nvarchar(255)
)
INSERT INTO @tblOptCl EXEC rptOptGetClients @i_jobId, @optClient OUTPUT
INSERT INTO @tblOptAT EXEC rptOptGetAppTypes @i_jobId, @optAppType OUTPUT
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO #tblClients (r_id, r_name, r_simSystemOSId, r_net_hostName, r_desc, r_cvdPort, r_evMgrcPort, r_status, r_releaseId, r_OSId, r_simOSInfo, r_displayname)
SELECT	id, displayName, simOperatingSystemId, net_hostName, SUBSTRING(clientDescription,0,3072), cvdPort, evmgrcPort, status, releaseId, simOperatingSystemId,
	ISNULL((select attrval from APP_clientProp where componentNameID = APP_Client.id AND attrname = 'Sim OS Info' AND modified = 0), ''),
    displayname
FROM	APP_Client
WHERE	(@optClient = 0 OR id in (select t_id from @tblOptCl)) AND id in (select clientId from APP_Platform where platformType=4)
IF @optAppType > 0
	DELETE	#tblClients
	FROM	#tblClients A LEFT OUTER JOIN (SELECT DISTINCT clientId FROM APP_Application WHERE appTypeId IN (select t_id from @tblOptAT)) B
		ON	A.r_id = B.clientId
	WHERE	B.clientId IS NULL
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @optClient <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2013, 0, '#rptUserObjects'  --SUB_CLIENT_ITEM
IF NOT EXISTS(SELECT * FROM #rptUserObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
delete from #tblClients
			where r_id not in (select clientId from #rptUserObjects  u where clientId > 0)
	DROP TABLE #rptUserObjects
END
--get list of user UMGroups that have permissions
DECLARE @clId 			integer
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
CREATE TABLE #tempUserGroupList(clId integer, groupList text)
IF (dbo.isNewSecurity() = 0)
BEGIN
DECLARE clientUserGroupList CURSOR FOR SELECT DISTINCT r_Id FROM #tblClients
OPEN clientUserGroupList
FETCH NEXT FROM clientUserGroupList INTO @clId
WHILE @@FETCH_STATUS = 0
BEGIN
	declare @ugList nvarchar(1000);
	create table #temp_ug (userGroupId int,
				  userGroupName nvarchar(MAX))
	INSERT INTO #temp_ug
		SELECT UG.id,UG.name
		FROM UMGroupAssociation UGA,UMGroups UG
		where UGA.groupId = UG.id and
UGA.type1 = 2009 and UGA.id1 = @clId
	IF NOT EXISTS(select userGroupName from #temp_ug where #temp_ug.userGroupId=dbo.GetMasterGroupID() or userGroupName ='View All')
	BEGIN
	INSERT INTO #temp_ug
	SELECT distinct UG.id,UG.name
	FROM UMGroups UG
	where id=dbo.GetMasterGroupID() or name = 'View All'
	END
	SET @ugList = substring((select distinct  ','+ userGroupName
					FROM #temp_ug
					FOR XML PATH('')),2,1000);
	drop table #temp_ug
	INSERT INTO #tempUserGroupList values(@clId, @ugList);
	FETCH NEXT FROM clientUserGroupList INTO @clId
END
CLOSE clientUserGroupList
DEALLOCATE clientUserGroupList
END
ELSE
BEGIN
DECLARE @entityType1 INT = 3
	DECLARE @i_entityList XML
	SET @i_entityList = (SELECT
3 as '@entityType1',
	r_Id  as '@entityId1'
	FROM #tblClients
	for xml path('entity'),root('entityList') )
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
        DROP TABLE #tgroupObjects
--	THIS WILL GIVE ALL USERGROUP ASSOCIATED WITH THESE CLIENT WITHOUT USER SECURITY CHECK (USER ID IS NOT PASSED)
CREATE TABLE #tgroupObjects ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,3, @i_entityList,0,0,0,0
	-- USER SECURITY CHECK FOR THIS USER
	IF object_id('tempdb.dbo.#entityTable') is not null
		drop table #entityTable
	create table #entityTable
	(
		entityId int
	)
	 exec sec_getUserGroupsForThisUser '#entityTable', @userID
	IF object_id('tempdb.dbo.#clientgroups') is not null
		drop table #clientgroups
	CREATE table #clientgroups (name nvarchar(max),clientId INT )
	INSERT INTO #clientgroups
		select distinct UG.name,t.entityId1
	FROM	UMGroups UG INNER JOIN #tgroupObjects t ON
	UG.id = t.userORGroupId and t.isUSer = 0
	INNER JOIN #entityTable E ON
	UG.id = E.entityId
	drop table #entityTable
	INSERT INTO #tempUserGroupList
	Select distinct cg2.clientId,
    substring(
        (
            Select ','+cg1.name  AS [text()]
            From #clientgroups cg1
            Where cg1.clientId = cg2.clientId
            ORDER BY cg1.clientId
            For XML PATH ('')
        ), 2, 1000) [groups]
	From #clientgroups cg2
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
    DROP TABLE #tgroupObjects
	IF object_id('tempdb.dbo.#clientgroups') is not null
		drop table #clientgroups
END
update #tblClients set r_OSNAME	=dbo.GetClientOSName(r_id, r_simOSInfo)
update #tblClients set r_HwName	=dbo.GetClientHardwareName(r_id, r_simOSInfo)
UPDATE	#tblClients
SET		r_OSName = S.Name
FROM	#tblClients, simOperatingSystem S
WHERE	r_OSName = '' AND r_OSId = S.id
UPDATE	#tblClients
SET		r_hwName = S.PlatformType
FROM	#tblClients, simOperatingSystem S
WHERE	r_hwName = '' AND r_OSId = S.id
--get updateCache
UPDATE #tblClients
SET r_updateCache = ISNULL((SELECT c.displayName FROM app_client C, app_clientprop CP, PatchUpdateAgentInfo UA
							WHERE	componentNameId = r_id AND C.id = UA.clientId and cast(UA.id as varchar(64)) = attrVal AND UA.isEnabled =1 AND UA.isDeleted = 0 AND
									attrname like 'UPDATE CACHE AGENT ID' AND cp.modified = 0), '')
UPDATE #tblClients
SET r_updateCache = ISNULL((SELECT TOP 1 displayName FROM APP_Client C, APP_ComponentProp CP, PatchUpdateAgentInfo UA
WHERE	C.id = UA.clientId AND UA.id = longVal AND propertyTypeId = 1300 AND longval > 0 AND UA.isEnabled =1 AND UA.isDeleted = 0 AND
									componentId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = r_id)), '')
WHERE r_updateCache = ''
UPDATE #tblClients
SET r_updateCache = 'Commserve'
WHERE r_updateCache = ''
DECLARE @value nvarchar(max) = NULL
SET @value = (SELECT TOP 1 value FROM UMUserPrefs (NOLOCK) WHERE userid = @userId)
DECLARE @userPrefs XML
  IF (CHARINDEX( '<?xml version=''1.0'' encoding=''UTF-8''?>',@value,1)) <> 0
  BEGIN
    SET @userPrefs  =(SELECT CONVERT(XML,SUBSTRING(@value,LEN('<?xml version=''1.0'' encoding=''UTF-8''?>')+1,LEN(@value)),2))
  END
  IF (CHARINDEX( '<?xml version="1.0" ?>',@value,1)) <> 0
  BEGIN
    SET @userPrefs  =(SELECT CONVERT(XML,SUBSTRING(@value,LEN('<?xml version="1.0" ?>')+1,LEN(@value)),2))
  END
DECLARE @isVSDC INT = (select @userPrefs.value('./userprefs_UserPreferences[1]/@showVirtualServerDiscoveredClients','int') )
IF ( @isVSDC = 0 )
BEGIN
	DELETE #tblClients FROM #tblClients tmp
		INNER JOIN APP_ClientProp clProp WITH(NOLOCK)
			ON tmp.r_id = clProp.componentNameId
			and clProp.attrName = 'Virtual Server Discovered Clients'
			and clProp.modified =0
			AND clProp.attrVal = '1'
		LEFT OUTER JOIN simInstalledPackages S
			ON S.ClientId = tmp.r_id
		LEFT OUTER JOIN (SELECT Ida.clientId FROM app_idaprop IdaProp INNER JOIN APP_IDAName Ida ON IdaProp.componentNameId = Ida.id where IdaProp.attrName = 'Pseudo Apptype' AND IdaProp.attrVal = '1' and IdaProp.modified = 0) IDA
			ON IDA.clientId = tmp.r_id
		WHERE S.ClientId IS NULL AND IDA.clientId IS NULL
END
SELECT	r_id, r_name, r_simSystemOSId, r_net_hostName, r_desc, r_cvdPort, r_evMgrcPort,	r_status, r_releaseId, r_OSId, r_simOSInfo, r_OSName, r_hwId, r_hwName,
	bkpEnabled	=ISNULL((select action from JMJobAction where clientId=r_id AND appType=0 AND mediaAgentId=1 AND opType=4), 0),
	rstEnabled	=ISNULL((select action from JMJobAction where clientId=r_id AND appType=0 AND mediaAgentId=1 AND opType=5), 0),
	agingEnabled=ISNULL((select action from JMJobAction where clientId=r_id AND appType=0 AND mediaAgentId=1 AND opType=10), 2),
	lastKnownOnlineTime =ISNULL((SELECT MAX(LastOnlineTime) from CCRClientToClient ccr where ccr.FromClientID = (SELECT distinct ClientID From APP_CommCell WHERE id = 2) and ccr.ToClientID =r_id), 0),
	priority	=ISNULL((select attrVal from APP_ClientProp where componentNameId=r_id and attrName='JMPriority' and modified =0), 6),
	deleted		=ISNULL((select CAST(attrVal AS integer) from APP_ClientProp where componentNameId=r_id and attrName='platformdeleted 4' and modified =0), 0),
	encryption	=ISNULL((select CAST(attrVal AS integer) from APP_ClientProp where componentNameId=r_id and attrName='Encrypt: type' and modified =0 and componentNameId in(select componentNameId from APP_ClientProp where attrName ='Encrypt: encryption' and attrVal ='1' and modified =0)), 0),
	encKeyLen	=ISNULL((select CAST(attrVal AS integer) from APP_ClientProp where componentNameId=r_id and attrName='Encrypt: Key Length' and modified =0), 128),
	restoreAccess	=ISNULL((select CAST(attrVal AS integer) from APP_ClientProp where componentNameId=r_id and attrName='Encrypt: restoreAccess' and modified =0), -1),
	drtoolAccess	=ISNULL((select CAST(attrVal AS integer) from APP_ClientProp where componentNameId=r_id and attrName='Encrypt: drToolAccess' and modified =0), -1),
	rsaPubKey      = ISNULL((select attrVal from APP_ClientProp where componentNameId=r_id and attrName='Encrypt: rsaPubKey' and modified =0), N''),
	rsaPriKeySF    = ISNULL((select attrVal from APP_ClientProp where componentNameId=r_id and attrName='Encrypt: rsaPriKeySF' and modified =0), N''),
	isVirtual	=ISNULL((select CAST(attrVal AS integer) from APP_ClientProp where componentNameId=r_id and attrName='Virtual Client' and modified =0),0),
	isVSDC		=ISNULL((select CAST(attrVal AS integer) from APP_ClientProp where componentNameId=r_id and attrName='Virtual Server Discovered Clients' and modified =0),0),
	isMiniSRM   =ISNULL((select TOP 1 CAST(attrVal AS integer) from APP_ClientProp where componentNameId=r_id and attrName='Mini SRM Agent' and modified =0 Order by created desc),0),
	QinetixInstDir	=ISNULL((select install_dir from APP_Platform where clientId = r_id and platformType = 4), ''),
	-- Get the Version of Foreign Client else Get the Version from Galaxy License tables
	release		=CASE WHEN EXISTS (select * from APP_CommCell where type = 100  and id = (select origCCId from APP_Client where id = r_id))
					  THEN ISNULL((select attrVal from APP_ClientProp where componentNameId = r_id and attrName = 'Foreign Client Version' and modified =0), '')
					  ELSE ISNULL((select release FROM simAllGalaxyRel where id=r_releaseId), '') END,
	buildId		=ISNULL((select max(Build) from LicUsage where CId=r_id AND releaseId=r_releaseId), ''),
	userGroup	=ISNULL((select groupList from #tempUserGroupList where clId=r_id), ''),
	r_updateCache,
    r_displayname
FROM	#tblClients
ORDER BY r_name
IF object_id('tempdb.dbo.#tblClients') is not null	DROP TABLE #tblClients
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'RptGetClients')
	delete from GxQscripts where name = 'RptGetClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetClients')
	delete from GXDBVersions where aliasname = 'RptGetClients'
GO

insert into GXDBVersions values(2, 'RptGetClients',  '00010040001200130000', 'RptGetClients', '00010040001200130000')
GO

