

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetClientListByLat.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetClientListByLat.sp,v $ $Id: rptGetClientListByLat.sp,v 1.36.36.7 2018/12/28 21:34:31 vikashkumar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "rptGetClientListByLat"			|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetClientListByLat')
BEGIN
	print '>>> Drop Stored Procedure: rptGetClientListByLat <<<'
	drop procedure rptGetClientListByLat
END
IF EXISTS (select * from GxQscripts where name='rptGetClientListByLat')
	delete from GxQscripts where name = 'rptGetClientListByLat'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetClientListByLat')
	delete from GXDBVersions where aliasname = 'rptGetClientListByLat'
GO
print '... Creating Procedure: rptGetClientListByLat'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetClientListByLat
  @i_licAppType integer,
  @i_bConsultAppMgrTbl integer
AS
  DECLARE @o_clientName nchar(255)
  DECLARE @o_clientId integer;
  DECLARE @o_installTime integer;
  DECLARE @o_expireTime integer;
  DECLARE @o_evalNo integer;
  DECLARE @o_permNo integer;
  DECLARE @o_appNo integer;
  DECLARE @o_appType integer;
  DECLARE @o_appTypeName char(255);
  DECLARE @o_clientDisplayName nchar(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	SELECT	m_name=CL.name, m_Id=cId, m_appType=appType, maxInst=Max(opTimeUTC), m_instTime=0, m_expTime=0, m_eval=0, m_appNum=0,
        m_relId=Max(LU.releaseId), m_installed=0, m_uninstalled=0, m_displayname=CL.displayname
	INTO	#temp
	FROM	licUsage LU
    INNER JOIN APP_CLIENT CL (NOLOCK) ON cId = CL.id
	WHERE	licType = @i_licAppType AND opType = 'Install' AND installFlag = 0
    GROUP BY CL.name, CL.displayname, CId, appType
	UPDATE	#temp
	SET	m_instTime = datediff(second, '01/01/1970', maxInst),
		m_expTime = (case eval when 1 then datediff(second, '01/01/1970', expiryDateUTC) else 0 end),
		m_eval = eval
	FROM	licUsage
	WHERE	licType = @i_licAppType AND m_id = cid AND m_appType = appType
	UPDATE	#temp
	SET	m_appNum = t_appNum
	FROM	(select t_id=m_id, t_appNum=count(DISTINCT m_appType) from #temp GROUP BY m_Id) AS T
	WHERE	t_id=m_Id
DECLARE	@bIsSRM	INT
IF EXISTS (select * from #temp where m_appType >= 600 AND m_appType <= 654)
	SET @bIsSRM = 1
ELSE
	SET @bIsSRM = 0
-- drop the MA which is already uninstalled: 84 = SIM_CSL_AT_V2_MAGNETIC_LIBRARY
	IF @i_licAppType = 84
BEGIN
	DECLARE	@MAs	TABLE (id INT)
	INSERT INTO @MAs
	EXEC MMGetMAsUsingDDOLicense
	DELETE	#temp
	FROM	@MAs
	WHERE	m_id not in (select id from @MAs)
END
-- drop the libraries which is already uninstalled: SIM_CSL_AT_V2_LCP, SIM_CSL_AT_V2_SHARELCP
	ELSE IF @i_licAppType = 10 OR @i_licAppType = 26
	DELETE	#temp
	FROM	#temp
	WHERE	NOT EXISTS (select * from MMLibrary where libraryId = m_Id)
ELSE IF @i_licAppType = 71
	DELETE	#temp
	WHERE m_Id NOT IN (	select DP.DrivePoolId from MMDrivePool DP(READUNCOMMITTED), MMMountPath MP(READUNCOMMITTED)
				where MP.MountPathTypeId = 1 and MP.LibraryId > 0 and MP.MasterPoolId > 0 and MP.MasterPoolId = DP.MasterPoolId)
ELSE IF @i_bConsultAppMgrTbl > 0
BEGIN
-- drop the client/agent which is already uninstalled: SIM_CSL_AT_V2_SHAREPOINTV2_DB --> appType = CV_APPTYPE_MS_SHAREPOINTV2_DOC
	IF @i_licAppType = 92
BEGIN
	UPDATE #temp SET m_installed =
 (	SELECT	count(*)
	FROM	APP_Application
	WHERE	m_Id = clientId and (m_relId < 13 and appTypeId = m_appType OR m_relId >= 13 and appTypeId = 78)
 )
	UPDATE #temp SET m_uninstalled =
 (	SELECT	count(*)
	FROM	APP_Application
	WHERE	m_Id = clientId and (m_relId < 13 and appTypeId = m_appType OR m_relId >= 13 and appTypeId = 78) AND (subClientStatus&2) > 0
 )
	DELETE	#temp
	FROM	#temp
	WHERE	m_AppType < 1000 AND (m_installed = 0 OR m_installed <= m_uninstalled)
END
-- appType change in 8.0:
--	SIM_CSL_AT_V2_MS_WINFS_DATA_MIGRATOR(63)--> appType = CV_APPTYPE_MS_FILE_ARCHIVER(58):	instance type: APP_FSDM_LOCAL_MIGRATION (1)
--	SIM_CSL_AT_V2_NTAP_DATA_MIGRATOR(95) 	--> appType = LEGACY_CV_APPTYPE_FILE_SHARE_ARCHIVER(73):	instance Type: APP_FSDM_NETWORK_SHARE (3)
--	SIM_CSL_AT_V2_NTAP_DATA_MIGRATOR(95) 	--> appType = CV_APPTYPE_PROXY_FILESHARE_ARCHIVER(1081):instance Type: APP_FSDM_CELERRA (2)
	ELSE IF @i_licAppType = 95
BEGIN
	DECLARE @FSDMTbl	TABLE(t_licType int, t_appType int, t_instanceType int)
	INSERT INTO @FSDMTbl SELECT 63, 58, 1
	INSERT INTO @FSDMTbl SELECT 95, 73, 3
	INSERT INTO @FSDMTbl SELECT 95, 1081, 2
	UPDATE	#temp SET m_installed =
 (	SELECT	count(*)
	FROM	APP_Application A, @FSDMTbl T
	WHERE	m_Id = clientId and (m_relId < 13 and appTypeId = m_appType OR m_relId >= 13 and appTypeId = 58 AND m_appType = T.t_appType and instance in
		(	select componentNameId from APP_instanceProp where attrName = 'FSDM instance type' and attrVal = cast(t_instanceType as nvarchar(10)) and modified = 0)) and
		(subClientStatus&2) = 0
 )
	-- remove the ones with instance marked deleted
	UPDATE	#temp SET m_uninstalled =
 (	SELECT	count(*)
	FROM	APP_Application, @FSDMTbl T
	WHERE	m_Id = clientId and m_relId >= 13 and appTypeId = 58 and m_appType = T.t_appType AND
			(	instance in (select componentNameId from APP_instanceProp where attrName = 'FSDM instance type' and attrVal = cast(t_instanceType as nvarchar(10)) and modified = 0)
				AND
				instance in (select id from APP_instanceName where (status&2) > 0)
			)
 )
	DELETE	#temp
	FROM	#temp
	WHERE	m_installed = 0 OR m_installed <= m_uninstalled
END
-- SRM license support
	ELSE IF @bIsSRM > 0
	DELETE	#temp
	FROM	#temp
	WHERE	(NOT EXISTS (	select * from APP_iDAName where clientId = m_Id AND appTypeId = m_AppType)
			AND
		 NOT EXISTS (	select * from APP_ClientProp JOIN APP_iDAType ON attrName = name and type = m_AppType
				where componentNameId = m_Id AND attrVal = '1' AND modified = 0))
		OR
			EXISTS (select * from APP_iDAName where clientId = m_Id AND appTypeId = m_AppType AND (Status&2)>0)
-- drop the client/agent which is already uninstalled
	ELSE
	DELETE	#temp
	FROM	#temp
	WHERE	m_AppType < 1000 AND (NOT EXISTS (select * from APP_iDAName where clientId = m_Id AND appTypeId = m_AppType) OR
			 EXISTS (select * from APP_iDAName where clientId = m_Id AND appTypeId = m_AppType AND (Status&2)>0))
	-- some agents don't have subclients created at install time so use APP_iDAName table
	--	(select count(*) from APP_Application where clientId = m_Id AND appTypeId = m_AppType) = 0 OR
	--	(select count(*) from APP_Application where clientid = m_Id AND appTypeId = m_AppType) <=
	--	(select count(*) from APP_Application where clientid = m_Id AND appTypeId = m_AppType AND (subClientStatus&2) > 0)
	--									)
-- clean dangling rows from LicUsage table
	DELETE	licUsage
	WHERE	licType = @i_licAppType AND OpType = 'Install' AND cid not in (select m_id from #temp where m_appType = appType) AND installFlag = 0
END
DECLARE @isACVCheckValid INT = 0
DECLARE @licInheritedType INT = 0
DECLARe @bIsLicInherited INT = 0
SELECT @licInheritedType = CAST(attrVal AS INT) FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = 'InheritedLicType'--SZ_INHERITED_LI_TYPE
IF @licInheritedType = 1 OR @licInheritedType = (2|1)
	SET @bIsLicInherited = 1
IF @bIsLicInherited = 1
BEGIN
		IF EXISTS(select * FROM RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND globalLimitGB > 0 AND quotaType in (100027,100032,100033)) AND
		EXISTS(select * from RptClientGroupQuotaUsage WITH (NOLOCK) WHERE clientGroupId = 0 AND globalLimitGB > 0 AND quotaType IN (100002, 100004, 100005, 100006, 100018, 100019))
			SELECT @isACVCheckValid = 1
END
ELSE
BEGIN
	IF EXISTS(select simLicAppTypeId from licAAL WITH (NOLOCK) WHERE simLicAppTypeId in (100027,100032,100033)) AND
	EXISTS(select simLicAppTypeId from licAAL WITH (NOLOCK) WHERE simLicAppTypeId IN (100002, 100004, 100005, 100006, 100018, 100019))
		SELECT @isACVCheckValid = 1
END
IF @isACVCheckValid = 1
BEGIN
	IF object_id('tempdb.dbo.#tempVMsWithIdAppType') IS NOT null DROP TABLE #tempVMsWithIdAppType
	CREATE TABLE #tempVMsWithIdAppType(t_Id INT, t_appTypeId INT)
	EXEC LicGetVMAppcalss1 '#tempVMsWithIdAppType'
	DELETE #temp FROM #tempVMsWithIdAppType WHERE m_Id = t_Id AND m_appType = t_appTypeId
	DROP TABLE #tempVMsWithIdAppType
END
--	IF @i_licAppType = SIM_CSL_AT_V2_MSSQL
	IF @i_licAppType = 9
		SELECT	DISTINCT m_name, m_Id, MAX(m_instTime), MAX(m_expTime),
			evalNo = (select count(DISTINCT m_Id) from #temp where m_eval = 1),
			permNo = (select count(DISTINCT m_Id) from #temp where m_eval = 0),
            0, 0, '', m_displayname
		FROM	#temp
		GROUP BY m_name, m_Id
		ORDER BY m_name
	ELSE
		SELECT	(case when @i_licAppType not in (71, 10, 26) then (select name from APP_Client where id=m_id) else m_name end),
 			m_Id, m_instTime, m_expTime,
			evalNo = (select count(*) from #temp where m_eval = 1),
			permNo = (select count(*) from #temp where m_eval = 0),
			m_appNum, m_appType,
			(case when m_appType>0 then (select name from APP_iDAType where type=m_appType) else '' END),
            (case when @i_licAppType not in (71, 10, 26) then (select displayname from APP_Client where id=m_id) else m_displayname end)
		FROM	#temp
		ORDER BY m_eval, m_name, m_appType
	DROP TABLE #temp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetClientListByLat')
	delete from GxQscripts where name = 'RptGetClientListByLat'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetClientListByLat')
	delete from GXDBVersions where aliasname = 'RptGetClientListByLat'
GO

insert into GXDBVersions values(2, 'RptGetClientListByLat',  '00010036003600070000', 'RptGetClientListByLat', '00010036003600070000')
GO

