

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetCapabilitiesByUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetCapabilitiesByUser.sp,v $ $Id: RptGetCapabilitiesByUser.sp,v 1.4.2.5 2018/03/20 00:36:28 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "RptGetCapabilitiesByUser"	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetCapabilitiesByUser <<<'

IF EXISTS (select * from sysobjects where name='RptGetCapabilitiesByUser')
	drop procedure RptGetCapabilitiesByUser
IF EXISTS (select * from GxQscripts where name='RptGetCapabilitiesByUser')
	delete from GxQscripts where name = 'RptGetCapabilitiesByUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCapabilitiesByUser')
	delete from GXDBVersions where aliasname = 'RptGetCapabilitiesByUser'
GO
print '... Creating Procedure: RptGetCapabilitiesByUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetCapabilitiesByUser
  @i_jobId integer
AS
  DECLARE @userName varchar(max)
  DECLARE @userGroups varchar(max)
  DECLARE @_entityTypeName varchar(max)
  DECLARE @entityName varchar(max)
  DECLARE @roleName varchar(max)
  DECLARE @permissionsNames varchar(max)
BEGIN
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @i_userId		integer
SET @i_userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
IF	EXISTS (SELECT id FROM APP_Client WHERE id = 2 AND releaseId = 16)
BEGIN
IF object_id('tempdb.dbo.#tuserentityInfo') is not null	DROP TABLE #tuserentityInfo
IF object_id('tempdb.dbo.#tempUserList') IS NOT null DROP TABLE #tempUserList
IF object_id('tempdb.dbo.#rolePermissionsMap') IS NOT null DROP TABLE #rolePermissionsMap
IF object_id('tempdb.dbo.#allRoles') IS NOT null DROP TABLE #allRoles
IF object_id('tempdb.dbo.#userGroupMap') IS NOT null DROP TABLE #userGroupMap
IF object_id('tempdb.dbo.#rollUpPermissionsInSameRole') IS NOT null DROP TABLE #rollUpPermissionsInSameRole
IF object_id('tempdb.dbo.#entityTable') is not null
	drop table #entityTable
create table #entityTable
(
	entityId int
)
	exec sec_getUsersForThisUser '#entityTable', @i_userId
SELECT	* INTO #tempUserList
FROM	UMUsers U
INNER JOIN #entityTable E ON
	U.id = E.entityId
WHERE	U.login NOT LIKE '%(Deleted,%)' AND ((U.flags & (0x384)) = 0) AND enabled=1 --discarding all the users who are hidden, disabled, MMC SSO and common SSO
CREATE TABLE #allRoles (roleID INT)
INSERT INTO #allRoles
    SELECT roleId
    FROM UMRolesPermissions RP
    WHERE
       RP.hierarchyLevel = 123
    EXCEPT
    SELECT roleId
    FROM UMRolesPermissions RP
    WHERE
       RP.excludeCategory = 1 OR RP.excludePermission = 1
	drop table #entityTable
CREATE TABLE #tuserentityInfo (
	userOrGroupId INT,
    isUser INT,
	isVisibleUser INT,
    roleId INT,
	permissionId INT,
	permissionName varchar(MAX),
	messageId INT,
    includeAll INT,
    entityType1 INT,
    entityID1 INT,
    entityType2 INT,
    entityID2 INT,
    entityType3 INT,
    entityID3 INT,
    entityType4 INT,
    entityID4 INT,
    entityType5 INT,
    entityID5 INT,
    AssocKind varchar(MAX),
    AssocName varchar(MAX))
-- type1 is a client, type2 is an apptype, type3 is an instance, type4 is a backup set, type5 is a subclient
-- if type1 is not a client, type2, type3, type4 and type5 will be zero
INSERT INTO #tuserentityInfo (userOrGroupId, isUser, roleId, permissionId, permissionName, messageId, includeAll, entityType1, entityID1, entityType2, entityID2, entityType3, entityID3, entityType4, entityID4, entityType5, entityID5)
SELECT DISTINCT userOrGroupId, UMSecurityAssociations.isUser, UMSecurityAssociations.roleId, 0, 'All Permissions', 0, includeAll, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5
     FROM UMSecurityAssociations
     --INNER JOIN #tempUserList ON UMSecurityAssociations.isUser = 1 AND UMSecurityAssociations.userOrGroupId = id
     INNER JOIN #allRoles AllRoles ON AllRoles.roleID = UMSecurityAssociations.roleID
     WHERE UMSecurityAssociations.permissionId = 0  AND UMSecurityAssociations.isCreator=0
UNION
     SELECT DISTINCT userOrGroupId, UMSecurityAssociations.isUser, roleId, 0, '', 0, includeAll, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5
     FROM UMSecurityAssociations
     --INNER JOIN #tempUserList ON UMSecurityAssociations.isUser = 1 AND UMSecurityAssociations.userOrGroupId = id
     WHERE UMSecurityAssociations.permissionId = 0 AND UMSecurityAssociations.roleId NOT IN (SELECT * FROM #allRoles) AND UMSecurityAssociations.isCreator=0 -- isUser=1 AND
UNION
     SELECT DISTINCT userOrGroupId, UMSecurityAssociations.isUser, roleId, UMPermissions.id, UMPermissions.permissionName, UMPermissions.messageId, includeAll, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5
     FROM UMSecurityAssociations
     --INNER JOIN #tempUserList ON UMSecurityAssociations.isUser = 1 AND UMSecurityAssociations.userOrGroupId = id
     INNER JOIN UMPermissions ON UMPermissions.id = UMSecurityAssociations.permissionID
     WHERE UMSecurityAssociations.permissionId <> 0  AND UMSecurityAssociations.isCreator=0
-- fill AssocKind and AssocName in #tuserentityInfo table
DECLARE @entityType INTEGER
DECLARE @tableName	NVARCHAR(512)
DECLARE @idColName	NVARCHAR(512)
DECLARE @entityNameColName	NVARCHAR(512)
DECLARE @entityNameinXML	NVARCHAR(512)
DECLARE @whereClause	NVARCHAR(512)
DECLARE @entityTypeName	NVARCHAR(512)
DECLARE @AssocKind	NVARCHAR(512)
DECLARE @entityTypeNameMessageId	bigint
DECLARE Dynamic_Entity_Map_Update CURSOR FOR
SELECT DISTINCT entityType, tableName, idColName, entityNameColName, entityNameinXML, whereClause, entityTypeName, entityTypeNameMessageId
  FROM app_entity
  INNER JOIN #tuserentityInfo ON app_entity.entityType=entityType1
  AND app_entity.entityNameColName  is not null AND app_entity.entityNameColName <>''
OPEN Dynamic_Entity_Map_Update;
FETCH NEXT FROM Dynamic_Entity_Map_Update into @entityType, @tableName, @idColName, @entityNameColName, @entityNameinXML, @whereClause, @entityTypeName, @entityTypeNameMessageId
WHILE @@FETCH_STATUS = 0
   BEGIN
	  -- set AssocKind, regardless of entityId (because entityId may be zero if includeAll is 1)
	  -- update #tuserentityInfo set AssocKind='CommCell',AssocName='All Entities' where entityType=1
	  set @AssocKind= ISNULL((select message from evlocalemsgs where localeid = 0 and messageid=@entityTypeNameMessageId),@entityTypeName)
	  DECLARE @SQLString nvarchar(500);
	  DECLARE @retValue INT
	  declare @errCode        integer
	  SET @SQLString =
		N'update #tuserentityInfo set AssocKind=''' + @AssocKind + N''' where entityType1='+CAST(@entityType AS varchar)
	   --print @SQLString
	   EXEC @retValue=sp_executesql @SQLString
	   set @errCode = @@ERROR
	   if @errCode <> 0 OR @retValue <> 0
		  BREAK;
	  -- set AssocName
   	  -- update #tuserentityInfo set AssocKind='CommCell',AssocName=AC.aliasName from APP_CommCell AC where itemType=1 AND AC.id=itemId
	  SET @SQLString =
		N'update #tuserentityInfo set AssocKind=''' + @AssocKind + N''',AssocName='+ @tableName + N'.' + @entityNameColName +
	    N' from '+ @tableName + N' where entityType1='+CAST(@entityType AS varchar)+N' AND ' + @tableName + N'.' + @idColName + N'=entityId1'
	   --print @SQLString
	   EXEC @retValue=sp_executesql @SQLString
	   set @errCode = @@ERROR
	   if @errCode <> 0 OR @retValue <> 0
		  BREAK;
	FETCH NEXT FROM Dynamic_Entity_Map_Update into @entityType, @tableName, @idColName, @entityNameColName, @entityNameinXML, @whereClause, @entityTypeName, @entityTypeNameMessageId
   END;
CLOSE Dynamic_Entity_Map_Update;
DEALLOCATE Dynamic_Entity_Map_Update;
update #tuserentityInfo set AssocName='' where entityType1>0 and entityId1>0 and includeAll=0 and AssocName IS NULL
update #tuserentityInfo set AssocName='All Entities' where entityType1>0  and includeAll=1
-- set AssocKind and AssocName for itemId>1 columns (includeAll does not apply to these columns)
    update #tuserentityInfo set AssocKind+=' > iDataAgent',AssocName+=' > '+APP_IDAType.name from APP_IDAType where entityType2=4 AND APP_IDAType.type=entityId2
    update #tuserentityInfo set AssocKind+=' > Instance',AssocName+=' > '+APP_InstanceName.name from APP_InstanceName where entityType3=5 AND APP_InstanceName.id=entityId3 AND APP_InstanceName.id!=1
    update #tuserentityInfo set AssocKind+=' > BackupSet',AssocName+=' > '+APP_BackupSetName.name from APP_BackupSetName where entityType4=6 AND APP_BackupSetName.id=entityId4
    update #tuserentityInfo set AssocKind+=' > Subclient',AssocName+=' > '+APP_Application.subclientname from APP_Application where entityType5=7 AND APP_Application.id=entityId5
-- role is a collection of permissions
-- get permissions for every role
	SELECT	distinct UMR2.id, UMR2.name as 'roleName',
	substring(
			(select ',' + UMP.permissionName AS [text()]
			 from UMPermissions UMP, UMRoles umr1, UMRolesWithPermissionsExpanded UMRPE
			 where umr1.id=UMRPE.roleId AND UMRPE.permissionId=UMP.id and umr1.id=umr2.id
			 ORDER BY umr1.id
			 FOR XML PATH('')
			), 2, 10000) [allPermissionsForRole]
	INTO #rolePermissionsMap
	FROM UMRoles umr2
-- for roles that have all permissions, display All Permissions
update #rolePermissionsMap set allPermissionsForRole='All Permissions' from #allRoles where #allRoles.roleID=#rolePermissionsMap.id
-- get groups for every user
	SELECT	distinct u2.id,
	substring(
			(select ',' + G.name AS [text()]
			 from UMGroups G, UMUsers u1, UMUserGroup UG
			 where u1.id=UG.userId AND UG.groupId=G.id and u1.id=u2.id
			 ORDER BY u1.id
			 FOR XML PATH('')
			), 2, 10000) [allGroupsForUser]
	INTO #userGroupMap
	FROM UMUsers u2
-- user select
	SELECT DISTINCT
        U.login as 'User Name',
        ISNULL(UGM.allGroupsForUser,'No Groups') as 'User Groups',
		ISNULL(entityInfo.AssocKind,'No Entity Type') as 'Entity Type',
		ISNULL(entityInfo.AssocName,'No Entity') as 'Entity Name',
        CASE WHEN RPM.roleName IS NULL OR RPM.Id=0 THEN 'No Role' ELSE RPM.roleName END as 'Role Name',
		-- a user is not necessarily associated with a role, may be associated with a permission only
		ISNULL(RPM.allPermissionsForRole,ISNULL(entityInfo.permissionName,'No Permissions')) 'Permissions Names'
	INTO #rollUpPermissionsInSameRole
	FROM #tempUserList U
		 LEFT OUTER JOIN #tuserentityInfo entityInfo ON U.id = entityInfo.userOrGroupId AND entityInfo.isUser=1
		 LEFT OUTER JOIN #rolePermissionsMap RPM on entityInfo.roleId=RPM.id
		 LEFT OUTER JOIN #userGroupMap UGM on U.id = UGM.id
    ORDER BY U.login, [Entity Type]
	CREATE TABLE #ServiceUserAccount (AgentName nvarchar(max),Account nvarchar(max),Description nvarchar(max))
	BEGIN TRY
	INSERT INTO #ServiceUserAccount
	exec RptGetServiceAccountsUsers
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    END CATCH
-- roll up permissions
	SELECT	DISTINCT U.[User Name],U.[User Groups],U.[Entity Type],U.[Entity Name],U.[Role Name],
	substring(
			(select ',' + U2.[Permissions Names] AS [text()]
			 from #rollUpPermissionsInSameRole U2
			 WHERE U.[User Name]=U2.[User Name] AND
				   U.[User Groups]=U2.[User Groups] AND
			       U.[Entity Type]=U2.[Entity Type] AND
				   U.[Entity Name]=U2.[Entity Name] AND
				   U.[Role Name]=U2.[Role Name]
			 ORDER BY U2.[User Name],U2.[User Groups],U2.[Entity Type],U2.[Entity Name],U2.[Role Name]
			 FOR XML PATH('')
			), 2, 10000) [Permissions Names]
	FROM #rollUpPermissionsInSameRole U
	UNION
	SELECT Account,'No Groups','Agent', AgentName,'No Role',Description
	FROM #ServiceUserAccount
IF object_id('tempdb.dbo.#tuserentityInfo') is not null	DROP TABLE #tuserentityInfo
IF object_id('tempdb.dbo.#tempUserList') IS NOT null DROP TABLE #tempUserList
IF object_id('tempdb.dbo.#rolePermissionsMap') IS NOT null DROP TABLE #rolePermissionsMap
IF object_id('tempdb.dbo.#allRoles') IS NOT null DROP TABLE #allRoles
IF object_id('tempdb.dbo.#userGroupMap') IS NOT null DROP TABLE #userGroupMap
IF object_id('tempdb.dbo.#rollUpPermissionsInSameRole') IS NOT null DROP TABLE #rollUpPermissionsInSameRole
IF object_id('tempdb.dbo.#ServiceUserAccount') IS NOT null DROP TABLE #ServiceUserAccount
END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCapabilitiesByUser')
	delete from GxQscripts where name = 'RptGetCapabilitiesByUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCapabilitiesByUser')
	delete from GXDBVersions where aliasname = 'RptGetCapabilitiesByUser'
GO

insert into GXDBVersions values(2, 'RptGetCapabilitiesByUser',  '00010004000200050000', 'RptGetCapabilitiesByUser', '00010004000200050000')
GO

