

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetCapabilities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetCapabilities.sp,v $ $Id: RptGetCapabilities.sp,v 1.1.4.5 2020/08/24 15:16:00 sjohnson Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "RptGetCapabilitiesByUser"	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetCapabilities')
BEGIN
	print '>>> Drop Stored Procedure: RptGetCapabilities <<<'
	drop procedure RptGetCapabilities
END
IF EXISTS (select * from GxQscripts where name='RptGetCapabilities')
	delete from GxQscripts where name = 'RptGetCapabilities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCapabilities')
	delete from GXDBVersions where aliasname = 'RptGetCapabilities'
GO
print '... Creating Procedure: RptGetCapabilities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetCapabilities
  @i_jobId integer
AS
  DECLARE @o_rowType int
  DECLARE @o_userOrGroupName nvarchar(255)
  DECLARE @o_userOrGroupEnabled nvarchar(255)
  DECLARE @o_entityType nvarchar(255)
  DECLARE @o_entityName nvarchar(max)
  DECLARE @o_roleOrPermission nvarchar(max)
  DECLARE @o_member nvarchar(max)
  DECLARE @o_memberEnabled nvarchar(255)
  DECLARE @o_rowsPerUserOrUserGroup int
  DECLARE @o_rowsPerEntityType int
  DECLARE @o_rowsPerEntityName int
  DECLARE @o_rowsPerRolesOrPermissions int
BEGIN
    SET NOCOUNT ON
    DECLARE @rowType_isCount    INT = 0
    DECLARE @rowType_isGroup     INT = 1
    DECLARE @rowType_isUser    INT = 2
DECLARE @userId INT = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
    IF OBJECT_ID('tempdb..#Capabilities') IS NOT NULL DROP TABLE #Capabilities
    CREATE TABLE #Capabilities
    (
        rowType                     int,
        userOrGroupName             nvarchar(max),
        userOrGroupId               int,
        isUser                      int,
        userOrGroupFlags	        int,
        entityType                  nvarchar(max),
        entityTypeId                int,
        entityName			        nvarchar(max),
        roleOrPermission	        nvarchar(max),
        member	                    nvarchar(max),
        memberEnabled	                nvarchar(max),
        --the rowsPer* columns are used by the CPP layer to merge the cells(per column) with the same data
        rowsPerUserOrUserGroup      int,
        rowsPerEntityType           int,
        rowsPerEntityName           int,
        rowsPerRolesOrPermissions   int,
    )
    INSERT INTO #Capabilities(userOrGroupId, isUser, userOrGroupName, userOrGroupFlags, entityTypeId, entityType, memberEnabled, member, entityName, roleOrPermission)
    EXEC sec_rpt_Associations @userId
    UPDATE #Capabilities
    SET rowType = CASE WHEN isUser = 1 THEN  @rowType_isUser ELSE @rowType_isGroup END
    UPDATE T
    SET rowsPerUserOrUserGroup = C.rowsPerUserOrUserGroup
    FROM #Capabilities T INNER JOIN (
        SELECT rowType, userOrGroupId, count(*) AS rowsPerUserOrUserGroup
        FROM #Capabilities
        GROUP BY rowType, userOrGroupId
    ) C ON T.rowType = C.rowType AND T.userOrGroupId = C.userOrGroupId
    UPDATE T
    SET rowsPerEntityType = C.rowsPerEntityType
    FROM #Capabilities T INNER JOIN (
        SELECT rowType, userOrGroupId, entityTypeId, count(*) AS rowsPerEntityType
        FROM #Capabilities
        GROUP BY rowType, userOrGroupId, entityTypeId
    ) C ON T.rowType = C.rowType AND T.userOrGroupId = C.userOrGroupId AND T.entityTypeId = C.entityTypeId
    UPDATE T
    SET rowsPerEntityName = C.rowsPerEntityName
    FROM #Capabilities T INNER JOIN (
        SELECT rowType, userOrGroupId, entityTypeId, entityName, count(*) AS rowsPerEntityName
        FROM #Capabilities
        GROUP BY rowType, userOrGroupId, entityTypeId, entityName
    ) C ON T.rowType = C.rowType AND T.userOrGroupId = C.userOrGroupId
        AND T.entityTypeId = C.entityTypeId AND T.entityName = C.entityName
    UPDATE T
    SET rowsPerRolesOrPermissions = C.rowsPerRolesOrPermissions
    FROM #Capabilities T INNER JOIN (
        SELECT rowType, userOrGroupId, entityTypeId, entityName, roleOrPermission , count(*) AS rowsPerRolesOrPermissions
        FROM #Capabilities
        WHERE rowType = @rowType_isGroup
        GROUP BY rowType, userOrGroupId, entityTypeId, entityName, roleOrPermission
    ) C ON T.rowType = C.rowType AND T.userOrGroupId = C.userOrGroupId
        AND T.entityTypeId = C.entityTypeId AND T.entityName = C.entityName
        AND T.roleOrPermission = C.roleOrPermission
--  USE CLIENT DISPLAY NAME INSTEAD OF NAME:
	UPDATE T
	set entityName = CL.displayName
	FROM #Capabilities T
	INNER JOIN APP_Client CL
	ON T.entityTypeId in (1, 3, 11) AND  T.entityName = CL.name  -- Commcell, Client, MediaAgent
    SELECT rowType,
        CASE WHEN ISNULL(userOrGroupName,'') = '' THEN 'N/A' ELSE userOrGroupName END AS userOrGroupName,
        CASE WHEN userOrGroupFlags = 0 THEN 'No' ELSE 'Yes' END AS userOrGroupEnabled,
		CASE WHEN ISNULL(entityType,'') = '' THEN 'N/A' ELSE entityType END AS entityType,
		CASE WHEN ISNULL(entityName,'') = '' THEN 'N/A' ELSE entityName END AS entityName,
		CASE WHEN ISNULL(roleOrPermission,'') = '' THEN 'N/A' ELSE roleOrPermission END AS roleOrPermission,
		case when ISNULL(member,'') = '' then 'N/A' else member end AS member,
        CASE WHEN memberEnabled = 0 THEN 'No' ELSE 'Yes' END AS memberEnabled,
        rowsPerUserOrUserGroup, rowsPerEntityType, rowsPerEntityName, rowsPerRolesOrPermissions
    FROM #Capabilities
    ORDER BY rowType, userOrGroupName, entityType, entityName, memberEnabled desc
    IF OBJECT_ID('tempdb..#Capabilities') IS NOT NULL DROP TABLE #Capabilities
END

IF EXISTS (select * from GxQscripts where name = 'RptGetCapabilities')
	delete from GxQscripts where name = 'RptGetCapabilities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCapabilities')
	delete from GXDBVersions where aliasname = 'RptGetCapabilities'
GO

insert into GXDBVersions values(2, 'RptGetCapabilities',  '00010001000400050000', 'RptGetCapabilities', '00010001000400050000')
GO

