

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetCDRAttempts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetCDRAttempts.sp,v $ $Id: RptGetCDRAttempts.sp,v 1.4.278.2 2018/03/22 03:14:18 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetCDRAttempts"			|
--	||
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetCDRAttempts <<<'

IF EXISTS (select * from sysobjects where name='RptGetCDRAttempts')
	drop procedure RptGetCDRAttempts
IF EXISTS (select * from GxQscripts where name='RptGetCDRAttempts')
	delete from GxQscripts where name = 'RptGetCDRAttempts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCDRAttempts')
	delete from GXDBVersions where aliasname = 'RptGetCDRAttempts'
GO
print '... Creating Procedure: RptGetCDRAttempts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetCDRAttempts
  @i_taskId int,
  @i_jobId int,
  @i_clId int,
  @i_useCSTime int
AS
  DECLARE @o_phaseNum integer;
  DECLARE @o_AttemptNum integer;
  DECLARE @o_status integer;
  DECLARE @o_startTime integer;
  DECLARE @o_endTime integer;
  DECLARE @o_elapsedTime integer;
  DECLARE @o_filesToTransfer bigint;
  DECLARE @o_filesTransfered bigint;
  DECLARE @o_dataToTransfer bigint;
  DECLARE @o_dataTransfered bigint;
  DECLARE @o_failureReason varchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @startTime	integer
DECLARE @endTime	integer
EXEC RptOptGetTime @i_taskId, @startTime OUTPUT, @endTime OUTPUT
SELECT	phaseNum, attemptNum, status,
	(case @i_useCSTime when 0 then DBO.rptgetJobClientTime(@i_clId, ISNULL(startTime,0)) else startTime end),
	(case @i_useCSTime when 0 then DBO.rptgetJobClientTime(@i_clId, isnull(endTime,0)) else endTime end), elapsedTime,
	numberOfFilesToTransfer, noFilesTransfered, bytesToTransfer, dataTransfer, failureReason
FROM	JMCDRAttempts
WHERE	jobId = @i_jobId AND (@startTime = 0 OR endTime = 0 OR endTime >= @startTime) AND (@endTime = 0 OR startTime <= @endTime)
ORDER BY startTime
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCDRAttempts')
	delete from GxQscripts where name = 'RptGetCDRAttempts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCDRAttempts')
	delete from GXDBVersions where aliasname = 'RptGetCDRAttempts'
GO

insert into GXDBVersions values(2, 'RptGetCDRAttempts',  '00010004027800020000', 'RptGetCDRAttempts', '00010004027800020000')
GO

