

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetCCReadiness.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetCCReadiness.sp,v $ $Id: RptGetCCReadiness.sp,v 1.65.2.20 2020/12/23 12:13:15 nbirru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptGetCCReadiness"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='rptGetCCReadiness')
BEGIN
	print '>>> Drop Stored Procedure: rptGetCCReadiness <<<'
	drop procedure rptGetCCReadiness
END
IF EXISTS (select * from GxQscripts where name='rptGetCCReadiness')
	delete from GxQscripts where name = 'rptGetCCReadiness'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetCCReadiness')
	delete from GXDBVersions where aliasname = 'rptGetCCReadiness'
GO
print '... Creating Procedure: rptGetCCReadiness'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure rptGetCCReadiness
  @i_jobId integer,
  @i_CCRId integer
AS
  DECLARE @o_clientId integer;
  DECLARE @o_clientName nchar(255);
  DECLARE @o_appType integer;
  DECLARE @o_appTypeName char(255);
  DECLARE @o_instance integer;
  DECLARE @o_instanceName nchar(255);
  DECLARE @o_backupSet integer;
  DECLARE @o_backupSetName nchar(255);
  DECLARE @o_subClient integer;
  DECLARE @o_subClientName nchar(255);
  DECLARE @o_dataStoragePolicy integer;
  DECLARE @o_dataStoragePolicyName NVARCHAR(255);
  DECLARE @o_SPCopyName NVARCHAR(255);
  DECLARE @o_logStoragePolicy integer;
  DECLARE @o_logStoragePolicyName NVARCHAR(255);
  DECLARE @o_incrSP integer;
  DECLARE @o_incrSPName NVARCHAR(255);
  DECLARE @o_CCRStatus integer;
  DECLARE @o_CCRNetworkReadinessFlag integer;
  DECLARE @o_CCRResourceReadinessFlag integer;
  DECLARE @o_dataPathNum integer;
  DECLARE @o_dataPathId integer;
  DECLARE @o_CopyType integer;
  DECLARE @o_flags integer;
  DECLARE @o_defaultCopyId integer;
  DECLARE @o_dataPathFlag integer;
  DECLARE @o_drivePoolName NVARCHAR(255);
  DECLARE @o_mediaAgentName char(255);
  DECLARE @o_libraryAliasName NVARCHAR(255);
  DECLARE @o_clientInterface char(255);
  DECLARE @o_mediaAgentInterface char(255);
  DECLARE @o_isLogAG integer;
  DECLARE @o_scNum integer;
  DECLARE @o_isRAC integer;
  DECLARE @o_isNonRealSubClients integer;
  DECLARE @o_DataInterface char(255);
  DECLARE @o_allDDBInfo xml;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @errorOnly	integer
DECLARE @disabledCliententities integer
DECLARE @clOpt		integer
DECLARE @appTypeOpt	integer
DECLARE @tblClients	TABLE (t_clId int)
DECLARE @tblApptypes	TABLE (t_appTypeId int)
DECLARE @i_taskId integer
SET @i_taskId = @i_jobId
DECLARE @locId  integer
DECLARE @flags	bigint
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @errorOnly 	= dbo.GetOptionInt(1474670120, @i_jobId, 0, 0)
set @disabledCliententities = dbo.GetOptionInt(985522432, @i_jobId, 0, 0)
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetObjectList @i_jobId, 444361887, @appTypeOpt OUTPUT
BEGIN
	UPDATE 	CCRCommcellReadiness
	SET 	CCREndTime = dbo.GetUnixTime(getutcdate())
	WHERE	CCRID = @i_CCRId
END
-- If the apptype CV_APPTYPE_WINDOWS_FILESYSTEM is present in GUI selection,
-- We must consider all the WIN FS AppTypes.
-- This I have added because I need to merge all flavours of Windows AppTypes to one(MR: 62562)
-- For backward compatibility with 8.0 and 9.0 I am adding this.
DECLARE @WindowsFSSelected INT
SET @WindowsFSSelected = CASE WHEN EXISTS (SELECT * FROM @tblAppTypes WHERE t_appTypeId = 33) THEN 1 ELSE 0 END
IF @WindowsFSSelected <> 0
BEGIN
INSERT INTO @tblAppTypes VALUES (1)
INSERT INTO @tblAppTypes VALUES (11)
	--INSERT INTO @tblAppTypes VALUES (CV_APPTYPE_WINDOWS_FILESYSTEM) -- Already there
INSERT INTO @tblAppTypes VALUES (34)
INSERT INTO @tblAppTypes VALUES (42)
INSERT INTO @tblAppTypes VALUES (43)
END
--clients having all non real subclients
--real subclient, if subclientStatus exist in {0, CV_STATUS_DEFAULT	0x00008,CV_STATUS_SYSTEM_RECOVERY 0x0100}
--otherwise, Non real subclients {CV_STATUS_DELETED	0x00004, CV_STATUS_DUMMY 0x00010,CV_STATUS_HIDDEN	0x00020, CV_STATUS_CMD_LINE	0x0040}
DECLARE @tblClientsWithNonRealSubclients	TABLE (clientId int)
insert into @tblClientsWithNonRealSubclients
select  C.id from APP_Client C WITH (READUNCOMMITTED)
where id not in (select distinct clientid from app_application WITH (READUNCOMMITTED)
					 where subclientstatus =0
					OR ((subclientstatus & 8) >0) AND  ((subclientstatus & 48) = 0  )
					OR ((subclientstatus &256) >0 AND  ((subclientstatus & 48) = 0 )))
if @clOpt >0
	delete C FROM @tblClientsWithNonRealSubclients C
	left outer join @tblClients T on C.clientId = T.t_clId
	where C.clientId IS NULL
--begin--For VSA pseudo clients, we need to involve the member servers
	declare @pseudoVSAClients xml;
	set @pseudoVSAClients = (select (
	select t_clId as '@id'
	from @tblClients C
	where Exists (select clientId
			from APP_IDAName IDA WITH (READUNCOMMITTED)
			where C.t_clId = IDA.clientId
AND appTypeId = 106
				AND not exists (select clientId from simInstalledPackages SIM WITH (READUNCOMMITTED) where IDA.clientId=SIM.clientId )
			)
	for xml path('client'), TYPE) for xml path('pseudoVSAClients'));
	--select @pseudoVSAClients --gets the pseudo vsa clients in the CS as xml rows
	IF object_id('tempdb.dbo.#pseudoVSANodes') IS NOT null	DROP TABLE #pseudoVSANodes
	CREATE TABLE #pseudoVSANodes(pseudoClient int, node int);
	insert into #pseudoVSANodes
	EXEC AppGetVSMemberServersXML @pseudoVSAClients
	insert into @tblClients
	select distinct node from #pseudoVSANodes N where not exists(select t_clId from @tblClients C where C.t_clId = N.node)
	DROP TABLE #pseudoVSANodes
--end
DECLARE @tmpExternalClient TABLE (id INT)
--Get NBU client list
INSERT INTO @tmpExternalClient
SELECT C.id
FROM APP_Client C WITH (READUNCOMMITTED) , APP_CommCell Cell WITH (READUNCOMMITTED)
WHERE C.origCCId = Cell.id and Cell.type = 100
IF object_id('tempdb.dbo.#temp_dataPath_list') IS NOT null DROP TABLE #temp_dataPath_list
CREATE TABLE #temp_dataPath_list(	dataPathId		integer,
				drivePoolId		integer,
				drivePoolName		nvarchar(256),
				drivePoolType		integer,
				mediaAgentId		integer,
				NDMPHostId		integer,
				mediaAgentName		varchar(256),
				libraryId		integer,
				libraryName		varchar(256),
				libraryAliasName	nvarchar(256),
				libraryType		integer,
				clientInterface		varchar(256),
				mediaAgentInterface	varchar(256),
				HWCompression		integer,
				DataPathFlag		integer,
				numRows			integer,
				archGroupId		integer,
				clientId		integer)
IF object_id('tempdb.dbo.#BCIF') IS NOT null DROP TABLE #BCIF
 SELECT DISTINCT subclientId=id,clientId,appTypeId,instance,backupSet,subClientName,dataArchGrpID,logArchGrpID, scNum=0,isDisabled=0
 INTO #BCIF
 FROM APP_Application APP WITH (READUNCOMMITTED)
 WHERE  (@clOpt = 0 OR EXISTS (SELECT t_clId FROM @tblClients where t_clId = APP.clientId))
	AND (@appTypeOpt = 0 OR EXISTS (SELECT t_appTypeId FROM @tblApptypes WHERE APP.appTypeId = t_appTypeId))
	AND (
				APP.subClientStatus & 2 = 0
			OR
				(
					( APP.subClientStatus & 2 = 2 ) AND EXISTS ( SELECT SIM.clientId FROM SimInstalledPackages SIM WHERE APP.clientId = SIM.clientId ) --Allow clients with siminstalled packages but with subclientstatus as uninstalled(restore-only clients)
				)
		)
	AND (APP.subClientStatus & 4) = 0
	AND (((APP.subClientStatus & 32) = 0 OR EXISTS (select clientId from @tblClientsWithNonRealSubclients WHERE clientId = APP.clientId))
	AND (APP.subClientStatus & 16) = 0 OR (APP.subClientStatus & 64) > 0)
	AND EXISTS (select subclientId from CCRToSubClient WITH (NOLOCK) where SubClientId = App.id)
	IF object_id('tempdb.dbo.#ClientWithoutSubclients') IS NOT NULL drop table #ClientWithoutSubclients
	CREATE TABLE #ClientWithoutSubclients (clientId int )
	IF (@clOpt = 0)
	INSERT INTO #ClientWithoutSubclients
		SELECT DISTINCT C.id from APP_Client C WITH (NOLOCK)
		INNER JOIN    (select clientid,max(HighestSP) AS 'HighestSP' from simInstalledPackages WITH (NOLOCK) group by ClientId) sim  ON sim.ClientId = C.id
		LEFT OUTER JOIN APP_Application AP WITH (NOLOCK) ON  C.id = AP.clientId
		WHERE AP.clientId IS NULL AND (c.releaseId > 16 or (c.releaseId = 16 and sim.highestSP >= 17))
	ELSE
	INSERT INTO #ClientWithoutSubclients
		SELECT DISTINCT C.id from APP_Client C WITH (NOLOCK)
		INNER JOIN @tblClients t on c.id = t.t_clId
		INNER JOIN    (select clientid,max(HighestSP) AS 'HighestSP' from simInstalledPackages WITH (NOLOCK) group by ClientId) sim  ON sim.ClientId = C.id
		LEFT OUTER JOIN APP_Application AP WITH (NOLOCK) ON  C.id = AP.clientId
		WHERE AP.clientId IS NULL AND (c.releaseId > 16 or (c.releaseId = 16 and sim.highestSP >= 17))
	DELETE FROM #ClientWithoutSubclients
	    where clientId IN (
	    select attrVal from APP_ClientProp where attrName like 'Linked CS Client' and modified = 0)
	DECLARE @IdentInsQueryCheckList NVARCHAR(MAX)
	SET @IdentInsQueryCheckList = 'INSERT INTO #BCIF (subClientId, clientId, appTypeId,instance,backupSet,dataArchGrpId,logArchGrpId,subclientName,scNum,isDisabled)
	SELECT	0, clientId, 0,0,0,1,1,'''',0,0
	FROM	#ClientWithoutSubclients'
	EXEC SQLUtilIdentityInsert @IdentInsQueryCheckList, '#BCIF'
--removed defaultDummyBackupSet subclient from the report
DELETE  #BCIF
    FROM    #BCIF T
            INNER JOIN APP_Application A (nolock)
                ON T.subclientId = A.id
            INNER JOIN APP_BackupSetName B (nolock)
                ON A.backupset = B.id
    WHERE   B.name = 'defaultDummyBackupSet'
AND A.appTypeId IN (37, 62, 103)
-- remove more hidden subclients
 delete  #BCIF FROM #BCIF, APP_InstanceName WITH (READUNCOMMITTED) WHERE id=instance and ((status & 16)>0 or (status & 32)>0)
-- skip pre-imaged machines
delete  #BCIF FROM #BCIF, APP_Client WITH (READUNCOMMITTED) WHERE id=clientId and (status & 0x04000) > 0
-- skip external NBU clients
 delete  #BCIF FROM #BCIF, @tmpExternalClient WHERE id = clientId
-- remove subclient policy subclients & commnet agents
 DELETE FROM #BCIF WHERE apptypeid IN (1030,121,122)
-- skip SRM pseudo clients
delete  #BCIF FROM #BCIF, APP_Client WITH (READUNCOMMITTED) WHERE id=clientId and (status & 0x0400) > 0
 AND clientId in (SELECT componentNameId FROM APP_clientProp WITH (READUNCOMMITTED)
                  WHERE attrName LIKE 'NoPhysicalMachinePresent' AND attrVal = '1')
--skip SRM agentless clients
DECLARE @simClients TABLE(clientId INT);
INSERT INTO @simClients
select distinct clientId from simInstalledPackages WITH (READUNCOMMITTED)
DELETE  T
FROM  #BCIF T
INNER JOIN simInstalledPackages P WITH (NOLOCK)
ON T.clientId = P.ClientId
INNER JOIN App_SubclientProp prop WITH (NOLOCK)
ON T.subclientId = prop.componentNameId
AND prop.cs_attrName = CHECKSUM(N'Index SubClient')
    AND     prop.attrName = N'Index SubClient'
    AND     prop.attrVal = '1'
    AND     prop.modified = 0
delete  #BCIF
FROM #BCIF
where clientId in (SELECT componentNameId FROM APP_clientProp WITH (READUNCOMMITTED)
                  WHERE attrName LIKE 'Mini SRM Agent' AND attrVal = '1' AND NOT EXISTS (select * from @simClients where clientId = componentNameId) AND modified = 0)
-- Delete CS cluster nodes
DECLARE @CSNode INT
SELECT @CSNode = clientId FROM APP_Platform WITH (NOLOCK) WHERE (platformType & 1) = 1
DECLARE @isClusterCS INT = 0
SELECT @isClusterCS = attrVal FROM App_ClientProp with(nolock)
WHERE componentNameId = @CSNode
AND attrName LIKE 'Virtual Client' AND modified = 0
 -- If it is a cluster CS
IF @isClusterCS = 1
BEGIN
delete  #BCIF
FROM #BCIF
where clientId in (SELECT PMClientId FROM APP_VMToPMMap WITH (NOLOCK)  where VMClientId = @CSNode )
END
 DECLARE @IdentInsQuery NVARCHAR(MAX)
 SET @IdentInsQuery = ' INSERT INTO #BCIF (subclientId,clientId,appTypeId,instance,backupSet,subClientName,dataArchGrpID,logArchGrpID,scNum,isDisabled)
	 SELECT subclientId,clientId,appTypeId,instance,backupSet,subClientName,logArchGrpID,0,0,0
	 FROM #BCIF
	 WHERE dataArchGrpId>1 AND logArchGrpId>1 AND dataArchGrpId<>logArchGrpId'
 EXEC SQLUtilIdentityInsert @IdentInsQuery, '#BCIF'
 UPDATE #BCIF
 SET dataArchGrpID=logArchGrpID
 WHERE dataArchGrpId<=1 AND logArchGrpId>1
--get data path
IF OBJECT_ID('tempdb..#InvalidDatapath') IS NOT NULL DROP TABLE #InvalidDatapath
CREATE TABLE #InvalidDatapath (appId INT,clientId INT, archGroupId INT)
 DECLARE @clientId	INTEGER
 DECLARE @archGrpId	INTEGER
 DECLARE dataPathList CURSOR FOR
 	SELECT DISTINCT clientId, dataArchGrpId FROM #BCIF
 OPEN dataPathList
 FETCH NEXT FROM dataPathList INTO @clientId,@archGrpId
 WHILE @@FETCH_STATUS <> -1
 BEGIN
 	IF @archGrpId > 1
	INSERT INTO #temp_dataPath_list
	EXEC getdataPathsForSubClient @archGrpId, @clientId, 0
	ELSE IF @archGrpId = 1	-- Stroage Policy Not Assigned
		 INSERT INTO #temp_dataPath_list
		 values(0,0,'N/A',-1,1,0,'N/A',0,'N/A','N/A',-1,'N/A','N/A',-1,0,1,1,@clientId)
	IF NOT EXISTS (SELECT 1 FROM #temp_dataPath_list where clientId = @clientId)
	BEGIN
	    INSERT INTO #InvalidDatapath
	    select MIN(id),@clientId, @archGrpId
	    FROM APP_Application where clientId = @clientId and (subClientStatus & 6) = 0
    END
	FETCH NEXT FROM dataPathList INTO @clientId,@archGrpId
 END
 CLOSE dataPathList
 DEALLOCATE dataPathList
 DECLARE @subdisableError INT =0
  DECLARE @sidbError INT =0
SET @subdisableError = 64
SET @sidbError = 128|256|512
  update #BCIF
 set isDisabled=(case when (CCRResultFlag &  @subdisableError)>0 then 1 else 0 end)
 from #BCIF tt,CCRToSubClient CCRS WITH (READUNCOMMITTED)
 where tt.subclientId = CCRS.subclientid and CCRS.CCRId = @i_CCRId
--MR:50845: remove CCR check for MA associated with secondary copy, which is not similar to primary copy MA
DELETE #temp_dataPath_list
FROM #temp_dataPath_list td
WHERE td.dataPathId NOT IN (
		SELECT T.dataPathId
		FROM  MMDataPath DP WITH (READUNCOMMITTED), #temp_dataPath_list T
		WHERE T.dataPathId =DP.DataPathId and DP.HostClientId IN
			(
				SELECT DISTINCT DP.HostClientId
				FROM  archGroup AG WITH (READUNCOMMITTED), MMDataPath DP WITH (READUNCOMMITTED)
				WHERE T.archGroupId =AG.id AND AG.defaultCopy =DP.CopyId
			)
)
DELETE T
FROM #temp_dataPath_list AS T
INNER JOIN MMDataPath DP
ON DP.DatapathId=T.DatapathId
INNER JOIN archGroupCopy AGC ON
AGC.Id=DP.copyId AND AGC.type=5
update #temp_dataPath_list
set numRows = (select count(*) from #temp_dataPath_list b where a.archGroupId = b.archGroupId and a.clientid=b.clientid group by b.archGroupId,b.clientid)
from #temp_dataPath_list a
 IF @errorOnly > 0
BEGIN
	delete 	#temp_dataPath_list
	FROM	#temp_dataPath_list T
	LEFT JOIN #InvalidDatapath I ON I.clientId = T.clientId AND I.archGroupId = T.archGroupId
	WHERE	not exists ( SELECT * FROM CCRToSubClient C WITH (READUNCOMMITTED) WHERE C.CCRId=@i_CCRId AND C.ClientId=T.clientId
			AND C.DataPathId=T.dataPathId AND CCRResultFlag != 0) AND I.clientId is NOT NULL
	update #temp_dataPath_list
	set numRows = (select count(*) from #temp_dataPath_list b where a.archGroupId = b.archGroupId and a.clientid=b.clientid group by b.archGroupId,b.clientid)
	from #temp_dataPath_list a
	IF NOT EXISTS (SELECT 1 FROM #InvalidDatapath)
	BEGIN
		delete 	#BCIF
		WHERE	dataArchGrpID < 1 OR
		0 = (select count(*) from #temp_dataPath_list where clientId=#BCIF.clientId AND archGroupId=#BCIF.dataArchGrpId)
	END
	delete 	#BCIF
	FROM	#BCIF B, #temp_dataPath_list T, CCRToSubClient C WITH (READUNCOMMITTED)
	WHERE	B.clientId=T.clientId AND B.dataArchGrpId=T.archGroupId AND
		C.CCRId=@i_CCRId AND C.ClientId=B.clientId AND C.SubClientId=B.subclientId AND C.DataPathId=T.dataPathId AND CCRResultFlag=0
END
-- delete disabled clients if the option include disabled clients is unchecked
-- opType =  4 BACKUP
-- action =  1 DISABLED
 IF @disabledCliententities = 0
 BEGIN
	 delete #BCIF  WHERE clientId in (SELECT clientid FROM JMJobAction WITH (READUNCOMMITTED) WHERE optype= 4  and action = 1 and apptype =0)
 END
--security concerns
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @clOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2013 , 0, '#rptUserObjects'	-- SUB_CLIENT_ITEM = to get SUB_CLIENT_ITEM it will be having client/appType/instance/backupSet/subclient/
	delete #rptUserObjects
	WHERE clientGroupId <> 0 or commcellId <> 2
	delete	#BCIF
	FROM	#BCIF T
	WHERE	0 = (	select	count(*) from #rptUserObjects
			where	clientId IN (0, T.clientId) AND
				appTypeId IN (0,T.appTypeId) AND
				instanceId IN (0,T.instance) AND
				backupsetId IN (0,T.backupSet) AND
				subClientId IN (0,T.subclientId))
	DROP TABLE #rptUserObjects
END
  IF @disabledCliententities = 0
 BEGIN
     DELETE tt
	 from #BCIF tt,CCRToSubClient CCRS WITH (READUNCOMMITTED)
	where tt.subclientId = CCRS.subclientid and CCRS.CCRId = @i_CCRId
AND (CCRResultFlag& 64) = 64
 END
 UPDATE #BCIF
 SET scNum=(select count(*) from #BCIF T where F.clientId=T.clientId and F.appTypeId = T.appTypeId and F.dataArchGrpID=T.dataArchGrpID and F.isDisabled = T.isDisabled)
 FROM #BCIF F
-- DDB ma subclient information
DECLARE  @subClientDDBMAInfo TABLE  (subclientid INT , archCopyid INT, DDBClientID INT ,DDBClientName NVARCHAR(MAX),DDBPathID INT ,DDBPathName NVARCHAR(MAX) )
INSERT INTO @subClientDDBMAInfo( subclientid ,archCopyid, DDBClientID,DDBPathID  ,DDBPathName )
SELECT distinct sc.subclientid, AGC.id, IdxSS.ClientId as DDBClientID,IdxAP.IdxAccessPathId,IdxAP.Path  FROM
	CCRToSubClient(nolock) AS sc INNER JOIN app_application(nolock)   AS AA ON
aa.id=sc.subclientid AND sc.CCRId = @i_CCRId AND SC.AppTypeId not in(13, 88,84)
		INNER JOIN archGroup(nolock) AG ON AA.dataArchGrpId = AG.id
		INNER JOIN archGroupCopy(nolock) AGC ON AG.id = AGC.archGroupId
		INNER JOIN archSubclientCopyDDBMap CSD (NOLOCK) ON AGC.id = CSD.copyId AND SC.subClientId = CSD.appId
		INNER JOIN  IdxSIDBSubStore(nolock) IdxSS ON CSD.SIDBStoreId = IdxSS.SIDBStoreId
		INNER JOIN IdxAccessPath IdxAP ON IdxSS.IdxAccessPathId = IdxAP.IdxAccessPathId
UPDATE @subClientDDBMAInfo
SET DDBClientName =  CP.attrVal from APP_ClientProp (nolock) CP
inner join @subClientDDBMAInfo DDBMA ON CP.componentNameId = DDBMA.DDBClientID and attrName = 'DataPipeInterface'
DECLARE  @subClientAllDDBMAInfo TABLE  (subclientid INT , archCopyId INT, DDBInfoXML XML  )
INSERT INTO @subClientAllDDBMAInfo( subclientid, archCopyId  )
		select DISTINCT subclientid, archCopyId from @subClientDDBMAInfo
--UPDATE @subClientAllDDBMAInfo
--SET DDBInfoXML = R.alldddb
--FROM
--(SELECT DDBMA1.subclientid as ddbsubclientid,STUFF((SELECT  ', ' + DDBMA2.DDBClientName +'(' + ')'  FROM  @subClientDDBMAInfo DDBMA2 WHERE DDBMA1.subclientid = DDBMA2.subclientid
--FOR XML PATH ( '' ) ) , 1 , 2 , '' ) as "alldddb"
--FROM  @subClientDDBMAInfo DDBMA1) R
--where R.ddbsubclientid = subclientid
--
--
update tt
set DDBInfoXML = (select
 tt1.subclientid as [@SubClientId],
0	as	[@DataPathId],
	0 as	[@CCToDDBMANetCheckErrorCode],
	0 as	[@DDBMAToCCNetCheckErrorCode],
	0 as	[@DDBMAToMANetCheckErrorCode],
	0 as	[@MAToDDBMANetCheckErrorCode],
	tt1.DDBClientID as	[@DDBMAHostClientId],
	tt1.DDBClientName [@DDBMAHostName],
	datapaths.DataPathInformation.query('.')
	from (select  dd.DDBClientID ,
				  dd.subclientid	,
				  dd.archCopyId,
				(select DDBPathID [@id],
				DDBPathName [@name]
				from (select distinct DDBClientID,DDBPathID,DDBPathName,subclientid, archCopyId from  @subClientDDBMAInfo) dd1
				where dd1.DDBClientID = dd.DDBClientID and dd.subclientid =  dd1.subclientid and dd.archCopyId = dd1.archCopyId
				FOR XML PATH ('DataPathInformation'),type) as DataPathInformation
				from  @subClientDDBMAInfo dd
				group by  dd.DDBClientID,dd.subclientid,dd.archCopyId) as datapaths
	inner join (select distinct subclientid, archCopyId, DDBClientID,DDBClientName from @subClientDDBMAInfo) tt1
    on tt1.SubClientId= datapaths.SubClientId and  tt1.DDBClientID= datapaths.DDBClientID and tt1.archCopyId = datapaths.archCopyId
	and tt1.SubClientId= tt.SubClientId and tt1.archCopyid = tt.archCopyId
FOR XML PATH ('DDBMAInfo'))
from @subClientAllDDBMAInfo as tt
DECLARE @useClientDisplayName int=1    --R11 SP15 Always use displayName
--    IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bUseClientDisplayName' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' -- AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
--    BEGIN
--        SET @useClientDisplayName = 1
--    END
 SELECT B.clientId,clientName=(select (CASE WHEN @useClientDisplayName = 1 THEN displayname ELSE name END)  from APP_Client WITH (READUNCOMMITTED) where id=B.clientId),
	B.appTypeId,appTypeName=(select name from APP_iDAType WITH (READUNCOMMITTED) where type=B.appTypeId),
	B.instance,instanceName=(select name from APP_InstanceName WITH (READUNCOMMITTED) where id=B.instance),
	B.backupSet,backupSetName=(select name from APP_BackupSetName  WITH (READUNCOMMITTED) where id=B.backupSet),
	B.subclientId,B.subClientName,
	B.dataArchGrpID,dataArchGrpName=(select name from archGroup WITH (READUNCOMMITTED) where id=B.dataArchGrpID),
	SPCopyName=(select AGC.name from ArchGroupCopy  AGC WITH (READUNCOMMITTED), MMDataPath DP WITH (READUNCOMMITTED) where AGC.Id=DP.copyId and DP.DatapathId=T.DatapathId),
	B.logArchGrpID,logArchGrpName=(select name from archGroup WITH (READUNCOMMITTED) where id=B.logArchGrpID),
	A.incrSP,incrName=(select name from archGroup tt WITH (READUNCOMMITTED) where tt.id=A.incrSP),
	CCRStatus=(select CCRResultFlag FROM CCRToSubClient C WITH (READUNCOMMITTED)
		LEFT OUTER JOIN #InvalidDatapath I ON I.appId = C.SubClientId
		WHERE C.CCRId=@i_CCRId AND C.ClientId=B.clientId AND C.SubClientId=B.subclientId AND (C.DataPathId=T.dataPathId OR B.subclientId = 0 OR I.appId IS NOT NULL)),
	CCRNetworkReadinessFlag=(select CCRNetworkReadinessFlag FROM CCRToSubClient C WITH (READUNCOMMITTED)
		WHERE C.CCRId=@i_CCRId AND C.ClientId=B.clientId AND C.SubClientId=B.subclientId AND (C.DataPathId=T.dataPathId OR B.subclientId = 0)),
	CCRResourceReadinessFlag=(select CCRResourceReadinessFlag FROM CCRToSubClient C WITH (READUNCOMMITTED)
		LEFT OUTER JOIN #InvalidDatapath I ON I.appId = C.SubClientId
		WHERE C.CCRId=@i_CCRId AND C.ClientId=B.clientId AND C.SubClientId=B.subclientId AND (C.DataPathId=T.dataPathId OR I.appId IS NOT NULL )),
	ISNULL(numRows, 1),T.dataPathId,CopyType=
											(SELECT CASE WHEN issnapcopy =0 then AGC.type
														 WHEN NOT EXISTS (select * from ArchGroupControlHost(NOLOCK) WHERE ArchGroupId =AGC.archGroupId  AND SMReplicationProtocolType =1 )
														 THEN CASE WHEN (SELECT AG.defaultSnapCopy from ArchGroup AG WITH (READUNCOMMITTED) WHERE AG.ID = AGC.archGroupId  )= AGC.id THEN 101 --RPT_DATA_SNAP_PRIMARY
																   WHEN AGC.isMirrorCopy = 1 THEN 102 --RPT_DATA_SNAP_MIRROR
																   WHEN AGC.type = 2 THEN 103 --RPT_DATA_SNAP_SELECTIVE;
WHEN  AGC.extendedFlags & 256 = 256 THEN 104 --RPT_DATA_SNAP_REPLICA;
																   ELSE 105 --RPT_DATA_SNAP_VAULT;
															  END
														 WHEN EXISTS (select * from ArchGroupControlHost(NOLOCK) WHERE ArchGroupId =AGC.archGroupId AND SMReplicationProtocolType =1 )
														 THEN CASE WHEN (SELECT AG.defaultSnapCopy from ArchGroup AG WITH (READUNCOMMITTED) WHERE AG.ID = AGC.archGroupId  )= AGC.id THEN 106 --RPT_DATA_SPOS_PRIMARY
																   WHEN AGC.isMirrorCopy = 1 THEN 107 --RPT_DATA_SPOS_MIRROR
															   END
													END
														 from ArchGroupCopy  AGC WITH (READUNCOMMITTED), MMDataPath DP WITH (READUNCOMMITTED) where AGC.Id=DP.copyId and DP.DatapathId=T.DatapathId),
	flags=(select AGC.flags from ArchGroupCopy  AGC WITH (READUNCOMMITTED), MMDataPath DP WITH (READUNCOMMITTED) where AGC.Id=DP.copyId and DP.DatapathId=T.DatapathId),
	defaultCopyId=(select distinct AG.defaultcopy from ArchGroup AG WITH (READUNCOMMITTED), ArchGroupCopy AGC WITH (READUNCOMMITTED), MMDataPath DP WITH (READUNCOMMITTED) where AGC.id=AG.defaultCopy and DP.DataPathId=T.DataPathId and AGC.Id=DP.copyId),
	DataPathFlag,drivePoolName,mediaAgentName,libraryAliasName,clientInterface,mediaAgentInterface,
	isLogAG=(CASE WHEN logArchGrpID>0 THEN 0 ELSE 1 END),scNum,
	isOraRAC=(case B.appTypeId when 80 then 1 else 0 end),isNonRealSubClients=(select COUNT(clientId) from @tblClientsWithNonRealSubclients where clientId = B.clientId),
	isDataInterface=''	,
	(select ISNULL(DDB.DDBInfoXML,'')
	For xml path('rpt_RptDDBMAResp'),type)
 FROM	#BCIF B LEFT OUTER JOIN #temp_dataPath_list T ON B.clientId=T.clientId AND B.dataArchGrpId=T.archGroupId
				LEFT OUTER JOIN
				(SELECT subclientid, DataPathId, DDBInfoXML FROM @subClientAllDDBMAInfo DDB1
				JOIN MMDataPath MD WITH (READUNCOMMITTED) ON MD.CopyId = DDB1.archCopyId ) DDB
				ON DDB.subclientid = B.subclientId AND DDB.DataPathId = T.DataPathId
		LEFT OUTER JOIN ArchGroup A WITH (READUNCOMMITTED) ON B.dataArchGrpID=A.id
 ORDER BY scNum,isOraRAC, clientName, dataArchGrpName, appTypeName, instanceName, backupSetName, subClientName, isLogAG
 drop table #BCIF
 drop table #temp_dataPath_list
 drop table #ClientWithoutSubclients
 IF OBJECT_ID('tempdb..#InvalidDatapath') IS NOT NULL DROP TABLE #InvalidDatapath
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCCReadiness')
	delete from GxQscripts where name = 'RptGetCCReadiness'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCCReadiness')
	delete from GXDBVersions where aliasname = 'RptGetCCReadiness'
GO

insert into GXDBVersions values(2, 'RptGetCCReadiness',  '00010065000200200000', 'RptGetCCReadiness', '00010065000200200000')
GO

