

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetCCRIDAApplicationCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetCCRIDAApplicationCheck.sp,v $ $Id: RptGetCCRIDAApplicationCheck.sp,v 1.1.2.6 2020/11/19 07:57:13 nbirru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetCCRIDAApplicationCheck"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGetCCRIDAApplicationCheck')
BEGIN
	print '>>> Drop Stored Procedure: RptGetCCRIDAApplicationCheck <<<'
	drop procedure RptGetCCRIDAApplicationCheck
END
IF EXISTS (select * from GxQscripts where name='RptGetCCRIDAApplicationCheck')
	delete from GxQscripts where name = 'RptGetCCRIDAApplicationCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCCRIDAApplicationCheck')
	delete from GXDBVersions where aliasname = 'RptGetCCRIDAApplicationCheck'
GO
print '... Creating Procedure: RptGetCCRIDAApplicationCheck'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGetCCRIDAApplicationCheck
  @i_CCRId integer
AS
  DECLARE @response xml
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#idaInfoTbl') IS NOT null DROP TABLE #idaInfoTbl
CREATE TABLE #idaInfoTbl
(
    clientId	INT,
	clientName	nvarchar(255),
    appId       INT ,
    appName	nvarchar(255),
)
    -- csabjan: If the flag to use client display name is set, then query and use the client display name.
	DECLARE @useClientDisplayName int = 1    -- Form 61287 Always use DisplayName
--        IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bUseClientDisplayName' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
--        BEGIN
--            SET @useClientDisplayName = 1
--        END
	INSERT INTO  #idaInfoTbl ( clientId , clientName , appId ,  appName)
	SELECT DISTINCT A.CLIENTID,(CASE WHEN @useClientDisplayName = 1 THEN C1.displayname ELSE C1.name END)  ,C.appTypeId, itype.displayName
	FROM APP_Application A (NOLOCK)
	INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = A.CLIENTID AND A.APPTYPEID = C.APPTYPEID AND C.CCRId = @i_CCRId
	INNER JOIN APP_Client C1 (NOLOCK) ON C1.Id = A.CLIENTID AND C1.Id = C.ClientId
	INNER JOIN APP_IDAName idaname  (NOLOCK)  on idaname.clientId=C1.Id AND A.APPTYPEID = idaname.APPTYPEID
	INNER JOIN  APP_iDAType itype on itype.type=idaname.appTypeId
WHERE C.appTypeId IN  ( 137,106,78, 38,
61,22,62,
37,80,3,5
						  )
	AND C.CCRId = @i_CCRId
	UNION
	SELECT DISTINCT  C1.Id,
                 (CASE WHEN @useClientDisplayName = 1 THEN C1.displayname ELSE C1.name END),
				 simPackageID,
CASE WHEN simPackageID in (808, 854) THEN 'Work Flow' ELSE 'MongoDB' END
	FROM SimInstalledPackages    pkgTbl (NOLOCK)
	INNER JOIN CCRToSubClient C (NOLOCK) ON C.ClientId = pkgTbl.CLIENTID AND  C.CCRId = @i_CCRId
	INNER JOIN APP_Client C1 (NOLOCK) ON C1.Id = pkgTbl.CLIENTID AND C1.Id = C.ClientId
	WHERE pkgTbl.OpType IN ('Install', 'Reinstall', 'Release Upgrade', 'Package Sync')
AND simPackageId in (808, 854, 952, 1604) AND pkgTbl.HighestSP>14
	SET @response = (SELECT clientId  '@clientId',
                            clientName '@clientName' ,
                            appId  '@applicationId',
                            I.appName        '@appName', 4 as "@_type_"
						FROM #idaInfoTbl I order by appId,clientName asc
                    FOR XML PATH('IdaEntity'),root('Rpt_RptCCRIDAApplicationCheck'))
	DROP TABLE #idaInfoTbl
SELECT @response
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCCRIDAApplicationCheck')
	delete from GxQscripts where name = 'RptGetCCRIDAApplicationCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCCRIDAApplicationCheck')
	delete from GXDBVersions where aliasname = 'RptGetCCRIDAApplicationCheck'
GO

insert into GXDBVersions values(2, 'RptGetCCRIDAApplicationCheck',  '00010001000200060000', 'RptGetCCRIDAApplicationCheck', '00010001000200060000')
GO

