

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetBackupsetSLA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetBackupsetSLA.sp,v $ $Id: RptGetBackupsetSLA.sp,v 1.1.2.7 2020/10/27 16:15:06 junlu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetBackupsetSLA')
BEGIN
	print '>>> Drop Stored Procedure: RptGetBackupsetSLA <<<'
	drop procedure RptGetBackupsetSLA
END
IF EXISTS (select * from GxQscripts where name='RptGetBackupsetSLA')
	delete from GxQscripts where name = 'RptGetBackupsetSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetBackupsetSLA')
	delete from GXDBVersions where aliasname = 'RptGetBackupsetSLA'
GO
print '... Creating Procedure: RptGetBackupsetSLA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetBackupsetSLA
-- Stored Procedure Inputs
  @user_id INT = 1,
  @sla_days INT = -1,
  @full_only INT = 0,
  @end_date DATE = NULL
AS
SET NOCOUNT ON
/* These tables can be created by caller for results */
IF OBJECT_ID('tempdb.dbo.#SubclientSLA') IS NULL
	CREATE TABLE #SubclientSLA (clientId INT, isVM INT, appTypeId INT, appId INT, days INT, slaDaysLevel VARCHAR(32), protected INT, category INT, lastCheckTime INT)
IF OBJECT_ID('tempdb.dbo.#ExcludedEntity') IS NULL
	CREATE TABLE #ExcludedEntity (clientId INT, isVM INT, clientGroupId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, planId INT,
		category INT, installedTime INT, lastProtectedTime INT, lastOnlineTime INT, lastOfflineTime INT, isOnline VARCHAR(8), slaDays INT,
		clientType VARCHAR(32), ExcludedReason NVARCHAR(MAX))
/* These tables can only be created by caller for results
IF OBJECT_ID('tempdb.dbo.#BackupsetSLA') IS NOT NULL DROP TABLE #BackupsetSLA
CREATE TABLE #BackupsetSLA (appTypeId INT, backupsetId INT, category INT, slaDays INT)
*/
IF OBJECT_ID('tempdb.dbo.#VisibleClients') IS NOT NULL DROP TABLE #VisibleClients
CREATE TABLE #VisibleClients (clientId INT)
IF OBJECT_ID('tempdb.dbo.#VisibleObjects') IS NOT NULL DROP TABLE #VisibleObjects
create table  #VisibleObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @user_id, 2013, 0, '#VisibleObjects'
DECLARE @AppTypeTbl TABLE (appTypeId INT)
INSERT	INTO @AppTypeTbl VALUES (78)
IF EXISTS (
	SELECT 1 FROM #VisibleObjects
	WHERE	commCellId=2 AND clientGroupId=0 AND clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0
		AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND reviewSetId=0
		AND querySetId=0 AND downloadSetId=0 AND ermId=0 AND legalHoldId=0 AND tagId=0 AND cdPolicyId=0 AND complianceReportId=0
		AND taskId=0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0
		AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
	) --commcell level associations
BEGIN
	INSERT	INTO #SubclientSLA
	SELECT	clientId, 0, appTypeId, appId, CASE WHEN @sla_days = -1 THEN slaDays ELSE @sla_days END, slaDaysLevel,
			CASE WHEN category IN (1,13) THEN 1 ELSE 0 END, category, lastSeenTime
	FROM	RptSLASubclient WITH (NOLOCK)
	WHERE	fullJobsOnly = @full_only AND appTypeId IN (SELECT appTypeId FROM @AppTypeTbl) AND category IN (1,13, 2,3,4,9,12)
	IF OBJECT_ID('tempdb.dbo.#ExcludedEntity') IS NOT NULL
	INSERT	INTO #ExcludedEntity
	SELECT	DISTINCT E.clientId, 0, E.clientGroupId, E.appTypeId, E.instanceId, E.backupsetId, E.appId, E.planId,
			E.category, 0, 0, -1, -1, 'N/A', @sla_days, 'Server', ''
	FROM	RptSLAExclusion E WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK) ON E.clientId = A.clientId AND E.appTypeId IN (0, A.appTypeId)
	WHERE	A.appTypeId IN (SELECT appTypeId FROM @AppTypeTbl)
END
ELSE
BEGIN
	INSERT	INTO #SubclientSLA
	SELECT	S.clientId, 0, S.appTypeId, S.appId, CASE WHEN @sla_days = -1 THEN S.slaDays ELSE @sla_days END, S.slaDaysLevel,
			CASE WHEN S.category IN (1,13) THEN 1 ELSE 0 END, S.category, S.lastSeenTime
	FROM	RptSLASubclient S WITH (NOLOCK)
			INNER JOIN (
				SELECT	DISTINCT clientId
				FROM	APP_ClientGroupAssoc WITH (NOLOCK)
				WHERE	clientGroupId IN (SELECT clientGroupId FROM #VisibleObjects WHERE clientGroupId > 0)
				UNION
				SELECT	DISTINCT clientId
				FROM	#VisibleObjects
				WHERE	clientId > 0 AND appTypeId = 0
			) T ON S.clientId = T.clientId
	WHERE	S.fullJobsOnly = @full_only AND S.appTypeId IN (SELECT appTypeId FROM @AppTypeTbl) AND S.category IN (1,13, 2,3,4,9,12)
	UNION
	SELECT	S.clientId, 0, S.appTypeId, S.appId, CASE WHEN @sla_days = -1 THEN S.slaDays ELSE @sla_days END, S.slaDaysLevel,
			CASE WHEN S.category IN (1,13) THEN 1 ELSE 0 END, S.category, S.lastSeenTime
	FROM	RptSLASubclient S WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
			INNER JOIN #VisibleObjects O ON O.clientId = A.clientId AND O.appTypeId = A.appTypeId
	WHERE	S.fullJobsOnly = @full_only AND S.appTypeId IN (SELECT appTypeId FROM @AppTypeTbl) AND S.category IN (1,13, 2,3,4,9,12)
		AND O.instanceId IN (0, A.instance) AND O.backupsetId IN (0, A.backupset) AND O.subclientId IN (0, A.id)
	IF OBJECT_ID('tempdb.dbo.#ExcludedEntity') IS NOT NULL
	INSERT	INTO #ExcludedEntity
	SELECT	E.clientId, 0, E.clientGroupId, E.appTypeId, E.instanceId, E.backupsetId, E.appId, E.planId,
			E.category, 0, 0, -1, -1, 'N/A', @sla_days, 'Server', ''
	FROM	RptSLAExclusion E WITH (NOLOCK)
			INNER JOIN #VisibleObjects O ON O.clientId = E.clientId AND O.appTypeId = E.appTypeId
	WHERE	O.instanceId IN (0, E.instanceId) AND O.backupsetId IN (0, E.backupsetId) AND O.subclientId IN (0, E.appId)
END
DELETE	S
FROM	#SubclientSLA S
		INNER JOIN RptSLAExclusion E WITH (NOLOCK) ON S.ClientId = E.clientId
WHERE	E.appTypeId IN (0, S.AppTypeId) AND E.appId IN (0, S.AppId)
DELETE	S
FROM	#SubclientSLA S
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON S.ClientId = CP.componentNameId
			AND CP.attrName = 'Office 365 Pseudo Client' AND CP.attrVal = '1' AND CP.modified = 0
WHERE	S.AppTypeId = 78
IF @sla_days > 0 OR @end_date IS NOT NULL
BEGIN
	IF @end_date IS NULL
		SET @end_date = GETDATE()
	DECLARE @from_date DATE = DATEADD(DAY, -@sla_days, @end_date)
	UPDATE	T SET category = ISNULL(CASE U.category WHEN 0 THEN 1 ELSE U.category END, CASE T.category WHEN 4 THEN 4 ELSE 3 END)
	FROM	#SubclientSLA T
			INNER JOIN (
				SELECT	A.appId, MIN(S.category%13) AS category
				FROM	#SubclientSLA A
						LEFT OUTER JOIN RptSLA S WITH (NOLOCK) ON A.appId = S.appId
							AND	S.fullJobsOnly = @full_only AND S.date BETWEEN @from_date AND @end_date
				GROUP BY A.appId
			) U ON T.appId = U.appId
	IF EXISTS (SELECT 1 FROM #SubclientSLA WHERE category = 3)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tblSubclient') IS NOT NULL DROP TABLE #tblSubclient
		CREATE TABLE #tblSubclient (ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, BackupScheduled INT)
		INSERT	INTO #tblSubclient
		SELECT	A.clientId, A.appTypeId, A.instance, A.backupset, A.id, 0
		FROM	#SubclientSLA S
				INNER JOIN APP_Application A WITH (NOLOCK) ON S.AppId = A.id
		WHERE	S.category = 3
		EXEC RptBackupScheduledSubclients 0
		UPDATE	S SET category = 4
		FROM	#SubclientSLA S
				INNER JOIN #tblSubclient T ON S.AppId = T.AppId AND T.BackupScheduled = 0
	END
END
IF OBJECT_ID('tempdb.dbo.#BackupsetSLA') IS NOT NULL
INSERT	INTO #BackupsetSLA
SELECT	A.appTypeId, A.backupset, MAX(CASE S.category WHEN 2 THEN 102 ELSE S.category END)%100, MIN(S.days)
FROM	#SubclientSLA S
		INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
GROUP BY A.appTypeId, A.backupset
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetBackupsetSLA')
	delete from GxQscripts where name = 'RptGetBackupsetSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetBackupsetSLA')
	delete from GXDBVersions where aliasname = 'RptGetBackupsetSLA'
GO

insert into GXDBVersions values(2, 'RptGetBackupsetSLA',  '00010001000200070000', 'RptGetBackupsetSLA', '00010001000200070000')
GO

