

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetAuxCopySourceMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetAuxCopySourceMedia.sp,v $ $Id: rptGetAuxCopySourceMedia.sp,v 1.6.208.2 2018/03/22 03:01:52 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptGetAuxCopySourceMedia"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetAuxCopySourceMedia')
BEGIN
	print '>>> Drop Stored Procedure: rptGetAuxCopySourceMedia <<<'
	drop procedure rptGetAuxCopySourceMedia
END
IF EXISTS (select * from GxQscripts where name='rptGetAuxCopySourceMedia')
	delete from GxQscripts where name = 'rptGetAuxCopySourceMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetAuxCopySourceMedia')
	delete from GXDBVersions where aliasname = 'rptGetAuxCopySourceMedia'
GO
print '... Creating Procedure: rptGetAuxCopySourceMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetAuxCopySourceMedia
  @i_CopyId integer
AS
  DECLARE @o_streamNum INTEGER;
  DECLARE @o_mediaId INTEGER;
  DECLARE @o_Media VARCHAR(2050);
DECLARE @spId		integer
DECLARE @srcCopyId	integer
DECLARE @tblDstCopy	TABLE (dstCopyId int)
DECLARE @tblJob		TABLE (jobId int, commCellId int, dataType int)
DECLARE @tblAFile	TABLE (id int, commCellId int)
DECLARE @tblSrcAFile	TABLE (archFileId int, commCellId int, streamNum int)
DECLARE @tblSrcChunk	TABLE (acCommCellId int, archChunkId int, afCommCellId int, archFileId int, streamNum int, volId int, mediaId int)
DECLARE @tblSrcMedia	TABLE (mediaId int, streamNum int, archChunkId int, name varchar(1024))
SELECT	@spId = id, @srcCopyId = defaultCopy
FROM	archGroup WITH (READUNCOMMITTED)
WHERE	id = (select archGroupId from archGroupCopy WITH (READUNCOMMITTED) where id = @i_CopyId)
IF @i_CopyId = @srcCopyId
	INSERT INTO @tblDstCopy
	SELECT id FROM archGroupCopy WITH (READUNCOMMITTED) WHERE archGroupId = @spId AND id <> @i_CopyId
ELSE
	INSERT INTO @tblDstCopy VALUES(@i_CopyId)
INSERT INTO @tblJob
SELECT jobId, commCellId, dataType
FROM   JMJobDataStats WITH (READUNCOMMITTED)
WHERE  archGrpCopyId IN (select dstCopyId from @tblDstCopy) AND status IN (101, 102, 103) AND (disabled & 1) = 0
DELETE @tblJob
FROM   @tblJob T, JMJobDataStats J WITH (READUNCOMMITTED)
WHERE  J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.dataType = T.dataType AND
      J.archGrpCopyId = @srcCopyId AND (J.status <> 100 OR (J.disabled & 1) <> 0)
INSERT INTO @tblAFile
SELECT F.id, F.commCellId
FROM   @tblJob J, archFile F WITH (READUNCOMMITTED)
WHERE  F.jobId = J.jobId AND F.commCellId = J.commCellId AND
      F.fileType = J.dataType AND F.archGroupId = @spId AND
      (F.isValid = 1 OR F.appId IN (SELECT id FROM app_application WHERE appTypeId NOT IN
      (2,3,4,5,9,13,15,16,22,23,26,27,28,30,31,32,37,47,49,50,53,61,62,1000)))
DELETE @tblAFile
FROM   @tblAFile T, archFileCopy F WITH (READUNCOMMITTED)
WHERE  F.archFileId = T.id AND F.commCellId = T.commCellId AND F.archCopyId IN (select dstCopyId from @tblDstCopy)
      AND F.isValid = 1
INSERT INTO @tblSrcAFile
SELECT F.archFileId, F.commCellId, F.streamNum
FROM   @tblAFile T, archFileCopy F WITH (READUNCOMMITTED)
WHERE  F.archFileId = T.id AND F.commCellId = T.commCellId AND F.archCopyId = @srcCopyId
      AND F.isValid = 1
INSERT INTO @tblSrcChunk
SELECT A.chunkCommCellId, A.archChunkId, A.commCellId, A.archFileId, T.streamNum, 0, 0
FROM   @tblSrcAFile T, archChunkMapping A WITH (READUNCOMMITTED)
WHERE  A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = @srcCopyId
UPDATE @tblSrcChunk SET volId = A.volumeId
FROM   @tblSrcChunk T, archChunk A WITH (READUNCOMMITTED)
WHERE  A.id = T.archChunkId AND A.commCellId = T.acCommCellId
UPDATE @tblSrcChunk
SET mediaId = (SELECT MediaId FROM MMVolume WITH (READUNCOMMITTED) WHERE VolumeId=volId)
INSERT INTO @tblSrcMedia
SELECT	mediaId, streamNum, MIN(archChunkId), (select M.barcode from MMMedia M WITH (READUNCOMMITTED) where M.MediaId=T.mediaId)
FROM   @tblSrcChunk T
GROUP BY mediaId, streamNum
UPDATE @tblSrcMedia
SET	name = P.MountPathName
FROM	@tblSrcMedia T, MMMediaSide M WITH (READUNCOMMITTED), MMS2getMountPathNameGUIView P WITH (READUNCOMMITTED)
WHERE  T.name = 'CV_MAGNETIC' AND T.mediaId = M.mediaId AND M.MediaSideId = P.MediaSideId
SELECT streamNum, mediaId, name FROM @tblSrcMedia
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetAuxCopySourceMedia')
	delete from GxQscripts where name = 'RptGetAuxCopySourceMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetAuxCopySourceMedia')
	delete from GXDBVersions where aliasname = 'RptGetAuxCopySourceMedia'
GO

insert into GXDBVersions values(2, 'RptGetAuxCopySourceMedia',  '00010006020800020000', 'RptGetAuxCopySourceMedia', '00010006020800020000')
GO

