

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetAssociatedEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetAssociatedEntities.sp,v $ $Id: RptGetAssociatedEntities.sp,v 1.10.14.10 2018/11/18 03:51:49 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "MMSummPageGetStoragePolicies"	|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetAssociatedEntities')
BEGIN
	print '>>> Drop Stored Procedure: RptGetAssociatedEntities <<<'
	drop procedure RptGetAssociatedEntities
END
IF EXISTS (select * from GxQscripts where name='RptGetAssociatedEntities')
	delete from GxQscripts where name = 'RptGetAssociatedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetAssociatedEntities')
	delete from GXDBVersions where aliasname = 'RptGetAssociatedEntities'
GO
print '... Creating Procedure: RptGetAssociatedEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetAssociatedEntities
  @i_userId INTEGER,
  @inputxml XML
AS
BEGIN
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
declare @responsesList table
(
	response xml
)
DECLARE @xml xml
DECLARE @entityType int
DECLARE @reportType int
DECLARE @commcellParam int
DECLARE @includeHiddenSPs int = 0
DECLARE @includeHiddenLibraries int = 0
DECLARE @includeGlobalSPs int = 0
DECLARE @entityFilters int = 0
SET @commcellParam = 2
SET @entityType = ISNULL (( SELECT ref.value('@entityType', 'INTEGER')
	  FROM @inputxml.nodes('App_GenericEntityReq') R(ref)), 1)
SET @reportType = ISNULL (( SELECT ref.value('@reportType', 'INTEGER')
	  FROM @inputxml.nodes('App_GenericEntityReq') R(ref)), 1)
SET @entityFilters = ISNULL (( SELECT ref.value('@entityFilters', 'INTEGER')
	  FROM @inputxml.nodes('App_GenericEntityReq') R(ref)), 0)
IF object_id('tempdb.dbo.#tblSecObjForUser') is not null DROP TABLE #tblSecObjForUser
create table  #tblSecObjForUser ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
DECLARE @secObjectType	INTEGER
DECLARE @secObjectCap	BIGINT
EXEC sec_updateUserCredentials @i_userId
IF OBJECT_ID('tempdb.dbo.#RptGetAssociatedEntities_userObject') IS NOT null
   DROP TABLE #RptGetAssociatedEntities_userObject
create table  #RptGetAssociatedEntities_userObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 0, 0, '#RptGetAssociatedEntities_userObject'
--Storage Policies, NAS Storage Policies
if @entityType IN (16, 17)
begin
	IF (@entityFilters & 1) = 1
		SET @includeHiddenSPs = 1
	IF (@entityFilters & 2) = 2
		SET @includeGlobalSPs = 1
	declare @storagePolicyIds table
	(
		storagePolicyId int
	)
if @reportType = 7770
	begin
		INSERT INTO @storagePolicyIds
		SELECT AG.id
		FROM MMDrivePool DP WITH (READUNCOMMITTED)
        INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED) ON  DP.DrivePoolId = DPath.DrivePoolId
        INNER JOIN MMMasterPool MP WITH (READUNCOMMITTED) ON MP.MasterPoolId = DP.MasterPoolId AND DP.NDMPHostId > 0
        INNER JOIN MMLibrary ML WITH (READUNCOMMITTED) ON ML.LibraryId = MP.LibraryId
        INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON DPath.copyId = AG.defaultCopy
        INNER JOIN archAgingRule AR WITH (READUNCOMMITTED) ON AR.copyId = AG.defaultCopy
WHERE AG.id!=1 AND AG.type <> 2
	end
else if @entityType IN (16)
	begin
		INSERT INTO @storagePolicyIds
		SELECT  id
		FROM archGroup WITH (READUNCOMMITTED)
WHERE id!=1 AND type IN (1 , 2 )
	end
	--CVA_SP_FREEZE_ASSOCIATION_FLAG to check whether storage policy is disabled or not.
	INSERT INTO @responsesList
	SELECT IsNull((SELECT AG.id as 'entityInfo/@id',
	AG.name as 'entityInfo/@name',
	CASE
WHEN (@entityType = 16 AND @reportType <> 7770) THEN
	(
        -- Use a sub query for child elements.
        SELECT
            id as '@id',
			name as '@name'
        FROM
            archGroupCopy AGC WITH (READUNCOMMITTED)
        WHERE
AGC.archGroupId = AG.id AND AGC.type <> 5
        FOR
            XML PATH('childEntityInfo'), -- The element name for each row.
            TYPE -- Column is typed so it nests as XML, not text.
    )
    END
	FROM archGroup AG WITH (READUNCOMMITTED)
WHERE (@includeHiddenSPs = 1 OR (AG.flags & 64) = 0)
and (@includeGlobalSPs = 1 OR (((AG.flags & 256) = 0) AND ((AG.flags & 16384) = 0) AND ((AG.flags & 8388608) = 0)))
	and AG.type <> 4
	and AG.id in
	(
		SELECT storagePolicyId FROM @storagePolicyIds
	)
and exists(SELECT 1 FROM #RptGetAssociatedEntities_userObject sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
				UNION
			SELECT 1 FROM #RptGetAssociatedEntities_userObject	WHERE commCellId  = @commcellParam
				AND (archGroupId = -10  OR archGroupId = AG.id)
				)
	order by AG.name asc
	for xml path('response'),root('App_GenericEntityResp')),'<App_GenericEntityResp/>')
end
--Libraries, Location Libraries (VTL)
if @entityType IN (8, 9)
begin
	IF (@entityFilters & 4) = 4
		SET @includeHiddenLibraries = 1
	DELETE FROM #tblSecObjForUser
	DECLARE @tblSecLibrary table (LibraryId int)
	DECLARE @allLibrary INTEGER = 0
SET @secObjectType = 2049
	EXEC sec_getUserObjects @i_userId, @secObjectType, 0, '#tblSecObjForUser'
IF EXISTS (SELECT * FROM #tblSecObjForUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
		SET @allLibrary = 1
	ELSE
		INSERT INTO @tblSecLibrary SELECT LibraryId FROM #tblSecObjForUser
	IF @allLibrary = 0 AND EXISTS (SELECT * FROM MMConfigs WHERE NAME = 'MMS2_CONFIG_CHECK_USER_MA_RIGHT' AND value = 1)
	BEGIN
		DELETE FROM #tblSecObjForUser
		DECLARE @tblSecMediaAgentMgr table (MediaAgentId int)
SET @secObjectType = 2048
SET @secObjectCap = power(2, 10-1)
		EXEC sec_getUserObjects @i_userId, @secObjectType, 0, '#tblSecObjForUser'
		--Must be able to manage media agent
		DELETE FROM #tblSecObjForUser WHERE capabilities & (@secObjectCap) = 0
IF EXISTS (SELECT * FROM #tblSecObjForUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
			SET @allLibrary = 1
		ELSE
			INSERT INTO @tblSecMediaAgentMgr SELECT MediaAgentId from #tblSecObjForUser
		INSERT INTO @tblSecLibrary
		SELECT DISTINCT A.LibraryId
		FROM MMLibraryController A with (nolock), @tblSecMediaAgentMgr B
		WHERE A.ClientId = B.MediaAgentId
		AND A.LibraryId NOT IN (SELECT LibraryId FROM @tblSecLibrary)
	END
	IF @allLibrary = 1
		INSERT INTO @tblSecLibrary
		SELECT LibraryId
		FROM MMLibrary with (nolock)
WHERE 	libraryid > 0 AND libraryTypeId <> 8 AND libraryTypeId <> 10
	declare @libraryIds table
	(
		libraryId int
	)
if @entityType=9 AND @reportType = 7767
	begin
		INSERT INTO @libraryIds
		SELECT  LibraryId
		FROM    MMLibrary WITH (READUNCOMMITTED)
WHERE (BarCodeReaderPresent > 0 and LibraryTypeId = 1) or LibraryTypeId = 4
	end
else if @entityType = 8 AND @reportType = 7756
	begin
		INSERT INTO @libraryIds
		SELECT L.LibraryId
		FROM MMSpareGroup S WITH(READUNCOMMITTED) INNER JOIN MMLibrary L WITH(READUNCOMMITTED) ON L.LibraryId = S.LibraryId
		WHERE S.SpareGroupId >0
			AND S.SpareGroupType IN (1,2,32)
AND L.LibraryTypeId NOT IN (4, 5, 10)
	end
else if @entityType = 8
	begin
		INSERT INTO @libraryIds
		SELECT  LibraryId
		FROM    MMLibrary WITH (READUNCOMMITTED)
WHERE libraryTypeId <> 8 AND libraryTypeId <> 10
	end
	INSERT INTO @responsesList
	SELECT IsNull((select L.LibraryId as 'entityInfo/@id',
		L.AliasName as 'entityInfo/@name',
		CASE
WHEN (@entityType = 8 AND @reportType = 7756 ) THEN
		(
			-- Use a sub query for child elements.
			SELECT
				S.SpareGroupId as '@id',
				S.SpareGroupName as '@name'
			FROM
				MMSpareGroup S WITH (READUNCOMMITTED)
			WHERE
				S.LibraryId = L.LibraryId
				AND S.SpareGroupId >0
				AND S.SpareGroupType IN (1,2,32)
			FOR
				XML PATH('childEntityInfo'), -- The element name for each row.
				TYPE -- Column is typed so it nests as XML, not text.
		)
		END
		FROM MMLibrary L WITH (READUNCOMMITTED)
WHERE (@includeHiddenLibraries = 1 OR (L.ExtendedAttributes & 33554432) = 0 ) AND
		LibraryId in
		(
			SELECT libraryId FROM @libraryIds
		)
		and L.LibraryId > 0
			-- Now return only mediaAgents which are accessibile
		AND L.LibraryId IN (SELECT libraryId FROM @tblSecLibrary)
		order by L.LibraryId desc
		for xml path('response'),root('App_GenericEntityResp')),'<App_GenericEntityResp/>')
end
--Mediaagents
if @entityType=10 OR @entityType=11
begin
	DELETE FROM #tblSecObjForUser
	DECLARE @tblSecMediaAgent table (MediaAgentId int)
SET @secObjectType = 2048
	EXEC sec_getUserObjects @i_userId, @secObjectType, 0, '#tblSecObjForUser'
IF EXISTS (SELECT * FROM #tblSecObjForUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
		INSERT INTO @tblSecMediaAgent SELECT clientId FROM MMHost WITH (READUNCOMMITTED)
	ELSE
		INSERT INTO @tblSecMediaAgent SELECT MediaAgentId from #tblSecObjForUser
	declare @mediaAgentIds table
	(
		mediaAgentId int
	)
	--INSERT INTO @mediaAgentIds
	--SELECT  ref.value('@mediaAgentId', 'int') AS Agent
	--FROM    @inputxml.nodes('App_GetAssociatedEntities/entity') R ( ref )
	-- If the level is 10,_ALL_MEDIAAGENTS_ then add all mediaAgents to the array.
	if @entityType=10
	begin
		INSERT INTO @mediaAgentIds
		SELECT clientId FROM MMHost WITH (READUNCOMMITTED)
	end
	INSERT INTO @responsesList
	select IsNull((
		SELECT distinct mh.clientid as 'entityInfo/@id',
		cl.displayName as 'entityInfo/@name'
		FROM  MMHost as mh WITH (READUNCOMMITTED), APP_Client as cl WITH (READUNCOMMITTED)
		WHERE  mh.clientid = cl.id and mh.clientid > 1
		-- and mh.MmHostEnabled = 1 -- We want only enabled media agents
		and cl.id not in (SELECT APP_VMToPMMap.PMClientId FROM APP_VMToPMMap WITH (READUNCOMMITTED) WHERE APP_VMToPMMap.VMClientId = 2)
		and mh.ClientId in
		(
			SELECT mediaAgentId FROM @mediaAgentIds
		)
		and mh.ClientId IN (SELECT mediaAgentId from @tblSecMediaAgent)
		order by mh.clientId desc
		for XML PATH('response'), root('App_GenericEntityResp')),'<App_GenericEntityResp/>')
end
--Vault Tracking Policies
if @entityType=20 OR @entityType=21
begin
    IF object_id('tempdb.dbo.#rptVTUserObjects') IS NOT null DROP TABLE #rptVTUserObjects
create table  #rptVTUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 8462, 0, '#rptVTUserObjects'    -- Vault tracker policies only
	DECLARE @CCHECK INT
IF EXISTS (SELECT * FROM #rptVTUserObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	  SET @CCHECK = 1
	ELSE
	  SET @CCHECK = 0
	INSERT INTO @responsesList
	SELECT IsNull((SELECT PolicyId as 'entityInfo/@id',
		PolicyName as 'entityInfo/@name'
		FROM VTPolicy vtp WITH (READUNCOMMITTED), #rptVTUserObjects vtPolicyViewable
		WHERE
		  (@CCHECK = 1 OR vtp.PolicyId = vtPolicyViewable.vtPolicyId)
		  and vtp.PolicyId > 0
		  group by PolicyId, PolicyName
		ORDER by vtp.PolicyId desc
		for xml path('response'),root('App_GenericEntityResp')),'<App_GenericEntityResp/>')
    DROP TABLE #rptVTUserObjects
end
--Media Repository
if @entityType=57
begin
	DELETE FROM #tblSecObjForUser
	DECLARE @tblSecShelf table (vtShelfId int)
SET @secObjectType = 8180
	EXEC sec_getUserObjects @i_userId, @secObjectType, 0, '#tblSecObjForUser'
IF EXISTS (SELECT * FROM #tblSecObjForUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
		INSERT INTO @tblSecShelf
		SELECT LibraryId
		from MMLibrary with (nolock)
WHERE 	libraryid > 0 AND libraryTypeId = 8
	ELSE
		INSERT INTO @tblSecShelf SELECT vtShelfId from #tblSecObjForUser
	declare @shelfLibraryIds table
	(
		shelfLibraryId int
	)
	if @entityType=57
	begin
		INSERT INTO @shelfLibraryIds
		SELECT  LibraryId
		FROM    MMLibrary WITH (READUNCOMMITTED)
	end
	INSERT INTO @responsesList
	SELECT IsNull((SELECT LibraryId as 'entityInfo/@id',
		AliasName as 'entityInfo/@name'
		FROM MMLibrary WITH (READUNCOMMITTED)
		WHERE --LibraryEnabled=1 and
		LibraryId in
		(
			SELECT libraryId FROM @shelfLibraryIds
		)
and LibraryId > 0 and libraryTypeId = 8
		and LibraryId in ( select vtShelfId from @tblSecShelf)
		order by MMLibrary.LibraryId desc
		for xml path('response'),root('App_GenericEntityResp')),'<App_GenericEntityResp/>')
end
--Export Location
if @entityType=53
begin
	DELETE FROM #tblSecObjForUser
	DECLARE @tblSecLocation table (locationId int)
set @secObjectType = 8464
	EXEC sec_getUserObjects @i_userId, @secObjectType, 0, '#tblSecObjForUser'
IF EXISTS (SELECT * FROM #tblSecObjForUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
		INSERT INTO @tblSecLocation SELECT ExportLocationId from MMExportLocation
	ELSE
		INSERT INTO @tblSecLocation SELECT entityId1 from #tblSecObjForUser
	declare @locationIds table
	(
		locationId int
	)
	if @entityType=53
	begin
		INSERT INTO @locationIds
		SELECT  ExportLocationId
		FROM    MMExportLocation WITH (READUNCOMMITTED)
	end
	INSERT INTO @responsesList
	SELECT IsNull((SELECT ExportLocationId as 'entityInfo/@id',
		ExportLocation as 'entityInfo/@name'
		FROM MMExportLocation WITH (READUNCOMMITTED)
		WHERE --LibraryEnabled=1 and
		ExportLocationId in
		(
			SELECT locationId FROM @locationIds
		)
		and ExportLocationId IN (SELECT locationId FROM @tblSecLocation)
		order by MMExportLocation.ExportLocationId asc
		for xml path('response'),root('App_GenericEntityResp')),'<App_GenericEntityResp/>')
end
	SELECT @xml = (SELECT ISNULL((SELECT *
		FROM @responsesList),'</App_GenericEntityResp>'))
	SELECT @xml
IF OBJECT_ID('tempdb.dbo.#RptGetAssociatedEntities_userObject') IS NOT null
   DROP TABLE #RptGetAssociatedEntities_userObject
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetAssociatedEntities')
	delete from GxQscripts where name = 'RptGetAssociatedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetAssociatedEntities')
	delete from GXDBVersions where aliasname = 'RptGetAssociatedEntities'
GO

insert into GXDBVersions values(2, 'RptGetAssociatedEntities',  '00010010001400100000', 'RptGetAssociatedEntities', '00010010001400100000')
GO

