

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetArchGroupList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetArchGroupList.sp,v $ $Id: RptGetArchGroupList.sp,v 1.7.208.6 2018/11/01 01:33:28 chandru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : ""			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetArchGroupList')
BEGIN
	print '>>> Drop Stored Procedure: RptGetArchGroupList <<<'
	drop procedure RptGetArchGroupList
END
IF EXISTS (select * from GxQscripts where name='RptGetArchGroupList')
	delete from GxQscripts where name = 'RptGetArchGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetArchGroupList')
	delete from GXDBVersions where aliasname = 'RptGetArchGroupList'
GO
print '... Creating Procedure: RptGetArchGroupList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetArchGroupList
  @i_jobId integer
AS
  DECLARE @o_archGroupId integer;
  DECLARE @o_policyName NVARCHAR(255);
  DECLARE @o_incrSPName NVARCHAR(255);
  DECLARE @o_defCopyName NVARCHAR(255);
  DECLARE @o_timeZoneType integer;
  DECLARE @o_timeZoneName varchar(255);
  DECLARE @o_policyType integer;
  DECLARE @o_policyFlags integer;
  DECLARE @o_maxStreams integer;
  DECLARE @o_enabledCI integer;
  DECLARE @o_hasSnapCopy integer;
  DECLARE @o_hasDedupCopy integer;
  DECLARE @o_hasMediaPwd integer;
  DECLARE @o_userGroups varchar(MAX);
  DECLARE @o_controlHostId integer;
  DECLARE @o_controlHostName NVARCHAR(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#tempUGCList') IS NOT null DROP TABLE #tempUGCList
IF object_id('tempdb.dbo.#tempUserList') IS NOT null DROP TABLE #tempUserList
DECLARE @userId			integer
DECLARE @policyId		integer
DECLARE @tblPolicy		TABLE (archGroupId int)
SET @userId = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblPolicy EXEC rptOptGetObjectList @i_jobId, 1242473090, @policyId OUTPUT
IF	@policyId <= 0
BEGIN
	DELETE FROM @tblPolicy
INSERT INTO @tblPolicy SELECT id FROM archGroup WHERE id > 1 AND type <> 4
END
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @policyId <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2231, 0, '#rptUserObjects'	-- 2231 = ARCHIVE_GROUP_ITEM
	DELETE	#rptUserObjects
	WHERE	clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR libraryID <> 0
			OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0
			OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
			OR taskId <> 0
	DELETE	@tblPolicy
	WHERE	NOT EXISTS (SELECT * FROM #rptUserObjects WHERE archGroupID in (0, archGroupId))
	DROP TABLE #rptUserObjects
END
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
CREATE TABLE #tempUserGroupList(archGroupId integer, userGroupText text)
--get list of user UMGroups that have permissions on each SP
IF (dbo.isNewSecurity() = 0)
BEGIN
	DECLARE archGroupCur CURSOR FOR
		SELECT archGroupId FROM @tblPolicy
	OPEN archGroupCur
	FETCH NEXT FROM archGroupCur INTO @policyId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #tempUserGroupList
		EXEC rptGetUserGroups 2231, @policyId, 0, 0, 0, 0, 0, 0		-- 2231: ARCHIVE_GROUP_ITEM
		FETCH NEXT FROM archGroupCur INTO @policyId
	END
	CLOSE archGroupCur
	DEALLOCATE archGroupCur
END
ELSE
BEGIN
DECLARE @entityType1 INT = 17
	DECLARE @i_entityList XML
	SET @i_entityList = (SELECT
17  as '@entityType1',
	archGroupId  as '@entityId1'
	FROM   @tblPolicy
	for xml path('entity'),root('entityList') )
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
        DROP TABLE #tgroupObjects
--	THIS WILL GIVE ALL USERGROUP ASSOCIATED WITH THESE CLIENT WITHOUT USER SECURITY CHECK (USER ID IS NOT PASSED)
CREATE TABLE #tgroupObjects ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,17, @i_entityList,0,0,0,0
	-- USER SECURITY CHECK FOR THIS USER
	IF object_id('tempdb.dbo.#entityTable') is not null
		drop table #entityTable
	create table #entityTable
	(
		entityId int
	)
	 exec sec_getUserGroupsForThisUser '#entityTable', @userID
	IF object_id('tempdb.dbo.#usergroups') is not null
		drop table #usergroups
	CREATE table #usergroups (name nvarchar(max),archgroupId INT )
	INSERT INTO #usergroups
		select distinct UG.name,t.entityId1
	FROM	UMGroups UG INNER JOIN #tgroupObjects t ON
	UG.id = t.userORGroupId and t.isUSer = 0
	INNER JOIN #entityTable E ON
	UG.id = E.entityId
	drop table #entityTable
	INSERT INTO #tempUserGroupList
	Select distinct cg2.archgroupId,
    substring(
        (
            Select ','+cg1.name  AS [text()]
            From #usergroups cg1
            Where cg1.archgroupId = cg2.archgroupId
            ORDER BY cg1.archgroupId
            For XML PATH ('')
        ), 2, 1000) [groups]
	From #usergroups cg2
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
    DROP TABLE #tgroupObjects
	IF object_id('tempdb.dbo.#usergroups') is not null
		drop table #usergroups
END
SELECT	PolicyId		= AG.id,
		PolicyName		= AG.name,
		IncrSPName		= CASE WHEN AG.incrSP > 0 THEN (SELECT name FROM archGroup WHERE id = AG.incrSP) ELSE '' END,
		DefCopyName		= (SELECT name FROM archGroupCopy WHERE id = AG.defaultCopy),
		AG.timeZoneType,
		AG.timeZone,
		AG.type,
		AG.flags,
		AG.maxStreams,
		EnabledCI		= ISNULL((SELECT enabled FROM archContentIndexingRules WHERE archGroupId = AG.id), 0),
		HasSnapCopy		= ISNULL((SELECT TOP 1 id FROM archGroupCopy WHERE archGroupId = AG.id AND isSnapCopy = 1), 0),
HasDedupCopy	= ISNULL((SELECT TOP 1 id FROM archGroupCopy AGC WHERE archGroupId = AG.id AND ((AGC.dedupeFlags & 262144) > 0)), 0),
		HasMediaPwd		= CASE WHEN AG.mediaPassword = '' THEN 0 ELSE 1 END,
		UserGroups		= ISNULL(UG.userGroupText, ''),
		ControlHostId   = CH.ControlHostId,
		ControlHostName = CH.SMArrayId
FROM	archGroup AG
		INNER JOIN @tblPolicy P ON AG.id = P.archGroupId
		LEFT OUTER JOIN #tempUserGroupList UG ON AG.id = UG.archGroupId
		LEFT OUTER JOIN ArchGroupControlHost AC ON AG.id = AC.archGroupId
		LEFT OUTER JOIN SMControlHost CH ON AC.ControlHostId = CH.ControlHostId
ORDER BY AG.name
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetArchGroupList')
	delete from GxQscripts where name = 'RptGetArchGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetArchGroupList')
	delete from GXDBVersions where aliasname = 'RptGetArchGroupList'
GO

insert into GXDBVersions values(2, 'RptGetArchGroupList',  '00010007020800060000', 'RptGetArchGroupList', '00010007020800060000')
GO

