

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetArchGroupCopyList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetArchGroupCopyList.sp,v $ $Id: RptGetArchGroupCopyList.sp,v 1.31.36.7 2020/01/13 22:44:50 chandru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : ""			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetArchGroupCopyList')
BEGIN
	print '>>> Drop Stored Procedure: RptGetArchGroupCopyList <<<'
	drop procedure RptGetArchGroupCopyList
END
IF EXISTS (select * from GxQscripts where name='RptGetArchGroupCopyList')
	delete from GxQscripts where name = 'RptGetArchGroupCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetArchGroupCopyList')
	delete from GXDBVersions where aliasname = 'RptGetArchGroupCopyList'
GO
print '... Creating Procedure: RptGetArchGroupCopyList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetArchGroupCopyList
  @i_policyIdsXml xml
AS
  DECLARE @o_policyId integer;
  DECLARE @o_policyName NVARCHAR(255);
  DECLARE @o_defaultCopy integer;
  DECLARE @o_policyFlags integer;
  DECLARE @o_copyId integer;
  DECLARE @o_copyName NVARCHAR(255);
  DECLARE @o_isDefaultCopy integer;
  DECLARE @o_sourceCopyId integer;
  DECLARE @o_sourceCopyName NVARCHAR(255);
  DECLARE @o_isExtCommCell integer;
  DECLARE @o_copyType integer;
  DECLARE @o_copyFlags integer;
  DECLARE @o_dedupeFlags integer;
  DECLARE @o_isSnapCopy integer;
  DECLARE @o_isActive integer;
  DECLARE @o_startTime integer;
  DECLARE @o_deferredDays integer;
  DECLARE @o_multiplex integer;
  DECLARE @o_maxStreamNum integer;
  DECLARE @o_encType integer;
  DECLARE @o_encKeyLen integer;
  DECLARE @o_ValidPeriod integer;
  DECLARE @o_calendar nvarchar(255);
  DECLARE @o_hasSchedule integer;
  DECLARE @MR_refreshingDays integer;
  DECLARE @MR_minDaysToRetain integer;
  DECLARE @MR_usePercentage integer;
  DECLARE @o_totPathNum integer;
  DECLARE @o_dataPathFlag integer;
  DECLARE @o_HWEncryption integer;
  DECLARE @o_HWCompression integer;
  DECLARE @o_mediaAgentName nvarchar(255);
  DECLARE @o_libraryName NVARCHAR(255);
  DECLARE @o_spareGroupName NVARCHAR(255);
  DECLARE @o_masterPoolName NVARCHAR(255);
  DECLARE @o_drivePoolName NVARCHAR(255);
  DECLARE @o_mediaAgentDisplayName nvarchar(255);
  DECLARE @o_ValidPeriodType integer;
  DECLARE @o_endTime integer;
-- CopyType
-- 0: Primary
-- 1: Synchronous
-- 2: Selective
-- 3: Primary Snap
-- 4: Snap Mirror
-- 5: Snap Vault
-- 6: SILO
-- 7: Secondary SILO
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #tempPolicyIds (archGroupId int)
CREATE TABLE #tempAGCopyList
(
	policyId		INT,
	policyName		NVARCHAR(1024),
	defaultCopy		INT,
	policyFlags		INT,
	copyId			INT,
	copyName		NVARCHAR(1024),
	isDefaultCopy	INT,
	sourceCopyId	INT,
	isExtCommCell	INT,
	copyType		INT,
	copyFlags		INT,
	dedupeFlags		INT,
	isSnapCopy		INT,
	isActive		INT,
	startTime		INT,
	delayedDays		INT,
	maxMultiplex	INT,
	maxStreamNum	INT,
	encType			INT,
	encKeyLen		INT,
	archCheckValidPeriod	INT,
	archCheckValidPeriodType	INT,
	endTime			INT,
	calendar		NVARCHAR(1024)
)
CREATE TABLE #CopyDataPath
(
	CopyId			INT,
	DataPathFlag	INT,
	IsHWCompressed	INT,
	UseHWEncryption	INT,
    MediaAgentName  NVARCHAR(1024),
	LibraryName		NVARCHAR(1024),
	SpareGroupName	NVARCHAR(1024),
	MasterPoolName	NVARCHAR(1024),
	DrivePoolName	NVARCHAR(1024),
	DrivePoolType	INT,
	NDMPHostId		INT,
    MediaAgentDisplayName  VARCHAR(1024)
)
INSERT	INTO #tempPolicyIds
SELECT	T.c.value('@policyId', 'int')
FROM	@i_policyIdsXml.nodes('/r/h') T(c)
INSERT	INTO #tempAGCopyList
SELECT	policyId = AG.id, policyName = AG.name, AG.defaultCopy, policyFlags = AG.flags,
		copyId	 = AC.id, copyName   = AC.name,
		isDefaultCopy = CASE WHEN AC.id = AG.defaultCopy THEN 1 WHEN AC.id = AG.defaultSnapCopy THEN 1 ELSE 0 END,
		sourceCopyId = CASE WHEN sourceCopyId = 0 THEN AG.defaultCopy ELSE AC.sourceCopyId END,
		isExtCommCell = CASE WHEN AC.origCCcommCellID > 2 AND EXISTS (SELECT * FROM APP_Commcell WHERE id = AC.origCCcommCellID AND type = 100) THEN 1 ELSE 0 END,
		copyType = CASE WHEN AC.id = AG.defaultCopy THEN 0
						WHEN AC.id = AG.defaultSnapCopy THEN 3
						WHEN AC.isSnapCopy = 1 THEN (CASE WHEN AC.isMirrorCopy = 1 THEN 4 ELSE 5 END)
WHEN (AC.flags & 524288) > 0 THEN 6
WHEN (AC.extendedFlags & 8) > 0 THEN 7
WHEN AC.type = 2 THEN 2
						ELSE 1
					END,
		AC.flags, AC.dedupeFlags, AC.isSnapCopy, AC.isActive, AC.startTime, AC.delayedDays,
		AC.maxMultiplex, AC.maxStreamNum, AC.encType, AC.encKeyLen, AC.archCheckValidPeriod,
		AC.archCheckValidPeriodType, AC.endTime,
		calendar = (CASE WHEN AC.calendarId > 1 THEN (select name from APP_CustomCalendar where id = AC.calendarId) ELSE N'' END)
FROM	#tempPolicyIds T
		INNER JOIN archGroup AG ON AG.id = T.archGroupId
INNER JOIN archGroupCopy AC ON AC.archGroupId = AG.id AND AC.type <> 5
INSERT	INTO #CopyDataPath
SELECT	P.CopyId, P.Flag,
		CASE WHEN L.LibraryTypeId IN (2,3,5) THEN -1 ELSE P.IsHardwareCompressed END,
		CASE WHEN L.LibraryTypeId IN (2,3,5) THEN -1 ELSE P.UseHardwareEncryption END,
        CL.displayName, L.AliasName, SG.SpareGroupName, MP.MasterPoolName, DP.DrivePoolName, DP.DrivePoolType, DP.NDMPHostId, CL.displayname
FROM	#tempAGCopyList T
		INNER JOIN MMDataPath P		ON P.CopyId = T.copyId
		INNER JOIN MMDrivePool DP	ON DP.DrivePoolId = P.DrivePoolId
		INNER JOIN MMMasterPool MP	ON MP.MasterPoolId = DP.MasterPoolId
		INNER JOIN MMLibrary L		ON L.LibraryId = MP.libraryId
		INNER JOIN APP_Client CL	ON CL.id = P.HostClientId
		INNER JOIN MMSpareGroup SG	ON SG.SpareGroupId = P.SpareGroupId
UPDATE	#CopyDataPath
SET     MediaAgentName = CL.displayName,
        MediaAgentDisplayName = CL.displayname
FROM	MMNDMPHostInfo NDMP INNER JOIN APP_Client CL ON CL.id = NDMP.ClientId
WHERE	#CopyDataPath.DrivePoolType = 3 AND #CopyDataPath.NDMPHostId = NDMP.NDMPHostId
SELECT	T.policyId,
		T.policyName,
		T.defaultCopy,
		T.policyFlags,
		T.copyId,
		T.copyName,
		T.isDefaultCopy,
		T.sourceCopyId,
		SourceCopyName	= (SELECT name FROM archGroupCopy WHERE id = T.sourceCopyId),
		T.isExtCommCell,
		T.copyType,
		T.copyFlags,
		T.dedupeFlags,
		T.isSnapCopy,
		T.isActive,
		T.startTime,
		T.delayedDays,
		T.maxMultiplex,
		T.maxStreamNum,
		T.encType,
		T.encKeyLen,
		T.archCheckValidPeriod,
		T.calendar,
		ISNULL(S.numOfTask, 0),
		ISNULL(MR.daysAfterWritten, 0),
		ISNULL(MR.daysBeforeAged, 0),
		ISNULL(MR.percentage, 0),
		ISNULL(P.numOfDataPath, 0),
		ISNULL(DP.DataPathFlag, 0),
		ISNULL(DP.UseHWEncryption, 0),
		ISNULL(DP.IsHWCompressed, 0),
		ISNULL(DP.MediaAgentName, ''),
		ISNULL(DP.LibraryName, ''),
		ISNULL(DP.SpareGroupName, ''),
		ISNULL(DP.MasterPoolName, ''),
		ISNULL(DP.DrivePoolName, ''),
        ISNULL(DP.MediaAgentDisplayName, ''),
		T.archCheckValidPeriodType,
		T.endTime
FROM	#tempAGCopyList T
		LEFT OUTER JOIN (SELECT	CopyId, COUNT(*) AS numOfDataPath FROM #CopyDataPath GROUP BY CopyId) P ON T.copyId = P.copyId
		LEFT OUTER JOIN #CopyDataPath DP ON DP.CopyId = T.copyId
		LEFT OUTER JOIN
		(SELECT	C.copyId, COUNT(DISTINCT ST.taskId) AS numOfTask
		FROM	#tempAGCopyList C
				INNER JOIN TM_AssocEntity AE
					ON (AE.copyId = C.copyId OR AE.policyId = C.policyId AND AE.copyId = 0) AND C.isDefaultCopy = 0 AND C.isSnapCopy = 0
				INNER JOIN TM_SubTask ST
					ON ST.taskId = AE.taskId AND ST.operationType = 4003
		GROUP BY C.copyId) S ON T.copyId = S.copyId
		LEFT OUTER JOIN
		archCopyMediaRefreshProp MR ON T.copyId = MR.copyId
ORDER BY policyName, isDefaultCopy DESC, copyName, MediaAgentName, LibraryName
DROP TABLE #tempPolicyIds
DROP TABLE #tempAGCopyList
DROP TABLE #CopyDataPath
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetArchGroupCopyList')
	delete from GxQscripts where name = 'RptGetArchGroupCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetArchGroupCopyList')
	delete from GXDBVersions where aliasname = 'RptGetArchGroupCopyList'
GO

insert into GXDBVersions values(2, 'RptGetArchGroupCopyList',  '00010031003600070000', 'RptGetArchGroupCopyList', '00010031003600070000')
GO

