

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetADUserGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetADUserGroups.sp,v $ $Id: RptGetADUserGroups.sp,v 1.8.32.2 2018/03/22 02:57:11 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetADUserGroups"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetADUserGroups <<<'

IF EXISTS (select * from sysobjects where name='RptGetADUserGroups')
	drop procedure RptGetADUserGroups
IF EXISTS (select * from GxQscripts where name='RptGetADUserGroups')
	delete from GxQscripts where name = 'RptGetADUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetADUserGroups')
	delete from GXDBVersions where aliasname = 'RptGetADUserGroups'
GO
print '... Creating Procedure: RptGetADUserGroups'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetADUserGroups
  @i_taskId integer,
  @i_hideOLUsers integer
AS
  DECLARE @o_ADGroupId integer;
  DECLARE @o_ADGroupName char(255);
  DECLARE @o_description char(255);
  DECLARE @o_enabled integer;
  DECLARE @o_providerId integer;
  DECLARE @o_domainName char(255);
  DECLARE @o_hostName char(255);
  DECLARE @o_userId integer;
  DECLARE @o_userName char(255);
  DECLARE @o_userDescription char(255);
  DECLARE @o_userEnabled integer;
  DECLARE @o_lastLogin integer;
  DECLARE @o_email char(255);
  DECLARE @o_login char(255);
  DECLARE @o_userflags integer;
  DECLARE @o_userNum integer;
  DECLARE @o_locGroupList varchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userAsscotdGroups table (groupId int);
DECLARE @i_userId int, @locId int, @flags bigint, @i_forModification int = 0, @i_isRestrictedViewEnabled int = 1
EXEC RptOptGetUserFlags @i_taskId, @i_userId OUTPUT, @locId OUTPUT, @flags OUTPUT
IF (dbo.isNewSecurity() = 0)
BEGIN
	DECLARE @canManageAllUsers int = 0
		EXEC sec_canManageAllUsers @i_userId, @canManageAllUsers OUTPUT
	DECLARE @IsHideEnabled int = 0
	IF @canManageAllUsers = 0 AND @i_forModification = 0
		EXEC sec_isHideEnabled @i_userId, @i_isRestrictedViewEnabled, @IsHideEnabled OUTPUT
	DECLARE @userHasUserManagementCap int = 0
	DECLARE @ManageUserCapMask bigint = CAST(POWER(2.0, 14 - 1) AS bigint)
		IF @canManageAllUsers = 0 AND @i_forModification <> 0
			EXEC sec_userHasCapability @i_userId, @ManageUserCapMask, @userHasUserManagementCap OUTPUT
	DECLARE @ListAllUsers int = 0
	IF @canManageAllUsers <> 0	or
		(@i_forModification = 0 AND @IsHideEnabled = 0)
		SET @ListAllUsers = 1
	IF @ListAllUsers <> 0
	BEGIN
			INSERT INTO @userAsscotdGroups
			SELECT UMGroups.id groupId
			FROM UMGroups
			WHERE (	(@i_isRestrictedViewEnabled <> 0 OR UMGroups.name <> 'CV_Restricted_Visibility')
					AND UMGroups.name <> 'Common Outlook Add-Ins'
				)
			ORDER BY UMGroups.id
	END
	ELSE IF ( @i_forModification = 0 OR @userHasUserManagementCap <> 0  )
	BEGIN
		DECLARE @providerId INT = ( select umDSproviderId FROM UMUsers WHERE id = @i_userid )
		IF ( @providerId = 0 )
		BEGIN
			INSERT INTO @userAsscotdGroups
			SELECT UMGroups.id groupId
			FROM UMGroups INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
			WHERE	(		UMUserGroup.userId = @i_userId
						AND UMGroups.name <> 'CV_Restricted_Visibility'
						AND UMGroups.name <> 'Common Outlook Add-Ins'
					)
			ORDER BY UMGroups.id
		END
		ELSE
		BEGIN
			INSERT INTO @userAsscotdGroups
			SELECT  DISTINCT  UMGroups.id groupId
			FROM         UMDSUserGroup INNER JOIN
								  UMDSGroupMaps ON UMDSUserGroup.groupId = UMDSGroupMaps.umDSgroupId INNER JOIN
								  UMGroups ON UMDSGroupMaps.umgroupId = UMGroups.id
			WHERE	(		UMDSUserGroup.userId = @i_userId
						AND UMGroups.name <> 'CV_Restricted_Visibility'
						AND UMGroups.name <> 'Common Outlook Add-Ins'
					)
			ORDER BY UMGroups.id
		END
	END
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb.dbo.#RptGetADUserGroupsTbl') IS NOT NULL
		DROP TABLE #RptGetADUserGroupsTbl
	CREATE TABLE #RptGetADUserGroupsTbl (userGroupId INT)
	EXEC sec_getUserGroupsForThisUser '#RptGetADUserGroupsTbl', @i_userId, 0
	INSERT INTO @userAsscotdGroups
		SELECT DISTINCT userGroupId FROM #RptGetADUserGroupsTbl
	IF OBJECT_ID('tempdb.dbo.#RptGetADUserGroupsTbl') IS NOT NULL
		DROP TABLE #RptGetADUserGroupsTbl
END
DECLARE @groupList	varchar(MAX)
DECLARE @locGroupName	varchar(255)
DECLARE @exGroupId	int
DECLARE @userGroupList	TABLE (	gId		int,
				gName		varchar(255),
				gDescription	varchar(255),
				gEnabled	int,
				providerId	int,
				domainName	varchar(255),
				hostName	varchar(255),
				locGrps		varchar(MAX))
INSERT INTO @userGroupList
SELECT	G.id, G.name, G.description, G.enabled, P.id, P.domainName, P.hostName, NULL
FROM	UMDSGroups G, UMDSProviders P
WHERE	G.UmDSProviderId=P.id AND EXISTS (select * from UMDSGroupMaps where umDSGroupId=G.id)
DECLARE extGroupList CURSOR FOR
	SELECT DISTINCT gId  FROM @userGroupList
OPEN extGroupList
FETCH NEXT FROM extGroupList INTO @exGroupId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @groupList	= ''
	DECLARE locGroupList CURSOR FOR
	SELECT name FROM UMGroups G, UMDSGroupMaps M WHERE M.umDSGroupId=@exGroupId and G.id=M.umgroupId
	OPEN locGroupList
	FETCH NEXT FROM locGroupList INTO @locGroupName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF LEN(@groupList) <> 0
			SET @groupList =  @groupList + ', '
		SET @groupList = @groupList + @locGroupName
		FETCH NEXT FROM locGroupList INTO @locGroupName
	END
	CLOSE locGroupList
	DEALLOCATE locGroupList
	UPDATE @userGroupList SET locGrps = @groupList WHERE gId  = @exGroupId
	FETCH NEXT FROM extGroupList INTO @exGroupId
END
CLOSE extGroupList
DEALLOCATE extGroupList
if object_id('tempdb.dbo.#tempUserGroupTable') is not Null	DROP TABLE #tempUserGroupTable
SELECT	T.*, userId=id, name, description, enabled, lastLoginTime, email, login, flags
INTO	#tempUserGroupTable
FROM	@userGroupList T	LEFT OUTER JOIN UMDSUserGroup G	ON T.gId = G.groupId
				LEFT OUTER JOIN UMUsers U 	ON G.userId = U.id and T.providerId = U.umDSProviderId
DELETE	#tempUserGroupTable
WHERE	login LIKE '%(Deleted,%)'
		OR (@i_hideOLUsers > 0 AND (flags & 256) <> 0)
		OR ((flags & 0x004) = 4) --discarding all the users who are hidden
		OR gId not in	(select GM.umDSgroupId
						from @userAsscotdGroups AG -- Gets data from UMGroup
								JOIN UMDSGroupMaps GM --#tempUserGroupTable gets groupIds from @userGroupList Which contains groupid's from UMDSGroup
									ON  AG.groupId = GM.umgroupId
						)
SELECT	gId, gName, gDescription, gEnabled, providerId, domainName, hostName, userId, name, description, enabled, lastLoginTime, email, login, flags,
	userNum=(select count(DISTINCT tt.userId) from #tempUserGroupTable tt where tt.gId=T.gId), locGrps
FROM	#tempUserGroupTable T
DROP TABLE #tempUserGroupTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetADUserGroups')
	delete from GxQscripts where name = 'RptGetADUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetADUserGroups')
	delete from GXDBVersions where aliasname = 'RptGetADUserGroups'
GO

insert into GXDBVersions values(2, 'RptGetADUserGroups',  '00010008003200020000', 'RptGetADUserGroups', '00010008003200020000')
GO

