

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptEventMsg.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptEventMsg.sp,v $ $Id: RptEventMsg.sp,v 1.22.36.6 2020/03/17 20:34:14 vmishra Exp $";
--     +-----------------------------------------------------------------------+
--     |                       PROCEDURE: "rptEventMsg"                        |
--     +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptEventMsg')
BEGIN
	print '>>> Drop Stored Procedure: rptEventMsg <<<'
	drop procedure rptEventMsg
END
IF EXISTS (select * from GxQscripts where name='rptEventMsg')
	delete from GxQscripts where name = 'rptEventMsg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptEventMsg')
	delete from GXDBVersions where aliasname = 'rptEventMsg'
GO
print '... Creating Procedure: rptEventMsg'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptEventMsg
  @i_jobId integer,
  @outputtable VARCHAR(124)=''
AS
  DECLARE @o_id integer;
  DECLARE @o_jobId integer;
  DECLARE @o_severity integer;
  DECLARE @o_time integer;
  DECLARE @o_subsystem varchar(128);
  DECLARE @o_client nvarchar(255);
  DECLARE @o_eventCode varchar(30);
  DECLARE @o_msgText nvarchar(MAX);
  DECLARE @o_clientDisplayName nvarchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId			integer
DECLARE @locId			integer
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @jobId			integer
DECLARE @order			integer
DECLARE @clOpt			integer
DECLARE @svrInfo		integer
DECLARE @svrMinor		integer
DECLARE @svrMajor		integer
DECLARE @svrCritical		integer
DECLARE @tblSeverity		TABLE (t_severity int)
DECLARE @tblClients		TABLE (t_clId int)
CREATE TABLE #tblEventMsgsInternal (
					Id			int,
					jobId		int,
					severity	int,
					time		int,
					subsystem	varchar(128),
                    client      nvarchar(255),
					eventCode	varchar(30),
					msgText		nvarchar(4000),
                    clientDisplayName nvarchar(255))
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @locId	= dbo.GetOptionInt(1421724997, @i_jobId, 0, 0)
SET @jobId	= dbo.GetOptionInt(522918836, @i_jobId, 0, 0)
SET @order	= dbo.GetOptionInt(52239626, @i_jobId, 0, 0)
SET @svrInfo	= dbo.GetOptionInt(619331572, @i_jobId, 0, 0)
SET @svrMinor	= dbo.GetOptionInt(1207506819, @i_jobId, 0, 0)
SET @svrMajor	= dbo.GetOptionInt(1207748991, @i_jobId, 0, 0)
SET @svrCritical= dbo.GetOptionInt(821092823, @i_jobId, 0, 0)
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
DECLARE @canUserViewAll INT = 0
EXEC sec_canViewAll @userId, @canUserViewAll OUTPUT
-- disable client selection which is not available in GUI
--INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
SET @clOpt = 0
IF @svrInfo > 0
INSERT INTO @tblSeverity VALUES(0)
IF @svrMinor > 0
INSERT INTO @tblSeverity VALUES(3)
IF @svrMajor > 0
INSERT INTO @tblSeverity VALUES(6)
IF @svrCritical > 0
INSERT INTO @tblSeverity VALUES(9)
IF	@endTime = 0
	SET @endTime = 0x7FFFFFFF
IF @clOpt = 0
BEGIN
	IF	@jobId = 0
		INSERT INTO #tblEventMsgsInternal
        SELECT  EvMsg.id, jobId_l, severity, timeSource, subsystem, client,
			CAST (L.SubsystemID AS VARCHAR(10))+':'+CAST (L.MessageNum AS VARCHAR(19)),
            ISNULL(EvMsgCache.Message, DBO.fn_EvFormatEventMsgText(EvMsg.id, @locId, EvMsg.MessageId, 1,2)),
            CL.displayName
		FROM	EvMsg
                     INNER  JOIN APP_Client CL WITH (NOLOCK) ON CL.Id = EvMsg.clientID
                LEFT OUTER  JOIN EvMsgCache ON EvMsgId = EvMsg.id AND LocaleId = @locId
				            JOIN @tblSeverity ON severity = t_severity
                            JOIN EvLocaleMsgs L ON EvMsg.messageId = L.MessageID AND L.LocaleID = @locId
		WHERE	timeSource >= @startTime AND timeSource <= @endTime AND type <> 2
			AND (@canUserViewAll = 1 OR dbo.isClientVisibleEvents(@userId, jobId_l, EvMsg.CommcellId, clientId, userID, libraryId, maClientId, mediaId, driveId) > 0)
	ELSE
		INSERT INTO #tblEventMsgsInternal
        SELECT  EvMsg.id, jobId_l, severity, timeSource, subsystem, client,
			CAST (L.SubsystemID AS VARCHAR(10))+':'+CAST (L.MessageNum AS VARCHAR(19)),
            ISNULL(EvMsgCache.Message, DBO.fn_EvFormatEventMsgText(EvMsg.id, @locId, EvMsg.MessageId, 1,2)),
            CL.displayName
		FROM	EvMsg
                     INNER  JOIN APP_Client CL WITH (NOLOCK) ON CL.Id = EvMsg.clientID
                LEFT OUTER  JOIN EvMsgCache ON EvMsgId = EvMsg.id AND LocaleId = @locId
				            JOIN @tblSeverity ON severity = t_severity
                            JOIN EvLocaleMsgs L ON EvMsg.messageId = L.MessageID AND L.LocaleID = @locId
		WHERE	jobId_l = @jobId
			AND timeSource >= @startTime AND timeSource <= @endTime AND type <> 2
			AND (@canUserViewAll = 1 OR dbo.isClientVisibleEvents(@userId, jobId_l, EvMsg.CommcellId, clientId, userID, libraryId, maClientId, mediaId, driveId) > 0)
END
ELSE
BEGIN
	IF	@jobId = 0
		INSERT INTO #tblEventMsgsInternal
        SELECT  EvMsg.id, jobId_l, severity, timeSource, subsystem, client,
			CAST (L.SubsystemID AS VARCHAR(10))+':'+CAST (L.MessageNum AS VARCHAR(19)),
            ISNULL(EvMsgCache.Message, DBO.fn_EvFormatEventMsgText(EvMsg.id, @locId, EvMsg.MessageId, 1,2)),
            CL.displayName
		FROM	EvMsg
                     INNER  JOIN APP_Client CL WITH (NOLOCK) ON CL.Id = EvMsg.clientID
                LEFT OUTER  JOIN EvMsgCache ON EvMsgId = EvMsg.id AND LocaleId = @locId
				            JOIN @tblSeverity ON severity = t_severity
				            JOIN @tblClients ON clientId = t_clId
                            JOIN EvLocaleMsgs L ON EvMsg.messageId = L.MessageID AND L.LocaleID = @locId
		WHERE	timeSource >= @startTime AND timeSource <= @endTime AND type <> 2
			AND (@canUserViewAll = 1 OR dbo.isClientVisibleEvents(@userId, jobId_l, EvMsg.CommcellId, clientId, userID, libraryId, maClientId, mediaId, driveId) > 0)
	ELSE
		INSERT INTO #tblEventMsgsInternal
        SELECT  EvMsg.id, jobId_l, severity, timeSource, subsystem, client,
			CAST (L.SubsystemID AS VARCHAR(10))+':'+CAST (L.MessageNum AS VARCHAR(19)),
            ISNULL(EvMsgCache.Message, DBO.fn_EvFormatEventMsgText(EvMsg.id, @locId, EvMsg.MessageId, 1,2)),
            CL.displayName
		FROM	EvMsg
                     INNER  JOIN APP_Client CL WITH (NOLOCK) ON CL.Id = EvMsg.clientID
                LEFT OUTER  JOIN EvMsgCache ON EvMsgId = EvMsg.id AND LocaleId = @locId
				            JOIN @tblSeverity ON severity = t_severity
				            JOIN @tblClients ON clientId = t_clId
                            JOIN EvLocaleMsgs L ON EvMsg.messageId = L.MessageID AND L.LocaleID = @locId
		WHERE	jobId_l = @jobId
			AND timeSource >= @startTime AND timeSource <= @endTime AND type <> 2
			AND (@canUserViewAll = 1 OR dbo.isClientVisibleEvents(@userId, jobId_l, EvMsg.CommcellId, clientId, userID, libraryId, maClientId, mediaId, driveId) > 0)
END
IF LEN(@outputtable) = 0
BEGIN
IF @order = 2
		SELECT Id, jobId, severity, time, subsystem, client, eventCode, msgText, clientDisplayName FROM #tblEventMsgsInternal ORDER BY client ASC, id DESC
ELSE IF @order = 3
		SELECT Id, jobId, severity, time, subsystem, client, eventCode, msgText, clientDisplayName FROM #tblEventMsgsInternal ORDER BY jobId DESC, id DESC
	ELSE
		SELECT Id, jobId, severity, time, subsystem, client, eventCode, msgText, clientDisplayName FROM #tblEventMsgsInternal ORDER BY id DESC
END
ELSE
BEGIN
	EXEC('INSERT INTO '+@outputtable+' SELECT * FROM #tblEventMsgsInternal')
END
DROP TABLE #tblEventMsgsInternal
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'RptEventMsg')
	delete from GxQscripts where name = 'RptEventMsg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptEventMsg')
	delete from GXDBVersions where aliasname = 'RptEventMsg'
GO

insert into GXDBVersions values(2, 'RptEventMsg',  '00010022003600060000', 'RptEventMsg', '00010022003600060000')
GO

