

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptEndPointUserDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptEndPointUserDetails.sp,v $ $Id: RptEndPointUserDetails.sp,v 1.2.40.6 2018/09/29 17:33:41 leiwang Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptEndPointUserDetails <<<'

IF EXISTS (select * from sysobjects where name='RptEndPointUserDetails')
	drop procedure RptEndPointUserDetails
IF EXISTS (select * from GxQscripts where name='RptEndPointUserDetails')
	delete from GxQscripts where name = 'RptEndPointUserDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptEndPointUserDetails')
	delete from GXDBVersions where aliasname = 'RptEndPointUserDetails'
GO
print '... Creating Procedure: RptEndPointUserDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptEndPointUserDetails
-- Input arguments
  @reportType INT,
  @nUserId INT = 0,
  @nOrganizationId INT = 0
AS
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF OBJECT_ID('tempdb.dbo.#Users') IS NOT NULL
		DROP TABLE #Users
	CREATE TABLE #Users (
		userId		INT,
		report		INT,	--	ReportType:	1 EndPointSharingUsers, 2 EndPointUsers, 3 EndPointEDiscoveryUsers, 4 All Users
		type		INT,		--	EndPointSharingUsers:	11-ShareFolderUser, 12-ShareFolderEdgeDriveUser
							--	EndPointUsers:			21-DLOUser, 22-SyncFolderUser, 23-DLPUser, 24-ExplorerPluginUser
							--	EndPointEDiscoveryUsers: 31-DLOCIUser
		clientId	INT,
		otherId	INT DEFAULT 0
	)
	CREATE CLUSTERED INDEX User_Idx ON #Users (userId, report, type)
	IF OBJECT_ID('tempdb.dbo.#ClientOwners') IS NOT NULL
		DROP TABLE #ClientOwners
	CREATE TABLE #ClientOwners (
		clientId				INT,
		userId					INT,
		PRIMARY KEY(clientId, userId)
	)
	INSERT INTO #ClientOwners(clientId, userId)
		SELECT DISTINCT clientId, userId FROM dbo.sec_getClientOwners(1) WHERE userId <> 0		-- function expands user groups to user associations
	IF @nUserId > 1 AND object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL --SECURITY
	BEGIN
		delete #ClientOwners
		where clientId not in (select clientId from #LicCalUserObj where clientId > 0)
	END
	DECLARE @Reports TABLE (
		type		INT PRIMARY KEY,
		name		NVARCHAR(48)
	)
	INSERT INTO @Reports
		SELECT 1, N'End Point Sharing User'
		UNION SELECT 2, N'End Point User'
		UNION SELECT 3, N'End Point E-Discovery User'
		UNION SELECT 11, N'Share Folder User'
		UNION SELECT 12, N'Edge Drive User'
		UNION SELECT 21, N'DLO User'
		UNION SELECT 22, N'Sync Folder User'
		UNION SELECT 23, N'DLP User'
		UNION SELECT 24, N'Explorer Plug-in User'
		UNION SELECT 31, N'DLOCI User'
	IF (@reportType = 1  OR @reportType = 4)
	BEGIN
		INSERT INTO #Users(userId, report, type, clientId, otherId)
			SELECT DISTINCT A.ownerId, 1, 11,0,A.syncWebFolderId FROM App_SyncCloudFolder A WITH(NOLOCK) WHERE A.flag&12 <> 0
			UNION
			SELECT DISTINCT CAST(attrVal AS INT), 1, 12,0, componentNameId FROM APP_BackupSetProp A WITH(NOLOCK)
			WHERE A.attrName = 'Edge Drive User Id' and A.modified = 0
	END
	IF (@reportType = 2 OR @reportType = 4)
	BEGIN
		INSERT INTO #Users(userId, report, type, clientId, otherId)
			SELECT a.userid, 2, 21, a.clientId,0 from
				(
					SELECT DISTINCT co.userId 'userid', co.clientId FROM #ClientOwners co WHERE co.clientId IN (SELECT id FROM APP_Client WITH(NOLOCK) WHERE status & 4096 = 4096 AND status & 2 <> 2)
				) a
			UNION
			SELECT ownerId, 2, 22, 0, A.syncWebFolderId FROM App_SyncCloudFolder A WITH (NOLOCK) WHERE A.flag&60 = 0
			UNION
			SELECT a.userid, 2, 23, a.clientId,0 from
				(
					SELECT DISTINCT co.userId 'userid', co.clientId from #ClientOwners co where co.clientId IN (
						SELECT DISTINCT DLPClients.id
						FROM
						(
							SELECT cli.id
							FROM APP_Client cli WITH(NOLOCK)
								INNER JOIN APP_ClientGroupAssoc Assoc WITH(NOLOCK) ON
									cli.id = Assoc.clientId
									AND cli.status != 0
								INNER JOIN APP_ClientProp prop WITH(NOLOCK) ON
									cli.id = prop.componentNameId
									AND prop.attrName = 'enableDLP'
									AND prop.attrVal = '0'
							WHERE
								(cli.status & 0xEFFF) = 0
								AND Assoc.clientGroupId IN (SELECT groupId
															FROM DlpGroupProp WITH(NOLOCK)
															WHERE groupId IN (SELECT groupId FROM DlpGroupProp WITH(NOLOCK) WHERE attrname = 'enableDLP' AND attrVal = '1')
															AND attrName = 'dlpContents' AND REPLACE(attrVal, ';', '') <> '')
							UNION
							SELECT cli.id
							FROM APP_Client cli WITH(NOLOCK)
								INNER JOIN APP_ClientProp prop WITH(NOLOCK) ON
									cli.id = prop.componentNameId
							WHERE
								cli.status != 0
								AND (cli.status & 0xEFFF) = 0
								AND prop.componentNameId IN (SELECT componentNameId FROM APP_ClientProp WITH(NOLOCK) WHERE attrname = 'enableDLP' AND attrVal = '1')
								AND prop.attrName = 'dlpContents' AND REPLACE(prop.attrVal, ';', '') <> ''
						) AS DLPClients
					)
				) a
			UNION
			SELECT a.userid, 2, 24, a.clientId,0 from
				(
					SELECT DISTINCT co.userId 'userid', co.clientId from #ClientOwners co where co.clientId IN (SELECT DISTINCT componentNameId FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'FS Explorer Plugin Enabled Status' AND attrVal = '1' AND modified = 0)
				) a
	END
	IF (@reportType = 3 OR @reportType = 4)
	BEGIN
		INSERT INTO #Users(userId, report, type, clientId)
			SELECT a.userid, 3, 31, a.clientId FROM
				(
					SELECT DISTINCT co.userId 'userid', co.clientId FROM #ClientOwners co WHERE co.clientId IN (SELECT id FROM APP_Client WITH(NOLOCK) WHERE id in (SELECT DISTINCT clientId FROM APP_ApplicatiON WITH(NOLOCK) WHERE (status & 4096) = 4096 AND id IN (SELECT appid FROM archFile WITH(NOLOCK) WHERE flags & 64 = 64)))
				) a
	END
	IF (@reportType < 1 OR @reportType > 4)
	BEGIN
		-- Bad Report Type Input
		RETURN 1
	END
	IF @nOrganizationId = 0
		UPDATE #Users SET clientId = 0
	ELSE
	BEGIN
		UPDATE C SET clientId = B.clientId
		FROM #Users C JOIN App_SyncCloudConfig B WITH(NOLOCK) ON C.otherId = B.syncWebFolderId
		WHERE C.type IN (11,22)
		UPDATE C SET clientId = B.clientId
		FROM #Users C JOIN APP_Application B WITH(NOLOCK) ON C.otherId = B.backupset
		WHERE C.type = 12
	END
	SELECT
		u.id userId,
		u.name,
		u.login,
		u.email,
		tu.report userType,
		r.name reportName,
		(SELECT STUFF((
			SELECT
				DISTINCT ',' + sr.name
			FROM #Users su
				INNER JOIN @Reports sr ON
					sr.type = su.type
			WHERE
				su.userId = u.id
			FOR XML PATH(''), TYPE).value('.', 'NVARCHAR(512)'), 1, 1, '')) associationTypes,
		tu.clientId
	FROM
		UMUsers u WITH(NOLOCK)
		INNER JOIN (SELECT DISTINCT userId, report, clientId FROM #Users) tu ON
			tu.userId = u.id
		INNER JOIN @Reports r ON
			r.type = tu.report
	IF OBJECT_ID('tempdb.dbo.#Users') IS NOT NULL
		DROP TABLE #Users
GO

IF EXISTS (select * from GxQscripts where name = 'RptEndPointUserDetails')
	delete from GxQscripts where name = 'RptEndPointUserDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptEndPointUserDetails')
	delete from GXDBVersions where aliasname = 'RptEndPointUserDetails'
GO

insert into GXDBVersions values(2, 'RptEndPointUserDetails',  '00010002004000060000', 'RptEndPointUserDetails', '00010002004000060000')
GO

