

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptDM2AuditMsg.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptDM2AuditMsg.sp,v $ $Id: RptDM2AuditMsg.sp,v 1.7.210.2 2018/03/22 03:14:34 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptDM2AuditMsg"									|
--	|Description: Retrieve GUI Audit Trail Informtion						|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDM2AuditMsg <<<'

IF EXISTS (select * from sysobjects where name='RptDM2AuditMsg')
	drop procedure RptDM2AuditMsg
IF EXISTS (select * from GxQscripts where name='RptDM2AuditMsg')
	delete from GxQscripts where name = 'RptDM2AuditMsg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDM2AuditMsg')
	delete from GXDBVersions where aliasname = 'RptDM2AuditMsg'
GO
print '... Creating Procedure: RptDM2AuditMsg'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptDM2AuditMsg
  @i_jobId integer,
  @i_auditLevel integer
AS
  DECLARE @o_evMsgId integer;
  DECLARE @o_userId integer;
  DECLARE @o_time integer;
  DECLARE @o_messageId integer;
  DECLARE @o_opId integer;
  DECLARE @o_paramId integer;
  DECLARE @o_auditLevel integer;
  DECLARE @o_entityType integer;
  DECLARE @o_entityId integer;
  DECLARE @o_oldMsgId integer;
  DECLARE @o_newMsgId integer;
  DECLARE @o_msgSpanNum integer;
  DECLARE @o_msgText nvarchar(MAX);
SET NOCOUNT ON
	DECLARE @locId			integer
	DECLARE @startTime		integer
	DECLARE @endTime		integer
	DECLARE @reviewSetOpt	integer
	DECLARE @reviewSetName	varchar(1024)
	DECLARE @tblEventMsgs TABLE (
			id			int,
			userId		int,
			timeServer	int,
			messageId	int,
			opId		int,	-- id in EvGuiAuditOperation table
			paramId		int,	-- id in EvGuiAuditParameter table
			auditLevel	int,
			entityType	int,
			entityId	int,
			oldMsgId	int,
			newMsgId	int,
			msgSpanNum	int,
			messageText	nvarchar(max)
			primary key (id)
			)
	DECLARE @tblEventAuditLevel TABLE (
			opId		int,	-- id in EvGuiAuditOperation table
			auditLevel	int
			)
	DECLARE @tblReviewSet TABLE (
			reviewSetId		int
			)
	-- Get local of report
SET @locId	= dbo.GetOptionInt(1421724997, @i_jobId, 0, 0)
	INSERT INTO @tblReviewSet EXEC rptOptGetObjectList @i_jobId, 1815144984, @reviewSetOpt OUTPUT
	-- Get time range for report
	EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
	-- Retrieve GUI Audit events, default all event to AUDIT_TRAIL_LEVEL_HIGH = 2
	INSERT INTO @tblEventMsgs
	SELECT	id, userId, timeServer, messageId, 0, 0, 2, 0, 0,  0, '', '',''
	FROM	EvMsg WITH (NOLOCK)
	WHERE	(@startTime = 0 OR timeServer >= @startTime) AND (@endTime = 0 OR timeServer <= @endTime)
	AND		type = 2 and messageId in
						(select messageId
						 from EvLocaleMsgs
						where Messagenum in (306, 654, 784) --Review Set related message
						AND SubsystemId in (84, 85)) -- GUIAUDIT_OPS_SSID, GUIAUDIT_PARAMS_SSID
	UPDATE	@tblEventMsgs
	SET		messageText = DBO.fn_EvFormatEventMsgText( id, @locId, messageId, 1,2)
	UPDATE	@tblEventMsgs
	SET		opId = b.id, entityType = b.EntityType, entityId=b.EntityId
	FROM	@tblEventMsgs a, EvGuiAuditOperation b
	WHERE	a.id = b.evMsgId
	UPDATE	@tblEventMsgs
	SET		opId = b.opId, paramId = b.id, oldMsgId = b.OldMsgId, newMsgId =b.NewMsgId
	FROM	@tblEventMsgs a, EvGuiAuditParameter b
	WHERE	a.id = b.evMsgId
	--support for review set selection
	IF @reviewSetOpt =1
	BEGIN
		DECLARE @tblOpId TABLE (
					opId		int
				)
		--get list of opId associate with review set which need to filter
		DECLARE operationIdList CURSOR FOR
			SELECT containerName FROM DM2Container where containerId in (select reviewSetId from @tblReviewSet)
		OPEN operationIdList
		FETCH NEXT FROM operationIdList INTO @reviewSetName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @tblOpId
			SELECT opid FROM @tblEventMsgs
			WHERE messageText like '%'+  @reviewSetName  +'%'
			FETCH NEXT FROM operationIdList INTO @reviewSetName
		END
		CLOSE operationIdList
		DEALLOCATE operationIdList
		--if some review set is selected, filter out rows
		delete from @tblEventMsgs
		where opId not in (select opId from @tblOpId)
	END
	INSERT	INTO @tblEventAuditLevel
	SELECT	DISTINCT a.opId, b.auditLevel
	FROM	@tblEventMsgs a, EvGuiAuditLevel b
	WHERE	a.messageId = b.opMsgId and a.messageId >0
	UPDATE	@tblEventMsgs
	SET		auditLevel = b.auditLevel
	FROM	@tblEventMsgs a, @tblEventAuditLevel b
	WHERE	a.opId = b.opId
	Delete  FROM @tblEventMsgs
	WHERE messageText IS null
	UPDATE @tblEventMsgs
	SET	   msgSpanNum = (SELECT Distinct COUNT(*) FROM @tblEventMsgs e
						 WHERE e.opId = a.opId
						 GROUP BY opId, timeServer)
	FROM @tblEventMsgs a
	select * from @tblEventMsgs
	WHERE	auditLevel <= @i_auditLevel
	ORDER	BY opId desc, paramId asc
GO

IF EXISTS (select * from GxQscripts where name = 'RptDM2AuditMsg')
	delete from GxQscripts where name = 'RptDM2AuditMsg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDM2AuditMsg')
	delete from GXDBVersions where aliasname = 'RptDM2AuditMsg'
GO

insert into GXDBVersions values(2, 'RptDM2AuditMsg',  '00010007021000020000', 'RptDM2AuditMsg', '00010007021000020000')
GO

