

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptCommservSurveyGetXMLSummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  FILE NAME   : RptCommservSurveyGetXMLSummary.sp
--  AUTHOR      : Dinesh Babu Navaneethan
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptCommservSurveyGetXMLSummary')
BEGIN
	print '>>> Drop Stored Procedure: RptCommservSurveyGetXMLSummary <<<'
	drop procedure RptCommservSurveyGetXMLSummary
END
IF EXISTS (select * from GxQscripts where name='RptCommservSurveyGetXMLSummary')
	delete from GxQscripts where name = 'RptCommservSurveyGetXMLSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommservSurveyGetXMLSummary')
	delete from GXDBVersions where aliasname = 'RptCommservSurveyGetXMLSummary'
GO
print '... Creating Procedure: RptCommservSurveyGetXMLSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommservSurveyGetXMLSummary
-- Input arguments
  @i_mode int
AS
  DECLARE @o_SurveySummary XML;
SET NOCOUNT ON
DECLARE @tmpXML AS XML = ''
DECLARE @lastUploadTime BIGINT
DECLARE @lastCollectionTime BIGINT
DECLARE @metricsType VARCHAR(256)='Diagnostic and Usage'
DECLARE	@emailIds VARCHAR(MAX)=''
DECLARE @commcellNumber INT = 0
DECLARE @tempFlag int =1
IF EXISTS(SELECT name FROM GXGlobalParam WHERE name = 'CommservSurveyRunning')
BEGIN
	SELECT @metricsType = value from GXGlobalParam where name ='CommservSurveyRunning'
END
IF (@metricsType = 'Diagnostics and Usage')  --public
BEGIN
	SET @tempFlag = 1
	SET @lastUploadTime = (SELECT CAST (CAST(value AS VARCHAR) AS BIGINT) FROM GXGlobalParam WHERE name = 'CommservSurveyLastUploadTime')
END
IF (@metricsType = 'Metrics Reporting')
BEGIN
	SET @tempFlag = 2
	SET @lastUploadTime = (SELECT CAST (CAST(value AS VARCHAR) AS BIGINT) FROM GXGlobalParam WHERE name = 'CommservSurveyPrivateLastUploadTime')
END
ELSE IF (@metricsType = 'Metrics Direct Dip')
BEGIN
	SET @tempFlag = 16
	-- Setting last upload time to zero, as all collected data is to be uploaded for direct dip collection
	SET @lastUploadTime = 0
END
IF ( @i_mode = 1)
BEGIN
	SET @tempFlag =  4
	-- Setting last upload time to zero, as all dynamic xml queries need to be sent
	SET @lastUploadTime = 0
END
ELSE IF(@i_mode = 2)
BEGIN
	SET @tempFlag =  8
	-- Setting last upload time to zero, as all dynamic xml queries need to be sent
	SET @lastUploadTime = 0
END
SET @emailIds = (SELECT value FROM GXGLOBALParam WHERE name = 'CommservSurveyMailId')
SET @tmpXML = (SELECT LogXML FROM RptSurveyLog WHERE LogDate > @lastUploadTime AND QueryId >= 1	AND MetricsType = @tempFlag FOR XML PATH(''))
DECLARE @csReleaseId INT = 0
SELECT  @csReleaseId = releaseId FROM APP_Client WHERE id = 2
IF ( @csReleaseId > 15)
	SET @commcellNumber = (Select commcellId from LicCSL (NOLOCK)  where id = (select max(id) from LicCSL (NOLOCK)))
ELSE
	SET @commcellNumber = (SELECT number FROM APP_CommCell (NOLOCK) WHERE id = 2)
IF (@tmpXML IS NOT NULL AND @tmpXML.exist('*') != 0) --Adding sanity check to make sure xml data is valid.
BEGIN
	SELECT @tmpXML = @tmpXML.query('/LogXML/*')
	SELECT @commcellNumber as '@commcellID', @emailIds AS '@emailRecipients', @tmpXML
		FOR XML PATH('Rpt_CSSXMLDATAROOT'), TYPE
END
ELSE
BEGIN
	SELECT ''
END
DELETE FROM RptSurveyLog
WHERE MetricsType = @tempFlag
	OR LogDate <= dbo.GetUnixTime(DATEADD(mm, -1, GETUTCDATE())) --Delete anything older than a month. Adding cleanup for any stale data.
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommservSurveyGetXMLSummary')
	delete from GxQscripts where name = 'RptCommservSurveyGetXMLSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommservSurveyGetXMLSummary')
	delete from GXDBVersions where aliasname = 'RptCommservSurveyGetXMLSummary'
GO

insert into GXDBVersions values(2, 'RptCommservSurveyGetXMLSummary',  '00000000000000000000', 'RptCommservSurveyGetXMLSummary', '00000000000000000000')
GO

