

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptCommservSurveyCapacityLicenseUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  FILE NAME   : RptCommservSurveyCapacityLicenseUsage.sp
--  AUTHOR      : Dinesh Babu Navaneethan
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptCommservSurveyCapacityLicenseUsage')
BEGIN
	print '>>> Drop Stored Procedure: RptCommservSurveyCapacityLicenseUsage <<<'
	drop procedure RptCommservSurveyCapacityLicenseUsage
END
IF EXISTS (select * from GxQscripts where name='RptCommservSurveyCapacityLicenseUsage')
	delete from GxQscripts where name = 'RptCommservSurveyCapacityLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommservSurveyCapacityLicenseUsage')
	delete from GXDBVersions where aliasname = 'RptCommservSurveyCapacityLicenseUsage'
GO
print '... Creating Procedure: RptCommservSurveyCapacityLicenseUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommservSurveyCapacityLicenseUsage
  @i_subUsgTot XML,
  @i_licUsgTot XML
AS
SET NOCOUNT ON
DECLARE @LogDate AS BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @queryId AS INTEGER = 1
DECLARE @logXML AS XML
DECLARE @surveyXML varchar(MAX)
DECLARE @metricsType VARCHAR(256)='Diagnostic and Usage'
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpLicUsage11')) DROP TABLE #tmpLicUsage11
CREATE TABLE #tmpLicUsage11 (licType INT, usage BIGINT)
EXEC LicCALUsage 0,0
DECLARE @CapacityLicense TABLE (LicType	INT, Used BIGINT, Issued BIGINT, Eval BIGINT, EvalExpiry DATETIME)
DECLARE @permField	VARCHAR(2048)=''
DECLARE @evalField	VARCHAR(2048)=''
DECLARE @licType	INT = 0
DECLARE @permIssued	INT = 0
DECLARE @permUsed	INT = 0
DECLARE @evalIssued	INT = 0
DECLARE @evalUsed	INT = 0
DECLARE @bEval		INT = 0
DECLARE @evalExpiry	INT = 0
DECLARE @inheritedLicType INT = 0
SELECT @inheritedLicType = ISNULL(attrVal,0) FROM LicUsageBasedConfig WHERE attrName = 'InheritedLicType'
--If this is a child or license server fetch the data from RptClientGroupQuotaUsage
IF @inheritedLicType&1 > 0
BEGIN
	INSERT INTO @CapacityLicense
	SELECT quotaType,quotaUsedGB,globalLimitGB,0,dbo.GetDateTime(expiryTime) FROM RptClientGroupQuotaUsage WHERE quotaType IN (100002, 100004, 100005, 100006) AND clientGroupId = 0
END
ELSE
BEGIN
	DECLARE CapacityLic CURSOR FOR
	SELECT	simLicAppTypeId, RTRIM(perm_fld1), RTRIM(eval_fld1)
	FROM	LicAAL WITH (NOLOCK)
	WHERE	simLicAppTypeId IN (100002, 100004, 100005, 100006) AND commcellId = 2
	OPEN CapacityLic
		FETCH NEXT FROM CapacityLic INTO @licType, @permField, @evalField
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		SET @permIssued = 0
		SET @permUsed	= 0
		IF (@permField <> '')
			EXEC xp_getAALInfo2 @permField, @permIssued OUTPUT, @permUsed OUTPUT, @bEval OUTPUT, @evalExpiry OUTPUT
		SET @evalIssued = 0
		SET @evalUsed	= 0
		SET @bEval		= 0
		SET @evalExpiry = 0
		IF (@evalField <> '')
			EXEC xp_getAALInfo2 @evalField, @evalIssued OUTPUT, @evalUsed OUTPUT, @bEval OUTPUT, @evalExpiry OUTPUT
		INSERT INTO @CapacityLicense
		SELECT @licType, @permUsed+@evalUsed, @permIssued, @evalIssued,
			   CASE WHEN @evalExpiry > 0 THEN dbo.GetDateTime(@evalExpiry) ELSE '1970-01-01' END
		FETCH NEXT FROM CapacityLic INTO @licType, @permField, @evalField
	END
	CLOSE CapacityLic
	DEALLOCATE CapacityLic
END
SET @surveyXML =
	(SELECT
		@i_subUsgTot,
		(
			SELECT
				[100013] as '@nArchivedMailBox',
				[100015]*1024 as '@UsedDiskSpaceMB',
				[100016]*1024 as '@DedupDataSizeMB',
				[100017] as '@CIObjects',
				[100018] as '@VMSockets',
				[100019] as '@nProtectedVM',
				[100021] as '@nArchivedVM',
				[100024] as '@EndpointUsers',
				[100025] as '@SharingUsers',
				[100026] as '@eDiscoveryUsers',
				[100027] as '@VMWithACV',
				[100028] as '@MSimUsers',
				[100031]*1024 as '@AppStoreSpaceMB',
				[100032] as '@nOIUsers',
				[100033] as '@nVOIUsers',
				[100034]*1024 as '@nActEDisFilesMB',
				[100035] as '@nActEDisECApps',
				[100036]*1024 as '@nActSensDataFilesMB',
				[100037] as '@nActSensDataECApps',
				[100038]*1024 as '@nFileStoreOptMB',
				[100039] as '@nActSuite',
				[100040] as '@nDRVM',
				[100041]*1024 as '@nMetallicStoreMB',
				[100042]*1024 as '@nMetallicStoreT2MB',
				[100043]*1024 as '@nMetallicStoreT3MB',
				[100044]*1024 as '@nMetallicStoreT4MB',
				[100045]*1024 as '@nMetallicStoreT5MB',
				[100046]*1024 as '@nMetallicStoreT6MB',
				[100047]*1024 as '@nMetallicStoreT7MB',
				[100048]*1024 as '@nMetallicStoreT8MB',
				[100049]*1024 as '@nMetallicStoreT9MB',
				[100050]*1024 as '@nMetallicStoreT10MB'
			FROM #tmpLicUsage11
				PIVOT (MAX(usage) FOR licType IN (
				[100013], [100015], [100016], [100017], [100018], [100019], [100021], [100024], [100025], [100026], [100027], [100028], [100031], [100032], [100033], [100034], [100035], [100036], [100037], [100038], [100039],[100040],[100041],[100042],[100043],[100044],[100045],[100046],[100047],[100048],[100049],[100050])
				) AS P
			FOR
			XML PATH('SubscriptionUsageUsed'), TYPE
		),
--		@i_licUsgTot,
		(
			SELECT
				ISNULL((SELECT Issued*1024 FROM @CapacityLicense WHERE LicType = 100002), 0)	as '@EnterpriseBackupSize',
				ISNULL((SELECT Issued*1024 FROM @CapacityLicense WHERE LicType = 100004), 0)	as '@EnterpriseArchiveSize',
				ISNULL((SELECT Issued*1024 FROM @CapacityLicense WHERE LicType = 100005), 0)	as '@SnapshotSize',
				ISNULL((SELECT Issued*1024 FROM @CapacityLicense WHERE LicType = 100006), 0)	as '@ReplicationSize'
			FOR
			XML PATH('LicenseUsageTotal'), TYPE
		),
		(
			SELECT
				ISNULL((SELECT Used*1024 FROM @CapacityLicense WHERE LicType = 100002), 0)	as '@EnterpriseBackupSize',
				ISNULL((SELECT Used*1024 FROM @CapacityLicense WHERE LicType = 100004), 0)	as '@EnterpriseArchiveSize',
				ISNULL((SELECT Used*1024 FROM @CapacityLicense WHERE LicType = 100005), 0)	as '@SnapshotSize',
				ISNULL((SELECT Used*1024 FROM @CapacityLicense WHERE LicType = 100006), 0)	as '@ReplicationSize'
			FOR
			XML PATH('LicenseUsageUsed'), TYPE
		),
		(
			SELECT
				(SELECT Eval*1024  FROM @CapacityLicense WHERE LicType = 100002)	as '@BackupSizeMB',
				(SELECT EvalExpiry FROM @CapacityLicense WHERE LicType = 100002)	as '@BackupExpiry',
				(SELECT Eval*1024  FROM @CapacityLicense WHERE LicType = 100004)	as '@ArchiveSizeMB',
				(SELECT EvalExpiry FROM @CapacityLicense WHERE LicType = 100004)	as '@ArchiveExpiry',
				(SELECT Eval*1024  FROM @CapacityLicense WHERE LicType = 100005)	as '@SnapshotSizeMB',
				(SELECT EvalExpiry FROM @CapacityLicense WHERE LicType = 100005)	as '@SnapshotExpiry',
				(SELECT Eval*1024  FROM @CapacityLicense WHERE LicType = 100006)	as '@ReplicationSizeMB',
				(SELECT EvalExpiry FROM @CapacityLicense WHERE LicType = 100006)	as '@ReplicationExpiry'
			FOR
			XML PATH('LicenseUsageEval'), TYPE
		)
	 FOR XML PATH('CapacityLicenseUsage'))
SET @logXML =
(
	SELECT
		@queryId AS '@QueryId',
		@LogDate AS '@LogDate',
		@surveyXML
	FOR XML PATH('Rpt_CSSXMLDATA')
)
DROP TABLE #tmpLicUsage11
DECLARE @tempFlag int
IF EXISTS(SELECT name FROM GXGlobalParam WHERE name = 'CommservSurveyRunning')
BEGIN
	SELECT @metricsType = value from GXGlobalParam where name ='CommservSurveyRunning'
END
IF (@metricsType = 'Diagnostics and Usage') --public
BEGIN
	SET @tempFlag = 1
END
IF (@metricsType = 'Metrics Reporting') --private
BEGIN
	SET @tempFlag = 2
END
ELSE IF (@metricsType = 'Metrics Direct Dip') --direct dip
BEGIN
	SET @tempFlag = 16
END
INSERT INTO RptSurveyLog VALUES (@logDate, @queryId, @logXML, @tempFlag)
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommservSurveyCapacityLicenseUsage')
	delete from GxQscripts where name = 'RptCommservSurveyCapacityLicenseUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommservSurveyCapacityLicenseUsage')
	delete from GXDBVersions where aliasname = 'RptCommservSurveyCapacityLicenseUsage'
GO

insert into GXDBVersions values(2, 'RptCommservSurveyCapacityLicenseUsage',  '00000000000000000000', 'RptCommservSurveyCapacityLicenseUsage', '00000000000000000000')
GO

