

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptCommservSurvey.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  RptCommservSurvey()
--  +========================================================================+
-- Parameters - i_dynamicQuery should strinctly follow below guidelines
--
--1. Look at the SAMPLE QUERY Section of any existing query
--2. QueryId = 1 is used for Commserve License Usage Survey script stored in Commserver. Pick up a unique QueryId that is NOT USED EARLIER from table cf_CommservSurveyQueries present in CVCloud database.
--3. DO SET @outputXML as result of the dynamic query. The output should include QueryId and LogData as shown in the SAMPLE QUERY section.
--4. DO NOT DECLARE @outputXML or SELECT @outputXML [just "SET @outputXML" is good enough]. @outputXML is used as output parameter for sp_executesql in RptCommservSurvey stored proc to execute dynamic query.
--5. DO NOT include any SELECT statements that return rows. If there is any such SELECT statement, we might not be able to catch failure for that script.
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptCommservSurvey')
BEGIN
	print '>>> Drop Stored Procedure: RptCommservSurvey <<<'
	drop procedure RptCommservSurvey
END
IF EXISTS (select * from GxQscripts where name='RptCommservSurvey')
	delete from GxQscripts where name = 'RptCommservSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommservSurvey')
	delete from GXDBVersions where aliasname = 'RptCommservSurvey'
GO
print '... Creating Procedure: RptCommservSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommservSurvey
  @i_dynamicQuery NVARCHAR(MAX),
  @i_queryId INTEGER,
  @i_mode INTEGER
AS
DECLARE @logDate BIGINT
DECLARE @queryId INTEGER
DECLARE @logXML XML = NULL
DECLARE @o_ErrorCode INTEGER
DECLARE @metricsType VARCHAR(256)='Diagnostic and Usage'
IF (@i_queryId = NULL OR @i_queryId <= 0)
	SET @i_queryId = -1
DECLARE @ParmDefinition NVARCHAR(500)
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
    DROP TABLE #MetricsInputParams
CREATE TABLE #MetricsInputParams (mode INT )
INSERT INTO #MetricsInputParams(mode) VALUES(@i_mode)
SET @ParmDefinition = N'@outputXML XML OUTPUT';
EXECUTE sp_executesql @i_dynamicQuery, @ParmDefinition, @outputXML=@logXML OUTPUT
SET @o_ErrorCode = @@ERROR
IF @o_ErrorCode <> 0
BEGIN
	RAISERROR ('Error executing the query', 16, 1)
END
ELSE
IF @logXML IS NOT NULL
BEGIN
	SELECT
		@logDate = R.ref.value('./@LogDate[1]', 'BIGINT'),
		@queryId = R.ref.value('./@QueryId[1]', 'INTEGER')
	FROM @logXML.nodes('/Rpt_CSSXMLDATA') R(ref)
	IF (@logDate IS NULL OR @queryId IS NULL)
	BEGIN
		RAISERROR ('Query Output is not correct', 16, 1)
	END
	ELSE
	BEGIN
		DECLARE @tempFlag int
		IF EXISTS(SELECT name FROM GXGlobalParam WHERE name = 'CommservSurveyRunning')
		BEGIN
			SELECT @metricsType = value from GXGlobalParam where name ='CommservSurveyRunning'
		END
		IF (@metricsType = 'Diagnostics and Usage') --public
		BEGIN
			SET @tempFlag = 1
		END
		IF (@metricsType = 'Metrics Reporting') --private
		BEGIN
			SET @tempFlag = 2
		END
		ELSE IF (@metricsType = 'Metrics Direct Dip') --direct dip
		BEGIN
			SET @tempFlag = 16
		END
		IF(@i_mode = 1)
			SET @tempFlag =   4 -- for private freequency
		ELSE IF(@i_mode = 2)
			SET @tempFlag =   8 -- for public freequency
		INSERT INTO RptSurveyLog VALUES (@logDate, @queryId, @logXML, @tempFlag)
	END
END
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#MetricsInputParams'))
    DROP TABLE #MetricsInputParams
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommservSurvey')
	delete from GxQscripts where name = 'RptCommservSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommservSurvey')
	delete from GXDBVersions where aliasname = 'RptCommservSurvey'
GO

insert into GXDBVersions values(2, 'RptCommservSurvey',  '00000000000000000000', 'RptCommservSurvey', '00000000000000000000')
GO

