

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptCommcellGrowth.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptCommcellGrowth.sp,v $ $Id: rptCommcellGrowth.sp,v 1.36.40.3 2018/03/22 03:11:58 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptCommcellGrowth"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptCommcellGrowth')
BEGIN
	print '>>> Drop Stored Procedure: rptCommcellGrowth <<<'
	drop procedure rptCommcellGrowth
END
IF EXISTS (select * from GxQscripts where name='rptCommcellGrowth')
	delete from GxQscripts where name = 'rptCommcellGrowth'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptCommcellGrowth')
	delete from GXDBVersions where aliasname = 'rptCommcellGrowth'
GO
print '... Creating Procedure: rptCommcellGrowth'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptCommcellGrowth
  @i_jobId integer
AS
  DECLARE @r_type INTEGER;
  DECLARE @r_count1 BIGINT;
  DECLARE @r_count2 BIGINT;
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @i_Datetime1		DATETIME
DECLARE @i_Datetime2		DATETIME
DECLARE @startTime		INT
DECLARE @endTime		INT
DECLARE @weekday1		INT
DECLARE @weekday2		INT
DECLARE @lastWeekendStart1	INT
DECLARE @lastWeekendEnd1	INT
DECLARE @lastWeekendStart2	INT
DECLARE @lastWeekendEnd2	INT
DECLARE @tempLicUsageTime1	TABLE (LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER)
DECLARE @tempLicUsageTime2	TABLE (LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER)
DECLARE @tempBkpStats1		TABLE (jobId INTEGER, bkpLevel INTEGER, servStartDate INTEGER, servEndDate INTEGER, totalUncompBytes BIGINT)
DECLARE @tempBkpStats2		TABLE (jobId INTEGER, bkpLevel INTEGER, servStartDate INTEGER, servEndDate INTEGER, totalUncompBytes BIGINT)
DECLARE @tempLicChange1		TABLE (cId INTEGER, changes INTEGER)
DECLARE @tempLicChange2		TABLE (cId INTEGER, changes INTEGER)
DECLARE @upgradeGroup		TABLE (groupId INTEGER, apptypeId INTEGER)
DECLARE @licUsageInstalled1	TABLE
				(LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER, eval INTEGER, expiryDateUTC DATETIME, opTimeUTC DATETIME)
--DECLARE @dcLicUsageInstalled1	TABLE
--				(LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER, eval INTEGER, expiryDateUTC DATETIME, opTimeUTC DATETIME)
--DECLARE @licUsageUninstalled1	TABLE (LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER, opTimeUTC DATETIME)
--DECLARE @dcLicUsageUninstalled1	TABLE (LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER, opTimeUTC DATETIME)
DECLARE @licUsageInstalled2	TABLE
				(LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER, eval INTEGER, expiryDateUTC DATETIME, opTimeUTC DATETIME)
--DECLARE @dcLicUsageInstalled2	TABLE
--				(LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER, eval INTEGER, expiryDateUTC DATETIME, opTimeUTC DATETIME)
--DECLARE @licUsageUninstalled2	TABLE (LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER, opTimeUTC DATETIME)
--DECLARE @dcLicUsageUninstalled2	TABLE (LicTblId INTEGER, cId INTEGER, LicType INTEGER, appType INTEGER, opTimeUTC DATETIME)
INSERT INTO @upgradeGroup VALUES (1, 1)
INSERT INTO @upgradeGroup VALUES (1, 11)
INSERT INTO @upgradeGroup VALUES (1, 33)
INSERT INTO @upgradeGroup VALUES (1, 34)
INSERT INTO @upgradeGroup VALUES (1, 42)
INSERT INTO @upgradeGroup VALUES (1, 43)
INSERT INTO @upgradeGroup VALUES (2, 14)
INSERT INTO @upgradeGroup VALUES (2, 8)
INSERT INTO @upgradeGroup VALUES (2, 54)
INSERT INTO @upgradeGroup VALUES (3, 81)
INSERT INTO @upgradeGroup VALUES (3, 70)
INSERT INTO @upgradeGroup VALUES (3, 4)
INSERT INTO @upgradeGroup VALUES (3, 16)
INSERT INTO @upgradeGroup VALUES (4, 59)
INSERT INTO @upgradeGroup VALUES (4, 6)
INSERT INTO @upgradeGroup VALUES (5, 60)
INSERT INTO @upgradeGroup VALUES (5, 7)
INSERT INTO @upgradeGroup VALUES (6, 9)
INSERT INTO @upgradeGroup VALUES (6, 53)
INSERT INTO @upgradeGroup VALUES (6, 15)
INSERT INTO @upgradeGroup VALUES (7, 45)
INSERT INTO @upgradeGroup VALUES (7, 56)
INSERT INTO @upgradeGroup VALUES (7, 57)
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
if @startTime = 0 -- if STARTDATE is undefined assume CreateTimeUTC
BEGIN
	SET @startTime = dbo.GetUnixTime((select top 1 CreateTimeUTC from licUsageHistory))
END
SET @i_Datetime1 = dbo.GetDateTime(@startTime)
IF @endTime > 0 -- if ENDDATE is undefined assume CurrentTimeUTC
	SET @i_Datetime2 = dbo.GetDateTime(@endTime)
ELSE
BEGIN
	SET @i_Datetime2 = getutcdate()
	SET @endTime = dbo.GetUnixTime(@i_Datetime2)
END
--Optimization changes
DECLARE @tmptbl TABLE(col int)
INSERT INTO @tmptbl
SELECT cId FROM licUsageHistory where licType NOT IN (71, -1, -1) AND Optype = 'Deleted'
INSERT INTO @tmptbl
SELECT cId FROM licUsageHistory
WHERE (appType < 1000 AND licType NOT IN (71, -1, -1)) and Optype = 'Uninstall'
--SELECT id, cId, licType, appType, optype, eval, expiryDateUTC, opTimeUTC INTO #tempDeletedClients
--FROM licUsageHistory
--WHERE (cId in (SELECT cId FROM licUsageHistory where licType NOT IN (SIM_CSL_AT_V2_CENTERRA, SIM_CSL_AT_V2_LCP, SIM_CSL_AT_V2_SHARELCP) AND Optype = 'Deleted') or
--		cId in (SELECT cId
--		FROM licUsage
--		WHERE (appType < 1000 AND licType NOT IN (SIM_CSL_AT_V2_CENTERRA, SIM_CSL_AT_V2_LCP, SIM_CSL_AT_V2_SHARELCP)) and Optype = 'Uninstall') )
--		AND licType NOT IN (SIM_CSL_AT_V2_CENTERRA, SIM_CSL_AT_V2_LCP, SIM_CSL_AT_V2_SHARELCP)
--*****************************************************************************************
-- optimization changes
INSERT INTO @licUsageInstalled1
SELECT	max(id), cId, licType, appType, eval, expiryDateUTC, opTimeUTC
FROM	licUsageHistory
WHERE	(OpType = 'Install' or OpType = 'Upgrade') AND (eval = 0 OR expiryDateUTC > @i_Datetime1) AND opTimeUTC <= @i_Datetime1
group by OpTimeUTC, CId, LicType, AppType, Eval, ExpiryDateUTC
--INSERT INTO @licUsageUninstalled1
--SELECT	id, cId, licType, appType, opTimeUTC
--FROM	licUsageHistory
--WHERE	optype = 'Uninstall' AND opTimeUTC <= @i_Datetime1
--INSERT INTO @dcLicUsageInstalled1
--SELECT	id, cId, licType, appType, eval, expiryDateUTC, opTimeUTC
--FROM	#tempDeletedClients
--WHERE	optype = 'Install' AND (eval = 0 OR expiryDateUTC > @i_Datetime1) AND opTimeUTC <= @i_Datetime1
--INSERT INTO @dcLicUsageUninstalled1
--SELECT	id, cId, licType, appType, opTimeUTC
--FROM	#tempDeletedClients
--WHERE	optype = 'Uninstall' AND opTimeUTC <= @i_Datetime1
INSERT INTO @licUsageInstalled2
SELECT	max(id), cId, licType, appType, eval, expiryDateUTC, opTimeUTC
FROM	licUsageHistory
WHERE	(OpType = 'Install' or OpType = 'Upgrade') AND opTimeUTC <= @i_Datetime2
group by OpTimeUTC, CId, LicType, AppType, Eval, ExpiryDateUTC
--INSERT INTO @licUsageUninstalled2
--SELECT	id, cId, licType, appType, opTimeUTC
--FROM	licUsage
--WHERE	optype = 'Uninstall' AND opTimeUTC <= @i_Datetime2
--INSERT INTO @dcLicUsageInstalled2
--SELECT	id, cId, licType, appType, eval, expiryDateUTC, opTimeUTC
--FROM	#tempDeletedClients
--WHERE	optype = 'Install' AND (eval = 0 OR expiryDateUTC > @i_Datetime2) AND opTimeUTC <= @i_Datetime2
--INSERT INTO @dcLicUsageUninstalled2
--SELECT	id, cId, licType, appType, opTimeUTC
--FROM	#tempDeletedClients
--WHERE	optype = 'Uninstall' AND opTimeUTC <= @i_Datetime2
--*****************************************************************************************
INSERT INTO @tempLicChange1
SELECT	cid, count(apptype)
FROM	@licUsageinstalled1 L1
WHERE	L1.apptype < 1000 OR
	 (1=(select count(DISTINCT groupId) from @upgradeGroup where apptypeId IN (L1.appType)))
GROUP BY cid
INSERT INTO @tempLicChange2
SELECT	cid, count(apptype)
FROM	@licUsageInstalled2 L1
WHERE	L1.apptype < 1000 OR
		(1=(select count(DISTINCT groupId) from @upgradeGroup where apptypeId IN (L1.appType)))
GROUP BY cid
--UNION
--SELECT	cid, count(apptype)
--FROM	@dcLicUsageUninstalled2 T1
--WHERE	T1.apptype < 1000 AND
--	EXISTS (SELECT * FROM @dcLicUsageInstalled2 T2
--		WHERE	T1.opTimeUTC < T2.opTimeUTC AND T1.cId = T2.cId AND
--			(T2.appType = T1.appType OR 1=(select count(DISTINCT groupId) from @upgradeGroup where apptypeId IN (T2.appType, T1.appType))))
--GROUP BY cid
INSERT INTO @tempLicUsageTime1
SELECT	LicTblId, cId, licType, appType
FROM	@licUsageInstalled1 L1
WHERE	(eval = 0 OR expiryDateUTC > @i_Datetime1)
INSERT INTO @tempLicUsageTime2
SELECT	LicTblId, cId, licType, appType
FROM	@licUsageInstalled2 L1
WHERE	(eval = 0 OR expiryDateUTC > @i_Datetime2)
SET @weekday1 = case DATEPART(WEEKDAY, @i_Datetime1) when 1 then 8 else DATEPART(WEEKDAY, @i_Datetime1) end
SET @lastWeekendEnd1 = dbo.GetUnixTime(dbo.GetDayStart(@i_Datetime1, 0)) - (@weekday1 - 2) * 3600 * 24 - 1
SET @lastWeekendStart1 = @lastWeekendEnd1 - 3600 * 24 * 2 + 1
SET @weekday2 = case DATEPART(WEEKDAY, @i_Datetime2) when 1 then 8 else DATEPART(WEEKDAY, @i_Datetime2) end
SET @lastWeekendEnd2 = dbo.GetUnixTime(dbo.GetDayStart(@i_Datetime2, 0)) - (@weekday2 - 2) * 3600 * 24 - 1
SET @lastWeekendStart2 = @lastWeekendEnd2 - 3600 * 24 * 2 + 1
DECLARE @timezone NVARCHAR(255) =  (select dbo.GetClientTimeZone(2))
SET @lastWeekendStart1 =dbo.GetUnixTimeBig( dbo.LocalToUTCTime( dbo.GetDateTime(@lastWeekendStart1),@timezone))
SET @lastWeekendStart2 =dbo.GetUnixTimeBig( dbo.LocalToUTCTime( dbo.GetDateTime(@lastWeekendStart2),@timezone))
SET @lastWeekendEnd1 =dbo.GetUnixTimeBig( dbo.LocalToUTCTime( dbo.GetDateTime(@lastWeekendEnd1),@timezone))
SET @lastWeekendEnd2 =dbo.GetUnixTimeBig( dbo.LocalToUTCTime( dbo.GetDateTime(@lastWeekendEnd2),@timezone))
INSERT INTO @tempBkpStats1
SELECT	jobId, bkpLevel, servStartDate, servEndDate, totalUncompBytes
FROM	JMBkpStats
WHERE	(servStartDate > @lastWeekendStart1 OR servStartDate > (@startTime - 3600 * 24 * 7)) AND servStartDate < @startTime
INSERT INTO @tempBkpStats2
SELECT	jobId, bkpLevel, servStartDate, servEndDate, totalUncompBytes
FROM	JMBkpStats
WHERE	(servStartDate > @lastWeekendStart2 OR servStartDate > (@endTime - 3600 * 24 * 7)) AND servStartDate < @endTime
CREATE TABLE #tempReturnList(
	type	integer,
	count1	BIGINT,
	count2	BIGINT
)
-- pass start/end time to the event manager
INSERT INTO #tempReturnList VALUES(0, @startTime, @endTime)
INSERT INTO #tempReturnList VALUES(1, 0, 0)
INSERT INTO #tempReturnList VALUES(9, 0, 0)
INSERT INTO #tempReturnList VALUES(10, 0, 0)
INSERT INTO #tempReturnList VALUES(11, 0, 0)
INSERT INTO #tempReturnList VALUES(12, 0, 0)
INSERT INTO #tempReturnList VALUES(13, 0, 0)
INSERT INTO #tempReturnList VALUES(14, 0, 0)
--INSERT INTO #tempReturnList VALUES(CCG_ENT_DRIVE_COUNT, 0, 0)
--INSERT INTO #tempReturnList VALUES(CCG_ENT_LIB_COUNT, 0, 0)
INSERT INTO #tempReturnList VALUES(2, 0, 0)
INSERT INTO #tempReturnList VALUES(3, 0, 0)
INSERT INTO #tempReturnList VALUES(6, 0, 0)
--INSERT INTO #tempReturnList VALUES(CCG_ENT_USER_COUNT, 0, 0)
INSERT INTO #tempReturnList VALUES(15, 0, 0)
INSERT INTO #tempReturnList VALUES(8, 0, 0)
INSERT INTO #tempReturnList VALUES(25, 0, 0)
INSERT INTO #tempReturnList VALUES(26, 0, 0)
INSERT INTO #tempReturnList VALUES(17, 0, 0)
INSERT INTO #tempReturnList VALUES(18, 0, 0)
INSERT INTO #tempReturnList VALUES(19, 0, 0)
INSERT INTO #tempReturnList VALUES(20, 0, 0)
INSERT INTO #tempReturnList VALUES(21, 0, 0)
INSERT INTO #tempReturnList VALUES(22, 0, 0)
INSERT INTO #tempReturnList VALUES(23, 0, 0)
INSERT INTO #tempReturnList VALUES(24, 0, 0)
--UPDATE	#tempReturnList
--SET	count1=(SELECT	COUNT(DISTINCT cId) FROM @tempLicUsageTime1
--		WHERE	licType = SIM_CSL_AT_V2_CCBASE AND appType = CV_APPTYPE_COMMCLNTMGMT),
--	count2=(SELECT	COUNT(DISTINCT cId) FROM @tempLicUsageTime2
--		WHERE	licType = SIM_CSL_AT_V2_CCBASE AND appType = CV_APPTYPE_COMMCLNTMGMT)
--WHERE type = CCG_ENT_CLIENT_INSTALLED
UPDATE	#tempReturnList
SET	count1=(select count(DISTINCT C.clientId) from APP_ClientInstallHistory C, APP_Platform P
        where   C.clientId=P.clientId AND PlatformType = 4 and NOT EXISTS
        (select * from APP_ClientProp
         where C.clientId=componentNameId and attrName='platformdeleted 4' and modified=0 and attrVal='1') AND
		 (@startTime > installTime) AND ((@startTime <= uninstallTime) OR (uninstallTime = 0))),
	count2 =(select count(DISTINCT C.clientId) from APP_ClientInstallHistory C, APP_Platform P
        where   C.clientId=P.clientId AND PlatformType = 4 and NOT EXISTS
        (select * from APP_ClientProp
         where C.clientId=componentNameId and attrName='platformdeleted 4' and modified=0 and attrVal='1') AND
		(@endTime > installTime) AND ((@endTime <= uninstallTime) OR (uninstallTime = 0)))
WHERE type = 1
UPDATE	#tempReturnList
SET	count1=(SELECT COUNT(tbl.CId)
			FROM (SELECT MAX(id) tblId, cid, OpType
					FROM LicUsage
					WHERE licType IN (select simlicapptype from simAppTypeLicTypeMap, app_idaType WHERE displayName LIKE '%MediaAgent%' and type =appTypeId and simlicapptype < 1000)
AND OpTimeUTC < @i_Datetime1 AND (OpType = 'install' or OpType = 'upgrade') AND (Eval = 0 OR ExpiryDateUTC > @i_Datetime1) and AppType = 1002 group by cid, OpType) tbl),
	count2=(SELECT COUNT(tbl.CId)
			FROM (SELECT MAX(id) tblId, cid, OpType
					FROM LicUsage
					WHERE licType IN (select simlicapptype from simAppTypeLicTypeMap, app_idaType WHERE displayName LIKE '%MediaAgent%' and type =appTypeId and simlicapptype < 1000)
AND OpTimeUTC < @i_Datetime2 AND (OpType = 'install' or OpType = 'upgrade') AND (Eval = 0 OR ExpiryDateUTC > @i_Datetime2) and AppType = 1002 group by cid, OpType) tbl)
WHERE type = 3
CREATE TABLE #tempLicUsage1  (id int,cid int,apptype int)
CREATE TABLE #tempLicUsage2  (id int,cid int,apptype int)
 INSERT INTO #tempLicUsage1
 select MAX(id) tblID, CId,  AppType from licUsageHistory where OpTimeUTC <= @i_Datetime1
 AND AppType < 1000 AND AppType NOT IN (SELECT componentNameId FROM simApptypeProp WHERE attrName LIKE 'DummyApptype')
 group by cid,  apptype
INSERT INTO #tempLicUsage2
select MAX(id) tblID, CId,  AppType from licUsageHistory where OpTimeUTC <= @i_Datetime2
AND AppType < 1000 AND AppType NOT IN (SELECT componentNameId FROM simApptypeProp WHERE attrName LIKE 'DummyApptype')
group by cid, apptype
UPDATE	#tempReturnList
SET	count1=(SELECT	COUNT(*)
			FROM	(select T.id,T.cid,T.appType,LH.opType from #tempLicUsage1 T INNER JOIN licUsageHistory LH ON T.id = LH.id AND LH.Cid = T.cid  and T.apptype = LH.apptype
		 where LH.OpType = 'install' or LH.OpType = 'upgrade') AS T1),
	count2=(SELECT count(*)
			FROM
				(select T.id,T.cid,T.appType,LH.opType from #tempLicUsage2 T INNER JOIN licUsageHistory LH ON  t.id = LH.id and LH.Cid = T.cid and T.apptype = LH.apptype
		 where LH.OpType = 'install' or LH.OpType = 'upgrade' ) AS T2)
WHERE type = 2
DROP TABLE #tempLicUsage1
DROP TABLE #tempLicUsage2
--UPDATE	#tempReturnList
--SET	count1=(SELECT	COUNT(*)
--		FROM	(SELECT DISTINCT cId, licType FROM @tempLicUsageTime1
--			WHERE	licType IN (	SIM_CSL_AT_V2_CENTERRA, SIM_CSL_AT_V2_LCP, SIM_CSL_AT_V2_SHARELCP)) AS T1),
--	count2=(SELECT	COUNT(*)
--		FROM	(SELECT DISTINCT cId, licType FROM @tempLicUsageTime2
--			WHERE	licType IN (	SIM_CSL_AT_V2_CENTERRA, SIM_CSL_AT_V2_LCP, SIM_CSL_AT_V2_SHARELCP)) AS T2)
--WHERE type = CCG_ENT_LIB_COUNT
UPDATE	#tempReturnList
SET	count1=(select sum(changes) from @tempLicChange1),
	count2=(select sum(changes) from @tempLicChange2)
WHERE type = 6
UPDATE	#tempReturnList
SET	count1=(SELECT COUNT(DISTINCT jobId) FROM @tempBkpStats1 WHERE	servStartDate > (@startTime - 3600 * 24)),
	count2=(SELECT COUNT(DISTINCT jobId) FROM @tempBkpStats2 WHERE	servStartDate > (@endTime - 3600 * 24))
WHERE type = 15
UPDATE	#tempReturnList
SET	count1=(SELECT SUM(totalUncompBytes) FROM @tempBkpStats1 WHERE	servStartDate > (@startTime - 3600 * 24)),
	count2=(SELECT SUM(totalUncompBytes) FROM @tempBkpStats2 WHERE	servStartDate > (@endTime - 3600 * 24))
WHERE type = 8
UPDATE	#tempReturnList
SET	count1=(SELECT COUNT(DISTINCT jobId) FROM @tempBkpStats1 WHERE	bkpLevel = 2 AND servStartDate > (@startTime - 3600 * 24)),
	count2=(SELECT COUNT(DISTINCT jobId) FROM @tempBkpStats2 WHERE	bkpLevel = 2 AND servStartDate > (@endTime - 3600 * 24))
WHERE type = 9
UPDATE	#tempReturnList
SET	count1=(SELECT SUM(totalUncompBytes) FROM @tempBkpStats1 WHERE	bkpLevel = 2 AND servStartDate > (@startTime - 3600 * 24)),
	count2=(SELECT SUM(totalUncompBytes) FROM @tempBkpStats2 WHERE	bkpLevel = 2 AND servStartDate > (@endTime - 3600 * 24))
WHERE type = 10
UPDATE	#tempReturnList
SET	count1=(SELECT COUNT(DISTINCT jobId) FROM @tempBkpStats1 WHERE	servStartDate > @lastWeekendStart1 AND servStartDate < @lastWeekendEnd1),
	count2=(SELECT COUNT(DISTINCT jobId) FROM @tempBkpStats2 WHERE	servStartDate > @lastWeekendStart2 AND servStartDate < @lastWeekendEnd2)
WHERE type = 11
UPDATE	#tempReturnList
SET	count1=(SELECT SUM(totalUncompBytes) FROM @tempBkpStats1 WHERE	servStartDate > @lastWeekendStart1 AND servStartDate < @lastWeekendEnd1),
	count2=(SELECT SUM(totalUncompBytes) FROM @tempBkpStats2 WHERE	servStartDate > @lastWeekendStart2 AND servStartDate < @lastWeekendEnd2)
WHERE type = 12
UPDATE	#tempReturnList
SET	count1=(SELECT COUNT(DISTINCT jobId) FROM @tempBkpStats1 WHERE	servStartDate > (@startTime - 3600 * 24 * 7)),
	count2=(SELECT COUNT(DISTINCT jobId) FROM @tempBkpStats2 WHERE	servStartDate > (@endTime - 3600 * 24 * 7))
WHERE type = 13
UPDATE	#tempReturnList
SET	count1=(SELECT SUM(totalUncompBytes) FROM @tempBkpStats1 WHERE	servStartDate > (@startTime - 3600 * 24 * 7)),
	count2=(SELECT SUM(totalUncompBytes) FROM @tempBkpStats2 WHERE	servStartDate > (@endTime - 3600 * 24 * 7))
WHERE type = 14
--NO OF CHUNKS WRITTEN
UPDATE	#tempReturnList
SET	count1= (SELECT COUNT(*) FROM ArchChunk WITH (READUNCOMMITTED)
					WHERE  (createTime + writeTime)> (@startTime - 3600 * 24) AND (createTime + writeTime) < @startTime),
	count2= (SELECT COUNT(*) FROM ArchChunk WITH (READUNCOMMITTED)
					WHERE  (createTime + writeTime)> (@endTime - 3600 * 24) AND (createTime + writeTime) < @endTime)
WHERE type = 25
--NO. OF RESERVATIONS
UPDATE	#tempReturnList
SET	count1= (SELECT COUNT(DISTINCT reservationId) FROM jmjobresourcehistory  WHERE ReservationTime > (@startTime - 3600 * 24) AND ReservationTime < @startTime),
	count2= (SELECT COUNT(DISTINCT reservationId)  FROM jmjobresourcehistory  WHERE ReservationTime > (@endTime - 3600 * 24) AND ReservationTime < @endTime)
WHERE type = 26
---scale issues:taking more time
----JOBS COMPLETED IN ONE ATMPT
-----------------------------
--declare @tempbkpatmptstats1 table (commcellid int, jobid int, phase int, phaseAttempts int)
--declare @tempbkpatmptstats2 table (commcellid int, jobid int, phase int, phaseAttempts int)
--insert into @tempbkpatmptstats1
--SELECT commcellid, jobid, phase, COUNT(STATUS) phaseAttempts
--FROM jmbkpatmptstats WITH (READUNCOMMITTED)
--WHERE servstartDate  > (@startTime- 86400 /*(3600 * 24)*/)  AND servStartDate < @startTime
--GROUP BY commcellid, jobid, phase
--
--insert into @tempbkpatmptstats2
--SELECT commcellid, jobid, phase, COUNT(STATUS) phaseAttempts
--FROM jmbkpatmptstats WITH (READUNCOMMITTED)
--WHERE servstartDate  > (@endTime- 86400 /*(3600 * 24)*/) AND servStartDate < @endTime
--GROUP BY commcellid, jobid, phase
--
--UPDATE	#tempReturnList
--SET	count1= (SELECT count(*)
--				 FROM
--				 (
--					SELECT sum(q.phaseattempts)-count(*) as att, q.commcellid as commcellid,q.jobid as jobid
--					FROM @tempbkpatmptstats1 q
--					GROUP BY q.commcellid,q.jobid
--				)q1 WHERE att = 0),
--
--	count2=(SELECT count(*)
--				 FROM
--				 (
--					SELECT sum(q.phaseattempts)-count(*) as att, q.commcellid as commcellid,q.jobid as jobid
--					FROM @tempbkpatmptstats2 q
--					GROUP BY q.commcellid,q.jobid
--				)q1 WHERE att = 0)
--WHERE type = CCG_ENT_JOB_ATTEMPT
----------------------------
--JOBS IN QUEUE(QUEUED)
UPDATE	#tempReturnList
SET	count1= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 15 and jobStartTime > (@startTime - 3600 * 24) AND jobStartTime < @startTime),
	count2= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 15 and jobStartTime > (@endTime - 3600 * 24) AND jobStartTime < @endTime)
WHERE type = 18
--JOBS IN QUEUE(PENDING)
UPDATE	#tempReturnList
SET	count1= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 2 and jobStartTime > (@startTime - 3600 * 24) AND jobStartTime < @startTime),
	count2= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 2 and jobStartTime > (@endTime - 3600 * 24) AND jobStartTime < @endTime)
WHERE type = 19
--JOBS IN QUEUE(WAITING)
UPDATE	#tempReturnList
SET	count1= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 3 and jobStartTime > (@startTime - 3600 * 24) AND jobStartTime < @startTime),
	count2= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 3 and jobStartTime > (@endTime - 3600 * 24)AND jobStartTime < @endTime)
WHERE type = 20
--JOBS IN QUEUE(SUSPENDED)
UPDATE	#tempReturnList
SET	count1= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 5 and jobStartTime > (@startTime - 3600 * 24) AND jobStartTime < @startTime),
	count2= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 5 and jobStartTime > (@endTime - 3600 * 24)AND jobStartTime < @endTime)
WHERE type = 21
--JOBS IN QUEUE(RUNNING)
UPDATE	#tempReturnList
SET	count1= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 1 and jobStartTime > (@startTime - 3600 * 24) AND jobStartTime < @startTime),
	count2= (SELECT COUNT(*) FROM jmjobinfo WITH (READUNCOMMITTED)
			   WHERE state = 1 and jobStartTime > (@endTime - 3600 * 24)AND jobStartTime < @endTime)
WHERE type = 22
--NO. OF MOUNTS/HOUR
DECLARE @i_Datetime3 DATETIME = DATEADD(HH, -24, @i_Datetime1)
DECLARE @i_Datetime4 DATETIME = DATEADD(HH, -24, @i_Datetime2)
UPDATE	#tempReturnList
SET	count1= (SELECT SUM(NumberOfMounts) FROM MMDriveHistory d
			   WHERE HistoryType = 2 AND TimeStart > @i_Datetime3 AND TimeStart < @i_Datetime1),
	count2= (SELECT SUM(NumberOfMounts) FROM MMDriveHistory d
			   WHERE HistoryType = 2 AND TimeStart > @i_Datetime4 AND TimeStart < @i_Datetime2)
WHERE type = 23
---scale issues:taking more time
----MAX NO. OF STRMS TRANSF. DATA
--declare @tempJobResourceHistory1 table (count24hr_ids int)
--declare @tempJobResourceHistory2 table (count24hr_ids int)
--INSERT INTO @tempJobResourceHistory1
--SELECT COUNT(DISTINCT h.StreamId)
--FROM jmjobresourcehistory AS h WITH (READUNCOMMITTED)
--WHERE RMTimeStamp > @sttime AND RMTimeStamp < @startTime
--group by RMTimeStamp/300
--INSERT INTO @tempJobResourceHistory2
--SELECT COUNT(DISTINCT h.StreamId)
--FROM jmjobresourcehistory AS h WITH (READUNCOMMITTED)
--WHERE RMTimeStamp > @ettime AND RMTimeStamp < @endTime
--group by RMTimeStamp/300
--UPDATE	#tempReturnList
--SET	count1= (SELECT MAX(count24hr_ids)
--		     FROM @tempJobResourceHistory1 ),
--	count2= (SELECT MAX(count24hr_ids)
--			 FROM @tempJobResourceHistory2
--		     )
--WHERE type = CCG_ENT_NUM_STREAM
SELECT * FROM #tempReturnList ORDER BY type
--DROP TABLE #tempDeletedClients
DROP TABLE #tempReturnList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommcellGrowth')
	delete from GxQscripts where name = 'RptCommcellGrowth'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommcellGrowth')
	delete from GXDBVersions where aliasname = 'RptCommcellGrowth'
GO

insert into GXDBVersions values(2, 'RptCommcellGrowth',  '00010036004000030000', 'RptCommcellGrowth', '00010036004000030000')
GO

