

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptCheckReEnableSLA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptCheckReEnableSLA.sp,v $ $Id: RptCheckReEnableSLA.sp,v 1.1.2.4 2020/09/02 04:13:09 samrutkar Exp $";
--  +===================================================================+
--  | APPCheckActivityControl - PRIMARY ENTRY POINT FOR ALL CCP OPS         |
--  +===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptCheckReEnableSLA')
BEGIN
	print '>>> Drop Stored Procedure: RptCheckReEnableSLA <<<'
	drop procedure RptCheckReEnableSLA
END
IF EXISTS (select * from GxQscripts where name='RptCheckReEnableSLA')
	delete from GxQscripts where name = 'RptCheckReEnableSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCheckReEnableSLA')
	delete from GXDBVersions where aliasname = 'RptCheckReEnableSLA'
GO
print '... Creating Procedure: RptCheckReEnableSLA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCheckReEnableSLA
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
-----------------------------------------------------------
  @i_fetchOnly integer
AS
  DECLARE @entityType integer
  DECLARE @entityId integer
  DECLARE @entityName NVARCHAR(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE     @nowTime        AS Integer = dbo.GetUnixTime (GetUTCdate())
    IF object_id('tempdb.dbo.#RptSLAEnabled') is not null
        DROP TABLE #RptSLAEnabled
    CREATE TABLE #RptSLAEnabled
    (
	    entityType INT,
		entityId	INT,
		entityName  NVARCHAR(1024)
    )
	INSERT INTO #RptSLAEnabled
	SELECT DISTINCT 158/* (PLAN_ENTITY)*/,AP.Id,AP.Name  FROM APP_PlanProp APP WITH (NOLOCK)
	INNER JOIN App_Plan AP WITH (NOLOCK) ON AP.id = APP.componentNameId
	INNER JOIN APP_PlanProp APP1 WITH (NOLOCK) ON APP1.componentNameId = APP.componentNameId
WHERE APP.attrName = 'SLA option exclusion delay interval'
AND App1.attrName = 'SLA option excluded' AND APP1.attrVal = '1'
	AND CAST (APP.attrVal AS INT) <  @nowTime AND APP.attrVal <> '0' AND App.modified = 0 AND App1.modified = 0
	INSERT INTO #RptSLAEnabled
	select 28,componentId,AG.name from APP_ComponentProp AP WITH (NOLOCK)
	INNER JOIN APP_ClientGroup AG ON AG.id = AP.componentId
where propertyTypeId = 3325 and componentType = 8 and AP.modified = 0
	AND longVal < @nowTime AND longVal <> 0
	IF (@i_fetchOnly = 0 AND EXISTS (select 1 from #RptSLAEnabled))
	BEGIN
		UPDATE APP
		set attrval = '0'
		FROM App_PlanProp  APP
		INNER JOIN #RptSLAEnabled R ON R.entityId = APP.componentNameId
WHERE APP.attrName = 'SLA option exclusion delay interval'
		 AND R.entityType = 158/*(PLAN_ENTITY)*/ AND App.modified = 0
        UPDATE APP
		set attrval = ''
		FROM App_PlanProp  APP
		INNER JOIN #RptSLAEnabled R ON R.entityId = APP.componentNameId
WHERE APP.attrName =  'SLA option description'
		 AND R.entityType = 158/*(PLAN_ENTITY)*/ AND App.modified = 0
		UPDATE AP
		SET longVal = 0
		FROM APP_ComponentProp AP WITH (NOLOCK)
		INNER JOIN #RptSLAEnabled R ON R.entityId = AP.componentId
WHERE propertyTypeId = 3325 and componentType = 8 and AP.modified = 0 AND R.entityType = 28 /* CLIENT_GROUP_ENTITY*/
		UPDATE AP
		SET longVal = 0
		FROM APP_ComponentProp AP WITH (NOLOCK)
		INNER JOIN #RptSLAEnabled R ON R.entityId = AP.componentId
WHERE propertyTypeId = 3301 and componentType = 8 and AP.modified = 0 AND R.entityType = 28 /* CLIENT_GROUP_ENTITY*/
		UPDATE AP
		SET stringVal = ''
		FROM APP_ComponentProp AP WITH (NOLOCK)
		INNER JOIN #RptSLAEnabled R ON R.entityId = AP.componentId
WHERE propertyTypeId = 3326 and componentType = 8 and AP.modified = 0 AND R.entityType = 28 /* CLIENT_GROUP_ENTITY*/
   END
	select entityType,entityId,entityName from #RptSLAEnabled
	IF object_id('tempdb.dbo.#RptSLAEnabled') is not null
        DROP TABLE #RptSLAEnabled

IF EXISTS (select * from GxQscripts where name = 'RptCheckReEnableSLA')
	delete from GxQscripts where name = 'RptCheckReEnableSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCheckReEnableSLA')
	delete from GXDBVersions where aliasname = 'RptCheckReEnableSLA'
GO

insert into GXDBVersions values(2, 'RptCheckReEnableSLA',  '00010001000200040000', 'RptCheckReEnableSLA', '00010001000200040000')
GO

