

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptCCReadinessCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptCCReadinessCheck.sp,v $ $Id: RptCCReadinessCheck.sp,v 1.40.14.21.8.1 2021/03/09 23:53:22 nbirru Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptCCReadinessCheck"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptCCReadinessCheck')
BEGIN
	print '>>> Drop Stored Procedure: RptCCReadinessCheck <<<'
	drop procedure RptCCReadinessCheck
END
IF EXISTS (select * from GxQscripts where name='RptCCReadinessCheck')
	delete from GxQscripts where name = 'RptCCReadinessCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCCReadinessCheck')
	delete from GXDBVersions where aliasname = 'RptCCReadinessCheck'
GO
print '... Creating Procedure: RptCCReadinessCheck'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptCCReadinessCheck
  @i_jobId integer,
  @i_clientId integer,
  @i_userId integer,
  @i_xml xml
AS
  DECLARE @o_CCRId integer;
SET NOCOUNT ON
DECLARE @CCRID		integer
DECLARE @userId		integer
DECLARE @startTime	integer
DECLARE @clOpt		integer
DECLARE @appTypeOpt	integer
DECLARE @tblClients	TABLE (t_clId int)
DECLARE @tblApptypes	TABLE (t_appTypeId int)
--*****************************************************************************--
--																			   --
--	Note : This stored procedure is being used for Gui Connectivity check	   --
--	If you modify this proc for reports please do verify the option			   --
--	CheckConnectivity on the GUI											   --
--	JobId=0 and CliendId != 0 is for Connectivity check on the GUI			   --
--																			   --
--*****************************************************************************--
DECLARE @tmpExternalClient TABLE (id INT)
SET @startTime	= dbo.GetUnixTime(getutcdate())
IF (len(cast(@i_xml as nvarchar(max)))>0)
BEGIN
	DECLARE @handle INT;
	EXEC sp_xml_preparedocument @handle OUTPUT, @i_xml
	DECLARE @includeAll INT
	SET @includeAll = ISNULL((SELECT TOP 1 includeAll FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList', 1) WITH (includeAll int)), 0)
	IF(@includeAll = 1)
		SET	   @clOpt = 0
	ELSE
	BEGIN
		SET	   @clOpt = 1
		DECLARE @tblClientGrps	TABLE (id int)
		INSERT INTO @tblClientGrps
			SELECT clientGroupId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientGroupList', 1) WITH (clientGroupId int)
		INSERT INTO @tblClients
			SELECT clientId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientList', 1) WITH (clientId int)
			UNION
			SELECT clientId FROM APP_ClientGroupAssoc (NOLOCK) WHERE clientGroupId in (SELECT id FROM @tblClientGrps)
	END
	SET    @appTypeOpt = 0
	SET @userId	= @i_userId
END
ELSE IF (@i_jobId != 0 AND @i_clientId = 0 )
BEGIN
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
	INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetObjectList @i_jobId, 444361887, @appTypeOpt OUTPUT
	--Get NBU client list
	INSERT INTO @tmpExternalClient
	SELECT C.id
	FROM APP_Client C WITH (READUNCOMMITTED) , APP_CommCell Cell WITH (READUNCOMMITTED)
	WHERE C.origCCId = Cell.id and Cell.type = 100
END
ELSE
BEGIN
	INSERT INTO @tblClients(t_clId) values(@i_clientId)
	INSERT INTO @tblAppTypes(t_appTypeId) select distinct appTypeId from APP_Application WITH (READUNCOMMITTED) where ClientId = @i_clientId
	SET	   @clOpt = 1
	SET    @appTypeOpt = 1
	SET @userId	= @i_userId
END
--clients having all non real subclients
--real subclient, if subclientStatus exist in {0, CV_STATUS_DEFAULT	0x00008}
--otherwise, Non real subclients {CV_STATUS_DELETED	0x00004, CV_STATUS_DUMMY 0x00010,CV_STATUS_HIDDEN	0x00020, CV_STATUS_CMD_LINE	0x0040}
DECLARE @tblClientsWithNonRealSubclients	TABLE (clientId int)
insert into @tblClientsWithNonRealSubclients
select  C.id from APP_Client C WITH (READUNCOMMITTED)
where id not in (select distinct clientid from app_application WITH (READUNCOMMITTED)
					 where subclientstatus =0
					OR ((subclientstatus & 8) >0) AND  ((subclientstatus & 48) = 0  )
					OR ((subclientstatus &256) >0 AND  ((subclientstatus & 48) = 0 )))
if @clOpt >0
	delete from @tblClientsWithNonRealSubclients
	where clientId not in (
	select t_clId  from @tblClients )
--begin--For VSA pseudo clients, we need to involve the member servers
	declare @pseudoVSAClients xml;
	set @pseudoVSAClients = (select (
	select t_clId as '@id'
	from @tblClients C
	where Exists (select clientId
					from APP_IDAName IDA WITH (READUNCOMMITTED)
					where C.t_clId = IDA.clientId
AND appTypeId = 106
							AND not exists (select clientId from simInstalledPackages SIM WITH (READUNCOMMITTED) where IDA.clientId=SIM.clientId )
				)
	for xml path('client'), TYPE) for xml path('pseudoVSAClients'));
	--select @pseudoVSAClients --gets the pseudo vsa clients in the CS as xml rows
	IF object_id('tempdb.dbo.#pseudoVSANodes') IS NOT null	DROP TABLE #pseudoVSANodes
	CREATE TABLE #pseudoVSANodes(pseudoClient int, node int);
	insert into #pseudoVSANodes
	EXEC AppGetVSMemberServersXML @pseudoVSAClients
	insert into @tblClients
	select distinct node from #pseudoVSANodes N where not exists(select t_clId from @tblClients C where C.t_clId = N.node)
	DROP TABLE #pseudoVSANodes
--end
IF object_id('tempdb.dbo.#TEMP_DATAPATH') IS NOT null DROP TABLE #TEMP_DATAPATH
CREATE TABLE #TEMP_DATAPATH(	dataPathId		integer,
				drivePoolId		integer,
				drivePoolName		nvarchar(256),
				drivePoolType		integer,
				mediaAgentId		integer,
				NDMPHostId		integer,
				mediaAgentName		varchar(256),
				libraryId		integer,
				libraryName		varchar(256),
				libraryAliasName	nvarchar(256),
				libraryType		integer,
				clientInterface		varchar(256),
				mediaAgentInterface	varchar(256),
				HWCompression		integer,
				DataPathFlag		integer,
				numRows			integer,
				archGroupId		integer,
				clientId		integer)
-- get subclient list
 IF object_id('tempdb.dbo.#CHECK_LIST1') IS NOT null DROP TABLE #CHECK_LIST1
 SELECT subclientId=id,clientId,appTypeId,instance,dataArchGrpId,logArchGrpId,subclientName INTO #CHECK_LIST1
 FROM APP_Application APP WITH (READUNCOMMITTED)
 WHERE  (@clOpt = 0 OR EXISTS (SELECT t_clId FROM @tblClients where t_clId = APP.clientId))
	AND (@appTypeOpt = 0 OR EXISTS (SELECT t_appTypeId FROM @tblApptypes WHERE APP.appTypeId = t_appTypeId))
	AND (
				APP.subClientStatus & 2 = 0
			OR
				(
					( APP.subClientStatus & 2 = 2 ) AND EXISTS ( SELECT SIM.clientId FROM SimInstalledPackages SIM WHERE APP.clientId = SIM.clientId ) --Allow clients with siminstalled packages but with subclientstatus as uninstalled(restore-only clients)
				)
		)
	AND (APP.subClientStatus & 4) = 0
	AND (((APP.subClientStatus & 32) = 0 OR EXISTS (select clientId from @tblClientsWithNonRealSubclients WHERE clientId = APP.clientId))
	AND (APP.subClientStatus & 16) = 0 OR (APP.subClientStatus & 64) > 0)
	IF object_id('tempdb.dbo.#ClientWithoutSubclients') IS NOT NULL drop table #ClientWithoutSubclients
	CREATE TABLE #ClientWithoutSubclients (clientId int )
	IF (@clOpt = 0)
	INSERT INTO #ClientWithoutSubclients
		SELECT DISTINCT C.id from APP_Client C WITH (NOLOCK)
		INNER JOIN    (select clientid,max(HighestSP) AS 'HighestSP' from simInstalledPackages WITH (NOLOCK) group by ClientId) sim  ON sim.ClientId = C.id
		LEFT OUTER JOIN APP_Application AP WITH (NOLOCK) ON  C.id = AP.clientId
		WHERE AP.clientId IS NULL AND (c.releaseId > 16 or (c.releaseId = 16 and sim.highestSP >= 17))
	ELSE
	INSERT INTO #ClientWithoutSubclients
		SELECT DISTINCT C.id from APP_Client C WITH (NOLOCK)
		INNER JOIN @tblClients t on c.id = t.t_clId
		INNER JOIN    (select clientid,max(HighestSP) AS 'HighestSP' from simInstalledPackages WITH (NOLOCK) group by ClientId) sim  ON sim.ClientId = C.id
		LEFT OUTER JOIN APP_Application AP WITH (NOLOCK) ON  C.id = AP.clientId
		WHERE AP.clientId IS NULL AND (c.releaseId > 16 or (c.releaseId = 16 and sim.highestSP >= 17))
	IF object_id('tempdb.dbo.#DBAgentsToPerformNetChk') IS NOT NULL drop table #DBAgentsToPerformNetChk
	CREATE TABLE #DBAgentsToPerformNetChk (AppTypeId INT)
INSERT INTO #DBAgentsToPerformNetChk values (3), (22), (80), (81), (135), (125), (104), (37), (62), (103), (80), (5), (61), (79)
	IF object_id('tempdb.dbo.#ClientWithOnlyDBAgents') IS NOT NULL drop table #ClientWithOnlyDBAgents
    CREATE TABLE #ClientWithOnlyDBAgents (clientId int)
    IF (@clOpt = 0)
    INSERT INTO #ClientWithOnlyDBAgents
	    SELECT DISTINCT C.id FROM APP_Client C WITH (NOLOCK)
	    INNER JOIN APP_Application A WITH (NOLOCK) ON C.id = A.clientId
	    INNER JOIN #DBAgentsToPerformNetChk DB ON A.appTypeId = DB.AppTypeId
	ELSE
	INSERT INTO #ClientWithOnlyDBAgents
	    SELECT DISTINCT C.t_clId FROM @tblClients C
	    INNER JOIN APP_Application A WITH (NOLOCK) ON C.t_clId = A.clientId
	    INNER JOIN #DBAgentsToPerformNetChk DB ON A.appTypeId = DB.AppTypeId
    DELETE FROM #ClientWithOnlyDBAgents
    WHERE clientId IN (SELECT DISTINCT C.clientId FROM #ClientWithOnlyDBAgents C WITH (NOLOCK)
    INNER JOIN APP_Application A WITH (NOLOCK) ON C.clientId = A.clientId
    INNER JOIN APP_BackupSetName B (nolock) ON A.backupset = B.id
WHERE A.appTypeId NOT in (SELECT appTypeId FROM #DBAgentsToPerformNetChk) OR (A.appTypeId in (SELECT appTypeId FROM #DBAgentsToPerformNetChk) AND B.status & 0x00010 = 0))
    INSERT INTO #ClientWithoutSubclients
    select clientId from #ClientWithOnlyDBAgents
	DELETE FROM #ClientWithoutSubclients
	where clientId IN (
	select attrVal from APP_ClientProp where attrName like 'Linked CS Client' and modified = 0)
	DECLARE @IdentInsQueryCheckList NVARCHAR(MAX)
	SET @IdentInsQueryCheckList = 'INSERT INTO #CHECK_LIST1 (subClientId, clientId, appTypeId,instance,dataArchGrpId,logArchGrpId,subclientName)
	 SELECT	0, clientId, 0,0,0,0,''''
	 FROM	#ClientWithoutSubclients'
	 EXEC SQLUtilIdentityInsert @IdentInsQueryCheckList, '#CHECK_LIST1'
-- Do security check for clients
IF @userId > 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2013 , 0, '#rptUserObjects'	-- SUB_CLIENT_ITEM = to get SUB_CLIENT_ITEM it will be having client/appType/instance/backupSet/subclient/
	delete #rptUserObjects
	WHERE clientGroupId <> 0 or commcellId <> 2
	delete  t
	from #CHECK_LIST1 t, APP_Application A WITH (READUNCOMMITTED)
	WHERE SubClientId=id AND
	 0 = (	select	count(*) from #rptUserObjects  u
			where	u.clientId in (0, t.clientId) AND
					u.appTypeId IN (0,t.appTypeId) AND
					u.instanceId IN (0,a.instance) AND
					u.backupsetId IN (0,a.backupSet) AND
					u.subClientId IN (0,t.subClientId))
	DROP TABLE #rptUserObjects
END
DELETE  #CHECK_LIST1
    FROM    #CHECK_LIST1 T
            INNER JOIN APP_Application A (nolock)
                ON T.subclientId = A.id
            INNER JOIN APP_BackupSetName B (nolock)
                ON A.backupset = B.id
            INNER JOIN #DBAgentsToPerformNetChk DB
            	ON A.appTypeId = DB.AppTypeId
WHERE   B.status & 0x00010 = 0x00010
IF object_id('tempdb.dbo.#DBAgentsToPerformNetChk') IS NOT NULL drop table #DBAgentsToPerformNetChk
DELETE  T
FROM #CHECK_LIST1 T
INNER JOIN simInstalledPackages P WITH (NOLOCK)
ON T.clientId = P.ClientId
INNER JOIN App_SubclientProp prop WITH (NOLOCK)
ON T.subclientId = prop.componentNameId
AND prop.cs_attrName = CHECKSUM(N'Index SubClient')
    AND     prop.attrName = N'Index SubClient'
    AND     prop.attrVal = '1'
    AND     prop.modified = 0
-- remove more hidden subclients
 delete  #CHECK_LIST1 FROM #CHECK_LIST1, APP_InstanceName WITH (READUNCOMMITTED) WHERE id=instance and ((status & 16)>0 or (status & 32)>0)
-- skip pre-imaged machines
delete  #CHECK_LIST1 FROM #CHECK_LIST1, APP_Client WITH (READUNCOMMITTED) WHERE id=clientId and (status & 0x04000) > 0
 -- skip external NBU clients
 delete  #CHECK_LIST1 FROM #CHECK_LIST1, @tmpExternalClient WHERE id = clientId
 -- skip subclient policy subclients & commnet agents
 DELETE FROM #CHECK_LIST1 WHERE apptypeid IN (1030,121,122)
-- skip SRM pseudo clients
delete  #CHECK_LIST1 FROM #CHECK_LIST1, APP_Client WITH (READUNCOMMITTED) WHERE id=clientId and (status & 0x0400) > 0
 AND clientId in (SELECT componentNameId FROM APP_clientProp WITH (READUNCOMMITTED)
                  WHERE attrName LIKE 'NoPhysicalMachinePresent' AND attrVal = '1')
--skip SRM agentless clients
DECLARE @simClients TABLE(clientId INT);
INSERT INTO @simClients
select distinct clientId from simInstalledPackages WITH (READUNCOMMITTED)
DELETE  #CHECK_LIST1
FROM #CHECK_LIST1
WHERE clientId IN (SELECT componentNameId FROM APP_clientProp WITH (READUNCOMMITTED)
                  WHERE attrName LIKE 'Mini SRM Agent' AND attrVal = '1' and not exists (select * from @simClients where clientId = componentNameId) AND modified = 0)
--delete index server pool client
DELETE  C
FROM #CHECK_LIST1 C
INNER JOIN DM2Cloud D WITH (NOLOCK) ON  D.pseudoClientId = C.clientId
WHERE D.CloudType = 9
-- Delete CS cluster nodes
DECLARE @CSNode INT
SELECT @CSNode = clientId FROM APP_Platform WITH (NOLOCK) WHERE (platformType & 1) = 1
DECLARE @isClusterCS INT = 0
SELECT @isClusterCS = attrVal FROM App_ClientProp with(nolock)
WHERE componentNameId = @CSNode
AND attrName LIKE 'Virtual Client' AND modified = 0
 -- If it is a cluster CS
IF @isClusterCS = 1
BEGIN
delete  @tblClients
FROM @tblClients
where t_clId in (SELECT PMClientId FROM APP_VMToPMMap WITH (NOLOCK)  where VMClientId = @CSNode )
DELETE  #CHECK_LIST1
FROM #CHECK_LIST1
WHERE clientId IN (SELECT PMClientId FROM APP_VMToPMMap WITH (NOLOCK)  where VMClientId = @CSNode )
END
-- get the list with subclient, storage policy pair
 IF object_id('tempdb.dbo.#CHECK_LIST2') IS NOT null DROP TABLE #CHECK_LIST2
 SELECT	subClientId, clientId, appTypeId, archGrpId=dataArchGrpId INTO #CHECK_LIST2
 FROM	#CHECK_LIST1
 DELETE from #CHECK_LIST2
 From #CHECK_LIST2 D INNER JOIN App_Application A ON A.id = D.subclientId
 WHERE  A.logArchGrpId>1 AND A.dataArchGrpID != A.logArchGrpID and A.subclientStatus & 0x40000 > 0
 DECLARE @IdentInsQuery NVARCHAR(MAX)
 SET @IdentInsQuery = 'INSERT INTO #CHECK_LIST2 (subClientId, clientId, appTypeId, archGrpId)
	 SELECT	subClientId, clientId, appTypeId, logArchGrpId
	 FROM	#CHECK_LIST1
	 WHERE	dataArchGrpId<>logArchGrpId and logArchGrpId!=1'
 EXEC SQLUtilIdentityInsert @IdentInsQuery, '#CHECK_LIST2'
-- get data path
 DECLARE @clientId	INTEGER
 DECLARE @archGrpId	INTEGER
IF OBJECT_ID('tempdb..#InvalidDatapath') IS NOT NULL DROP TABLE #InvalidDatapath
CREATE TABLE #InvalidDatapath (appId INT,clientId INT)
 DECLARE dataPathList CURSOR FOR
 	SELECT DISTINCT clientId, archGrpId FROM #CHECK_LIST2
 OPEN dataPathList
 FETCH NEXT FROM dataPathList INTO @clientId,@archGrpId
 WHILE @@FETCH_STATUS <> -1
 BEGIN
	IF @archGrpId > 1
	INSERT INTO #TEMP_DATAPATH
	EXEC getdataPathsForSubClient @archGrpId, @clientId, 1
	ELSE IF @archGrpId = 1	-- Stroage Policy Not Assigned
		 INSERT INTO #TEMP_DATAPATH
		 values(0,0,'N/A',-1,1,0,'N/A',0,'N/A','N/A',-1,'N/A','N/A',-1,0,1,1,@clientId)
	IF NOT EXISTS (SELECT 1 FROM #TEMP_DATAPATH where clientId = @clientId)
	BEGIN
		INSERT INTO #InvalidDatapath
		select MIN(id),@clientId
		FROM APP_Application where clientId = @clientId and (subClientStatus & 6) = 0
	END
	FETCH NEXT FROM dataPathList INTO @clientId,@archGrpId
 END
 CLOSE dataPathList
 DEALLOCATE dataPathList
--MR:50845: remove CCR check for MA associated with secondary copy, which is not similar to primary copy MA
DELETE #TEMP_DATAPATH
FROM #TEMP_DATAPATH td
WHERE td.dataPathId NOT IN (
		SELECT T.dataPathId
		FROM  MMDataPath DP WITH (READUNCOMMITTED), #TEMP_DATAPATH T
		WHERE T.dataPathId =DP.DataPathId and DP.HostClientId IN
			(
				SELECT DISTINCT DP.HostClientId
				FROM  archGroup AG WITH (READUNCOMMITTED), MMDataPath DP WITH (READUNCOMMITTED)
				WHERE T.archGroupId =AG.id AND AG.defaultCopy =DP.CopyId
			)
)
DELETE T
FROM  CCRToSubClient T
INNER  JOIN #CHECK_LIST2 c ON C.clientId = T.clientId
INNER JOIN CCRCommCellReadiness CCR ON CCR.ccrid = T.ccrid
where CCR.CCREndTime > 0
-- update CCR tables
 IF EXISTS (select 1 from #CHECK_LIST2)
 INSERT INTO CCRCommCellReadiness (CCRLevel,CCRStartTime,CCREndTime)
-- SELECT	@ccId, 0, @startTime, 0
 SELECT	0, @startTime, 0
 SET	@CCRID = SCOPE_IDENTITY()
 INSERT INTO CCRToSubClient  (CCRId,ClientId,SubClientId,DataPathId,CCRResultFlag,CCRNetworkReadinessFlag,CCRResourceReadinessFlag,lastUnCompBytes,lastCompBytes,capacityAvailable,appTypeId,dataWritten)
-- SELECT	@CCRID, @ccId, c.clientId, c.subClientId, t.dataPathId, 0, 0, 0, 0, 0, 0
 SELECT	@CCRID, c.clientId, c.subClientId, t.dataPathId, 0, 0, 0, 0, 0, 0, appTypeId, 0
 FROM	#CHECK_LIST2 c, #TEMP_DATAPATH t
 WHERE	c.clientId=t.clientId AND c.archGrpId=t.archGroupId
 --Insert SubclientId 0 from SP17 for to check cs -client net connectivity for client without any subclient
INSERT INTO CCRToSubClient  (CCRId,ClientId,SubClientId,DataPathId,CCRResultFlag,CCRNetworkReadinessFlag,CCRResourceReadinessFlag,lastUnCompBytes,lastCompBytes,capacityAvailable,appTypeId,dataWritten)
 SELECT	@CCRID, clientId, 0,0, 0, 0, 0, 0, 0, 0, 0, 0
 FROM	#CHECK_LIST2
 WHERE	subclientId = 0
 --Invalid Datapath configuration on every subclient
 IF EXISTS (SELECT 1 FROM #InvalidDatapath)
 BEGIN
	INSERT INTO CCRToSubClient  (CCRId,ClientId,SubClientId,DataPathId,CCRResultFlag,CCRNetworkReadinessFlag,CCRResourceReadinessFlag,lastUnCompBytes,lastCompBytes,capacityAvailable,appTypeId,dataWritten)
SELECT	DISTINCT @CCRID, I.clientId, I.appId, 0, 2, 0, 8192, 0, 0, 0, 0, 0
	FROM	#CHECK_LIST2 c
	INNER JOIN #InvalidDatapath I ON I.clientId = c.clientId AND I.appId = c.subclientId
	LEFT OUTER JOIN CCRToSubClient CCR ON CCR.SubClientId = I.appId AND CCR.CCRId = @CCRID
	where CCR.SubClientId IS NULL
 END
  SELECT ISNULL(@CCRID,0)
 DROP TABLE #TEMP_DATAPATH
 DROP TABLE #CHECK_LIST1
 DROP TABLE #CHECK_LIST2
 DROP TABLE #ClientWithoutSubclients
 IF OBJECT_ID('tempdb..#InvalidDatapath') IS NOT NULL DROP TABLE #InvalidDatapath
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCCReadinessCheck')
	delete from GxQscripts where name = 'RptCCReadinessCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCCReadinessCheck')
	delete from GXDBVersions where aliasname = 'RptCCReadinessCheck'
GO

insert into GXDBVersions values(2, 'RptCCReadinessCheck',  'v1.40.14.21.8.1', 'RptCCReadinessCheck', 'v1.40.14.21.8.1')
GO

