

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptBkpStatusTracking.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptBkpStatusTracking.sp,v $ $Id: RptBkpStatusTracking.sp,v 1.39.2.10 2018/11/18 03:52:07 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptBkpStatusTracking"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptBkpStatusTracking')
BEGIN
	print '>>> Drop Stored Procedure: rptBkpStatusTracking <<<'
	drop procedure rptBkpStatusTracking
END
IF EXISTS (select * from GxQscripts where name='rptBkpStatusTracking')
	delete from GxQscripts where name = 'rptBkpStatusTracking'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptBkpStatusTracking')
	delete from GXDBVersions where aliasname = 'rptBkpStatusTracking'
GO
print '... Creating Procedure: rptBkpStatusTracking'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptBkpStatusTracking
  @i_jobId integer
AS
  DECLARE @o_subClient integer;
  DECLARE @o_clientId integer;
  DECLARE @o_appType integer;
  DECLARE @o_instance integer;
  DECLARE @o_backupSet integer;
  DECLARE @o_subClientName nchar(255);
  DECLARE @o_libraryId integer;
  DECLARE @o_AGId integer;
  DECLARE @o_AGName NVARCHAR(255);
  DECLARE @o_AGCId integer;
  DECLARE @o_AGCName NVARCHAR(255);
  DECLARE @o_copyNum integer;
  DECLARE @o_isSecCopy integer;
  DECLARE @o_startTime integer;
  DECLARE @o_endTime integer;
  DECLARE @o_jobId integer;
  DECLARE @o_status integer;
  DECLARE @o_state integer;
  DECLARE @o_bkpLevel integer;
  DECLARE @o_copyStatus integer;
  DECLARE @o_copyDisabled integer;
  DECLARE @o_ccId integer;
  DECLARE @o_clientName nchar(255);
  DECLARE @o_appTypeName char(255);
  DECLARE @o_instanceName nchar(255);
  DECLARE @o_backupSetName nchar(255);
  DECLARE @o_libraryName NVARCHAR(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId			integer
DECLARE @locId			integer
DECLARE @rptType		integer
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @order			integer
DECLARE @clOpt			integer
DECLARE @appTypeOpt		integer
DECLARE @tblClients		TABLE (t_clId int)
DECLARE @tblApptypes		TABLE (t_appTypeId int)
DECLARE @tblRptApptypes		TABLE (t_rptTypeId int, t_appTypeId int)
DECLARE @subclientList	integer
DECLARE @tblOptSubclientSelection	TABLE (t_clientId int, t_agentId int, t_instanceId int, t_backupsetId int, t_subclientId int, t_exclude int)
DECLARE @scOpt				integer
DECLARE @tblSubclientIds	TABLE (t_id int)
DECLARE @SPCopyOpt		integer
DECLARE @tblSPCopies	TABLE (archGroupId int, copyId int)
INSERT INTO @tblRptApptypes VALUES(7723, 47)
INSERT INTO @tblRptApptypes VALUES(7723, 50)
INSERT INTO @tblRptApptypes VALUES(7721, 45)
INSERT INTO @tblRptApptypes VALUES(7721, 56)
INSERT INTO @tblRptApptypes VALUES(7721, 57)
INSERT INTO @tblRptApptypes VALUES(7721, 58)
INSERT INTO @tblRptApptypes VALUES(7721, 66)
INSERT INTO @tblRptApptypes VALUES(7721, 73)
INSERT INTO @tblRptApptypes VALUES(7721, 82)
INSERT INTO @tblRptApptypes VALUES(7721, 83)
INSERT INTO @tblRptApptypes VALUES(7721, 67)
INSERT INTO @tblRptApptypes VALUES(7721, 68)
INSERT INTO @tblRptApptypes VALUES(7721, 89)
INSERT INTO @tblRptApptypes VALUES(7721, 90)
--Below code is to filter unexpected rows like SRM jobs in calendar BKP report and to support below jobs in future for other report types
BEGIN
INSERT INTO @tblRptApptypes VALUES(7792, 84)
	--Filter CommNet Server and Commnet Agent for Backup Job Summary Report
INSERT INTO @tblRptApptypes VALUES(0, 121)
INSERT INTO @tblRptApptypes VALUES(0, 122)
INSERT INTO @tblRptApptypes VALUES(7788, 93)
INSERT INTO @tblRptApptypes VALUES(7788, 105)
	--SRM
INSERT INTO @tblRptApptypes VALUES(7744, 600)
INSERT INTO @tblRptApptypes VALUES(7744, 601)
INSERT INTO @tblRptApptypes VALUES(7744, 602)
INSERT INTO @tblRptApptypes VALUES(7744, 603)
INSERT INTO @tblRptApptypes VALUES(7744, 604)
INSERT INTO @tblRptApptypes VALUES(7744, 605)
INSERT INTO @tblRptApptypes VALUES(7744, 606)
INSERT INTO @tblRptApptypes VALUES(7744, 607)
INSERT INTO @tblRptApptypes VALUES(7744, 650)
INSERT INTO @tblRptApptypes VALUES(7744, 651)
INSERT INTO @tblRptApptypes VALUES(7744, 652)
INSERT INTO @tblRptApptypes VALUES(7744, 699)
END
SET @rptType 		= dbo.GetOptionInt(2039186688, @i_jobId, 0, 0)
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @order		= dbo.GetOptionInt(705619325, @i_jobId, 0, 0)
SET @subclientList = dbo.GetOptionInt(1950881962, @i_jobId, 0, 0)
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetObjectList @i_jobId, 444361887, @appTypeOpt OUTPUT
INSERT INTO @tblSPCopies EXEC rptOptGetStoragePolicies @i_jobId, @SPCopyOpt OUTPUT
IF object_id('tempdb.dbo.#TEMP_list') IS NOT NULL DROP TABLE #TEMP_list
IF object_id('tempdb.dbo.#TEMP_BST') IS NOT NULL DROP TABLE #TEMP_BST
CREATE TABLE #TEMP_list (	id			int,
							clientId	int,
							appTypeId	int,
							instance	int,
							backupSet	int,
							subClientName	nvarchar(256),
							libId		int,
							agId		int,
							agName		nvarchar(288),
							agcId		int,
							agcName		nvarchar(256),
							copyNum		int,
							secCopy		int
						)
IF OBJECT_ID('tempdb..#tblApplication') IS NOT NULL
	DROP TABLE #tblApplication
CREATE TABLE #tblApplication (id INT)
IF @subclientList <= 0
BEGIN
	IF @clOpt = 0
	BEGIN
		IF  @appTypeOpt <= 0
			INSERT INTO #tblApplication
			SELECT  id
			FROM    APP_Application A WITH (READUNCOMMITTED)
		ELSE
			INSERT INTO #tblApplication
			SELECT  id
			FROM    APP_Application A WITH (READUNCOMMITTED)
					INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
	END
	ELSE
	BEGIN
		IF  @appTypeOpt <= 0
			INSERT INTO #tblApplication
			SELECT  id
			FROM    APP_Application A WITH (READUNCOMMITTED) INNER JOIN @tblClients CL ON A.clientId = CL.t_clId
		ELSE
			INSERT INTO #tblApplication
			SELECT DISTINCT id
			FROM    APP_Application A WITH (READUNCOMMITTED) INNER JOIN @tblClients CL ON A.clientId = CL.t_clId
					INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
	END
END
ELSE
BEGIN
	INSERT INTO @tblOptSubclientSelection EXEC rptOptGetSubclients @i_jobId, @scOpt OUTPUT
	IF @scOpt > 0
	BEGIN
		DECLARE @t_clientId			int
		DECLARE @t_agentId			int
		DECLARE @t_instanceId		int
		DECLARE @t_backupsetId		int
		DECLARE @t_subclientId		int
		DECLARE @t_exclude			int
		DECLARE @tblExcludedSubclientIds	TABLE (t_id int)
		DECLARE subclientIds CURSOR FOR
		SELECT t_clientId, t_agentId, t_instanceId, t_backupsetId, t_subclientId, t_exclude FROM @tblOptSubclientSelection
		OPEN subclientIds
		FETCH NEXT FROM subclientIds INTO @t_clientId, @t_agentId, @t_instanceId, @t_backupsetId, @t_subclientId, @t_exclude
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF(@t_exclude <> 1)
			BEGIN
				INSERT INTO @tblSubClientIds
				EXEC rptGetSubClientIds @t_clientId, @t_agentId, @t_instanceId, @t_backupsetId, @t_subclientId
			END
			ELSE
			BEGIN
				INSERT INTO @tblExcludedSubclientIds
				EXEC rptGetSubClientIds @t_clientId, @t_agentId, @t_instanceId, @t_backupsetId, @t_subclientId
			END
			FETCH NEXT FROM subclientIds INTO @t_clientId, @t_agentId, @t_instanceId, @t_backupsetId, @t_subclientId, @t_exclude
		END
		DELETE tS FROM @tblSubClientIds tS INNER JOIN @tblExcludedSubclientIds tES ON tS.t_id = tES.t_id
		CLOSE subclientIds
		DEALLOCATE subclientIds
		INSERT INTO #tblApplication
		SELECT DISTINCT id
			FROM     APP_Application A WITH (READUNCOMMITTED)
						JOIN @tblSubclientIds sub
							ON id = sub.t_id
			WHERE	(@appTypeOpt = 1 AND appTypeId in (select t_appTypeId from @tblApptypes)) OR @appTypeOpt IN (-1, 0)
	END
END
IF @rptType IN ( 7721 )
BEGIN
	DELETE tA
	FROM #tblApplication tA INNER JOIN APP_Application A ON tA.id = A.id
	LEFT OUTER JOIN APP_SubClientProp scProp WITH (READUNCOMMITTED)
				ON scProp.componentNameId = tA.id
				AND scProp.attrName ='Is Turbo Subclient' and scProp.attrVal ='1' and scProp.modified=0
	WHERE A.appTypeId NOT IN (select t_appTypeId from @tblRptApptypes where t_rptTypeId = @rptType)
		  AND scProp.componentNameId IS NULL
END
ELSE
BEGIN
	DECLARE @rptTypeExists INT = CASE WHEN EXISTS(select * from @tblRptApptypes where t_rptTypeId = @rptType) THEN 1 ELSE 0 END
	DELETE tA
	FROM #tblApplication tA INNER JOIN APP_Application A ON tA.id = A.id
	WHERE (@rptTypeExists = 0 AND A.appTypeId IN (select t_appTypeId from @tblRptApptypes)) OR
					(@rptTypeExists = 1 AND A.appTypeId NOT IN (select t_appTypeId from @tblRptApptypes where t_rptTypeId = @rptType))
END
INSERT INTO #TEMP_list
SELECT DISTINCT A.id,A.clientId,A.appTypeId,A.instance,A.backupSet,A.subClientName,libId=0,
	agId=AG.id,agName=AG.name,agcId=AC.id,agcName=AC.name,copyNum=0,
	secCopy=(case when AC.id in (AG.defaultCopy, AG.defaultSnapCopy) then 0 else 1 end)
FROM	APP_Application A
		INNER JOIN #tblApplication tA ON A.id = tA.id
		INNER JOIN archGroup SP ON SP.id IN (A.dataArchGrpID, A.logArchGrpID)
		INNER JOIN archGroupCopy AC ON AC.archGroupId IN (SP.id, SP.incrSP) AND AC.type IN (1, 2) AND AC.isActive = 1
		INNER JOIN archGroup AG ON AG.id = AC.archGroupId
WHERE	A.appTypeId < 1000
;WITH MoreCopy (appId, copyId) AS
(
	SELECT	S.appId, ISNULL(J.archGrpCopyId, CASE WHEN S.opType IN (59,65) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END)
	FROM	(SELECT	B.jobId, B.commCellId, B.appId, B.opType,
					CASE WHEN B.dataArchGrpId > 1 THEN B.dataArchGrpId ELSE B.logArchGrpId END AS archGrpId
			FROM	JMBkpStats B
					INNER JOIN #tblApplication tA ON B.appId = tA.id
			WHERE	B.servEndDate > @startTime
			) S
			INNER JOIN archGroup AG ON S.archGrpId = AG.id
			LEFT OUTER JOIN JMJobDataStats J ON S.jobId = J.jobId AND S.commCellId = J.commCellId AND S.archGrpId = J.archGrpId
			LEFT OUTER JOIN #TEMP_list T ON S.appId = T.id
				  AND ISNULL(J.archGrpCopyId, CASE WHEN S.opType IN (59,65) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END) = T.agcId
	WHERE	T.id IS NULL
	GROUP BY S.appId, ISNULL(J.archGrpCopyId, CASE WHEN S.opType IN (59,65) THEN AG.defaultSnapCopy ELSE AG.defaultCopy END)
)
INSERT INTO #TEMP_list
SELECT DISTINCT A.id,A.clientId,A.appTypeId,A.instance,A.backupSet,A.subClientName,libId=0,
	agId=AG.id,agName=AG.name,agcId=AC.id,agcName=AC.name,copyNum=0,
	secCopy=(case when AC.id in (AG.defaultCopy, AG.defaultSnapCopy) then 0 else 1 end)
FROM	MoreCopy C
		INNER JOIN APP_Application A ON C.appId = A.id
		INNER JOIN archGroupCopy AC	ON C.copyId = AC.id AND AC.type IN (1, 2) AND AC.isActive = 1
		INNER JOIN archGroup AG	ON AC.archGroupId = AG.id
IF EXISTS (SELECT * FROM @tblSPCopies)
BEGIN
	DELETE	#TEMP_list
	FROM	#TEMP_list B
			LEFT OUTER JOIN @tblSPCopies T
		ON	B.agId = T.archGroupId AND (B.agcId = T.copyId OR T.copyId <= 0)
	WHERE	T.archGroupId IS NULL
END
DECLARE @defaultDataPathFlag INT = (1 | 2 | 4)
UPDATE temp
SET libId = MP.LibraryId
FROM #TEMP_list temp
	INNER JOIN MMDataPath DP ON temp.agcId = DP.CopyId AND (DP.Flag & @defaultDataPathFlag) = @defaultDataPathFlag
	INNER JOIN MMDrivePool MD ON MD.DrivePoolId = DP.DrivePoolId
	INNER JOIN MMMasterPool MP ON MP.MasterPoolId = MD.MasterPoolId
IF @endTime = 0
	SET @endTime = 0x7FFFFFFF
-- Initialize cStatus to 2 (enum CVCopyDataState: NODATA) if job is failed or killed.
SELECT	T.*,startT=B.servStartDate,endT=B.servEndDate,jobId=B.jobId,status=B.status,state=0,bkpLevel=B.bkpLevel,
	cStatus=(CASE WHEN (B.opType NOT IN (59,65) AND T.agcId = AG.defaultCopy OR B.opType IN (59,65) AND T.agcId = AG.defaultSnapCopy)
			THEN (CASE WHEN B.status IN (1,14) THEN 100 ELSE 2 END) ELSE 0 END),
	cDisabled=0,ccId=B.commcellId,
	clientName=convert(nvarchar(255),''),appTypeName=convert(varchar(255),''),instanceName=convert(nvarchar(512),''),
	backupSetName=convert(nvarchar(128),''),libName=convert(varchar(128),'')
INTO	#TEMP_BST
FROM	#TEMP_list T
		INNER JOIN JMBkpStats B ON T.id = B.appId
		INNER JOIN archGroup AG ON T.agId = AG.id
WHERE	T.agId IN (B.dataArchGrpId, B.logArchGrpId)
	AND B.servEndDate >= @startTime AND B.servStartDate <= @endTime
-- Initialize cStatus to 1 (enum CVCopyDataState: INPROGRESS) for active jobs.
INSERT INTO #TEMP_BST
SELECT	T.*,J.jobStartTime,0,J.jobId,0,J.state,B.bkpLevel,1,0,J.commcellId,'','','','',''
FROM	#TEMP_list T
		INNER JOIN JMBkpJobInfo B ON T.id = B.applicationId
		INNER JOIN JMJobInfo J ON B.commcellId = J.commcellId and B.jobId = J.jobId
		INNER JOIN archGroup AG ON T.agId = AG.id
WHERE	T.agId IN (B.dataPolicy, B.logPolicy)
	AND J.jobStartTime >= @startTime AND J.jobStartTime <= @endTime
	AND (J.opType IN (59,65) AND T.agcId = AG.defaultSnapCopy OR J.opType NOT IN (59,65) AND T.agcId = AG.defaultCopy)
--Remove non-turbo jobs
IF @rptType = 7721
BEGIN
     --Remove non-turbo jobs
    DELETE  #TEMP_BST
    FROM    #TEMP_BST T LEFT OUTER JOIN
            (SELECT componentNameId, created
            FROM    APP_SubClientProp scProp
            WHERE   attrName = 'Is Turbo Subclient' AND scProp.attrVal = '1' AND scProp.modified = 0)
            TurboSC ON T.id = TurboSC.componentNameId AND T.startT < TurboSC.created
    WHERE   TurboSC.componentNameId IS NOT NULL
END
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @clOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#rptUserObjects'	-- 2009 = CLIENT_ITEM
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	delete	#TEMP_BST
	FROM	#TEMP_BST T
	WHERE	NOT EXISTS (	select	* from #rptUserObjects U
				where	U.clientId IN (0, T.clientId) AND
					U.appTypeId IN (0,T.appTypeId) AND
					U.instanceId IN (0,T.instance) AND
					U.backupsetId IN (0,T.backupSet) AND
					U.subClientId IN (0,T.id))
	DROP TABLE #rptUserObjects
END
UPDATE #TEMP_BST
SET 	clientName	=(select displayName from APP_Client where id=clientId),
	appTypeName	=(select name from APP_iDAType where type=appTypeId),
	instanceName	=(select name from APP_InstanceName where id=instance),
	backupSetName	=(select name from APP_BackupSetName where id=backupSet),
	libName		=(select aliasName from MMLibrary where libraryid=libId)
UPDATE	#TEMP_BST
SET		cStatus = CASE WHEN minStatus = 100 AND maxStatus IN (101, 102, 103) THEN 103 ELSE maxStatus END, cDisabled = CASE maxStatus WHEN 100 THEN 0 ELSE S.disabled END
FROM	#TEMP_BST T INNER JOIN
		(SELECT	J.jobId, J.commCellId, J.archGrpCopyId, MIN(J.status) AS minStatus, MAX(J.status) AS maxStatus, MAX(J.disabled&(1|256)) AS disabled
		FROM	#TEMP_BST B INNER JOIN JMJobDataStats J ON B.jobId = J.jobId AND B.ccId = J.commCellId
		GROUP BY J.jobId, J.commCellId, J.archGrpCopyId
		) S ON T.jobId=S.JobId and T.ccId=commcellId and T.agcId=S.archGrpCopyId
UPDATE	#TEMP_BST SET copyNum = S.copyNum
FROM	#TEMP_BST T
		INNER JOIN (SELECT agId, COUNT(DISTINCT agcId) AS copyNum FROM #TEMP_BST GROUP BY agId) S
		ON T.agId = S.agId
UPDATE	#TEMP_BST
SET	cDisabled = 1
FROM	#TEMP_BST T, JMJobDataStats J
WHERE	ccId=commcellId and T.jobId=J.jobId and T.agId=J.archGrpId AND T.cStatus IN (101,102,103) AND T.cDisabled = 0
	and (J.disabled & 1)=1 and J.archGrpCopyId in (select defaultCopy from archGroup)
IF @order = 2
	SELECT * FROM #TEMP_BST ORDER BY clientName,appTypeName,instanceName,backupSetName,subClientName,agName,secCopy,agcName,startT,endT
ELSE IF @order = 1
	SELECT * FROM #TEMP_BST ORDER BY appTypeName,clientName,instanceName,backupSetName,subClientName,agName,secCopy,agcName,startT,endT
ELSE IF @order = 4
	SELECT * FROM #TEMP_BST ORDER BY agName,clientName,appTypeName,instanceName,backupSetName,subClientName,secCopy,agcName,startT,endT
ELSE
	SELECT * FROM #TEMP_BST ORDER BY subClientName,agId,secCopy,agcId,startT,endT
DROP TABLE #TEMP_BST
DROP TABLE #TEMP_list
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBkpStatusTracking')
	delete from GxQscripts where name = 'RptBkpStatusTracking'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpStatusTracking')
	delete from GXDBVersions where aliasname = 'RptBkpStatusTracking'
GO

insert into GXDBVersions values(2, 'RptBkpStatusTracking',  '00010039000200100000', 'RptBkpStatusTracking', '00010039000200100000')
GO

