

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptBkpHistoryInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptBkpHistoryInfo.sp,v $ $Id: RptBkpHistoryInfo.sp,v 1.258.2.73 2020/12/03 02:23:29 mkhan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptBkpHistoryInfo"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='rptBkpHistoryInfo')
BEGIN
	print '>>> Drop Stored Procedure: rptBkpHistoryInfo <<<'
	drop procedure rptBkpHistoryInfo
END
IF EXISTS (select * from GxQscripts where name='rptBkpHistoryInfo')
	delete from GxQscripts where name = 'rptBkpHistoryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptBkpHistoryInfo')
	delete from GXDBVersions where aliasname = 'rptBkpHistoryInfo'
GO
print '... Creating Procedure: rptBkpHistoryInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure rptBkpHistoryInfo
  @i_jobId integer
AS
  DECLARE @o_type integer;
  DECLARE @o_total integer;
  DECLARE @o_success integer;
  DECLARE @o_partSuc integer;
  DECLARE @o_active integer;
  DECLARE @o_killed integer;
  DECLARE @o_noRun integer;
  DECLARE @o_noBkp integer;
  DECLARE @o_commcellId integer;
  DECLARE @o_clientId integer;
  DECLARE @o_clientName nchar(255);
  DECLARE @o_appType integer;
  DECLARE @o_appTypeName char(255);
  DECLARE @o_instance integer;
  DECLARE @o_instanceName nchar(255);
  DECLARE @o_backupSet integer;
  DECLARE @o_backupSetName nchar(255);
  DECLARE @o_subClient integer;
  DECLARE @o_subClientName nchar(255);
  DECLARE @o_jobId integer;
  DECLARE @o_clientGrpId integer;
  DECLARE @o_cgName NVARCHAR(1024);
  DECLARE @o_bkpLevel integer;
  DECLARE @o_status integer;
  DECLARE @o_state integer;
  DECLARE @o_duration integer;
  DECLARE @o_servStartDate integer;
  DECLARE @o_servEndDate integer;
  DECLARE @o_currentPhaseName char(255);
  DECLARE @o_objects bigint;
  DECLARE @o_uncompSize bigint;
  DECLARE @o_bkpTime integer;
  DECLARE @o_initFrom integer;
  DECLARE @o_scanFileFailures integer;
  DECLARE @o_scanFolderFailures integer;
  DECLARE @o_bkpFileFailures integer;
  DECLARE @o_bkpFolderFailures integer;
  DECLARE @o_failedFiles bigint;
  DECLARE @o_failedFolders bigint;
  DECLARE @o_options integer;
  DECLARE @o_attributes bigint;
  DECLARE @o_userName nchar(255);
  DECLARE @o_archGroup integer;
  DECLARE @o_archGroupName NVARCHAR(255);
  DECLARE @o_logGroup integer;
  DECLARE @o_logGroupName NVARCHAR(255);
  DECLARE @o_currentSize bigint;
  DECLARE @o_currentTime integer;
  DECLARE @o_MAId integer;
  DECLARE @o_MAName nchar(255);
  DECLARE @o_writeStartTime integer;
  DECLARE @o_writeEndTime integer;
  DECLARE @o_opType integer;
  DECLARE @o_subOpType integer;
  DECLARE @o_scanType integer;
  DECLARE @o_failureErrorCode integer;
  DECLARE @o_contentIdx bigint;
  DECLARE @o_compBkpSize bigint;
  DECLARE @o_bkpSize bigint;
  DECLARE @o_percentageChange integer;
  DECLARE @o_extRetentionFlags integer;
  DECLARE @o_retentionDays integer;
  DECLARE @o_pinJobEndTime bigint;
  DECLARE @o_snapJobId integer;
  DECLARE @o_snapJobStatus integer;
  DECLARE @o_dataStatus integer;
  DECLARE @o_agedTime integer;
  DECLARE @o_transferredDataSize bigint;
  DECLARE @o_schedName NVARCHAR(255);
  DECLARE @o_sizeOnMedia bigint;
  DECLARE @o_sysStateSkipReason integer;
  DECLARE @o_stubSize bigint;
  DECLARE @o_isCatelogJob integer;
  DECLARE @o_bkpAttributesEx bigint;
  DECLARE @o_cellName char(255);
  DECLARE @o_failReasonIds char(255);
  DECLARE @o_proxyHostName nvarchar(255);
  DECLARE @o_MAList nvarchar(MAX);
  DECLARE @o_failReason nvarchar(MAX);
  DECLARE @o_scanTypeChangeReason nvarchar(MAX);
  DECLARE @o_xmlJobInfo XML;
  DECLARE @o_jobDescription nvarchar(MAX);
  DECLARE @o_clientDesc nvarchar(MAX);
  DECLARE @o_idaDesc nvarchar(MAX);
  DECLARE @o_instanceDesc nvarchar(MAX);
  DECLARE @o_bkpSetDesc nvarchar(MAX);
  DECLARE @o_subclientDesc nvarchar(MAX);
  DECLARE @o_ClientGroups nvarchar(MAX);
  DECLARE @o_referenceCopyCriteria nvarchar(MAX);
  DECLARE @o_referenceCopyAssociation nvarchar(MAX);
  DECLARE @o_topNXml XML;
  DECLARE @o_clientOwnersList nvarchar(MAX);
  DECLARE @o_clientHostName nchar(255);
  DECLARE @o_skipped int;
  DECLARE @o_committed int;
  DECLARE @o_TrueUp int;
  DECLARE @o_clientDisplayName nchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId			integer
DECLARE @locId			integer
DECLARE @rptType		integer
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @active			integer
DECLARE @failed			integer
DECLARE @history		integer
DECLARE @needStatus		integer
DECLARE @noBkp			integer
DECLARE @noRun			integer
DECLARE @formatId		integer
DECLARE @isHtml			integer = 0
DECLARE @order			integer
DECLARE @subClientOpt		integer
DECLARE @includeAged		integer
DECLARE @includeMA		integer
DECLARE @clOpt			integer
DECLARE @appTypeOpt		integer
DECLARE @SPCopyOpt		integer
DECLARE @jobTypeOpt		integer
DECLARE @jobId			integer
DECLARE @useCSTime		integer
DECLARE @optSizeDecr		integer
DECLARE @optSizeIncr		integer
DECLARE @flags			bigint
DECLARE @tblStatus			TABLE (status int)
IF object_id('tempdb.dbo.#tblClients') is not null DROP TABLE #tblClients
CREATE TABLE #tblClients	(t_clId int)
DECLARE @tblApptypes		TABLE (t_appTypeId int)
DECLARE @tblRptApptypes		TABLE (t_rptTypeId int, t_appTypeId int)
IF object_id('tempdb.dbo.#tblSubclients') is not null DROP TABLE #tblSubclients
CREATE TABLE #tblSubclients	(t_appId int)
IF object_id('tempdb.dbo.#tblLastJob') is not null DROP TABLE #tblLastJob
CREATE TABLE #tblLastJob	(t_appId int, t_job int)
IF object_id('tempdb.dbo.#tblBkpStream') is not null DROP TABLE #tblBkpStream
CREATE TABLE #tblBkpStream	(cJobId int, csize bigint, ctime int)
IF object_id('tempdb.dbo.#tblSummary') is not null DROP TABLE #tblSummary
create table #tblSummary	(tot INT, tid INT, st INT, et INT, ts BIGINT, bs BIGINT, obj BIGINT, fFiles BIGINT, fFolders BIGINT, cs BIGINT, sizeOnMedia BIGINT, stubSize BIGINT)
IF OBJECT_ID('tempdb.dbo.#tblAppIds') IS NOT NULL DROP TABLE #tblAppIds
CREATE TABLE #tblAppIds( applicationId INT,	created INT)
DECLARE @tblSPCopies		TABLE (archGroupId int, copyId int)
DECLARE @jobDesc			nvarchar(4000)
DECLARE @rptTempType		integer
DECLARE @basicRetn			integer
DECLARE @ExtendedRetn		integer
DECLARE @ManualRetn 		integer
DECLARE @allRetn			integer
DECLARE @bkpCopyJobs		integer
DECLARE @bkpCopyJobsOnly	integer
DECLARE @tblSubclientIds	TABLE (t_id int)
DECLARE @scOpt				integer
DECLARE @subclientFilterList	integer
DECLARE @MediaDeleted			integer
DECLARE @snapBkpJobsOnly		integer
DECLARE @transferredDataSize	integer
DECLARE @delayed				integer
DECLARE @allJobStatus			integer
DECLARE @description			integer
DECLARE @includeClientDesc		integer
DECLARE	@filterOnSubClientDesc	integer
DECLARE	@SubClientDescriptionFilter	nvarchar(4000)
DECLARE @includeFailedFilesOnly	integer
DECLARE	@failedFilesThreshold	integer
DECLARE	@performanceJobsOnly	integer
DECLARE @includeDisabledActivityClients	integer
DECLARE @includeDeconfiguredClients	integer
DECLARE @errorCode	integer = 0
DECLARE @errorCodeFilter	int = 0
DECLARE @noofMostfreqError		integer = 0
DECLARE @committed				integer = 0
DECLARE @skipped				integer
DECLARE @includeSkippedInNoRun		integer = 1
DECLARE @useAbsTimeRangeForJobSummaryRpt INTEGER
DECLARE @AllSPCopiesSelected INT = 0
DECLARE @jobXML XML
DECLARE @jobXMLHandle INT
DECLARE @excludeHiddenSubclients integer = 0
DECLARE @csBias			INT = 0
DECLARE @csDSTFlag		INT = 0
DECLARE @csTimeZoneId	INT = 0
SELECT  @csTimeZoneId = attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Commcell timezone Id' AND modified = 0
IF @csTimeZoneId = 0
	SELECT  @csTimeZoneId = attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = 2 AND attrName = 'timezone Id' AND modified = 0
SELECT	@csBias = Bias, @csDSTFlag = DSTFlag FROM SchedTimeZone WITH (NOLOCK) WHERE TimeZoneID = @csTimeZoneId
IF OBJECT_ID('tempdb.dbo.#ClientGroupsString') IS NOT NULL DROP TABLE #ClientGroupsString
CREATE TABLE #ClientGroupsString (clientId INT, clientGroups NVARCHAR(MAX), timeZoneId INT, bias INT, dstFlag INT)
IF object_id('tempdb.dbo.#tblApplication') is not null DROP TABLE #tblApplication
CREATE TABLE #tblApplication (id INT, clientId INT, appTypeId INT, instance INT, subclientStatus INT, dataArchGrpId INT, logArchGrpId INT)
IF object_id('tempdb.dbo.#BKPXT') IS NOT null DROP TABLE #BKPXT
CREATE TABLE #BKPXT(
	ccId	INT,
	jobId	INT,
	subTaskId INT,
	optype	INT,
	clId	INT,
	appId	INT,
	appType	INT,
	bLevel	INT,
	status	INT,
	state	INT,
	startT	INT,
	endT	INT,
	duration INT,
	cPhase	INT,
	objects	BIGINT,
	uncompSize	BIGINT,
	bTime	INT,
	initF	INT,
	failIds	varchar(512),
	failR	ntext,
	sFl	INT,
	sFd	INT,
	bFl	INT,
	bFd	INT,
	options	INT,
	attributes	BIGINT,
	userName	nvarchar(1024),
	archGrp	INT,
	logArchGrp INT,
	wST 	INT,
	wET 	INT,
	failError	INT,
	cIdx	BIGINT	default(0),
	scanType	INT	default(0),
	scanChangeReason	varchar(1024) default(''),
	compSize	BIGINT,
	bkpSize	BIGINT,
	percChange	INT,
	jobDescription nvarchar(MAX) default(N''),
	xmlJobInfo nvarchar(MAX) default(N''),
	snapJobId	INT,
	snapJobStatus	INT,
	dataStatus		INT,
	agedTime		INT,
	transferredDataSize BIGINT default(-1),
	sizeOnMedia		BIGINT,
	stubSize		BIGINT,
	scheduleName	NVARCHAR(255) default(N'')
)
-------
IF object_id('tempdb.dbo.#tempJobRetention') is not null DROP TABLE #tempJobRetention
CREATE TABLE #tempJobRetention(
	jobId INT, commCellId INT, archGrpCopyId INT,
	retentionDays INT, extRetentionFlags INT, extRetentionDays INT,
	manualRetentionEndTime BIGINT, manualRetaided INT,
	PRIMARY KEY(jobId, commCellId, archGrpCopyId))
IF object_id('tempdb.dbo.#maxJobRetention') is not null DROP TABLE #maxJobRetention
CREATE TABLE #maxJobRetention(
	jobId INT, commCellId INT, extRetentionFlags INT, retentionDays INT, extRetentionDays INT, manualRetentionEndTime BIGINT,
	PRIMARY KEY(jobId, commCellId))
---------
INSERT INTO @tblRptApptypes VALUES(7792, 84)
INSERT INTO @tblRptApptypes VALUES(7716, 47)		-- QR_RECOVERY_REPORT: 7718
INSERT INTO @tblRptApptypes VALUES(7716, 50)
--Filter CommNet Server and Commnet Agent for Backup Job Summary Report
INSERT INTO @tblRptApptypes VALUES(0, 121)
INSERT INTO @tblRptApptypes VALUES(0, 122)
INSERT INTO @tblRptApptypes VALUES(7788, 93)
INSERT INTO @tblRptApptypes VALUES(7788, 105)
--SRM
INSERT INTO @tblRptApptypes VALUES(7744, 600)
INSERT INTO @tblRptApptypes VALUES(7744, 601)
INSERT INTO @tblRptApptypes VALUES(7744, 602)
INSERT INTO @tblRptApptypes VALUES(7744, 603)
INSERT INTO @tblRptApptypes VALUES(7744, 604)
INSERT INTO @tblRptApptypes VALUES(7744, 605)
INSERT INTO @tblRptApptypes VALUES(7744, 606)
INSERT INTO @tblRptApptypes VALUES(7744, 607)
INSERT INTO @tblRptApptypes VALUES(7744, 650)
INSERT INTO @tblRptApptypes VALUES(7744, 651)
INSERT INTO @tblRptApptypes VALUES(7744, 652)
INSERT INTO @tblRptApptypes VALUES(7744, 699)
INSERT INTO @tblRptApptypes VALUES(8003, 45)	-- DM_RECOVERY_REPORT: 7719
INSERT INTO @tblRptApptypes VALUES(8003, 56)
INSERT INTO @tblRptApptypes VALUES(8003, 57)
INSERT INTO @tblRptApptypes VALUES(8003, 58)
INSERT INTO @tblRptApptypes VALUES(8003, 66)
INSERT INTO @tblRptApptypes VALUES(8003, 73)
INSERT INTO @tblRptApptypes VALUES(8003, 82)
INSERT INTO @tblRptApptypes VALUES(8003, 83)
INSERT INTO @tblRptApptypes VALUES(8003, 67)
INSERT INTO @tblRptApptypes VALUES(8003, 68)
INSERT INTO @tblRptApptypes VALUES(8003, 90)
INSERT INTO @tblRptApptypes VALUES(8003, 89)
-- Exchange Compliance Archiver subclients dont have 'Is Turbo Subclient' enabled
INSERT INTO @tblRptApptypes VALUES(7717, 56)
INSERT INTO @tblRptApptypes VALUES(7717, 67)
INSERT INTO @tblRptApptypes VALUES(7717, 137)
INSERT INTO @tblRptApptypes VALUES(7717, 82)
INSERT INTO @tblRptApptypes VALUES(7717, 90)
--
DECLARE @MAXINT	integer
SET	@MAXINT	= 0x7FFFFFFF
SET @rptType 		= dbo.GetOptionInt(2039186688, @i_jobId, 0, 0)
SET @userId			= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @locId		= dbo.GetOptionInt(1421724997, @i_jobId, 0, 0)
SET @formatId		= dbo.GetOptionInt(1310074675, @i_jobId, 0, 0)
IF  @formatId <> 2 AND @formatId <> 5
	SET @isHtml	= 1
SET @jobId			= dbo.GetOptionInt(127117398, @i_jobId, 0, 0)
SET @subClientOpt	= dbo.GetOptionInt(1880827487, @i_jobId, 0, 0)
SET @includeAged	= dbo.GetOptionInt(1144564847, @i_jobId, 0, 0)
SET @includeMA		= dbo.GetOptionInt(1289917648, @i_jobId, 0, 0)
SET @order			= dbo.GetOptionInt(705619325, @i_jobId, 0, 0)
SET @useCSTime		= dbo.GetOptionInt(695030402, @i_jobId, 0, 0)
SET @noofMostfreqError = dbo.GetOptionInt(402475830, @i_jobId, 0, 0)
IF dbo.GetOptionInt(71187221, @i_jobId, 0, 0) > 0
SET @optSizeDecr	= dbo.GetOptionInt(1395938505, @i_jobId, 0, 0)
IF dbo.GetOptionInt(1927032049, @i_jobId, 0, 0) > 0
SET @optSizeIncr	= dbo.GetOptionInt(1689937627, @i_jobId, 0, 0)
SET @ExtendedRetn	= dbo.GetOptionInt(641733173, @i_jobId, 0, 0)
SET @ManualRetn	= dbo.GetOptionInt(1984366008, @i_jobId, 0, 0)
SET @excludeHiddenSubclients = dbo.GetOptionInt(2142102290, @i_jobId, 0, 0)
SET @basicRetn		= dbo.GetOptionInt(329756736, @i_jobId, 0, 0)
SET @allRetn		= dbo.GetOptionInt(502580051, @i_jobId, 0, 0)
SET @bkpCopyJobs	= dbo.GetOptionInt(1523551209, @i_jobId, 0, 0)
SET @bkpCopyJobsOnly	= dbo.GetOptionInt(252379957, @i_jobId, 0, 0)
SET @includeDisabledActivityClients	= dbo.GetOptionInt(870756969, @i_jobId, 0, 0)
SET @includeDeconfiguredClients	= dbo.GetOptionInt(1384792131, @i_jobId, 0, 0)
SET @jobDesc		= dbo.GetOptionString(305418106, @i_jobId, 0, 0)
SET @description	= dbo.GetOptionInt(430250426, @i_jobId, 0, 0)
SET @subclientFilterList = dbo.GetOptionInt(1950881962, @i_jobId, 0, 0)
SET @MediaDeleted = dbo.GetOptionInt(666826481, @i_jobId, 0, 0)
SET @snapBkpJobsOnly = dbo.GetOptionInt(35155339, @i_jobId, 0, 0)
SET @transferredDataSize = dbo.GetOptionInt(1024714352, @i_jobId, 0, 0)
SET @allJobStatus		= dbo.GetOptionInt(144860792, @i_jobId, 0, 0)
SET	@includeClientDesc	= dbo.GetOptionInt(756316779, @i_jobId, 0, 0)
--Vipin Start
SET @filterOnSubClientDesc = dbo.GetOptionInt (185252052, @i_jobId, 0, 0)
SET @SubClientDescriptionFilter = dbo.GetOptionString(845879830, @i_jobId, 0, 0)
--Vipin End
SET	@includeFailedFilesOnly = dbo.GetOptionInt(1316786188, @i_jobId, 0, 0)
SET	@failedFilesThreshold = dbo.GetOptionInt(1661938351, @i_jobId, 0, 0)
SET @errorCode			= dbo.GetOptionInt(1307886748,@i_jobId,0,0)
IF @errorCode > 0
BEGIN
SET @errorCodeFilter		= CAST((dbo.GetOptionString(676022536,@i_jobId,0,0)) AS INT);
END
IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bIncludeSkippedInNoRun' AND relativePath = 'CommServDB.Console' AND VALUE Like 'false' AND enabled = 1 AND deleted = 0)
 	SET @includeSkippedInNoRun = 0
IF(@bkpCopyJobsOnly>0)
SET @bkpCopyJobs=1
SET @jobXML = (SELECT dbo.GetXMLJobOptions(@i_jobid))
EXEC sp_xml_preparedocument @jobXMLHandle OUTPUT, @jobXML
SET @AllSPCopiesSelected = ISNULL((SELECT TOP 1 allCopies FROM OPENXML (@jobXMLHandle, 'TMMsg_JobOption/adminOpts/reportOption/storagePolicyCopyList', 1) WITH (allCopies int)), 0)
EXEC sp_xml_removedocument @jobXMLHandle
EXEC RptOptGetBkpJobType @i_jobId, @jobTypeOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetAppTypes @i_jobId, @appTypeOpt OUTPUT
INSERT INTO @tblSPCopies EXEC rptOptGetStoragePolicies @i_jobId, @SPCopyOpt OUTPUT
DECLARE @MAId      integer
DECLARE @tblMA     TABLE (t_id int)
INSERT INTO @tblMA EXEC rptOptGetObjectList @i_jobId, 587766369, @MAId OUTPUT
DECLARE @includeVSiDA INTEGER
IF @appTypeOpt = 0 OR EXISTS (SELECT * FROM @tblAppTypes WHERE t_appTypeId = 106)
	SET @includeVSiDA = 1
ELSE
	SET @includeVSiDA = 0
-- If the apptype CV_APPTYPE_WINDOWS_FILESYSTEM is present in GUI selection,
-- We must consider all the WIN FS AppTypes.
-- This I have added because I need to merge all flavours of Windows AppTypes to one(MR: 62562)
-- For backward compatibility with 8.0 and 9.0 I am adding this.
DECLARE @WindowsFSSelected INT
SET @WindowsFSSelected = CASE WHEN EXISTS (SELECT * FROM @tblAppTypes WHERE t_appTypeId = 33) THEN 1 ELSE 0 END
IF @WindowsFSSelected <> 0
BEGIN
INSERT INTO @tblAppTypes VALUES (1)
INSERT INTO @tblAppTypes VALUES (11)
	--INSERT INTO @tblAppTypes VALUES (CV_APPTYPE_WINDOWS_FILESYSTEM) -- Already there
INSERT INTO @tblAppTypes VALUES (34)
INSERT INTO @tblAppTypes VALUES (42)
INSERT INTO @tblAppTypes VALUES (43)
END
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
--MR 159274: CMR to only include jobs that started AND ended in the given time frame if time range is specified in days (regKey based)
SET @useAbsTimeRangeForJobSummaryRpt = 0
IF EXISTS (
	SELECT *
	FROM APP_AdvanceSettings WITH(NOLOCK)
	WHERE keyName = 'bUseAbsTimeRangeForJobSummaryRpt'
			AND type = 'BOOLEAN'
			AND relativePath = 'Reports'
			AND enabled = 1
			AND deleted = 0
			AND entityType = 3
			AND entityId = 2
			AND CONVERT(NVARCHAR(20), value) = N'true'
) AND (SELECT dbo.GetOptionString(1399039985, @i_jobId, 0, 0)) = 11 --TimeRangeType_RELATIVE_DAYS
AND (SELECT dbo.GetOptionInt(162723971, @i_jobId, 0, 0)) = (60*60*24) --Selected Time Range = 1 day
	SET @useAbsTimeRangeForJobSummaryRpt = 1
IF	@endTime = 0
	SET @endTime = 0x7FFFFFFF
INSERT INTO #tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblStatus EXEC rptOptGetJobStatus @i_jobId, @active OUTPUT, @history OUTPUT, @noBkp OUTPUT, @noRun OUTPUT, @failed OUTPUT, @delayed OUTPUT, @skipped OUTPUT
SET @needStatus = (select count(*) from @tblStatus)
DECLARE @nSummaryRows	INT = 0
DECLARE @MaxNumOfRows	INT = 10000
SELECT	@MaxNumOfRows = CAST(value AS INT)
FROM	GxGlobalParam WITH (READUNCOMMITTED)
WHERE	name = 'RptBkpHistoryInfoMaxRows' AND modified = 0
DECLARE @skipErrorCodeLink INT = 0
SELECT	@skipErrorCodeLink = CAST(value AS INT)
FROM	GxGlobalParam WITH (READUNCOMMITTED)
WHERE	name = 'RptSkipErrorCodeLink' AND modified = 0
DECLARE @runtimeSecurityCheck INT = 0
SELECT	@runtimeSecurityCheck = CAST(value AS INT)
FROM	GxGlobalParam WITH (READUNCOMMITTED)
WHERE	name = 'RptRuntimeSecurityCheck' AND modified = 0
IF @jobId > 0
BEGIN
	SET @order = 0
	INSERT INTO #BKPXT
	SELECT 2, J.jobId, B.backupTaskId, J.optype, A.clientId, A.id, appTypeId, bkpLevel, 0, state, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase, filesXfered, uncompbytes,
CASE WHEN B.bkpAttributesEx & 0x40000000 <> 0 THEN -1 ELSE isnull((select sum(writeTime) from JMBkpAttemptInfo where JMBkpAttemptInfo.jobId=J.jobId and writeTime>0), 0)+isnull((select max(writeTime) from JMJobStreams where jobId=J.jobId and writeTime>0), 0) END,
		initFrom, '', '', scanFileFailures, scanFolderFailures, backupFileFailures,
		backupFolderFailures, bkpOptions, bkpAttributes,
		(select login from UMUsers where id=userId), currentPolicy, 0, 0, 0, 0, 0, scanType, scanTypeChangeReason, compbytes, compbytes, 0, J.jobDescription, J.xmlJobInfo, 0, 0, -1, -1, B.nwTransBytes, 0, 0, N''
	FROM	JMJobInfo J WITH (READUNCOMMITTED), JMBkpJobInfo B WITH (READUNCOMMITTED), APP_Application A WITH (READUNCOMMITTED)
	WHERE	J.commcellId=B.commcellId and J.jobId=B.jobId and applicationId=A.id AND B.jobId=@jobId
	UNION
	SELECT	commcellId,jobId, subTaskId, optype,clientId,appId,appType,bkpLevel,
		(case displayStatus when 0 then status else displayStatus end),
		0,servStartDate,servEndDate,duration,0,
		totalNumOfFiles,totalUncompbytes,totalWriteTime,initFrom,'','',
		scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,bkpOptions,bkpAttributes,userName,
		JMBkpStats.dataArchGrpId, JMBkpStats.logArchGrpId,0,0,failureErrorCode,0,
		scanType,scanTypeChangeReason,totalcompbytes,totalBackupSize, percentageChange,
		'','', CASE WHEN opType = 60 THEN jobIdActedOn ELSE 0 END, 0, dataStatus, agedTime, JMBkpStats.nwTransBytes, 0, 0, N''
	FROM	JMBkpStats WITH (READUNCOMMITTED), APP_Application A WITH (READUNCOMMITTED)
	WHERE	appId = A.id AND jobId=@jobId
	UPDATE #BKPXT
	SET	wst=(select top 1 A.startTime
		FROM	JMBkpAttemptInfo A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
		WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
			T.jobId=J.jobId and A.phaseNum=J.phaseNum and A.attemptNum=J.attemptNum
		ORDER BY A.phaseNum, A.attemptNum)
	FROM	#BKPXT T
	UPDATE	#BKPXT
	SET		wst=T.StartDate, wet=T.EndDate
	FROM	(SELECT	A.jobId, A.commCellId, MIN(A.servStartDate) AS StartDate, MAX(A.servEndDate) AS EndDate
			FROM	#BKPXT B, JMBkpAtmptStats A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	B.jobId = A.jobId AND B.ccId = A.commCellId
				AND A.jobId = J.jobId AND A.commCellId = J.commCellId AND A.phase = J.phaseNum AND A.number = J.attemptNum
			GROUP BY A.jobId, A.commCellId) T
	WHERE	#BKPXT.ccId = T.commCellId AND #BKPXT.jobId = T.jobId
END
ELSE
BEGIN
IF @rptType IN ( 7717, 8003 )
	BEGIN
		INSERT INTO #tblAppIds
		SELECT DISTINCT A.id, scProp.created
		FROM APP_Application A WITH (READUNCOMMITTED)
		INNER JOIN APP_SubClientProp scProp WITH (READUNCOMMITTED)
		ON scProp.componentNameId = A.id
		AND scProp.attrName ='Is Turbo Subclient' and scProp.attrVal ='1' and scProp.modified = 0
		UNION
		SELECT DISTINCT A.id, scProp2.created
		FROM APP_Application A WITH (READUNCOMMITTED)
		INNER JOIN APP_SubClientProp scProp WITH (READUNCOMMITTED)
		ON scProp.componentNameId = A.id
		INNER JOIN APP_SubClientProp scProp2 WITH (READUNCOMMITTED)
		ON scProp.attrName = 'Associated subclient Policy' AND scProp.attrVal = scProp2.componentNameId
		AND scProp2.attrName ='Is Turbo Subclient' and scProp2.attrVal ='1' and scProp2.modified = 0
		IF @clOpt = 0
		BEGIN
			IF  @appTypeOpt = 0
				INSERT INTO #tblApplication
				SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
				FROM	APP_Application A WITH (READUNCOMMITTED)
				INNER JOIN #tblAppIds TA WITH (READUNCOMMITTED)
				ON TA.applicationId = A.id
WHERE (@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0
			ELSE
				INSERT INTO #tblApplication
				SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
				FROM	APP_Application A WITH (READUNCOMMITTED)
				INNER JOIN #tblAppIds TA WITH (READUNCOMMITTED)
				ON TA.applicationId = A.id
						INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
WHERE (@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0
		END
		ELSE
		BEGIN
			IF  @appTypeOpt = 0
				INSERT INTO #tblApplication
				SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
				FROM	APP_Application A WITH (READUNCOMMITTED)
				INNER JOIN #tblAppIds TA WITH (READUNCOMMITTED)
				ON TA.applicationId = A.id
				AND A.appTypeId not in (SELECT t_appTypeId FROM @tblApptypes)
				INNER JOIN #tblClients CL ON A.clientId = CL.t_clId
WHERE (@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0
			ELSE
				INSERT INTO #tblApplication
				SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
				FROM	APP_Application A WITH (READUNCOMMITTED)
				INNER JOIN #tblAppIds TA WITH (READUNCOMMITTED)
				ON TA.applicationId = A.id
						INNER JOIN #tblClients CL ON A.clientId = CL.t_clId
						INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
WHERE (@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0
		END
	END
IF @rptType = 7795 OR @rptType = 7784
	BEGIN
		--SET @active = 0
		--SET @history = 1
		SET @appTypeOpt = 0
		SET @order = 0
		SET @clOpt = 0
	END
	IF @appTypeOpt <> 0 AND (@appTypeOpt <> -1 AND @subclientFilterList <> 1)
		DELETE @tblApptypes
WHERE	@rptType in( 7715) AND t_appTypeId IN (select t_appTypeId from @tblRptApptypes) OR
@rptType not in( 7715) AND t_appTypeId NOT IN (select t_appTypeId from @tblRptApptypes where t_rptTypeId = @rptType)
	ELSE IF @rptType IN (select t_rptTypeId from @tblRptApptypes)
	BEGIN
		SET @appTypeOpt = 1
		INSERT INTO @tblApptypes
		SELECT	t_appTypeId
		FROM	@tblRptApptypes
		WHERE	t_rptTypeId = @rptType
	END
ELSE IF @rptType = 7795               ----MR: 21944
	BEGIN
		DELETE FROM	@tblRptApptypes
		--WHERE  t_rptTypeId != SRMJOB_REPORT			----need to show all jobs
	END
	--IF (@flags & 0x80000000000000) > 0 --Subclient Filtering
	IF @subclientFilterList > 0
	BEGIN
		CREATE TABLE #tblOptSubclientSelection (t_clientId int, t_agentId int, t_instanceId int, t_backupsetId int, t_subclientId int, t_exclude int)
		INSERT INTO #tblOptSubclientSelection EXEC rptOptGetSubclients @i_jobId, @scOpt OUTPUT
		IF @scOpt > 0
		BEGIN
			INSERT INTO @tblSubClientIds
				SELECT id FROM APP_Application
				INNER JOIN #tblOptSubclientSelection tmp ON
				(tmp.t_clientId = 0 OR clientId = tmp.t_clientId) AND (tmp.t_agentId = 0 OR appTypeId = tmp.t_agentId) AND (tmp.t_instanceId = 0 OR instance = tmp.t_instanceId)
				AND (tmp.t_backupsetId = 0 OR backupSet = tmp.t_backupsetId) AND (tmp.t_subclientId = 0 OR id = tmp.t_subclientId) AND tmp.t_exclude = 0
			DELETE  T FROM  @tblSubClientIds T
				INNER JOIN APP_Application A ON A.ID= T.t_id
				INNER JOIN #tblOptSubclientSelection tmp ON
					(clientId = tmp.t_clientId) AND (tmp.t_agentId = 0 OR appTypeId = tmp.t_agentId) AND (tmp.t_instanceId = 0 OR instance = tmp.t_instanceId)
					AND (tmp.t_backupsetId = 0 OR backupSet = tmp.t_backupsetId) AND (tmp.t_subclientId = 0 OR id = tmp.t_subclientId)
					AND tmp.t_exclude =1
			INSERT INTO #tblApplication
			SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
			FROM     APP_Application A WITH (READUNCOMMITTED)
						JOIN @tblSubclientIds sub
							ON id = sub.t_id
			LEFT OUTER JOIN #tblApplication table1 ON A.id = table1.id
			WHERE	(@appTypeOpt = 1 AND A.appTypeId in (select t_appTypeId from @tblApptypes)) OR @appTypeOpt IN (-1, 0)
			AND table1.id IS NULL	--Without this AppId getting added twice
IF @rptType IN ( 7717, 8003 )
			BEGIN
				--we are doing this only for Migration and archive summary report as we are adding apptypes twice for these reports.
				DELETE FROM #tblApplication WHERE not exists (select t_id from @tblSubclientIds where id = t_id)--delete subclients that are not selected
			END
		END
		DROP TABLE #tblOptSubclientSelection
	END
	ELSE
	IF @clOpt = 0
	BEGIN
		IF  @appTypeOpt = 0
			INSERT INTO #tblApplication
			SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
			FROM	APP_Application A WITH (READUNCOMMITTED)
			LEFT OUTER JOIN #tblApplication table1 ON A.id = table1.id
			WHERE	A.appTypeId NOT in (select t_appTypeId from @tblRptApptypes)
			AND table1.id IS NULL	--Without this AppId getting added twice
AND ((@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0)
		ELSE
			INSERT INTO #tblApplication
			SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
			FROM	APP_Application A WITH (READUNCOMMITTED)
					INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
			LEFT OUTER JOIN #tblApplication table1 ON A.id = table1.id
WHERE ((@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0)
			AND table1.id IS NULL	--Without this AppId getting added twice
	END
	ELSE
	BEGIN
		IF  @appTypeOpt = 0
			INSERT INTO #tblApplication
			SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
			FROM	APP_Application A WITH (READUNCOMMITTED) INNER JOIN #tblClients CL ON A.clientId = CL.t_clId
     		LEFT OUTER JOIN #tblApplication table1 ON A.id = table1.id
WHERE ((@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0)
			AND	A.appTypeId NOT in (select t_appTypeId from @tblRptApptypes)
			AND table1.id IS NULL	--Without this AppId getting added twice
		ELSE
			INSERT INTO #tblApplication
			SELECT DISTINCT A.id, A.clientId, A.appTypeId, A.instance, A.subclientStatus, A.dataArchGrpID, A.logArchGrpID
			FROM	APP_Application A WITH (READUNCOMMITTED) INNER JOIN #tblClients CL ON A.clientId = CL.t_clId
					INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
     		LEFT OUTER JOIN #tblApplication table1 ON A.id = table1.id
WHERE ((@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0)
			AND table1.id IS NULL	--Without this AppId getting added twice
	END
	--MR 46028:if the user selects SRM Data Collection option , any backup job run with SRM options enabled should be displayed in the report
IF @rptType = 7744
		INSERT INTO #tblApplication
		SELECT DISTINCT id, clientId, appTypeId, instance, subclientStatus, A.dataArchGrpID, A.logArchGrpID
		FROM	APP_Application A WITH (READUNCOMMITTED), JMBkpStats B WITH (READUNCOMMITTED)
		WHERE	 (B.bkpattributes & 0x40000000000) > 0	--JMBKP_RUN_FILE_ANALYTICS
				AND A.id = B.appId
				AND A.origCCId = B.commCellId
				AND @appTypeOpt = 1
				AND (@clOpt = 0 OR clientId in (select t_clId from #tblClients))
				AND (@subclientFilterList = 0 OR A.id in (SELECT t_id FROM @tblSubClientIds))
				AND A.id not in (select id from #tblApplication)	--Without this AppId getting added twice
	DELETE	#tblApplication
	FROM	#tblApplication T
			INNER JOIN APP_Application A
				ON T.id = A.id
			INNER JOIN APP_BackupSetName B
				ON A.backupset = B.id
	WHERE	B.name = 'defaultDummyBackupSet'
AND	A.appTypeId IN (37, 62, 103)
	IF @active > 0 OR @noBkp > 0
	BEGIN
		INSERT INTO #BKPXT
		SELECT 2, J.jobId, B.backupTaskId, J.optype, A.clientId, A.id, appTypeId, bkpLevel, 0, state, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase, filesXfered, uncompbytes,
CASE WHEN B.bkpAttributesEx & 0x40000000 <> 0 THEN -1 ELSE isnull((select sum(writeTime) from JMBkpAttemptInfo WITH (READUNCOMMITTED) where JMBkpAttemptInfo.jobId=J.jobId and writeTime>0), 0)+isnull((select max(writeTime) from JMJobStreams WITH (READUNCOMMITTED) where jobId=J.jobId and writeTime>0), 0) END,
			initFrom, '', '', scanFileFailures, scanFolderFailures, backupFileFailures,
			backupFolderFailures, bkpOptions, bkpAttributes,
			(select login from UMUsers where id=userId), currentPolicy, 0, 0, 0, 0, 0, scanType, scanTypeChangeReason, compbytes, compbytes, 0, J.jobDescription, J.xmlJobInfo, 0, 0, -1, -1, -1, 0, 0, N''
		FROM	JMJobInfo J WITH (READUNCOMMITTED), JMBkpJobInfo B WITH (READUNCOMMITTED), #tblApplication A
		WHERE	J.commcellId=B.commcellId and J.jobId=B.jobId and applicationId=A.id AND
			jobStartTime <= @endTime AND
			(@jobTypeOpt = 0 OR (@jobTypeOpt & bkpLevel) > 0)
			AND state in (1,4,9) -- RUNNING=1 , COMPLETED=4 ,COMPLETEDSUCCESS=9
		IF @includeVSiDA = 1
		BEGIN
			INSERT INTO #BKPXT
			SELECT DISTINCT 2, J.jobId, B.backupTaskId, J.optype, A.clientId, A.id, appTypeId, bkpLevel, 0, state, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase, filesXfered, uncompbytes,
CASE WHEN B.bkpAttributesEx & 0x40000000 <> 0 THEN -1 ELSE isnull((select sum(writeTime) from JMBkpAttemptInfo WITH (READUNCOMMITTED) where JMBkpAttemptInfo.jobId=J.jobId and writeTime>0), 0)+isnull((select max(writeTime) from JMJobStreams WITH (READUNCOMMITTED) where jobId=J.jobId and writeTime>0), 0) END,
			initFrom, '', '', scanFileFailures, scanFolderFailures, backupFileFailures,
			backupFolderFailures, bkpOptions, bkpAttributes,
			(select login from UMUsers where id=userId), currentPolicy, 0, 0, 0, 0, 0, scanType, scanTypeChangeReason, compbytes, compbytes, 0, J.jobDescription, J.xmlJobInfo, 0, 0, -1, -1, -1, 0, 0, N''
			FROM	JMJobInfo J WITH (READUNCOMMITTED), JMBkpJobInfo B WITH (READUNCOMMITTED), APP_Application A, JMQinetixUpdateStatus Q
			WHERE	J.commcellId=B.commcellId and J.jobId=B.jobId and applicationId=A.id AND
				jobStartTime <= @endTime AND
				(@jobTypeOpt = 0 OR (@jobTypeOpt & bkpLevel) > 0)
				AND state in (1,4,9) -- RUNNING=1 , COMPLETED=4 ,COMPLETEDSUCCESS=9
				AND	J.jobId = Q.jobId AND J.commCellId = Q.commCellId
				AND	A.appTypeId = 106 -- VSiDA
				AND @clOpt <> 0
				AND (Q.clientId in (SELECT t_clId FROM #tblClients) AND A.clientId NOT IN (SELECT t_clId FROM #tblClients))
AND ((@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0)
		END
		UPDATE #BKPXT
		SET	wst=(select top 1 A.startTime
			FROM	JMBkpAttemptInfo A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
				T.jobId=J.jobId and A.phaseNum=J.phaseNum and A.attemptNum=J.attemptNum
			ORDER BY A.phaseNum, A.attemptNum)
		FROM	#BKPXT T
	END
	IF @delayed > 0
	BEGIN
		INSERT INTO #BKPXT
		SELECT 2, J.jobId, B.backupTaskId, J.optype, A.clientId, A.id, appTypeId, bkpLevel, 0, state, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase, filesXfered, uncompbytes,
CASE WHEN B.bkpAttributesEx & 0x40000000 <> 0 THEN -1 ELSE isnull((select sum(writeTime) from JMBkpAttemptInfo where JMBkpAttemptInfo.jobId=J.jobId and writeTime>0), 0)+isnull((select max(writeTime) from JMJobStreams where jobId=J.jobId and writeTime>0), 0) END,
			initFrom, '', '', scanFileFailures, scanFolderFailures, backupFileFailures,
			backupFolderFailures, bkpOptions, bkpAttributes,
			(select login from UMUsers where id=userId), currentPolicy, 0, 0, 0, 0, 0, scanType, scanTypeChangeReason, compbytes, compbytes, 0, J.jobDescription, J.xmlJobInfo, 0, 0, -1, -1, -1, 0, 0, N''
		FROM	JMJobInfo J WITH (READUNCOMMITTED), JMBkpJobInfo B WITH (READUNCOMMITTED), #tblApplication A
		WHERE	J.commcellId=B.commcellId and J.jobId=B.jobId and applicationId=A.id AND
			jobStartTime <= @endTime AND
			(@jobTypeOpt = 0 OR (@jobTypeOpt & bkpLevel) > 0)
			AND state NOT in (1,4,9)
		IF @includeVSiDA = 1
		BEGIN
			INSERT INTO #BKPXT
			SELECT DISTINCT 2, J.jobId, B.backupTaskId, J.optype, A.clientId, A.id, appTypeId, bkpLevel, 0, state, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase, filesXfered, uncompbytes,
CASE WHEN B.bkpAttributesEx & 0x40000000 <> 0 THEN -1 ELSE isnull((select sum(writeTime) from JMBkpAttemptInfo where JMBkpAttemptInfo.jobId=J.jobId and writeTime>0), 0)+isnull((select max(writeTime) from JMJobStreams where jobId=J.jobId and writeTime>0), 0) END,
			initFrom, '', '', scanFileFailures, scanFolderFailures, backupFileFailures,
			backupFolderFailures, bkpOptions, bkpAttributes,
			(select login from UMUsers where id=userId), currentPolicy, 0, 0, 0, 0, 0, scanType, scanTypeChangeReason, compbytes, compbytes, 0, J.jobDescription, J.xmlJobInfo, 0, 0, -1, -1, -1, 0, 0, N''
			FROM	JMJobInfo J WITH (READUNCOMMITTED), JMBkpJobInfo B WITH (READUNCOMMITTED), APP_Application A, JMQinetixUpdateStatus Q
			WHERE	J.commcellId=B.commcellId and J.jobId=B.jobId and applicationId=A.id AND
				jobStartTime <= @endTime AND
				(@jobTypeOpt = 0 OR (@jobTypeOpt & bkpLevel) > 0)
				AND state NOT in (1,4,9)
				AND	J.jobId = Q.jobId AND J.commCellId = Q.commCellId
				AND	A.appTypeId = 106 -- VSiDA
				AND @clOpt <> 0
				AND (Q.clientId in (SELECT t_clId FROM #tblClients) AND A.clientId NOT IN (SELECT t_clId FROM #tblClients))
AND ((@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0)
		END
		UPDATE #BKPXT
		SET	wst=(select top 1 A.startTime
			FROM	JMBkpAttemptInfo A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
				T.jobId=J.jobId and A.phaseNum=J.phaseNum and A.attemptNum=J.attemptNum
			ORDER BY A.phaseNum, A.attemptNum)
		FROM	#BKPXT T
	END
	create index tblApplication_idx1 on #tblApplication (id);
	IF @history > 0 OR @noRun > 0 OR (@includeSkippedInNoRun = 0 AND @skipped > 0)
	BEGIN
		INSERT INTO #BKPXT
		SELECT	commcellId,jobId, subTaskId, optype,clientId,appId,appType,bkpLevel,
				(case displayStatus when 0 then status else displayStatus end),0,servStartDate,servEndDate,duration,0,
				totalNumOfFiles,totalUncompbytes,
CASE WHEN J.bkpAttributesEx & 0x40000000 <> 0 THEN -1 ELSE totalWriteTime END,initFrom,'','',
				scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,bkpOptions,bkpAttributes,userName,
				J.dataArchGrpId, J.logArchGrpId,0,0,failureErrorCode,0,
				scanType,scanTypeChangeReason,totalcompbytes,totalBackupSize,percentageChange,
				'', '', CASE WHEN J.opType = 60 THEN J.jobIdActedOn ELSE 0 END, 0, J.dataStatus,J.agedTime, J.nwTransBytes, 0, 0, N''
		FROM	JMBkpStats J WITH (READUNCOMMITTED) INNER JOIN #tblApplication A ON appId = A.id
		WHERE	servEndDate >= @startTime AND servStartDate <= @endTime
			AND (@jobTypeOpt = 0 OR (@jobTypeOpt & bkpLevel) > 0)
			AND (@needStatus = 0 OR (case displayStatus when 0 then status else displayStatus end) in (select status from @tblStatus))
		-- Proxy client VSA job will be included when All Clients Selected/Proxy client selected
		-- So include Proxy client jobs only when All Clients option is not selected and proxy client is not selected
		-- Otherwise those jobs will get selected twice once in the above selection and once here.
		IF @includeVSiDA = 1 AND @clOpt <> 0
		BEGIN
			INSERT INTO #BKPXT
			SELECT	DISTINCT J.commcellId,J.jobId, J.subTaskId, optype,(SELECT clientId FROM APP_Application WHERE id = appId),appId,appType,bkpLevel,
					(case J.displayStatus when 0 then J.status else J.displayStatus end),0,servStartDate,servEndDate,duration,0,
					totalNumOfFiles,totalUncompbytes,
CASE WHEN J.bkpAttributesEx & 0x40000000 <> 0 THEN -1 ELSE totalWriteTime END,initFrom,'','',
					scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,bkpOptions,bkpAttributes,userName,
					J.dataArchGrpId, J.logArchGrpId,0,0,failureErrorCode,0,
					scanType,scanTypeChangeReason,totalcompbytes,totalBackupSize,percentageChange,
					'', '', CASE WHEN J.opType = 60 THEN J.jobIdActedOn ELSE 0 END, 0, J.dataStatus,J.agedTime, J.nwTransBytes, 0, 0, N''
			FROM	JMBkpStats J WITH (READUNCOMMITTED) INNER JOIN APP_Application A ON appId = A.id
					INNER JOIN JMQinetixUpdateStatus Q ON J.jobId = Q.jobId AND J.commCellId = Q.commCellId
			WHERE	J.appType = 106 -- VSiDA
				AND servEndDate >= @startTime AND servStartDate <= @endTime
				AND (@jobTypeOpt = 0 OR (@jobTypeOpt & bkpLevel) > 0)
				AND (@needStatus = 0 OR (case displayStatus when 0 then J.status else displayStatus end) in (select status from @tblStatus))
				AND Q.clientId IN (SELECT t_clId FROM #tblClients) AND A.clientId NOT IN (SELECT t_clId FROM #tblClients)
AND ((@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0)
		END
		UPDATE	#BKPXT
		SET		wst=T.StartDate, wet=T.EndDate
		FROM	(SELECT	A.jobId, A.commCellId, MIN(A.servStartDate) AS StartDate, MAX(A.servEndDate) AS EndDate
				FROM	#BKPXT B, JMBkpAtmptStats A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
				WHERE	B.jobId = A.jobId AND B.ccId = A.commCellId
					AND A.jobId = J.jobId AND A.commCellId = J.commCellId AND A.phase = J.phaseNum AND A.number = J.attemptNum
				GROUP BY A.jobId, A.commCellId) T
		WHERE	#BKPXT.ccId = T.commCellId AND #BKPXT.jobId = T.jobId
	END
	UPDATE	#BKPXT
SET		state = 100
	FROM	#BKPXT T INNER JOIN JMJobInfo J ON	J.commcellId = T.ccId AND J.jobId = T.jobId
	WHERE	J.guiAlertColorLevel = 40 --NO_RESPONSE_GUI_COLOR
IF @rptType = 7716
	BEGIN
		DECLARE @tblOptype	TABLE (t_optype int)
		DECLARE @isSnapshot	int
		DECLARE @isCreateRep	int
		DECLARE @isUpdteRep	int
SET @isSnapshot	= dbo.GetOptionInt(2029967311, @i_jobId, 0, 0)
SET @isCreateRep= dbo.GetOptionInt(1274499673, @i_jobId, 0, 0)
SET @isUpdteRep	= dbo.GetOptionInt(761051788, @i_jobId, 0, 0)
		IF @isSnapshot > 0
			INSERT INTO @tblOptype VALUES (22)	--SNAPSHOT
		IF @isCreateRep > 0
			INSERT INTO @tblOptype VALUES (23)	--CREATEREPLICA
		IF @isUpdteRep > 0
			INSERT INTO @tblOptype VALUES (24)	--UPDATEREPLICA
		DELETE #BKPXT WHERE optype NOT IN (select t_optype from @tblOptype)
	END
END
 -- Create index now for TR:160318-392 where rptbkphistoryifno.SP is taken hours to complete
create NONCLUSTERED  index BKPXT_idx1 on #BKPXT (jobid, ccId);
IF @rptType = 8003
BEGIN
	--Remove non-turbo jobs AND jobs from previous cycles
	DELETE	#BKPXT
	FROM	#BKPXT B
				JOIN #tblAppIds T
					ON B.appId = T.applicationId
				JOIN (SELECT appid, MAX(jobid) LASTFULLJOB
						FROM #BKPXT
						WHERE bLevel IN (0X1, 0x40, 0x80, 0x400, 0x8000)
								AND status NOT IN (2, 4, 9) --(FAIL, KILLED, DROPPED)
						GROUP BY appId) LASTCYCLE
					ON B.appId = LASTCYCLE.appId
	WHERE	B.startT < T.created OR B.jobId < LASTCYCLE.LASTFULLJOB
END
ELSE IF @rptType = 7717
BEGIN
	 --Remove non-turbo jobs
    DELETE  #BKPXT
	FROM    #BKPXT T
	LEFT OUTER JOIN (
	      SELECT      B.jobId, B.commCellId
	      FROM  #BKPXT X
	                  INNER JOIN JMBkpStats B ON X.jobId = B.jobId AND X.ccId = B.commCellId
	                  INNER JOIN JMJobStats J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
	      WHERE (B.appType IN (45,67,68,57,58,66,73,82,83,56,89,90) OR J.subOptype = 98 OR J.opType = 109)
	            AND B.opType <> 60 AND (B.opType <> 59 OR J.subOpType <> 96)
		  UNION
		  SELECT      B.jobId, B.commCellId
	      FROM  #BKPXT X
	                  INNER JOIN JMBkpJobInfo B ON X.jobId = B.jobId AND X.ccId = B.commCellId
					  INNER JOIN JMJobStats J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
					  INNER JOIN APP_Application A ON A.id = B.applicationId AND X.ccId = A.origCCId
		  WHERE (A.appTypeId IN (45,67,68,57,58,66,73,82,83,56,89,90) OR J.subOptype = 98 OR J.opType = 109)
	            AND J.opType <> 60 AND (J.opType <> 59 OR J.subOpType <> 96)
	      ) S ON T.jobId = S.jobId AND T.ccId = S.commCellId
	WHERE S.jobId IS NULL
	DELETE  #BKPXT
	FROM    #BKPXT B
			LEFT OUTER JOIN #tblAppIds T
		 ON B.appId = T.applicationId
	WHERE	B.appType = 106 AND T.applicationId IS NULL
END
ELSE IF @rptType NOT IN ( 7795, 7784)
BEGIN
	--Remove turbo jobs
	DELETE	#BKPXT
	FROM    #BKPXT T
	INNER JOIN JMBkpStats B ON T.jobId = B.jobId AND T.ccId = B.commCellId
	INNER JOIN JMJobStats J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
	WHERE (B.appType IN (45,67,68,57,58,66,73,82,83,56,89,90) OR J.subOptype = 98 OR J.opType = 109)
	    AND B.opType <> 60 AND (B.opType <> 59 OR J.subOpType <> 96)
	DELETE	#BKPXT
	FROM    #BKPXT T
	INNER JOIN JMBkpJobInfo B ON T.jobId = B.jobId AND T.ccId = B.commCellId
	INNER JOIN JMJobStats J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
	INNER JOIN APP_Application A ON A.id = B.applicationId AND T.ccId = A.origCCId
	WHERE (A.appTypeId IN (45,67,68,57,58,66,73,82,83,56,89,90) OR J.subOptype = 98 OR J.opType = 109)
	    AND J.opType <> 60 AND (J.opType <> 59 OR J.subOpType <> 96)
END
IF @includeAged = 0 and @jobId = 0
	DELETE #BKPXT FROM JMBkpStats J WITH (READUNCOMMITTED), #BKPXT B
	WHERE B.jobId=J.jobId and B.ccId=J.commcellId and J.dataStatus=1 AND B.status NOT IN (2, 4, 9) 	--(FAIL, KILLED, DROPPED)
-- INCLUDE SUCCESSFUL JOBS WITH DATA STATUS (MEDIA_DELETED)
IF @MediaDeleted <> 1
	DELETE #BKPXT FROM JMBkpStats J WITH (READUNCOMMITTED), #BKPXT B
	WHERE B.jobId=J.jobId and B.ccId=J.commcellId and J.dataStatus=2 AND B.status NOT IN (2, 4, 9) 	--(FAIL, KILLED, DROPPED)
	UPDATE #BKPXT
	SET state=-1
	FROM JMBkpStats J WITH (READUNCOMMITTED), #BKPXT B
	WHERE B.jobId=J.jobId and B.ccId=J.commcellId and J.dataStatus in (1,2) AND B.status NOT IN (2, 4, 9)	--(FAIL, KILLED, DROPPED)
--MR 37995: DELETE ALL OTHERS JOBS IF SNAP BKP JOBS OPTION HAS BEEN SELECTED.
IF @snapBkpJobsOnly =1
	DELETE FROM #BKPXT WHERE optype != 59    ---SNAPBACKUP = 59
IF @jobId = 0 AND @rptType NOT IN ( 7795, 7784 )
BEGIN
IF @subClientOpt = 1
	BEGIN
		INSERT	INTO #tblLastJob
		SELECT	appId, MAX(jobid)
		FROM	#BKPXT
		WHERE	status IN (1, 3) AND (bLevel & 0x40) = 0
		GROUP BY appId
		DELETE	#BKPXT
		FROM	#BKPXT LEFT OUTER JOIN #tblLastJob ON appId = t_appId
		WHERE	t_appId IS NULL OR jobId <> t_job
	END
ELSE IF @subClientOpt = 2
	BEGIN
		INSERT INTO #tblLastJob
		SELECT t_appId=appId, t_jobId=MAX(jobId)
		FROM #BKPXT
		GROUP BY appId
		DELETE	#BKPXT
		FROM	#BKPXT, #tblLastJob
		WHERE	appId = t_appId AND jobId <> t_job
	END
END
DROP TABLE #tblLastJob
UPDATE	#BKPXT
SET		cIdx = T.cIdx
FROM	(SELECT	J.jobId, J.commCellId, SUM(J.attributeValueInt) AS cIdx
		FROM	JMjobOptions J WITH (READUNCOMMITTED), #BKPXT B
		WHERE	J.jobId = B.jobId AND J.commCellId = B.ccId
AND J.attributeId IN (2,3,4,5)
		GROUP BY J.jobId, J.commCellId) T
WHERE	#BKPXT.jobId = T.jobId AND #BKPXT.ccId = T.commCellId
UPDATE	#BKPXT
SET		cIdx = (case when O.isExpired = 0 and isCIed > 0 then 1 else 0 end)
FROM	(select	AF.jobId, AF.commCellId, isCIed = sum(flags & (64 + 32)), isExpired = sum(flags & 256)
		from	archFile AF WITH (READUNCOMMITTED), #BKPXT B
		where	AF.jobId = B.jobId AND AF.commCellId = B.ccId AND AF.cloudId > 0
		group by AF.jobId, AF.commCellId) O
WHERE	#BKPXT.jobId = O.jobId and #BKPXT.ccId = O.commcellId
IF @includeFailedFilesOnly <> 0
BEGIN
	DELETE	FROM #BKPXT
	WHERE	(sFl + bFl + sFd + bFd) <= @failedFilesThreshold
END
--Delete per VM jobs. Include only the parent job for VM Backup Jobs
DELETE FROM #BKPXT
FROM #BKPXT B
INNER JOIN JMBkpStats J WITH(NOLOCK) ON B.JobId = J.JobId AND B.ccId = J.CommCellId
WHERE bkpAttributesEx & 0x4000000 <> 0
--Delete per VM jobs for active jobs. Include only the parent job for VM Backup Jobs
DELETE FROM #BKPXT
FROM #BKPXT B
INNER JOIN JMBkpJobInfo J WITH(NOLOCK) ON B.JobId = J.JobId AND B.ccId = J.CommCellId
WHERE bkpAttributesEx & 0x4000000 <> 0
--Delete child job for Synth full parent job. JMBKP_EX_VSA_PARENT_SYNTHFULL applicable only for V2 Clients
DELETE FROM #BKPXT
from #BKPXT B
INNER JOIN JMJobDataLink JL on B.jobId = JL.childJobId and JL.linkType = 7
INNER JOIN JMBkpStats JB ON JB.jobId = JL.parentJobId
where bkpAttributesEx & 0x100000000000000 <> 0 and JB.bkplevel = 64
--final table for return list
IF object_id('tempdb.dbo.#BKPXF') IS NOT NULL DROP TABLE #BKPXF
CREATE TABLE #BKPXF(
	type		INT,
	tot		INT,
	suc		INT,
	partSuc		INT,
	run		INT,
	killed		INT,
	noRun		INT,
	noBkp		INT,
	commcellId	INT	default(0),
	client		INT	default(0),
	clientName	nvarchar(256) default(''),
	appType		INT	default(0),
	appTypeName	varchar(256) default(''),
	instance	INT	default(0),
	instName	nvarchar(512) default(''),
	backupSet	INT	default(0),
	bsName		nvarchar(128) default(''),
	subClient	INT	default(0),
	scName		nvarchar(128) default(''),
	jobId		INT	default(0),
	clientGrpId	INT default(0),
	cgName		NVARCHAR(1024) default(N''),
	bLevel		INT	default(0),
	status		INT	default(0),
	state		INT	default(0),
	duration	INT	default(0),
	startT		INT	default(0),
	endT		INT	default(0),
	phase		varchar(64) default(''),
	objects		bigint	default(0),
	uncompSize		bigint	default(0),
	bTime		INT	default(0),
	initF		INT	default(0),
	sFl		INT	default(0),
	sFd		INT	default(0),
	bFl		INT	default(0),
	bFd		INT	default(0),
	totalFl		bigint	default(0),
	totalFd		bigint	default(0),
	options		INT	default(0),
	attributes	bigint	default(0),
	userName	nvarchar(256) default(''),
	archGrp		INT	default(0),
	archGrpName	nvarchar(144) default(''),
	logGrp		INT	default(0),
	logGrpName	nvarchar(144) default(''),
	currentS	bigint	default(0),
	currentT	INT	default(0),
	MAId		INT	default(0),
	MAName		nvarchar(144) default(''),
	writeStartT	INT	default(0),
	writeEndT	INT	default(0),
	optype		INT	default(0),
	subOptype	INT	default(0),
	scantype	INT	default(0),
	failError	INT	default(0),
	cIdx		BIGINT	default(0),
	compSize	BIGINT	default(0),
	bkpSize	BIGINT	default(0),
	percChange	INT	default(0),
	extRetentionFlags	int default(0),
	retentionDays		int default(0),
	pinJobEndTime		bigint default(0),
	snapJobId			int default(0),
	snapJobStatus 		int default(0),
	dataStatus			int default(-1),
	agedTime			int default(-1),
	transferredDataSize	bigint default(-1),
	schedName			nvarchar(255) default(N''),
	sizeOnMedia 		bigint default(0),
	sysStateSkipReason	INT default(0),
	stubSize			BIGINT default(0),
	isCatelogJob		INT default(0),
	bkpAttributesEx		BIGINT default(0),
	cellName			nvarchar(256) default(''),
	failIds		varchar(512) default(''),
	proxyHostName   nvarchar(256) default(''),
	MAList		ntext	default(N''),
	failR		ntext	default(N''),
	scanChgR	ntext	default(N''),
	xmlJobOption    nvarchar(MAX) default(N''),
	jobDescription  nvarchar(MAX) default(N''),
	clientDesc		nvarchar(MAX) default(N''),
	idaDesc			nvarchar(MAX) default(N''),
	instanceDesc	nvarchar(MAX) default(N''),
	bkpSetDesc		nvarchar(MAX) default(N''),
	subclientDesc	nvarchar(MAX) default(N''),
	clientGroups	varchar(MAX) default(''),
	referenceCopyCriteria	nvarchar(MAX) default(N''),
	referenceCopyAssociation	nvarchar(MAX) default(N''),
	topNXml	XML,
	clientOwnersList nvarchar(MAX) default(N''),
	clientHostName	nvarchar(256) default(''),
	skipped			int,
	committed		int,
	TrueUp		    int,
    clientDisplayName  nvarchar(256) default('')
)
IF @jobId = 0 AND @snapBkpJobsOnly <> 1
BEGIN
IF @noBkp > 0
BEGIN
	IF @startTime > 0 AND @endTime > 0
		INSERT INTO #tblSubclients
		SELECT distinct appId
		FROM JMBkpStats WITH (NOLOCK) JOIN #tblApplication ON appId = id
		WHERE servEndDate >= @startTime AND servStartDate <= @endTime
	ELSE IF @startTime > 0 AND @endTime = 0
		INSERT INTO #tblSubclients
		SELECT distinct appId
		FROM JMBkpStats WITH (NOLOCK) JOIN #tblApplication ON appId = id
		WHERE servEndDate >= @startTime
	ELSE IF @startTime = 0 AND @endTime > 0
		INSERT INTO #tblSubclients
		SELECT distinct appId
		FROM JMBkpStats WITH (NOLOCK) JOIN #tblApplication ON appId = id
		WHERE servStartDate <= @endTime
	ELSE
		INSERT INTO #tblSubclients
		SELECT distinct appId
		FROM JMBkpStats WITH (NOLOCK) JOIN #tblApplication ON appId = id
	INSERT INTO #BKPXT
	SELECT	0, 0, 0, 0, clientId, id, appTypeId, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, '', '', 0, 0, 0, 0, 0, 0, '',
			dataArchGrpId, logArchGrpId, 0, 0, 0, 0, 0, '', 0, 0, 0, '','', 0 ,0, -1, -1, -1, 0, 0, N''
	FROM	#tblApplication A
			LEFT OUTER JOIN #tblSubclients S ON A.id = S.t_appId
			LEFT OUTER JOIN (select distinct appId from #BKPXT) B ON A.id = B.appId
	WHERE	A.appTypeId < 1000 AND S.t_appId IS NULL AND B.appId IS NULL
	IF (@active IS NULL OR @active < 1) OR (@delayed = 1 AND (@active IS NULL OR @active < 1))
	DELETE FROM #BKPXT
	WHERE state IN (1, 4, 9) AND status = 0
	IF  @active = 0 AND @history = 0 AND @delayed =0
	BEGIN
		IF object_id('tempdb.dbo.#tblTempNoRunJobs') is not null DROP TABLE #tblTempNoRunJobs
		SELECT * INTO #tblTempNoRunJobs FROM JMBkpStats WITH (READUNCOMMITTED)
		WHERE	(@needStatus = 0 OR (case displayStatus when 0 then status else displayStatus end) in (select status from @tblStatus)) AND
			servEndDate >= @startTime AND servStartDate <= @endTime AND
			(@jobTypeOpt = 0 OR (@jobTypeOpt & bkpLevel) > 0) AND
			failureErrorCode IN (7, 8, 11, 12) --ACTIVITYDISABLED, MAXINSTANCESRUNNING, SCHEDSKIPPEDLATE
		INSERT INTO #BKPXT
		SELECT T.commcellId, jobId, subTaskId, optype, clientId, appId, appType, bkpLevel, (case displayStatus when 0 then status else displayStatus end), 0, servStartDate, servEndDate, duration, 0,
			totalNumOfFiles, totalUncompbytes,
CASE WHEN T.bkpAttributesEx & 0x40000000 <> 0 THEN -1 ELSE totalWriteTime END, initFrom, '', '',
			scanFileFailures, scanFolderFailures, backupFileFailures, backupFolderFailures, bkpOptions, bkpAttributes, userName,
			T.dataArchGrpId, T.logArchGrpId, 0, failureErrorCode, 0, scanType, scanTypeChangeReason, totalCompbytes, totalBackupSize, percentageChange,
			'',  '', 0, 0, -1, -1, -1, 0, 0, 0, N''
		FROM	#tblTempNoRunJobs T
		join  #tblApplication A ON T.appId=A.id
		WHERE	id NOT IN (select distinct appId from #BKPXT)
		DROP TABLE #tblTempNoRunJobs
	END
	DELETE #BKPXT FROM #tblApplication A, APP_InstanceName I, #BKPXT B
	WHERE B.appId = A.id and B.jobId = 0 and A.instance = I.id and
		((A.subclientStatus & 2) > 0 OR 	-- uninstalled
		 (A.subclientStatus & 4) > 0 OR 	-- deleted
		 (A.subclientStatus & 16) > 0 OR	-- dummy
		 (A.subclientStatus & 32) > 0 OR	-- hidden
		 (A.subclientStatus & 64) > 0 OR	-- cmdline
		 (I.status & 16) > 0 OR
		 (I.status & 32) > 0)
END
DROP TABLE #tblSubclients
IF (@appTypeOpt = 0 OR EXISTS (SELECT * FROM @tblAppTypes WHERE t_appTypeId = 53))
BEGIN
	 IF object_id('tempdb.dbo.#DAGServerAssociation') is not null DROP TABLE #DAGServerAssociation
	CREATE TABLE #DAGServerAssociation (DAGServerClId int, DAGAssociatedClId int, created int,modified int)
	INSERT INTO #DAGServerAssociation(DAGServerClId , DAGAssociatedClId ,created,modified)
		SELECT DISTINCT CP.componentNameId,
			(select TOP 1 id from APP_Client C WITH (READUNCOMMITTED)
			 where c.net_hostname like CP.attrName
AND ((C.status & 0x1000000) != 0)
AND ((C.status & ( 2 | 4)) = 0)), --0x00002 | 0x00004
			 CP.created,
			 CP.modified
	FROM APP_ClientProp CP WITH (READUNCOMMITTED) join APP_Client C WITH (READUNCOMMITTED) on CP.componentnameId = C.id
	WHERE CP.attrType = 125--PROPERTY_DAG_MEMBERSERVER
	IF  (@clOpt != 0 )
		DELETE  #DAGServerAssociation WHERE DAGAssociatedClId NOT IN (SELECT t_clId FROM #tblClients)
	DELETE	#BKPXT
		FROM	#BKPXT B
		JOIN #DAGServerAssociation DAG ON
DAG.DAGAssociatedClId = B.clId AND B.appType =53 AND (B.startT > DAG.created OR B.startT =-1)AND (B.startT<DAG.modified OR DAG.modified = 0)
	DROP TABLE #DAGServerAssociation
END
IF object_id('tempdb.dbo.#tblApplication') is not null DROP TABLE #tblApplication
IF @jobId = 0
BEGIN
	SET	@optSizeDecr = @optSizeDecr * (-1)
	IF @optSizeDecr <> 0 AND @optSizeIncr <> 0
		DELETE	#BKPXT
		WHERE	percChange < @optSizeIncr AND ( percChange > @optSizeDecr OR percChange = -200 )  -- percChange of -200 means, Previous job size is 0 and hence could not calculate the percentage Change.
	ELSE IF @optSizeDecr <> 0
		DELETE	#BKPXT
		WHERE	( percChange > @optSizeDecr OR percChange = -200 )
	ELSE IF @optSizeIncr <> 0
		DELETE 	#BKPXT
		WHERE	percChange < @optSizeIncr
END
IF @useAbsTimeRangeForJobSummaryRpt = 1
BEGIN
	DELETE FROM #BKPXT WHERE startT <= @startTime OR endT >= @endTime
END
IF  @subClientOpt = 1
	DELETE #BKPXT
	WHERE	failError IN (7, 8, 11, 12)		--(ACTIVITYDISABLED, MAXINSTANCESRUNNING, SCHEDSKIPPEDLATE, SCHEDSKIPPEDHOLIDAY)
END
UPDATE T
SET T.failIds = tmp.failIds
FROM #BKPXT T
INNER JOIN (SELECT T.ccId,T.jobId,J.failureReason AS failIds
			 FROM #BKPXT T
			 INNER JOIN JMJobInfo J WITH (READUNCOMMITTED)
			 ON T.ccId = J.commCellId AND T.jobId = J.jobId
			UNION
			SELECT T.ccId,T.jobId,J.failureReason AS failIds
			 FROM #BKPXT T
			 INNER JOIN JMBkpStats J WITH (READUNCOMMITTED)
			 ON T.ccId = J.commCellId AND T.jobId = J.jobId) tmp
ON T.ccId = tmp.ccId   AND T.jobId = tmp.jobId
IF @errorCodeFilter > 0
BEGIN
	DECLARE @tmpTab TABLE(JOBID INT, MARK INT);
	DELETE FROM #BKPXT
	WHERE failIds IS NULL OR failIds = ''
	INSERT INTO @tmpTab
	SELECT jobId, dbo.MarkNonErrorForDel(@errorCodeFilter, failIds)
	FROM #BKPXT
	DELETE FROM #BKPXT
	WHERE JOBID IN (SELECT JOBID FROM @tmpTab WHERE MARK = 0)
END
UPDATE	#BKPXT
SET	status = -1
WHERE	failError IN (7, 8, 11, 12)			--(ACTIVITYDISABLED, MAXINSTANCESRUNNING, SCHEDSKIPPEDLATE, SCHEDSKIPPEDHOLIDAY)
--MR 43042
--Delete the jobs if startTime > current time
IF @startTime > dbo.getunixtime(GETUTCDATE())
	DELETE FROM #BKPXT
--Delete the jobs if No Run is only selected
IF @failed = 0
	DELETE #BKPXT
	WHERE status=9
IF @noRun = 0
BEGIN
	DELETE #BKPXT
	WHERE	status=-1 AND failError IN (7, 8, 11) --(ACTIVITYDISABLED, MAXINSTANCESRUNNING, SCHEDSKIPPEDLATE)
	IF @includeSkippedInNoRun = 1
	DELETE #BKPXT WHERE status = -1 AND failError = 12	--SCHEDSKIPPEDHOLIDAY
END
IF @includeSkippedInNoRun = 0
	IF @skipped = 0
		DELETE #BKPXT
		WHERE	status=-1 AND failError = 12	--SCHEDSKIPPEDHOLIDAY
	ELSE
		UPDATE #BKPXT
		SET status = -2
		WHERE failError = 12
--Delete the Delayed Jobs if not Selected
IF @delayed = 0
	DELETE #BKPXT
	WHERE status=0 and state NOT in (1,4,9) and @allJobStatus = 0
--if SILO Archive Report, delete other backup jobs and vice versa.
IF @rptType=7758
BEGIN
	DELETE FROM #BKPXT WHERE appId NOT IN (SELECT componentNameId FROM APP_subclientProp  WITH (READUNCOMMITTED) WHERE  attrName = 'SILO Copy ID' AND attrVal <> '0')
	IF EXISTS (SELECT * FROM @tblSPCopies)
	BEGIN
		DECLARE	@tblSiloCopies TABLE (copyId INT)
		INSERT	INTO @tblSiloCopies
		SELECT	AGC.id
		FROM	@tblSPCopies C, archGroupCopy AGC
		WHERE	AGC.archGroupId = C.archGroupId
			AND (C.copyId = 0 OR AGC.id = C.copyId)
AND ((AGC.flags & 524288) > 0 OR (AGC.extendedFlags & 8) > 0)
		IF NOT EXISTS (SELECT * FROM @tblSiloCopies)
			DELETE	#BKPXT
		ELSE
			DELETE	#BKPXT
			FROM	#BKPXT B
					LEFT OUTER JOIN
					(SELECT	DISTINCT J.jobId, J.commCellId
					FROM	JMJobDataStats J INNER JOIN @tblSiloCopies C
						ON	C.copyId = J.archGrpCopyId) T
				ON	T.jobId = B.jobId AND T.commCellId = B.ccId
			WHERE	T.jobId IS NULL
	END
END
ELSE IF @rptType = 7715
BEGIN
	IF EXISTS (SELECT * FROM @tblSPCopies)
	BEGIN
		DELETE	#BKPXT
		FROM	#BKPXT B
				LEFT OUTER JOIN @tblSPCopies T
			ON	B.archGrp = T.archGroupId OR B.logArchGrp = T.archGroupId OR (@AllSPCopiesSelected > 0 AND B.archGrp <= 1 AND B.logArchGrp <= 1)
		WHERE	T.archGroupId IS NULL
	END
END
ELSE IF @rptType!= 7795
	  DELETE FROM #BKPXT WHERE appId IN (SELECT componentNameId FROM APP_subclientProp WITH (READUNCOMMITTED) WHERE  attrName = 'SILO Copy ID' AND attrVal <> '0')
--if EDC Discovery Report, delete other backup jobs and vice versa.
IF @rptType = 8006
DELETE FROM #BKPXT WHERE appType <> 127
ELSE
DELETE FROM #BKPXT WHERE appType = 127
UPDATE	#BKPXT
SET		jobDescription = J.jobDescription, xmlJobInfo = J.xmlJobInfo
FROM	JMJobStats J WITH (READUNCOMMITTED)
WHERE	#BKPXT.jobId = J.jobId AND #BKPXT.ccId = J.commCellId AND (J.jobDescription <> '' OR J.xmlJobInfo <> '')
IF @jobDesc not like N''
BEGIN
	SET @jobDesc = N'%' + @jobDesc + N'%'
	DELETE #BKPXT
	FROM #BKPXT
	WHERE jobDescription NOT LIKE @jobDesc OR jobDescription IS NULL
END
UPDATE	#BKPXT
SET		snapJobStatus= CASE WHEN (S.disabled =0 OR S.materializationStatus =100) THEN S.materializationStatus ELSE 0 END
FROM	#BKPXT T, JMJobSnapshotStats S WITH (READUNCOMMITTED)
WHERE	S.commcellId = T.ccId and S.jobid = T.jobid and T.opType IN(59,65)
IF @bkpCopyJobsOnly > 0
	DELETE T
	FROM #BKPXT T
		JOIN JMJobStats S
			on T.jobId = S.jobId
	WHERE T.optype <> 60 	-- 60->SNAPTOTAPE
ELSE
IF @rptType!= 7795 AND @bkpCopyJobs = 0
	DELETE T
	FROM #BKPXT T
		JOIN JMJobStats S
			on T.jobId = S.jobId
	WHERE T.optype = 60 	-- 60->SNAPTOTAPE
			OR ( T.opType = 59 AND S.subOpType = 96 ) -- 59->SnapBackup, 96->Deferred Catalog
IF @includeDisabledActivityClients = 0
BEGIN
	DELETE	S FROM #BKPXT S INNER JOIN JMJobAction J WITH (NOLOCK)
		ON	J.opType IN (4, 76) AND J.action = 1
		AND J.clientId = S.clId AND J.appType IN (S.appType, 0)
	DELETE	S FROM #BKPXT S
			INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
			INNER JOIN JMJobAction J WITH (NOLOCK)
		ON	J.opType IN (4, 76) AND J.action = 1
		AND J.instanceId = A.instance AND J.instanceId > 1
	DELETE	S FROM #BKPXT S INNER JOIN JMJobAction J WITH (NOLOCK)
		ON	J.opType IN (4, 76) AND J.action = 1
		AND J.appId = S.AppId
	DELETE	S FROM #BKPXT S
			INNER JOIN (
				SELECT	componentNameId AS appId, CAST(attrVal AS INT) AS subclientPolicyAppId
				FROM	APP_SubClientProp WITH (NOLOCK)
				WHERE	attrName = 'Associated subclient Policy' AND modified = 0
			) T ON S.appId = T.appId
			INNER JOIN JMJobAction J WITH (NOLOCK)
				ON	J.opType IN (4, 76) AND J.action = 1
				AND J.appId = T.subclientPolicyAppId
	DELETE	S FROM #BKPXT S
			INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON S.clId = CGA.clientId
			INNER JOIN JMJobAction J WITH (NOLOCK) ON CGA.clientGroupId = J.clientGroupId
				AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
				AND J.opType IN (4, 76) AND J.action = 1
END
IF @includeDeconfiguredClients = 0
	DELETE T
	FROM #BKPXT T
	-- status CV_STATUS_UNINSTALLED=2, CV_STATUS_DELETED=4,
	-- specialClientFlags 0X2   SAME_COMMCELL_GALAXY_PACKAGES_ABSENT, 0X8   NO_COUNT_IN_SCALE_LIMITS  (Virtual server, add-in,  miniSRM)
	WHERE T.clId in (select id from APP_Client where (status&6)>0 and (specialClientFlags&10)!=10)
--Include Data Transfer Size When Deduplication is Used from Client to MA
--IF @transferredDataSize > 0
--BEGIN
--	IF object_id('temp.dbo.#tempTransferredDataSize') is not null DROP TABLE #tempTransferredDataSize
--	CREATE TABLE #tempTransferredDataSize(
--	[jobId] int NOT NULL, [appId] int NOT NULL, commCellId int NOT NULL, [archGroupId] int NOT NULL, [archGroupCopyId] int NOT NULL, [transDataSize] bigint NOT NULL)
--
--	INSERT INTO #tempTransferredDataSize
--	SELECT jobId, appId, commCellId, archGrpId, archGrpCopyId, transDataSize
--	FROM JMJobDataStats
--	WHERE dataType = 1
--
--	UPDATE #BKPXT
--	SET transferredDataSize =
--	    (CASE
--	     WHEN transDataSize <> 0 THEN transDataSize
--		 WHEN compSize <> 0  THEN compSize
--		 ELSE uncompSize END)
--	FROM #BKPXT T JOIN #tempTransferredDataSize D ON
--	     T.jobId = D.jobId AND T.archGrp = D.archGroupId AND T.appId = D.appId AND T.ccId = D.commCellId
--END
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND (@clOpt <= 0 OR @runtimeSecurityCheck = 1)
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2013 , 0, '#rptUserObjects'	-- SUB_CLIENT_ITEM = to get SUB_CLIENT_ITEM it will be having client/appType/instance/backupSet/subclient/
	CREATE INDEX #rptUserObjects_idx ON #rptUserObjects (clientId, appTypeId, instanceId, backupsetId, subClientId)
	delete #rptUserObjects
	WHERE clientGroupId <> 0 or commcellId <> 2
	delete #BKPXT
	FROM #BKPXT, APP_Application WITH (READUNCOMMITTED)
	WHERE appId=id AND
		0 = (	select	count(*) from #rptUserObjects
			where	clientId IN (0, clId) AND
				appTypeId IN (0,appType) AND
				instanceId IN (0,instance) AND
				backupsetId IN (0,backupSet) AND
				subClientId IN (0,appId))
	DROP TABLE #rptUserObjects
END
IF @filterOnSubClientDesc <> 0
BEGIN
	DECLARE @compareString nvarchar(4000)
	SET @compareString = N'%' + @SubClientDescriptionFilter + N'%'
	DELETE	#BKPXT
	FROM	#BKPXT A LEFT OUTER JOIN
			(SELECT componentNameId, attrVal FROM APP_SubClientProp WITH (READUNCOMMITTED)
			WHERE	attrName = 'User Description' AND modified = 0) B
		ON	A.appId = B.componentNameId
	WHERE	A.appId > 0
	AND		ISNULL(B.attrVal, N'') NOT LIKE @compareString
END
--Delete defualtDummyBackupSet rows for DB2 agents as this backupSet is created for every instance but it's not visible on GUI
--MR: 122747
DELETE #BKPXT
FROM	#BKPXT A LEFT OUTER JOIN
		(SELECT App.id AppId FROM APP_BackupSetName B INNER JOIN APP_Application App
							 ON B.id = App.backupSet
							 WHERE appTypeId IN  (3,22,37,61,62,79,80,103) AND (B.status & 16) = 16
		) Sub
	ON A.appId = Sub.AppId
WHERE A.jobId <= 0 AND Sub.AppId IS NOT NULL
--udpate scheduleName
UPDATE	#BKPXT
SET		scheduleName = S.subTaskName
FROM	#BKPXT B
		JOIN TM_SubTask S
			ON B.subtaskid= S.subtaskid
--update value of sizeonMedia
-- use primary copy size first
CREATE TABLE #JobSizeOnMedia (jobId INT, commCellId INT, sizeOnMedia BIGINT)
INSERT	INTO #JobSizeOnMedia (JobId, commcellId, sizeOnMedia)
SELECT	S.jobId, S.commcellId, SUM(S.sizeOnMedia)
FROM	JMJobDataStats S WITH (READUNCOMMITTED)
		INNER JOIN #BKPXT B ON S.commcellId = B.ccid and S.jobid = B.jobid
		INNER JOIN archGroup AG WITH (NOLOCK) ON S.archGrpId = AG.id
		and S.archGrpCopyId = AG.defaultCopy
GROUP BY S.jobId, S.commcellId
IF	EXISTS (SELECT * FROM #BKPXT WHERE optype = 60)
	INSERT INTO #JobSizeOnMedia (JobId, commcellId, sizeOnMedia)
	SELECT	B.jobId, S.commcellId, SUM(S.sizeOnMedia)
	FROM	JMJobDataStats S WITH (READUNCOMMITTED)
			INNER JOIN #BKPXT B ON S.commcellId = B.ccid and S.jobid = B.snapJobId
			INNER JOIN archGroup AG WITH (NOLOCK) ON S.archGrpId = AG.id
			and S.archGrpCopyId = AG.defaultCopy
	GROUP BY B.jobId, S.commcellId
UPDATE	B SET sizeOnMedia = S.sizeOnMedia
FROM	#BKPXT B INNER JOIN #JobSizeOnMedia S
	ON 	S.commcellId = B.ccid and S.jobid = B.jobid
DELETE FROM #JobSizeOnMedia
INSERT	INTO #JobSizeOnMedia (JobId, commcellId, sizeOnMedia)
SELECT	T.jobid, T.commcellId, MAX(T.sizeOnMedia)
FROM	(SELECT	S.jobid, S.commcellId, S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
		FROM	JMJobDataStats S WITH (READUNCOMMITTED), #BKPXT B
		WHERE	S.commcellId = B.ccid and S.jobid = B.jobid and S.AuxCopyJobId = 0 AND B.sizeOnMedia = 0
		GROUP BY S.jobid, S.commcellId, S.archGrpCopyId) AS T
GROUP BY T.jobid, T.commcellId
UPDATE	B
SET		sizeOnMedia = J.sizeOnMedia
FROM	#BKPXT B INNER JOIN #JobSizeOnMedia J ON B.jobId = J.jobId AND B.ccid = J.commcellId AND  B.sizeOnMedia = 0
UPDATE #BKPXT
SET sizeOnMedia = BS.totalBackupSize
FROM JMBKPSTATS BS
		JOIN #BKPXT T
			ON BS.JOBID = T.JOBID AND BS.commCellId = T.ccId
WHERE T.sizeOnMedia = 0
--Parent Job size for VM Jobs
update #BKPXT
set sizeOnMedia = JO.attributeValueInt
from #BKPXT BKP
INNER JOIN JMJobDataLink JL ON JL.parentJobId = BKP.jobId and BKP.appType = 106 and BKP.ccId = JL.commCellId and BKP.blevel <> 64 --SYNTH_FULL
INNER JOIN JMJobOptions as JO ON JO.jobId = BKP.jobId and JO.commCellId = BKP.ccId and JO.attributeId = 73 --JM_JOB_SIZE_ON_MEDIA_NAME
--Stub Size
UPDATE	#BKPXT
SET		stubSize = attributeValueInt
FROM	#BKPXT B INNER JOIN JMJobOptions J ON B.jobId = J.jobId AND B.ccId = J.commCellId
WHERE	attributeName = 'stub size'
DELETE FROM #JobSizeOnMedia
INSERT	INTO #JobSizeOnMedia (JobId, commcellId, sizeOnMedia)
SELECT	V1.jobId, V1.commCellId, SUM(CAST(V1.attrVal AS BIGINT))
FROM	APP_VMProp V1
		INNER JOIN APP_VMProp V2
			ON V1.jobId = V2.jobId AND V1.commCellId = V2.commCellId AND V1.VMClientId = V2.VMClientId
WHERE	V1.attrName = 'vmGuestSize' AND V2.attrName = 'vmIsArchivedByCurrJob' AND V2.attrVal = '1'
GROUP BY V1.jobId, V1.commCellId
UPDATE	#BKPXT
SET		stubSize = J.sizeOnMedia
FROM	#BKPXT T
		INNER JOIN #JobSizeOnMedia J ON T.jobId = J.jobId AND T.ccId = J.commCellId
WHERE	T.appType = 106
DROP TABLE #JobSizeOnMedia
-- Update all Windows app types to CV_APPTYPE_WINDOWS_FILESYSTEM. MR:62562
-- if we do not do this we end up showing the aggregations several times for the same app type name in summary of the report.
UPDATE	#BKPXT
SET		appType = 33
WHERE	appType in (1, 11, 34, 42, 43)
-- We may not need the above statement if all the clients registered to this CS are 10.0 or greater.
UPDATE #BKPXT
SET objects = V1.passedVMs,
sFl = 0, bFl = V1.failedVMs
FROM #BKPXT B1
INNER JOIN (SELECT sum(case when attrval in (0,3) then 1 else 0 end) AS passedVMs,
sum( case when attrval =1 then 1 else 0 end ) AS failedVMs,
jobId, commcellId FROM APP_VMProp WITH (READUNCOMMITTED)
WHERE attrName = 'vmStatus'
GROUP BY jobId, commcellId) AS V1
ON B1.jobId = V1.jobId AND B1.ccId = V1.commcellId
-- UPDATE HERE THE FAILURE REASON NO NEED TO BE HAVING IN OTHER PLACE
UPDATE T
SET T.failR = dbo.RptGetFailureReasonErrorCodeLink(T.failIds, @locid, @isHtml, @skipErrorCodeLink, clId)
FROM #BKPXT T
WHERE T.failIds <> ''
IF @formatId <> 4 AND @formatId <> 14
BEGIN
 	IF @order <> 18 --CLIENT_GROUP
 	BEGIN
IF @rptType <> 7744
		BEGIN
 			INSERT INTO #BKPXF
 			SELECT 0,0,0,0,0,0,0,0,ccId,clId,(select name from APP_Client WITH (READUNCOMMITTED) where id=clId),
 				appType,(select name from APP_iDAType WITH (READUNCOMMITTED) where type=appType),
 				instance,(select name from APP_InstanceName WITH (READUNCOMMITTED) where id=instance),
 				backupSet,(select name from APP_BackupSetName WITH (READUNCOMMITTED) where id=backupSet),
 				A.id,subClientName,jobId,0, N'',
 				bLevel,status,state,duration,startT,endT,(case cPhase when 0 then '' else
 				(select name from JMPhase P WITH (READUNCOMMITTED), JMOpTable O  WITH (READUNCOMMITTED) where O.appTypeType=appType and O.operation=optype and
 				P.opTableId=O.id and P.phase=cPhase) end),objects,uncompSize,bTime,initF,sFl,sFd,bFl,bFd,0,0,options,attributes,userName,
 				archGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=archGrp),''),logArchGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=logArchGrp),''),0,0,0,'',wst,wet,optype,0,scanType,failError,cIdx,compSize,bkpSize,percChange,0,0,0,snapJobId,snapJobStatus,dataStatus,agedTime,transferredDataSize, scheduleName, sizeOnMedia, 0, stubSize, 0, 0, '',failIds,'','',failR,
 				dbo.JMGetLocalizedMessageMaxFunc(@locid,scanChangeReason), xmlJobInfo , jobDescription, N'', N'', N'', N'', N'',N'',NULL,NULL,NULL,N'','',0,0,0,
                (select displayName from APP_Client WITH (READUNCOMMITTED) where id=clId)
 			FROM #BKPXT AS B
				INNER JOIN APP_Application AS A ON appId = id
WHERE (@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0
		END
IF @rptType = 7744
		BEGIN
 			INSERT INTO #BKPXF
 			SELECT 0,0,0,0,0,0,0,0,ccId,clId,(select name from APP_Client WITH (READUNCOMMITTED) where id=clId),
 				appType,
 				(select name from APP_iDAType WITH (READUNCOMMITTED) where type = appType),
 				ISNULL(instance,0),ISNULL((select name from APP_InstanceName WITH (READUNCOMMITTED) where id=instance), ''),
 				ISNULL(backupSet,0),ISNULL((select name from APP_BackupSetName WITH (READUNCOMMITTED) where id=backupSet), ''),
 				ISNULL(APP_Application.id,0),ISNULL(subClientName, 'N/A'),jobId, 0, N'',
 				bLevel,status,state,duration,startT,endT,(case cPhase when 0 then '' else
 				(select name from JMPhase P WITH (READUNCOMMITTED), JMOpTable O  WITH (READUNCOMMITTED) where O.appTypeType=appType and O.operation=optype and
 				P.opTableId=O.id and P.phase=cPhase) end),objects,uncompSize,bTime,initF,sFl,sFd,bFl,bFd,0,0,options,attributes,userName,
 				archGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=archGrp),''),logArchGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=logArchGrp),''),0,0,0,'',wst,wet,optype,0,scanType,failError,cIdx,compSize,bkpSize,percChange,0,0,0,snapJobId,snapJobStatus,dataStatus,agedTime,transferredDataSize, scheduleName, sizeOnMedia, 0, stubSize, 0, 0, '',failIds,'','',failR,
 				dbo.JMGetLocalizedMessageMaxFunc(@locid,scanChangeReason), xmlJobInfo , jobDescription, N'', N'', N'', N'', N'', N'', NULL,NULL,NULL,N'','',0,0,0,
                (select displayName from APP_Client WITH (READUNCOMMITTED) where id=clId)
 			FROM #BKPXT AS B LEFT OUTER JOIN APP_Application WITH (READUNCOMMITTED)
  			ON appId=id
		END
 	END
  	IF @order = 18 --CLIENT_GROUP
  	BEGIN
IF @rptType <> 7744
		BEGIN
 			INSERT INTO #BKPXF
 			SELECT 0,0,0,0,0,0,0,0,ccId,clId,(select name from APP_Client WITH (READUNCOMMITTED) where id=clId),
 				appType,(select name from APP_iDAType WITH (READUNCOMMITTED) where type=appType),
 				instance,(select name from APP_InstanceName WITH (READUNCOMMITTED) where id=instance),
 				backupSet,(select name from APP_BackupSetName WITH (READUNCOMMITTED) where id=backupSet),
 				A.id,subClientName,jobId, ISNULL(CGA.clientGroupId, -1),
 				ISNULL((SELECT name FROM APP_ClientGroup WHERE id = CGA.clientGroupId), ''),
 				bLevel,status,state,duration,startT,endT,(case cPhase when 0 then '' else
 				(select name from JMPhase P WITH (READUNCOMMITTED), JMOpTable O  WITH (READUNCOMMITTED) where O.appTypeType=appType and O.operation=optype and
 				P.opTableId=O.id and P.phase=cPhase) end),objects,uncompSize,bTime,initF,sFl,sFd,bFl,bFd,0,0,options,attributes,userName,
 				archGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=archGrp),''),logArchGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=logArchGrp),''),0,0,0,'',wst,wet,optype,0,scanType,failError,cIdx,compSize,bkpSize,percChange,0,0,0,snapJobId,snapJobStatus,dataStatus,agedTime,transferredDataSize, scheduleName, sizeOnMedia, 0, stubSize, 0, 0, '',failIds,'','',failR,
 				dbo.JMGetLocalizedMessageMaxFunc(@locid,scanChangeReason), xmlJobInfo , jobDescription, N'', N'', N'', N'', N'', N'', NULL,NULL,NULL,N'','',0,0,0,
                (select displayName from APP_Client WITH (READUNCOMMITTED) where id=clId)
 			FROM #BKPXT AS B
  					INNER JOIN APP_Application AS A ON appId = id
  					LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON clId = CGA.clientId
WHERE (@excludeHiddenSubclients = 1 AND A.subclientStatus & 0x00020 <>0x00020) OR @excludeHiddenSubclients = 0
		END
IF @rptType = 7744
		BEGIN
 			INSERT INTO #BKPXF
 			SELECT 0,0,0,0,0,0,0,0,ccId,clId,(select name from APP_Client WITH (READUNCOMMITTED) where id=clId),
 				appType,
 				(select name from APP_iDAType WITH (READUNCOMMITTED) where type = appType),
 				ISNULL(instance,0),ISNULL((select name from APP_InstanceName WITH (READUNCOMMITTED) where id=instance), ''),
 				ISNULL(backupSet,0),ISNULL((select name from APP_BackupSetName WITH (READUNCOMMITTED) where id=backupSet), ''),
 				ISNULL(APP_Application.id,0),ISNULL(subClientName, 'N/A'),jobId, ISNULL(CGA.clientGroupId, -1),
 				ISNULL((SELECT name FROM APP_ClientGroup WHERE id = CGA.clientGroupId), ''),
 				bLevel,status,state,duration,startT,endT,(case cPhase when 0 then '' else
 				(select name from JMPhase P WITH (READUNCOMMITTED), JMOpTable O  WITH (READUNCOMMITTED) where O.appTypeType=appType and O.operation=optype and
 				P.opTableId=O.id and P.phase=cPhase) end),objects,uncompSize,bTime,initF,sFl,sFd,bFl,bFd,0,0,options,attributes,userName,
 				archGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=archGrp),''),logArchGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=logArchGrp),''),0,0,0,'',wst,wet,optype,0,scanType,failError,cIdx,compSize,bkpSize,percChange,0,0,0,snapJobId,snapJobStatus,dataStatus,agedTime,transferredDataSize, scheduleName, sizeOnMedia, 0, stubSize, 0, 0,'',failIds,'','',failR,
 				dbo.JMGetLocalizedMessageMaxFunc(@locid,scanChangeReason), xmlJobInfo , jobDescription, N'', N'', N'', N'', N'', N'', NULL,NULL,NULL,N'','',0,0,0,
                (select displayName from APP_Client WITH (READUNCOMMITTED) where id=clId)
 			FROM #BKPXT AS B LEFT OUTER JOIN APP_Application WITH (READUNCOMMITTED) ON appId=id
  				LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON clId = CGA.clientId
		END
 	END
	UPDATE B SET TrueUp = 1
	FROM #BKPXF B INNER JOIN JMMisc J
	ON B.jobId = J.jobId AND B.commcellId = J.commCellId AND J.itemType = 38
 	--get MA
 	IF @includeMA > 0 OR EXISTS (SELECT * FROM @tblMA)
	BEGIN
		CREATE TABLE #JobMediaAgents (jobId INT, commCellId INT, copyId INT, mediaAgentId INT, mediaAgentName NVARCHAR(256))
		INSERT	INTO #JobMediaAgents
		SELECT	DISTINCT JR.jobId, JR.commCellId, JR.copyId, JR.ClientId, CL.name
		FROM	JMJobResourceHistory JR
				INNER JOIN #BKPXF B ON JR.jobId = B.jobId AND JR.commCellId = B.commCellId
				INNER JOIN APP_Client CL ON JR.ClientId = CL.id
		ORDER BY JR.jobId, JR.commCellId, CL.name
		DELETE T FROM #JobMediaAgents T
				LEFT OUTER JOIN archGroup AG ON T.copyId IN (AG.defaultCopy, AG.defaultSnapCopy)
		WHERE	AG.id IS NULL
		INSERT	INTO #JobMediaAgents
		SELECT	DISTINCT T.jobId, T.commCellId, DP.CopyId, CL.id, CL.name
		FROM	(SELECT	J.jobId, J.commCellId, J.archGrp
				FROM	#BKPXF J
						LEFT OUTER JOIN #JobMediaAgents M ON J.jobId = M.jobId AND J.commCellId = M.commCellId
				WHERE	M.jobId IS NULL
				) T
				INNER JOIN archGroup AG ON T.archGrp = AG.id
				INNER JOIN MMDataPath DP ON DP.CopyId IN (AG.defaultCopy, AG.defaultSnapCopy) AND DP.Flag&1 = 1
				INNER JOIN APP_Client CL ON DP.HostClientId = CL.id
		ORDER BY T.jobId, T.commCellId, CL.name
		IF @includeMA > 0
		BEGIN
			CREATE TABLE #JobMAList (jobId INT, commCellId INT, maList NVARCHAR(MAX))
			INSERT	#JobMAList
			SELECT	jobId, commCellId,
					STUFF((SELECT ','+[mediaAgentName] FROM #JobMediaAgents WHERE jobId = T.jobId FOR XML PATH('')), 1, 1, '')
			FROM	(SELECT DISTINCT jobId, commCellId FROM #JobMediaAgents) T
			CREATE INDEX #JobMAList_jobId_commCellId_idx ON #JobMAList (jobId, commCellId)
			UPDATE  B SET MAList = J.maList
			FROM	#BKPXF B INNER JOIN #JobMAList J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
			DROP TABLE #JobMAList
		END
IF @rptType IN (7715, 7758) AND EXISTS (SELECT * FROM @tblMA)
		BEGIN
			DELETE	J FROM #JobMediaAgents J
					LEFT OUTER JOIN @tblMA MA ON J.mediaAgentId = MA.t_id
			WHERE   MA.t_id IS NULL
			DELETE  B FROM #BKPXF B
					LEFT OUTER JOIN #JobMediaAgents J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
			WHERE   J.jobId IS NULL
			DELETE  B FROM #BKPXT B
					LEFT OUTER JOIN #JobMediaAgents J ON B.jobId = J.jobId AND B.ccId = J.commCellId
			WHERE   J.jobId IS NULL
		END
		DROP TABLE #JobMediaAgents
	END
 	UPDATE	#BKPXF
 	SET		archGrpName = Q.name
	FROM	QRPolicy Q WITH (READUNCOMMITTED)
WHERE	#BKPXF.archGrp = Q.id AND #BKPXF.appType IN (47, 50)
 	INSERT INTO #tblBkpStream
 	SELECT T.jobId, sum(unCompBytes), max(writeTime)
 	FROM #BKPXT T, JMJobStreams J	WITH (READUNCOMMITTED)
 	WHERE T.status=0 and T.jobId=J.jobId
 	GROUP BY T.jobId
 	UPDATE #BKPXF
	SET currentS=csize, currentT=ctime FROM #tblBkpStream WHERE cJobId=jobId and status=0
END
DROP TABLE #tblBkpStream
IF EXISTS (SELECT 1 FROM #tblClients)
	INSERT	INTO #ClientGroupsString
	SELECT	t_clId, '', 0, 0, 0
	FROM	#tblClients
ELSE
	INSERT	INTO #ClientGroupsString
	SELECT	DISTINCT client, '', 0, 0, 0
	FROM	#BKPXF
CREATE INDEX #ClientGroupsString_clientId_idx ON #ClientGroupsString (clientId)
EXEC GetClientGroupsString
IF @useCSTime = 0
BEGIN
	UPDATE	C SET timeZoneId = CP.attrVal
	FROM	#ClientGroupsString C
			INNER JOIN APP_ClientProp CP ON C.clientId = CP.componentNameId AND CP.attrName = 'timezone Id' AND CP.modified = 0
	UPDATE	C SET bias = TZ.Bias, dstFlag = TZ.DSTFlag
	FROM	#ClientGroupsString C
			INNER JOIN SchedTimeZone TZ ON C.timezoneId = TZ.TimeZoneID
	UPDATE	J
		SET startT = CASE WHEN ISNULL(J.startT,0) > 0 THEN J.startT+C.bias ELSE 0 END,
			endT   = CASE WHEN ISNULL(J.endT,0) > 0   THEN J.endT+C.bias ELSE 0 END,
			writeStartT = CASE WHEN ISNULL(J.writeStartT,0) > 0 THEN J.writeStartT+C.bias ELSE 0 END,
			writeEndT   = CASE WHEN ISNULL(J.writeEndT,0) > 0   THEN J.writeEndT+C.bias ELSE 0 END
	FROM	#BKPXF J
			INNER JOIN #ClientGroupsString C ON J.client = C.clientId
	UPDATE	J SET startT += (D.DSTBias - S.DSTBias)
	FROM	#BKPXF J
			INNER JOIN #ClientGroupsString C ON J.client = C.clientId AND C.dstFlag = 1
			INNER JOIN SchedTimeZoneDates D ON C.timezoneId = D.TimeZoneID  AND DATEADD(SS, J.startT, '1970-01-01') BETWEEN D.DSTDate AND D.STDDate
			INNER JOIN SchedTimeZoneDates S ON S.TimeZoneID = @csTimeZoneId AND DATEADD(SS, J.startT, '1970-01-01') BETWEEN S.DSTDate AND S.STDDate
	WHERE	J.jobId > 0
	UPDATE	J SET endT += (D.DSTBias - S.DSTBias)
	FROM	#BKPXF J
			INNER JOIN #ClientGroupsString C ON J.client = C.clientId AND C.dstFlag = 1
			INNER JOIN SchedTimeZoneDates D ON C.timezoneId = D.TimeZoneID  AND DATEADD(SS, J.endT, '1970-01-01') BETWEEN D.DSTDate AND D.STDDate
			INNER JOIN SchedTimeZoneDates S ON S.TimeZoneID = @csTimeZoneId AND DATEADD(SS, J.endT, '1970-01-01') BETWEEN S.DSTDate AND S.STDDate
	WHERE	J.jobId > 0
	UPDATE	J SET writeStartT += (D.DSTBias - S.DSTBias)
	FROM	#BKPXF J
			INNER JOIN #ClientGroupsString C ON J.client = C.clientId AND C.dstFlag = 1
			INNER JOIN SchedTimeZoneDates D ON C.timezoneId = D.TimeZoneID  AND DATEADD(SS, J.writeStartT, '1970-01-01') BETWEEN D.DSTDate AND D.STDDate
			INNER JOIN SchedTimeZoneDates S ON S.TimeZoneID = @csTimeZoneId AND DATEADD(SS, J.writeStartT, '1970-01-01') BETWEEN S.DSTDate AND S.STDDate
	WHERE	J.jobId > 0
	UPDATE	J SET writeEndT += (D.DSTBias - S.DSTBias)
	FROM	#BKPXF J
			INNER JOIN #ClientGroupsString C ON J.client = C.clientId AND C.dstFlag = 1
			INNER JOIN SchedTimeZoneDates D ON C.timezoneId = D.TimeZoneID  AND DATEADD(SS, J.writeEndT, '1970-01-01') BETWEEN D.DSTDate AND D.STDDate
			INNER JOIN SchedTimeZoneDates S ON S.TimeZoneID = @csTimeZoneId AND DATEADD(SS, J.writeEndT, '1970-01-01') BETWEEN S.DSTDate AND S.STDDate
	WHERE	J.jobId > 0
	UPDATE	#BKPXF SET startT -= @csBias, endT -= @csBias, writeStartT -= @csBias, writeEndT -= @csBias
END
---------
IF @basicRetn > 0 OR @allRetn >0 OR @ExtendedRetn > 0 OR @ManualRetn>0
BEGIN
INSERT INTO #tempJobRetention
SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
			(case when J.AppType in (SELECT appTypeId FROM APP_IDATypeHandlingInfo WITH (NOLOCK) WHERE isDMAppType = 1)
				 then A.archiverRetDays else A.retentionDays end),
			B.retentionFlags, 0,
			B.manualRetentionEndTime, B.disabled & 2
FROM	JMJobDataStats B WITH (NOLOCK), #BKPXF J,
			(SELECT AR.copyId,
					(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays,
					(case when AR.archiverRetDays < 0 then @MAXINT else AR.archiverRetDays end) AS archiverRetDays
			FROM	archAgingRule AR WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
			WHERE	AR.copyId = AGC.id ) A
WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
		AND B.status IN (2, 100)
		AND A.copyId = B.archGrpCopyId
		AND J.subclient = B.appId
UPDATE	#tempJobRetention
SET		extRetentionFlags = (
			case
			when extRetentionFlags & 64 <> 0 then 64
			when extRetentionFlags & 32 <> 0 then 32
			when extRetentionFlags & 16 <> 0 then 16
			when extRetentionFlags & 8 <> 0 then 8
			when extRetentionFlags & 4 <> 0 then 4
			when extRetentionFlags & 2 <> 0 then 2
			end)
WHERE	extRetentionFlags <> 0
UPDATE	#tempJobRetention
SET		extRetentionDays = b.retentionDays
FROM	#tempJobRetention a,
			(SELECT AR.copyId, AR.retentionRule,
			(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays
			FROM	archAgingRuleExtended AR WITH (READUNCOMMITTED), archGroupCopy AGC WITH (NOLOCK)
			WHERE	AR.copyId = AGC.id ) b
WHERE	b.copyId = a.archGrpCopyId AND b.retentionRule = a.extRetentionFlags
--40000000 =1073741824 this is unused value for extRetentionFlags using that
declare @manualflagtmp int = 1073741824
UPDATE	#tempJobRetention
SET		extRetentionFlags = extRetentionFlags|@manualflagtmp
WHERE	manualRetaided >0  and (@allRetn >0  OR @ManualRetn>0)
INSERT INTO #maxJobRetention
SELECT	jobId, commCellId, MAX(extRetentionFlags), MAX(retentionDays), MAX(extRetentionDays), MAX(manualRetentionEndTime)
FROM	#tempJobRetention
GROUP BY jobId, commCellId
DROP TABLE #tempJobRetention
UPDATE	#BKPXF
SET		extRetentionFlags = JR.extRetentionFlags,
			retentionDays = (case when JR.extRetentionDays > JR.retentionDays then JR.extRetentionDays else JR.retentionDays end),
			pinJobEndTime = JR.manualRetentionEndTime
FROM	#BKPXF JS, #maxJobRetention JR
WHERE	JR.jobId = JS.jobId AND JR.commCellId = JS.commCellId
DROP TABLE #maxJobRetention
-- delete only if it is unchecked
	IF ( @allRetn =0)
	BEGIN
	-- delete basic retention jobs if it is unchecked
		IF @basicRetn =0
		BEGIN
				DELETE FROM #BKPXT
				WHERE jobid IN(select Jobid FROM #BKPXF
				WHERE extRetentionFlags = 0 )
				DELETE FROM #BKPXF
				WHERE extRetentionFlags = 0
		END
	-- delete extended retention jobs if  it is unchecked
		IF @extendedRetn =0
		BEGIN
				DELETE FROM #BKPXT
				WHERE jobid IN (select Jobid FROM #BKPXF
				WHERE extRetentionFlags >0  and (extRetentionFlags&@manualflagtmp)!=@manualflagtmp)
				DELETE FROM #BKPXF
				WHERE extRetentionFlags >0 and (extRetentionFlags&@manualflagtmp)!=@manualflagtmp
		END
	-- delete manual retention jobs if  it is unchecked
		IF @ManualRetn =0
		BEGIN
				DELETE FROM #BKPXT
				WHERE jobid IN (select Jobid FROM #BKPXF
				WHERE extRetentionFlags >0  and (extRetentionFlags&@manualflagtmp)=@manualflagtmp)
				DELETE FROM #BKPXF
				WHERE extRetentionFlags >0 and (extRetentionFlags&@manualflagtmp)=@manualflagtmp
		END
	END
END
-- cellNum
UPDATE #BKPXF
SET cellName =C.aliasName
FROM #BKPXF JS,APP_Commcell C WITH (READUNCOMMITTED)
WHERE JS.commCellId = C.Id
--suboptype
UPDATE #BKPXF
SET subOptype =S.subOpType
FROM #BKPXF JS, JMJobStats S WITH (READUNCOMMITTED)
WHERE JS.commCellId = S.commCellId AND JS.jobId = S.jobId AND S.subOpType > 0
UPDATE	#BKPXF
SET		isCatelogJob = 1
FROM	#BKPXF B, JMJobSnapshotStats S
WHERE	B.jobId = S.jobId AND B.commcellId = S.commcellId
	AND	S.flags & 1 <> 0 --CVA_JOB_PICKED_FOR_DELAYED_CATALOG
UPDATE	#BKPXF
SET		isCatelogJob = 1
FROM	#BKPXF B, archMaterializeSnapshotProp A
WHERE	B.archGrp = A.archGroupId AND A.enabled = 2 --CVA_ARCHMATERIALIZE_DELAYED_CATALOG_ENABLED
	AND B.isCatelogJob = 0
---include description at various level
IF  @includeClientDesc> 0
BEGIN
	UPDATE	#BKPXF
	SET		clientDesc = clientDescription
	FROM	#BKPXF T
			INNER JOIN APP_Client CL WITH (READUNCOMMITTED) ON T.client = CL.id
	WHERE	T.client > 0 AND ISNULL(clientDescription, N'') <> N''
	UPDATE	#BKPXF
	SET		idaDesc = P.attrVal
	FROM	#BKPXF T
			INNER JOIN APP_IDAName I WITH (READUNCOMMITTED) ON T.client = I.clientId AND T.appType = I.appTypeId
			INNER JOIN APP_IDAProp P WITH (READUNCOMMITTED) ON I.id = P.componentNameId
	WHERE	T.client > 0 AND P.attrName = 'IDA Description' AND ISNULL(P.attrVal, N'') <> N'' AND P.modified = 0
	UPDATE	#BKPXF
	SET		bkpSetDesc = P.attrVal
	FROM	#BKPXF T INNER JOIN APP_BackupSetProp P WITH (READUNCOMMITTED) ON T.backupSet = P.componentNameId
	WHERE	T.backupSet > 0 AND P.attrName = 'User Description' AND ISNULL(P.attrVal, N'') <> N'' AND P.modified = 0
	UPDATE	#BKPXF
	SET		instanceDesc = P.attrVal
	FROM	#BKPXF T INNER JOIN APP_InstanceProp P WITH (READUNCOMMITTED) ON T.instance = P.componentNameId
	WHERE	T.instance > 0 AND P.attrName = 'User Description' AND ISNULL(P.attrVal, N'') <> N'' AND P.modified = 0
	UPDATE	#BKPXF
	SET		subclientDesc = P.attrVal
	FROM	#BKPXF T INNER JOIN APP_SubClientProp P WITH (READUNCOMMITTED) ON T.subClient = P.componentNameId
	WHERE	T.subClient > 0 AND P.attrName = 'User Description' AND ISNULL(P.attrVal, N'') <> N'' AND P.modified = 0
END
ELSE
-- include subclient description
IF @filterOnSubClientDesc <> 0
	UPDATE	#BKPXF
	SET		subclientDesc = P.attrVal
	FROM	#BKPXF T INNER JOIN APP_SubClientProp P WITH (READUNCOMMITTED) ON T.subClient = P.componentNameId
	WHERE	T.subClient > 0 AND P.attrName = 'User Description' AND ISNULL(P.attrVal, N'') <> N'' AND P.modified = 0
-- Update all Windows app types to CV_APPTYPE_WINDOWS_FILESYSTEM. MR:62562
UPDATE	#BKPXF
SET		appType = 33, appTypeName = 'Windows File System'
WHERE	appType in (1, 11, 34, 42, 43)
-- We may not need the above statement if all the clients registered to this CS are 10.0 or greater.
UPDATE	#BKPXF
SET		bkpAttributesEx = I.bkpAttributesEx
FROM	#BKPXF T INNER JOIN JMBkpJobInfo I
	ON	T.jobId = I.jobId AND T.commCellId = I.commCellId
UPDATE	#BKPXF
SET		bkpAttributesEx = B.bkpAttributesEx
FROM	#BKPXF T INNER JOIN JMBkpStats B
	ON	T.jobId = B.jobId AND T.commCellId = B.commCellId
----------
IF(@noofMostfreqError>0)
BEGIN
DECLARE @spError		integer = 0
DECLARE	@outXmlResp		XML	=NULL
 EXEC @spError = RptGetTopMostJobErrors @i_jobId,@outXmlResp OUTPUT
END
INSERT INTO #BKPXF (type,tot,suc,partSuc,run,killed,noRun,noBkp,commcellId,startT,endT,uncompSize,objects,totalFl,totalFd,bkpSize,compSize,sizeOnMedia,stubSize,state,bTime,topNXml,skipped,committed)
SELECT 2,
	count(*),
	(select count(*) from #BKPXT where status=1),
	(select count(*) from #BKPXT where status=3),
(select count(*) from #BKPXT where status=0 and state in (1,4,9,100)),  --Active jobs: RUNNING , COMPLETED, COMPLETEDSUCCESS
	(select count(*) from #BKPXT where status=4),
	(select count(*) from #BKPXT where status=-1 AND failError>0),
	(select count(*) from #BKPXT where bLevel=-1 and state=-1 and status=-1),
	CASE WHEN count(*) <= @MaxNumOfRows THEN count(*) ELSE @MaxNumOfRows END,
	isnull(min(startT),0),isnull(max(endT),0),sum(uncompSize),sum(objects),sum(sFl+bFl),sum(sFd+bFd),sum(bkpSize), sum(compSize), sum(sizeOnMedia), sum(stubSize),
(select count(*) from #BKPXT where status=0 and state NOT in (1,4,9,100)),
	(select count(*) from #BKPXT where status=14)
	,@outXmlResp,
	(select count(*) from #BKPXT where status=-2 AND failError = 12),	--SCHEDSKIPPEDHOLIDAY
	(select count(*) from #BKPXT where status=16)
FROM #BKPXT WHERE jobId>0
SET @MaxNumOfRows += 1
UPDATE	#BKPXF
SET		proxyHostName = SP.attrval
FROM	(SELECT	componentNameId, attrval
		FROM	APP_subclientProp WITH (READUNCOMMITTED)
		WHERE	attrType = 1 AND attrName = 'Proxy Host' and modified = 0) SP
WHERE	#BKPXF.subclient = SP.componentNameId
UPDATE	#BKPXF
SET		#BKPXF.clientGroups = assoc.ClientGroups
FROM	#ClientGroupsString assoc
WHERE	#BKPXF.client = assoc.ClientId
DECLARE	@csClientId	INT
SELECT	TOP 1 @csClientId = ClientID From APP_CommCell WHERE id = 2
--reference copy
UPDATE	J SET referenceCopyCriteria = T.attrVal
FROM	#BKPXF J INNER JOIN
		(SELECT B.jobId, B.commcellId, B.subclient, S.attrVal, ROW_NUMBER() OVER (PARTITION BY B.jobId, B.commcellId, B.subclient ORDER BY created) AS rowNo
		FROM	#BKPXF B INNER JOIN APP_SubClientProp S
			 ON B.subClient = S.componentNameId AND B.startT >= S.created AND (B.startT < S.modified OR S.modified = 0) AND S.attrName = 'Reference Copy Content'
		) T ON J.jobId = T.jobId AND J.commcellId = T.commcellId AND J.subClient = T.subClient
WHERE	T.rowNo = 1 AND J.bLevel IN (1,2)
UPDATE	B SET referenceCopyAssociation = CONVERT(VARCHAR(MAX), xmlJobInfo)
FROM	#BKPXF B INNER JOIN JMReferenceCopyJobStats R ON B.jobId = R.jobId AND B.commCellId = R.commCellId AND B.subClient = R.refAppId
--end reference copy
--System State backup skip reason
UPDATE	#BKPXF
SET		sysStateSkipReason = 1
FROM	#BKPXF B, APP_Application A, APP_SubClientProp SCP
WHERE	(B.attributes & 0x100000) = 0x100000 --JMBKP_WITH_SYSTEM_STATE
	AND	B.bLevel <> 1 --Not Full
	AND A.id = B.subClient
	AND A.id = SCP.componentNameId
	AND SCP.attrName = 'System State on Full Backup Only'
	AND SCP.attrVal = 1
	AND (SCP.created <= B.startT
		AND (SCP.modified = 0 OR SCP.modified > B.startT))
CREATE TABLE #LastJob  (jobId BIGINT, ccId INT, lastJobId BIGINT, appId INT, bkpLevel BIGINT)
INSERT INTO #LastJob SELECT jobId, commcellId, 0, subClient, 0 FROM #BKPXF WHERE jobId <> 0 and sysStateSkipReason = 1
UPDATE	L
	SET lastJobId = ( SELECT MAX(jobId)  FROM JMBkpStats WHERE  commCellId = L.ccId AND appId = L.appId and servStartDate =
					(SELECT MAX(servStartDate) FROM JMBkpStats WHERE  commCellId = L.ccId AND appId = L.appId)
					)
FROM #LastJob L
UPDATE	L
	SET bkpLevel = (SELECT bkpLevel FROM JMBkpStats WHERE jobId = L.lastJobId AND commCellId = L.ccId)
FROM #LastJob L
UPDATE	#BKPXF
SET		sysStateSkipReason = 2
FROM	#BKPXF B, #LastJob L
WHERE	B.jobId = L.jobId
	AND	B.commcellId = L.ccId
	AND B.sysStateSkipReason = 1
	AND	L.bkpLevel = 64 --SYNTHETIC_FULL
drop table #LastJob
-- get laptop owner list
CREATE TABLE #LaptopOwner (clientId INT, ownerName NVARCHAR(255))
CREATE TABLE #LaptopOwnerList (clientId INT, ownerList NVARCHAR(MAX))
INSERT	INTO #LaptopOwner
SELECT	C.id, U.login
FROM	(SELECT DISTINCT client FROM #BKPXF) AS T
		INNER JOIN APP_Client C ON T.client = C.id AND (C.status&0x1000) <> 0
		INNER JOIN sec_getClientOwnersExpandUG O ON O.clientId = C.id
		INNER JOIN UMUsers U ON U.id = O.userId
ORDER BY C.id, U.login
INSERT	#LaptopOwnerList
SELECT	clientId,
		STUFF((SELECT ','+[ownerName] FROM #LaptopOwner WHERE clientId = T.clientId FOR XML PATH('')), 1, 1, '')
FROM	(SELECT DISTINCT clientId FROM #LaptopOwner) T
DROP TABLE #LaptopOwner
CREATE INDEX #LaptopOwnerList_clientId_idx ON #LaptopOwnerList (clientId)
UPDATE  B SET clientOwnersList = J.ownerList
FROM	#BKPXF B INNER JOIN #LaptopOwnerList J ON B.client = J.clientId
--get grouping info
IF @order = 1
BEGIN
	INSERT INTO #tblSummary
	SELECT count(*), appType, isnull(min(startT),0), isnull(max(endT),0), sum(uncompSize), sum(bkpSize), sum(objects), sum(sFl+bFl), sum(sFd+bFd), sum(compSize), sum(sizeOnMedia), sum(stubSize)
	FROM #BKPXT
	WHERE jobId>0
	GROUP BY appType
	INSERT INTO #tblSummary
	SELECT 0, appType, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM #BKPXT
	WHERE jobId=0 AND appType NOT IN (select tid from #tblSummary)
	GROUP BY appType
	INSERT INTO #BKPXF (type,tot,suc,partSuc,run,killed,noRun,noBkp,appType,appTypeName,startT,endT,uncompSize,objects,totalFl,totalFd,bkpSize,compSize,sizeOnMedia,stubSize,state,bTime,skipped,committed)
	SELECT 1,tot,
		(select count(*) from #BKPXT where appType=tid and status=1),
		(select count(*) from #BKPXT where appType=tid and status=3),
(select count(*) from #BKPXT where appType=tid and status=0 and state in (1,4,9,100)),
		(select count(*) from #BKPXT where appType=tid and status=4),
		(select count(*) from #BKPXT where appType=tid and status=-1 AND failError>0),
		(select count(*) from #BKPXT where appType=tid and bLevel=-1 and state=-1 and status=-1),
		tid,(select name from APP_iDAType where type=tid),st,et,ts,obj,fFiles,fFolders, bs,cs,sizeOnMedia,stubSize,
(select count(*) from #BKPXT where appType=tid and status=0 and state NOT in (1,4,9,100)),
		(select count(*) from #BKPXT where appType=tid and status=14),
		(select count(*) from #BKPXT where appType=tid and status=-2 AND failError = 12),			--SCHEDSKIPPEDHOLIDAY
		(select count(*) from #BKPXT where appType=tid and status=16)
	FROM #tblSummary
	SET @MaxNumOfRows += @@ROWCOUNT
	SELECT TOP(@MaxNumOfRows) * FROM #BKPXF ORDER BY type DESC, appTypeName, clientName, jobId DESC
END
ELSE IF @order = 2
BEGIN
	INSERT INTO #tblSummary
	SELECT count(*), clId, isnull(min(startT),0), isnull(max(endT),0), sum(uncompSize), sum(bkpSize), sum(objects), sum(sFl+bFl), sum(sFd+bFd), sum(compSize), sum(sizeOnMedia), sum(stubSize)
	FROM #BKPXT
	WHERE jobId > 0
	GROUP BY clId
	INSERT INTO #tblSummary
	SELECT 0, clId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM #BKPXT
	WHERE jobId = 0 AND clId NOT IN (select tid from #tblSummary)
	GROUP BY clId
    INSERT INTO #BKPXF (type,tot,suc,partSuc,run,killed,noRun,noBkp,client,clientName,startT,endT,uncompSize,objects,totalFl,totalFd,bkpSize,compSize,sizeOnMedia, stubSize,state,bTime,clientOwnersList,clientHostName,skipped,committed,clientDisplayName)
	SELECT 1,tot,
		(select count(*) from #BKPXT where clId=tid and status=1),
		(select count(*) from #BKPXT where clId=tid and status=3),
(select count(*) from #BKPXT where clId=tid and status=0 and state in (1,4,9,100)),
		(select count(*) from #BKPXT where clId=tid and status=4),
		(select count(*) from #BKPXT where clId=tid and status=-1 AND failError>0),
		(select count(*) from #BKPXT where clId=tid and bLevel=-1 and state=-1 and status=-1),
 		tid,CL.name,st,et,ts,obj,fFiles,fFolders,bs,cs,sizeOnMedia,stubSize,
(select count(*) from #BKPXT where clId=tid and status=0 and state NOT in (1,4,9,100)),
 		(select count(*) from #BKPXT where clId=tid and status=14),
		ISNULL((select ownerList from #LaptopOwnerList where clientId=tid), ''),
		CL.net_hostname,
		(select count(*) from #BKPXT where clId=tid and status=-2 AND failError = 12),
		(select count(*) from #BKPXT where clId=tid and status=16),
        CL.displayName
	FROM #tblSummary INNER JOIN APP_Client CL WITH(NOLOCK) ON tid = CL.id
	SET @MaxNumOfRows += @@ROWCOUNT
	SELECT TOP(@MaxNumOfRows) * FROM #BKPXF ORDER BY type DESC, clientName, appTypeName, jobId DESC
END
ELSE IF @order = 18 --RPT_GROUP_BY_OPTION_CLIENT_GROUP
BEGIN
	INSERT INTO #tblSummary
	SELECT count(*), B.clientGroupId, isnull(min(B.startT),0), isnull(max(B.endT),0), sum(B.uncompSize), sum(B.bkpSize), sum(B.objects), sum(B.sFl+B.bFl), sum(B.sFd+B.bFd), sum(B.compSize), sum(B.sizeOnMedia), SUM(stubSize)
FROM (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B
	WHERE jobId > 0
	GROUP BY B.clientGroupId
	INSERT INTO #tblSummary
	SELECT 0, B.clientGroupId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
FROM (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B
	WHERE B.jobId = 0 AND B.clientGroupId NOT IN (select tid from #tblSummary)
	GROUP BY B.clientGroupId
	INSERT INTO #BKPXF (type,tot,suc,partSuc,run,killed,noRun,noBkp,clientGrpId,cgName,startT,endT,uncompSize,objects,totalFl,totalFd,bkpSize,compSize,sizeOnMedia,stubSize,state,bTime,skipped,committed)
	SELECT 1,tot,
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=1),
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=3),
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=0 and B.state in (1,4,9,100)),
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=4),
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=-1 AND B.failError>0),
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.bLevel=-1 and B.state=-1 and B.status=-1),
 		tid,(select ISNULL(name, '') from APP_ClientGroup where id=tid),st,et,ts,obj,fFiles,fFolders,bs,cs,sizeOnMedia,stubSize,
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=0 and B.state NOT in (1,4,9,100)),
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=14),
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=-2 AND B.failError = 12),
(select count(*) from (SELECT B.*, ISNULL(CGA.clientGroupId, -1) AS clientGroupId FROM #BKPXT B LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON B.clId = CGA.clientId) B where B.clientGroupId=tid and B.status=16)
	FROM #tblSummary
	SET @MaxNumOfRows += @@ROWCOUNT
	SELECT TOP(@MaxNumOfRows) * FROM #BKPXF ORDER BY type DESC, cgName, clientName, appTypeName, jobId DESC
END
ELSE IF @order = 4
BEGIN
	declare @isQR integer
set @isQR = (select count(*) from #BKPXT where appType in (47, 50))
	INSERT INTO #tblSummary
	SELECT count(*), case when archGrp > 1 then archGrp when logArchGrp > 1 then logArchGrp else 1 end,
		isnull(min(startT),0), isnull(max(endT),0), sum(uncompSize), sum(bkpSize), sum(objects), sum(sFl+bFl), sum(sFd+bFd), sum(compSize), sum(sizeOnMedia), sum(stubSize)
	FROM #BKPXT
	WHERE jobId>0 AND (archGrp > 1 OR logArchGrp > 1)
	GROUP BY case when archGrp > 1 then archGrp when logArchGrp > 1 then logArchGrp else 1 end
	DECLARE @tblLogArchGrp	TABLE (tot INT, tid INT, st INT, et INT, ts BIGINT, bs BIGINT, obj BIGINT, fFiles BIGINT, fFolders BIGINT, cs BIGINT, sizeOnMedia BIGINT, stubSize BIGINT)
	INSERT INTO @tblLogArchGrp
	SELECT count(*), logArchGrp,
		isnull(min(startT),0), isnull(max(endT),0), sum(uncompSize), sum(bkpSize), sum(objects), sum(sFl+bFl), sum(sFd+bFd), sum(compSize), sum(sizeOnMedia), sum(stubSize)
	FROM #BKPXT
	WHERE jobId>0 AND archGrp > 1 AND logArchGrp > 1 AND archGrp <> logArchGrp
	GROUP BY logArchGrp
	UPDATE #tblSummary
	SET tot = S.tot + T.tot,
		st = case when S.st < T.st then S.st else T.st end,
		et = case when S.et > T.et then S.et else T.et end,
		ts = S.ts + T.ts, bs = S.bs + T.bs, obj = S.obj + T.obj,
		fFiles = S.fFiles + T.fFiles, fFolders = S.fFolders + T.fFolders,
		cs = S.cs + T.cs, sizeOnMedia = S.sizeOnMedia + T.sizeOnMedia,
		stubSize = S.stubSize + T.stubSize
	FROM #tblSummary S, @tblLogArchGrp T
	WHERE S.tid = T.tid
	INSERT INTO #tblSummary
	SELECT *
	FROM @tblLogArchGrp
	WHERE tid NOT IN (select tid from #tblSummary)
	INSERT INTO #tblSummary
	SELECT 0, archGrp, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM #BKPXT
	WHERE jobId=0 AND archGrp NOT IN (select tid from #tblSummary)
	GROUP BY archGrp
	INSERT INTO #BKPXF (type,tot,suc,partSuc,run,killed,noRun,noBkp,startT,endT,uncompSize,archGrp,archGrpName,objects,totalFl,totalFd,bkpSize,compSize,sizeOnMedia,stubSize,state,bTime,skipped,committed)
	SELECT 1,tot,
		(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=1),
		(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=3),
(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=0 and state in (1,4,9,100)),
		(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=4),
		(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=-1 AND failError>0),
		(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and bLevel=-1 and state=-1 and status=-1),
 		st,et,ts,tid,(case when @isQR>0 then (select name from QRPolicy where id=tid)
				else (select name from archGroup where id=tid) end),obj,fFiles,fFolders,bs,cs,sizeOnMedia,stubSize,
(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=0 and state NOT in (1,4,9,100)),
		(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=14),
		(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=-2 AND failError = 12),
		(select count(*) from #BKPXT where (archGrp=tid OR logArchGrp = tid) and status=16)
	FROM #tblSummary
	SET @MaxNumOfRows += @@ROWCOUNT
	SELECT TOP(@MaxNumOfRows) * FROM #BKPXF ORDER BY type DESC, archGrpName, jobId DESC
END
ELSE
BEGIN
	SELECT TOP(@MaxNumOfRows) * FROM #BKPXF ORDER BY type DESC, jobId DESC
END
DROP TABLE #BKPXT
DROP TABLE #BKPXF
DROP TABLE #tblSummary
DROP TABLE #LaptopOwnerList
IF OBJECT_ID('tempdb.dbo.#tblAppIds') IS NOT NULL
	DROP TABLE #tblAppIds
SET ANSI_WARNINGS ON
SET NOCOUNT OFF
GO
--dummy check-in becuase one update on build 52 failed to get built correctly Form (52563).

IF EXISTS (select * from GxQscripts where name = 'RptBkpHistoryInfo')
	delete from GxQscripts where name = 'RptBkpHistoryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpHistoryInfo')
	delete from GXDBVersions where aliasname = 'RptBkpHistoryInfo'
GO

insert into GXDBVersions values(2, 'RptBkpHistoryInfo',  '00010258000200730000', 'RptBkpHistoryInfo', '00010258000200730000')
GO

