

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptBackupScheduledSubclients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptBackupScheduledSubclients.sp,v $ $Id: RptBackupScheduledSubclients.sp,v 1.1.2.4.68.1 2021/01/16 02:13:34 gpattabiraman Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptBackupScheduledSubclients')
BEGIN
	print '>>> Drop Stored Procedure: RptBackupScheduledSubclients <<<'
	drop procedure RptBackupScheduledSubclients
END
IF EXISTS (select * from GxQscripts where name='RptBackupScheduledSubclients')
	delete from GxQscripts where name = 'RptBackupScheduledSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBackupScheduledSubclients')
	delete from GXDBVersions where aliasname = 'RptBackupScheduledSubclients'
GO
print '... Creating Procedure: RptBackupScheduledSubclients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptBackupScheduledSubclients
  @i_dummy INTEGER
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Caller will create table #tblSubclient
-- CREATE TABLE #tblSubclient (ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, BackupScheduled INT)
CREATE TABLE #BackupTask (taskId INT, taskType INT)
INSERT	INTO #BackupTask
SELECT	DISTINCT T.taskId, T.taskType
FROM	TM_SubTask ST WITH (NOLOCK)
	    INNER JOIN TM_Task T WITH (NOLOCK)
			ON T.taskId = ST.taskId AND T.disabled = 0 AND ST.subTaskType = 2
	    INNER JOIN TM_SubTaskOptions STO WITH (NOLOCK)
			ON STO.subTaskId = ST.SubTaskId
AND	STO.optionId = 458405394 AND STO.value IN ('1', '2', '3', '6')
WHERE	T.taskType = 2
	 OR T.taskType = 4 AND T.taskName NOT IN ('System Created for Content Store', 'System Created for DDB subclients')
CREATE TABLE #BackupTaskAsso (TaskId INT, AssocType INT, ClientGroupId INT, ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT)
INSERT	INTO #BackupTaskAsso
SELECT	DISTINCT AE.taskId, AE.assocType, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId
FROM	TM_Associations AE WITH (NOLOCK) -- Use view to get plan level associations
	    INNER JOIN #BackupTask T ON AE.taskId = T.taskId AND AE.exclude = 0
WHERE	(T.taskType = 2 OR T.taskType = 4 AND AE.assocType NOT IN (2, 28))
	AND AE.taskId NOT IN (SELECT DISTINCT taskId FROM TM_AssocFilter WITH (NOLOCK) WHERE filter_type = 2 AND filter_value = 124)
UNION
SELECT	DISTINCT AE.taskId, AE.assocType, AE.clientGroupId, 0, CASE WHEN ISNULL(AF.filter_type, 0) = 1 THEN ISNULL(ATGA.appTypeId, 0) ELSE ISNULL(AF.filter_value, 0) END, 0, 0, 0
FROM	TM_AssocEntity AE WITH (NOLOCK)
	    INNER JOIN #BackupTask T ON AE.taskId = T.taskId AND T.taskType = 4 AND AE.exclude = 0
	    LEFT OUTER JOIN TM_AssocFilter AF WITH (NOLOCK) ON AF.taskId = T.taskId
	    LEFT OUTER JOIN APP_AppTypeGroup ATG WITH (NOLOCK) ON ATG.appTypeGroupId = AF.filter_value AND AF.filter_type = 1
	    LEFT OUTER JOIN APP_AppTypeGroupAssoc ATGA WITH (NOLOCK) ON ATGA.appGroupId = ATG.appTypeGroupId
WHERE	AE.assocType IN (2, 28) AND (ISNULL(AF.filter_type, 0) <> 2 OR ISNULL(AF.filter_value, 0) <> 124)
DROP TABLE #BackupTask
CREATE INDEX #BackupTaskAsso_idx ON #BackupTaskAsso (ClientId, AppTypeId, InstanceId, BackupsetId, AppId)
CREATE TABLE #SubclientTask (TaskId INT, ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT)
INSERT	INTO #SubclientTask
SELECT	T.TaskId, S.ClientId, S.AppTypeId, S.InstanceId, S.BackupsetId, S.AppId
FROM	#tblSubclient S, #BackupTaskAsso T
WHERE	T.ClientId IN (S.ClientId, 0) AND (T.ClientId > 0 OR T.AssocType = 2)
	AND T.AppTypeId IN (S.AppTypeId, 0)
	AND T.InstanceId IN (S.InstanceId, 0)
	AND T.BackupsetId IN (S.BackupsetId, 0)
	AND T.AppId IN (S.AppId, 0)
UNION
SELECT	T.TaskId, S.ClientId, S.AppTypeId, S.InstanceId, S.BackupsetId, S.AppId
FROM	#tblSubclient S
		INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON S.ClientId = CGA.clientId
 		INNER JOIN #BackupTaskAsso T ON CGA.ClientGroupId = T.ClientGroupId AND T.ClientId = 0 AND T.ClientGroupId > 0
WHERE	(T.AppTypeId = 0 OR S.AppTypeId = T.AppTypeId)
DROP TABLE #BackupTaskAsso
DELETE	#SubclientTask
FROM	#SubclientTask S
		INNER JOIN TM_AssocEntity E WITH (NOLOCK) ON S.TaskId = E.taskId AND E.exclude = 1
		INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON S.ClientId = CGA.clientId AND E.clientGroupId = CGA.clientGroupId
WHERE	E.clientGroupId > 0 AND E.clientId = 0
DELETE	#SubclientTask
FROM	#SubclientTask S
		INNER JOIN TM_AssocEntity E WITH (NOLOCK) ON S.TaskId = E.taskId AND E.exclude = 1
WHERE	E.clientId > 0 AND E.clientId = S.ClientId
	AND E.apptypeId IN (0, S.AppTypeId)
	AND E.instanceId IN (0, S.InstanceId)
	AND E.backupsetId IN (0, S.BackupsetId)
	AND E.subclientId IN (0, S.AppId)
UPDATE	S SET BackupScheduled = 1
FROM	#tblSubclient S INNER JOIN #SubclientTask T ON S.AppId = T.AppId
DROP TABLE #SubclientTask
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBackupScheduledSubclients')
	delete from GxQscripts where name = 'RptBackupScheduledSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBackupScheduledSubclients')
	delete from GXDBVersions where aliasname = 'RptBackupScheduledSubclients'
GO

insert into GXDBVersions values(2, 'RptBackupScheduledSubclients',  'v1.1.2.4.68.1', 'RptBackupScheduledSubclients', 'v1.1.2.4.68.1')
GO

