

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptAvgBkpThroughput.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptAvgBkpThroughput.sp,v $ $Id: RptAvgBkpThroughput.sp,v 1.12.46.13 2020/07/24 02:15:13 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptAvgBkpThroughput')
BEGIN
	print '>>> Drop Stored Procedure: RptAvgBkpThroughput <<<'
	drop procedure RptAvgBkpThroughput
END
IF EXISTS (select * from GxQscripts where name='RptAvgBkpThroughput')
	delete from GxQscripts where name = 'RptAvgBkpThroughput'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAvgBkpThroughput')
	delete from GXDBVersions where aliasname = 'RptAvgBkpThroughput'
GO
print '... Creating Procedure: RptAvgBkpThroughput'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptAvgBkpThroughput
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 55
SET @blLatestSurvey = 1 --Always pickup the latest
CREATE TABLE #LatestResult (CommServUniqueId INT, CommCellId INT, CommServName NVARCHAR(256), DisplayName NVARCHAR(256), SurveyResultId INT, RunningTime INT)
INSERT INTO #LatestResult
SELECT	CommServUniqueId, CommCellId, CommServName, DisplayName, SurverResultId, RunningTime
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId, @i_GroupId)
CREATE TABLE #DailyThroughput (Type VARCHAR(255), JobsEndDate DATE, AppSizeGB REAL, WriteTimeHR REAL, ThroughputGBHR DECIMAL(32,2))
CREATE TABLE #DailySPThroughput (CommServUniqueId INT, PolicyName VARCHAR(255), JobsEndDate DATE, AppSizeGB REAL, WriteTimeHR REAL, ThroughputGBHR DECIMAL(32,2))
CREATE TABLE #week_table (WeekDate DATE, Name VARCHAR(32))
DECLARE	@lastDays INT = 7
DECLARE @LastDate DATE = GETDATE()
DECLARE @QueryStr NVARCHAR(MAX)
DECLARE @Columns  VARCHAR(MAX)
SELECT	@LastDate = MAX(JobsEndDate)
FROM	cf_SurveyAvgBkpThroughputV1 AS A WITH (NOLOCK)
		INNER JOIN #LatestResult B ON A.SurveyResultId = B.SurveyResultId
IF @LastDate > DATEADD(DD, 1, GETDATE())
	SET @LastDate = GETDATE()
;WITH R(N) AS
(
	SELECT 0
	UNION ALL
	SELECT N+1 FROM R WHERE N < @lastDays
)
INSERT INTO #week_table (WeekDate)
SELECT DATEADD(DAY, -N, @LastDate) FROM R
IF(@blaggregate=1) -- Charts
BEGIN
	SELECT
		datediff(second, '01/01/1970', WeekDate) AS 'Date<DWDDMMM>',
		CAST(ISNULL([1], 0) AS DECIMAL(32,2)) AS 'Average Disk Throughput (GB/HR)',
		CAST(ISNULL([0], 0) AS DECIMAL(32,2)) AS 'Average Tape Throughput (GB/HR)',
		CAST(ISNULL([2], 0) AS DECIMAL(32,2)) AS 'Average Cloud Throughput (GB/HR)'
	FROM #week_table W LEFT OUTER JOIN
		(
		SELECT	JobsEndDate, IsDisk, CAST(SUM(AppSizeGB)/24.0 AS DECIMAL(32,2)) AS Throughput
		FROM	cf_SurveyAvgBkpThroughputV1 AS A WITH (NOLOCK)
				INNER JOIN #LatestResult B ON A.SurveyResultId = B.SurveyResultId
				INNER JOIN #week_table D ON A.JobsEndDate = D.WeekDate
		GROUP BY JobsEndDate, IsDisk
		) S PIVOT (MAX(Throughput) FOR IsDisk IN ([0], [1], [2])) AS P ON W.WeekDate = P.JobsEndDate
	ORDER BY WeekDate
END
ELSE
IF	@blaggregate = 0 -- table for disk, tape and cloud throughput
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			resultView.CommCellID AS 'CommCell ID',
			resultView.DisplayName AS 'CommCell Name',
			CASE
				WHEN MAX(resultView.RunningTime) = -1 THEN 'N/A'
				ELSE CAST(MAX(resultView.RunningTime) AS VARCHAR(MAX))
			END AS 'Running Time in Seconds',
			CASE WHEN MAX(csInfo.JobsEndDate) IS NULL THEN -100
	 			ELSE datediff(second, '01/01/1970', MAX(csInfo.JobsEndDate)) END AS 'Date<MMMDDYYYY>',
			CASE csInfo.IsDisk
				 WHEN 1 THEN 'Disk'
				 WHEN 2 THEN 'Cloud'
				 ELSE 'Tape'
			END AS 'Type',
			CAST(ISNULL(SUM(csInfo.AppSizeGB*1024.0),0) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
			CAST(ISNULL((SUM(csInfo.AppSizeGB)/(24.0 * 8)),0) AS DECIMAL(32,2)) 	AS 'Throughput (GB/HR)'
		FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
			INNER JOIN #LatestResult AS resultView
				ON resultView.SurveyResultId = csInfo.SurveyResultId
		GROUP BY resultView.CommServUniqueId, resultView.CommCellID, resultView.DisplayName, csInfo.IsDisk
		ORDER BY [Date<MMMDDYYYY>], [Type]
	END
	ELSE
		SELECT
			csInfo.CommServUniqueId AS 'CommServ UniqueId',
			CASE WHEN csInfo.JobsEndDate IS NULL THEN -100
				ELSE datediff(second, '01/01/1970', csInfo.JobsEndDate) END AS 'Date<MMMDDYYYY>',
			CASE csInfo.IsDisk
				 WHEN 1 THEN 'Disk'
				 WHEN 2 THEN 'Cloud'
				 ELSE 'Tape'
			END AS 'Type',
			CAST(ISNULL(csInfo.AppSizeGB*1024.0,0) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
			CAST(ISNULL((csInfo.AppSizeGB/24.0),0) AS DECIMAL(32,2)) 	AS 'Throughput (GB/HR)'
		FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
			INNER JOIN #LatestResult AS resultView
				ON resultView.SurveyResultId = csInfo.SurveyResultId
		ORDER BY csInfo.JobsEndDate, [Type]
END
ELSE
IF	@blaggregate IN (2,3,4,5,6,7,8,9,10,11)
BEGIN
	IF	@blaggregate IN (2,3) -- backup throughput per media type
		INSERT	INTO #DailyThroughput
		SELECT	CASE T.IsDisk WHEN 1 THEN 'Disk' WHEN 2 THEN 'Cloud' ELSE 'Tape'END, T.JobsEndDate, SUM(T.AppSizeGB), SUM(T.WriteTimeHr),
				CASE WHEN SUM(T.WriteTimeHr) > 0 THEN SUM(T.AppSizeGB)/SUM(T.WriteTimeHr) ELSE 0 END
		FROM	cf_SurveyAvgBkpThroughputV1 AS T WITH (NOLOCK)
				INNER JOIN #LatestResult R ON R.SurveyResultId = T.SurveyResultId
		GROUP BY T.IsDisk, T.JobsEndDate
	ELSE
	IF	@blaggregate IN (4,5) -- backup throughput per agent type
		INSERT	INTO #DailyThroughput
		SELECT 	AT.shortName, T.JobsEndDate, SUM(T.AppSizeGB), SUM(1.0*T.WriteTime)/3600.0,
				CASE WHEN SUM(1.0*T.WriteTime) > 0 THEN 3600.0*SUM(T.AppSizeGB)/SUM(1.0*T.WriteTime) ELSE 0 END
		FROM	cf_SurveyBkpThroughputByAgentType AS T WITH (NOLOCK)
				INNER JOIN cf_SurveyAgentType AT ON T.AppTypeId = AT.id
				INNER JOIN #LatestResult AS R ON R.SurveyResultId = T.SurveyResultId
		GROUP BY AT.shortName, T.JobsEndDate
	ELSE
	IF	@blaggregate IN (6,7) -- restore throughput per agent type
		INSERT	INTO #DailyThroughput
		SELECT 	AT.shortName, T.JobsEndDate, SUM(T.AppSizeGB), SUM(1.0*T.WriteTime)/3600.0,
				CASE WHEN SUM(1.0*T.WriteTime) > 0 THEN 3600.0*SUM(T.AppSizeGB)/SUM(1.0*T.WriteTime) ELSE 0 END
		FROM	cf_SurveyRstThroughputByAgentType AS T WITH (NOLOCK)
				INNER JOIN cf_SurveyAgentType AT ON T.AppTypeId = AT.id
				INNER JOIN #LatestResult AS R ON R.SurveyResultId = T.SurveyResultId
		GROUP BY AT.shortName, T.JobsEndDate
	ELSE
	IF	@blaggregate IN (8,9) -- aux copy throughput per agent type
		INSERT	INTO #DailyThroughput
		SELECT 	CASE T.IsDisk WHEN 1 THEN 'Disk' WHEN 2 THEN 'Cloud' ELSE 'Tape' END,
				T.JobsEndDate, SUM(T.AppSizeGB), SUM(T.WriteTimeHr),
				CASE WHEN SUM(T.WriteTimeHr) > 0 THEN 1.0*SUM(T.AppSizeGB)/SUM(T.WriteTimeHr) ELSE 0 END
		FROM	cf_SurveyAuxCopyThroughput AS T WITH (NOLOCK)
				INNER JOIN #LatestResult AS R ON R.SurveyResultId = T.SurveyResultId
		GROUP BY CASE T.IsDisk WHEN 1 THEN 'Disk' WHEN 2 THEN 'Cloud' ELSE 'Tape' END, T.JobsEndDate
	ELSE
	IF	@blaggregate IN (10,11) -- backup throughput per storage policy
		INSERT	INTO #DailySPThroughput
		SELECT 	R.CommServUniqueId, T.PolicyName, T.JobsEndDate, SUM(T.AppSizeGB), SUM(1.0*T.WriteTime)/3600.0,
				CASE WHEN SUM(1.0*T.WriteTime) > 0 THEN 3600.0*SUM(T.AppSizeGB)/SUM(1.0*T.WriteTime) ELSE 0 END
		FROM	cf_SurveyBkpThroughputByStoragePolicy AS T WITH (NOLOCK)
				INNER JOIN #LatestResult AS R ON R.SurveyResultId = T.SurveyResultId
		GROUP BY R.CommServUniqueId, T.PolicyName, T.JobsEndDate
	IF	@blaggregate IN (2,4,6,8) -- table
	BEGIN
		UPDATE #week_table SET Name = LEFT(CONVERT(VARCHAR(8), WeekDate, 107), 6)
		SELECT	@Columns = ISNULL(@Columns + ', ', '') + QUOTENAME(Name)
		FROM	#week_table
		ORDER BY WeekDate
		SET @QueryStr =
			N'SELECT
				Type AS [Type], ' + @Columns + ', AvgThroughput AS [Average]
			FROM
			(
				SELECT 	A.Type, CAST(A.AvgThroughput AS DECIMAL(32,2)) AS AvgThroughput, W.Name, ISNULL(T.ThroughputGBHR, 0) AS Value
				FROM	#week_table W
						CROSS JOIN (
							SELECT 	Type, CASE WHEN SUM(WriteTimeHR) > 0 THEN SUM(AppSizeGB)/SUM(WriteTimeHR) ELSE 0 END AS AvgThroughput
							FROM	#DailyThroughput join #week_table
							on #week_table.WeekDate = #DailyThroughput.JobsEndDate
							GROUP BY Type) A
						LEFT OUTER JOIN #DailyThroughput T ON A.Type = T.Type AND W.WeekDate = T.JobsEndDate
			) X
			PIVOT
			(
				MAX(Value)
				FOR Name IN (' + @Columns + N')
			) P
			ORDER BY [Average] DESC'
		EXEC sp_executesql @QueryStr
	END
	ELSE
	IF	@blaggregate IN (10) -- Storage Policy table
	BEGIN
		UPDATE #week_table SET Name = LEFT(CONVERT(VARCHAR(8), WeekDate, 107), 6)
		SELECT	@Columns = ISNULL(@Columns + ', ', '') + QUOTENAME(Name)
		FROM	#week_table
		ORDER BY WeekDate
		SET @QueryStr =
			N'SELECT
				CommServUniqueId AS [CommServ UniqueId<DONOTSHOW>], CommServName AS [CommCell Name], PolicyName AS [Storage Policy], ' + @Columns + ', AvgThroughput AS [Average]
			FROM
			(
				SELECT 	R.CommServUniqueId, R.CommServName, A.PolicyName, CAST(A.AvgThroughput AS DECIMAL(32,2)) AS AvgThroughput, W.Name, ISNULL(T.ThroughputGBHR, 0) AS Value
				FROM	#week_table W
						CROSS JOIN (
							SELECT 	CommServUniqueId, PolicyName, CASE WHEN SUM(WriteTimeHR) > 0 THEN SUM(AppSizeGB)/SUM(WriteTimeHR) ELSE 0 END AS AvgThroughput
							FROM	#DailySPThroughput join #week_table
							on #week_table.WeekDate = #DailySPThroughput.JobsEndDate
							GROUP BY CommServUniqueId, PolicyName) A
						INNER JOIN #LatestResult R ON A.CommServUniqueId = R.CommServUniqueId
						LEFT OUTER JOIN #DailySPThroughput T ON A.CommServUniqueId = T.CommServUniqueId AND A.PolicyName = T.PolicyName AND W.WeekDate = T.JobsEndDate
			) X
			PIVOT
			(
				MAX(Value)
				FOR Name IN (' + @Columns + N')
			) P
			ORDER BY [CommCell Name], [Average] DESC'
		EXEC sp_executesql @QueryStr
	END
	ELSE
	IF	@blaggregate IN (3,5,7,9) -- chart
		SELECT 	A.Type AS 'Type',
				DATEDIFF(SS, '01/01/1970', WeekDate) AS 'Date<DWDDMMM>',
				ISNULL(T.ThroughputGBHR, 0) AS 'Throughput (GB/HR)'
		FROM	#week_table W
				CROSS JOIN (
					SELECT 	Type, CASE WHEN SUM(WriteTimeHR) > 0 THEN SUM(AppSizeGB)/SUM(WriteTimeHR) ELSE 0 END AS AvgThroughput
					FROM	#DailyThroughput
					GROUP BY Type) A
				LEFT OUTER JOIN #DailyThroughput T ON A.Type = T.Type AND W.WeekDate = T.JobsEndDate
		ORDER BY 'Throughput (GB/HR)' DESC
	ELSE
	IF	@blaggregate IN (11) -- Storage Policy chart
		SELECT 	CASE WHEN i_CommServUniqueID = 0 THEN R.CommservName +' - ' + A.PolicyName ELSE A.PolicyName END AS 'Storage Policy',
				DATEDIFF(SS, '01/01/1970', WeekDate) AS 'Date<DWDDMMM>',
				ISNULL(T.ThroughputGBHR, 0) AS 'Throughput (GB/HR)'
		FROM	#week_table W
				CROSS JOIN (
					SELECT 	CommServUniqueId, PolicyName, CASE WHEN SUM(WriteTimeHR) > 0 THEN SUM(AppSizeGB)/SUM(WriteTimeHR) ELSE 0 END AS AvgThroughput
					FROM	#DailySPThroughput
					GROUP BY CommServUniqueId, PolicyName) A
				INNER JOIN #LatestResult R ON A.CommServUniqueId = R.CommServUniqueId
				LEFT OUTER JOIN #DailySPThroughput T ON A.Type = T.Type AND W.WeekDate = T.JobsEndDate
		ORDER BY 'Throughput (GB/HR)' DESC
END
DROP TABLE #week_table
DROP TABLE #DailyThroughput
DROP TABLE #DailySPThroughput
DROP TABLE #LatestResult
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptAvgBkpThroughput')
	delete from GxQscripts where name = 'RptAvgBkpThroughput'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAvgBkpThroughput')
	delete from GXDBVersions where aliasname = 'RptAvgBkpThroughput'
GO

insert into GXDBVersions values(2, 'RptAvgBkpThroughput',  '00010012004600130000', 'RptAvgBkpThroughput', '00010012004600130000')
GO

