

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptAsBuiltGuide.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptAsBuiltGuide.sp,v $ $Id: RptAsBuiltGuide.sp,v 1.5.12.19.6.1 2021/02/04 01:31:16 hchen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptAsBuiltGuide')
BEGIN
	print '>>> Drop Stored Procedure: RptAsBuiltGuide <<<'
	drop procedure RptAsBuiltGuide
END
IF EXISTS (select * from GxQscripts where name='RptAsBuiltGuide')
	delete from GxQscripts where name = 'RptAsBuiltGuide'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAsBuiltGuide')
	delete from GXDBVersions where aliasname = 'RptAsBuiltGuide'
GO
print '... Creating Procedure: RptAsBuiltGuide'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptAsBuiltGuide
  @i_userid INT,
  @i_param INT
AS
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @InternetGateway NVARCHAR(MAX) = 'No Internet Gateway'
	IF(@i_param IN (3, 22)) --Set @InternetGateway
	BEGIN
		IF EXISTS(SELECT * FROM GxGlobalParam WHERE  NAME = 'DownloadInternetGtwyEnabled' AND value = '1' AND modified = 0)
			SELECT @InternetGateway = 'Use Client: ' + name FROM APP_Client WHERE id = (SELECT CAST(value AS INT) FROM GxGlobalParam WHERE  NAME = 'CommservSurveyCollectionProxy' AND modified = 0)
		ELSE IF EXISTS(SELECT * FROM GxGlobalParam WHERE  NAME = 'CommservSurveyUseMetricsServerAsInternetGateway' AND value = '1' AND modified = 0)
			SELECT @InternetGateway = 'Use Metrics Server'
	END
	IF @i_param = 1		-- Backup Job Statistics
	BEGIN
		DECLARE @TotalJobs  int
		DECLARE @CJobs      int
		DECLARE @CWEJobs    int
		DECLARE @CWWJobs    int
		DECLARE @FailedJobs int
		DECLARE @sixtdaysec int
		SET @sixtdaysec=24*60*60*15
		DECLARE @LastDate BIGINT = (SELECT dbo.GetUnixTimeBig(CAST(getutcdate() AS DATE)))
		DECLARE @jobStatusAggrTbl TABLE
		(
		   jobStatus int,
		   totalCount int
		)
		DECLARE @nreleaseId INT =1
		SET @nreleaseId =(SELECT releaseId from APP_Client  where id =2)
		DECLARE @ExcludedAppIds TABLE (appId INT)
		INSERT INTO @ExcludedAppIds
		SELECT componentNameId FROM APP_subclientProp WHERE attrName IN ('DDB Backup', 'Index SubClient', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
		UNION
		SELECT id FROM APP_Application
		WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)
		INSERT INTO @jobStatusAggrTbl
		SELECT BKP.jobState, COUNT(BKP.jobState)
		FROM
			(SELECT
			   (CASE WHEN displayStatus = 0 THEN B.status
					 ELSE displayStatus
				END) AS jobState
			FROM JMBkpStats B
				INNER JOIN APP_Application A ON B.appId = A.id
				INNER JOIN APP_Client C ON C.id = A.clientId
			WHERE B.servEndDate >= @LastDate-@sixtdaysec
				AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
				AND dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1
				AND A.id NOT IN (SELECT appId FROM @ExcludedAppIds)
			) BKP
		GROUP BY BKP.jobState
		IF EXISTS (SELECT totalCount FROM @jobStatusAggrTbl where jobStatus = 1)
			SET @CJobs = ( SELECT totalCount FROM @jobStatusAggrTbl where jobStatus = 1 )
		ELSE
			SET @CJobs = 0
		IF EXISTS (SELECT totalCount FROM @jobStatusAggrTbl where jobStatus in (14))
			SET @CWWJobs = ( SELECT totalCount FROM @jobStatusAggrTbl where jobStatus in (14)  )
		ELSE
			SET @CWWJobs = 0
		IF EXISTS (SELECT totalCount FROM @jobStatusAggrTbl where jobStatus = 3)
			SET @CWEJobs = ( SELECT totalCount FROM @jobStatusAggrTbl where jobStatus =3  )
		ELSE
			SET @CWEJobs = 0
		IF EXISTS (SELECT totalCount FROM @jobStatusAggrTbl where jobStatus IN ( 2,4) )
			SET @FailedJobs = ( SELECT SUM(totalCount) FROM @jobStatusAggrTbl where jobStatus IN ( 2,4) )
		ELSE
			SET @FailedJobs = 0
		SET @TotalJobs = @CJobs + @CWWJobs + @CWEJobs + @FailedJobs
		SELECT 'Success Rate' AS Parameters,CASE WHEN @TotalJobs = 0 THEN 'N/A' ELSE CAST(CAST(ROUND(@CJobs*100.0/@TotalJobs,2) AS DECIMAL(10,2)) AS VARCHAR(10)) +' %' END AS 'Values'
		UNION ALL
		SELECT 'Number Of Backups' AS Parameters,CAST(@TotalJobs AS VARCHAR(10)) AS 'Values'
		UNION ALL
		SELECT 'Successful Backups' AS Parameters,CAST(@CJobs AS VARCHAR(10)) AS 'Values'
		UNION ALL
		SELECT 'Jobs Completed With Error' AS Parameters,CAST(@CWEJobs AS VARCHAR(10)) AS 'Values'
		UNION ALL
		SELECT 'Jobs Completed With Warning' AS Parameters,CAST(@CWWJobs AS VARCHAR(10)) AS 'Values'
		UNION ALL
		SELECT 'Failed Backups' AS Parameters,CAST(@FailedJobs AS VARCHAR(10)) AS 'Values'
	END
	ELSE IF @i_param IN (2, 7) --Licensing information
	BEGIN
		DECLARE @licenseXML XML = (SELECT TOP 1 licXML FROM SimLicenses ORDER BY id DESC)
		IF @i_param = 2
			SELECT
				lic.part.value('@PartNumberName', 'nvarchar(max)') AS 'LicDescription',
				lic.part.value('@PartNumber', 'nvarchar(max)') AS 'LicPartNumber',
				lic.part.value('@Quantity', 'int') AS 'LicPermanent',
				lic.part.value('@QuantityEval', 'int') AS 'LicEvaluation'
			FROM @LicenseXml.nodes('//CommVaultOEMOrder[1]/LAServerInfo[1]/LAPartNumbers[1]/CvPartNumber') AS lic(part)
			ORDER BY lic.part.value('@PartNumberName', 'nvarchar(max)') ASC
		ELSE
			SELECT
				lic.sku.value('@SKUName', 'nvarchar(max)') AS 'SKUName',
				lic.sku.value('@SKU', 'nvarchar(max)') AS 'SKU',
				lic.sku.value('@SKUBundle', 'nvarchar(max)') AS 'SKUBundle',
				s.k.value('@PartNumberName', 'nvarchar(max)') AS 'SKUPartNumber',
				s.k.value('@Quantity', 'int') AS 'PartPermQ',
				s.k.value('@QuantityEval', 'int') AS 'PartEvalQ',
				lic.sku.value('@Quantity', 'int') AS 'SKUPermanent',
				lic.sku.value('@QuantityEval', 'int') AS 'SKUEvaluation'
			FROM @LicenseXml.nodes('//CommVaultOEMOrder[1]/LAServerInfo[1]/LASKUs[1]/SKU') AS lic(sku)
				OUTER APPLY lic.sku.nodes('SKUPartNumbers') AS S(k)
			ORDER BY lic.sku.value('@SKUName', 'nvarchar(max)') ASC
	END
	ELSE IF @i_param = 3		-- CS Information
	BEGIN
		DECLARE @CSNode INT
		DECLARE @CSClientId INT
		SELECT @CSNode = clientId FROM APP_Platform WHERE platformType = 1
		DECLARE @localNetHostName NVARCHAR(1024) = (SELECT net_hostname from app_client where id = @CSNode)
		DECLARE @StandByNode INT
		DECLARE @StandByHostName NVARCHAR(1024), @StandByIP NVARCHAR(128)
		SELECT
			@StandByNode= C.id
		FROM APP_Client C
		INNER JOIN simInstalledPackages SIM ON SIM.simPackageID = 24 AND SIM.ClientId = C.id
		WHERE C.net_hostname <> @localNetHostName
Select @StandByHostName=stringVal from APP_ComponentProp where componentId = @StandByNode AND propertyTypeId = 2103 AND modified = 0
Select @StandByIP=stringVal from APP_ComponentProp where componentId = @StandByNode AND propertyTypeId = 2102 AND modified = 0
		-- Find out if this is a cluster CS.
		DECLARE @isClusterCS INT = 0
		SELECT @isClusterCS = attrVal FROM App_ClientProp
		WHERE componentNameId = @CSNode
			AND attrName LIKE 'Virtual Client'
			AND modified = 0
		-- If it is a cluster CS, we need to consider the active physical node of CommServ as CommServ client id
		IF @isClusterCS = 0
			SET @CSClientId = @CSNode
		ELSE
		BEGIN
			--Use currently active physical node
			SELECT @CSClientId = attrVal
			FROM App_ClientProp
			WHERE componentNameId = @CSNode AND attrName like 'CS Active Physical Node' AND modified = 0
		END
		DECLARE @majorVer INTEGER
		DECLARE @minorVer VARCHAR(1) = ''
		SELECT @majorVer = MAX(HighestSP) FROM simInstalledPackages WHERE clientId = @CSClientId
		SELECT @minorVer =
			CASE
			WHEN MAX(SpMinorVersion) = 0 THEN ''
			ELSE CHAR(MAX(SpMinorVersion)+96)
			END
		FROM simInstalledPackages
		WHERE clientId = @CSClientId  and HighestSP=@majorVer
		DECLARE @webConsoleURL      NVARCHAR(MAX) = ''
		SELECT @webConsoleURL = value FROM GXGlobalParam
		WHERE name = 'WebConsoleURL' AND modified = 0
		DECLARE @posIdx INT = PATINDEX('%/webconsole/%', @webConsoleURL)
		IF @posIdx = 0
		BEGIN
			SET @posIdx = PATINDEX('%/webconsole%', @webConsoleURL)
			IF @posIdx != 0
				SET @webConsoleURL =  REVERSE(RIGHT(REVERSE (@webConsoleURL), len(@webConsoleURL) -
					NULLIF(charindex('elosnocbew/', REVERSE(@webConsoleURL)) - 2,0))) + '/'
		END
		ELSE
		BEGIN
			SET @webConsoleURL = LEFT(@webConsoleURL, @posIdx+LEN('/webconsole/')-1)
		END
		SELECT [CommServe],[ServerClass] FROM (SELECT AC.displayName as name,
			   CASE (SELECT attrVal FROM App_ClientProp WHERE componentNameId = Ac.id AND attrName LIKE 'Virtual Client'  AND modified = 0) WHEN 0 THEN 'Physical'
					ELSE 'Cluster' END Type,
			   AC.net_hostname AS hostName,
			   dbo.GetClientOSName(AC.id,NULL) osName,
			   CAST((AC.releaseId-5) AS VARCHAR(10))+'.0' AS Release,
			   ISNULL(CAST(@majorVer AS VARCHAR(5))+@minorVer,'N/A') servicePack,
			   (select attrVal from APP_ClientProp where attrName = 'Patch Local Location' and componentNameId = AC.id AND modified = 0) InstallFolderLocation,
			   CC.smtpServer,
			   CC.ipAddress,
			   CC.userName AS DRUser
		FROM APP_Client AC
			INNER JOIN APP_Commcell CC ON CC.clientId = AC.id
			where AC.ID  =@CSClientId) CS
		CROSS APPLY
		(
			SELECT 'CommCell ID', (SELECT TOP 1 dbo.ConvertBigIntToHexStr(CommcellId) FROM LicCsl ORDER BY Id DESC) UNION ALL
			SELECT 'CommCell Name', name UNION ALL
			SELECT 'CommCell Type', Type UNION ALL
			SELECT 'Primary CommServe Hostname', hostName UNION ALL
			SELECT 'Primary CommServe IP Address', ipAddress UNION ALL
			SELECT 'Standby CommServe Hostname', @StandByHostName UNION ALL
			SELECT 'Standby CommServe IP Address', @StandByIP UNION ALL
			SELECT 'Operating System', osName UNION ALL
			SELECT 'CommCell Version', Release + ' Feature Release: ' + ServicePack UNION ALL
			SELECT 'Additional Patches',ISNULL(STUFF((
											SELECT DISTINCT '; ' + U.Data
											FROM simInstalledPackages P
											CROSS APPLY dbo.SplitString(CAST(P.AdditionalPatches AS NVARCHAR(MAX)), ',') U
											WHERE P.ClientId = @CSClientId AND CAST(P.AdditionalPatches AS NVARCHAR(MAX)) <> 'None'
											FOR XML PATH ('')
										), 1, 2, ''), 'None') UNION ALL
			SELECT 'Install Folder Location', InstallFolderLocation	UNION ALL
			SELECT 'Disaster Recovery Path', (SELECT value FROM GXGlobalParam WHERE Name = 'DRDumpLocation' AND modified = 0) UNION ALL
			SELECT 'Disaster Recovery User', DRUser UNION ALL
			SELECT 'Disaster Recovery Copies', (SELECT value FROM GXGlobalParam WHERE Name = 'DRNumFulls' AND modified = 0) UNION ALL
			SELECT 'Mail Server', smtpServer UNION ALL
			SELECT 'Mail Sender Address', (SELECT value FROM GXGlobalParam WHERE Name = 'EVSMTPSender' AND modified = 0) UNION ALL
			SELECT 'Internet Gateway', @InternetGateway UNION ALL
			SELECT 'Default Report URL', (SELECT value FROM GXGlobalParam WHERE Name = 'CommcellReportsUrl' AND modified = 0) UNION ALL
			SELECT 'CommCell Console URL', (SELECT value FROM GXGlobalParam WHERE Name = 'CommcellConsoleUrl' AND modified = 0) UNION ALL
			SELECT 'Web Console URL', @webConsoleURL UNION ALL
SELECT 'Additional Settings', (SELECT ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  3 AND deleted = 0 AND enabled = 1 AND entityId = 2 for XML PATH('')), 1, 2, ''),'None')) UNION ALL
			SELECT 'Max number of parallel data transfer operations for DDBs', (SELECT CAST(value AS NVARCHAR(MAX)) FROM MMConfigs WHERE Name = 'MMCONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_CONNECTION_PER_DDB')
		)C([CommServe],[ServerClass])
	END
	ELSE IF @i_param = 4		-- MA Information
	BEGIN
		SELECT MA.MAClientId,MA.MediaAgentName,[MediaAgent],[ServerClass] FROM (
				SELECT MA.ClientId AS MAClientId,
				CL.displayName AS MediaAgentName,
				CASE WHEN AC.attrVal IS NULL THEN 'Physical'
					 ELSE 'Cluster'
					 END MediaAgentType,
				CL.net_hostname AS HostName,
				dbo.GetClientOSName(CL.id,NULL) AS OSName,
				R.release+'.0' AS Release,
				CASE WHEN V.attrVal IS NULL OR CHARINDEX(' SP',V.attrVal) = 0 THEN 'N/A'
					ELSE SUBSTRING(V.attrVal,CHARINDEX(' SP',V.attrVal)+3,LEN(V.attrVal))
				END AS ServicePackVersion,
				(select P.attrVal from APP_ClientProp P where P.attrName = 'Patch Local Location' and P.componentNameId = MA.clientId AND P.modified = 0) InstallFolderLocation,
				I.IndexCachePath,
				I.Retention,
				ISNULL(STUFF((SELECT '; ' + P.path
					FROM IdxSIDBSubStore S
						INNER JOIN idxAccessPath P ON S.idxAccessPathId = P.idxAccessPathId
					WHERE S.ClientId = MA.ClientId AND S.commCellId = 2
					AND S.SubStoreId = CASE WHEN S.origSubStoreId > 0 THEN S.origSubStoreId ELSE S.SubStoreId END FOR XML PATH('')), 1, 2, ''), 'None') AS DDBPaths,
				MA.MaxReservations
		FROM    MMHost MA
				INNER JOIN APP_Client CL ON CL.id = MA.ClientId AND CL.id > 1
				INNER JOIN simAllGalaxyRel R ON R.id = CL.releaseId
				INNER JOIN LicUsage lu ON lu.AppType=1002 AND lu.OpType='Install' AND lu.CId=cl.id
				LEFT OUTER JOIN APP_ClientProp V ON V.componentNameId = MA.ClientId AND V.attrName = 'SP Version Info' AND V.modified = 0
				LEFT OUTER JOIN (
					SELECT DISTINCT
						  a.ClientId AS MAId,
						  a.Path AS IndexCachePath,
						  p.AgeingNoOfDays AS Retention
					FROM IdxPool p
						 INNER JOIN IdxCache c ON c.IdxCacheType=1 AND p.IdxPoolId=c.IdxPoolId
						 INNER JOIN IdxAccessPath a ON c.IdxCacheId=a.IdxCacheId) I ON  I.MAId = MA.ClientId
				LEFT OUTER JOIN APP_ClientProp AC ON CL.id = AC.componentNameId AND AC.attrName = 'Active Physical Node' AND AC.attrVal <> CL.id AND AC.modified = 0
				) MA
		CROSS APPLY
		(
			SELECT 'MediaAgent Name', MediaAgentName UNION ALL
			SELECT 'MediaAgent Type', MediaAgentType UNION ALL
			SELECT 'MediaAgent HostName', HostName UNION ALL
			SELECT 'Operating System', OSName UNION ALL
			SELECT 'Commvault Version', Release UNION ALL
			SELECT 'Feature Release', ServicePackVersion UNION ALL
SELECT 'Agents Installed', (SELECT ISNULL(STUFF((SELECT DISTINCT ', ' + APP_IDAType.displayName								FROM licUsage licUsage WITH(NOLOCK)									INNER JOIN APP_IDAType APP_IDAType WITH(NOLOCK) ON licUsage.appType = APP_IDAType.type								WHERE licUsage.opType = 'Install' AND licUsage.appType < 1000 AND licUsage.licType NOT IN (10, 26, 71) AND licUsage.cid = MAClientId								FOR XML PATH('')), 1, 2, ''), 'None')) UNION ALL
			SELECT 'Install Folder Location', InstallFolderLocation UNION ALL
			SELECT 'Index Cache/DB Path', IndexCachePath UNION ALL
			SELECT 'Index Cache Retention', CAST(Retention AS VARCHAR(10)) UNION ALL
			SELECT 'DDB Path', ISNULL(DDBPaths, 'None') UNION ALL
			SELECT 'Maximum number of parallel data transfer operations', CAST(MaxReservations AS NVARCHAR(MAX)) UNION ALL
SELECT 'Additional Settings', (SELECT ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  3 AND deleted = 0 AND enabled = 1 AND entityId = MAClientId for XML PATH('')), 1, 2, ''),'None'))
		)C([MediaAgent],[ServerClass])
		ORDER BY MediaAgentName
	END
	ELSE IF @i_param = 5		-- VSA information
	BEGIN
		IF OBJECT_ID('tempdb..#VSAProxiesAndInstances') IS NOT NULL DROP TABLE #VSAProxiesAndInstances
		CREATE TABLE #VSAProxiesAndInstances(ProxyId INT, InstanceId INT)
		INSERT INTO #VSAProxiesAndInstances
		SELECT DISTINCT ProxyId, InstanceId FROM (
			SELECT  MS.C.value('@clientId', 'INT') AS ProxyId,P.componentNameId AS InstanceId
			FROM (SELECT componentNameId, CAST(attrVal AS XML) AS MemberServers FROM APP_InstanceProp WHERE attrName = 'Vs Member Servers' AND modified = 0)  P
				CROSS APPLY P.MemberServers.nodes('//App_MemberServers/memberServers/client') AS MS(C)
WHERE MS.C.value('@clientId', 'INT') IS NOT NULL AND MS.C.value('@_type_', 'INT') = 3
			UNION ALL
			SELECT  CGA.clientId AS ProxyId,P.componentNameId AS InstanceId
			FROM (SELECT componentNameId, CAST(attrVal AS XML) AS MemberServers FROM APP_InstanceProp WHERE attrName = 'Vs Member Servers' AND modified = 0)  P
				CROSS APPLY P.MemberServers.nodes('//App_MemberServers/memberServers/client') AS MS(C)
				INNER JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = MS.C.value('@clientGroupId', 'INT')
WHERE MS.C.value('@_type_', 'INT') = 28) P
		IF OBJECT_ID('tempdb..#ProxyDetails') IS NOT NULL DROP TABLE #ProxyDetails
		CREATE TABLE #ProxyDetails(ProxyId INT, Instances NVARCHAR(MAX), HostNames NVARCHAR(MAX), ClientAssoc NVARCHAR(MAX))
		INSERT INTO #ProxyDetails
		SELECT ProxyId,
			STUFF((SELECT ';'+name FROM APP_InstanceName I INNER JOIN #VSAProxiesAndInstances P ON I.id = P.InstanceId WHERE P.ProxyId = T.ProxyId FOR XML PATH('')),1,1,''),
			STUFF((SELECT ';'+attrVal FROM APP_InstanceProp I INNER JOIN #VSAProxiesAndInstances P ON I.componentNameId = P.InstanceId WHERE P.ProxyId = T.ProxyId AND attrName = 'Virtual Server Host' AND modified = 0 FOR XML PATH('')),1,1,''),
			STUFF((SELECT distinct(';'+C.displayName) FROM APP_Application A INNER JOIN APP_Client C ON A.clientId = C.id INNER JOIN #VSAProxiesAndInstances P ON A.instance = P.InstanceId WHERE P.ProxyId = T.ProxyId FOR XML PATH('')),1,1,'')
		FROM (SELECT DISTINCT ProxyId FROM #VSAProxiesAndInstances) T
		SELECT ProxyId, ProxyName,[VSAParameters],[VSAValues] FROM (
						SELECT P.ProxyId,
						CL.displayName AS ProxyName ,
						P.Instances,
						P.HostNames,
						dbo.GetClientOSName(CL.id,NULL) AS OSName,
						R.release+'.0' AS Release,
						CASE WHEN V.attrVal IS NULL OR CHARINDEX(' SP',V.attrVal) = 0 THEN 'N/A'
							ELSE SUBSTRING(V.attrVal,CHARINDEX(' SP',V.attrVal)+3,LEN(V.attrVal))
						END AS ServicePackVersion,
						(select CP.attrVal from APP_ClientProp CP where CP.attrName = 'Patch Local Location' and CP.componentNameId = P.ProxyId AND CP.modified = 0) InstallFolderLocation,
						P.ClientAssoc
				FROM    #ProxyDetails P
						INNER JOIN APP_Client CL ON CL.id = P.ProxyId AND CL.id > 1
						INNER JOIN simAllGalaxyRel R ON R.id = CL.releaseId
						LEFT OUTER JOIN APP_ClientProp V ON V.componentNameId =  P.ProxyId AND V.attrName = 'SP Version Info' AND V.modified = 0
						) P
				CROSS APPLY
				(
					SELECT 'Virtual Server Agent Name', ProxyName UNION ALL
					SELECT 'Virtual Server Agent Type', Instances UNION ALL
					SELECT 'Virtual Server HostName', HostNames UNION ALL
					SELECT 'Operating System', OSName UNION ALL
					SELECT 'Commvault Version', Release UNION ALL
					SELECT 'Feature Release', ServicePackVersion UNION ALL
SELECT 'Agents Installed', (SELECT ISNULL(STUFF((SELECT DISTINCT ', ' + APP_IDAType.displayName								FROM licUsage licUsage WITH(NOLOCK)									INNER JOIN APP_IDAType APP_IDAType WITH(NOLOCK) ON licUsage.appType = APP_IDAType.type								WHERE licUsage.opType = 'Install' AND licUsage.appType < 1000 AND licUsage.licType NOT IN (10, 26, 71) AND licUsage.cid = P.ProxyId								FOR XML PATH('')), 1, 2, ''), 'None')) UNION ALL
					SELECT 'Install Folder Location', InstallFolderLocation UNION ALL
					SELECT 'Virtual Server Client Association', ClientAssoc UNION ALL
SELECT 'Additional Settings', (SELECT ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  3 AND deleted = 0 AND enabled = 1 AND entityId = P.ProxyId for XML PATH('')), 1, 2, ''),'None'))
				)C([VSAParameters],[VSAValues])
				ORDER BY ProxyName
		IF OBJECT_ID('tempdb..#VSAProxiesAndInstances') IS NOT NULL DROP TABLE #VSAProxiesAndInstances
		IF OBJECT_ID('tempdb..#ProxyDetails') IS NOT NULL DROP TABLE #ProxyDetails
	END
	ELSE IF @i_param = 6 -- DR Backup Information
	BEGIN
		DECLARE @lt_fullJobsToRetain varchar(256)
		DECLARE @lt_useNetworkPath    varchar(10)
		DECLARE @lt_logFilesToBackup varchar(max)
		DECLARE @lt_writingToTape varchar(10)
		SELECT @lt_fullJobsToRetain = value
		FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'DRNumFulls'
		-- Find whether metadata dumps are saved to network path or local file system path
		SELECT @lt_useNetworkPath = (CASE WHEN value like '\\%' THEN 'true' ELSE 'false' END)
		FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'DRDumpLocation'
		-- Find the patterns of the log files being backed up by DR backup job
		SELECT @lt_logFilesToBackup = value
		FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'DRDumpClientLogWildCard'
		-- Find if the target media is a tape or magnetic library
		IF EXISTS
		(
			  SELECT *
			  FROM APP_Application A WITH(READUNCOMMITTED)
					INNER JOIN archGroupCopy B WITH(READUNCOMMITTED) ON A.dataArchGrpID = B.archGroupId
					INNER JOIN MMDataPath C WITH(READUNCOMMITTED) ON B.id = C.CopyId
					INNER JOIN MMDrivePool D WITH(READUNCOMMITTED) ON C.DrivePoolId = D.DrivePoolId
			  WHERE D.DrivePoolType <> 10001 AND A.appTypeId = 1000 AND A.dataArchGrpID > 1
		)
		BEGIN
			  SET @lt_writingToTape = 'true'
		END
		ELSE
		BEGIN
			  SET @lt_writingToTape = 'false'
		END
		SELECT  A.subTaskName As scheduleName,
				(CASE C.freq_type WHEN 1 THEN 'one Time' WHEN 4 THEN 'daily'
					WHEN 8 THEN 'weekly' WHEN 16 THEN 'monthly' WHEN 32 THEN 'monthly'
					WHEN 64 THEN 'yearly' WHEN 128 THEN 'yearly' ELSE CONVERT(varchar(10), C.freq_type) END) scheduleType,
				ISNULL(CAST(jobdetails.jobId AS VARCHAR(10)),'N/A') as 'lastJobId',
				@lt_fullJobsToRetain AS fullJobsToRetain,
				@lt_useNetworkPath AS usingNetworkPath,
				ISNULL(@lt_logFilesToBackup,'None') AS logFilesToBackup,
				@lt_writingToTape AS writingToTape
		  FROM TM_SubTask A  WITH(READUNCOMMITTED)
				INNER JOIN TM_PatternAssoc B WITH(READUNCOMMITTED) ON A.subTaskId = B.subTaskId
				INNER JOIN TM_Pattern C WITH(READUNCOMMITTED) ON B.patternId = C.patternId
				AND A.deleted = 0 AND A.operationType = 4002
				INNER JOIN TM_Task D WITH(READUNCOMMITTED) ON D.taskId = A.taskId
				AND D.deleted=0 AND D.disabled=0
			LEFT OUTER JOIN
			(
			SELECT  C.subTaskId AS 'subTaskId' , max(C.jobId) AS 'jobId'
			FROM APP_Application  A WITH(READUNCOMMITTED) INNER JOIN JMJobDataStats B WITH(READUNCOMMITTED) ON A.id = B.appId
			AND A.appTypeId = 1000 AND B.status = 100 AND (B.disabled & 256) = 0
			INNER JOIN JMAdminJobStatsTable C WITH(READUNCOMMITTED) ON C.jobId = B.jobId
			GROUP BY C.subTaskId) as  jobdetails
			on
			jobdetails.subTaskId =A.subTaskId
				AND EXISTS(SELECT 1 FROM APP_Application WITH(READUNCOMMITTED) WHERE appTypeId = 1000 AND dataArchGrpID > 1)
	END
	ELSE IF @i_param = 8		-- Storage Array Information
	BEGIN
		SELECT SCH.SMArrayId AS ArrayName,
			   --SAR.LoginName,
			   SCH.SMHostUserName,
			   SCH.SMHostName,
			   SCH.SnapVendorName,
			   CASE WHEN AR.ArrayName IS NULL THEN 'Array'
					ELSE 'FileServer'
			   END AS ArrayType,
			   ISNULL(AR.ProductFirmwareVersion,'') AS ProductFirmwareVersion,
			   ISNULL(AR.productOSVersion,'') AS productOSVersion
		FROM SMControlHost SCH
		LEFT OUTER JOIN (SELECT SAR.*,SAHM .ControlHostId
							FROM SMArrayCtrlHostMap SAHM
							INNER JOIN SMArray SAR
								ON SAR.Id = SAHM.ArrayId) AR
			ON AR.ControlHostId = SCH.ControlHostId
		WHERE SCH.ControlHostId >0
	END
	ELSE IF @i_param = 9 -- Disk Library Information (used script CommservSurveyQuery_117.sql for reference)
	BEGIN
		IF OBJECT_ID('tempdb..#TempLibMountPath') IS NOT NULL
			DROP TABLE #TempLibMountPath
		IF OBJECT_ID('tempdb..#LibraryMountPaths') IS NOT NULL
			DROP TABLE #LibraryMountPaths
		CREATE TABLE #LibraryMountPaths (LibraryId INT, isCloud INT, MountPathName NVARCHAR(MAX))
		INSERT INTO #LibraryMountPaths
			SELECT MP.LibraryId, CASE MP.MountPathTypeId WHEN 7 THEN 1 ELSE 0 END,
				  CASE
						WHEN MP.MountPathTypeId = 1
						THEN ISNULL((SELECT TOP 1 A.FriendlyName
									FROM MMCenteraInfo A
									INNER JOIN MMMountPathToStorageDevice B ON A.CenteraId = B.CenteraId
									WHERE B.MountPathId = MP.MountPathId), 'Unavailable')
						WHEN MP.MountPathTypeId IN (4, 5, 7) AND S.MountPathId IS NOT NULL
						THEN S.Folder
						ELSE MP.MountPathName
					END MountPathName
			FROM MMMountPath MP
			LEFT OUTER JOIN (
			SELECT  c.MountPathId, DC.Folder
			FROM    (SELECT a.MountPathId, a.DeviceId
					FROM    MMMountPathToStorageDevice a,
							MMDeviceController b
					WHERE   a.DeviceId = b.DeviceId
					GROUP BY a.MountPathId, a.DeviceId
					HAVING COUNT(b.DeviceControllerId) = 1) c
					INNER JOIN MMDeviceController DC ON DC.DeviceId = c.DeviceId
			) S ON S.MountPathId = MP.MountPathId WHERE MP.MountPathId > 0
		select LibraryId, SUM(isCloud) AS isCloud, ISNULL(STUFF((SELECT ';'+MountPathName FROM #LibraryMountPaths WHERE LibraryId = T.LibraryId FOR XML PATH('')),1,1,''),'') MountPaths
		INTO #TempLibMountPath
		FROM #LibraryMountPaths T GROUP BY LibraryId
		SELECT AC.displayName AS MAName,
			L.AliasName AS LibName,
			CASE WHEN F.FreeBytesMB IS NULL OR F.FreeBytesMB <= 0 THEN 'N/A'
				ELSE dbo.FormatBytes(F.FreeBytesMB,'MB')
			END AS FreeSpaceMB,
			CASE WHEN F.TotalSpaceMB IS NULL OR F.TotalSpaceMB <= 0 THEN 'N/A'
				ELSE dbo.FormatBytes(F.TotalSpaceMB,'MB')
			END AS TotalSpaceMB,
				T.MountPaths AS MountPathName
		FROM    MMLibrary L
				INNER JOIN MMLibraryController LC
					ON L.LibraryId = LC.LibraryId AND L.LibraryId > 0 AND L.LibraryTypeId = 3
				INNER JOIN App_CLient AC
					ON AC.id = LC.ClientId
				LEFT OUTER JOIN #TempLibMountPath T
					ON T.LibraryId = L.LibraryId
				LEFT OUTER JOIN (
					SELECT  M.LibraryId, SUM(CAST(MS.FreeBytesMB AS BIGINT)) AS FreeBytesMB,SUM(ISNULL(CAST(MS.TotalSpaceMB AS BIGINT),0)) AS TotalSpaceMB
					FROM    MMMediaSide MS
							INNER JOIN MMMedia M ON MS.MediaId = M.MediaId
							LEFT OUTER JOIN (
								SELECT  MediaSideId FROM MMVolume
								WHERE VolumeFlags IN (1, 5, 7) AND RecordingFormatId <> 10001
								) V ON MS.MediaSideId = V.MediaSideId
					WHERE   (M.MediaTypeId = 10001 OR V.MediaSideId IS NOT NULL)
					GROUP BY M.LibraryId
					) F ON L.LibraryId = F.LibraryId
		WHERE ISNULL(isCloud, 0) = 0
		order by AC.displayName,LibraryName
		IF OBJECT_ID('tempdb..#TempLibMountPath') IS NOT NULL
			DROP TABLE #TempLibMountPath
		IF OBJECT_ID('tempdb..#LibraryMountPaths') IS NOT NULL
			DROP TABLE #LibraryMountPaths
	END
	ELSE IF @i_param = 10		-- Tape Library Information (used script CommservSurveyQuery_117.sql for reference)
	BEGIN
		SELECT  L.AliasName AS 'LibraryName',
			D.DriveCount ,
			D.Type,
			ISNULL(TS.Slots, 0) AS 'Slots'
			--ISNULL(TS.Slots, 0) - ISNULL(TS.OccupiedSlots, 0) AS 'EmptySlots'
		FROM (SELECT MP.LibraryId AS LibraryId,
					COUNT(DISTINCT D.DriveID) AS DriveCount,
					DT.DriveTypeName AS Type
				FROM    MMDrive D
						INNER JOIN MMDriveType DT ON D.DriveTypeId = DT.DriveTypeId
						INNER JOIN MMDriveController DC ON D.DriveID = DC.DriveID
						INNER JOIN MMDrivePool DP ON DC.DrivePoolID = DP.DrivePoolID
						INNER JOIN MMMasterPool MP ON DP.MasterPoolId = MP.MasterPoolID
				WHERE   D.DriveTypeId <> 10001
				GROUP BY MP.LibraryId,DT.DriveTypeName) D
		INNER JOIN MMLibrary L ON D.LibraryId = L.LibraryId
		LEFT OUTER JOIN (
			SELECT  B.LibraryId, COUNT(*) AS Slots, SUM(IsOccupied) AS OccupiedSlots
			FROM    MMSlot SL
			INNER JOIN MMBay B ON SL.BayId = B.BayId
			WHERE   SL.SlotType = 1
			GROUP BY B.LibraryId
			) TS ON L.LibraryId = TS.LibraryId
		WHERE L.LibraryId > 0 AND L.LibraryTypeId != 8
		ORDER BY L.LibraryId
	END
	ELSE IF @i_param = 11		-- Storage Policies
	BEGIN
		SELECT
			AG.name AS 'policyName',
			AGC.name AS 'copyName',
			--AR.archiverRetDays AS 'archiverRetDays',
			CAST(CASE WHEN AGC.maxStreamNum > 0 THEN AGC.maxStreamNum
				 ELSE AG.maxStreams
			END AS VARCHAR(10)) +
			CASE WHEN AGC.maxMultiplex > 0 THEN '/'+CAST(maxMultiplex AS VARCHAR(10))
				 ELSE ''
			END 'Streams/Multiplex',
			CASE WHEN AR.retentionDays = -1 AND AR.fullCycles = -1 THEN 'Infinite'
				 WHEN AR.retentionDays = 0 AND AR.fullCycles = 0 THEN 'Spool'
				 ELSE CASE WHEN AR.retentionDays < 1 THEN ''
						   WHEN AR.retentionDays = 1 THEN CAST(AR.retentionDays AS VARCHAR(10))+' day'
						   ELSE CAST(AR.retentionDays AS VARCHAR(10))+' days'
					  END + CASE WHEN AR.retentionDays >= 1 AND AR.fullCycles >= 1 THEN '/'  ELSE '' END +
					  CASE WHEN AR.fullCycles < 1 THEN ''
						   WHEN AR.fullCycles = 1 THEN CAST(AR.fullCycles AS VARCHAR(10))+' cycle'
						   ELSE CAST(AR.fullCycles AS VARCHAR(10))+' cycles'
					  END
			END AS 'retention',
			--AR.weekStart,
			--AR.monthStart,
			--AR.yearStart,
			ISNULL(STUFF((SELECT ';'+(CASE WHEN ARE.retentionRule IS NOT NULL
					THEN (CASE ARE.retentionDays
							WHEN -1 THEN 'Infinite '
							ELSE CAST(ARE.retentionDays AS VARCHAR(10))+' days '
						  END) +
						  (CASE ARE.retentionRule
							WHEN 2 THEN 'All Fulls'
							WHEN 4 THEN 'Weekly Full'
							WHEN 8 THEN 'Monthly Full'
							WHEN 16 THEN 'Quaterly Full'
							WHEN 32 THEN 'Half Yearly Full'
							WHEN 64 THEN 'Yearly Full'
						   END)
			END) FROM archAgingRuleExtended ARE WHERE ARE.copyId = AGC.id FOR XML PATH('')),1,1,''),'') AS extRretentionRules,
			AC.displayName + ' : '+L.ALiasName + ISNULL(':'+S.SpareGroupName,'') AS Datapath,
			SIDB.SIDBStoreAliasName  AS DDBEngine
		FROM
			archGroup AG
			INNER JOIN archGroupCopy AGC ON AGC.archGroupId = AG.id
			INNER JOIN MMDataPath D ON D.copyId = AGC.id
			INNER JOIN MMDrivePool DPL ON D.DrivePoolId = DPL.DrivePoolId
			INNER JOIN MMMasterPool MPL ON DPL.MasterPoolId = MPL.MasterPoolId
			INNER JOIN MMLibrary L ON MPL.LibraryId = L.LibraryId
			INNER JOIN APP_Client AC ON D.HostClientId = AC.id
			LEFT OUTER JOIN MMSpareGroup S ON S.SpareGroupId = D.SpareGroupId AND S.LibraryId = L.LibraryId
			LEFT OUTER JOIN archAgingRule AR ON AR.copyId = AGC.id
LEFT OUTER JOIN archCopySIDBStore CS ON CS.copyId = AGC.id AND ((CS.Flags & (2|4)) = (2|4))
			LEFT OUTER JOIN IdxSIDBStore SIDB ON SIDB.SIDBStoreId = CS.SIDBStoreId AND SIDB.commcellId = 2
		WHERE
			AG.type IN (1, 2) AND AGC.type IN (1, 2) AND D.Flag & 1 = 1 -- Default Data Path
		ORDER BY AG.name, AGC.name
	END
	ELSE IF @i_param = 12		-- Dedup storage Policies
	BEGIN
		SELECT AG.name AS StoragePolicy,
			   AGC.name AS Copy,
			   ISNULL(GDSP.name,'') AS GlobalDedupePolicy,
			   AG.SIBlockSizeKB AS BlockSizeKB,
			   (CASE WHEN AGC.dedupeFlags & 67108864 <> 0
					THEN 'Pause and Recover Automatically'
					WHEN AGC.dedupeFlags & 33554432 <> 0
					THEN 'Pause and Recover On-Demand'
					ELSE 'Failover to new DDB'
				END) AS DDBAvailPauseRecFail,
CASE WHEN (ISNULL(S.flags, 0) & 8192) <> 0 THEN 'Yes' ELSE 'No' END AS TransactionDDB,
				ISNULL(STUFF((SELECT DISTINCT ', ' + CL.displayName
							FROM archCopySIDBStore CS
								INNER JOIN IdxSIDBSubStore SS ON CS.SIDBStoreID = SS.SIDBStoreId
								INNER JOIN APP_Client CL ON SS.ClientId = CL.id AND SS.CommcellId = 2
WHERE AGC.id = CS.CopyId AND ((CS.Flags & 4) > 0)
							FOR XML PATH('')), 1, 2, ''), 'None') AS 'MediaAgents'
		FROM archGroupCopy AGC
		INNER JOIN archGroup AG ON AGC.archGroupId = AG.id
		LEFT JOIN archCopyToGlobalPolicy GP ON AGC.id = GP.copyId
LEFT JOIN archGroup GDSP ON GDSP.id = GP.globalPolicyId and ((GDSP.Flags & 256 /*CVA_SP_GLOBAL_DEDUP_FLAG*/) > 0)
LEFT JOIN archCopySIDBStore CSO ON AGC.id = CSO.CopyId AND ((CSO.Flags & (2|4)) = (2|4))
		LEFT JOIN IdxSIDBStore S ON S.SIDBStoreId = CSO.SIDBStoreId AND S.commcellId = 2
WHERE AGC.dedupeFlags & 262144 <> 0
		order by AG.name
	END
	ELSE IF @i_param IN (13,16)
	BEGIN
		IF OBJECT_ID('tempdb..#BackupTask') IS NOT NULL
			DROP TABLE #BackupTask
		CREATE TABLE #BackupTask (taskId INT, taskName NVARCHAR(255), taskType INT, disabled INT, subTaskId INT, subTaskName NVARCHAR(255), subTaskType INT)
		INSERT  INTO #BackupTask
		SELECT  DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, ST.SubTaskId, ST.subTaskName, ST.subTaskType
		FROM    TM_SubTask ST
				INNER JOIN TM_Task T
					ON T.taskId = ST.taskId AND ST.subTaskType =2	-- 1 : Storage Policy association
					AND T.deleted = 0 AND T.invalid = 0 AND T.uninstalled = 0
				INNER JOIN TM_SubTaskOptions STO
					ON STO.subTaskId = ST.SubTaskId
					AND ST.subTaskType = 2 AND STO.optionId IN (458405394) AND STO.value IN ('1', '2', '3', '4', '6', '7')
		WHERE   T.taskType IN (2, 4)
		-- taskType 4 policy
		-- taskType 2 schedule
		IF OBJECT_ID('tempdb..#TaskAssoc') IS NOT NULL
			DROP TABLE #TaskAssoc
		CREATE TABLE #TaskAssoc (taskId INT, taskName NVARCHAR(255), taskType INT, disabled INT, subTaskId INT, subTaskName NVARCHAR(255), subTaskType INT,
				assocType INT, clientGroupId INT, clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, exclude INT)
		INSERT  INTO #TaskAssoc
		SELECT  DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, T.subTaskId, ISNULL(T.subTaskName, ''), T.subTaskType,
				AE.assocType, AE.clientGroupId, AE.clientId,
				AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId ,AE.exclude
		FROM    TM_AssocEntity AE
				INNER JOIN #BackupTask T ON AE.taskId = T.taskId
		WHERE   (T.taskType = 2 OR T.taskType = 4 AND AE.assocType NOT IN (2, 28))
				AND AE.taskId NOT IN (SELECT DISTINCT taskId FROM TM_AssocFilter WHERE filter_type = 2 AND filter_value = 124)
		UNION
		SELECT  DISTINCT T.taskId, T.taskName, T.taskType, T.disabled, T.SubTaskId, T.subTaskName,T.subTaskType,
				AE.assocType, AE.clientGroupId, 0,
				CASE WHEN ISNULL(AF.filter_type, 0) = 1 THEN ISNULL(ATGA.appTypeId, 0) ELSE ISNULL(AF.filter_value, 0) END, 0, 0, 0, AE.exclude
		FROM    TM_AssocEntity AE
				INNER JOIN #BackupTask T ON AE.taskId = T.taskId AND T.taskType = 4
				LEFT OUTER JOIN TM_AssocFilter AF ON AF.taskId = T.taskId
				LEFT OUTER JOIN APP_AppTypeGroup ATG ON ATG.appTypeGroupId = AF.filter_value AND AF.filter_type = 1
				LEFT OUTER JOIN APP_AppTypeGroupAssoc ATGA ON ATGA.appGroupId = ATG.appTypeGroupId
		WHERE   AE.assocType IN (2, 28,17,18) AND (ISNULL(AF.filter_type, 0) <> 2 OR ISNULL(AF.filter_value, 0) <> 124)
		DELETE FROM #TaskAssoc WHERE (@i_param = 16 AND taskType = 4)
									 OR (@i_param = 13 AND taskType = 2)
		DECLARE @CStimezone varchar(128) = dbo.GetClientTimeZone(2)
		IF OBJECT_ID('tempdb..#TempAgentTaskAssoc') IS NOT NULL
			DROP TABLE #TempAgentTaskAssoc
		CREATE TABLE #TempAgentTaskAssoc (TaskId INT, AppTypeName VARCHAR(256))
		IF OBJECT_ID('tempdb..#TempScheduleTbl') IS NOT NULL
			DROP TABLE #TempScheduleTbl
		SELECT
			TASK.taskId,
			TASK.subTaskId,
			TASK.taskname AS schedulePolicy,
			TASK.subtaskname AS scheduleName,
			CASE CONVERT(int, SOPT.value)
				WHEN 1 THEN 'Full'
				WHEN 2 THEN 'Incremental'
				WHEN 3 THEN 'Differential'
				WHEN 4 THEN 'Synthetic Full'
				WHEN 5 THEN 'ASR'
				WHEN 6 THEN 'Transaction Log'
				WHEN 7 THEN 'Pre-Selected Backup Type'
				WHEN 8 THEN 'Snapshot'
				WHEN 9 THEN 'Create OSSV Replica(s)'
				WHEN 10 THEN 'Incrementally update OSSV volumes'
				WHEN 11 THEN 'SRM Analysis'
				WHEN 12 THEN 'SRM Discovery'
				ELSE 'Unknown'
			END AS schedBackupType,
			PAT.description,
			CASE WHEN PAT.freq_type = 128 OR PAT.freq_recurrence_factor IN (0,1) THEN ''
				 ELSE 'Every '+ CONVERT(varchar(2),PAT.freq_recurrence_factor) +
				CASE PAT.freq_type
					WHEN 4   THEN ' days on'
					WHEN 8   THEN ' weeks on'
					WHEN 16  THEN ' months on'
					WHEN 32  THEN ' months on'
					WHEN 64  THEN ' years on'
					ELSE ''
				END
			END +
			CASE WHEN PAT.freq_type IN (1,4,8) OR (PAT.freq_type NOT IN (1,4,8,64) AND PAT.freq_interval NOT BETWEEN 1 AND 10) THEN CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 )
				 ELSE ' '+
			ISNULL(CASE PAT.freq_type
				WHEN 16 THEN 'day ' + CONVERT(varchar(2), PAT.freq_interval)
				WHEN 32 THEN
					CASE PAT.freq_relative_interval
						WHEN 5 THEN 'Last'
						ELSE LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
							CASE PAT.freq_relative_interval WHEN 1 THEN 'st' WHEN 2 THEN 'nd' WHEN 3 THEN 'rd' ELSE 'th' END)
					END
					+ ' ' +
					CASE PAT.freq_interval
						WHEN 1 THEN 'Sunday'
						WHEN 2 THEN 'Monday'
						WHEN 3 THEN 'Tuesday'
						WHEN 4 THEN 'Wednesday'
						WHEN 5 THEN 'Thursday'
						WHEN 6 THEN 'Friday'
						WHEN 7 THEN 'Saturday'
						WHEN 8 THEN 'Week Day'
						WHEN 9 THEN 'Day'
						WHEN 10 THEN 'Weekend Day'
						ELSE 'Unknown'
					END
				WHEN 64 THEN
					'day '+CONVERT(varchar(2), PAT.freq_interval)
					+ ' of ' +
					CASE PAT.freq_recurrence_factor
						WHEN 1 THEN 'January'
						WHEN 2 THEN 'February'
						WHEN 3 THEN 'March'
						WHEN 4 THEN 'April'
						WHEN 5 THEN 'May'
						WHEN 6 THEN 'June'
						WHEN 7 THEN 'July'
						WHEN 8 THEN 'August'
						WHEN 9 THEN 'September'
						WHEN 10 THEN 'October'
						WHEN 11 THEN 'November'
						WHEN 12 THEN 'December'
					END
				WHEN 128 THEN
					CASE PAT.freq_relative_interval
					WHEN 5 THEN 'Last'
					ELSE LTRIM(CONVERT(char(1), (PAT.freq_relative_interval)) +
					  CASE  PAT.freq_relative_interval WHEN 1 THEN 'st' WHEN 2 THEN 'nd' WHEN 3 THEN 'rd' ELSE 'th' END)
					END
					+ ' ' +
					CASE PAT.freq_interval
						WHEN 1 THEN 'Sunday'
						WHEN 2 THEN 'Monday'
						WHEN 3 THEN 'Tuesday'
						WHEN 4 THEN 'Wednesday'
						WHEN 5 THEN 'Thursday'
						WHEN 6 THEN 'Friday'
						WHEN 7 THEN 'Saturday'
						WHEN 8 THEN 'Week Day'
						WHEN 9 THEN 'Day'
						WHEN 10 THEN 'Weekend Day'
						ELSE 'Unknown'
					END
					+ ' ' + 'of' + ' ' +
					CASE PAT.freq_recurrence_factor
						WHEN 1 THEN 'January'
						WHEN 2 THEN 'February'
						WHEN 3 THEN 'March'
						WHEN 4 THEN 'April'
						WHEN 5 THEN 'May'
						WHEN 6 THEN 'June'
						WHEN 7 THEN 'July'
						WHEN 8 THEN 'August'
						WHEN 9 THEN 'September'
						WHEN 10 THEN 'October'
						WHEN 11 THEN 'November'
						WHEN 12 THEN 'December'
					END
				ELSE ' '
			END,'')+ ' at '+CONVERT(varchar(12), DATEADD(second, PAT.active_start_time , '01/01/1970 00:00:00AM'), 108 ) +
			CASE WHEN PAT.freq_subday_interval > 0 THEN ' and repeats every '+CAST(CAST((28800/60.0/60.0) AS DECIMAL(6,1)) AS VARCHAR(10))+' hrs until '+ CONVERT(CHAR(5), DATEADD(SECOND, PAT.active_end_time, 0), 108)
				ELSE ''
			END
			END AS schedBackupTime,
			CASE WHEN PAT.freq_type = 4 THEN 1
				 WHEN PAT.freq_type = 8 AND LTRIM(t3.monday) <> '' THEN 1 ELSE 0 END AS Mon,
			CASE WHEN PAT.freq_type = 4 THEN 1
				 WHEN PAT.freq_type = 8 AND LTRIM(t3.tuesday) <> '' THEN 1 ELSE 0 END AS Tue,
			CASE WHEN PAT.freq_type = 4 THEN 1
				 WHEN PAT.freq_type = 8 AND LTRIM(t3.wednesday) <> '' THEN 1 ELSE 0 END AS Wed,
			CASE WHEN PAT.freq_type = 4 THEN 1
				 WHEN PAT.freq_type = 8 AND LTRIM(t3.thursday) <> '' THEN 1 ELSE 0 END AS Thu,
			CASE WHEN PAT.freq_type = 4 THEN 1
				 WHEN PAT.freq_type = 8 AND LTRIM(t3.friday) <> '' THEN 1 ELSE 0 END AS Fri,
			CASE WHEN PAT.freq_type = 4 THEN 1
				 WHEN PAT.freq_type = 8 AND LTRIM(t3.saturday) <> '' THEN 1 ELSE 0 END AS Sat,
			CASE WHEN PAT.freq_type = 4 THEN 1
				 WHEN PAT.freq_type = 8 AND LTRIM(t3.sunday) <> '' THEN 1 ELSE 0 END AS Sun,
			--CASE WHEN RT.nextRunTime IS NULL THEN NULL ELSE dbo.UTCToLocalTime(RT.nextRunTime, @CStimezone) END AS schedNextBackupTime,
			CASE
				WHEN TASK.clientGroupId <> 0
					THEN ACG.name
				WHEN TASK.clientid <> 0
					THEN AC.displayName
				WHEN TASK.clientGroupId = 0 AND TASK.clientid = 0 AND TASK.appTypeId = 0 AND TASK.instanceId = 0 AND TASK.backupsetId = 0 AND TASK.appId = 0
					THEN 'ALL CLIENTS'
			END AS AssociatedEntities
			INTO #TempScheduleTbl
		FROM #TaskAssoc TASK INNER JOIN TM_SubTaskOptions AS SOPT ON TASK.subTaskId = SOPT.subTaskId
			INNER JOIN TM_PatternAssoc AS PATASSOC ON PATASSOC.subTaskId = TASK.subTaskId
			INNER JOIN TM_Pattern AS PAT ON PAT.patternId = PATASSOC.patternId
			LEFT OUTER JOIN APP_ClientGroup ACG ON TASK.clientGroupId = ACG.id AND TASK.clientGroupId <> 0
			LEFT OUTER JOIN App_Client AC ON TASK.clientId = AC.id AND TASK.clientId <> 0
			LEFT OUTER JOIN TM_RunTime AS RT ON RT.patternId = PAT.patternId
			LEFT OUTER JOIN TempCvView3 t3 ON PAT.PatternId = t3.patternid
		WHERE
			SOPT.optionId = 458405394
			AND ISNULL(RT.processed, 0) = 0 AND ISNULL(RT.firing, 0) =  0
			AND TASK.exclude = 0 AND TASK.disabled = 0
		INSERT INTO #TempAgentTaskAssoc
		SELECT DISTINCT taskId,
				CASE WHEN LTRIM(RTRIM(AATG.osGroup)) = '' THEN AATG.App+' ' + CASE WHEN AATG.appGroup  = 'Granular Agents' THEN ''
																				   ELSE AATG.appGroup
																			  END
					 ELSE AATG.osGroup + ' '+ CASE WHEN AATG.appGroup = 'Granular Agents' THEN ''
												   ELSE AATG.appGroup
											  END
				END
			FROM TM_AssocFilter TF
				INNER JOIN APP_AppTypeGroup AAG
					ON TF.filter_value = AAG.appTypeGroupId AND TF.filter_type = 1 AND AAG.typeOfGroup = 0
				INNER JOIN APP_AppTypeGroupAssoc ATGA
					ON AAG.appTypeGroupId = ATGA.appGroupId
				INNER JOIN App_AppTypeGroups AATG
					ON AATG.appTypeId = ATGA.appTypeId
				WHERE TF.taskId IN (SELECT DISTINCT taskId FROM #TempScheduleTbl)
		UNION ALL
		SELECT DISTINCT taskId,
				CASE WHEN LTRIM(RTRIM(AATG.osGroup)) = '' THEN AATG.App+' ' +CASE WHEN AATG.appGroup  = 'Granular Agents' THEN ''
																				   ELSE AATG.appGroup
																			  END
					 ELSE AATG.osGroup + ' '+ CASE WHEN AATG.appGroup = 'Granular Agents' THEN ''
												   ELSE AATG.appGroup
											  END
				END
				from TM_AssocFilter TF
				INNER JOIN App_AppTypeGroups AATG
					ON TF.filter_value = AATG.appTypeId AND TF.filter_type = 2
				WHERE TF.taskId IN (SELECT DISTINCT taskId FROM #TempScheduleTbl)
		SELECT taskId,schedulePolicy,scheduleName,schedBackupType,schedBackupTime,Mon,Tue,Wed,Thu,Fri,Sat,Sun,
			STUFF((SELECT DISTINCT ','+AssociatedEntities FROM #TempScheduleTbl IT WHERE IT.taskid = T.taskId FOR XML PATH('')),1,1,'') AS AssociatedEntites,
			ISNULL(STUFF((SELECT DISTINCT ','+AppTypeName FROM #TempAgentTaskAssoc TA WHERE TA.TaskId = T.taskId FOR XML PATH('')),1,1,''),'All Agents') AS AgentTypes
		FROM #TempScheduleTbl T
		GROUP BY taskId,schedulePolicy,scheduleName,schedBackupType,schedBackupTime,Mon,Tue,Wed,Thu,Fri,Sat,Sun
		ORDER BY schedulePolicy,scheduleName
		IF OBJECT_ID('tempdb..#TempScheduleTbl') IS NOT NULL
			DROP TABLE #TempScheduleTbl
		IF OBJECT_ID('tempdb..#TempAgentTaskAssoc') IS NOT NULL
			DROP TABLE #TempAgentTaskAssoc
		IF OBJECT_ID('tempdb..#TaskAssoc') IS NOT NULL
			DROP TABLE #TaskAssoc
		IF OBJECT_ID('tempdb..#BackupTask') IS NOT NULL
			DROP TABLE #BackupTask
	END
	ELSE IF @i_param = 14		-- Vault Tracker Policy Information
	BEGIN
		select VT.PolicyName AS VTPolicyName,
		   AG.name AS StoragePolicyName,
		   AGC.name AS CopyName,
		   SIBlockSizeKB AS BlockSizeKB
		from VTPolicy VT
			INNER JOIN VTPolicyToCopy VTC ON VT.PolicyId = VTC.PolicyId
			INNER JOIN archGroup AG ON VTC.ArchGroupId = AG.id
			INNER JOIN archGroupCopy AGC ON AG.id = AGC.archGroupId
	END
	ELSE IF @i_param = 15		-- Subclient Policies
	BEGIN
		SELECT DISTINCT SubPolicy.name AS SubClientPolicyName,
			   CASE ISNULL(CAST(SubPolicyiDA.attrVal AS INT),0)
					WHEN 1 THEN 'Windows'
					WHEN 2 THEN 'Windows'
					WHEN 3 THEN 'Unix'
					WHEN 4 THEN 'Netware'
					ELSE 'Unsupported'
			   END AS iDateAgent,
			   APP.subclientName AS SubClientName,
			   AG.name AS StoragePolicyName,
			   STUFF((SELECT ';;'+fileName FROM APP_ScFilterFile SContent WHERE SContent.componentNameId = APP.id AND SContent.type=1 and SContent.modified = 0 FOR XML PATH('')),1,2,'') +
			   ISNULL(';;Excluded: '+STUFF((SELECT ';;'+fileName FROM APP_ScFilterFile SContent WHERE SContent.componentNameId = APP.id AND SContent.type=3 and SContent.modified = 0 FOR XML PATH('')),1,2,''),'') +
			   ISNULL(';;Exceptions: '+STUFF((SELECT ';;'+fileName FROM APP_ScFilterFile SContent WHERE SContent.componentNameId = APP.id AND SContent.type=2 and SContent.modified = 0 FOR XML PATH('')),1,2,''),'')
			   AS Content
		FROM APP_BackupSetProp BSP
			INNER JOIN APP_BackupSetName BS ON BSP.componentNameId = BS.id AND attrName like 'Associated subclient Policy' and BSP.modified = 0
			INNER JOIN APP_BackupSetName SubPolicy ON SubPolicy.id = BSP.attrVal
			LEFT OUTER JOIN APP_BackupSetProp SubPolicyiDA ON SubPolicyiDA.componentNameId = SubPolicy.id AND SubPolicyiDA.attrName like 'Associated subclient Policy Ida Type'
			INNER JOIN APP_Application APP ON APP.backupSet = SubPolicy.id
			INNER JOIN archGroup AG ON APP.dataArchGrpID = AG.id
	END
	ELSE IF @i_param = 17		-- Alerts created at CC level
	BEGIN
		IF OBJECT_ID('tempdb..#NotificationTypes') IS NOT NULL DROP TABLE #NotificationTypes
		CREATE TABLE #NotificationTypes(Type INT, Name NVARCHAR(MAX))
		INSERT INTO #NotificationTypes
SELECT 1, 'E-mail' UNION ALL
SELECT 4, 'SNMP' UNION ALL
SELECT 8, 'Event Viewer' UNION ALL
SELECT 16, 'Run Command' UNION ALL
SELECT 512, 'Save to Disk' UNION ALL
SELECT 1024, 'RSS' UNION ALL
SELECT 8192, 'Console Alerts' UNION ALL
SELECT 32768, 'SCOM' UNION ALL
SELECT 65536, 'Workflow'
		SELECT  N.notificationName,
			dbo.fn_EvFormatEventMsgText(0,0, C.nameID, 0, 2) AS name,
			dbo.fn_EvFormatEventMsgText(0,0, T.nameID, 0, 2) AS alertType,
			STUFF((SELECT ', '+Name FROM #NotificationTypes WHERE Type & N.notifType !=0 FOR XML PATH('')),1,2,'') NotificationMethod,
			CASE WHEN Status&1 = 0 THEN 'Enabled'
					 ELSE 'Disabled'
			END AS Status
			--,N.xmlEntityList
		FROM    NTNotificationRule N
				INNER JOIN NTCategory C ON N.categoryId=C.id
				INNER JOIN NTAlertType T ON N.alertTypeId=T.id and C.id= T.categoryId
				LEFT OUTER JOIN (SELECT NTalertTypeID FROM  NTalertNodeTypeMap GROUP BY NTalertTypeID) NTType ON NTType.NTalertTypeID = T.id
		WHERE   N.revision > 0
			AND N.status & 32 <> 32 --SRM Based alerts
			AND N.status & 64 <> 64 --ROMS Alerts
			AND C.id <> 9
			AND ( NTType.NTalertTypeID IS NULL OR
			(CASE WHEN N.xmlEntityList.exist('/CVGui_CommCellTreeNode/associations') = 1
					THEN (CASE WHEN T.id = 59 --'Client Groups'
								THEN (SELECT COUNT(*) FROM N.xmlEntityList.nodes('/CVGui_CommCellTreeNode/associations') c(n)
										WHERE ISNULL(c.n.value('@_type_','INT'),0) <> 27)
							  ELSE
								 CASE
									WHEN (SELECT COUNT(*) FROM N.xmlEntityList.nodes('/CVGui_CommCellTreeNode/associations') c(n)
												WHERE ISNULL(c.n.value('@_type_','INT'),0) IN (2,27)) = 2
										THEN (SELECT COUNT(*) FROM N.xmlEntityList.nodes('/CVGui_CommCellTreeNode/associations') c(n)
										WHERE ISNULL(c.n.value('@_type_','INT'),0) NOT IN (2,10,25,27,42,43,34,95,113))
									ELSE
										(SELECT COUNT(*) FROM N.xmlEntityList.nodes('/CVGui_CommCellTreeNode/associations') c(n)
										WHERE ISNULL(c.n.value('@_type_','INT'),0) NOT IN (2,10,25,42,43,34,95,113))
								 END
							END)
			 ELSE CASE WHEN ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/clients/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/clientGroups/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/libraries/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/mediaAgents/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/storagePolcies/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/trackingPolicies/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/trackingSchedules/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/trackingJobs/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/criterias/@includeAll)[1]','INT'),0) +
				  ISNULL(N.xmlEntityList.value('(/CVGui_CommCellTreeNode/workflows/@includeAll)[1]','INT'),0) > 0
					THEN 0
					   ELSE 1
				  END
			 END) = 0
			 )
		ORDER BY N.notificationName
		IF OBJECT_ID('tempdb..#NotificationTypes') IS NOT NULL DROP TABLE #NotificationTypes
	END
	ELSE IF @i_param = 18 -- Cloud Library Information
	BEGIN
		IF OBJECT_ID('tempdb..#CloudTypes') IS NOT NULL DROP TABLE #CloudTypes
		CREATE TABLE #CloudTypes (DeviceTypeId INT, CloudTypeString NVARCHAR(MAX))
		INSERT INTO #CloudTypes
SELECT 2, 'Amazon S3'
				UNION ALL
SELECT 3, 'Microsoft Azure Storage'
				UNION ALL
SELECT 4, 'Nirvanix MFS'
				UNION ALL
SELECT 5, 'Rackspace Cloud Files'
				UNION ALL
SELECT 6, 'Iron Mountain ASP'
				UNION ALL
SELECT 7, 'Sun Cloud Storage'
				UNION ALL
SELECT 8, 'i365 Cloud Storage'
				UNION ALL
SELECT 9, 'EMC Atmos'
				UNION ALL
SELECT 10, 'AT&T Synaptic Storage'
				UNION ALL
SELECT 63, 'Network Files'
				UNION ALL
SELECT 11, 'Object Server'
				UNION ALL
SELECT 12, 'Hitachi Content Platform'
				UNION ALL
SELECT 13, 'Mezeo Cloud Storage'
				UNION ALL
SELECT 51, 'Caringo CAStor'
				UNION ALL
SELECT 52, 'Dell DX Object Storage Platform'
				UNION ALL
SELECT 14, 'OpenStack Object Storage'
				UNION ALL
SELECT 15, 'Quantum ActiveScale'
				UNION ALL
SELECT 54, 'DDN WOS'
				UNION ALL
SELECT 16, 'China Mobile oNest'
				UNION ALL
SELECT 18, 'Verizon Cloud Storage'
				UNION ALL
SELECT 19, 'Google Cloud Storage'
				UNION ALL
SELECT 20, 'VMware vCloud Air Object Storage'
				UNION ALL
SELECT 21, 'Oracle Cloud Infrastructure Object Storage Classic'
				UNION ALL
SELECT 22, 'Oracle Cloud Infrastructure Archive Storage Classic'
				UNION ALL
SELECT 23, 'Alibaba Cloud Object Storage Service'
				UNION ALL
SELECT 24, 'Huawei Object Storage'
				UNION ALL
SELECT 53, 'Amazon Glacier'
				UNION ALL
SELECT 25, 'Oracle Cloud Infrastructure Object Storage (S3 Compatibility)'
				UNION ALL
SELECT 26, 'Oracle Cloud Infrastructure Object Storage'
				UNION ALL
SELECT 28, 'Oracle Cloud Infrastructure Archive Storage'
				UNION ALL
SELECT 27, 'Telefonica Open Cloud Object Storage'
				UNION ALL
SELECT 29, 'Inspur Cloud Object Storage'
				UNION ALL
SELECT 30, 'IBM Cloud Object Storage'
				UNION ALL
SELECT 31, 'Microsoft Data Lake Store'
				UNION ALL
SELECT 32, 'Kingsoft Standard Storage Service'
				UNION ALL
SELECT 33, 'Microsoft OneDrive'
				UNION ALL
SELECT 34, 'Iron Mountain Iron Cloud'
				UNION ALL
SELECT 35, 'Microsoft File Share'
				UNION ALL
SELECT 36, 'Microsoft Data Lake Store Gen 2'
				UNION ALL
SELECT 59, 'HPE Catalyst Storage'
				UNION ALL
SELECT 200, 'Ceph Object Gateway (S3-compatible)'
				UNION ALL
SELECT 201, 'Cloudian HyperStore'
				UNION ALL
SELECT 202, 'Dell EMC ECS (S3-compatible)'
				UNION ALL
SELECT 203, 'Fujitsu Storage ETERNUS CD10000'
				UNION ALL
SELECT 204, 'Hitachi Content Platform for Cloud Scale'
				UNION ALL
SELECT 205, 'IBM Cloud Object Storage (S3-compatible)'
				UNION ALL
SELECT 206, 'NetApp StorageGRID'
				UNION ALL
SELECT 207, 'CL Vault v2'
				UNION ALL
SELECT 208, 'Scality RING'
				UNION ALL
SELECT 209, 'Wasabi Hot Cloud Storage'
				UNION ALL
SELECT 210, 'Nutanix Objects'
				UNION ALL
SELECT 400, 'Metallic Cloud Storage'
		SELECT
			AC.displayName AS MAName,
			L.AliasName AS LibName,
			ISNULL(C.CloudTypeString, 'Invalid Cloud Type') AS Type,
CASE WHEN (M.Attribute & 32) = 0 THEN 'No' ELSE 'Yes' END AS MicroPruningEnabled,
			M.MountPathName AS MountPathName
		FROM MMS2getMountPathNameGUIView M
			INNER JOIN MMDevice D ON M.DeviceId = D.DeviceId
			INNER JOIN MMLibrary L ON M.LibraryId = L.LibraryId
			INNER JOIN MMLibraryController LC ON LC.LibraryId = M.LibraryId
			INNER JOIN App_CLient AC ON AC.id = LC.ClientId
			LEFT OUTER JOIN #CloudTypes C ON D.DisplayDeviceTypeId = C.DeviceTypeId
		WHERE M.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
		IF OBJECT_ID('tempdb..#CloudTypes') IS NOT NULL DROP TABLE #CloudTypes
	END
	ELSE IF @i_param = 19		-- Administrative Storage Policies
	BEGIN
		IF OBJECT_ID('tempdb..#AdminSPs') IS NOT NULL DROP TABLE #AdminSPs
		CREATE TABLE #AdminSPs (adminArchGrpId INT)
		INSERT INTO #AdminSPs
			SELECT DISTINCT A.dataArchGrpId
			FROM APP_Application A
				LEFT OUTER JOIN APP_subclientProp DDB ON A.id = DDB.componentNameId AND DDB.cs_attrName = checksum(N'DDB Backup')
				LEFT OUTER JOIN APP_subclientProp IDX ON A.id = IDX.componentNameId AND IDX.cs_attrName = checksum(N'Index SubClient')
			WHERE A.appTypeId=1000 OR DDB.componentNameId IS NOT NULL OR IDX.componentNameId IS NOT NULL
		SELECT
			AG.name AS 'policyName',
			AGC.name AS 'copyName',
			CAST(CASE WHEN AGC.maxStreamNum > 0 THEN AGC.maxStreamNum
				 ELSE AG.maxStreams
			END AS VARCHAR(10)) +
			CASE WHEN AGC.maxMultiplex > 0 THEN '/'+CAST(maxMultiplex AS VARCHAR(10))
				 ELSE ''
			END 'Streams/Multiplex',
			CASE WHEN AR.retentionDays = -1 AND AR.fullCycles = -1 THEN 'Infinite'
				 WHEN AR.retentionDays = 0 AND AR.fullCycles = 0 THEN 'Spool'
				 ELSE CASE WHEN AR.retentionDays < 1 THEN ''
						   WHEN AR.retentionDays = 1 THEN CAST(AR.retentionDays AS VARCHAR(10))+' day'
						   ELSE CAST(AR.retentionDays AS VARCHAR(10))+' days'
					  END + CASE WHEN AR.retentionDays >= 1 AND AR.fullCycles >= 1 THEN '/'  ELSE '' END +
					  CASE WHEN AR.fullCycles < 1 THEN ''
						   WHEN AR.fullCycles = 1 THEN CAST(AR.fullCycles AS VARCHAR(10))+' cycle'
						   ELSE CAST(AR.fullCycles AS VARCHAR(10))+' cycles'
					  END
			END AS 'retention',
			ISNULL(STUFF((SELECT ';'+(CASE WHEN ARE.retentionRule IS NOT NULL
					THEN (CASE ARE.retentionDays
							WHEN -1 THEN 'Infinite '
							ELSE CAST(ARE.retentionDays AS VARCHAR(10))+' days '
						  END) +
						  (CASE ARE.retentionRule
							WHEN 2 THEN 'All Fulls'
							WHEN 4 THEN 'Weekly Full'
							WHEN 8 THEN 'Monthly Full'
							WHEN 16 THEN 'Quaterly Full'
							WHEN 32 THEN 'Half Yearly Full'
							WHEN 64 THEN 'Yearly Full'
						   END)
			END) FROM archAgingRuleExtended ARE WHERE ARE.copyId = AGC.id FOR XML PATH('')),1,1,''),'') AS extRretentionRules,
			AC.displayName + ' : '+L.ALiasName + ISNULL(':'+S.SpareGroupName,'') AS Datapath,
			SIDB.SIDBStoreAliasName  AS DDBEngine
		FROM
			archGroup AG
			INNER JOIN #AdminSPs A ON A.adminArchGrpId = AG.id
			INNER JOIN archGroupCopy AGC ON AGC.archGroupId = AG.id
			INNER JOIN MMDataPath D ON D.copyId = AGC.id
			INNER JOIN MMDrivePool DPL ON D.DrivePoolId = DPL.DrivePoolId
			INNER JOIN MMMasterPool MPL ON DPL.MasterPoolId = MPL.MasterPoolId
			INNER JOIN MMLibrary L ON MPL.LibraryId = L.LibraryId
			INNER JOIN APP_Client AC ON D.HostClientId = AC.id
			LEFT OUTER JOIN MMSpareGroup S ON S.SpareGroupId = D.SpareGroupId AND S.LibraryId = L.LibraryId
			LEFT OUTER JOIN archAgingRule AR ON AR.copyId = AGC.id
LEFT OUTER JOIN archCopySIDBStore CS ON CS.copyId = AGC.id AND ((CS.Flags & (2|4)) = (2|4))
			LEFT OUTER JOIN IdxSIDBStore SIDB ON SIDB.SIDBStoreId = CS.SIDBStoreId AND SIDB.commcellId = 2
		WHERE
			AG.type IN (1, 2) AND AGC.type IN (1, 2) AND D.Flag & 1 = 1 -- Default Data Path
		ORDER BY AG.name, AGC.name
	END
	ELSE IF @i_param = 20 --Client Group Info
	BEGIN
		SELECT
			name AS CGName,
			description,
CASE WHEN (flag & 0x1000) !=0 THEN 'Automatic Association' ELSE 'Manual Associaton' END AS AutoOrManualAssoc,
(SELECT ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  28 AND deleted = 0 AND enabled = 1 AND entityId = CG.id for XML PATH('')), 1, 2, ''),'None')) AS AdditionalSettings
		FROM APP_ClientGroup CG
WHERE (status & (2|4|16|32)) = 0 --(0x00002 | 0x00004 | 0x00010 | 0x00020)
		ORDER BY name
	END
	ELSE IF @i_param = 21 --Report Schedules
	BEGIN
		IF OBJECT_ID('tempdb..#ReportTypeNames') IS NOT NULL DROP TABLE #ReportTypeNames
		CREATE TABLE #ReportTypeNames (type INT, name NVARCHAR(MAX))
		INSERT INTO #ReportTypeNames
SELECT 7705,                           'Event Report' UNION ALL
SELECT 7715,                  'Backup Job Summary Report' UNION ALL
SELECT 7720,                 'Restore Job Summary Report' UNION ALL
SELECT 7775,                'Auxiliary Copy Job Summary Report' UNION ALL
SELECT 7785,              'Data Aging Job Summary Report' UNION ALL
SELECT 7790,            'Disaster Recovery Backup Job Summary Report' UNION ALL
SELECT 7740,       'Library and Drive Report' UNION ALL
SELECT 7750,           'Disaster Recovery Backup Job Summary Report' UNION ALL
SELECT 7780,                'Data on Media and Data Aging Forecast' UNION ALL
SELECT 7770,              'NAS NDMP Backup Archives Report' UNION ALL
SELECT 7795,                     'Job Summary Report' UNION ALL
SELECT 7784,                   'Administrative Job Summary Report' UNION ALL
SELECT 7796,                     'Jobs in Storage Policy Copies Report' UNION ALL
SELECT 7731,             'CommCell Configuration Report' UNION ALL
SELECT 7797,                         'License Summary Report' UNION ALL
SELECT 7798,                       'Audit Trail Report' UNION ALL
SELECT 7716,                     'OSSV Replica Creation Job Summary Report' UNION ALL
SELECT 7717,                       'Archive/Compliance Archive Job Summary Report' UNION ALL
SELECT 7718,                     'OSSV Recovery Job Summary Report' UNION ALL
SELECT 7719,                     'Recovery/Retrieve Job Summary Report' UNION ALL
SELECT 7714,          'Calendar Backup Job Summary Report' UNION ALL
SELECT 7710,                   'Job Schedule - Interval Report' UNION ALL
SELECT 7711,                'Job Schedule - List Report' UNION ALL
SELECT 7721,              'Calendar Archive/Compliance Archive Job Summary Report' UNION ALL
SELECT 7723,                     'Calendar OSSV Job Summary Report' UNION ALL
SELECT 7799,                 'User Capability Report' UNION ALL
SELECT 7766,                      'Storage Information Report' UNION ALL
SELECT 7767,          'Vault Tracking Report' UNION ALL
SELECT 7765,                    'Exportable Media Report' UNION ALL
SELECT 7786,              'Data Verification Job Summary Report' UNION ALL
SELECT 7736,         'Exchange Mailbox Archiver Data Aging History Report' UNION ALL
SELECT 7791,              'CommCell Readiness Report' UNION ALL
SELECT 7756,                    'Scratch Pool Report' UNION ALL
SELECT 7782,            'Download Updates Job Summary Report' UNION ALL
SELECT 7783,           'Install/Remove Updates Job Summary Report' UNION ALL
SELECT 7792,                'ContinuousDataReplicator Job Summary Report' UNION ALL
SELECT 7733,                'CDR Recovery Job Summary Report' UNION ALL
SELECT 7732,                'Stub Recall Job Summary Report' UNION ALL
SELECT 7713,                 'CommCell Growth Report' UNION ALL
SELECT 7737,                   'Jobs On Media Report' UNION ALL
SELECT 7738,         'Data Retention Forecast and Compliance Report' UNION ALL
SELECT 7739,      'Data Retention Forecast and Compliance Report' UNION ALL
SELECT 7787,        'Offline Content Indexing Job Summary Report' UNION ALL
SELECT 7788,         'Online Content Indexing Job Summary Report' UNION ALL
SELECT 7789,          'Search Restore Job Summary Report' UNION ALL
SELECT 7761,              'Media Prediction Report' UNION ALL
SELECT 7741,          'Backup Copy Workflow Job Summary Report' UNION ALL
SELECT 7742,    'Disk Library Maintenance Job Summary Report' UNION ALL
SELECT 7746,            'Information Management Job Summary Report' UNION ALL
SELECT 7758,                    'SILO Archive Job Summary Report' UNION ALL
SELECT 7759,                   'SILO Retrieve Job Summary Report' UNION ALL
SELECT 7757,       'Erase Backup/Archived Data Job Summary Report' UNION ALL
SELECT 7762,            'Media Refresh Job Summary Report' UNION ALL
SELECT 7776,           'Review Set posting Report' UNION ALL
SELECT 7777,          'Review Set Activity Report' UNION ALL
SELECT 7778,           'Legal Hold Summary Report' UNION ALL
SELECT 7779,             'Search Activity Report' UNION ALL
SELECT 7781,               'Chain of Custody Report' UNION ALL
SELECT 7793,           'Review Set Summary Report' UNION ALL
SELECT 7751,                 'CommCell Export Job Summary Report' UNION ALL
SELECT 7752,                 'CommCell Import Job Summary Report' UNION ALL
SELECT 7771,     'Install/Upgrade/Remove Software Job Summary Report' UNION ALL
SELECT 7794, 'Reconstruct Dedupe Database Job Summary Report' UNION ALL
SELECT 8001,         'Catalogue Media Job Summary Report' UNION ALL
SELECT 8002,           'Virtual Machine Management Job Summary Report' UNION ALL
SELECT 8003,                 'Archive Summary Report' UNION ALL
SELECT 8005,           'Virtualize Me Job Summary Report' UNION ALL
SELECT 8010,                             'File Level Analytics Report' UNION ALL
SELECT 8004,                  'Send Log Files Job Summary Report' UNION ALL
SELECT 8006,                   'EDC Discovery Job Summary Report' UNION ALL
SELECT 8007,                  'Log Monitoring Report' UNION ALL
SELECT 8009,                         'Report Job Summary Report' UNION ALL
SELECT 8011,                        'Workflow Report' UNION ALL
SELECT 8012,                             'Scheduled Web Report' UNION ALL
SELECT 8013,                  'Data Analytics Job Summary Report' UNION ALL
SELECT 8014,                     'Live Sync Job Summary Report' UNION ALL
SELECT 8015,                     'Log Monitoring Report'
		DECLARE @ScheduleResultTable TABLE (result XML)
		DECLARE @ReportSchedulesXML XML
		INSERT INTO @ScheduleResultTable
EXEC TM_GetTaskList @i_userid, 0, '<TMMsg_GetTaskListReq><filter isCalendar="0" policy="1" schedules="1"><operationTypes val="4004"/></filter></TMMsg_GetTaskListReq>'
		SELECT TOP 1 @ReportSchedulesXML = result FROM @ScheduleResultTable
		SELECT
			R.S.value('subTasks[1]/subTask[1]/@subTaskName', 'nvarchar(max)') AS ScheduleName,
CASE WHEN ISNULL(R.S.value('subTasks[1]/options[1]/adminOpts[1]/reportOption[1]/commonOpt[1]/@reportType', 'int'), 0) = 8012 THEN 'Web Report' ELSE 'CommCell Report' END AS Category,
CASE WHEN ISNULL(R.S.value('subTasks[1]/options[1]/adminOpts[1]/reportOption[1]/commonOpt[1]/@reportType', 'int'), 0) = 8012
				THEN ISNULL(R.S.value('subTasks[1]/options[1]/adminOpts[1]/reportOption[1]/webReportOption[1]/@filePrefix', 'nvarchar(max)'), '')
				ELSE ISNULL(n.name, '')
			END AS ReportType,
			CASE WHEN ISNULL(R.S.value('task[1]/taskFlags[1]/@disabled', 'int'), 0) = 0 THEN 'Enabled' ELSE 'Disabled' END AS Status,
			CASE ISNULL(R.S.value('subTasks[1]/options[1]/adminOpts[1]/reportOption[1]/commonOpt[1]/@emailType', 'int'), 0)
WHEN 1 THEN 'Embedded'
WHEN 2 THEN 'Attachment'
WHEN 3 THEN 'Compressed Attachment'
						ELSE 'None'
					END AS NotificationMethod
		FROM @ReportSchedulesXML.nodes('//TMMsg_GetTaskListResp/taskDetail') AS R(S)
			LEFT OUTER JOIN #ReportTypeNames N ON N.type = ISNULL(R.S.value('subTasks[1]/options[1]/adminOpts[1]/reportOption[1]/commonOpt[1]/@reportType', 'int'), 0)
		IF OBJECT_ID('tempdb..#ReportTypeNames') IS NOT NULL DROP TABLE #ReportTypeNames
	END
	ELSE IF @i_param = 22 --Internet Connectivity
	BEGIN
		DECLARE @UseHttpProxy INT = 0
		SELECT @UseHttpProxy = CAST(value AS INT) FROM GXGlobalParam where name = 'SendLogsUseHTTPProxy'
		SELECT 'Internet Gateway' AS 'Option', @InternetGateway AS 'Value' UNION ALL
		SELECT 'Download Software Protocol', value FROM GXGlobalParam where name = 'Patch Download Protocol' UNION ALL
		SELECT 'Use HTTP Proxy', CASE WHEN @UseHttpProxy = 1 THEN 'Yes' ELSE 'No' END UNION ALL
		SELECT 'HTTP Proxy Server', value FROM GXGlobalParam where @UseHttpProxy = 1 and name = 'SendLogsHTTPProxySite' UNION ALL
		SELECT 'HTTP Proxy Port', value FROM GXGlobalParam where @UseHttpProxy = 1 and name = 'SendLogsHTTPProxyPort' UNION ALL
		SELECT 'HTTP Proxy User', value FROM GXGlobalParam where @UseHttpProxy = 1 and name = 'SendLogsHTTPProxyUser'
	END
	ELSE IF @i_param = 23 --Cloud Metrics Reporting
	BEGIN
		DECLARE @clientGroupIdStr NVARCHAR(MAX), @clientGroupNameStr NVARCHAR(MAX) = ''
		SELECT @clientGroupIdStr = value FROM GXGlobalParam where name = 'CommservSurveySpecialClientGroup' and modified = 0
		IF (ISNULL(@clientGroupIdStr, '-1') = '-1')
		BEGIN
			SET @clientGroupNameStr = 'All Client Groups'
		END
		ELSE
		BEGIN
			SET @clientGroupIdStr = @clientGroupIdStr + ','
			DECLARE @endIndex integer=0
			DECLARE @startIndex integer=0
			DECLARE @groupId integer
			SET @endIndex = CHARINDEX(',', @clientGroupIdStr, @startIndex)
			WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
			BEGIN
				SET @groupId = CAST(SUBSTRING(@clientGroupIdStr,@startIndex,@endIndex-@startIndex) AS INT)
				if(@groupId > 0)
				BEGIN
					DECLARE @tmpStr NVARCHAR(100);
					SELECT @tmpStr = NAME FROM APP_ClientGroup WHERE id = @groupId;
					IF(@tmpStr IS NOT NULL)
						SET @clientGroupNameStr = @clientGroupNameStr + CASE WHEN LEN(@clientGroupNameStr) > 0 THEN ', ' ELSE '' END + @tmpStr
				END
				SET @startIndex = @endIndex + 1
				SET @endIndex = CHARINDEX(',', @clientGroupIdStr, @startIndex)
			END
		END
		SELECT displayName AS 'Option', CASE WHEN isEnabled & 1 = 1 THEN 'Enabled' ELSE 'Disabled' END AS 'Value' FROM CloudMonitoringService UNION ALL
		SELECT 'Client Groups', @clientGroupNameStr UNION ALL
		SELECT 'Data Collection Time', RIGHT('00' + CAST(CAST(value AS INT)/3600 AS NVARCHAR(MAX)), 2) + ':' + RIGHT('00' + CAST((CAST(value AS INT)/60)%60 AS NVARCHAR(MAX)), 2) FROM GXGlobalParam where name = 'CommservSurveyCollectionWindow' AND modified = 0 UNION ALL
		SELECT 'Data Collection Frequency', value + ' Days' FROM GXGlobalParam where name = 'CommservSurveyUploadFreqDays' AND modified = 0
	END
	ELSE IF @i_param = 24 --Security - Roles
	BEGIN
		DECLARE @RoleDetailsXML XML = '<Security_GetRolesPropertiesRequest listPropertyLevel="10"/>'
		EXEC sec_getRoleDetailList @RoleDetailsXML OUTPUT
		SELECT role.prop.value('(role/@roleName)[1]', 'nvarchar(max)') AS RoleName,
			role.prop.value('@description', 'nvarchar(max)') AS RoleDescription,
			CASE role.prop.value('(role/flags/@disabled)[1]', 'INT')
				WHEN 0 THEN 'Enabled'
				ELSE 'Disabled'
			END AS Status
		FROM @RoleDetailsXML.nodes('//Security_GetRolesPropertiesResponse/roleProperties') as role(prop)
		ORDER BY role.prop.value('(role/@roleName)[1]', 'nvarchar(max)')
	END
	ELSE IF @i_param = 25 --Security - Domain User Groups
	BEGIN
		SELECT G.id,
			P.domainName,
			G.name AS ADGroup,
(SELECT ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  15 AND deleted = 0 AND enabled = 1 AND entityId = G.id for XML PATH('')), 1, 2, ''),'None')) AS AdditionalSettings
		FROM UMDSProviders P
			INNER JOIN UMDSgroups G ON G.umdsProviderId = P.id
WHERE P.serviceType <> 5 and P.serviceType <> 11 AND P.enabled = 1 and G.enabled = 1
	END
	ELSE IF @i_param = 26 --Security - Commcell Users
	BEGIN
		DECLARE @UsersResultTable TABLE (result XML)
		DECLARE @UsersXML XML
		DECLARE @i_xml nvarchar(max) = '<App_GetUserPropertiesRequest level="10"><processinginstructioninfo><user _type_="13" userId="'+CAST(@i_userId AS NVARCHAR(MAX))+'"/></processinginstructioninfo></App_GetUserPropertiesRequest>'
		INSERT INTO @UsersResultTable
		EXEC sec_getUsersNew @i_xml
		SELECT TOP 1 @UsersXML = result FROM @UsersResultTable
		IF OBJECT_ID('tempdb..#Users') IS NOT NULL DROP TABLE #Users
		CREATE TABLE #Users (userId INT, UserName NVARCHAR(MAX))
		IF OBJECT_ID('tempdb..#UserGroups') IS NOT NULL DROP TABLE #UserGroups
		CREATE TABLE #UserGroups (userId INT, GroupNames NVARCHAR(MAX))
		IF OBJECT_ID('tempdb..#userGroupId') IS NOT NULL DROP TABLE #userGroupId
		CREATE TABLE #userGroupId (userGroupId INT)
		INSERT INTO #Users (userId, userName)
		SELECT
			U.users.value('userEntity[1]/@userId', 'INT'),
			U.users.value('userEntity[1]/@userName', 'NVARCHAR(MAX)')
		FROM @UsersXML.nodes('//App_GetUserPropertiesResponse/users') U(users)
			OUTER APPLY U.users.nodes('associatedUserGroups') G(groups)
		DECLARE @selectedUserId INT
		DECLARE userCursor CURSOR FOR SELECT userId FROM #Users
		OPEN userCursor
		FETCH NEXT FROM userCursor INTO @selectedUserId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			TRUNCATE TABLE #userGroupId
			INSERT INTO #userGroupId
			EXEC sec_getMemberUserGroups @selectedUserId
			INSERT INTO #UserGroups
			SELECT @selectedUserId, ISNULL(STUFF((SELECT ', ' + G.name FROM UMGroups G INNER JOIN #userGroupId T ON T.userGroupId = G.id FOR XML PATH('')), 1, 2, ''), '')
			FETCH NEXT FROM userCursor INTO @selectedUserId
		END
		CLOSE userCursor
		DEALLOCATE userCursor
		IF OBJECT_ID('tempdb..#userGroupId') IS NOT NULL DROP TABLE #userGroupId
		SELECT U.userId,
			U.UserName AS UserName,
			G.GroupNames AS AssocGroup,
(SELECT ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  13 AND deleted = 0 AND enabled = 1 AND entityId = U.userId for XML PATH('')), 1, 2, ''),'None')) AS AdditionalSettings
		FROM #Users U
			INNER JOIN #UserGroups G ON U.userId = G.userId
		IF OBJECT_ID('tempdb..#Users') IS NOT NULL DROP TABLE #Users
		IF OBJECT_ID('tempdb..#UserGroups') IS NOT NULL DROP TABLE #UserGroups
	END
	ELSE IF @i_param = 27 --Hypervisor Protection
	BEGIN
		IF OBJECT_ID('tempdb..#HypervisorProtection') IS NOT NULL DROP TABLE #HypervisorProtection
		CREATE TABLE #HypervisorProtection (instanceId INT, ClientName NVARCHAR(MAX), InstanceName NVARCHAR(MAX), Proxies NVARCHAR(MAX))
		INSERT INTO #HypervisorProtection
		SELECT DISTINCT A.instance, C.displayName, I.name, ''
		FROM APP_Application A
			INNER JOIN APP_InstanceName I ON A.instance = I.id
			INNER JOIN APP_Client C ON C.id = A.clientId
WHERE A.appTypeId = 106 AND dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1
		IF OBJECT_ID('tempdb..#InstanceProxies') IS NOT NULL DROP TABLE #InstanceProxies
		CREATE TABLE #InstanceProxies(instanceId INT, Proxy NVARCHAR(MAX))
		INSERT INTO #InstanceProxies
		SELECT I.instanceId, CL.displayName
		FROM #HypervisorProtection I
			CROSS APPLY (SELECT CAST(attrVal AS XML) AS MemberServersXML FROM APP_InstanceProp WHERE componentNameId = I.instanceId AND attrName = 'Vs Member Servers' AND modified = 0) AS MS
			CROSS APPLY MS.MemberServersXML.nodes('//App_MemberServers/memberServers/client') AS M(C)
			INNER JOIN APP_Client CL ON M.C.value('@clientId', 'INT') = CL.id
WHERE M.C.value('@_type_', 'INT') = 3
		UNION ALL
		SELECT I.instanceId, CL.name
		FROM #HypervisorProtection I
			CROSS APPLY (SELECT CAST(attrVal AS XML) AS MemberServersXML FROM APP_InstanceProp WHERE componentNameId = I.instanceId AND attrName = 'Vs Member Servers' AND modified = 0) AS MS
			CROSS APPLY MS.MemberServersXML.nodes('//App_MemberServers/memberServers/client') AS M(C)
			INNER JOIN APP_ClientGroup CL ON M.C.value('@clientGroupId', 'INT') = CL.id
WHERE M.C.value('@_type_', 'INT') = 28
		UPDATE #HypervisorProtection
		SET Proxies = STUFF((SELECT ', ' + Proxy FROM #InstanceProxies I WHERE I.instanceId = #HypervisorProtection.instanceId FOR XML PATH('')), 1, 2, '')
		SELECT clientName, InstanceName, ISNULL(Proxies, ''), Proxies FROM #HypervisorProtection
		IF OBJECT_ID('tempdb..#HypervisorProtection') IS NOT NULL DROP TABLE #HypervisorProtection
		IF OBJECT_ID('tempdb..#InstanceProxies') IS NOT NULL DROP TABLE #InstanceProxies
	END
	ELSE IF @i_param = 28 -- Active clients
	BEGIN
		SELECT CL.id, CL.displayName AS ClientName,
(SELECT ISNULL(STUFF((SELECT DISTINCT ', ' + APP_IDAType.displayName								FROM licUsage licUsage WITH(NOLOCK)									INNER JOIN APP_IDAType APP_IDAType WITH(NOLOCK) ON licUsage.appType = APP_IDAType.type								WHERE licUsage.opType = 'Install' AND licUsage.appType < 1000 AND licUsage.licType NOT IN (10, 26, 71) AND licUsage.cid = CL.id								FOR XML PATH('')), 1, 2, ''), 'None'))AS AgentsInstalled
		FROM APP_Client CL
WHERE CL.id > 1 AND status & 0x00002 = 0
		ORDER BY CL.displayName
	END
	ELSE IF @i_param = 29 -- Search Engine Nodes
	BEGIN
		IF OBJECT_ID('tempdb..#FastServers') IS NOT NULL DROP TABLE #FastServers
		CREATE TABLE #FastServers(serverName NVARCHAR(MAX), clientId INT, clientName NVARCHAR(MAX), cloudId INT, hostName NVARCHAR(MAX), baseport INT, version NVARCHAR(MAX), engineName NVARCHAR(MAX), serverType INT)
		INSERT INTO #FastServers
		EXEC AppGetFastServerList
		SELECT SE.SEClientId,SE.SEName,[Params],[values] FROM (
			SELECT F.clientId AS SEClientId,
			CL.displayName AS SEName,
			F.hostname AS HostName,
			dbo.GetClientOSName(CL.id,NULL) AS OSName,
			R.release+'.0' AS Release,
			CASE WHEN V.attrVal IS NULL OR CHARINDEX(' SP',V.attrVal) = 0 THEN 'N/A'
				ELSE SUBSTRING(V.attrVal,CHARINDEX(' SP',V.attrVal)+3,LEN(V.attrVal))
			END AS ServicePackVersion,
			(select P.attrVal from APP_ClientProp P where P.attrName = 'Patch Local Location' and P.componentNameId = CL.id AND P.modified = 0) InstallFolderLocation
		FROM    (SELECT DISTINCT ClientId, hostName FROM  #FastServers) F
				INNER JOIN APP_Client CL ON CL.id = F.ClientId AND CL.id > 1
				INNER JOIN simAllGalaxyRel R ON R.id = CL.releaseId
				LEFT OUTER JOIN APP_ClientProp V ON V.componentNameId = CL.id AND V.attrName = 'SP Version Info' AND V.modified = 0
		) SE
		CROSS APPLY
		(
			SELECT 'Search Engine', ISNULL((STUFF((SELECT ', ' + EngineName FROM #FastServers WHERE clientId = SE.SEClientId FOR XML PATH('')), 1, 2, '')), '') UNION ALL
			SELECT 'Search Engine Node Client Name', SEName UNION ALL
SELECT 'Search Engine Node Type', (SELECT TOP 1 CASE WHEN C.CoreRoles & 1 != 0 OR C.CoreRoles & 4 != 0 THEN 'CDS' + ' ' ELSE '' END +
CASE WHEN C.CoreRoles & 2 != 0 OR C.CoreRoles & 4 != 0 THEN 'QPS' + ' ' ELSE '' END +
CASE WHEN C.CoreRoles & 4 != 0 THEN 'Admin' + ' ' ELSE '' END +
CASE WHEN C.CoreRoles & 8 != 0 THEN 'Search' + ' ' ELSE '' END +
CASE WHEN C.CoreRoles & 16 != 0 THEN 'Index' + ' ' ELSE '' END +
CASE WHEN C.CoreRoles & 32 != 0 THEN 'Metadata store' + ' ' ELSE '' END +
CASE WHEN C.CoreRoles & 64 != 0 THEN 'Extended store' + ' ' ELSE '' END AS ServerType
										FROM DM2SearchServerCoreInfo C
											INNER JOIN #FastServers F ON F.cloudId = C.cloudId AND F.ClientId = C.ClientId AND SE.SEClientId = F.ClientId
										) UNION ALL
			SELECT 'Search Engine Node HostName', HostName UNION ALL
			SELECT 'Operating System', OSName UNION ALL
			SELECT 'Commvault Version', Release UNION ALL
			SELECT 'Feature Release', ServicePackVersion UNION ALL
SELECT 'Agents Installed', (SELECT ISNULL(STUFF((SELECT DISTINCT ', ' + APP_IDAType.displayName								FROM licUsage licUsage WITH(NOLOCK)									INNER JOIN APP_IDAType APP_IDAType WITH(NOLOCK) ON licUsage.appType = APP_IDAType.type								WHERE licUsage.opType = 'Install' AND licUsage.appType < 1000 AND licUsage.licType NOT IN (10, 26, 71) AND licUsage.cid = SE.SEClientId								FOR XML PATH('')), 1, 2, ''), 'None')) UNION ALL
			SELECT 'Install Folder Location', InstallFolderLocation UNION ALL
			SELECT 'Content Index Path', ISNULL((SELECT attrVal FROM APP_ClientProp WHERE ComponentNameId = SE.SEClientId AND attrName = 'FAST_index-dir' AND modified = 0), '') UNION ALL
SELECT 'Additional Settings', (SELECT ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  3 AND deleted = 0 AND enabled = 1 AND entityId = SE.SEClientId for XML PATH('')), 1, 2, ''),'None'))
		)C([Params],[values])
		ORDER BY SEName
		IF OBJECT_ID('tempdb..#FastServers') IS NOT NULL DROP TABLE #FastServers
	END
	ELSE IF @i_param = 30 -- Index Servers
	BEGIN
		DECLARE @cloudId INT
		IF OBJECT_ID('tempdb.dbo.#IndexLocation') IS NOT NULL DROP TABLE #IndexLocation
		CREATE TABLE #IndexLocation (cloudId INT, propName NVARCHAR(255), IndexLocation NVARCHAR(255))
		IF OBJECT_ID('tempdb.dbo.#indexServer') IS NOT NULL DROP TABLE #indexServer
		CREATE TABLE #indexServer (
				cloudId INT,
				IndexServerName NVARCHAR(255),
				NodeClientId INT,
				indexDirectory NVARCHAR(255)
			)
		--get legacy & cluster index servers
		INSERT INTO #indexServer (cloudId, IndexServerName, nodeClientId)
		SELECT DC.cloudId, PC.displayName, core.clientId
		FROM DM2Cloud DC
			INNER JOIN APP_Client PC ON DC.pseudoClientId = PC.id
			LEFT OUTER JOIN DM2SearchServerCoreInfo core ON core.cloudId = DC.cloudId
		WHERE DC.CloudType IN (1,5)
		DECLARE getIndexServer CURSOR FOR
		SELECT  cloudId from #indexServer
		OPEN    getIndexServer
		FETCH   NEXT FROM getIndexServer
		INTO    @cloudId
		WHILE   @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO #IndexLocation (propName, IndexLocation)
			EXEC APPGetDM2CloudMetaProp @cloudId , 'INDEXLOCATION'
			UPDATE #IndexLocation SET cloudId = @cloudId WHERE cloudId = -1
			FETCH   NEXT FROM getIndexServer INTO @cloudId
		END
		CLOSE       getIndexServer
		DEALLOCATE  getIndexServer
		SELECT I.nodeClientId AS ISClientId,I.nodeClientName AS ISName,[Params],[values] FROM (
			SELECT INS.nodeClientId,
				CL.displayName AS nodeClientName,
				CL.net_hostname,
				dbo.GetClientOSName(CL.id,NULL) AS OSName,
				R.release+'.0' AS Release,
				CASE WHEN V.attrVal IS NULL OR CHARINDEX(' SP',V.attrVal) = 0 THEN 'N/A'
					ELSE SUBSTRING(V.attrVal,CHARINDEX(' SP',V.attrVal)+3,LEN(V.attrVal))
				END AS ServicePackVersion,
				(select P.attrVal from APP_ClientProp P where P.attrName = 'Patch Local Location' and P.componentNameId = CL.id AND P.modified = 0) InstallFolderLocation
			FROM   (SELECT DISTINCT nodeClientId FROM #indexServer) INS
				INNER JOIN APP_Client CL ON CL.id = INS.nodeClientId AND CL.id > 1
				INNER JOIN simAllGalaxyRel R ON R.id = CL.releaseId
				LEFT OUTER JOIN APP_ClientProp V ON V.componentNameId = CL.id AND V.attrName = 'SP Version Info' AND V.modified = 0
		) I
		CROSS APPLY
		(
			SELECT 'Index Server Name', ISNULL((STUFF((SELECT ', ' + IndexServerName FROM #indexServer WHERE nodeClientId = I.nodeClientId FOR XML PATH('')), 1, 2, '')), '') UNION ALL
			SELECT 'Index Server Node Client Name', nodeClientName UNION ALL
			SELECT 'Index Server HostName', net_hostname UNION ALL
			SELECT 'Operating System', OSName UNION ALL
			SELECT 'Commvault Version', Release UNION ALL
			SELECT 'Feature Release', ServicePackVersion UNION ALL
SELECT 'Agents Installed', (SELECT ISNULL(STUFF((SELECT DISTINCT ', ' + APP_IDAType.displayName								FROM licUsage licUsage WITH(NOLOCK)									INNER JOIN APP_IDAType APP_IDAType WITH(NOLOCK) ON licUsage.appType = APP_IDAType.type								WHERE licUsage.opType = 'Install' AND licUsage.appType < 1000 AND licUsage.licType NOT IN (10, 26, 71) AND licUsage.cid = nodeClientId								FOR XML PATH('')), 1, 2, ''), 'None')) UNION ALL
			SELECT 'Install Folder Location', InstallFolderLocation UNION ALL
			SELECT 'Index Path', ISNULL(STUFF((SELECT IndexLocation FROM #IndexLocation L INNER JOIN #indexServer INS ON INS.nodeClientId = I.nodeClientId AND INS.cloudId = L.cloudId FOR XML PATH('')), 1, 2, ''), 'None') UNION ALL
			SELECT 'Roles', ISNULL(STUFF((SELECT DISTINCT ', ' + M.roleTypeName
							FROM DM2CloudCoreRole R
								INNER JOIN DM2CloudRoleMaster M on R.RoleId = M.roleType
								INNER JOIN #indexServer INS ON R.cloudId = INS.cloudId
							WHERE INS.nodeClientId = I.nodeClientId FOR XML PATH('')), 1, 2, ''), 'None') UNION ALL
SELECT 'Additional Settings', (SELECT ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  3 AND deleted = 0 AND enabled = 1 AND entityId = nodeClientId for XML PATH('')), 1, 2, ''),'None'))
		)C([Params],[values])
		ORDER BY nodeClientName
		IF OBJECT_ID('tempdb.dbo.#IndexLocation') IS NOT NULL DROP TABLE #IndexLocation
		IF OBJECT_ID('tempdb.dbo.#indexServer') IS NOT NULL DROP TABLE #indexServer
	END
	ELSE IF @i_param = 31 -- Secondary Commserv
	BEGIN
		DECLARE @CSNodeSC INT
		SELECT @CSNodeSC = clientId FROM APP_Platform WHERE platformType = 1
		DECLARE @localNetHostNameSC NVARCHAR(1024) = (SELECT net_hostname from app_client where id = @CSNodeSC)
		DECLARE @StandByNodeSC INT
		SELECT
			@StandByNodeSC= C.id
		FROM APP_Client C
		INNER JOIN simInstalledPackages SIM ON SIM.simPackageID = 24 AND SIM.ClientId = C.id
		WHERE C.net_hostname <> @localNetHostNameSC
		SELECT 'Standby CommServe Name' AS SecondCSParam, attrVal AS SecondCSValue FROM APP_ClientProp WHERE componentNameId = @StandByNodeSC and attrName = 'strComputerName' AND modified = 0
		UNION ALL
		SELECT 'CommServe Type', CASE (SELECT attrVal FROM App_ClientProp WHERE componentNameId = @StandByNodeSC AND attrName LIKE 'Virtual Client'  AND modified = 0) WHEN 0 THEN 'Physical'
                    ELSE 'Cluster' END Type
		UNION ALL
SELECT 'Standby CommServe HostName', stringVal FROM APP_ComponentProp WHERE componentId = @StandByNodeSC and propertyTypeId = 2103  AND modified = 0
		UNION ALL
		SELECT 'Operating System', attrVal FROM APP_ClientProp WHERE componentNameId = @StandByNodeSC and attrName = 'Operating System Name' AND modified = 0
		UNION ALL
		SELECT 'Commvault Software Version', attrVal FROM APP_ClientProp WHERE componentNameId = @StandByNodeSC and attrName = 'Client Version' AND modified = 0
		UNION ALL
		SELECT 'Feature Release', attrVal FROM APP_ClientProp WHERE componentNameId = @StandByNodeSC and attrName = 'SP Version Info' AND modified = 0
		UNION ALL
		SELECT 'Additional Patches', ISNULL(STUFF((
                                            SELECT DISTINCT '; ' + U.Data
                                            FROM simInstalledPackages P
                                            CROSS APPLY dbo.SplitString(CAST(P.AdditionalPatches AS NVARCHAR(MAX)), ',') U
                                            WHERE P.ClientId = @StandByNodeSC AND CAST(P.AdditionalPatches AS NVARCHAR(MAX)) <> 'None'
                                            FOR XML PATH ('')
                                        ), 1, 2, ''), 'None')
		UNION ALL
		SELECT 'Install Folder Location ',attrVal FROM APP_ClientProp WHERE componentNameId = @StandByNodeSC and attrName = 'Patch Local Location' AND modified = 0
		UNION ALL
		SELECT 'MS-SQL Install Directory', ''
		UNION ALL
		SELECT 'MS-SQL Version', ''
		UNION ALL
		SELECT 'Additional Settings', ISNULL(STUFF((SELECT ', ' + keyName + ': ' + CAST(value AS NVARCHAR(MAX)) FROM APP_AdvanceSettings WITH(NOLOCK)  WHERE entityType =  3 AND deleted = 0 AND enabled = 1 AND entityId = @StandByNodeSC for XML PATH('')), 1, 2, ''),'None')
	END
SET NOCOUNT OFF
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'RptAsBuiltGuide')
	delete from GxQscripts where name = 'RptAsBuiltGuide'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAsBuiltGuide')
	delete from GXDBVersions where aliasname = 'RptAsBuiltGuide'
GO

insert into GXDBVersions values(2, 'RptAsBuiltGuide',  'v1.5.12.19.6.1', 'RptAsBuiltGuide', 'v1.5.12.19.6.1')
GO

