

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptAdminHistoryInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptAdminHistoryInfo.sp,v $ $Id: RptAdminHistoryInfo.sp,v 1.150.32.34 2020/12/17 02:57:46 mkhan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptAdminHistoryInfo"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='rptAdminHistoryInfo')
BEGIN
	print '>>> Drop Stored Procedure: rptAdminHistoryInfo <<<'
	drop procedure rptAdminHistoryInfo
END
IF EXISTS (select * from GxQscripts where name='rptAdminHistoryInfo')
	delete from GxQscripts where name = 'rptAdminHistoryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptAdminHistoryInfo')
	delete from GXDBVersions where aliasname = 'rptAdminHistoryInfo'
GO
print '... Creating Procedure: rptAdminHistoryInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure rptAdminHistoryInfo
  @i_jobId integer
AS
  DECLARE @o_rowType INTEGER;
  DECLARE @o_total INTEGER;
  DECLARE @o_completed INTEGER;
  DECLARE @o_cwe INTEGER;
  DECLARE @o_cww INTEGER;
  DECLARE @o_killed INTEGER;
  DECLARE @o_failed INTEGER;
  DECLARE @o_running INTEGER;
  DECLARE @o_delayed INTEGER;
  DECLARE @o_jobId integer;
  DECLARE @o_opType integer;
  DECLARE @o_status integer;
  DECLARE @o_state integer;
  DECLARE @o_startTime integer;
  DECLARE @o_endTime integer;
  DECLARE @o_currentPhaseName char(255);
  DECLARE @o_totalWriteTime integer;
  DECLARE @o_userName nchar(255);
  DECLARE @o_auxCopySize bigint;
  DECLARE @o_agId integer;
  DECLARE @o_agName NVARCHAR(255);
  DECLARE @o_agcId integer;
  DECLARE @o_agcName NVARCHAR(255);
  DECLARE @o_AP_NumDays integer;
  DECLARE @o_AP_IsForecast integer;
  DECLARE @o_AC_NewMediaFlag integer;
  DECLARE @o_ER_BkpLevel integer;
  DECLARE @o_EX_TotalMedia bigint;
  DECLARE @o_EX_TotalSuccess bigint;
  DECLARE @o_EX_TotalFailures bigint;
  DECLARE @o_libraryId integer;
  DECLARE @o_libName NVARCHAR(255);
  DECLARE @o_InvenType integer;
  DECLARE @o_initFrom integer;
  DECLARE @o_totalSize bigint;
  DECLARE @o_totalBackupSize bigint;
  DECLARE @o_nwTransBytes bigint;
  DECLARE @o_applicationSize bigint;
  DECLARE @o_dataWritten bigint;
  DECLARE @o_indexedItems bigint;
  DECLARE @o_searchEngine NVARCHAR(255);
  DECLARE @o_embeddedObjects bigint;
  DECLARE @o_skippedItems bigint;
  DECLARE @o_jobFlags integer;
  DECLARE @o_taskOption integer;
  DECLARE @o_taskStatus integer;
  DECLARE @o_commcellId integer;
  DECLARE @o_mediaCreationTime integer;
  DECLARE @o_lastChunkWrittenTime integer;
  DECLARE @o_cellName char(255);
  DECLARE @o_failReasonIds char(255);
  DECLARE @o_failureReason nvarchar(MAX);
  DECLARE @o_ER_DbName nvarchar(MAX);
  DECLARE @o_ER_Destination nvarchar(MAX);
  DECLARE @o_MediaUsed nvarchar(MAX);
  DECLARE @o_jobDescription nvarchar(MAX);
  DECLARE @o_mountPathName nvarchar(MAX);
  DECLARE @o_MAName nvarchar(MAX);
  DECLARE @o_parentJobid nvarchar(MAX);
  DECLARE @o_reportName nvarchar(MAX);
  DECLARE @o_srmAgentName nvarchar(MAX);
  DECLARE @o_bkpjobIdXml nvarchar(MAX);
  DECLARE @o_jobInfo nvarchar(MAX);
  DECLARE @o_sidbStore nvarchar(MAX);
  DECLARE @o_barcode varchar(MAX);
  DECLARE @o_catalogJobInfoXml varchar(MAX);
  DECLARE @o_libraryName varchar(MAX);
  DECLARE @o_DedupReconRestoreJobs varchar(MAX);
  DECLARE @o_cloudId INT;
  DECLARE @o_monitorPolicy nvarchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @selJobId		integer = 0 --filter results based on user given job Id
DECLARE @userId			integer
DECLARE @locId			integer
DECLARE @rptType		integer
DECLARE @opType			integer
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @active			integer
DECLARE @history		integer
DECLARE @needStatus		integer
DECLARE @noBkp			integer
DECLARE @noRun			integer
DECLARE @failed			integer
DECLARE @delayed		integer
DECLARE @jobId			integer
DECLARE @medNum			integer
DECLARE @dataLen		integer
DECLARE @flags			bigint
DECLARE @media			nvarchar(1024)
DECLARE @tokSep			nvarchar(10)
DECLARE @PTRVAL			varbinary(16)
DECLARE @tblStatus		TABLE (status int)
DECLARE @tblAuxCopyMedia	TABLE (media ntext)
DECLARE @jobDesc		nvarchar(4000)
DECLARE @prntjobId		varchar(1024)
DECLARE @pjobId			varchar(1024)
DECLARE @startPos		int
DECLARE @dlPos			int
DECLARE @endPos			int
DECLARE	@xmlJobInfo		nvarchar(4000)
DECLARE @sidbStoreName	nvarchar(1024)
DECLARE @optypeList	TABLE(t_optype int)
DECLARE @SPOpt			int = 0
DECLARE @tblOptSPs		TABLE(policyId int, copyId int)
DECLARE @errorCode	integer = 0
DECLARE @errorCodeFilter	int = 0
DECLARE @useAbsTimeRangeForJobSummaryRpt INTEGER
DECLARE @showSPsDisabledForBackup INT = 0
IF object_id('tempdb.dbo.#JobList') IS NOT null DROP TABLE #JobList
 CREATE TABLE #JobList(
	rowtype			INTEGER, --2 Summary All job types, 1 - Summary one Job type, 0 - Detail(Not a summary row)
	total			INTEGER,
	completed		INTEGER,
	cwe				INTEGER,
	cww				INTEGER,
	killed			INTEGER,
	failed			INTEGER,
	running			INTEGER,
	delayed			INTEGER,
	jobId			INT,
	opType			INT,
	status			INT,
	state			INT,
	startTime		INT,
	endTime			INT,
	currentPhase		INT,
	agId			INT,
	agName			ntext,
	AP_NumDays		INT,
	AP_IsForecast		INT,
	AC_NewMediaFlag		INT,
	ER_BkpLevel		INT,
	ER_DbName		ntext,
	ER_Destination		ntext,
	MediaUsed		ntext,
	EX_TotalMedia		BIGINT,
	EX_TotalSuccess		BIGINT,
	EX_TotalFailures	BIGINT,
	failIds			varchar(512),
	failureReason		ntext,
	agcId			INT,
	libraryId		INT,
	InvenType		INT,
	userName		nvarchar(1024),
	totalWriteTime		INT,
	initFrom		INT,
	jobFlags		INT,
	TotalSize		BIGINT,
	TotalBackupSize	BIGINT,
	nwTransBytes	BIGINT,
	applicationSize	BIGINT,
	dataWritten		BIGINT,
	numFiles		BIGINT,
	embeddedObjects		BIGINT,
	skippedItems		BIGINT,
	dataStatus		INT,
	jobDescription nvarchar(MAX) default(N''),
	mountPathName		varchar(1024),
	taskOption		INT,
	taskStatus		INT,
	srmRptType		INT,
	commcellId		INT,
	mediaCreationTime	INT,
	lastChunkWrittenTime	INT,
	cellName		varchar(512),
	mediaAgent		varchar(1024),
	parentJobid		varchar(1024),
	reportName		varchar(1024) default(''),
	srmAgentName	varchar(1024) default(''),
	bkpjobIdXml		nvarchar(MAX),
	jobInfo		ntext,
	sidbStoreName	nvarchar(1024),
	barcode			varchar(256)	,
	catalogJobInfoXml	varchar(MAX),
	library			varchar(256),
	DedupReconRestoreJobs 	VARCHAR(MAX),
	CloudId			INT
 )
DECLARE @i_taskId integer
DECLARE @MAId      integer
DECLARE @tblMA     TABLE (t_id int)
SET @i_taskId = @i_jobId
SET @rptType 	= dbo.GetOptionInt(2039186688, @i_jobId, 0, 0)
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @locId	= dbo.GetOptionInt(1421724997, @i_jobId, 0, 0)
SET @selJobId			= dbo.GetOptionInt(127117398, @i_jobId, 0, 0)
SET @jobDesc		= dbo.GetOptionString(305418106, @i_jobId, 0, 0)
SET @errorCode			= dbo.GetOptionInt(1307886748,@i_jobId,0,0)
IF @errorCode > 0
BEGIN
SET @errorCodeFilter		= CAST((dbo.GetOptionString(676022536,@i_jobId,0,0)) AS INT);
END
SET @showSPsDisabledForBackup = ISNULL(dbo.GetOptionInt(1500296262, @i_jobId, 0, 0), 1)
INSERT INTO @tblStatus EXEC rptOptGetJobStatus @i_jobId, @active OUTPUT, @history OUTPUT, @noBkp OUTPUT, @noRun OUTPUT, @failed OUTPUT, @delayed OUTPUT
INSERT INTO @tblOptSPs EXEC rptOptGetStoragePolicies @i_jobId, @SPOpt OUTPUT
INSERT INTO @tblMA EXEC rptOptGetObjectList @i_jobId, 587766369, @MAId OUTPUT
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
--MR 159274: CMR to only include jobs that started AND ended in the given time frame if time range is specified in days (regKey based)
SET @useAbsTimeRangeForJobSummaryRpt = 0
IF EXISTS (
	SELECT 1
	FROM APP_AdvanceSettings WITH(NOLOCK)
	WHERE keyName = 'bUseAbsTimeRangeForJobSummaryRpt'
			AND type = 'BOOLEAN'
			AND relativePath = 'Reports'
			AND enabled = 1
			AND deleted = 0
			AND entityType = 3
			AND entityId = 2
			AND CONVERT(NVARCHAR(20), value) = N'true'
) AND (SELECT dbo.GetOptionString(1399039985, @i_jobId, 0, 0)) = 11 --TimeRangeType_RELATIVE_DAYS
AND (SELECT dbo.GetOptionInt(162723971, @i_jobId, 0, 0)) = (60*60*24) --Selected Time Range = 1 day
	SET @useAbsTimeRangeForJobSummaryRpt = 1
IF	@endTime <= 0
	SET	@endTime = 0x7FFFFFFF
SET @needStatus = (select count(*) from @tblStatus)
SET @tokSep = N', '
if object_id('tempdb.dbo.#UMuserGroup') is not Null	DROP TABLE #UMuserGroup
if object_id('tempdb.dbo.#TMP_VNA_forRptList') is not null DROP TABLE #TMP_VNA_forRptList
if object_id('tempdb.dbo.#TMP_CC_User') is not null DROP TABLE #TMP_CC_User
IF @userId <> 0
BEGIN
		create table #UMuserGroup (
			userId int not null,
			groupId int not null,
			flag     int not null
		)
		create table #TMP_VNA_forRptList (
			groupId int not null,
			canSee     int not null
		)
		create table #TMP_CC_User (
			commCellId int not null,
			canSeeAll int not null
		)
		IF EXISTS (SELECT 1 FROM UMUsers WITH (NOLOCK) WHERE id = @userId AND umDSproviderId = 0)
			INSERT	INTO #UMuserGroup
			SELECT	userID, groupId, flag
			FROM	UMUserGroup WITH (NOLOCK)
			WHERE	userid = @userId
		ELSE
			INSERT	INTO #UMuserGroup
			SELECT	DISTINCT UG.userId, GM.umgroupId, GM.flag
			FROM	UMDSUserGroup AS UG WITH (NOLOCK), UMDSGroupMaps AS GM WITH (NOLOCK)
			WHERE	UG.userID = @userId
			AND		GM.umdsgroupId = UG.groupId
			INSERT	INTO #TMP_VNA_forRptList
			SELECT	groupId, allassociations
			FROM	#UMUserGroup, UMGroups WITH (NOLOCK)
			WHERE	userId = @userId
			AND		(UMGroups.groupFlags & 1 = 1)
			AND		#UMUserGroup.groupId = UMGroups.id
		IF ((select count(groupId) FROM #TMP_VNA_forRptList WHERE canSee = 1) = 0)
		BEGIN
			IF (dbo.isNewSecurity() = 0)
			BEGIN
				INSERT INTO #TMP_CC_User SELECT id,0 FROM App_CommCell
				UPDATE #TMP_CC_User set  canSeeAll =1
				FROM #TMP_CC_User CC
				WHERE
					(
	      				SELECT COUNT(VisNode.groupId)
	      				FROM #TMP_VNA_forRptList as VisNode, UMGroupAssociation AS GA WITH (NOLOCK)
	      				WHERE 	VisNode.groupId = GA.groupId
	        			AND GA.type1 = 2018 AND GA.id1 = CC.commCellId
	            			AND GA.type2 = 0      AND GA.id2 = 0
	            			AND GA.type3 = 0      AND GA.id3 = 0
	            			AND GA.type4 = 0      AND GA.id4 = 0
					) > = 1
			 END
			 ELSE
			 BEGIN
				IF object_id('tempdb.dbo.#CommcellReport_UserObjects') is not null DROP TABLE #CommcellReport_UserObjects
create table  #CommcellReport_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
				EXEC sec_getUserObjects  @userId, 2018, 0, '#CommcellReport_UserObjects'
				INSERT INTO #TMP_CC_User SELECT id,0 FROM App_CommCell
				UPDATE TMP set  canSeeAll =1
				FROM #TMP_CC_User TMP INNER JOIN  #CommcellReport_UserObjects users ON users.entityId6 = tmp.commCellId
				IF object_id('tempdb.dbo.#CommcellReport_UserObjects') is not null DROP TABLE #CommcellReport_UserObjects
			 END
		END
END
INSERT INTO @optypeList
SELECT (case @rptType	when 7775		then 13	--AUXCOPY
when 7785				then 10	--PRUNE
when 7790			then 11	--CSDRBKP
when 7786				then 31	--cvARCHIVECHECK
when 7782			then 36	--PATCHDOWNLOAD
when 7783			then 35	--PATCHUPDATE
when 7787		then 53 --OFFLINECONTENTINDEX
when 7741			then 61 --SNAPTOTAPEWORKFLOW
when 7742	then 63 --MAGLIBMAINTENANCE
when 7743						then 62 --SRMREPORT
when 7746			then 64	--DM2
when 7757		then 44	--BROWSEANDDELETE
when 7762			then 74	--MEDIAREFRESHING
when 7751					then 71	--CCMCAPTURE (EXPORT)
when 7752					then 72	--CCMMERGE (IMPORT)
when 7771		then 67	--INSTALLCLIENT
when 7794	then 80	--DEDUPDBSYNC
when 7724				then 79	--SRMAGENTLESSOPTYPE
when 8001			then 47	--CATALOGUEMEDIATYPE
WHEN 8002			THEN 85 --VMP_MANAGEMENT
WHEN 8005			THEN 89 --VIRTUALIZEME
WHEN 8004					THEN 92 --SEND_LOGFILE
WHEN 8006					THEN 75 --FDCOPTYPE
WHEN 8011						THEN 90 --WORKFLOW_MGMT
WHEN 8007					THEN 76 --LOG_MONITORING
WHEN 8009							THEN 17 --REPORTS
when 8013					THEN 53 --OFFLINECONTENTINDEX
WHEN 8015                         THEN 86 --LOG MONITORING JOBS
WHEN 8019       THEN 31 --cvARCHIVECHECK (data verification..for now)
				else 0 end)
SET @opType = (select t_optype from @optypeList)
IF @rptType = 7757
	INSERT INTO @optypeList VALUES (38)	--SELECTIVEDELETE
IF @rptType = 7775
	INSERT INTO @optypeList VALUES (104)	--AUXCOPY2
IF @rptType = 7771
BEGIN
	INSERT INTO @optypeList VALUES (68)	--UNINSTALLCLIENT
	INSERT INTO @optypeList VALUES (35)	--upgrade software, (optype =35 & ER_BkpLevel = 1)
END
-- include SRM report jobs when report jobs are asked for (SRM_ADMIN_REPORT)
IF @rptType = 8009
BEGIN
    INSERT INTO @optypeList VALUES (62)
END
-- include workflow jobs when workflow management jobs are asked for
IF @rptType = 8011
BEGIN
    INSERT INTO @optypeList VALUES (39)
END
--include Content Indexing job when offline content indexing is selected
IF @rptType = 7787
BEGIN
    INSERT INTO @optypeList VALUES (113)
END
--active but not delayed jobs
IF @active > 0
IF @selJobId > 0
BEGIN
	INSERT INTO #JobList
	SELECT 0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	J.jobId, J.opType, 0, state, jobStartTime, lastStartOrRun, currentPhase, ArchGrpID, ArchGrpName, AP_NumDays, AP_IsForecast, AC_NewMediaFlag, ER_BkpLevel, ER_DbName, ER_Destination, ER_MediasUsed, TotalObjects, ObjectsDone, ObjectsFailed, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), ArchGrpCopyID, libraryId, MI_InventoryType, (select login from UMUsers WITH (READUNCOMMITTED) where id=userId), 0, initFrom, 0, totalSize, -1, A.nwTransBytes, 0, 0, numFiles, embeddedObjects, skippedItems, 0, J.jobDescription, '', 0, 0, 0,J.commcellId, '', '', '', '', '','', J.xmlJobInfo,'', '', 0,0,'','',' ', CloudId
	FROM JMJobInfo J WITH (READUNCOMMITTED), JMAdminJobInfoTable A WITH (READUNCOMMITTED)
	WHERE A.jobId = @selJobId AND J.jobId = A.jobId AND (@opType = 0 OR EXISTS (select * from @optypeList where t_optype=J.opType)) AND J.jobId <> @i_jobId
	AND state in (1,4,9) -- RUNNING=1 , COMPLETED=4 ,COMPLETEDSUCCESS=9
END
ELSE
BEGIN
	INSERT INTO #JobList
	SELECT 0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	J.jobId, J.opType, 0, state, jobStartTime, lastStartOrRun, currentPhase, ArchGrpID, ArchGrpName, AP_NumDays, AP_IsForecast, AC_NewMediaFlag, ER_BkpLevel, ER_DbName, ER_Destination, ER_MediasUsed, TotalObjects, ObjectsDone, ObjectsFailed, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), ArchGrpCopyID, libraryId, MI_InventoryType, (select login from UMUsers WITH (READUNCOMMITTED) where id=userId), 0, initFrom, 0, totalSize, -1, A.nwTransBytes, 0, 0, numFiles, embeddedObjects, skippedItems, 0, J.jobDescription, '', 0, 0, 0,J.commcellId, 0,0, '', '', '', '', '','', J.xmlJobInfo,'', '','','',' ', CloudId
	FROM JMJobInfo J WITH (READUNCOMMITTED), JMAdminJobInfoTable A WITH (READUNCOMMITTED)
	WHERE J.jobId = A.jobId AND (@opType = 0 OR EXISTS (select * from @optypeList where t_optype=J.opType)) AND jobStartTime <= @endTime AND J.jobId <> @i_jobId
	AND state in (1,4,9) -- RUNNING=1 , COMPLETED=4 ,COMPLETEDSUCCESS=9
	AND (@SPOpt < 1 OR EXISTS (SELECT * FROM @tblOptSPs WHERE (policyId = A.ArchGrpId ) AND (A.archGrpCopyID = 0 OR copyId = 0 OR copyId = A.ArchGrpCopyId)))
END
IF @history > 0 and @rptType <> 7742
IF @selJobId > 0
BEGIN
	INSERT INTO #JobList
	SELECT 0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	jobId, opType, status, 0, servStart, servEnd, 0, ArchGrpID, ArchGrpName, AP_NumDays, AP_IsForecast, AC_NewMediaFlag, ER_BkpLevel, ER_DbName, ER_Destination, ER_MediasUsed, EX_TotalMedia, EX_TotalSuccess, EX_TotalFailures, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), ArchGrpCopyID, libraryId, MI_InventoryType, userName, totalWriteTime, initFrom, jobFlags, totalSize, totalBackupSize, nwTransBytes, 0, 0, numFiles, embeddedObjects, skippedItems, dataStatus,
	(select jobDescription from JmJobStats WITH (READUNCOMMITTED) where jobId = A.jobId and commCellId = A.commCellId), '', 0, 0, 0,commcellId, '', '', '', '','','', (select xmlJobInfo from JmJobStats where jobId = A.jobId and commCellId = A.commCellId),'','', 0,0,'','',' ', CloudId
	FROM JMAdminJobStatsTable A WITH (READUNCOMMITTED)
	WHERE jobId = @selJobId AND	(@opType = 0 OR EXISTS (select * from @optypeList where t_optype=opType)) AND
		(@needStatus = 0 OR status in (select status from @tblStatus))
END
ELSE
BEGIN
	INSERT INTO #JobList
	SELECT 0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	jobId, opType, status, 0, servStart, servEnd, 0, ArchGrpID, ArchGrpName, AP_NumDays, AP_IsForecast, AC_NewMediaFlag, ER_BkpLevel, ER_DbName, ER_Destination, ER_MediasUsed, EX_TotalMedia, EX_TotalSuccess, EX_TotalFailures, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), ArchGrpCopyID, libraryId, MI_InventoryType, userName, totalWriteTime, initFrom, jobFlags, totalSize, totalBackupSize, nwTransBytes, 0, 0, numFiles, embeddedObjects, skippedItems, dataStatus,
	(select jobDescription from JmJobStats WITH (READUNCOMMITTED) where jobId = A.jobId and commCellId = A.commCellId), '', 0, 0, 0,commcellId, 0,0, '', '', '', '','','', (select xmlJobInfo from JmJobStats where jobId = A.jobId and commCellId = A.commCellId),'','','','',' ', CloudId
	FROM JMAdminJobStatsTable A WITH (READUNCOMMITTED)
	WHERE	(@opType = 0 OR EXISTS (select * from @optypeList where t_optype=opType)) AND
		(@needStatus = 0 OR status in (select status from @tblStatus)) AND
		servEnd >= @startTime AND servStart <= @endTime
	AND (@SPOpt < 1 OR EXISTS (SELECT * FROM @tblOptSPs WHERE (policyId = A.ArchGrpId )  AND (A.archGrpCopyID = 0 OR copyId = 0 OR copyId = A.ArchGrpCopyId)))
END
--delayed jobs
IF @delayed > 0
IF(@selJobId > 0)
BEGIN
	INSERT INTO #JobList
	SELECT 0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	J.jobId, J.opType, 0, state, jobStartTime, lastStartOrRun, currentPhase, ArchGrpID, ArchGrpName, AP_NumDays, AP_IsForecast, AC_NewMediaFlag, ER_BkpLevel, ER_DbName, ER_Destination, ER_MediasUsed, TotalObjects, ObjectsDone, ObjectsFailed, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), ArchGrpCopyID, libraryId, MI_InventoryType, (select login from UMUsers where id=userId), 0, initFrom, 0, totalSize, -1, A.nwTransBytes, 0, 0, numFiles, embeddedObjects, skippedItems, 0, J.jobDescription, '', 0, 0, 0,J.commcellId, '', '', '', '', '','', J.xmlJobInfo,'','', 0,0,'','',' ', CloudId
	FROM JMJobInfo J WITH (READUNCOMMITTED), JMAdminJobInfoTable A WITH (READUNCOMMITTED)
	WHERE A.jobId = @selJobId AND J.jobId = A.jobId AND (@opType = 0 OR EXISTS (select * from @optypeList where t_optype=J.opType)) AND J.opType <> 17
	AND state NOT in (1,4,9) -- RUNNING=1 , COMPLETED=4 ,COMPLETEDSUCCESS=9
END
ELSE
BEGIN
	INSERT INTO #JobList
	SELECT 0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	J.jobId, J.opType, 0, state, jobStartTime, lastStartOrRun, currentPhase, ArchGrpID, ArchGrpName, AP_NumDays, AP_IsForecast, AC_NewMediaFlag, ER_BkpLevel, ER_DbName, ER_Destination, ER_MediasUsed, TotalObjects, ObjectsDone, ObjectsFailed, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), ArchGrpCopyID, libraryId, MI_InventoryType, (select login from UMUsers where id=userId), 0, initFrom, 0, totalSize, -1, A.nwTransBytes, 0, 0, numFiles, embeddedObjects, skippedItems, 0, J.jobDescription, '', 0, 0, 0,J.commcellId, 0,0, '', '', '', '', '','', J.xmlJobInfo,'','','','',' ', CloudId
	FROM JMJobInfo J WITH (READUNCOMMITTED), JMAdminJobInfoTable A WITH (READUNCOMMITTED)
	WHERE J.jobId = A.jobId AND (@opType = 0 OR EXISTS (select * from @optypeList where t_optype=J.opType)) AND J.opType <> 17 AND jobStartTime <= @endTime
	AND state NOT in (1,4,9) -- RUNNING=1 , COMPLETED=4 ,COMPLETEDSUCCESS=9
	AND (@SPOpt < 1 OR EXISTS (SELECT * FROM @tblOptSPs WHERE (policyId = A.ArchGrpId )  AND (A.archGrpCopyID = 0 OR copyId = 0 OR copyId = A.ArchGrpCopyId)))
END
UPDATE	#JobList
SET		state = 100
FROM	#JobList L INNER JOIN JMJobInfo J ON	J.commcellId = L.commcellId AND J.jobId = L.jobId
WHERE	J.guiAlertColorLevel = 40 --NO_RESPONSE_GUI_COLOR
--delete install/remove updates jobs (ie optype = 35 & ER_BkpLevel IN (0 = install updates, 2 = remove updates))
IF @rptType = 7771
	DELETE FROM #JobList
	WHERE opType = 35 AND ER_BkpLevel IN (0, 2)
--delete upgrade software jobs (ie optype = 35 & ER_BkpLevel = 1)
IF @rptType = 7783
	DELETE FROM #JobList
	WHERE opType = 35 AND ER_BkpLevel = 1
--update optype for analytics jobs
IF @rptType IN ( 8013, 7784, 7795, 7787)
 UPDATE #JobList
 SET opType = 103
 WHERE opType = 53
		AND (	 jobId IN (SELECT jobId FROM JMJobStats (NOLOCK) WHERE subOpType IN (103, 112))
				OR
				jobId IN (SELECT jobId FROM JMJobInfo (NOLOCK) WHERE subOpType IN (103, 112))
			)
--space reclamation jobs report changes
--update optype for space reclamation jobs
--they have the optype 31 of archive check jobs, but have an additional suboptype = 141
--if data verification report, then remove the space reclamation jobs...
IF @rptType = 7786
	BEGIN
		DELETE FROM #JobList FROM #JobList jl
			INNER JOIN JMJobStats js
			ON jl.commCellId = js.commCellId AND jl.jobid = js.jobid AND jl.optype = 31 and js.suboptype = 141
		DELETE FROM #JobList FROM #JobList jl
			INNER JOIN JMJobInfo ji
			ON jl.commCellId = ji.commCellId AND jl.jobid = ji.jobid AND jl.optype = 31 and ji.suboptype = 141
	END
--if space reclamation report, them remove everything except space reclamtion jobs..
ELSE IF @rptType = 8019
	BEGIN
		-- delete all jobs that are not ddb space reclation jobs
		DELETE FROM #JobList FROM #JobList jl
			INNER JOIN JMJobStats js
			ON jl.commCellId = js.commCellId AND jl.jobid = js.jobid AND jl.optype = 31 and js.suboptype <> 141
		DELETE FROM #JobList FROM #JobList jl
			INNER JOIN JMJobInfo ji
			ON jl.commCellId = ji.commCellId AND jl.jobid = ji.jobid AND jl.optype = 31 and ji.suboptype <> 141
		--change op type of remaining jobs to 141(space reclamation report)
		UPDATE #JobList
			SET opType = 141
	END
--if all admin jobs reports, then update the job optype to 141
ELSE
	BEGIN
		UPDATE jl SET jl.optype = 141
			FROM #JobList AS jl
			INNER JOIN JMJobStats AS js ON jl.commCellId = js.commCellId AND jl.jobid = js.jobid
			WHERE jl.optype = 31 and js.suboptype = 141
		UPDATE jl SET jl.optype = 141
			FROM #JobList AS jl
			INNER JOIN JMJobInfo AS ji ON jl.commCellId = ji.commCellId AND jl.jobid = ji.jobid
			WHERE jl.optype = 31 and ji.suboptype = 141
	END
--end of space reclamation jobs report changes
--update optype for online crawl jobs
IF @rptType IN ( 7784, 7795, 7787, 7788)
BEGIN
	UPDATE #JobList
	SET opType = 130
	WHERE opType = 53
		AND (	 jobId IN (SELECT jobId FROM JMJobStats (NOLOCK) WHERE subOpType IN (130))
				OR
				jobId IN (SELECT jobId FROM JMJobInfo (NOLOCK) WHERE subOpType IN (130))
			)
	UPDATE #JobList
	SET opType = 143
	WHERE opType = 53
		AND (	 jobId IN (SELECT jobId FROM JMJobStats (NOLOCK) WHERE subOpType IN (143))
				OR
				jobId IN (SELECT jobId FROM JMJobInfo (NOLOCK) WHERE subOpType IN (143))
			)
END
IF @rptType = 7787
BEGIN
	--delete analytics jobs if offline ci report is selected
	DELETE FROM #JobList
	WHERE opType = 103 /*DATA_ANALYTICS*/
	--delete online crawl history job
	DELETE T
	FROM #JobList T
	JOIN JMJobStats S (NOLOCK) ON S.jobId = T.jobid
	WHERE S.subOpType IN ( 130 /*ONLINE_CRAWL*/ , 143 /*SOLR_INDEX_IMPORT*/, 132 /*CONTENT_INDEXING_ENTITY_EXTRACTION*/)
	--delete online crawl running job
	DELETE T
	FROM #JobList T
	JOIN JMJobInfo S (NOLOCK) ON S.jobId = T.jobid
	WHERE S.subOpType IN ( 130 /*ONLINE_CRAWL*/ , 143 /*SOLR_INDEX_IMPORT*/, 132 /*CONTENT_INDEXING_ENTITY_EXTRACTION*/)
END
--delete offline ci jobs if analytics report is selected
IF @rptType = 8013
	DELETE FROM #JobList
	WHERE opType = 53
CREATE TABLE #LMMonitoringPolicy (lm_jobId int, xmlvalue XML, monitoringPolicy varchar(max))
IF @rptType IN (8015,7784,7795)
BEGIN
INSERT INTO #LMMonitoringPolicy
select J.jobId,  CONVERT(XML,SUBSTRING(xmlJobInfo,LEN('<?xml version=''1.0'' encoding=''UTF-8''?>')+1,LEN(xmlJobInfo)),2) ,''
from #JobList as J INNER JOIN JmJobStats  Jm WITH (NOLOCK)   ON Jm.jobId = J.jobId WHERE J.optype = 86
UPDATE lm_temp
SET monitoringPolicy =(select xmlValue.value('(/JobManager_AdminJobDetailsXml/patchUpdateInfo/@monitoringPolicyName)[1]','varchar(max)')  from #LMMonitoringPolicy as lm where lm.lm_jobId = lm_temp.lm_jobId )
From #LMMonitoringPolicy lm_temp
END
DECLARE @userName NVARCHAR(510)
SET @userName = (SELECT TOP 1 login FROM UMUsers  WITH (NOLOCK) WHERE id = @userId)
DELETE  #JobList
	FROM #JobList Jobs
	WHERE  NOT EXISTS ( SELECT * from #TMP_CC_User WHERE commCellId = Jobs.commCellId and canSeeAll=1)
	AND NOT (@userId = 0 OR @userName = Jobs.userName OR dbo.isAdminJobVisible(@userId, Jobs.CommCellId,  Jobs.agId, Jobs.jobId, Jobs.opType,0) <> 0)
--get media for aux copy jobs
; WITH AuxCopyMedia (jobId, commCellId, media) AS
(
	SELECT	DISTINCT J.jobId, J.commCellId, CASE C.MediaTypeId WHEN 10001 THEN D.MountPathName ELSE C.barcode END AS media
	FROM	#JobList J
			INNER JOIN JMMisc A WITH (READUNCOMMITTED) ON A.jobId = J.jobId AND A.commcellId = J.commCellId AND A.itemType = 11
			INNER JOIN MMVolume B WITH (READUNCOMMITTED) ON B.VolumeId = A.intData
			INNER JOIN MMMedia C WITH (READUNCOMMITTED) ON C.MediaId = B.MediaId
			LEFT OUTER JOIN MMS2getMountPathNameGUIView D ON D.MediaId = C.MediaId
)
UPDATE	#JobList
SET		MediaUsed = T.media
FROM	(SELECT	jobId, commCellId,
				STUFF((SELECT ',' + media FROM AuxCopyMedia WHERE jobId = A.jobId AND commCellId = A.commCellId ORDER BY media
					FOR XML PATH('')), 1, 1, '') AS media
		FROM	AuxCopyMedia A
		GROUP BY jobId, commCellId) T
WHERE	#JobList.jobId = T.jobId AND #JobList.commCellId = T.commCellId
------parentJobid for Snap to tape job
DECLARE @commcellId INT = 0, @pCommcellId INT = 0;
IF @rptType = 7741 OR @rptType = 7784 OR @rptType =7795
BEGIN
	DECLARE getPrntJobIdList CURSOR FOR SELECT jobId, commcellId FROM #JobList
	OPEN getPrntJobIdList
	FETCH NEXT FROM getPrntJobIdList INTO @jobId, @commcellId
	DECLARE @size BIGINT = 0,@tempSize BIGINT, @XfrTime INTEGER = 0, @tempXfrTime INTEGER
	DECLARE @mediaUsed varchar(1024) = '',@tempMedia varchar(1024) = ''
	DECLARE @needUpdate INT;
	WHILE @@FETCH_STATUS = 0
	BEGIN
			SET @mediaUsed = ''
			SET @size = 0
			SET @XfrTime = 0
			SET @needUpdate = 0
			DECLARE getpJobList CURSOR FOR
			SELECT processedJobId, commcellId FROM JMJobWF WHERE jobid = @jobId AND commcellId = @commcellId
			SET @prntjobId = ''
			OPEN getpJobList
			FETCH NEXT FROM getpJobList INTO @pjobId, @pCommcellId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @tempMedia = ''
				SET @tempSize = 0
				SET @tempXfrTime = 0
				IF @prntjobId <> ''
					SET @prntjobId = @prntjobId + ', '
				SET @prntjobId = @prntjobId + @pjobId
				--compose MediaUsed field
				IF @mediaUsed <> ''
					SET @mediaUsed = @mediaUsed + ', '
				SET @tempMedia=(SELECT dbo.GetMediaList(J.jobId)FROM JMBkpStats j WHERE	j.jobId = @pjobId AND commcellId = @pCommcellId)
				SET @mediaUsed = @mediaUsed + @tempMedia
				--calculate the size AND transfer time
				SET @tempSize = (SELECT totalUncompBytes FROM JMBkpStats WHERE jobId = @pjobId AND commcellId = @pCommcellId)
				SET @tempXfrTime = (SELECT totalWriteTime FROM JMBkpStats WHERE jobId = @pjobId AND commcellId = @pCommcellId)
				SET @size = @size + @tempSize
				SET @XfrTime = @XfrTime + @tempXfrTime
				SET @needUpdate = 1
				FETCH NEXT FROM getpJobList INTO @pjobId, @pCommcellId
			END
			CLOSE getpJobList
			DEALLOCATE getpJobList
			UPDATE #JobList
			SET parentJobId = @prntjobId, totalWriteTime = @XfrTime, TotalSize = @size, MediaUsed = @mediaUsed
			WHERE  jobid =@jobId AND @needUpdate = 1
			FETCH NEXT FROM getPrntJobIdList INTO @jobId, @commcellId
	END
	CLOSE getPrntJobIdList
	DEALLOCATE getPrntJobIdList
END
---get report name
IF @rptType = 8009 OR @rptType = 7784 OR @rptType =7795
BEGIN
	DECLARE getReportType CURSOR FOR SELECT jobId, jobInfo FROM #JobList where Optype = 17
	OPEN	getReportType
	FETCH NEXT FROM getReportType INTO @jobId, @xmlJobInfo
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET	@dlPos = ISNULL(PATINDEX('%ReportName%', @xmlJobInfo),0)
		IF @dlPos > 0
		BEGIN
			SET	@startPos =	ISNULL(CHARINDEX('"', @xmlJobInfo, @dlPos+1), 0)
			SET	@endPos =	ISNULL(CHARINDEX('"', @xmlJobInfo, @startPos+1), 0)
			UPDATE #JobList
			SET	reportName = SUBSTRING(@xmlJobInfo, @startPos+1, @endPos-@startPos-1)
			WHERE  jobid = @jobId
		END
	FETCH NEXT FROM getReportType INTO @jobId, @xmlJobInfo
	END
	CLOSE getReportType
	DEALLOCATE getReportType
END
-- Fragmentation Analysis
IF @rptType = 7742 OR @rptType = 7784 OR @rptType =7795
	UPDATE #JobList
	SET mountPathName = ISNULL((SELECT mountPathName FROM MMS2getMountPathNameGUIView  WITH (READUNCOMMITTED) WHERE MountPathId = MF.mountPathId), ''),
		taskOption = MF.taskOption ,
		taskStatus = MF.taskStatus
	FROM #JobList J, MMMagLibFADTaskInfo MF WITH (READUNCOMMITTED)
	WHERE  J.jobid =MF.adminJobId
--MAGNETIC_LIBRARY_MAINTANENCE_REPORT
if @rptType = 7742
IF @selJobId > 0
BEGIN
	INSERT INTO #JobList
	SELECT 0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	adminjobid, opType, status, 0, servStart, servEnd, 0, ArchGrpID, ArchGrpName, AP_NumDays, AP_IsForecast, AC_NewMediaFlag, ER_BkpLevel, ER_DbName, ER_Destination, ER_MediasUsed, EX_TotalMedia, EX_TotalSuccess, EX_TotalFailures, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), ArchGrpCopyID, libraryId, MI_InventoryType, userName, totalWriteTime, initFrom, jobFlags, totalSize, totalBackupSize, JA.nwTransBytes, 0, 0, numFiles, embeddedObjects, skippedItems, dataStatus,
	(select jobDescription from JmJobStats where jobId = JA.jobId and commCellId = JA.commCellId),
    ISNULL((SELECT mountPathName FROM MMS2getMountPathNameGUIView  WITH (READUNCOMMITTED) WHERE MountPathId = MF.mountPathId), ''), taskOption, taskStatus, 0,JA.commCellId,'', '','' ,'', '', '','', '','', 0,0,'','',' ', CloudId
	FROM JMAdminJobStatsTable  JA WITH (READUNCOMMITTED) ,MMMagLibFADTaskInfo MF WITH (READUNCOMMITTED)
	WHERE JA.jobid = @selJobId AND Ja.jobid =MF.adminjobid and (@opType = 0 OR EXISTS (select * from @optypeList where t_optype=opType)) AND
		(@needStatus = 0 OR status in (select status from @tblStatus))
END
ELSE
BEGIN
	INSERT INTO #JobList
	SELECT 0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	adminjobid, opType, status, 0, servStart, servEnd, 0, ArchGrpID, ArchGrpName, AP_NumDays, AP_IsForecast, AC_NewMediaFlag, ER_BkpLevel, ER_DbName, ER_Destination, ER_MediasUsed, EX_TotalMedia, EX_TotalSuccess, EX_TotalFailures, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), ArchGrpCopyID, libraryId, MI_InventoryType, userName, totalWriteTime, initFrom, jobFlags, totalSize, totalBackupSize, JA.nwTransBytes, 0, 0, numFiles, embeddedObjects, skippedItems, dataStatus,
	(select jobDescription from JmJobStats where jobId = JA.jobId and commCellId = JA.commCellId),
    ISNULL((SELECT mountPathName FROM MMS2getMountPathNameGUIView  WITH (READUNCOMMITTED) WHERE MountPathId = MF.mountPathId), ''), taskOption, taskStatus, 0,JA.commCellId,'', '','' ,'', '', '','', '','',0,0,'','',' ', CloudId
	FROM JMAdminJobStatsTable  JA WITH (READUNCOMMITTED) ,MMMagLibFADTaskInfo MF WITH (READUNCOMMITTED)
	WHERE	Ja.jobid =MF.adminjobid and (@opType = 0 OR EXISTS (select * from @optypeList where t_optype=opType)) AND
		(@needStatus = 0 OR status in (select status from @tblStatus)) AND
		servEnd >= @startTime AND servStart <= @endTime
END
-- WORKFLOW_REPORT
if @rptType IN (7795, 7784, 8011)
BEGIN
	UPDATE #JobList SET reportName = (select wfd.Name from WF_Definition wfd WITH (READUNCOMMITTED), JMAdminJobStatsTable jobInfo WITH (READUNCOMMITTED) where wfd.WorkflowId = jobInfo.workFlowId AND #JobList.jobId=jobInfo.jobId AND jobInfo.opType in (39,61,69,90,93,95)) where reportName is null OR LTRIM(reportName)=''
END
-- JunLu:  It is not right to get ARCH_CHECK_HISTORY_REPORT and EDC_DISCOVERY_REPORT jobs togather here.
-- EDC_DISCOVERY_REPORT
if @rptType IN (7784, 8006)
IF @selJobId > 0
BEGIN
	INSERT INTO #JobList
	SELECT	0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	JB.jobId, JB.opType, JB.status, 0, servStartDate, servEndDate, 0, 0, '', 0, 0, 0, 0, N'', N'', N'', 0, 0, 0, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), 0, 0, 0, username, totalWriteTime, initFrom, 0, totalUncompBytes, totalCompBytes, totalNumOfFiles, JB.nwTransBytes, 0, 0, 0, 0, dataStatus,
	ISNULL(J.jobDescription, ''), '', 0, 0, 0, JB.commCellId, '', '', '', '', '', '', '', '','', 0,0,'','',' ', CloudId
	FROM JMBkpStats JB WITH (READUNCOMMITTED), JMJobStats J WITH (READUNCOMMITTED)
	WHERE JB.jobId = @selJobId AND J.jobId = JB.jobID and J.commCellId = JB.commCellID
		AND	J.opType = 75
		AND	(@needStatus = 0 OR JB.status in (select status from @tblStatus))
END
ELSE
BEGIN
-- JunLu: This statement is slow.
	INSERT INTO #JobList
	SELECT	0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	JB.jobId, JB.opType, JB.status, 0, servStartDate, servEndDate, 0, 0, '', 0, 0, 0, 0, N'', N'', N'', 0, 0, 0, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), 0, 0, 0, username, totalWriteTime, initFrom, 0, totalUncompBytes, totalCompBytes, totalNumOfFiles, JB.nwTransBytes, 0, 0, 0, 0, dataStatus,
	ISNULL(J.jobDescription, ''), '', 0, 0, 0, JB.commCellId,0,0, '', '', '', '', '', '', '', '','', '','',' ', CloudId
	FROM JMBkpStats JB WITH (READUNCOMMITTED), JMJobStats J WITH (READUNCOMMITTED)
	WHERE	J.jobId = JB.jobID and J.commCellId = JB.commCellID
		AND	J.opType = 75
		AND	(@needStatus = 0 OR JB.status in (select status from @tblStatus))
		AND	servEndDate >= @startTime AND servStartDate <= @endTime
END
--ARCH_CHECK_HISTORY_REPORT
if @rptType IN (7784, 7786)
BEGIN
IF @selJobId > 0
BEGIN
	INSERT INTO #JobList
	SELECT	0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	JB.jobId, JB.opType, JB.status, 0, servStartDate, servEndDate, 0, 0, '', 0, 0, 0, 0, N'', N'', N'', 0, 0, 0, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), 0, 0, 0, username, totalWriteTime, initFrom, 0, totalUncompBytes, totalCompBytes, totalNumOfFiles, JB.nwTransBytes, 0, 0, 0, 0, dataStatus,
	ISNULL(J.jobDescription, ''), '', 0, 0, 0, JB.commCellId, '', '', '', '', '', '', '', '','', 0,0,'','',' ', CloudId
	FROM JMBkpStats JB WITH (READUNCOMMITTED), JMJobStats J WITH (READUNCOMMITTED)
	WHERE JB.jobId = @selJobId AND J.jobId = JB.jobID and J.commCellId = JB.commCellID
		AND	(J.subOpType = 82 OR (JB.opType = 4 AND ((SELECT ISNULL(dbo.GetJobOption(JB.jobId, 205179434), '0')) = '1')))
		AND	(@needStatus = 0 OR JB.status in (select status from @tblStatus))
END
ELSE
BEGIN
-- JunLu: This statement is slow.
	INSERT INTO #JobList
	SELECT	0, 0, 0, 0, 0, 0, 0, 0, 0, --Summary columns
	JB.jobId, JB.opType, JB.status, 0, servStartDate, servEndDate, 0, 0, '', 0, 0, 0, 0, N'', N'', N'', 0, 0, 0, failureReason, dbo.JMGetLocalizedMessageMaxFunc(@locId, failureReason), 0, 0, 0, username, totalWriteTime, initFrom, 0, totalUncompBytes, totalCompBytes, totalNumOfFiles, JB.nwTransBytes, 0, 0, 0, 0, dataStatus,
	ISNULL(J.jobDescription, ''), '', 0, 0, 0, JB.commCellId,0,0, '', '', '', '', '', '', '', '','', '','',' ', CloudId
	FROM JMBkpStats JB WITH (READUNCOMMITTED), JMJobStats J WITH (READUNCOMMITTED)
	WHERE	J.jobId = JB.jobID and J.commCellId = JB.commCellID
		AND	(J.subOpType = 82 OR (JB.opType = 4 AND ((SELECT ISNULL(dbo.GetJobOption(JB.jobId, 205179434), '0')) = '1')))
		AND	(@needStatus = 0 OR JB.status in (select status from @tblStatus))
		AND	servEndDate >= @startTime AND servStartDate <= @endTime
END
END
IF @errorCodeFilter > 0
BEGIN
	DECLARE @tmpTab TABLE(JOBID INT, MARK INT);
	DELETE FROM #JobList
	WHERE failIds IS NULL OR failIds = ''
	IF EXISTS(SELECT * FROM #JobList)
	BEGIN
		INSERT INTO @tmpTab
		SELECT jobId, dbo.MarkNonErrorForDel(@errorCodeFilter, failIds)
		FROM #JobList
		DELETE FROM #JobList
		WHERE JOBID IN (SELECT JOBID FROM @tmpTab WHERE MARK = 0)
	END
END
IF @useAbsTimeRangeForJobSummaryRpt = 1
BEGIN
	DELETE FROM #JobList WHERE startTime <= @startTime OR endTime >= @endTime
END
IF @jobDesc not like N''
BEGIN
	SET @jobDesc = N'%' + @jobDesc + N'%'
	DELETE #JobList
	FROM #JobList
	WHERE jobDescription NOT LIKE @jobDesc OR jobDescription IS NULL
END
-- MA Name
UPDATE #JobList
SET mediaAgent =ISNULL((select displayName from APP_Client WITH (READUNCOMMITTED) where id in (select TOP 1 LC.clientId from MMLibraryController LC WITH (READUNCOMMITTED)
				where LC.LibraryId = J.LibraryId AND LC.LibraryControllerId>0)), '')
FROM #JobList J
-- list of qualified backup job ids
/* MR 144252: this query takes time but bkpjobIdXml is no longer used in v11
if @rptType = 7786
BEGIN
	;WITH DVJobIds (DVjobID, agId,agcId, JobIDs) AS
	(
		SELECT DISTINCT	JM.jobId AS DVjobID,A.agId,A.agcId,
				ISNULL((
					SELECT DISTINCT  JD.jobId AS '@val'
					FROM	JMJobDataStats JD, JMAdminJobStatsTable JM where JM.opType =31
		AND JD.archcheckendtime>0 AND JD.archCheckEndTime BETWEEN JM.servStart AND JM.servEnd
		AND JD.archGrpId =A.agId AND (  JD.archGrpCopyId  =  A.agcId OR A.agcId  =0) AND JM.jobId = A.jobId
					FOR XML PATH('bkpjobIds'), ROOT('JobManager_InfoMgmtJobStats'))
					, '<JobManager_InfoMgmtJobStats/>')
		FROM	#JobList A,JMJobDataStats JD, JMAdminJobStatsTable JM where JM.opType =31
		AND JD.archcheckendtime>0 AND JD.archCheckEndTime BETWEEN JM.servStart AND JM.servEnd
		AND JD.archGrpId =A.agId AND (  JD.archGrpCopyId  =  A.agcId OR A.agcId  =0) AND JM.jobId = A.jobId
		GROUP BY JM.jobId,A.agId,A.agcId,A.jobId
	)
	UPDATE	#JobList SET bkpjobIdXml = DV.JobIDs
	FROM	DVJobIds DV
	WHERE	#JobList.jobId = DV.DVjobID AND #JobList.agId = DV.agId   AND #JobList.agcId = DV.agcId
END
*/
if @rptType = 7746
	UPDATE #JobList
	SET bkpjobIdXml =ISNULL((SELECT CAST(bkpjobIds as nvarchar(MAX)) FROM JMAdminInfoMgmtStats IM  WITH (READUNCOMMITTED) WHERE IM.JobId = J.JobId), '')
	FROM #JobList J
-- COMMCELL_EXPORT_REPORT = 7751,COMMCELL_IMPORT_REPORT ==7752
IF @rptType = 7751 OR @rptType = 7752 OR @rptType = 7784 OR @rptType =7795
	UPDATE #JobList
SET mountPathName = dbo.GetJobOption(jobid, 1645003648),		--DUMPFOLDER
InvenType = dbo.GetJobOption(jobid, 109347715)			--PATHTYPE (0-local, 1-network)
	WHERE opType in (71, 72)														--CCMCAPTURE, CCMMERGE
-----get sidb store name
IF @rptType = 7794 OR @rptType = 7784 OR @rptType =7795
BEGIN
	DECLARE @SIDBStoreInfo TABLE (t_jobId int, t_sidbStoreName nvarchar(1024), t_accessPath nvarchar(1024))
	INSERT INTO @SIDBStoreInfo
	SELECT	T.AdminJobId, S.SIDBStoreName, CL.displayName + (CASE WHEN CHARINDEX('/', AP.Path) > 0 THEN '/' ELSE '\' END) + AP.Path
	FROM	(SELECT	RH.AdminJobId, RH.SubStoreId
			 FROM	#JobList J INNER JOIN IdxSIDBRecoveryHistory RH ON RH.AdminJobId = J.jobId) T
			INNER JOIN IdxSIDBSubStore SS ON SS.SubStoreId = T.SubStoreId
			INNER JOIN IdxSIDBStore S ON S.SIDBStoreId = SS.SIDBStoreId
			INNER JOIN IdxAccessPath AP ON AP.IdxAccessPathId = SS.IdxAccessPathId
			INNER JOIN APP_Client CL ON CL.id = SS.ClientId
	--loop for jobId
	DECLARE getDDBConstructJobList CURSOR FOR
			SELECT Jobid FROM #JobList WHERE optype = 80
	OPEN getDDBConstructJobList
	FETCH NEXT FROM getDDBConstructJobList INTO @jobId
	WHILE @@FETCH_STATUS = 0
	BEGIN
			--loop for sidbstorename
			DECLARE getSIDBStoreList CURSOR FOR
			SELECT	t_sidbStoreName,
					(SELECT	 t_accessPath + ', '
					FROM	@SIDBStoreInfo X
					WHERE	t_jobid = @jobId AND t_sidbStoreName = Y.t_sidbStoreName
					ORDER BY t_accessPath
					FOR XML PATH('')) AS accessPaths
			FROM	@SIDBStoreInfo Y
			WHERE	t_jobid = @jobId
			GROUP BY t_sidbStoreName
			SET @sidbStoreName = ''
			OPEN getSIDBStoreList
			FETCH NEXT FROM getSIDBStoreList INTO @pjobId, @prntjobId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @sidbStoreName <> ''
					SET @sidbStoreName = @sidbStoreName + ', '
				SET @sidbStoreName = @sidbStoreName + @pjobId + '(' + LEFT(@prntjobId, LEN(@prntjobId) - 1) + ')'
				FETCH NEXT FROM getSIDBStoreList INTO @pjobId, @prntjobId
			END
			CLOSE getSIDBStoreList
			DEALLOCATE getSIDBStoreList
		UPDATE #JobList
		SET sidbStoreName = @sidbStoreName
		WHERE  jobid =@jobId
	FETCH NEXT FROM getDDBConstructJobList INTO @jobId
	END
	CLOSE getDDBConstructJobList
	DEALLOCATE getDDBConstructJobList
	IF(@rptType = 7794)
	BEGIN
		update #JobList
		set DedupReconRestoreJobs = isnull(X.DedupReconRestoreJobs,' ')
		from
			(select
			(SELECT SUBSTRING((select ','+CAST (attributeValueInt AS VARCHAR(10))
									from JMJobOptions subQuery
									where outerQuery.jobId = subQuery.jobid and attributeName = 'Dedup reconstruction option restore job id'
								for XML PATH('')), 2, 1000)) DedupReconRestoreJobs,jobId, commCellId
			from JMJobOptions outerquery) X
		where #JobList.jobId = X.jobId and #JobList.commcellId = X.commCellId
	END
END
--get DDB Name for Space Reclamation report
IF @rptType = 8019
	BEGIN
	--the CloudId column is actually storing the DDB Store Id
	--we can use that to get the DDB Name
	UPDATE J
		SET J.sidbStoreName =  ISS.SIDBStoreName
		FROM #JobList J INNER JOIN IdxSIDBStore ISS
			ON J.CloudId = ISS.SIDBStoreId
	--we will now use the CloudId column to store information regarding if the job has had an OCL phase
	--we already used the information in this column, so it is safe to overwrite
	--this information will be later used in the report to display a '#' along with the jobid to indicate this job has had an OCL phase
	UPDATE #JobList SET CloudId = 0
	UPDATE J
		SET J.CloudId = 1
		FROM #JobList J INNER JOIN JMAdminJobAttemptStatsTable JA
			ON J.jobId = JA.jobId AND JA.phaseNum = 3
	END
-- cellName
UPDATE #JobList
SET cellName =C.aliasName
FROM #JobList JS,APP_Commcell C WITH (READUNCOMMITTED)
WHERE JS.commCellId = C.Id
-- libraryId is used to store clientId
IF @rptType = 7757
	UPDATE #JobList
	SET libraryId = (SELECT clientId FROM APP_Application WITH (READUNCOMMITTED)
					 WHERE id = J.appID AND L.jobId = J.jobId),
		TotalSize = (SELECT appTypeId FROM APP_Application WITH (READUNCOMMITTED)
					 WHERE id = J.appID AND L.jobId = J.jobId)
	FROM #JobList L, JMAdminJobStatsTable J WITH (READUNCOMMITTED)
	WHERE L.jobId = J.jobId
--update job list with catalog job information.
update #JobList
	set barcode = M.BarCode,
		mediaCreationTime = M.CreationTime,
		lastChunkWrittenTime = M.CreationTime,
		catalogJobInfoXml = convert(varchar(MAX), MT.xmlString),
		library = L.LibraryName
from #JobList J inner join MMTapeCatalogJobInfo MT  WITH (READUNCOMMITTED) on J.jobId = MT.jobId
				inner join	MMMedia M WITH (READUNCOMMITTED) on M.MediaId = MT.MediaId
				inner join	MMLibrary L WITH (READUNCOMMITTED) on L.LibraryId = M.LibraryId
where J.opType	= 47 and J.commcellId = 2
IF @rptType = 7775 AND @showSPsDisabledForBackup = 0
BEGIN
DELETE  J
FROM #JobList J
INNER JOIN archgroup p WITH (NOLOCK) ON
p.id = j.agid
AND p.flags &64= 64
update	#JobList
set	nwTransBytes = ACI.NWTransBytes,
	applicationSize = ACI.ApplicationSize,
	dataWritten		= ACI.DataWritten
from #JobList JL,
	(select auxcopyjobid,
			max(NWTransBytes) as NWTransBytes,
			sum(ApplicationSize) as ApplicationSize,
			sum(DataWritten) as DataWritten
	from	CommCellAuxCopyInfo
	group by auxcopyjobid
	having @selJobId IN (0,auxcopyjobid)) ACI
where JL.jobId	= ACI.auxcopyjobid
END
update	#JobList
set		opType = 13
from	#JobList JL
WHERE	opType = 104
IF @rptType = 7741  AND EXISTS(select * from @tblMA)
BEGIN
	  IF object_id('tempdb.dbo.#StoragePolicies') IS NOT null DROP TABLE #StoragePolicies
      CREATE TABLE #StoragePolicies (archGrpId INT)
      INSERT  INTO #StoragePolicies
      SELECT  DISTINCT AG.id
      FROM    archGroup AG WITH(NOLOCK)
                  INNER JOIN MMDataPath DP WITH(NOLOCK) ON DP.CopyId IN (AG.defaultCopy, AG.defaultSnapCopy) AND DP.Flag&1 = 1
                  INNER JOIN APP_Client CL WITH(NOLOCK) ON DP.HostClientId = CL.id
                  INNER JOIN @tblMA MA ON CL.id = MA.t_id
      DELETE  B FROM #JobList B
                  LEFT OUTER JOIN #StoragePolicies P ON B.agid = P.archGrpId
      WHERE   P.archGrpId IS NULL
      DROP TABLE #StoragePolicies
END
-- Demo comment to show member copy policy name as earlier.
----update agId to GACP agId in case copy is pointing to GACP policy.
--Update #JobList
--set agId = agcDest.archGroupId
--from archGroupCopy agc WITH (READUNCOMMITTED), archGroupCopy agcDest WITH (READUNCOMMITTED)
--where #JobList.agcId = agc.id
--and (agc.extendedFlags & 2) > 0
--and agc.destMediaCopyId = agcDest.id
-- ALWAYS HIDE SUCCESSFUL JOBS WITH DATA STATUS (MEDIA_DELETED)
--DELETE #JobList
--WHERE dataStatus=2 AND status IN (1, 3)	-- JMSUCCESS, PARTIALSUCCESS
-- -----------------------------------------------------------------------------------------------------
--		Following block of code is to include the summary table in Admin Job Summary report.
--		Only admin job summary report will have the summary table.
--		All Job Summary report does not have summary table for admin jobs.
--		Row type column tells what that row is about.
--			2 - All Job Types summary row
--			1 - One Job Type summary row
--			0 - Detail row (Not summary)
--
--		All admin jobs report has the all job types summary row, individual admin job summary
--		report does not have the all job summary row because all jobs and job type row will
--		have the same data.
--
--		Job type for PATCHUPDATE job also depend on ER_BkpLevel column. Hence the specail handling.
--
--		Changes by : stelagamsetti (Sunil Telagamsetti)
--
-- ------------------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#tempAdminJobSummary') IS NOT null DROP TABLE #tempAdminJobSummary
CREATE TABLE #tempAdminJobSummary(
	tid						INTEGER,
	er_bkpLevel				INTEGER,
	total					INTEGER,
	startTime				INTEGER,
	endTime					INTEGER
)
IF @rptType <> 7795
BEGIN
IF @rptType = 7784
	BEGIN
		INSERT INTO #JobList(rowType, opType, ER_BkpLevel, total, completed, cwe, cww, killed, failed, running, delayed, startTime, endTime)
		SELECT 2,0,0,
			count(*),
			(select count(*) from #JobList where status=1), -- Completed
			(select count(*) from #JobList where status=3), -- CWE
			(select count(*) from #JobList where status=14), -- CWW
			(select count(*) from #JobList where status=4), -- Killed
			(select count(*) from #JobList where status in (2, 9)), -- Failed, dropped
(select count(*) from #JobList where status=0 and state in (1,4,9,100)),  -- Active jobs: RUNNING , COMPLETED, COMPLETEDSUCCESS
(select count(*) from #JobList where status=0 and state NOT in (1,4,9,100)), -- Delayed
			MIN(ISNULL(startTime, 0)),
			MAX(ISNULL(endTime, 0))
		FROM #JobList WHERE jobId>0
	END
	INSERT INTO #tempAdminJobSummary
	SELECT	opType, 0, count(*), MIN(ISNULL(startTime, 0)), MIN(ISNULL(endTime, 0))
	FROM	#JobList
	WHERE	jobId>0 AND opType NOT IN (35,31)
	GROUP BY	opType
	INSERT INTO #tempAdminJobSummary
	SELECT	opType, ER_BkpLevel, count(*), MIN(ISNULL(startTime, 0)), MIN(ISNULL(endTime, 0))
	FROM	#JobList
	WHERE	jobId>0 AND opType = 35
	GROUP BY	opType, ER_BkpLevel
	-- added to differentiate DDB verification from Data Verification jobs
	-- optype is same (31) but cloudId is 0 for Data verification and non zero for DDB verification
	-- The below command is to add the 2 manually to the summary table
	IF ((SELECT COUNT(*) FROM #JobList J WHERE jobId>0 AND opType = 31 AND cloudId = 0 )>0)
	BEGIN
		INSERT INTO #JobList(rowType, opType, ER_BkpLevel, total, completed, cwe, cww, killed, failed, running, delayed, startTime, endTime, cloudId)
		SELECT 1,31,0,
			count(*),
			(select count(*) from #JobList where status=1 AND opType = 31 AND cloudId = 0), -- Completed
			(select count(*) from #JobList where status=3 AND opType = 31 AND cloudId = 0), -- CWE
			(select count(*) from #JobList where status=14 AND opType = 31 AND cloudId = 0), -- CWW
			(select count(*) from #JobList where status=4 AND opType = 31 AND cloudId = 0), -- Killed
			(select count(*) from #JobList where status in (2, 9) AND opType = 31 AND cloudId = 0), -- Failed, dropped
			(select count(*) from #JobList where status=0 and state in (1,4,9,100) AND opType = 31 AND cloudId = 0),  -- Active jobs: RUNNING , COMPLETED, COMPLETEDSUCCESS
			(select count(*) from #JobList where status=0 and state NOT in (1,4,9,100) AND opType = 31 AND cloudId = 0), -- Delayed
			MIN(ISNULL(startTime, 0)),
			MAX(ISNULL(endTime, 0)),
			0
		FROM #JobList J WHERE jobId>0 AND opType = 31 AND cloudId = 0
	END
	IF ((SELECT COUNT(*) FROM #JobList J WHERE jobId>0 AND opType = 31 AND cloudId > 0 )>0)
	BEGIN
		INSERT INTO #JobList(rowType, opType, ER_BkpLevel, total, completed, cwe, cww, killed, failed, running, delayed, startTime, endTime, cloudId)
		SELECT 1,31,0,
			count(*),
			(select count(*) from #JobList where status=1 AND opType = 31 AND cloudId > 0), -- Completed
			(select count(*) from #JobList where status=3 AND opType = 31 AND cloudId > 0), -- CWE
			(select count(*) from #JobList where status=14 AND opType = 31 AND cloudId > 0), -- CWW
			(select count(*) from #JobList where status=4 AND opType = 31 AND cloudId > 0), -- Killed
			(select count(*) from #JobList where status in (2, 9) AND opType = 31 AND cloudId > 0), -- Failed, dropped
			(select count(*) from #JobList where status=0 and state in (1,4,9,100) AND opType = 31 AND cloudId > 0),  -- Active jobs: RUNNING , COMPLETED, COMPLETEDSUCCESS
			(select count(*) from #JobList where status=0 and state NOT in (1,4,9,100) AND opType = 31 AND cloudId > 0), -- Delayed
			MIN(ISNULL(startTime, 0)),
			MAX(ISNULL(endTime, 0)),
			1
		FROM #JobList J WHERE jobId>0 AND opType = 31 AND cloudId > 0
	END
IF @rptType = 7775
	BEGIN
		INSERT INTO #JobList(rowType, agId, total, completed, cwe, cww, killed, failed, running, delayed)
		SELECT 1,
			agId,
			(select COUNT(*) from #JobList where agid = T.agId ),
			(select COUNT(*) from #JobList where agid = T.agId and status = 1), -- Completed
			(select COUNT(*) from #JobList where agid = T.agId AND status=3 ), -- CWE
			(select COUNT(*) from #JobList where agid = T.agId AND status=14 ), -- CWW
			(select COUNT(*) from #JobList where agid = T.agId AND status=4 ), -- Killed
			(select COUNT(*) from #JobList where agid = T.agId AND status in (2, 9)), -- Failed, dropped
(select COUNT(*) from #JobList where agid = T.agId AND status=0 and state in (1,4,9,100)),  -- Active jobs: RUNNING , COMPLETED, COMPLETEDSUCCESS
(select COUNT(*) from #JobList where agid = T.agId AND status=0 and state NOT in (1,4,9,100)) -- Delayed
		FROM #JobList T group by agId
		INSERT INTO #JobList(rowType, opType, ER_BkpLevel, total, completed, cwe, cww, killed, failed, running, delayed, startTime, endTime)
		SELECT 2,0,0,
			count(*),
			(select count(*) from #JobList where status=1), -- Completed
			(select count(*) from #JobList where status=3), -- CWE
			(select count(*) from #JobList where status=14), -- CWW
			(select count(*) from #JobList where status=4), -- Killed
			(select count(*) from #JobList where status in (2, 9)), -- Failed, dropped
(select count(*) from #JobList where status=0 and state in (1,4,9,100)),  -- Active jobs: RUNNING , COMPLETED, COMPLETEDSUCCESS
(select count(*) from #JobList where status=0 and state NOT in (1,4,9,100)), -- Delayed
			MIN(ISNULL(startTime, 0)),
			MAX(ISNULL(endTime, 0))
		FROM #JobList WHERE jobId>0
	END
ELSE IF @rptType = 7786
	BEGIN
		INSERT INTO #JobList(rowType,total,completed,cwe,cww,killed,failed,running,delayed,startTime,endTime)
		SELECT 2,												-- aggregation for 'All' row summary
			COUNT(*),
			(select count(*) from #JobList where status=1), -- Completed
			(select count(*) from #JobList where status=3), -- CWE
			(select count(*) from #JobList where status=14), -- CWW
			(select count(*) from #JobList where status=4), -- Killed
			(select count(*) from #JobList where status in (2,9)), -- Failed, dropped
(select count(*) from #JobList where status=0 and state in (1,4,9,100)),  -- Active jobs: RUNNING , COMPLETED, COMPLETEDSUCCESS
(select count(*) from #JobList where status=0 and state NOT in (1,4,9,100)), -- Delayed
			MIN(ISNULL(startTime,0)),
			MAX(ISNULL(endTime,0))
		FROM #JobList T WHERE jobId > 0 AND rowType = 0
	END
	ELSE
	BEGIN
		INSERT INTO #JobList(rowType, opType, ER_BkpLevel, total, completed, cwe, cww, killed, failed, running, delayed, startTime, endTime)
		SELECT 1,
			tid,
			er_bkpLevel,
			total,
			(select count(*) from #JobList J where tid = optype AND (J.ER_BkpLevel = T.er_bkpLevel or tid <> 35) AND status=1), -- Completed
			(select count(*) from #JobList J where tid = optype AND (J.ER_BkpLevel = T.er_bkpLevel or tid <> 35) AND status=3), -- CWE
			(select count(*) from #JobList J where tid = optype AND (J.ER_BkpLevel = T.er_bkpLevel or tid <> 35) AND status=14), -- CWW
			(select count(*) from #JobList J where tid = optype AND (J.ER_BkpLevel = T.er_bkpLevel or tid <> 35) AND status=4), -- Killed
			(select count(*) from #JobList J where tid = optype AND (J.ER_BkpLevel = T.er_bkpLevel or tid <> 35) AND status in (2, 9)), -- Failed, dropped
(select count(*) from #JobList J where tid = optype AND (J.ER_BkpLevel = T.er_bkpLevel or tid <> 35) AND status=0 and state in (1,4,9,100)),  -- Active jobs: RUNNING , COMPLETED, COMPLETEDSUCCESS
(select count(*) from #JobList J where tid = optype AND (J.ER_BkpLevel = T.er_bkpLevel or tid <> 35) AND status=0 and state NOT in (1,4,9,100)), -- Delayed
			startTime,
			endTime
		FROM #tempAdminJobSummary T
	END
END
SELECT J.rowType, J.total, J.completed, J.cwe, J.cww, J.killed, J.failed, J.running, J.delayed, --Summary columns
	J.jobId, J.opType, J.status, J.state, J.startTime, J.endTime,
	(case J.currentPhase when 0 then '' else (select P.name from JMPhase as P WITH (READUNCOMMITTED),  JMOpTable as O WITH (READUNCOMMITTED)
	 where O.appTypeType=1000 and O.operation=J.opType and P.opTableId=O.id and P.phase=J.currentPhase) end),
	J.totalWriteTime, J.userName,
	(case when J.opType in (13, 31, 74) then (select sum(BytesXferred) from JMDataCopiedStatsTable WITH (READUNCOMMITTED) where jobId=J.jobId) else 0 end),
	J.agId, ISNULL((select name from archgroup WITH (READUNCOMMITTED) where id=J.agId), ISNULL(J.agName, '')), J.agcId, ISNULL((select name from archgroupcopy  WITH (READUNCOMMITTED) where id=J.agcId), ''),
	J.AP_NumDays, J.AP_IsForecast, J.AC_NewMediaFlag, J.ER_BkpLevel, J.EX_TotalMedia, J.EX_TotalSuccess,
	J.EX_TotalFailures, J.libraryId, (select L.AliasName from MMLibrary L WITH (READUNCOMMITTED) where L.libraryId=J.libraryId),
	J.InvenType, J.initFrom, J.totalSize, J.totalBackupSize, J.nwTransBytes, J.applicationSize, J.dataWritten, J.numFiles, CASE WHEN J.opType = 103 THEN ISNULL( (DC.name),N'') ELSE ISNULL((CP.stringVal),N'') END as searchEngine, J.embeddedObjects, J.skippedItems,
	J.jobFlags, J.taskOption, J.taskStatus,J.commcellId, J.mediaCreationTime, J.lastChunkWrittenTime, J.cellName, J.failIds, J.failureReason, J.ER_DbName, J.ER_Destination, J.MediaUsed, J.jobDescription, J.mountPathName, J.mediaAgent, J.parentJobId, J.reportName, J.srmAgentName, J.bkpjobIdXml,J.jobinfo, J.sidbStoreName, J.barcode, J.catalogJobInfoXml, J.library, J.DedupReconRestoreJobs, J.cloudId as cloudId,ISNULL((LM.monitoringPolicy),N'') AS 'MonitoringPolicy'
FROM #JobList J
LEFT JOIN DM2Cloud  DC WITH (NOLOCK) ON DC.cloudId = J.cloudId
LEFT JOIN APP_ComponentProp CP WITH (NOLOCK) on CP.ID = J.CloudId AND componentId=2 AND propertyTypeId=1 AND CP.modified=0
LEFT JOIN #LMMonitoringPolicy LM WITH (NOLOCK) on LM.lm_jobId = J.jobId
ORDER BY rowType DESC, opType, ER_BkpLevel, jobId DESC
DROP TABLE #JobList
DROP TABLE #tempAdminJobSummary
DROP TABLE #LMMonitoringPolicy
if object_id('tempdb.dbo.#UMuserGroup') is not Null	DROP TABLE #UMuserGroup
if object_id('tempdb.dbo.#TMP_VNA_forRptList') is not null DROP TABLE #TMP_VNA_forRptList
if object_id('tempdb.dbo.#TMP_CC_User') is not null DROP TABLE #TMP_CC_User
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptAdminHistoryInfo')
	delete from GxQscripts where name = 'RptAdminHistoryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAdminHistoryInfo')
	delete from GXDBVersions where aliasname = 'RptAdminHistoryInfo'
GO

insert into GXDBVersions values(2, 'RptAdminHistoryInfo',  '00010150003200340000', 'RptAdminHistoryInfo', '00010150003200340000')
GO

