

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ResolveDuplicateClientNameV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ResolveDuplicateClientNameV2.sp,v $ $Id: ResolveDuplicateClientNameV2.sp,v 1.3.50.1 2018/03/22 01:46:21 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  ResolveDuplicateClientName()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output: Resolves duplicate client names in bulk install
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan Mehta   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ResolveDuplicateClientNameV2 <<<'

IF EXISTS (select * from sysobjects where name='ResolveDuplicateClientNameV2')
	drop procedure ResolveDuplicateClientNameV2
IF EXISTS (select * from GxQscripts where name='ResolveDuplicateClientNameV2')
	delete from GxQscripts where name = 'ResolveDuplicateClientNameV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ResolveDuplicateClientNameV2')
	delete from GXDBVersions where aliasname = 'ResolveDuplicateClientNameV2'
GO
print '... Creating Procedure: ResolveDuplicateClientNameV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ResolveDuplicateClientNameV2
  @input xml
AS
  DECLARE @clientName nvarchar(255); 
  DECLARE @appClientName nvarchar(255); 
  DECLARE @appClientHostName nvarchar(1024); 
  DECLARE @appClientId int;
  DECLARE @cvdPort int;
  DECLARE @evmgrcPort int;
  DECLARE @vmguid nvarchar(64);
  DECLARE @isCompInstalled int;
  DECLARE @isOtherPkgsExists int;
  DECLARE @componentId int;
SET NOCOUNT ON
BEGIN
	--1) Create temp table
	--2) Insert into this table from the XML
	--3) Check for the duplicates using the logic discussed
	--4) Update the existing XML with the results
	--4) Return an XML
	IF object_id('inputxml') IS  null
	Begin
	create table inputxml(
					id					int IDENTITY(1,1) NOT NULL,
					inputxml			xml
					)
	end
	insert into inputxml values(@input)
	IF object_id('tempdb.dbo.#tmpClientList') IS NOT null DROP TABLE #tmpClientList
	create table #tmpClientList(
					id					int IDENTITY(1,1) NOT NULL,
					clientName			nvarchar(255),
					hostName			nvarchar(1024),
					vmguid				nvarchar(64),
					vmIPAddress			nvarchar(64),
					vmName				nvarchar(255),
					vmHostName			nvarchar(1024),
					vmGroup				nvarchar(64),
					flag				int,
					clientRenamed		int,
					appClientName		nvarchar(255),
					appClientHostName	nvarchar(1024),
					appClientFlags		int,
					appClientId			int,
					cvdPort				int,
					evmgrcPort			int,
					componentId			int,
					appTypeId			int,
					appId				int,
					releaseId			int,
					isCompInstalled		int,
					isOtherPkgsExists   int,
					hostRenamed			int
	)
	-- currently expecting only one component , either SRM win, SRM Unix package
	INSERT INTO #tmpClientList
	SELECT T.cc.value('client[1]/clientEntity[1]/@clientName', 'nvarchar(255)') AS a,
		  T.cc.value('client[1]/clientEntity[1]/@hostName', 'nvarchar(1024)'),
		  T.cc.value('clientProps[1]/@vmguid', 'nvarchar(64)'),
		  T.cc.value('clientProps[1]/@virtualServerIPAddress', 'nvarchar(256)'),
		  T.cc.value('clientProps[1]/@vmname', 'nvarchar(255)'),
		  T.cc.value('clientProps[1]/@vmhostname', 'nvarchar(1024)'),
		  T.cc.value('clientGroups[1]/@clientGroupName', 'nvarchar(255)'),
		  0,
		  0,
		  null,
		  null,
		  0,
		  0,
		  0,
		  0,
		  ISNULL(T.cc.value('../components[1]/componentInfo[1]/@ComponentId','int'),0) ,
		  0,
		  0,
		  0,
		  0,
		  0,
		  0
	FROM @input.nodes('/CVInstallManager_ClientSetup/clientComposition/clientInfo') T(cc)
	DECLARE  @createVMClientFlags INT=NULL
	SET  @createVMClientFlags= ISNULL((SELECT
									    	T.c.value('./@createVMClientFlags', 'int')
									   FROM
											@input.nodes('/CVInstallManager_ClientSetup/installFlags') T(c)),0)
	IF (@createVMClientFlags =8 )
	BEGIN
		-- update client id/flags if vmguid is present FOR AMAZON hostname only is sufficient
		update tmp set
			tmp.appClientId = cl.id,
			tmp.appClientName = cl.name,
			tmp.appClientHostName = cl.net_hostname,
			tmp.appClientFlags = cl.specialClientFlags,
			tmp.cvdPort = cl.cvdPort,
			tmp.evmgrcPort = cl.evmgrcPort,
			tmp.releaseId = cl.releaseId
			from #tmpClientList tmp inner join APP_Client as cl
			on tmp.hostName = cl.net_hostname
	END
	ELSE
	BEGIN
		-- update client id/flags if vmguid is present
		update tmp set
			tmp.appClientId = cl.id,
			tmp.appClientName = cl.name,
			tmp.appClientHostName = cl.net_hostname,
			tmp.appClientFlags = cl.specialClientFlags,
			tmp.cvdPort = cl.cvdPort,
			tmp.evmgrcPort = cl.evmgrcPort,
			tmp.releaseId = cl.releaseId
			from #tmpClientList tmp inner join APP_Client as cl
			on tmp.vmguid = cl.GUID
		update tmp set
			tmp.appClientId = cl.id,
			tmp.appClientName = cl.name,
			tmp.appClientHostName = cl.net_hostname,
			tmp.appClientFlags = cl.specialClientFlags,
			tmp.cvdPort = cl.cvdPort,
			tmp.evmgrcPort = cl.evmgrcPort,
			tmp.releaseId = cl.releaseId
			from #tmpClientList tmp
			INNER JOIN APP_ClientProp as clProp
			ON tmp.vmguid = clProp.attrVal
			AND clProp.attrName = 'Virtual Machine GUID'
			AND clProp.modified =0
			inner join APP_Client as cl
			ON clProp.componentNameId = cl.id
			AND tmp.appClientId = 0
		update tmp set
			tmp.appClientId = cl.id,
			tmp.appClientName = cl.name,
			tmp.appClientHostName = cl.net_hostname,
			tmp.appClientFlags = cl.specialClientFlags,
			tmp.cvdPort = cl.cvdPort,
			tmp.evmgrcPort = cl.evmgrcPort,
			tmp.releaseId = cl.releaseId
			from #tmpClientList tmp
			inner join APP_Client as cl
			ON tmp.hostName = cl.net_hostname
			AND tmp.appClientId = 0
			AND ( (cl.specialClientFlags & 2) = 0)
	END
	declare @currRelId	int
	-- when atleast one component exists, then only we will SRM database
	IF EXISTS ( SELECT clientName FROM #tmpClientList where componentId <> 0)
	BEGIN
		IF db_id('SRM') IS NOT null
		BEGIN
			SELECT @currRelId = MAX(id) FROM simAllGalaxyRel WITH (NOLOCK)
			UPDATE #tmpClientList SET appTypeId = 600 WHERE componentId = 402 AND releaseId = @currRelId
			UPDATE #tmpClientList SET appTypeId = 605 WHERE componentId = 1123 AND releaseId = @currRelId
			UPDATE tmp SET appId = app.id
			FROM #tmpClientList tmp
			INNER JOIN APP_Application app ON
				tmp.appTypeId !=0
				AND tmp.appTypeId = app.appTypeId
				AND tmp.appClientId = app.clientId
				AND (app.subclientStatus & 8 ) > 0
			UPDATE tmp SET isCompInstalled = 1
			FROM #tmpClientList tmp
			INNER JOIN SRM..CSStubSubClients stubSC ON
			tmp.appClientId <> 0
			AND tmp.appId <> 0
			AND tmp.appClientId = stubSC.csStubClientId
			AND stubSC.csAPPApplicationId = tmp.appId
			UPDATE tmp SET isOtherPkgsExists = 1
			FROM #tmpClientList tmp
			INNER JOIN simInstalledPackages simPkgs ON
				tmp.appClientId <> 0
				AND simPkgs.ClientId = tmp.appClientId
		END
	END
	declare @currentVMName nvarchar(255)
	declare @currentVMHostName nvarchar(1024)
	declare @currentVMIP nvarchar(64)
	declare @currentVMGUID nvarchar(64)
	declare @currentAppClientId int
	declare @currentAppClientFlags int
	declare @propId int
	declare @propValue nvarchar(1064)
	declare @currentCvdPort int
	declare @currentEvmgrcPort int
	declare @unixTime int
	declare @clientGrpId int
	declare @currentGrpName nvarchar(255)
	declare @tempVMGUID nvarchar(64)
	set @unixTime = dbo.GetUnixTime(GetUTCDate())
	declare @currClientName nvarchar(255)
	declare tempclients cursor for
	  select vmName, vmHostName, vmguid, vmIPAddress, appClientId, appClientFlags, vmGroup , appClientName from #tmpClientList where appClientId <> 0
	open tempclients
	fetch next from tempclients into @currentVMName, @currentVMHostName, @currentVMGUID, @currentVMIP, @currentAppClientId, @currentAppClientFlags, @currentGrpName, @currClientName
	WHILE @@FETCH_STATUS = 0
	begin
		if @currentAppClientFlags =  11
		begin
			declare @clientIdForHost int
			set @clientIdForHost = 0
			select @clientIdForHost = id from APP_Client where net_hostname = @currentVMHostName
			if ( @clientIdForHost = @currentAppClientId )
			begin
				if ( (@currClientName NOT LIKE  @currentVMName)  and (@currClientName NOT LIKE @currentVMName + '!_%' ESCAPE '!') )
				begin
					update APP_Client set name = @currentVMName WHERE id = @currentAppClientId
					update #tmpClientList set appClientName =@currentVMName where appClientId = @currentAppClientId
				end
			end
			if @clientIdForHost = 0
				begin
					--update name and nethost name in app_client
					update APP_Client set name = @currentVMName, net_hostname = @currentVMHostName
						where id = @currentAppClientId
				end
			else if @clientIdForHost <> @currentAppClientId
				begin
					SET @tempVMGUID = NULL
					select @tempVMGUID = attrVal FROM APP_clientProp where attrName ='Virtual Machine GUID' and modified = 0
								AND componentNameId = @clientIdForHost
					IF ( @tempVMGUID is NULL or @tempVMGUID  = @currentVMGUID )
					BEGIN
						--Update the AppClientProps and VM Hosts of @clientIdForHost from  @currentAppClientId
						update APP_ClientProp set attrVal = @currentVMName
							where componentNameId = @clientIdForHost and attrName = 'Virtual Machine Name' and modified = 0
						update APP_ClientProp set attrVal = @currentVMGUID
							where componentNameId = @clientIdForHost and attrName = 'Virtual Machine GUID' and modified = 0
						update APP_ClientProp set attrVal = @currentVMHostName
							where componentNameId = @clientIdForHost and attrName = 'Virtual Machine Host Name' and modified = 0
						update APP_ClientProp set attrVal = @currentVMIP
							where componentNameId = @clientIdForHost and attrName = 'Virtual Machine IP Address' and modified = 0
						update App_VM set clientId = @clientIdForHost where clientId = @currentAppClientId
						--Delete @currentAppClientId from app_client
						delete from APP_ClientGroupAssoc where clientId = @currentAppClientId
						delete from APP_ClientProp where componentNameId = @currentAppClientId
						delete from APP_Platform where clientId = @currentAppClientId
						delete from APP_Client where id = @currentAppClientId
						set @currentAppClientId = @clientIdForHost
					END
					ELSE
					begin
							if ( (@currClientName NOT LIKE  @currentVMName)  and (@currClientName NOT LIKE @currentVMName + '!_%' ESCAPE '!') )
							begin
								update APP_Client set name = @currentVMName WHERE id = @currentAppClientId
								update #tmpClientList set appClientName =@currentVMName where appClientId = @currentAppClientId
							end
					end
				end
		end
		set @propId = null
		set @propValue = null
		select @propId = id, @propValue = attrVal from APP_ClientProp WITH (NOLOCK) where attrName = 'Virtual Server Discovered Clients' and modified = 0 and componentNameId = @currentAppClientId
		if @propId is null
		begin
			--insert new property
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				values (@currentAppClientId, 'Virtual Server Discovered Clients', 2, '1', @unixTime, 0)
		end
		else if @propValue <> '1'
		begin
			--update the current record
			update APP_ClientProp set attrVal = '1' where id = @propId
		end
		set @propId = null
		set @propValue = null
		select @propId = id, @propValue = attrVal from APP_ClientProp WITH (NOLOCK) where attrName = 'Virtual Machine Name' and modified = 0 and componentNameId = @currentAppClientId
		if @propId is null
		begin
			--insert new property
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				values (@currentAppClientId, 'Virtual Machine Name', 1, @currentVMName, @unixTime, 0)
		end
		else if @propValue <> @currentVMName
		begin
			--update the current record
			update APP_ClientProp set attrVal = @currentVMName where id = @propId
		end
		set @propId = null
		set @propValue = null
		select @propId = id, @propValue = attrVal from APP_ClientProp WITH (NOLOCK) where attrName = 'Virtual Machine GUID' and modified = 0 and componentNameId = @currentAppClientId
		if @propId is null
		begin
			--insert new property
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				values (@currentAppClientId, 'Virtual Machine GUID', 1, @currentVMGUID, @unixTime, 0)
		end
		else if @propValue <> @currentVMGUID
		begin
			--update the current record
			update APP_ClientProp set attrVal = @currentVMGUID where id = @propId
		end
		set @propId = null
		set @propValue = null
		select @propId = id, @propValue = attrVal from APP_ClientProp WITH (NOLOCK) where attrName = 'Virtual Machine Host Name' and modified = 0 and componentNameId = @currentAppClientId
		if @propId is null
		begin
			--insert new property
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				values (@currentAppClientId, 'Virtual Machine Host Name', 1, @currentVMHostName, @unixTime, 0)
		end
		else if @propValue <> @currentVMHostName
		begin
			--update the current record
			update APP_ClientProp set attrVal = @currentVMHostName where id = @propId
		end
		set @propId = null
		set @propValue = null
		select @propId = id, @propValue = attrVal from APP_ClientProp WITH (NOLOCK) where attrName = 'Virtual Machine IP Address' and modified = 0 and componentNameId = @currentAppClientId
		if @propId is null
		begin
			--insert new property
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				values (@currentAppClientId, 'Virtual Machine IP Address', 1, @currentVMIP, @unixTime, 0)
		end
		else if @propValue <> @currentVMIP
		begin
			--update the current record
			update APP_ClientProp set attrVal = @currentVMIP where id = @propId
		end
		-- re associate vms back to client group
		SELECT @clientGrpId = id FROM APP_ClientGroup WITH (NOLOCK) where name = @currentGrpName
		IF ( @clientGrpId IS NOT NULL )
		BEGIN
			IF NOT EXISTS ( SELECT clientGroupId, clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) where clientGroupId = @clientGrpId AND clientId = @currentAppClientId)
				INSERT INTO APP_ClientGroupAssoc VALUES ( @clientGrpId, @currentAppClientId)
		END
		fetch next from tempclients into @currentVMName, @currentVMHostName, @currentVMGUID, @currentVMIP, @currentAppClientId, @currentAppClientFlags , @currentGrpName , @currClientName
	end
	close  tempclients
	deallocate  tempclients
	--Mark duplicate names in @input for renames
	UPDATE #tmpClientList
	SET flag = 1
	FROM #tmpClientList tt
	WHERE tt.appClientId = 0
	--Generate the subscript number based on App_Client
	UPDATE #tmpClientList
	SET clientRenamed = dbo.GenerateClientName(clientName, hostName, vmguid)
	FROM #tmpClientList
	where flag = 1
	UPDATE #tmpClientList
	SET hostRenamed = dbo.GenerateHostName(clientName, hostName, vmguid)
	FROM #tmpClientList
	where flag = 1
	--Change the subscript numbers to be unique for a client name
	update #tmpClientList
	set clientRenamed = #tmpClientList.clientRenamed + rankdata.crank - 1
	from
	(select C.id 'id', DENSE_RANK() over (partition by c.clientName,c.clientRenamed order by c.id)  'crank'
	from #tmpClientList c) rankdata
	where #tmpClientList.id = rankdata.id
	update #tmpClientList
	set hostRenamed = #tmpClientList.hostRenamed + rankdata.crank - 1
	from
	(select C.id 'id', DENSE_RANK() over (partition by c.hostName,c.hostRenamed order by c.id)  'crank'
	from #tmpClientList c) rankdata
	where #tmpClientList.id = rankdata.id
	--Modify the input xml to have generated client names
	declare @currentName nvarchar(255)
	declare @currentRenamed nvarchar(255)
	declare @currPkgsExists			int
	declare @isSRMAppTypeInstalled	int
	declare @compId			int
	declare @currentHostName		nvarchar(1024)
	declare @currentHostRenamed		nvarchar(255)
	declare @currentId				int
	declare tempclients cursor for
		  select id, clientName, clientRenamed, hostName, hostRenamed from #tmpClientList where clientRenamed <> 0 OR hostRenamed <> 0
	open tempclients
	fetch next from tempclients into @currentId, @currentName, @currentRenamed, @currentHostName, @currentHostRenamed
	WHILE @@FETCH_STATUS = 0
	begin
		declare @replaceStr		nvarchar(255)
		declare @replaceStrHost	nvarchar(255)
		if @currentRenamed = 0
			begin
				set @replaceStr = @currentName
			end
		else
			begin
				set @replaceStr = @currentName + '_' + CONVERT(nvarchar(10), @currentRenamed)
			end
		update #tmpClientList set appClientName = @replaceStr where id = @currentId
		if @currentHostRenamed = 0
			begin
				set @replaceStrHost = @currentHostName
			end
		else
			begin
				set @replaceStrHost = @currentHostName + '_' + CONVERT(nvarchar(10), @currentHostRenamed )
			end
		update #tmpClientList set appClientHostName = @replaceStr where id = @currentId
		fetch next from tempclients into @currentId, @currentName, @currentRenamed, @currentHostName, @currentHostRenamed
	end
	close  tempclients
	deallocate  tempclients
	select [clientName], [appClientName], [appClientHostName], [appClientId] , [cvdPort], [evmgrcPort], [vmguid], [isCompInstalled], [isOtherPkgsExists], [componentId] from #tmpClientList
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ResolveDuplicateClientNameV2')
	delete from GxQscripts where name = 'ResolveDuplicateClientNameV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ResolveDuplicateClientNameV2')
	delete from GXDBVersions where aliasname = 'ResolveDuplicateClientNameV2'
GO

insert into GXDBVersions values(2, 'ResolveDuplicateClientNameV2',  '00010003005000010000', 'ResolveDuplicateClientNameV2', '00010003005000010000')
GO

