

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ResolveDuplicateClientName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ResolveDuplicateClientName.sp,v $ $Id: ResolveDuplicateClientName.sp,v 1.51.2.23.8.1 2021/02/12 00:25:04 scheppuri Exp $";
--
--  +========================================================================+
--  |   Procedure:  ResolveDuplicateClientName()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output: Resolves duplicate client names in bulk install
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan Mehta   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ResolveDuplicateClientName')
BEGIN
	print '>>> Drop Stored Procedure: ResolveDuplicateClientName <<<'
	drop procedure ResolveDuplicateClientName
END
IF EXISTS (select * from GxQscripts where name='ResolveDuplicateClientName')
	delete from GxQscripts where name = 'ResolveDuplicateClientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ResolveDuplicateClientName')
	delete from GXDBVersions where aliasname = 'ResolveDuplicateClientName'
GO
print '... Creating Procedure: ResolveDuplicateClientName'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ResolveDuplicateClientName
  @input xml
AS
  DECLARE @output xml
SET NOCOUNT ON
BEGIN TRY
	DECLARE @errorCode		INT = 0
	DECLARE @errorStr	NVARCHAR(1024) = N''
	declare @unixTime int
	set @unixTime = dbo.GetUnixTime(GetUTCDate())
	DECLARE @virtualServerInstanceId int
	DECLARE @virtualServerInstanceType INT = 0
	DECLARE @vsaSubClientId INT=0
	DECLARE @vsaBackupSetId INT=0
	DECLARE @vsaClientId    INT=0
	Declare @isMSPComcell int = isnull((select CAST(value AS INT) from gxglobalparam where name = 'IsMSPCommcell'), 0)
	IF object_id('tempdb.dbo.#tmpClientList') IS NOT null DROP TABLE #tmpClientList
	create table #tmpClientList(
					id						int IDENTITY(1,1) NOT NULL,
					clientName				nvarchar(255),
					hostName				nvarchar(1024),
					displayName				nvarchar(255),
					vmguid					nvarchar(255),
					vmIPAddress				nvarchar(255),
					vmName					nvarchar(255),
					vmHostName				nvarchar(1024),
					vmGroup					nvarchar(64),
					vmOSName				nvarchar(255),
					vmOSVersion				nvarchar(255),
					vmProcessorType			nvarchar(64),
					flag					int,
					clientRenamed			int,
					appClientName			nvarchar(255),
					appClientHostName		nvarchar(1024),
					appClientFlags			int,
					appClientId				int,
					appClientVMName			nvarchar(255),
					appClientVMHostName		nvarchar(1024),
					appClientVMInstanceUUID	nvarchar(255),
					appClientVMGuid			nvarchar(255),
					appClientGuid			nvarchar(255),
					cvdPort					int,
					evmgrcPort				int,
					componentId				int,
					appTypeId				int,
					appId					int,
					releaseId				int,
					isCompInstalled			int,
					isOtherPkgsExists   	int,
					hostRenamed				int,
					instanceUUID			nvarchar(255),
					position			int,
					reasonForVMClientMatch	nvarchar(max)
	)
	-- currently expecting only one component , either SRM win, SRM Unix package
	INSERT INTO #tmpClientList
	SELECT SUBSTRING (T.cc.value('client[1]/clientEntity[1]/@clientName', 'nvarchar(255)'), 0, 255) AS a,
		  SUBSTRING (T.cc.value('client[1]/clientEntity[1]/@hostName', 'nvarchar(1024)'), 0, 1024),
		  SUBSTRING (T.cc.value('client[1]/clientEntity[1]/@displayName', 'nvarchar(255)'), 0, 255),
		  SUBSTRING (T.cc.value('clientProps[1]/@vmguid', 'nvarchar(255)'), 0, 255),
		  SUBSTRING (T.cc.value('clientProps[1]/@virtualServerIPAddress', 'nvarchar(255)'), 0, 255),
		  SUBSTRING (T.cc.value('clientProps[1]/@vmname', 'nvarchar(255)'), 0, 255),
		  SUBSTRING (T.cc.value('clientProps[1]/@vmhostname', 'nvarchar(1024)'), 0, 1024),
		  SUBSTRING (T.cc.value('clientGroups[1]/@clientGroupName', 'nvarchar(64)'), 0, 64),
		  SUBSTRING (T.cc.value('client[1]/osInfo[1]/OsDisplayInfo[1]/@OSName', 'nvarchar(255)'), 0, 255),
		  SUBSTRING (T.cc.value('client[1]/osInfo[1]/@Version', 'nvarchar(255)'), 0, 255),
		  SUBSTRING (T.cc.value('client[1]/osInfo[1]/OsDisplayInfo[1]/@ProcessorType', 'nvarchar(64)'), 0, 64),
		  0,
		  0,
		  null,
		  null,
		  0,
		  0,
		  null,
		  null,
		  null,
		  null,
		  null,
		  0,
		  0,
		  ISNULL(T.cc.value('../components[1]/componentInfo[1]/@ComponentId','int'),0) ,
		  0,
		  0,
		  0,
		  0,
		  0,
		  0,
		  null,
		  DENSE_RANK() OVER (ORDER BY cc) AS unique_cc,
		  null
	FROM @input.nodes('/CVInstallManager_ClientSetup/clientComposition/clientInfo') T(cc)
	SET @virtualServerInstanceId = @input.value('(/CVInstallManager_ClientSetup/clientComposition/clientInfo/clientProps/@vmInstanceId)[1]','int')
	SET @virtualServerInstanceType = ISNULL( (select attrVal FROM APP_InstanceProp WITH(NOLOCK) WHERE attrName ='Virtual Server Instance Type' AND modified =0 and componentNameId = @virtualServerInstanceId), 0)
	SET @vsaSubClientId=ISNULL( (SELECT  T.c.value('@vsaSubClientId', 'int') FROM   @input.nodes('CVInstallManager_ClientSetup') T(c)), 0)
	DECLARE @CompanyIds table(id integer)
	DECLARE @VMClientIds_Associated table(id integer)
	IF @vsaSubClientId <> 0
	BEGIN
		SELECT @vsaBackupSetId=backupSet,@vsaClientId=clientId from APP_Application WITH(NOLOCK) where id=@vsaSubClientId
		IF @isMSPComcell = 1
		BEGIN
			INSERT INTO @CompanyIds
select distinct companyId from UMSecurityAssociations WITH(NOLOCK) where companyId <> 0 and entityType5 = 7 and entityId5 = @vsaSubClientId
			IF NOT EXISTS(select 1 from @CompanyIds)
				INSERT INTO @CompanyIds
select distinct companyId from UMSecurityAssociations WITH(NOLOCK) where companyId <> 0 and entityType4 = 6 and entityId4 = @vsaBackupSetId	and entityId5=0
			IF NOT EXISTS(select 1 from @CompanyIds)
				INSERT INTO @CompanyIds
select distinct companyId from UMSecurityAssociations WITH(NOLOCK) where companyId <> 0 and entityType1 = 3 and entityId1 = @vsaClientId and entityId5=0 and entityId4 = 0
			delete CMP from @CompanyIds CMP
INNER JOIN UMDSProviders UMDS ON UMDS.id=CMP.id and (flags & 0x0002 = 0x0002  OR flags & 0x0010 = 0x0010)
			IF EXISTS(select 1 from @CompanyIds)
			BEGIN
				INSERT INTO @VMClientIds_Associated
					SELECT CGAssoc.ClientId from APP_ClientGroupAssoc CGAssoc WITH(NOLOCK)
INNER JOIN App_CompanyProp CP WITH(NOLOCK) ON CP.attrName = 'Associated Smart Client Group' AND CGAssoc.clientGroupId = CAST(CP.attrVal AS INT) AND CP.modIFied = 0
					INNER JOIN @CompanyIds C ON C.id=CP.componentNameId
			END
		END
	END
	IF object_id('tempdb.dbo.#tmpUpdateClientList') IS NOT null DROP TABLE #tmpUpdateClientList
	create table #tmpUpdateClientList(
					clientId 				int,
					clientName				nvarchar(255),
					displayName				nvarchar(255),
					clientRenamed			int,
					hostName				nvarchar(1024),
					cvdPort					int,
					conflict				int,
					hostNameConflict		int,
					agentInstalled			int
	)
	-- This variable decides whether to allow client rename or not for existing VM clients
	declare @strDontAllowVMRename varchar(256)
	declare @intDontAllowVMRename int
	SET @strDontAllowVMRename = ISNULL((select cast(value as varchar(256)) From GXGlobalParam with (nolock) where name = 'DontRenameVMClients'),'')
	SET @intDontAllowVMRename = 0
	IF ISNUMERIC(@strDontAllowVMRename) = 1
	BEGIN
		SET @intDontAllowVMRename = CAST(@strDontAllowVMRename AS INTEGER)
	END
	 -- This variable decides whether to use hostname match for associating VM to the existing client
    declare @intDontAllowHostNameMatch int
    SET  @intDontAllowHostNameMatch = ISNULL((select cast(value as INTEGER) From GXGlobalParam with (nolock) where name = 'DontAllowHostNameMatch' AND modified=0 ),0)
   	UPDATE #tmpClientList
	set instanceUUID = (CASE CHARINDEX(',',vmguid) WHEN
                                   0 THEN null
			ELSE SUBSTRING(vmguid, CHARINDEX(',',vmguid) + 1, len(vmguid))
			END	),
		vmguid = CASE WHEN CHARINDEX(',',vmguid) >0
                                 THEN SUBSTRING(vmguid,1, CHARINDEX(',',vmguid) - 1)
					ELSE vmguid END
	DECLARE  @createVMClientFlags INT=NULL
	DECLARE @clientGroupFlags INT
	-- 1-touch clients are transient and should not be considred
	IF object_id('tempdb.dbo.#tmponeTouchClients') IS NOT null DROP TABLE #tmponeTouchClients
	create table #tmponeTouchClients(
				clientId  int PRIMARY KEY
	)
	INSERT INTO #tmponeTouchClients
	SELECT distinct componentNameId from APP_ClientProp WITH (NOLOCK)
	where attrName ='1-Touch Client' and modified =0
	--There is a chance of duplicate BIOS GUIds For VMware, doing this for Non VMWare
	IF @virtualServerInstanceType != 0 AND @virtualServerInstanceType <> 101
	BEGIN
		--If the request has instance GUID and the bios GUID matches BIOS GUID,
		--Insert Instance GUID for client
		; WITH VMGUID (ClientId, GUIDName, GUID) AS
	(
		   SELECT componentNameId, attrName, attrVal
		   FROM   APP_ClientProp clProp WITH (NOLOCK) LEFT JOIN #tmponeTouchClients tmp ON tmp.clientId = clProp.componentNameId
		   WHERE  clProp.attrName IN ('Virtual Machine GUID', 'Virtual Machine Instance UUID')
				  AND clProp.modified = 0 AND tmp.clientId is null
	)
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT  A.ClientId, 'Virtual Machine Instance UUID', 1, tmp.instanceUUID, @unixTime, 0
			FROM #tmpClientList tmp
			INNER JOIN VMGUID A ON A.GUID = tmp.vmguid AND A.GUIDName = 'Virtual Machine GUID'
			LEFT OUTER JOIN VMGUID B ON B.GUIDName = 'Virtual Machine Instance UUID' AND B.ClientId = A.ClientId
			LEFT OUTER JOIN simInstalledPackages simPkg ON simPkg.ClientId = A.ClientId
			LEFT OUTER JOIN app_idaname iDAName ON iDAName.clientid = A.ClientId
			WHERE  B.ClientId IS NULL  AND tmp.instanceUUID IS NOT NULL AND simPkg.ClientId is NULL AND iDAName.clientid is NULL
	END
	SET  @createVMClientFlags= ISNULL((SELECT
									    	T.c.value('./@createVMClientFlags', 'int')
									   FROM
										@input.nodes('/CVInstallManager_ClientSetup/installFlags') T(c)),0)
	DECLARE @bcheckInLocalCommcell INT
	DECLARE @bMultiCommcell INT
	 IF EXISTS (SELECT 1 from App_CommCell WITH (NOLOCK) where id >2 )
		SET @bMultiCommcell=1
	ELSE
		SET @bMultiCommcell=0
	IF (@createVMClientFlags =8 )
	BEGIN
		SET @bcheckInLocalCommcell = 1
		--Get the matching VM client on local commcell and then foreign commcell if we don't find locally
		WHILE @bcheckInLocalCommcell = 1 OR (@bMultiCommcell = 1 AND @bcheckInLocalCommcell = 0)
		BEGIN
			-- update client id/flags if vmguid is present FOR AMAZON hostname only is sufficient
			UPDATE tmp SET
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'Client Property Guid Empty or Match AND Host Name Match'
				from #tmpClientList tmp
				inner join APP_Client as cl	WITH (NOLOCK) on tmp.hostName = cl.net_hostname
				LEFT join APP_ClientProp clProp WITH (NOLOCK) on clProp.componentNameId = cl.id AND clProp.attrName = 'Virtual Machine GUID' AND clProp.modified =0
				WHERE (clProp.attrVal is NULL OR clProp.attrVal = '' OR clProp.attrVal=tmp.vmGUID) AND tmp.appClientId = 0 AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
			UPDATE tmp SET
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'Deleted VM client With VM name and Host name match'
				from #tmpClientList tmp
				INNER join APP_ClientProp clProp1 WITH (NOLOCK) ON clProp1.attrName = 'Virtual Machine Host Name' AND clProp1.modified = 0  AND tmp.vmHostName = clProp1.attrVal
				inner join APP_Client as cl WITH (NOLOCK) on cl.id = clProp1.componentNameId
				inner join APP_ClientProp clProp WITH (NOLOCK) 	ON  clProp.componentNameId=cl.id AND clProp.attrName = 'Virtual Machine name' AND clProp.modified = 0 AND tmp.vmName = clProp.attrVal
				inner join APP_ClientProp clProp2 WITH (NOLOCK) ON clProp2.componentNameId=clProp.componentNameId AND clProp2.attrName = 'Virtual Machine Deletion Time' AND clProp2.modified = 0  AND  ISNULL(CAST(clProp2.attrVal As INT),0) <> 0
				INNER JOIN APP_ClientProp clProp3 WITH (NOLOCK) ON clProp3.componentNameId=clProp.componentNameId and clProp3.attrName = 'Virtual Machine Instance ID' AND clProp3.modified = 0 AND ISNULL(CAST(clProp3.attrVal As INT),0)=@virtualServerInstanceId
				INNER JOIN APP_ClientProp clProp4 WITH (NOLOCK) ON clProp4.componentNameId=clProp.componentNameId and clProp4.attrName = 'Sim OS Info' AND clProp4.modified = 0 AND (tmp.vmOSName = 'Any' OR ( tmp.vmOSName like '%Windows%' AND clProp4.attrVal like '%Windows%') OR ( tmp.vmOSName not like '%Windows%' AND clProp4.attrVal not like '%Windows%'))
				LEFT JOIN @VMClientIds_Associated VMClAssoc ON cl.id=VMClAssoc.id
				WHERE tmp.appClientId = 0 AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
				AND ( NOT EXISTS(select 1 from @CompanyIds) OR VMClAssoc.id is NOT NULL) -- There is no company association to the virtualization client or the VM client should be in the associated VM client list
			SET @bcheckInLocalCommcell = @bcheckInLocalCommcell - 1
		END
		UPDATE #tmpClientList SET appClientId = 0
			WHERE appClientId in (select appClientId from #tmpClientList GROUP BY appClientId HAVING  COUNT(*) > 1)
		TRUNCATE TABLE #tmpUpdateClientList
		-- TODO NO Underscores for host names. Add exception handling
		-- Also do this for non pseudo clients
		INSERT into #tmpUpdateClientList
		select tmp.appClientId,
				tmp.clientName,
				tmp.displayName,
				dbo.GenerateClientName(tmp.clientName, tmp.hostName, tmp.vmguid, tmp.instanceUUID, @createVMClientFlags),
				tmp.hostName,
				cl.cvdPort,
				0,
				0,
				0
		FROM #tmpClientList tmp
			INNER JOIN APP_Client cl
			on tmp.appClientId = cl.id
			AND tmp.appClientId <> 0
			where dbo.IsPseudoClient(cl.id) <> 1 OR EXISTS(SELECT ACP.componentNameId  FROM APP_ClientProp ACP WITH (NOLOCK) WHERE ACP.componentNameId = cl.id AND ( ACP.attrName = 'Virtual Server Discovered Clients'  OR ACP.attrName = 'Mini SRM Agent' ) AND attrval = '1' AND ACP.modified=0)
		--Change the subscript numbers to be unique for a client name
		update #tmpUpdateClientList
		set clientRenamed = #tmpUpdateClientList.clientRenamed + rankdata.crank - 1
		from
		(select C.clientId 'clientId', DENSE_RANK() over (partition by c.clientName,c.clientRenamed order by c.clientId)  'crank'
		from #tmpUpdateClientList c) rankdata
		where #tmpUpdateClientList.clientId = rankdata.clientId
		UPDATE tmp SET
			tmp.conflict = 1,tmp.hostNameConflict = 1,tmp.agentInstalled=1
		FROM #tmpUpdateClientList tmp
            INNER JOIN simInstalledPackages SIM
            ON SIM.ClientId = tmp.clientId
		UPDATE #tmpUpdateClientList SET conflict = 1
			WHERE EXISTS(select 1 from APP_Client where name = CASE WHEN clientRenamed = 0 THEN clientName ELSE clientName + '_' + CAST (clientRenamed AS NVARCHAR) END)
		UPDATE #tmpUpdateClientList SET hostNameConflict = 1
			WHERE EXISTS(select 1 from APP_Client cl where net_hostname = hostName AND cl.cvdPort = #tmpUpdateClientList.cvdPort)
		-- Rename the existing client only if override is not present
		IF @intDontAllowVMRename = 0
		BEGIN
			update cl set
				cl.name = CASE WHEN tmp.clientRenamed = 0 THEN tmp.clientName ELSE tmp.clientName + '_' + CAST (tmp.clientRenamed AS NVARCHAR) END
				FROM #tmpUpdateClientList tmp
				INNER JOIN APP_Client cl
				on cl.id = tmp.clientId
				where tmp.conflict <> 1
			update cl set
				cl.net_hostname = tmp.hostName
				FROM #tmpUpdateClientList tmp
				INNER JOIN APP_Client cl
				on cl.id = tmp.clientId
				where tmp.hostNameConflict <> 1
			update cl set
				cl.displayName = tmp.displayName
				FROM #tmpUpdateClientList tmp
				INNER JOIN APP_Client cl
				on cl.id = tmp.clientId	WHERE LEN(tmp.displayName) > 0	and tmp.agentInstalled <> 1
		END
		update tmp set
			tmp.appClientName = cl.name,
			tmp.appClientHostName = cl.net_hostname,
			tmp.flag = 1
			FROM #tmpClientList tmp
			INNER JOIN #tmpUpdateClientList tmpupg
			on tmp.appClientId = tmpupg.clientId
			INNER JOIN APP_Client cl
			on cl.id = tmp.appClientId
			where tmpupg.conflict <> 1
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT  tmp.ClientId, 'Virtual Machine Client Creation Conflict', 2, '1', @unixTime, 0
			FROM #tmpUpdateClientList tmp
			LEFT OUTER JOIN App_ClientProp cp
			on tmp.ClientId = cp.componentNameId AND cp.attrName = 'Virtual Machine Client Creation Conflict' and cp.modified = 0
			WHERE tmp.conflict = 1 AND cp.componentNameId IS NULL
	END
	ELSE
	BEGIN
		SET @bcheckInLocalCommcell = 1
		--Get the matching VM client on local commcell and then foreign commcell if we don't find locally
		WHILE @bcheckInLocalCommcell = 1 OR (@bMultiCommcell = 1 AND @bcheckInLocalCommcell = 0)
		BEGIN
			--If the instance guid does not exist in the xml then follow the below logic
			--Match hostname and VM Guid
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'Host Name and Guid match'
				from #tmpClientList tmp
				inner join APP_Client as cl WITH (NOLOCK) ON tmp.hostName = cl.net_hostname AND tmp.appClientId = 0 AND tmp.instanceUUID is NULL
				INNER join APP_ClientProp clProp WITH (NOLOCK) on clProp.componentNameId = cl.id AND clProp.attrName = 'Virtual Machine GUID' AND clProp.modified =0 AND tmp.vmGUID = clProp.attrVal
				WHERE  @bcheckInLocalCommcell = 0 OR cl.origCCId = 2
			--Match VM name and Guid
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'VM Name and Guid match'
				from #tmpClientList tmp
				inner join APP_ClientProp clProp WITH (NOLOCK) ON clProp.attrName = 'Virtual Machine GUID'	AND clProp.modified = 0  AND tmp.vmGUID = clProp.attrVal
				inner join APP_ClientProp clProp2 WITH (NOLOCK) ON clProp2.componentNameId=clProp.componentNameId AND clProp2.attrName = 'Virtual Machine name'	AND clProp2.modified = 0  AND tmp.vmName = clProp2.attrVal
				inner join APP_Client as cl ON cl.id=clProp.componentNameId
				WHERE tmp.appClientId = 0 AND tmp.instanceUUID is NULL AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
			--Match vm GUID in App_ClientProp table for the client
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'VM Guid match'
				from #tmpClientList tmp
				INNER JOIN APP_ClientProp as clProp WITH (NOLOCK) ON clProp.attrName = 'Virtual Machine GUID' AND clProp.modified =0 AND tmp.vmGUID = clProp.attrVal
				inner join APP_Client as cl WITH (NOLOCK) ON clProp.componentNameId = cl.id
				WHERE tmp.appClientId = 0 AND tmp.instanceUUID is NULL AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
			--Match vm GUID in App_Client table for the client
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'Client Guid match'
				from #tmpClientList tmp
				inner join APP_Client as cl WITH (NOLOCK) on tmp.vmGUID = CAST(cl.GUID AS nvarchar(256))
				WHERE tmp.appClientId = 0 AND tmp.instanceUUID is NULL AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
			SET @bcheckInLocalCommcell = @bcheckInLocalCommcell - 1
		END
		UPDATE #tmpClientList SET appClientId = 0
			WHERE appClientId in (select appClientId from #tmpClientList GROUP BY appClientId HAVING  COUNT(*) > 1)
		TRUNCATE TABLE #tmpUpdateClientList
		-- TODO NO Underscores for host names. Add exception handling
		-- Also do this for non pseudo clients
		INSERT into #tmpUpdateClientList
		select tmp.appClientId,
				tmp.clientName,
				tmp.displayName,
				dbo.GenerateClientName(tmp.clientName, tmp.hostName, tmp.vmguid, tmp.instanceUUID, @createVMClientFlags),
				tmp.hostName,
				cl.cvdPort,
				0,
				0,
				0
		FROM #tmpClientList tmp
			INNER JOIN APP_Client cl
			on tmp.appClientId = cl.id
			AND tmp.appClientId <> 0
			AND tmp.instanceUUID is NULL
			where dbo.IsPseudoClient(cl.id) <> 1 OR EXISTS(SELECT ACP.componentNameId  FROM APP_ClientProp ACP WHERE ACP.componentNameId = cl.id AND ( ACP.attrName = 'Virtual Server Discovered Clients'  OR ACP.attrName = 'Mini SRM Agent' ) AND attrval = '1' AND ACP.modified=0)
		--Change the subscript numbers to be unique for a client name
		update #tmpUpdateClientList
		set clientRenamed = #tmpUpdateClientList.clientRenamed + rankdata.crank - 1
		from
		(select C.clientId 'clientId', DENSE_RANK() over (partition by c.clientName,c.clientRenamed order by c.clientId)  'crank'
		from #tmpUpdateClientList c) rankdata
		where #tmpUpdateClientList.clientId = rankdata.clientId
		UPDATE tmp SET
			tmp.conflict = 1, tmp.hostNameConflict = 1,tmp.agentInstalled = 1
		FROM #tmpUpdateClientList tmp
            INNER JOIN simInstalledPackages SIM
            ON SIM.ClientId = tmp.clientId
		UPDATE #tmpUpdateClientList SET conflict = 1
			WHERE EXISTS(select 1 from APP_Client where name = CASE WHEN clientRenamed = 0 THEN clientName ELSE clientName + '_' + CAST (clientRenamed AS NVARCHAR) END)
		UPDATE #tmpUpdateClientList SET hostNameConflict = 1
			WHERE EXISTS(select 1 from APP_Client cl where net_hostname = hostName AND cl.cvdPort = #tmpUpdateClientList.cvdPort)
		-- Rename the existing client only if override is not present
		IF @intDontAllowVMRename = 0
		BEGIN
		update cl set
			cl.name = CASE WHEN tmp.clientRenamed = 0 THEN tmp.clientName ELSE tmp.clientName + '_' + CAST (tmp.clientRenamed AS NVARCHAR) END
			FROM #tmpUpdateClientList tmp
			INNER JOIN APP_Client cl
			on cl.id = tmp.clientId
			where tmp.conflict <> 1
		update cl set
				cl.net_hostname = tmp.hostName
				FROM #tmpUpdateClientList tmp
				INNER JOIN APP_Client cl
				on cl.id = tmp.clientId
				where tmp.hostNameConflict <> 1
		update cl set
				cl.displayName = tmp.displayName
				FROM #tmpUpdateClientList tmp
				INNER JOIN APP_Client cl
				on cl.id = tmp.clientId	WHERE LEN(tmp.displayName) > 0	and tmp.agentInstalled <> 1
		END
		update tmp set
			tmp.appClientName = cl.name,
			tmp.appClientHostName = cl.net_hostname,
			tmp.flag = 1
			FROM #tmpClientList tmp
			INNER JOIN #tmpUpdateClientList tmpupg
			on tmp.appClientId = tmpupg.clientId
			INNER JOIN APP_Client cl
			on cl.id = tmp.appClientId
			where tmpupg.conflict <> 1
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT  tmp.ClientId, 'Virtual Machine Client Creation Conflict', 2, '1', @unixTime, 0
			FROM #tmpUpdateClientList tmp
			LEFT OUTER JOIN App_ClientProp cp
			on tmp.ClientId = cp.componentNameId AND cp.attrName = 'Virtual Machine Client Creation Conflict' and cp.modified = 0
			WHERE tmp.conflict = 1 AND cp.componentNameId IS NULL
		SET @bcheckInLocalCommcell = 1
		--Get the matching VM client on local commcell and then foreign commcell if we don't find locally
		WHILE @bcheckInLocalCommcell = 1 OR (@bMultiCommcell = 1 AND @bcheckInLocalCommcell = 0)
		BEGIN
			--If the instance guid exists in the xml then follow the below logic
			--Match hostname and Instance UUID
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'Host Name and Instance UUID match'
				from #tmpClientList tmp
				inner join APP_Client as cl WITH (NOLOCK) on tmp.instanceUUID = CAST(cl.GUID AS NVARCHAR(255)) AND tmp.hostName = cl.net_hostname
				WHERE tmp.appClientId = 0 AND tmp.instanceUUID is not NULL AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
			--Match VM name and Instance UUID
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'VM Name and Instance UUID match'
				from #tmpClientList tmp
				inner join APP_ClientProp clProp WITH (NOLOCK) ON clProp.attrName = 'Virtual Machine Instance UUID' AND clProp.modified = 0  AND tmp.instanceUUID = clProp.attrVal
				inner join APP_ClientProp clProp2 WITH (NOLOCK)	ON clProp2.componentNameId=clProp.componentNameId AND clProp2.attrName = 'Virtual Machine name'	AND clProp2.modified = 0  AND tmp.vmName = clProp2.attrVal
				inner join APP_Client as cl WITH (NOLOCK) ON cl.id=clProp.componentNameId
				WHERE tmp.appClientId = 0 AND tmp.instanceUUID is not NULL AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
			--Match Instance UUID in App_clientProp
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'Instance UUID match'
				from #tmpClientList tmp
				INNER JOIN APP_ClientProp as clProp WITH (NOLOCK) ON clProp.attrName = 'Virtual Machine Instance UUID' AND clProp.modified =0 AND tmp.instanceUUID = clProp.attrVal
				inner join APP_Client as cl WITH (NOLOCK) ON clProp.componentNameId = cl.id
				WHERE tmp.appClientId = 0 AND tmp.instanceUUID is not NULL AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
			--Match Instance UUID in App_client
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'VM Instance UUID with Client Guid match'
				from #tmpClientList tmp
				inner join APP_Client as cl WITH (NOLOCK) on tmp.instanceUUID = CAST(cl.GUID AS NVARCHAR(255))
				WHERE tmp.appClientId = 0 AND tmp.instanceUUID is not NULL AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
			--we can set the client based on  BIOS GUID if there is no instanceUUID set for the existing client and if it is not VMWare
			IF @virtualServerInstanceType != 0 AND @virtualServerInstanceType <> 101
			BEGIN
				update tmp set
					tmp.appClientId = cl.id,
					tmp.appClientName = cl.name,
					tmp.appClientHostName = cl.net_hostname,
					tmp.appClientFlags = cl.specialClientFlags,
					tmp.cvdPort = cl.cvdPort,
					tmp.evmgrcPort = cl.evmgrcPort,
					tmp.releaseId = cl.releaseId,
					tmp.reasonForVMClientMatch = 'VM GUID match and Instance UUID does not Exists for the client'
					from #tmpClientList tmp
					INNER JOIN APP_ClientProp as clProp WITH (NOLOCK) ON clProp.attrName = 'Virtual Machine GUID' AND clProp.modified =0 AND tmp.vmguid = clProp.attrVal
					inner join APP_Client as cl WITH (NOLOCK) ON clProp.componentNameId = cl.id
					WHERE tmp.appClientId = 0 AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
					AND NOT EXISTS (select attrVal from app_clientprop where componentNameId=cl.id AND attrName = 'Virtual Machine Instance UUID' AND attrVal is NOT NULL AND attrVal != '' AND modified=0)
			END
			SET @bcheckInLocalCommcell = @bcheckInLocalCommcell - 1
		END
		TRUNCATE TABLE #tmpUpdateClientList
		-- TODO NO Underscores for host names. Add exception handling
		-- Also do this for non pseudo clients
		INSERT into #tmpUpdateClientList
		select tmp.appClientId,
				tmp.clientName,
				tmp.displayName,
				dbo.GenerateClientName(tmp.clientName, tmp.hostName, tmp.vmguid, tmp.instanceUUID, @createVMClientFlags),
				tmp.hostName,
				cl.cvdPort,
				0,
				0,
				0
		FROM #tmpClientList tmp
			INNER JOIN APP_Client cl
			on tmp.appClientId = cl.id
			AND tmp.appClientId <> 0
			AND tmp.instanceUUID is not NULL
			where dbo.IsPseudoClient(cl.id) <> 1 OR EXISTS(SELECT ACP.componentNameId  FROM APP_ClientProp ACP WITH (NOLOCK) WHERE ACP.componentNameId = cl.id AND ( ACP.attrName = 'Virtual Server Discovered Clients'  OR ACP.attrName = 'Mini SRM Agent' ) AND attrval = '1' AND ACP.modified=0)
		--Change the subscript numbers to be unique for a client name
		update #tmpUpdateClientList
		set clientRenamed = #tmpUpdateClientList.clientRenamed + rankdata.crank - 1
		from
		(select C.clientId 'clientId', DENSE_RANK() over (partition by c.clientName,c.clientRenamed order by c.clientId)  'crank'
		from #tmpUpdateClientList c) rankdata
		where #tmpUpdateClientList.clientId = rankdata.clientId
		UPDATE tmp SET
			tmp.conflict = 1, tmp.hostNameConflict = 1,tmp.agentInstalled = 1
		FROM #tmpUpdateClientList tmp
            INNER JOIN simInstalledPackages SIM
            ON SIM.ClientId = tmp.clientId
		UPDATE #tmpUpdateClientList SET conflict = 1
			WHERE EXISTS(select 1 from APP_Client where name = CASE WHEN clientRenamed = 0 THEN clientName ELSE clientName + '_' + CAST (clientRenamed AS NVARCHAR) END)
		UPDATE #tmpUpdateClientList SET hostNameConflict = 1
			WHERE EXISTS(select 1 from APP_Client cl where net_hostname = hostName AND cl.cvdPort = #tmpUpdateClientList.cvdPort)
		-- Rename the existing client only if override is not present
		IF @intDontAllowVMRename = 0
		BEGIN
		update cl set
			cl.name = CASE WHEN tmp.clientRenamed = 0 THEN tmp.clientName ELSE tmp.clientName + '_' + CAST (tmp.clientRenamed AS NVARCHAR) END
			FROM #tmpUpdateClientList tmp
			INNER JOIN APP_Client cl
			on cl.id = tmp.clientId
			where tmp.conflict <> 1
		update cl set
			cl.net_hostname = tmp.hostName
			FROM #tmpUpdateClientList tmp
			INNER JOIN APP_Client cl
			on cl.id = tmp.clientId
			where tmp.hostNameConflict <> 1
		update cl set
			cl.displayName = tmp.displayName
			FROM #tmpUpdateClientList tmp
			INNER JOIN APP_Client cl
			on cl.id = tmp.clientId	WHERE LEN(tmp.displayName) > 0	and tmp.agentInstalled <> 1
		END
		update tmp set
			tmp.appClientName = cl.name,
			tmp.appClientHostName = cl.net_hostname,
			tmp.flag = 1
			FROM #tmpClientList tmp
			INNER JOIN #tmpUpdateClientList tmpupg
			on tmp.appClientId = tmpupg.clientId
			INNER JOIN APP_Client cl
			on cl.id = tmp.appClientId
			where tmpupg.conflict <> 1
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT  tmp.ClientId, 'Virtual Machine Client Creation Conflict', 2, '1', @unixTime, 0
			FROM #tmpUpdateClientList tmp
			LEFT OUTER JOIN App_ClientProp cp
			on tmp.ClientId = cp.componentNameId AND cp.attrName = 'Virtual Machine Client Creation Conflict' and cp.modified = 0
			WHERE tmp.conflict = 1 AND cp.componentNameId IS NULL
		SET @bcheckInLocalCommcell = 1
		--Get the matching VM client on local commcell and then foreign commcell if we don't find locally
		WHILE @bcheckInLocalCommcell = 1 OR (@bMultiCommcell = 1 AND @bcheckInLocalCommcell = 0)
		BEGIN
			--If this doesn't match
			--Match the hostname and it doesn’t have any instance guid set and is also not a pseudo client
			IF @intDontAllowHostNameMatch =0
			BEGIN
				update tmp set
					tmp.appClientId = cl.id,
					tmp.appClientName = cl.name,
					tmp.appClientHostName = cl.net_hostname,
					tmp.appClientFlags = cl.specialClientFlags,
					tmp.cvdPort = cl.cvdPort,
					tmp.evmgrcPort = cl.evmgrcPort,
					tmp.releaseId = cl.releaseId,
					tmp.reasonForVMClientMatch = 'FQDN Host name match'
					from #tmpClientList tmp
					inner join APP_Client as cl WITH (NOLOCK)
					ON (tmp.hostName = cl.net_hostname OR cl.net_hostname in (Select _ID from dbo.SplitIDString(tmp.vmIPAddress)))
					AND CHARINDEX('.', cl.net_hostname) <> 0 AND CHARINDEX('.loc', cl.net_hostname) = 0 AND CHARINDEX('.localhost', cl.net_hostname) = 0
					AND tmp.appClientId = 0
					AND (dbo.IsPseudoClient(cl.id) <> 1 OR EXISTS(SELECT ACP.componentNameId  FROM APP_ClientProp ACP WITH (NOLOCK) WHERE ACP.componentNameId = cl.id AND ( ACP.attrName = 'Virtual Server Discovered Clients'  OR ACP.attrName = 'Mini SRM Agent' ) AND attrval = '1'))
					AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2)
					AND not exists(select * from APP_ClientProp P WITH (NOLOCK) where P.componentNameId = cl.id and p.attrName = 'Virtual Machine Instance UUID' AND modified=0)
					LEFT JOIN @VMClientIds_Associated VMClAssoc ON cl.id=VMClAssoc.id
					WHERE ( NOT EXISTS(select 1 from @CompanyIds) OR VMClAssoc.id is NOT NULL) -- There is no company association to the virtualization client or the VM client should be in the associated VM client list
			END
			--Match VM name alone if deletion time is set for the existing client and it's from same VSA instance
			update tmp set
				tmp.appClientId = cl.id,
				tmp.appClientName = cl.name,
				tmp.appClientHostName = cl.net_hostname,
				tmp.appClientFlags = cl.specialClientFlags,
				tmp.cvdPort = cl.cvdPort,
				tmp.evmgrcPort = cl.evmgrcPort,
				tmp.releaseId = cl.releaseId,
				tmp.reasonForVMClientMatch = 'Deleted VM client With VM name and Host name match'
				from #tmpClientList tmp
				INNER join APP_ClientProp clProp1 WITH (NOLOCK) ON clProp1.attrName = 'Virtual Machine Host Name' AND clProp1.modified = 0  AND tmp.vmHostName = clProp1.attrVal
				inner join APP_Client as cl	on cl.id = clProp1.componentNameId
				inner join APP_ClientProp clProp WITH (NOLOCK) ON  clProp.componentNameId=cl.id AND clProp.attrName = 'Virtual Machine name' AND clProp.modified = 0 AND tmp.vmName = clProp.attrVal
				inner join APP_ClientProp clProp2 WITH (NOLOCK) ON clProp2.componentNameId=clProp.componentNameId AND clProp2.attrName = 'Virtual Machine Deletion Time' AND clProp2.modified = 0  AND  ISNULL(CAST(clProp2.attrVal As INT),0) <> 0
				INNER JOIN APP_ClientProp clProp3 WITH (NOLOCK) ON clProp.componentNameId=clProp3.componentNameId and clProp3.attrName = 'Virtual Machine Instance ID' AND clProp3.modified = 0 AND ISNULL(CAST(clProp3.attrVal As INT),0)=@virtualServerInstanceId
				INNER JOIN APP_ClientProp clProp4 WITH (NOLOCK) ON clProp4.componentNameId=clProp.componentNameId and clProp4.attrName = 'Sim OS Info' AND clProp4.modified = 0 AND (tmp.vmOSName = 'Any' OR ( tmp.vmOSName like '%Windows%' AND clProp4.attrVal like '%Windows%') OR ( tmp.vmOSName not like '%Windows%' AND clProp4.attrVal not like '%Windows%'))
				LEFT JOIN @VMClientIds_Associated VMClAssoc ON cl.id=VMClAssoc.id
				WHERE tmp.appClientId = 0 AND ( @bcheckInLocalCommcell = 0 OR cl.origCCId = 2) AND
				( NOT EXISTS(select 1 from @CompanyIds) OR VMClAssoc.id is NOT NULL) -- There is no company association to the virtualization client or the VM client should be in the associated VM client list
			SET @bcheckInLocalCommcell = @bcheckInLocalCommcell - 1
		END
		UPDATE #tmpClientList SET appClientId = 0
			WHERE appClientId in (select appClientId from #tmpClientList GROUP BY appClientId HAVING  COUNT(*) > 1)
	END
	--Add VM client association to the history table
	DECLARE @DisableVMClientHistory INTEGER
	SET @DisableVMClientHistory=0
	--Get parameter whether to disable VM client history
	SELECT @DisableVMClientHistory = isnull(value, 0) FROM Gxglobalparam WITH (NOLOCK)	WHERE name = 'DisableVMClientHistory'
	IF @DisableVMClientHistory = 0
	BEGIN
		IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB.dbo.APPVMClientHistory') IS NOT NULL)
		BEGIN
			update tmp set
				tmp.appClientVMGuid = clProp.attrVal,
				tmp.appClientVMName	= clProp2.attrVal,
				tmp.appClientVMHostName	= clProp3.attrVal,
				tmp.appClientVMInstanceUUID = clProp4.attrVal,
				tmp.appClientGuid = cl.GUID
			from #tmpClientList tmp
			INNER JOIN APP_Client as cl	on cl.id = tmp.appClientId
			LEFT join APP_ClientProp clProp WITH (NOLOCK) on clProp.componentNameId = cl.id AND clProp.attrName = 'Virtual Machine GUID' AND clProp.modified =0
			LEFT join APP_ClientProp clProp2 WITH (NOLOCK) ON  clProp2.componentNameId=cl.id AND clProp2.attrName = 'Virtual Machine Name' AND clProp2.modified = 0
			LEFT join APP_ClientProp clProp3 WITH (NOLOCK) ON  clProp3.componentNameId=cl.id AND clProp3.attrName = 'Virtual Machine Host Name' AND clProp3.modified = 0
			LEFT join APP_ClientProp clProp4 WITH (NOLOCK) ON  clProp4.componentNameId=cl.id AND clProp4.attrName = 'Virtual Machine Instance UUID' AND clProp4.modified = 0
			INSERT INTO HistoryDB.dbo.APPVMClientHistory
				select appClientId,ISNULL(appClientVMName,''),ISNULL(appClientVMHostName,''),ISNULL(appClientVMInstanceUUID,''),ISNULL(appClientVMGuid,''),appClientHostName,appClientGuid,
				vmName,vmHostName,instanceUUID,vmguid,reasonForVMClientMatch,@unixTime
				from #tmpClientList tmp	WHERE appClientId<>0 AND (ISNULL(appClientVMName,'') <> vmName OR ISNULL(appClientVMHostName,'') <> vmHostName OR ISNULL(appClientVMInstanceUUID,'') <> instanceUUID
				OR ISNULL(appClientVMGuid,'') <> vmguid OR (appClientGuid <> vmguid AND appClientGuid <> instanceUUID) )
		END
	END
	MERGE APP_ClientProp AS T1
    USING #tmpClientList T2
    ON T1.componentNameId = T2.appClientId  AND T1.attrName='Virtual Server Discovered Clients' and T1.modified=0
    WHEN MATCHED and T1.attrVal <> '1' THEN
        UPDATE SET T1.attrVal ='1'
    WHEN NOT MATCHED and T2.appClientId <> 0 THEN
        INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
        VALUES(T2.appClientId,'Virtual Server Discovered Clients',2,'1',@unixTime,0);
	MERGE APP_ClientProp AS T1
    USING #tmpClientList T2
    ON T1.componentNameId = T2.appClientId  AND T1.attrName='Virtual Machine Name' and T1.modified=0
    WHEN MATCHED and T1.attrVal <> T2.vmName THEN
        UPDATE SET T1.attrVal = T2.vmName
    WHEN NOT MATCHED and T2.appClientId <> 0 THEN
        INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
        VALUES(T2.appClientId,'Virtual Machine Name',1,T2.vmName,@unixTime,0);
	MERGE APP_ClientProp AS T1
    USING #tmpClientList T2
    ON T1.componentNameId = T2.appClientId  AND T1.attrName='Virtual Machine Host Name' and T1.modified=0
    WHEN MATCHED and T1.attrVal <> T2.vmHostName THEN
        UPDATE SET T1.attrVal = T2.vmHostName
    WHEN NOT MATCHED and T2.appClientId <> 0 THEN
        INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
        VALUES(T2.appClientId,'Virtual Machine Host Name',1,T2.vmHostName,@unixTime,0);
	MERGE APP_ClientProp AS T1
    USING #tmpClientList T2
    ON T1.componentNameId = T2.appClientId  AND T1.attrName='Virtual Machine IP Address' and T1.modified=0
    WHEN MATCHED and T1.attrVal <> T2.vmIPAddress THEN
        UPDATE SET T1.attrVal = T2.vmIPAddress
    WHEN NOT MATCHED and T2.appClientId <> 0 THEN
        INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
        VALUES(T2.appClientId,'Virtual Machine IP Address',1,T2.vmIPAddress,@unixTime,0);
	MERGE APP_ClientProp AS T1
    USING #tmpClientList T2
    ON T1.componentNameId = T2.appClientId  AND T1.attrName='Virtual Machine GUID' and T1.modified=0
    WHEN MATCHED AND T2.vmguid IS NOT NULL AND T1.attrVal <> T2.vmguid THEN
        UPDATE SET T1.attrVal = T2.vmguid
    WHEN NOT MATCHED AND T2.vmguid IS NOT NULL and T2.appClientId <> 0 THEN
        INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
        VALUES(T2.appClientId,'Virtual Machine GUID',1,T2.vmguid,@unixTime,0);
	--Age the current property
	MERGE APP_ClientProp AS T1
	USING #tmpClientList T2
	ON T1.componentNameId = T2.appClientId  AND T1.attrName='Virtual Machine Instance UUID' and T1.modified=0
	WHEN MATCHED AND T2.instanceUUID IS NOT NULL and T1.attrVal <> T2.instanceUUID THEN
		UPDATE SET T1.modified = @unixTime;
   --insert new property
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		select tmp.appClientId,'Virtual Machine Instance UUID',1,tmp.instanceUUID,@unixTime,0 from #tmpClientList tmp
		LEFT OUTER JOIN App_ClientProp cp on tmp.appClientId = cp.componentNameId AND cp.attrName = 'Virtual Machine Instance UUID' and cp.modified = 0
		WHERE tmp.instanceUUID IS NOT NULL AND tmp.appClientId <> 0 AND cp.componentNameId IS NULL
	--retain only top 5 records
	 ; with ACP as
    (
        select ROW_NUMBER() over(PARTITION BY componentNameId,attrname order by created desc) as rank, * from app_clientprop where attrname = 'Virtual Machine Instance UUID'
    )
    delete from ACP where ACP.rank > 5
	MERGE APP_ClientProp AS T1
    USING #tmpClientList T2
    ON T1.componentNameId = T2.appClientId  AND T1.attrName='Sim OS Info' and T1.modified=0
    WHEN MATCHED and T2.appClientFlags = 11 AND T2.vmOSName <> 'Any' and T1.attrVal <> (T2.vmOSName + ':-' + T2.vmOSVersion + ':- :-' + T2.vmProcessorType) THEN
        UPDATE SET T1.attrVal = (T2.vmOSName + ':-' + T2.vmOSVersion + ':- :-' + T2.vmProcessorType)
    WHEN NOT MATCHED and T2.appClientFlags = 11 AND T2.vmOSName <> 'Any' and T2.appClientId <> 0 THEN
        INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
        VALUES(T2.appClientId,'Sim OS Info',1,(T2.vmOSName + ':-' + T2.vmOSVersion + ':- :-' + T2.vmProcessorType),@unixTime,0);
	Update cl set cl.simOperatingSystemId=CASE
											WHEN (tmp.vmOSName like '%Windows%') THEN 21
											ELSE 20
										END
			FROM App_Client cl
			INNER JOIN #tmpClientList tmp ON cl.id = tmp.appClientId and tmp.appClientFlags = 11 AND tmp.vmOSName <> 'Any'
UPDATE clGroup set clGroup.flag = ( clGroup.flag | 0x2000)
		FROM APP_ClientGroup clGroup
INNER JOIN #tmpClientList tmp ON clGroup.name=tmp.vmGroup AND ( clGroup.flag & 0x2000) != 0x2000
	-- re associate vms back to client group
	MERGE APP_ClientGroupAssoc AS T1
    USING (Select tmp.appClientId appClientId, clGroup.id clientGroupId  from #tmpClientList tmp
					INNER JOIN APP_ClientGroup clGroup ON clGroup.name=tmp.vmGroup WHERE tmp.appClientId <> 0 ) T2
	ON T1.clientGroupId = T2.clientGroupId AND T1.clientId = T2.appClientId
	WHEN NOT MATCHED THEN
		INSERT(clientGroupId,clientId) Values(T2.clientGroupId,T2.appClientId);
	declare @vmName nvarchar(255)
	declare @vmHostName nvarchar(1024)
	declare @appClientName nvarchar(255)
	declare @appClientHostName nvarchar(1024)
	declare @appClientId int
	declare @vmFlag int
	declare @position int
	declare tempclients cursor for
		select vmName, vmHostName, appClientId,flag, appClientName, appClientHostName, position from #tmpClientList where appClientId <> 0
	open tempclients
		fetch next from tempclients into @vmName, @vmHostName, @appClientId, @vmFlag, @appClientName, @appClientHostName, @position
	WHILE @@FETCH_STATUS = 0
	begin
		-- The We have updated the client name/hostname in app_client table, need to update the XML
		IF @vmFlag = 1
		BEGIN
			set @input.modify('replace value of (/CVInstallManager_ClientSetup/clientComposition[sql:variable("@position")]/clientInfo/client/clientEntity[@clientName=sql:variable("@vmName")]/@clientName)[1] with sql:variable("@appClientName")')
			set @input.modify('replace value of (/CVInstallManager_ClientSetup/clientComposition[sql:variable("@position")]/clientInfo/client/clientEntity[@clientName=sql:variable("@appClientName")]/@hostName)[1] with sql:variable("@appClientHostName")')
		END
		fetch next from tempclients into @vmName, @vmHostName, @appClientId, @vmFlag, @appClientName, @appClientHostName, @position
	end
	close  tempclients
	deallocate  tempclients
	--Generate the subscript number based on App_Client
	UPDATE #tmpClientList
	SET clientRenamed = dbo.GenerateClientName(clientName, hostName, vmguid, instanceUUID, @createVMClientFlags)
	FROM #tmpClientList
	where appClientId = 0
	--Change the subscript numbers to be unique for a client name
	update #tmpClientList
	set clientRenamed = #tmpClientList.clientRenamed + rankdata.crank - 1
	from
	(select C.id 'id', DENSE_RANK() over (partition by c.clientName,c.clientRenamed order by c.id)  'crank'
	from #tmpClientList c) rankdata
	where #tmpClientList.id = rankdata.id
	--Modify the input xml to have generated client names
	declare @currentName nvarchar(255)
	declare @currentRenamed nvarchar(255)
	declare @currPkgsExists			int
	declare @isSRMAppTypeInstalled	int
	declare @componentId			int
	declare @currentHostName		nvarchar(1024)
	declare @currentHostRenamed		nvarchar(255)
	declare tempclients cursor for
		  select clientName, clientRenamed, hostName, hostRenamed, position from #tmpClientList where clientRenamed <> 0 OR hostRenamed <> 0
	open tempclients
	fetch next from tempclients into @currentName, @currentRenamed, @currentHostName, @currentHostRenamed, @position
	WHILE @@FETCH_STATUS = 0
	begin
		declare @replaceStr		nvarchar(255)
		declare @replaceStrHost	nvarchar(255)
		if @currentRenamed = 0
			begin
				set @replaceStr = @currentName
			end
		else
			begin
				set @replaceStr = @currentName + '_' + CONVERT(nvarchar(10), @currentRenamed)
			end
		set @input.modify('replace value of (/CVInstallManager_ClientSetup/clientComposition[sql:variable("@position")]/clientInfo/client/clientEntity[@clientName=sql:variable("@currentName")]/@clientName)[1] with sql:variable("@replaceStr")')
		if @currentHostRenamed = 0
			begin
				set @replaceStrHost = @currentHostName
			end
		else
			begin
				set @replaceStrHost = @currentHostName + '_' + CONVERT(nvarchar(10), @currentHostRenamed )
			end
		set @input.modify('replace value of (/CVInstallManager_ClientSetup/clientComposition[sql:variable("@position")]/clientInfo/client/clientEntity[@clientName=sql:variable("@replaceStr")]/@hostName)[1] with sql:variable("@replaceStrHost")')
		fetch next from tempclients into @currentName, @currentRenamed, @currentHostName, @currentHostRenamed, @position
	end
	close  tempclients
	deallocate  tempclients
    declare @currentCvdPort int
    declare @currentEvmgrcPort int
	declare @currentVMGUID nvarchar(256)
	declare @currentInstanceUUID nvarchar(256)
	declare @tempstrGUID nvarchar(512)
	declare tempclients cursor for
		  select clientName, appClientName, appClientHostName, appClientId , cvdPort, evmgrcPort, vmguid, isCompInstalled, isOtherPkgsExists, componentId, instanceUUID from #tmpClientList where appClientId <> 0
	open tempclients
		fetch next from tempclients into @currentName, @appClientName, @appClientHostName, @appClientId, @currentCvdPort, @currentEvmgrcPort, @currentVMGUID, @isSRMAppTypeInstalled, @currPkgsExists,@componentId, @currentInstanceUUID
	WHILE @@FETCH_STATUS = 0
	begin
		IF ( @currentInstanceUUID IS NULL)
			set @input.modify('insert attribute clientId {sql:variable("@appClientId")} into (/CVInstallManager_ClientSetup/clientComposition/clientInfo/clientProps[lower-case(@vmguid)=lower-case(sql:variable("@currentVMGUID"))]/../client/clientEntity)[1]')
		ELSE
		begin
			SET @tempstrGUID = @currentVMGUID + ',' + @currentInstanceUUID
			set @input.modify('insert attribute clientId {sql:variable("@appClientId")} into (/CVInstallManager_ClientSetup/clientComposition/clientInfo/clientProps[lower-case(@vmguid)=lower-case(sql:variable("@tempstrGUID")) ]/../client/clientEntity)[1]')
		end
		set @input.modify('replace value of (/CVInstallManager_ClientSetup/clientComposition/clientInfo/client/clientEntity[lower-case(@clientName)=lower-case(sql:variable("@appClientName"))]/../@cvdPort)[1] with sql:variable("@currentCvdPort")')
		set @input.modify('replace value of (/CVInstallManager_ClientSetup/clientComposition/clientInfo/client/clientEntity[lower-case(@clientName)=lower-case(sql:variable("@appClientName"))]/../@evmgrcPort)[1] with sql:variable("@currentEvmgrcPort")')
		set @input.modify('replace value of (/CVInstallManager_ClientSetup/clientComposition/clientInfo/client/clientEntity[lower-case(@clientName)=lower-case(sql:variable("@appClientName"))]/@hostName)[1] with sql:variable("@appClientHostName")')
		IF (@componentId <> 0 )
		BEGIN
			IF ( @isSRMAppTypeInstalled = 0 )
			BEGIN
				IF ( @currPkgsExists <> 0 )
				BEGIN
					set @input.modify('replace value of (/CVInstallManager_ClientSetup/clientComposition/clientInfo/clientProps[lower-case(@vmguid)=lower-case(sql:variable("@currentVMGUID"))]/@ConsumeLicense)[1] with sql:variable("@currPkgsExists")')
				END
				-- the request will be sent to SIM, so let us take out, installdir, jobresults dir, binary set id etc
				set @input.modify('delete (/CVInstallManager_ClientSetup/clientComposition/clientInfo/client/clientEntity[lower-case(@clientName)=lower-case(sql:variable("@appClientName"))]/../@installDirectory)')
				set @input.modify('delete (/CVInstallManager_ClientSetup/clientComposition/clientInfo/client/clientEntity[lower-case(@clientName)=lower-case(sql:variable("@appClientName"))]/../osInfo[1])')
				set @input.modify('delete (/CVInstallManager_ClientSetup/clientComposition/clientInfo/client/clientEntity[lower-case(@clientName)=lower-case(sql:variable("@appClientName"))]/../jobResulsDir[1])')
				set @input.modify('delete (/CVInstallManager_ClientSetup/clientComposition/clientInfo/clientProps[lower-case(@vmguid)=lower-case(sql:variable("@currentVMGUID"))]/@BinarySetID)')
			END
			set @input.modify('insert attribute installedState {sql:variable("@isSRMAppTypeInstalled")} into (/CVInstallManager_ClientSetup/clientComposition/clientInfo/clientProps[lower-case(@vmguid)=lower-case(sql:variable("@currentVMGUID"))]/../../components/componentInfo)[1]')
		END
		fetch next from tempclients into @currentName, @appClientName, @appClientHostName, @appClientId, @currentCvdPort, @currentEvmgrcPort, @currentVMGUID, @isSRMAppTypeInstalled, @currPkgsExists,@componentId, @currentInstanceUUID
	end
	close  tempclients
	deallocate  tempclients
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
		--Close cursor
	IF ( CURSOR_STATUS('local', 'tempclients') >= 0  )/* cursor is open */
		CLOSE tempclients
	IF ( CURSOR_STATUS('local','tempclients') = -1 ) /* cursor is closed */
		DEALLOCATE tempclients
	SET @input = (SELECT (SELECT
		@errorCode as '@errorCode',
		@errorStr as '@ErrorString' FOR XML PATH('SimError'), TYPE) FOR XML PATH('CVInstallManager_ClientSetup'), TYPE)
END CATCH
select @input
IF object_id('tempdb.dbo.#tmpClientList') IS NOT null DROP TABLE #tmpClientList
IF object_id('tempdb.dbo.#tmpUpdateClientList') IS NOT null DROP TABLE #tmpUpdateClientList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ResolveDuplicateClientName')
	delete from GxQscripts where name = 'ResolveDuplicateClientName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ResolveDuplicateClientName')
	delete from GXDBVersions where aliasname = 'ResolveDuplicateClientName'
GO

insert into GXDBVersions values(2, 'ResolveDuplicateClientName',  'v1.51.2.23.8.1', 'ResolveDuplicateClientName', 'v1.51.2.23.8.1')
GO

