

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ReplaceGUIDWithVMName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ReplaceGUIDWithVMName.sp,v $ $Id: ReplaceGUIDWithVMName.sp,v 1.2.86.2 2020/08/14 14:35:18 scheppuri Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ReplaceGUIDWithVMName')
BEGIN
	print '>>> Drop Stored Procedure: ReplaceGUIDWithVMName <<<'
	drop procedure ReplaceGUIDWithVMName
END
IF EXISTS (select * from GxQscripts where name='ReplaceGUIDWithVMName')
	delete from GxQscripts where name = 'ReplaceGUIDWithVMName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ReplaceGUIDWithVMName')
	delete from GXDBVersions where aliasname = 'ReplaceGUIDWithVMName'
GO
print '... Creating Procedure: ReplaceGUIDWithVMName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ReplaceGUIDWithVMName
  @i_jobOptions XML
AS
  DECLARE @o_jobOptions XML;
BEGIN
SET NOCOUNT ON
	DECLARE @tbl TABLE (sourcePath NVARCHAR(MAX), VMGUID NVARCHAR(128), VMName NVARCHAR(1024), newPath NVARCHAR(MAX))
	INSERT INTO @tbl (sourcePath)
	SELECT  T.cc.value('@val', 'nvarchar(255)')
	FROM @i_jobOptions.nodes('/TMMsg_JobOption/restoreOptions/fileOption/sourceItem') T(cc)
	UPDATE @tbl SET VMGUID = SUBSTRING(sourcePath, CHARINDEX('\', sourcePath)+1, 36)
	UPDATE	@tbl SET VMName = C.name
	FROM	@tbl, APP_Client C, APP_ClientProp CP
	WHERE	C.id = CP.componentNameId
		AND	(CP.attrName = 'Virtual Machine GUID' OR CP.attrName = 'Virtual Machine Instance UUID') AND CP.attrVal = VMGUID AND CP.modified=0
	UPDATE @tbl SET newPath = REPLACE(sourcePath, VMGUID, VMName)
	DECLARE @srcPath NVARCHAR(128)
	DECLARE @newPath NVARCHAR(1024)
	DECLARE guidToName cursor for
	select sourcePath, newPath from @tbl WHERE newPath is not null
	open guidtoName
	fetch next from guidToName into @srcPath, @newPath
	WHILE @@FETCH_STATUS = 0
	BEGIN
		set @i_jobOptions.modify('replace value of (/TMMsg_JobOption/restoreOptions/fileOption/sourceItem[@val=sql:variable("@srcPath")]/@val)[1] with sql:variable("@newPath")')
		fetch next from guidToName into @srcPath, @newPath
	END
	SELECT @i_jobOptions
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'ReplaceGUIDWithVMName')
	delete from GxQscripts where name = 'ReplaceGUIDWithVMName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ReplaceGUIDWithVMName')
	delete from GXDBVersions where aliasname = 'ReplaceGUIDWithVMName'
GO

insert into GXDBVersions values(2, 'ReplaceGUIDWithVMName',  '00010002008600020000', 'ReplaceGUIDWithVMName', '00010002008600020000')
GO

