

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RemoveTPPMConfigurationForCA.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  RemoveTPPMConfigurationForCA
--  | Description:   Remove the firewall configuration for index server node clients and content analyzer client from firewall configuration table.
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RemoveTPPMConfigurationForCA.sp,v $ $Id: RemoveTPPMConfigurationForCA.sp,v 1.1.2.1 2020/07/01 15:51:50 jjindal Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RemoveTPPMConfigurationForCA')
BEGIN
	print '>>> Drop Stored Procedure: RemoveTPPMConfigurationForCA <<<'
	drop procedure RemoveTPPMConfigurationForCA
END
IF EXISTS (select * from GxQscripts where name='RemoveTPPMConfigurationForCA')
	delete from GxQscripts where name = 'RemoveTPPMConfigurationForCA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RemoveTPPMConfigurationForCA')
	delete from GXDBVersions where aliasname = 'RemoveTPPMConfigurationForCA'
GO
print '... Creating Procedure: RemoveTPPMConfigurationForCA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RemoveTPPMConfigurationForCA
  @i_dcPlanID INTEGER = 0,
  @i_datasourceId INTEGER = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @caCloudStr NVARCHAR(10)
DECLARE @isPlanExist as INT =0
DECLARE @isDSExist as INT =0
DECLARE @ispsuedoClient INT =0
DECLARE @ISCloudID INT =0
DECLARE @SourceISClient TABLE (clientID INT PRIMARY KEY)
DECLARE @SEPARATOR CHAR = ','
DECLARE @fromClientID INT
DECLARE @caCloudId INT = 0
DECLARE @caClientId INT = 0
DECLARE @caInstanceName NVARCHAR(256) =N''
DECLARE @caPortNo NVARCHAR(256) =N''
DECLARE @IndexServerClientIDs NVARCHAR(MAX) = 0
DECLARE @perfrormDelete INT = 0
DECLARE @caPropertyID INT = 0
DECLARE @planPropertyID INT = 0
IF @i_datasourceId <> 0 OR @i_dcPlanID <>0
BEGIN
    SELECT @caPropertyID = PropertyId from SEProperty (NOLOCK) where PropertyName = 'cacloudid'
	SELECT @planPropertyID = PropertyId from SEProperty (NOLOCK) where PropertyName = 'dcplanid'
	--Get Content Analyzer cloud ID and Index Server Cloud ID
	IF @i_dcPlanID <> 0
	BEGIN
SELECT @caCloudId= dbo.AppPlanGetEntityValueV2(@i_dcPlanID,'Content Analyzer Cloud Id',default) --'Content Analyzer Cloud Id' 'Content Analyzer Cloud Id'
SELECT @ispsuedoClient= dbo.AppPlanGetEntityValueV2(@i_dcPlanID,'Analytics Index Server Id',default) --'Analytics Index Server Id' - 'Analytics Index Server Id'
		IF @caCloudId <> 0
		BEGIN
			SELECT @caCloudStr = CAST(@caCloudId  AS NVARCHAR(10))
			--Check if any other plan exist with similar confiuration
			SELECT @isPlanExist =
			(CASE WHEN EXISTS
				(
					SELECT top 1 IS_app.componentNameId FROM  App_PlanProp IS_APP (NOLOCK)
					JOIN App_PlanProp CA_APP (NOLOCK) ON
					IS_APP.componentNameId = CA_APP.componentNameId
WHERE CA_APP.attrVal = @caCloudId  AND CA_APP.attrName = 'Content Analyzer Cloud Id'
AND IS_APP.attrVal = @ispsuedoClient  AND IS_APP.attrName = 'Analytics Index Server Id'
					AND IS_APP.componentNameId <> @i_dcPlanID
				)
			THEN 1 ELSE 0
			END
			) ;
			-- Check if any data source is having the similar configuration
			;WITH DSBasedOnIS AS
			(select  SD.DataSourceId AS DataSourceId from SEDataSource SD (NOLOCK)
			JOIN SECollectionInfo SO (NOLOCK) ON
			SO.CoreId = sd.CoreId
			JOIN DM2Cloud DC (NOLOCK) ON
			DC.cloudId = SO.CloudID
			where dc.pseudoClientId = @ispsuedoClient)
			SELECT @isDSExist =
				(CASE WHEN EXISTS
					(
						select  top 1 CAP.datasourceid FROM SEDataSourceProperty CAP (NOLOCK)
						WHERE CAP.PropertyId  = @caPropertyID
						AND CAP.datasourceid  NOT IN(
							SELECT DCP.datasourceid FROM SEDataSourceProperty DCP (NOLOCK)
							WHERE DCP.PropertyId  = @planPropertyID
							)
						AND CAP.DataSourceId IN (SELECT DataSourceId from DSBasedOnIS)
						AND CAP.PropertyValue = @caCloudStr
					)
				THEN 1 ELSE 0
				END
				) ;
			IF @isPlanExist <>  1 AND @isDSExist <>  1 -- If no plan and no data source exist with same Index Server and Content Analyzer than proceed
			BEGIN
				--Get client ID where Index Server is installed
				INSERT INTO @SourceISClient
				SELECT DSC.ClientId
				FROM DM2SearchServerCoreInfo DSC (NOLOCK)
				JOIN DM2Cloud DC (NOLOCK)
				ON DSC.cloudId = DC.cloudId
where DC.CloudType IN (1, 5) AND pseudoClientId =dbo.AppPlanGetEntityValueV2(@i_dcPlanID,'Analytics Index Server Id',default) -- 'Analytics Index Server Id' - 'Analytics Index Server Id'
				SET @perfrormDelete = 1
			END
		END
	END
	ELSE IF @i_datasourceId <> 0
	BEGIN
		SELECT @caCloudId =  DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
		WHERE DSP.DataSourceId = @i_datasourceId
		AND DSP.PropertyId =@caPropertyID
		IF @caCloudId <> 0
		BEGIN
			--CHeck if data source is a part of plan
			SELECT @isPlanExist =
				(CASE WHEN EXISTS
					(
						select top 1 DataSourceId from SEDataSourceProperty  (NOLOCK)
						where PropertyId = @planPropertyID
						AND DataSourceId = @i_datasourceId
					)
				THEN 1 ELSE 0
				END
				) ;
			-- Check if any other data source is having similar configuration
			SELECT @ISCloudID = SEC.cloudId From SECollectionInfo SEC (NOLOCK)
				JOIN SEDataSource SD1 (NOLOCK)
				ON SD1.CoreId = SEC.CoreId
				where SD1.DataSourceId  = @i_datasourceId
			SELECT @isDSExist =
				(CASE WHEN EXISTS
					(
						SELECT SD.DataSourceId FROM SEDataSource SD (NOLOCK)
						JOIN SECollectionInfo SC (NOLOCK) ON
						SD.CoreId = SC.CoreId
						JOIN SEDataSourceProperty CAP (NOLOCK) ON
						CAP.DataSourceId = SD.DataSourceId
						WHERE
							CAP.PropertyId  = @caPropertyID
							AND CAP.PropertyValue IN(SELECT propertyValue From SEDataSourceProperty (NOLOCK) where DataSourceId = @i_datasourceId AND PropertyId  = @caPropertyID )
							AND SC.CloudID = @ISCloudID
							AND SD.DataSourceId <> @i_datasourceId
					)
				THEN 1 ELSE 0
				END
				) ;
			IF @isPlanExist <>  1 AND @isDSExist <>  1 -- If no plan and no data source exist with same Index Server and Content Analyzer than proceed
			BEGIN
				SELECT @caCloudId =  DSP.PropertyValue FROM SEDataSourceProperty DSP (NOLOCK)
				WHERE DSP.DataSourceId = @i_datasourceId
				AND DSP.PropertyId =@caPropertyID
				--Get client ID where Index Server is installed
				INSERT INTO @SourceISClient
				SELECT DSC.ClientId
				FROM DM2SearchServerCoreInfo DSC (NOLOCK)
				JOIN  SECollectionInfo SC (NOLOCK)
				ON DSC.CloudId = SC.cloudID
				JOIN SEDataSource SD (NOLOCK)
				ON SC.CoreId = SD.CoreId
				where SD.DataSourceId = @i_datasourceId
				SET @perfrormDelete = 1
			END
		END
	END
	-- IF perfrormDelete is 1 AND caCloudId has valid cloud ID
	IF @perfrormDelete  = 1 AND @caCloudId <> 0
	BEGIN
		--Get client ID where content analyzer is installed and get the port number for the content extractor service.
SELECT @caClientId = ClientId FROM DM2SearchServerCoreInfo (NOLOCK) where CloudId = @caCloudId and cloudType = 2
		SELECT @caInstanceName = attrVal FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @caClientId AND attrName = 'Galaxy Instance name' and modified = 0
		SELECT @caPortNo = ISNULL(attrVal,
		(CASE WHEN @caInstanceName = 'Instance001' THEN '22000'
		ELSE ('2200'+ SUBSTRING (@caInstanceName, LEN(@caInstanceName), LEN(@caInstanceName))) END))
		FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @caClientId AND attrName = 'contentPreviewPort' and modified = 0
		IF @caClientID<>0 AND @caPortNo<>0
		BEGIN
			WHILE EXISTS(SELECT TOP 1 clientID FROM @SourceISClient )
			BEGIN
				SELECT @fromClientID = (SELECT TOP 1 clientID FROM @SourceISClient)
				IF @fromClientID <> @caClientId
				BEGIN
IF EXISTS (SELECT 1 FROM APP_FirewallTPPM WHERE tppmType=9 AND fromEntityType=3 AND fromEntityId=@fromClientID
AND fromPortNumber=0 AND toEntityType=3 AND toEntityId=@caClientId AND toPortNumber=@caPortNo AND status=1)
DELETE FROM APP_FirewallTPPM WHERE tppmType=9 AND fromEntityType=3 AND fromEntityId=@fromClientID
AND fromPortNumber=0 AND toEntityType=3 AND toEntityId=@caClientId AND toPortNumber=@caPortNo AND status=1
				END
				DELETE TOP (1) FROM @SourceISClient WHERE clientID = @fromClientID
			END
		END
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RemoveTPPMConfigurationForCA')
	delete from GxQscripts where name = 'RemoveTPPMConfigurationForCA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RemoveTPPMConfigurationForCA')
	delete from GXDBVersions where aliasname = 'RemoveTPPMConfigurationForCA'
GO

insert into GXDBVersions values(2, 'RemoveTPPMConfigurationForCA',  '00010001000200010000', 'RemoveTPPMConfigurationForCA', '00010001000200010000')
GO

