

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RemoveSqlUncommittedBackupEntries_Azure.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RemoveSqlUncommittedBackupEntries_Azure.sp,v $ $Id: RemoveSqlUncommittedBackupEntries_Azure.sp,v 1.1.2.2 2018/03/27 08:40:34 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RemoveSqlUncommittedBackupEntries_Azure
--  |
--  | Description:
--  |  Removes one Azure sql uncommitted backup entry by database name
--  |
--  |   Revisions  Author				Description
--  |   ---------  --------------		---------------------------------------------
--  |   1.0        wliao				Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RemoveSqlUncommittedBackupEntries_Azure <<<'

IF EXISTS (select * from sysobjects where name='RemoveSqlUncommittedBackupEntries_Azure')
	drop procedure RemoveSqlUncommittedBackupEntries_Azure
IF EXISTS (select * from GxQscripts where name='RemoveSqlUncommittedBackupEntries_Azure')
	delete from GxQscripts where name = 'RemoveSqlUncommittedBackupEntries_Azure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RemoveSqlUncommittedBackupEntries_Azure')
	delete from GXDBVersions where aliasname = 'RemoveSqlUncommittedBackupEntries_Azure'
GO
print '... Creating Procedure: RemoveSqlUncommittedBackupEntries_Azure'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RemoveSqlUncommittedBackupEntries_Azure
  @i_jobId INTEGER,
  @i_backupType INTEGER,
  @i_dbName NVARCHAR(256)
AS
  DECLARE @o_backup_set_id INTEGER; 
  DECLARE @o_clientId INTEGER;
  DECLARE @o_instanceId INTEGER;
  DECLARE @o_instanceName VARCHAR(256);
  DECLARE @o_databaseName NVARCHAR(256);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @i_sqlNameId integer
DECLARE @lastgoodDBbackupId integer
set @lastgoodDBbackupId = 0
select @i_sqlNameId = (select id from sqlNames where sqlid = (select id from sqlNames2 where name = @i_dbName and type = 1) and type = 1)
IF object_id('tempdb.dbo.#SQLDBINFOPERPHASETABLE') IS NOT null DROP TABLE #SQLDBINFOPERPHASETABLE
IF object_id('tempdb.dbo.#RETURNTABLEENTRIES') IS NOT null DROP TABLE #RETURNTABLEENTRIES
DECLARE @SQLDBINFOIDTABLE table
(
	id integer
)
INSERT INTO @SQLDBINFOIDTABLE
	select distinct sqlDbBackupFileId from sqlArchiveinfo
	where
	aFileId in (select id from archfile where jobId = @i_jobId and commcellid = 2 and isValid = 1)
SELECT *
INTO #SQLDBINFOPERPHASETABLE
FROM sqlDbBackupInfo
where id in (select id from @SQLDBINFOIDTABLE)
and type = char(@i_backupType)
select @lastgoodDBbackupId = id
from #SQLDBINFOPERPHASETABLE SDPT
WHERE
sqlNameId = @i_sqlNameId
DECLARE @TobeDeletedEntries Table
(
	id integer
)
IF(@lastgoodDBbackupId <> 0)
BEGIN
	insert into @TobeDeletedEntries
		select id from #SQLDBINFOPERPHASETABLE
		where
		id = @lastgoodDBbackupId
END
select *
INTO #RETURNTABLEENTRIES
from sqldbbackupinfo
WHERE ID IN (SELECT id from @TobeDeletedEntries)
delete from sqldbbackupinfo
where
id in (SELECT id from @TobeDeletedEntries)
select RTE.backup_set_id, APP.clientId, RTE.instanceId, INST.name, SN2.name
from #RETURNTABLEENTRIES RTE, APP_APPLICATION APP, APP_instanceName INST, SQLNames SN, SQLNames2 SN2
WHERE
RTE.appId = APP.ID AND
RTE.instanceId = INST.id AND
RTE.sqlNameId = SN.id AND
SN.sqlId = SN2.id AND
SN2.type = 1
drop table #SQLDBINFOPERPHASETABLE
drop table #RETURNTABLEENTRIES
GO

IF EXISTS (select * from GxQscripts where name = 'RemoveSqlUncommittedBackupEntries_Azure')
	delete from GxQscripts where name = 'RemoveSqlUncommittedBackupEntries_Azure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RemoveSqlUncommittedBackupEntries_Azure')
	delete from GXDBVersions where aliasname = 'RemoveSqlUncommittedBackupEntries_Azure'
GO

insert into GXDBVersions values(2, 'RemoveSqlUncommittedBackupEntries_Azure',  '00010001000200020000', 'RemoveSqlUncommittedBackupEntries_Azure', '00010001000200020000')
GO

