

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RemoveSqlUncommittedBackupEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RemoveSqlUncommittedBackupEntries.sp,v $ $Id: RemoveSqlUncommittedBackupEntries.sp,v 1.1.304.1 2018/03/27 09:00:16 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RemoveSqlUncommittedBackupEntries
--  |
--  | Description:
--  |  Removes all the sql uncommitted backup entries
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Kiran   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RemoveSqlUncommittedBackupEntries <<<'

IF EXISTS (select * from sysobjects where name='RemoveSqlUncommittedBackupEntries')
	drop procedure RemoveSqlUncommittedBackupEntries
IF EXISTS (select * from GxQscripts where name='RemoveSqlUncommittedBackupEntries')
	delete from GxQscripts where name = 'RemoveSqlUncommittedBackupEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RemoveSqlUncommittedBackupEntries')
	delete from GXDBVersions where aliasname = 'RemoveSqlUncommittedBackupEntries'
GO
print '... Creating Procedure: RemoveSqlUncommittedBackupEntries'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RemoveSqlUncommittedBackupEntries
  @i_jobId INTEGER,
  @i_backupType INTEGER,
  @i_dbName VARCHAR(256)
AS
  DECLARE @o_backup_set_id INTEGER; 
  DECLARE @o_clientId INTEGER;
  DECLARE @o_instanceId INTEGER;
  DECLARE @o_instanceName VARCHAR(256);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @i_sqlNameId integer
DECLARE @lastgoodDBbackupId integer
set @lastgoodDBbackupId = 0
select @i_sqlNameId = id from sqlNames where name = @i_dbName and type = 1
IF object_id('tempdb.dbo.#SQLDBINFOPERPHASETABLE') IS NOT null DROP TABLE #SQLDBINFOPERPHASETABLE
IF object_id('tempdb.dbo.#RETURNTABLEENTRIES') IS NOT null DROP TABLE #RETURNTABLEENTRIES
DECLARE @SQLDBINFOIDTABLE table
(
	id integer
)
INSERT INTO @SQLDBINFOIDTABLE
	select distinct sqlDbBackupFileId from sqlArchiveinfo
	where
	aFileId in (select id from archfile where jobId = @i_jobId and isValid = 1)
SELECT *
INTO #SQLDBINFOPERPHASETABLE
FROM sqlDbBackupInfo
where id in (select id from @SQLDBINFOIDTABLE)
and type = char(@i_backupType)
select @lastgoodDBbackupId = id
from #SQLDBINFOPERPHASETABLE SDPT
WHERE
sqlNameId = @i_sqlNameId
DECLARE @TobeDeletedEntries Table
(
	id integer
)
IF(@lastgoodDBbackupId <> 0)
BEGIN
	insert into @TobeDeletedEntries
		select id from #SQLDBINFOPERPHASETABLE
		where
		id >= @lastgoodDBbackupId
END
select *
INTO #RETURNTABLEENTRIES
from sqldbbackupinfo
WHERE ID IN (SELECT id from @TobeDeletedEntries)
delete from sqlArchiveInfo
where
sqlDbBackupFileId in (SELECT id from @TobeDeletedEntries)
delete from sqlfilebackupinfo
where
sqlDbBackupInfoId in (SELECT id from @TobeDeletedEntries)
delete from sqldbbackupinfo
where
id in (SELECT id from @TobeDeletedEntries)
select RTE.backup_set_id, APP.clientId, RTE.instanceId, INST.name
from #RETURNTABLEENTRIES RTE, APP_APPLICATION APP, APP_instanceName INST
WHERE
RTE.appId = APP.ID AND
RTE.instanceId = INST.id
drop table #SQLDBINFOPERPHASETABLE
drop table #RETURNTABLEENTRIES
GO

IF EXISTS (select * from GxQscripts where name = 'RemoveSqlUncommittedBackupEntries')
	delete from GxQscripts where name = 'RemoveSqlUncommittedBackupEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RemoveSqlUncommittedBackupEntries')
	delete from GXDBVersions where aliasname = 'RemoveSqlUncommittedBackupEntries'
GO

insert into GXDBVersions values(2, 'RemoveSqlUncommittedBackupEntries',  '00010001030400010000', 'RemoveSqlUncommittedBackupEntries', '00010001030400010000')
GO

