

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RegionUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RegionUpdate.sp,v $ $Id: RegionUpdate.sp,v 1.1.2.6 2019/08/13 18:17:12 nshah Exp $";
--	+===================================================================+
--	|  					  RegionUpdate								|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RegionUpdate')
BEGIN
	print '>>> Drop Stored Procedure: RegionUpdate <<<'
	drop procedure RegionUpdate
END
IF EXISTS (select * from GxQscripts where name='RegionUpdate')
	delete from GxQscripts where name = 'RegionUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionUpdate')
	delete from GXDBVersions where aliasname = 'RegionUpdate'
GO
print '... Creating Procedure: RegionUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RegionUpdate
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @regionId			INT
	DECLARE @regionName			NVARCHAR(255)
	DECLARE	@city			nvarchar(255)
	DECLARE @state			nvarchar(255)
	DECLARE @country		nvarchar(255)
	DECLARE @continent		nvarchar(255)
	DECLARE @latitude FLOAT
	DECLARE @longitude FLOAT
	DECLARE @address XML
	DECLARE @flag INT
	DECLARE @newRegionName			NVARCHAR(255)
	DECLARE	@oldCity			nvarchar(255)
	DECLARE @oldState			nvarchar(255)
	DECLARE @oldCountry		nvarchar(255)
	DECLARE @oldContinent		nvarchar(255)
	DECLARE @oldLatitude FLOAT
	DECLARE @oldLongitude FLOAT
	DECLARE @oldAddress XML
	DECLARE @oldFlag INT
	DECLARE @zonesOperationType INT
	DECLARE @nowTime		INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @regionFlags int
	-- Read the XML
	SELECT
		@regionId = ISNULL(( ref.value('(regionEntity/@regionId)[1]', 'INT')), 0),
		@regionName = ISNULL((ref.value('(regionEntity/@regionName)[1]', 'NVARCHAR(255)')), ''),
		@newRegionName = (ref.value('(regionEntity/@newName)[1]', 'NVARCHAR(255)')),
		@zonesOperationType =ref.value('(zones/@zonesOperationType)[1]', 'INT')
	FROM
		@inXml.nodes('/Api_UpdateRegionReq/region') doc(ref)
		IF object_id('tempdb.dbo.#tempZonePropTbl') IS NOT null DROP TABLE #tempZonePropTbl
		CREATE TABLE #tempZonePropTbl (zoneId int default 0,latitude float, longitude float,city NVARCHAR(255), state NVARCHAR(max), country NVARCHAR(max), continent NVARCHAR(max), address xml)
		INSERT INTO #tempZonePropTbl (zoneId, latitude , longitude ,city , state , country , continent , address )
			SELECT
				ISNULL(T.c.value('(zoneEntity/@zoneId)[1]','int'),0),
				ISNULL(T.c.value('(@latitude)[1]','NVARCHAR(MAX)'),''),
				ISNULL(T.c.value('(@longitude)[1]','NVARCHAR(MAX)'),''),
				LTRIM(RTRIM(ISNULL(T.c.value('(@city)[1]','NVARCHAR(MAX)'),''))),
				LTRIM(RTRIM(ISNULL(T.c.value('(@state)[1]','NVARCHAR(MAX)'),''))),
				LTRIM(RTRIM(ISNULL(T.c.value('(@country)[1]','NVARCHAR(MAX)'),''))),
				LTRIM(RTRIM(ISNULL(T.c.value('(@continent)[1]','NVARCHAR(MAX)'),''))),
				ISNULL(T.c.value('(@address)[1]','nvarchar(max)'),'')
        FROM @inXml.nodes('//Api_UpdateRegionReq/region/zones/zone') T(c)
		--Default to add if no operation type was given and there were zones populated in the request
		--If @zonesOperationType was set as null, no zones operation will be done down below
		IF @@ROWCOUNT <> 0 AND @zonesOperationType IS NULL
		BEGIN
			SET @zonesOperationType= 2
		END
	BEGIN TRY
		-- CHECK IF REGIONID EXIST
		IF @regionId = 0 AND @regionName <> ''
		BEGIN
			SELECT @regionFlags =flags, @regionId=id FROM App_Region WHERE name=@regionName
		END
		ELSE
		BEGIN
			SELECT @regionFlags =flags FROM App_Region WHERE Id=@regionId
		END
		--@regionFlags will be null when the region was not found.
		IF @regionId = 0 OR @regionId IS NULL OR @regionFlags IS NULL
			BEGIN
SET @errorCode = (3757 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
				GOTO ERROR_EXIT
			END
IF(@regionFlags & 0x0001 <> 0)
		BEGIN
SET @errorCode = (3885 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
				GOTO ERROR_EXIT
		END
		--Get the region name if not in the request
		IF(@regionName='')
		BEGIN
			SELECT @regionName=name FROM app_region where id = @regionId
		END
		-- CHECK FOR DUPLICATE REGION Name
		IF (@newRegionName  IS NOT NULL and EXISTS (SELECT 1  FROM App_Region WITH(NOLOCK) WHERE name = @newRegionName and id<>@regionId))
		BEGIN
SET @errorCode = (3778 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR
		END
		-- CHECK IF USER HAS PERMISSION TO UPDATE THE REGION
		DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @inUserId, 247, @userHasCapability OUTPUT, 102, @regionId
		IF @userHasCapability <> 1
		BEGIN
SET @errorCode = (3106 | (CAST(POWER(2, 24) AS BIGINT) * 35))/*use the same message as it is generic*/
			SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @inLocaleId)
			GOTO ERROR
		END
		BEGIN TRAN
		IF @zonesOperationType IS NOT NULL
		BEGIN
			--validations on the input
			IF (@zonesOperationType =1) AND NOT EXISTS(SELECT TOP 1 1 FROM #tempZonePropTbl)  -- overwrite
			BEGIN
SET @errorCode = (3887 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString =  dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
				GOTO ERROR
			END
			IF(@zonesOperationType =1 OR @zonesOperationType =2) -- overwrite or add
			BEGIN
				IF EXISTS(SELECT TOP 1 1 FROM #tempZonePropTbl WHERE country='' OR country IS NULL )
				BEGIN
SET @errorCode = (3886 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
					GOTO ERROR
				END
			END
			--REUSE THE EXISTING ZONES
			UPDATE p
			SET zoneId=z.id
			FROM  #tempZonePropTbl p
			INNER JOIN APP_ZONE z  on p.city= z.city and p.state=z.state and  p.country=z.country
			--now we hae zone id so validate the request for delete zones
			IF (@zonesOperationType =3) AND NOT EXISTS(SELECT zoneRegionId FROM APP_RegionZoneAssoc WHERE regionId=@regionId EXCEPT SELECT zoneid FROM #tempZonePropTbl) --delete
			BEGIN
SET @errorCode = (3887 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
				GOTO ERROR
			END
			--Also update the continent
			UPDATE p
			SET continent=z.continent
			FROM  #tempZonePropTbl p
			INNER JOIN APP_ZONE z  ON p.country=z.country AND z.continent <> ''
			WHERE p.continent = '' and p.zoneId = 0
			--UPDATE THE LAT AND LONG FOR THE EXISTING ZONES IF NEEDED
			UPDATE z
			SET z.latitude=p.latitude, z.longitude=p.longitude
			FROM  APP_ZONE z
			INNER JOIN #tempZonePropTbl p ON p.city= z.city AND p.state=z.state AND  p.country=z.country
			WHERE z.latitude <> p.latitude OR z.longitude<>P.longitude and p.zoneId > 0
			IF(@zonesOperationType =2) OR (@zonesOperationType =1) --ADD or overwrite
			BEGIN
				INSERT INTO App_Zone ([name],[latitude],[longitude],[flags],[city],[state],[country],[continent],[created],[modified],[zoneGuid],[address],locNameId,locCityId,locStateId,locCountryId,locContinentId)
           		SELECT IIF(city is null or city = '', state + '_' + country, city + '_' + state + '_' + country), latitude , longitude ,0, city , state , country , continent ,@nowTime,0, NEWID(), address,0,0,0,0,0
				FROM #tempZonePropTbl WHERE zoneId =0
				--UPDATE NEW ZONE IDS
				UPDATE p
				SET zoneId=z.id
				FROM  #tempZonePropTbl p
				INNER JOIN APP_ZONE z  ON p.city= z.city AND p.state=z.state AND  p.country=z.country AND p.continent = z.continent AND p.latitude= z.latitude AND p.longitude=z.longitude
				WHERE p.zoneId=0
				MERGE APP_RegionZoneAssoc RZ
				USING #tempZonePropTbl AS P
				ON RZ.zoneRegionId = p.zoneId AND RZ.isRegion = 0 AND RZ.regionId = @regionId
				WHEN NOT MATCHED THEN INSERT VALUES(@regionId, p.zoneId, 0);
			END
			IF(@zonesOperationType =1)
			BEGIN
				DELETE FROM APP_RegionZoneAssoc WHERE zoneRegionId IN(
				SELECT zoneRegionId
				FROM APP_RegionZoneAssoc WHERE regionId=@regionId
				EXCEPT
				SELECT zoneId
				FROM #tempZonePropTbl)
				AND regionId=@regionId
				DELETE FROM APP_ZONE WHERE id IN(
				SELECT z.id
				FROM APP_ZONE z
				LEFT JOIN APP_RegionZoneAssoc RZ ON RZ.zoneRegionId = z.Id  AND  RZ.isRegion = 0 AND  RZ.regionId <> @regionId
				 WHERE RZ.regionId is null
				EXCEPT
				SELECT zoneId
				FROM #tempZonePropTbl
				)
AND flags & 0x0001 = 0
			END
			IF(@zonesOperationType=3) -- DELETE
			BEGIN
				DELETE RZ
				FROM APP_RegionZoneAssoc RZ
				INNER JOIN #tempZonePropTbl P on p.zoneId = RZ.zoneRegionId AND  RZ.isRegion = 0
				WHERE RZ.regionId = @regionId
				--ZONE DELETE
				DELETE Z
				FROM APP_ZONE z
				INNER JOIN #tempZonePropTbl P on p.zoneId = z.id
				LEFT JOIN APP_RegionZoneAssoc RZ ON RZ.zoneRegionId = z.Id  AND  RZ.isRegion = 0 AND  RZ.regionId <> @regionId
WHERE RZ.regionId is null AND flags & 0x0001 = 0
			END
		END
		-- UPDATE APP_Region TABLE with new name
		IF(@newRegionName IS NOT NULL)
		BEGIN
			UPDATE APP_Region
				SET name = @newRegionName, displayName = @newRegionName
			FROM App_Region WHERE id=@regionId
		END
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
	 COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
		ROLLBACK TRAN
	END CATCH
ERROR:
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0
			ROLLBACK TRAN
		IF @errorString = ''
		BEGIN
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, 1, 0, 2)
		END
	END
ERROR_EXIT:
		SET @outXml = (SELECT
								(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('error'), TYPE),
						(SELECT @regionId AS 'regionEntity/@regionId', @regionName AS 'regionEntity/@regionName'
							FOR XML PATH('regions'),TYPE)
						FOR XML PATH('Api_RegionResp'), TYPE)
	IF OBJECT_ID('tempdb.dbo.#regionInfo') IS NOT NULL
	    DROP TABLE #regionInfo
	SELECT @outXml AS outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RegionUpdate')
	delete from GxQscripts where name = 'RegionUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionUpdate')
	delete from GXDBVersions where aliasname = 'RegionUpdate'
GO

insert into GXDBVersions values(2, 'RegionUpdate',  '00010001000200060000', 'RegionUpdate', '00010001000200060000')
GO

