

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RegionRuleEvaluator.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RegionRuleEvaluator.sp,v $ $Id: RegionRuleEvaluator.sp,v 1.1.2.3 2020/12/14 18:15:51 evolohov Exp $";
--	+===============================================================================+
--	|  								RegionRuleEvaluator								|
--	|																				|
--  |  PARAMETERS			  														|
--  |    i_entityId	  = id of client/subclient										|
--  |    i_entityType = Client -> 3, subclient -> 7									|
--  |  INPUT/OUTPUT																	|
--  |	 o_xml		  =	List of clientIds	Api::ClientList							|
--	+===============================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RegionRuleEvaluator')
BEGIN
	print '>>> Drop Stored Procedure: RegionRuleEvaluator <<<'
	drop procedure RegionRuleEvaluator
END
IF EXISTS (select * from GxQscripts where name='RegionRuleEvaluator')
	delete from GxQscripts where name = 'RegionRuleEvaluator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionRuleEvaluator')
	delete from GXDBVersions where aliasname = 'RegionRuleEvaluator'
GO
print '... Creating Procedure: RegionRuleEvaluator'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RegionRuleEvaluator
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_entityId INT,
  @i_entityType INT,
  @o_xml XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
  DECLARE @errorCode INT = 0
  DECLARE @errorMsg NVARCHAR(MAX) = ''
DECLARE @cLat FLOAT, @cLong FLOAT, @cCountry NVARCHAR(1024)
DECLARE @sourceClientId INT = @i_entityId /*Assume passed id is clientId. It gets set later if not client.*/
BEGIN TRY
	----- Get clients's Geo Location BEGIN -------------------------------------------------------------------------------------------
 	IF @i_entityId IS NULL OR @i_entityId <= 0
	BEGIN
		SET @errorCode = 1
		SET @errorMsg = 'Invalid input parameter.'
	END
	ELSE
	BEGIN
IF @i_entityType = 3
		BEGIN
			SELECT
				@cLat = ISNULL((CAST(attrVal AS XML).value('/App_GeoLocation[1]/@latitude', 'FLOAT')), 0),
				@cLong = ISNULL((CAST(attrVal AS XML).value('/App_GeoLocation[1]/@longitude', 'FLOAT')), 0),
				@cCountry = ISNULL((CAST(attrVal AS XML).value('/App_GeoLocation[1]/@country', 'NVARCHAR(1024)')), '')
			FROM APP_ClientProp WHERE componentNameId = @i_entityId AND modified = 0 AND attrName = 'Client Geo Location'
		END
		ELSE IF @i_entityType = 7
		BEGIN
			SELECT
				@cLat = ISNULL((CAST(attrVal AS XML).value('/App_GeoLocation[1]/@latitude', 'FLOAT')), 0),
				@cLong = ISNULL((CAST(attrVal AS XML).value('/App_GeoLocation[1]/@longitude', 'FLOAT')), 0),
				@sourceClientId = A.clientId
			FROM APP_Application A
			LEFT JOIN APP_ClientProp CP ON CP.componentNameId = A.clientId AND CP.modified = 0 AND CP.attrName = 'Client Geo Location'
			WHERE A.id = @i_entityId
		END
		ELSE
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Invalid input parameter.'
		END
	END
	----- Get clients's Geo Location END  --------------------------------------------------------------------------------------------
--
--
	----- Region BEGIN ---------------------------------------------------------------------------------------------------------------
	-- get region tagged to the entity or at client level
	DECLARE @sourceRegionId INT
	SELECT
 		@sourceRegionId = IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
 	FROM APP_AdvanceSettings
 	WHERE entityId = @i_entityId and entityType = @i_entityType
AND sourceId = 0 /*set on entity directly*/ AND keyName = 'Region Id' AND enabled = 1 AND deleted = 0
--
IF (@sourceRegionId = 0 OR @sourceRegionId IS NULL) AND @i_entityType <> 3
 		SELECT
 			@sourceRegionId = IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
 		FROM APP_AdvanceSettings -- No dirty reads
WHERE entityId = @sourceClientId and entityType = 3/*CLIENT_ENTITY*/
AND sourceId = 0 /*set on client directly*/ AND keyName = 'Region Id' AND enabled = 1 AND deleted = 0
	----- Region END   ---------------------------------------------------------------------------------------------------------------
--
--
	----- Calculate distance BEGIN  --------------------------------------------------------------------------------------------------
	DECLARE @clients TABLE (clientId INT, lat FLOAT, long FLOAT, country NVARCHAR(1024), regionId INT, distance INT DEFAULT NULL)
	IF @errorCode = 0
	BEGIN
		-- GET ALL THE CLIENTS FROM THE INPUT XML
		INSERT INTO @clients (clientId, lat, long, country, regionId)
			SELECT
				ref.value('@clientId', 'INT'),
				ISNULL((CAST(CP.attrVal AS XML).value('/App_GeoLocation[1]/@latitude', 'FLOAT')), 0),
				ISNULL((CAST(CP.attrVal AS XML).value('/App_GeoLocation[1]/@longitude', 'FLOAT')), 0),
				ISNULL((CAST(CP.attrVal AS XML).value('/App_GeoLocation[1]/@country', 'NVARCHAR(1024)')), ''),
				IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
			FROM @o_xml.nodes('/Api_ClientList/clients/client') R(ref)
			LEFT JOIN APP_ClientProp CP ON CP.componentNameId = ref.value('@clientId', 'INT') AND CP.modified = 0 AND CP.attrName = 'Client Geo Location'
LEFT JOIN APP_AdvanceSettings S ON S.keyName = 'Region Id' AND S.enabled = 1 AND S.deleted = 0
AND S.entityId = ref.value('@clientId', 'INT') AND S.entityType = 3/*CLIENT_ENTITY*/
	--
		-- CALCULATE CLOSEST REGION BASED ON GEO LOCATION
		UPDATE @clients
			SET distance = dbo.APPComputeGeoDistance(@cLat, @cLong, lat, long, default)
	END
	----- Calculate distance END    --------------------------------------------------------------------------------------------------
--
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@error
	SET @errorMsg = (SELECT ERROR_MESSAGE())
END CATCH
--
--
PROC_END:
----- CREATE RESULT -----------------------------------------------------------------------------------------------------------------
DECLARE @temp TABLE (ID INT IDENTITY(1, 1), clientId INT)
INSERT INTO @temp (clientId)
	SELECT clientId FROM @clients WHERE regionId <> 0 AND @sourceRegionId<>0 AND regionId= @sourceRegionId ORDER BY distance ASC
INSERT INTO @temp (clientId)
	SELECT clientId FROM @clients WHERE country = @cCountry ORDER BY distance ASC
INSERT INTO @temp (clientId)
	SELECT clientId FROM @clients WHERE country <> @cCountry AND lat<>0 AND long<>0 ORDER BY distance ASC
INSERT INTO @temp (clientId)
	SELECT clientId FROM @clients WHERE country <> @cCountry AND lat=0 AND long=0 ORDER BY distance ASC
SET @o_xml =
	(Select
			(SELECT clientId AS 'client/@clientId', ID AS 'client/@order' FROM @temp FOR XML PATH ('clients'), TYPE),
			@errorCode					AS 'error/@errorCode',
			@errorMsg					AS 'error/@errorMessage'
		FOR XML PATH('Api_ClientList'), TYPE)
----- CREATE RESULT -----------------------------------------------------------------------------------------------------------------
SELECT @o_xml -- c++ code requires SELECT to get sp execution result.
GO

IF EXISTS (select * from GxQscripts where name = 'RegionRuleEvaluator')
	delete from GxQscripts where name = 'RegionRuleEvaluator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionRuleEvaluator')
	delete from GXDBVersions where aliasname = 'RegionRuleEvaluator'
GO

insert into GXDBVersions values(2, 'RegionRuleEvaluator',  '00010001000200030000', 'RegionRuleEvaluator', '00010001000200030000')
GO

