

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RegionGet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RegionGet.sp,v $ $Id: RegionGet.sp,v 1.1.2.10 2019/08/13 18:17:15 nshah Exp $";
--	+===================================================================+
--	|  					  RegionGet										|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RegionGet')
BEGIN
	print '>>> Drop Stored Procedure: RegionGet <<<'
	drop procedure RegionGet
END
IF EXISTS (select * from GxQscripts where name='RegionGet')
	delete from GxQscripts where name = 'RegionGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionGet')
	delete from GXDBVersions where aliasname = 'RegionGet'
GO
print '... Creating Procedure: RegionGet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RegionGet
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT = 0,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @propertyLevel INT = 20
	DECLARE @regionId INT
	DECLARE @regionName NVARCHAR(255)
	DECLARE @getClients INT --get the list of clients and count of plans regardless of the property level
	DECLARE @getPlans INT --get the list of plans and count of plans regardless of the property level
	BEGIN TRY
	--IF OBJECT_ID('tempdb.dbo.#regionInfo') IS NOT NULL
	--	DROP TABLE #regionInfo
	--CREATE TABLE #regionInfo
	--(
	--	regionId		INT
	--)
	IF OBJECT_ID('tempdb.dbo.#clientInfo') IS NOT NULL
		DROP TABLE #clientInfo
	CREATE TABLE #clientInfo
	(
		regionId		INT,
		clientId		INT,
		clientName nvarchar(255),
		longitude nvarchar(50),
		latitude nvarchar(50),
	)
	IF OBJECT_ID('tempdb.dbo.#PlanInfo') IS NOT NULL
		DROP TABLE #PlanInfo
	CREATE TABLE #PlanInfo
	(
		regionId		INT,
		planId		INT,
		planName nvarchar(255),
		planSubType BIGINT,
		numOfClient int default 0
	)
	SELECT
		@regionId = ISNULL(( ref.value('(regionEntity/@regionId)[1]', 'INT')), 0),
@regionName = ISNULL((ref.value('(regionEntity/@regionName)[1]', 'NVARCHAR(127)')), ''),
		@propertyLevel = ISNULL(( ref.value('(../filteroptions/@propertyLevel)[1]', 'INT')), 20),
		@getClients = ISNULL(( ref.value('(../filteroptions/@getClients)[1]', 'INT')), 0),
		@getPlans = ISNULL(( ref.value('(../filteroptions/@getPlans)[1]', 'INT')), 0)
	FROM
		@inXml.nodes('/Api_GetRegionReq/region') doc(ref)
	-- VALIDATION CHECK FOR REGIONID
	IF @regionId = 0 AND @regionName <> ''
		BEGIN
			SET @regionId = ISNULL((SELECT id FROM App_Region WITH (NOLOCK) WHERE name = @regionName), 0)
			IF @regionId = 0
			BEGIN
SET @errorCode = (3757 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
				GOTO ERROR
			END
		END
	ELSE IF NOT EXISTS (SELECT 1 FROM App_Region WITH (NOLOCK) WHERE id = @regionId) AND @regionId <> 0
	BEGIN
SET @errorCode = (3757 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR
	END
	--Removing this as we want user to see all the regions.
	-- GET ALL THE REGIONS ON WHICH USER HAS EV_VISIBILITY CAPABILITY
--exec sec_getNonIdaObjectsForThisUser @inUserId, 102, 31, '#regionInfo'
	-- IF REGIONID IS SUPPLIED THEN CHECK IF USER HAS PERMISSION
	IF NOT EXISTS (SELECT 1 FROM App_Region WHERE id = @regionId) AND @regionId <> 0
	BEGIN
SET @errorCode = (3106 | (CAST(POWER(2, 24) AS BIGINT) * 35))/*use the same message as it is generic*/
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
		GOTO ERROR
	END
	 IF object_id('tempdb.dbo.#clientListTmp') is not null DROP TABLE #clientListTmp
create table  #clientListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	IF OBJECT_ID('tempdb.dbo.#PlansList')   IS NOT NULL DROP TABLE #PlansList
	CREATE TABLE #PlansList(planId INT NOT NULL)
	--IF(@regionId > 0)
	--BEGIN
		--DELETE  from #regionInfo WHERE regionId<>@regionId
	--END
	IF OBJECT_ID('tempdb.dbo.#AppRegiontemp') IS NOT null DROP TABLE #AppRegiontemp
	CREATE TABLE  #AppRegiontemp (id INT PRIMARY KEY,
		name NVARCHAR(127) NOT NULL,
		flags INT NOT NULL,
		created INT NOT NULL,
		modified INT NOT NULL,
		regionGuid UNIQUEIDENTIFIER NULL,
		displayName NVARCHAR(127) NULL)
	INSERT INTO #AppRegiontemp(id, name, flags,created, modified,regionGuid,displayName)
	SELECT id,CASE WHEN locNameId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @inLocaleId, locNameId, 1,2) ELSE NAME END, flags,created,modified,regionGuid, CASE WHEN locDisplayNameId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @inLocaleId, locDisplayNameId, 1,2) ELSE displayName END FROM App_Region
	IF OBJECT_ID('tempdb.dbo.#AppZonetemp') IS NOT null DROP TABLE #AppZonetemp
	CREATE TABLE  #AppZonetemp (
	id INT,
	name NVARCHAR(127) NOT NULL,
	latitude FLOAT NOT NULL,
	longitude FLOAT NOT NULL,
	flags INT NOT NULL,
	city NVARCHAR(127) NOT NULL,
	state NVARCHAR(127) NOT NULL,
	country NVARCHAR(127) NOT NULL,
	continent NVARCHAR(127) NOT NULL,
	created INT NOT NULL,
	modified INT NOT NULL,
	zoneGuid UNIQUEIDENTIFIER ,
	address xml NULL,
	zoneRegionId int,
	isRegion int)
	 IF(@propertyLevel>=10)
	 BEGIN
		INSERT INTO #AppZonetemp(id,name,latitude,longitude,flags,city,state,country,continent,created,modified,zoneGuid,address,zoneRegionId,isRegion)
		SELECT Z.id
		,CASE WHEN locNameId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @inLocaleId, locNameId, 1,2) ELSE Z.name END,
		latitude,longitude,Z.flags,city,
		CASE WHEN locStateId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @inLocaleId, locStateId, 1,2) ELSE Z.state END,
		CASE WHEN locCountryId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @inLocaleId, locCountryId, 1,2) ELSE Z.country END,
		CASE WHEN locContinentId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @inLocaleId, locContinentId, 1,2) ELSE Z.continent END,
		Z.created,Z.modified,zoneGuid,address,rz.regionId,rz.isRegion
		FROM APP_RegionZoneAssoc rz
		INNER JOIN #AppRegiontemp R ON  rz.regionId = r.id
		INNER JOIN App_zone z on z.id =rz.zoneRegionId and rz.isRegion = 0
	 END
	IF(@propertyLevel > 1 OR @getClients = 1 OR @getplans = 1)
	BEGIN
		EXEC sec_getUserObjects @inUserId, 2009, 0, '#clientListTmp'
		INSERT INTO #clientInfo(regionId,clientId , clientName)
		SELECT DISTINCT RI.id, c.id, c.name
		FROM  APP_Client c
INNER JOIN APP_AdvanceSettings aas ON aas.entityId=c.id AND aas.entityType=3 and aas.keyName='Region Id' AND aas.enabled=1 AND aas.deleted=0
INNER JOIN #clientListTmp sec on (sec.clientId = aas.entityId OR  (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
		INNER JOIN #AppRegiontemp RI ON ( @regionId = 0  and (aas.value like CAST(RI.id AS NVARCHAR(20)))) OR (@regionId > 0 AND RI.ID = @regionId and aas.value like CAST(RI.id AS NVARCHAR(20)) )
		IF(@propertyLevel > 20 and @getClients =1)
		BEGIN
			UPDATE #clientInfo set latitude=xmlblob.value('@latitude', 'NVARCHAR(MAX)'), longitude=xmlblob.value('@longitude', 'NVARCHAR(MAX)')
			FROM (
			SELECT cp.componentNameId, CAST(attrVal AS XML) as xmlValue
			FROM APP_ClientProp cp WITH(NOLOCK)
			JOIN #clientInfo ci WITH(NOLOCK) ON ci.clientId = cp.componentNameId
			WHERE cp.attrName = 'Client Geo Location' and cp.modified = 0 AND cp.attrVal like '<App_GeoLocation%'
			) T
			CROSS APPLY T.xmlValue.nodes('App_GeoLocation') M(xmlblob)
			WHERE xmlblob.value('@status_code', 'NVARCHAR(MAX)') = 'SUCCESS' and clientId=t.componentNameId
   		END
	END
	IF(@propertyLevel > 1 OR @getplans = 1)
	BEGIN
EXEC sec_getNonIdaObjectsForThisUser @inUserId, 158, 31, '#PlansList'
		INSERT INTO #PlanInfo(regionId,planId , planName, planSubType)
		SELECT DISTINCT RI.id, P.ID, P.name, P.subType
		FROM App_PlanRule PR
		CROSS APPLY PR.regionIds.nodes('/regions/region') AS x(r)
		CROSS APPLY PR.planIds.nodes('/Api_planList/plan') as y(s)
		INNER JOIN #PlansList sec ON sec.planId =  s.value('@planId','int')
		INNER JOIN #AppRegiontemp RI ON  r.value('@regionId','int') = CAST(RI.id AS NVARCHAR(20))
		INNER JOIN App_Plan P ON P.ID = sec.planId
		UPDATE #PlanInfo SET numOfClient = (SELECT COUNT(clientId)
		FROM  #clientInfo C
INNER JOIN APP_ClientProp CP1 ON CP1.componentNameId=C.clientId AND (CP1.attrName =  'Associated Plan' OR CP1.attrName like 'Default % Plan') AND modified=0
		WHERE  CP1.attrVal = CAST(planId AS VARCHAR(20)))
	END
ERROR:
		IF(@propertyLevel = 1)
	BEGIN
		SET @outXml = (SELECT
						(SELECT
							CASE WHEN (flags & 2<>0) THEN 'AZURE' WHEN (flags & 4<>0) THEN 'AWS' WHEN (flags & 1<>0) THEN 'CV_DEFAULT' ELSE 'USER_CREATED' END	AS '@regionType',				--enum Api_RegionType
							R.id as 'regionEntity/@regionId',
							R.name as 'regionEntity/@regionName',
							R.displayName as 'regionEntity/@displayName'
							FROM #AppRegiontemp R WITH(NOLOCK)
							WHERE R.id = @regionId OR @regionId = 0
							FOR XML PATH('regions'), TYPE
						),
						CASE WHEN @errorCode > 0 THEN
							(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								FOR XML PATH('error'), TYPE
							)
						END
						FOR XML PATH('Api_RegionResp'), TYPE)
	END
	ELSE
	BEGIN
		SET @outXml = (SELECT
						(SELECT
							case WHEN (flags & 2<>0) THEN 'AZURE' WHEN (flags & 4<>0) THEN 'AWS' WHEN (flags & 1<>0) THEN 'CV_DEFAULT' ELSE 'USER_CREATED' END	AS '@regionType',				--enum Api_RegionType
							R.id as 'regionEntity/@regionId',
							R.name as 'regionEntity/@regionName',
							R.displayName as 'regionEntity/@displayName',
							(SELECT (select
							CASE WHEN @propertyLevel>=20 then CAST(ISNULL(latitude, z.latitude) AS NVARCHAR(50) ) END AS '@latitude' ,
							CASE WHEN @propertyLevel>=20 then CAST(ISNULL(longitude, z.longitude) AS NVARCHAR(50)) END AS  '@longitude',
							CASE WHEN @propertyLevel>=10 then z.city END AS  '@city',
							CASE WHEN @propertyLevel>=10 then z.state END AS '@state',
							CASE WHEN @propertyLevel>=10 then z.country END AS '@country',
							CASE WHEN @propertyLevel>=20 then z.continent END AS '@continent',
							z.id as 'zoneEntity/@zoneId',
							z.name as 'zoneEntity/@zoneName'
							FROM #AppZonetemp z
							where z.zoneRegionId = r.id and z.isRegion = 0 FOR XML PATH('zone'), type)  FOR XML PATH('zones'), type),
							(SELECT (SELECT  COUNT(clientId)  FROM #clientInfo WHERE regionId=R.id) AS  '@numOfClients'  , CASE WHEN @propertyLevel > 10 AND @getclients = 1 THEN
							(SELECT latitude as '@latitude', longitude as '@longitude',(SELECT clientId AS '@clientId', clientName AS '@clientName'  FOR XML PATH('client'), type) FROM #clientInfo  WHERE regionId=R.id FOR XML pATH ('clientInfo'), TYPE) END	FOR XML PATH('regionClients'), type) ,
							(SELECT (SELECT  COUNT(planId)  FROM #planInfo WHERE regionId=R.id) AS  '@numOfPlans'  , CASE WHEN @propertyLevel > 10 AND @getplans = 1 THEN
							(SELECT planSubType as '@subtype', numOfClient as '@numOfClients',(SELECT planId AS '@planId', planName AS '@planName'  FOR XML PATH('plan'), type) FROM #planInfo  WHERE regionId=R.id FOR XML pATH ('planInfo'), TYPE) END	FOR XML PATH('regionPlans'), type)
							FROM #AppRegiontemp R WITH(NOLOCK)
							WHERE R.id = @regionId OR @regionId = 0
							FOR XML PATH('regions'), TYPE
						),
						CASE WHEN @errorCode > 0 THEN
							(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
								FOR XML PATH('error'), TYPE
							)
						END
						FOR XML PATH('Api_RegionResp'), TYPE)
	END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
	SELECT @outXml AS outXml
	IF OBJECT_ID('tempdb.dbo.#AppRegiontemp') IS NOT null DROP TABLE #AppRegiontemp
	IF OBJECT_ID('tempdb.dbo.#AppZonetemp') IS NOT null DROP TABLE #AppZonetemp
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RegionGet')
	delete from GxQscripts where name = 'RegionGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionGet')
	delete from GXDBVersions where aliasname = 'RegionGet'
GO

insert into GXDBVersions values(2, 'RegionGet',  '00010001000200100000', 'RegionGet', '00010001000200100000')
GO

