

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RegionDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RegionDelete.sp,v $ $Id: RegionDelete.sp,v 1.1.2.6 2019/01/04 20:07:18 mnatarajan Exp $";
--	+===================================================================+
--	|  					  RegionDelete									|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RegionDelete')
BEGIN
	print '>>> Drop Stored Procedure: RegionDelete <<<'
	drop procedure RegionDelete
END
IF EXISTS (select * from GxQscripts where name='RegionDelete')
	delete from GxQscripts where name = 'RegionDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionDelete')
	delete from GXDBVersions where aliasname = 'RegionDelete'
GO
print '... Creating Procedure: RegionDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RegionDelete
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @regionId			INT = 0
DECLARE @regionName			NVARCHAR(255) = ''
	DECLARE @regionFlags int
	-- Read the XML
	SELECT @regionId = ISNULL (ref.value('@regionId', 'INT'), 0),
@regionName = ISNULL (ref.value('@regionName', 'NVARCHAR(255)'), '')
		FROM @inXml.nodes ('Api_DeleteRegionReq/region/regionEntity') R(ref)
	-- CHECK IF REGIONID EXIST
	IF @regionId = 0 AND @regionName <> ''
	BEGIN
		SELECT @regionFlags =flags, @regionId=id FROM App_Region WHERE name=@regionName
	END
	ELSE
	BEGIN
			SELECT @regionFlags =flags,  @regionName=name FROM App_Region WHERE Id=@regionId
	END
	IF @regionId = 0 OR @regionId IS NULL OR @regionFlags IS NULL
		BEGIN
SET @errorCode = (3757 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
IF(@regionFlags & 0x0001 <> 0)
	BEGIN
SET @errorCode = (3884 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
	END
	-- CHECK IF USER HAS PERMISSION TO DELETE THE REGION
	DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @inUserId, 248, @userHasCapability OUTPUT, 102, @regionId
	IF @userHasCapability <> 1
	BEGIN
SET @errorCode = (3106 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*use the same message as it is generic*/
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
        GOTO ERROR
    END
	--check there are no associated entities
	IF OBJECT_ID('tempdb.dbo.#entities') IS NOT NULL
		DROP TABLE #entities
    CREATE TABLE #entities --reusing this table so clear the table before using it
    (
      entityName       nvarchar(256)
    )
	--if region has plans associated do not allow to delete the region
	INSERT INTO #entities
	SELECT DISTINCT P.name
		FROM App_PlanRule PR
				CROSS APPLY PR.regionIds.nodes('/regions/region') AS x(r)
				CROSS APPLY PR.planIds.nodes('/Api_planList/plan') as y(s)
		INNER JOIN App_Plan P ON P.ID = s.value('@planId','int')
		WHERE  r.value('@regionId','int') = @regionId
	DECLARE @planStr nvarchar(max) = ''
	IF EXISTS(SELECT TOP 1 1 FROM #entities)
		BEGIN
		SET @planStr = (SELECT STUFF((  SELECT ',' + entityName FROM  #entities FOR XML PATH('')), 1, 1, ''))
SET @errorCode = (3911 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (SELECT message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
SET @errorString = REPLACE(@errorString, '^1%s', (SELECT message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (3913 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @inLocaleId))
		SET @errorString = REPLACE(@errorString, '^2%s',@planStr)
		DELETE #entities
		GOTO ERROR
	END
	--if region has clients associated do not allow to delete the region
	INSERT INTO #entities
	SELECT distinct c.name
				FROM  APP_Client c
INNER JOIN APP_AdvanceSettings aas ON aas.entityId=c.id AND aas.entityType=3 and aas.keyName='Region Id' AND aas.enabled=1 AND aas.deleted=0
	WHERE aas.value  like CAST(@regionId AS NVARCHAR(20))
	DECLARE @clientStr nvarchar(max) = ''
	IF EXISTS(SELECT TOP 1 1 FROM #entities)
	BEGIN
		SET @clientStr = (SELECT STUFF((  SELECT ',' + entityName FROM  #entities FOR XML PATH('')), 1, 1, ''))
SET @errorCode = (3911 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (SELECT message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
SET @errorString = REPLACE(@errorString, '^1%s', (SELECT message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (3912 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @inLocaleId))
		SET @errorString = REPLACE(@errorString, '^2%s',@clientStr)
		DELETE #entities
		GOTO ERROR
	END
	--if region has VM groups(subclients) associated do not allow to delete the region
	INSERT INTO #entities
	SELECT distinct c.name
	FROM  APP_Client c
INNER JOIN APP_AdvanceSettings aas ON aas.entityId=c.id AND aas.entityType=7 and aas.keyName='Region Id' AND aas.enabled=1 AND aas.deleted=0
	WHERE aas.value  like CAST(@regionId AS NVARCHAR(20))
	DECLARE @vmGroupStr nvarchar(max)=''
		IF EXISTS(SELECT TOP 1 1 FROM #entities)
	BEGIN
		SET @vmGroupStr = (SELECT STUFF((  SELECT ',' + entityName FROM  #entities FOR XML PATH('')), 1, 1, ''))
SET @errorCode = (3911 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = (SELECT message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
SET @errorString = REPLACE(@errorString, '^1%s', (SELECT message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (3914 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @inLocaleId))
		SET @errorString = REPLACE(@errorString, '^2%s',@vmGroupStr)
		DELETE #entities
        GOTO ERROR
    END
	BEGIN TRAN
	DELETE FROM APP_RegionZoneAssoc WHERE regionId = @regionId
	DELETE FROM App_Region WHERE id = @regionId
	--DELETE ZONES IF NOT USED BY OTHER REGIONS AND NOT THE DEFAULT ZONE
	DELETE Z
	FROM App_ZONE  Z
	LEFT JOIN APP_RegionZoneAssoc RZ ON Z.id = RZ.zoneRegionId  AND regionId <>  @regionId  AND isRegion=0
WHERE Rz.zoneRegionId IS NULL AND flags & 0x0001=0
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
ERROR:
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0
			ROLLBACK TRAN
		IF @errorString = ''
		BEGIN
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, 1, 0, 2)
		END
	END
	ELSE IF XACT_STATE() <> 0
		COMMIT TRAN
ERROR_EXIT:
	IF(@errorCode =0) --AUDIT
	BEGIN
		DECLARE @opMsgId            INTEGER
		DECLARE @opEvMsgId          INTEGER
		DECLARE @opId               INTEGER
		DECLARE @paramMsgId         INTEGER
		DECLARE @dataIsEvent        INTEGER = 0
SET @opMsgId = (646 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @inUserId, @opEvMsgId OUTPUT, @opId OUTPUT
		SET @dataIsEvent = 0
SET @paramMsgId  = (1740 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @regionName, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @inUserId
	END
		SET @outXml = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE)
							FOR XML PATH('Api_RegionResp'), TYPE)
	SELECT @outXml AS outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RegionDelete')
	delete from GxQscripts where name = 'RegionDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionDelete')
	delete from GXDBVersions where aliasname = 'RegionDelete'
GO

insert into GXDBVersions values(2, 'RegionDelete',  '00010001000200060000', 'RegionDelete', '00010001000200060000')
GO

