

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RegionCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RegionCreate.sp,v $ $Id: RegionCreate.sp,v 1.1.2.8 2019/08/13 18:17:30 nshah Exp $";
--	+===================================================================+
--	|  					  RegionCreate									|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RegionCreate')
BEGIN
	print '>>> Drop Stored Procedure: RegionCreate <<<'
	drop procedure RegionCreate
END
IF EXISTS (select * from GxQscripts where name='RegionCreate')
	delete from GxQscripts where name = 'RegionCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionCreate')
	delete from GXDBVersions where aliasname = 'RegionCreate'
GO
print '... Creating Procedure: RegionCreate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RegionCreate
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode		INT = 0,
			@errorString	NVARCHAR(MAX) = '',
			@nowTime		INT = dbo.GetUnixTime (GetUTCdate()),
@regionName		NVARCHAR(127),
			@regionType int = 0,
			@regionFlag int = 0,
			@zoneFlag int =0
	BEGIN TRY
		-- Read the XML
SET  @regionName = ISNULL(@inXml.value('(//Api_CreateRegionReq/region/regionEntity/@regionName)[1]', 'nvarchar(127)'), '')
		SET  @regionType = ISNULL(@inXml.value('(//Api_CreateRegionReq/region/@regionType)[1]', 'int'), 0)
		--we allow creation of Azure(1) and AWS(2) regions
		IF(@regionType = 1 )
		BEGIN
SET  @regionFlag = 0x0003
SET @zoneFlag= 0x0001
		END
		ELSE IF(@regionType = 2 )
		BEGIN
SET  @regionFlag = 0x0005
SET @zoneFlag= 0x0001
		END
		IF object_id('tempdb.dbo.#tempZonePropTbl') IS NOT null DROP TABLE #tempZonePropTbl
CREATE TABLE #tempZonePropTbl (zoneId int default 0,latitude float, longitude float,city NVARCHAR(127), state NVARCHAR(127), country NVARCHAR(127), continent NVARCHAR(127), address xml)
		INSERT INTO #tempZonePropTbl (latitude , longitude ,city , state , country , continent , address )
			SELECT
ISNULL(T.c.value('(@latitude)[1]','NVARCHAR(127)'),''),
ISNULL(T.c.value('(@longitude)[1]','NVARCHAR(127)'),''),
LTRIM(RTRIM(ISNULL(T.c.value('(@city)[1]','NVARCHAR(127)'),''))),
LTRIM(RTRIM(ISNULL(T.c.value('(@state)[1]','NVARCHAR(127)'),''))),
LTRIM(RTRIM(ISNULL(T.c.value('(@country)[1]','NVARCHAR(127)'),''))),
LTRIM(RTRIM(ISNULL(T.c.value('(@continent)[1]','NVARCHAR(127)'),''))),
				ISNULL(T.c.value('(@address)[1]','nvarchar(max)'),'')
        FROM @inXml.nodes('//Api_CreateRegionReq/region/zones/zone') T(c)
		-- CHECK IF USER HAS CREATE REGION CAPABILITY
		DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @inUserId, 246, @userHasCapability OUTPUT, 1, 2
		IF (@userHasCapability = 0)
		BEGIN
SET @errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
			SET @errorString = REPLACE(@errorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @inUserId))
SET @errorString = REPLACE(@errorString, '^2%s', (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (3753 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @inLocaleId))
			SET @errorString = REPLACE(@errorString, 'this ^3%s and ', '')
			GOTO ERROR
		END
		-- CHECK FOR DUPLICATE REGION NAME
		IF EXISTS (SELECT 1 FROM App_Region WITH(NOLOCK) WHERE name = @regionName)
		BEGIN
SET @errorCode = (3778 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR
		END
		BEGIN TRAN
		IF NOT EXISTS(SELECT TOP 1 1 FROM #tempZonePropTbl)
		BEGIN
SET @errorCode = (3887 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR
		END
		IF EXISTS(SELECT TOP 1 1 FROM #tempZonePropTbl WHERE country='' OR country IS NULL )
		BEGIN
SET @errorCode = (3886 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR
		END
		--REUSE THE EXISTING ZONES
		UPDATE p
		SET zoneId=z.id
		FROM  #tempZonePropTbl p
		INNER JOIN APP_ZONE z  on p.city= z.city and p.state=z.state and  p.country=z.country
		--Also update the continent
		UPDATE p
		SET continent=z.continent
		FROM  #tempZonePropTbl p
		INNER JOIN APP_ZONE z  ON p.country=z.country AND z.continent <> ''
		WHERE p.continent = ''  and p.zoneId = 0
		--UPDATE THE LAT AND LONG FOR THE EXISTING ZONES IF NEEDED
		UPDATE z
		SET z.latitude=p.latitude, z.longitude=p.longitude
		FROM  APP_ZONE z
		INNER JOIN #tempZonePropTbl p ON p.city= z.city AND p.state=z.state AND  p.country=z.country
		WHERE z.latitude <> p.latitude OR z.longitude<>P.longitude
		--CREATE NEW ZONES. zone can also get created by update region API
		INSERT INTO App_Zone (name,latitude,longitude,flags,city,state,country,continent,created,modified,zoneGuid,address,locNameId,locCityId,locStateId,locCountryId,locContinentId)
		SELECT IIF(city is null or city = '', state + '_' + country, city + '_' + state + '_' + country), latitude , longitude , @zoneFlag, city , state , country , continent ,@nowTime,0, NEWID(), address,0,0,0,0,0
		FROM #tempZonePropTbl WHERE zoneId =0
		--UPDATE NEW ZONE IDS
		UPDATE p
		SET zoneId=z.id
		FROM  #tempZonePropTbl p
		INNER JOIN APP_ZONE z  ON p.city= z.city AND p.state=z.state AND  p.country=z.country AND p.continent = z.continent AND p.latitude= z.latitude AND p.longitude=z.longitude
		WHERE p.zoneId=0
		-- INSERT REGION AND GET THE REGIONID
		INSERT INTO App_Region (name, flags,created , modified, regionGuid, displayName, locNameId, locdisplayNameId)
		VALUES(@regionName, @regionFlag, @nowTime,0, NEWID(), @regionName,0,0)
		DECLARE @regionId INT = SCOPE_IDENTITY()
		--ADD THE REGION AND ZONE ASSOCIATION
		INSERT INTO APP_RegionZoneAssoc( regionId,zoneRegionId,isRegion)
		SELECT @regionId, zoneId, 0
		FROM #tempZonePropTbl WHERE zoneId >0
		-- GIVE PERMISSIONS TO THE CREATOR OF THE ENTITY.
		DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(31  AS NVARCHAR(10)) + ',' + CAST(247 AS NVARCHAR(10)) + ','
+ CAST(248 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @inUserId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 102, @regionId
		if (@errorCode<>0)
		BEGIN
			IF @errorString = ''
				set @errorString = 'Create Region failed.'
		END
	END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
END CATCH
ERROR:
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRAN
		END
		IF @errorString = ''
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
		END
	END
	ELSE IF XACT_STATE() <> 0
		COMMIT TRAN
ERROR_EXIT:
	IF(@errorCode =0) --AUDIT
	BEGIN
		DECLARE @opMsgId            INTEGER
		DECLARE @opEvMsgId          INTEGER
		DECLARE @opId               INTEGER
		DECLARE @paramMsgId         INTEGER
		DECLARE @dataIsEvent        INTEGER = 0
SET @opMsgId = (645 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @inUserId, @opEvMsgId OUTPUT, @opId OUTPUT
		SET @dataIsEvent = 0
SET @paramMsgId  = (1739 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @regionName, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @inUserId
	END
		SET @outXml =  (SELECT
						(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('error'), TYPE),
						(SELECT @regionId AS 'regionEntity/@regionId', @regionName AS 'regionEntity/@regionName'
							FOR XML PATH('regions'),TYPE)
					FOR XML PATH('Api_RegionResp'), TYPE)
	SELECT @outXml AS outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RegionCreate')
	delete from GxQscripts where name = 'RegionCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RegionCreate')
	delete from GXDBVersions where aliasname = 'RegionCreate'
GO

insert into GXDBVersions values(2, 'RegionCreate',  '00010001000200080000', 'RegionCreate', '00010001000200080000')
GO

