

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RecycleVolumesInDeletedAF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RecycleVolumesInDeletedAF.sp,v $ $Id: RecycleVolumesInDeletedAF.sp,v 1.125.2.25 2020/12/30 14:41:50 anarulkar Exp $";
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RecycleVolumesInDeletedAF')
BEGIN
	print '>>> Drop Stored Procedure: RecycleVolumesInDeletedAF <<<'
	drop procedure RecycleVolumesInDeletedAF
END
IF EXISTS (select * from GxQscripts where name='RecycleVolumesInDeletedAF')
	delete from GxQscripts where name = 'RecycleVolumesInDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RecycleVolumesInDeletedAF')
	delete from GXDBVersions where aliasname = 'RecycleVolumesInDeletedAF'
GO
print '... Creating Procedure: RecycleVolumesInDeletedAF'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RecycleVolumesInDeletedAF
  @i_JobId INTEGER,
  @i_CommCellId INTEGER,
  @i_dummy INTEGER
AS
  DECLARE @numMediaRecycled INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @numMediaRecycled = 0
DECLARE @defaultCCId INT = 2
	IF OBJECT_ID('tempdb.dbo.#VolumeList') IS NOT NULL DROP TABLE #VolumeList
	IF OBJECT_ID('tempdb.dbo.#VolHasChunk') IS NOT NULL DROP TABLE #VolHasChunk
	IF OBJECT_ID('tempdb.dbo.#VolCleanup') IS NOT NULL DROP TABLE #VolCleanup
	IF OBJECT_ID('tempdb.dbo.#LibHistory') IS NOT NULL DROP TABLE #LibHistory
	IF OBJECT_ID('tempdb.dbo.#RecyclableMedia') IS NOT NULL DROP TABLE #RecyclableMedia
	IF OBJECT_ID('tempdb.dbo.#RVIDArchChunks') IS NOT NULL DROP TABLE #RVIDArchChunks
	IF OBJECT_ID('tempdb.dbo.#NoPruningLibrary') IS NOT NULL DROP TABLE #NoPruningLibrary
	IF OBJECT_ID('tempdb.dbo.#VolCleanupNoPruningLib') IS NOT NULL DROP TABLE #VolCleanupNoPruningLib
	IF OBJECT_ID('tempdb.dbo.#CopyCleanup') IS NOT NULL DROP TABLE #CopyCleanup
/***************************** Create temp tables *************************/
	CREATE TABLE #VolumeList (
		VolumeId			INT,
		VolumeFlags			INT,
		VolumeFullReason	INT,
		MediaId				INT,
		MediaSideId			INT,
		MediaGroupId		INT,
		SIDBStoreId			INT,
		MountPathTypeId		INT,
		NumberOfSides		INT,
		IsWormMedia			INT,
		IsInMediaGroup		INT,
		MediaTypeId			INT,
		MediaFlags			INT,
		LibraryId			INT,
		LastWriteLibraryId	INT,
		SpareGroupId		INT,
		CapacityFreedMB		INT,
		Recyclable			INT,
		HasChunk			INT,
		OrigCCId			INT,
		isOverWriteIfDiffCC	INT
		PRIMARY KEY (VolumeId)
	)
	CREATE TABLE #VolHasChunk (
		VolumeId			INT,
		AllAged				INT,
		PRIMARY KEY (VolumeId)
	)
	CREATE TABLE #VolCleanup (
		VolumeId			INT
	)
	CREATE TABLE #CopyCleanup (
		CopyId		INT
	)
	CREATE	TABLE #LibHistory (
		LibraryId			INT,
		NumberOfMediaFreed	INT,
		CapacityFreedMB		BIGINT
	)
	CREATE	TABLE #RecyclableMedia
	(
		MediaId			INTEGER,
		BarCode			NVARCHAR(256)
	)
	CREATE TABLE #RVIDArchChunks
	(
		archChunkId		BIGINT,
		commCellId		INTEGER
		PRIMARY KEY (archChunkId, commCellId)
	)
	CREATE TABLE #NoPruningLibrary
	(
		LibraryId	INTEGER,
		MountPathId	INTEGER,
		MediaSideId	INTEGER
	)
	CREATE TABLE #VolCleanupNoPruningLib
	(
		VolumeId	INT
	)
DECLARE @now INT = dbo.getUnixTime(GETUTCDATE())
DECLARE @ErrVal INTEGER = 0
DECLARE @RowCount INTEGER = 0
DECLARE @maxRowsToPruneInBatch  INTEGER = 2000
SELECT  @maxRowsToPruneInBatch = ISNULL(value, 2000)
FROM    MMConfigs
WHERE   name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'
/*
If DataAging Job is Running and this procedure is called by some other process other than DataAging
then do not process anything. Let DataAging take care of it.
*/
IF EXISTS (SELECT * FROM JMAdminJobInfoTable
		   where opType = 10 and commCellId = @defaultCCId)
BEGIN
	-- DataAging Job is running
	IF @i_JobId <= 0
	BEGIN
		SELECT	0
		RETURN
	END
END
/*
Find if there are any magnetic libraries/mountpaths with no pruning option enabled.
*/
INSERT INTO #NoPruningLibrary
SELECT L.LibraryId, M.MountPathId, M.MediaSideId
FROM MMLibrary L WITH (READUNCOMMITTED), MMMountPath M WITH (READUNCOMMITTED)
WHERE L.LibraryId = M.LibraryId
AND (L.ExtendedAttributes & 1073741824) > 0
/*****************If exists remove Duplicate rows from MMDeletedAF table***************/
IF EXISTS (SELECT COUNT(*) FROM MMDeletedAF GROUP BY VolumeId, archFileId, archChunkId, SIDBStoreId HAVING COUNT(*) > 1)
BEGIN
	WITH CTE AS
	(
	SELECT archFileId, VolumeId, ArchChunkId, SIDBStoreId, ROW_NUMBER() OVER (PARTITION BY archFileId, VolumeId, ArchChunkId, SIDBStoreId ORDER BY DeletedTime) AS rn
	FROM MMDeletedAF
	WHERE SIDBStoreId > 0
	)
	DELETE FROM CTE
	WHERE rn > 1
END
/**************** Remove aged deduped volume from MMDeletedAF table *********/
	DELETE	MMDeletedAF
	WHERE	VolumeId > 0  AND SIDBStoreId > 0
			AND archFileId = 0 AND archChunkId = 0
AND (status & 256) <> 0
/**************** First check if there are new entries in the MMDeletedAF table *********/
	INSERT	INTO #VolumeList
	SELECT	V.VolumeId, V.VolumeFlags, V.VolumeFullReason, V.MediaId, V.MediaSideId, V.MediaGroupId, V.SIDBStoreId,
(CASE WHEN M.MediaTypeId != 10001 THEN 0
				ELSE (SELECT MountPathTypeId FROM MMMountPath WITH (NOLOCK) WHERE MediaSideId = V.MediaSideId) END),
			MT.NumberOfSides, MT.IsWormMedia, M.IsInMediaGroup, M.MediaTypeId, M.MediaFlags,
			M.LibraryId, (CASE WHEN M.LastWriteLibraryId > 0 THEN M.LastWriteLibraryId ELSE M.LibraryId END),
			M.SpareGroupId, DAF.CapacityFreedMB,
(CASE WHEN V.VolumeFlags = 1 THEN 0 ELSE 1 END)/*Recycleable*/, 0/*HasChunk*/, M.origCCcommCellID, (CASE WHEN ( (M.Attributes & 268435456) > 0) THEN 1 ELSE 0 END)
FROM	(SELECT VolumeId, SUM(CASE WHEN ((status & 1) = 0) THEN CapacityFreedBytes ELSE 0 END)/(1024*1024) AS CapacityFreedMB
			FROM	MMDeletedAF WITH (NOLOCK)
WHERE	VolumeId > 0 AND (status & 256) = 0
			GROUP BY VolumeId) DAF,
			MMVolume V WITH (NOLOCK), MMMedia M WITH (NOLOCK), MMMediaType MT WITH (NOLOCK)
	WHERE	M.MediaId = V.MediaId
	AND		V.VolumeId = DAF.VolumeId
	AND		MT.MediaTypeId = M.MediaTypeId
/**************** Filter out reserved media *********************************************/
	-- Do not recycle reserved volumes
	-- Jai - Mon Jul 14 18:04:39 EDT 2008
	-- -- Do not filter out volumes that are marked for recycle since it's found
	-- -- to be a cleaning media in drive.  See MR 15560 (Silk Radar MR 107707) for details.
	DELETE	#VolumeList
	FROM	#VolumeList V, MMResource R WITH (NOLOCK)
	WHERE	V.VolumeId = R.VolumeId
AND V.VolumeFullReason != 42027
	-- if media flag is MEDIA_FLAG_RESERVED_BY_JOB, make sure the job is not runnning right now
	DELETE	#VolumeList
	FROM	#VolumeList V, RMReservations R WITH (NOLOCK), JMJobInfo Job WITH (NOLOCK)
	WHERE	V.MediaFlags = 5 /*MEDIA_FLAG_RESERVED_BY_JOB*/
	AND		V.MediaId = R.MediaId
	AND		R.JobId = Job.JobId
	/* Delete invalid non-magnetic chunks */
	--To avoid deadlocks, insert chunks to temp table and then delete using primary key
	INSERT INTO #RVIDArchChunks
	SELECT	C.id, C.CommCellId
	FROM	archChunk C WITH (NOLOCK), #VolumeList V
WHERE	C.volumeId = V.VolumeId	AND V.MediaTypeId != 10001
	AND		C.physicalSize = 0 AND C.logicalSize = 0
	DELETE	archChunk
	FROM	archChunk C, #RVIDArchChunks DAC
	WHERE	C.id = DAC.archChunkId
			AND C.CommCellId = DAC.CommCellId
	INSERT	INTO #VolCleanup
	SELECT	VolumeId
	FROM	#VolumeList
WHERE	MediaTypeId != 10001 AND IsInMediaGroup = 0
	-- if media flag is MEDIA_FLAG_RESERVED_BY_JOB, reset it if there is no job using it
	AND		MediaFlags <> 5 /*MEDIA_FLAG_RESERVED_BY_JOB*/
	DELETE	#VolumeList
	FROM	#VolCleanup
	WHERE	#VolumeList.VolumeId = #VolCleanup.VolumeId
	-- add copy info here for which we have entries with MPId = 0
	INSERT INTO #CopyCleanup
	SELECT DISTINCT DAF.CopyId
	FROM MMDeletedAF DAF WITH (READUNCOMMITTED)
		INNER JOIN MMDataPath D WITH (READUNCOMMITTED) ON DAF.CopyId = D.CopyId
		INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
		INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON DP.MasterPoolId = MP.MasterPoolId
	WHERE DAF.MountPathId = 0 AND DAF.VolumeId = 0 AND DAF.CopyId > 0
AND (((MP.Attribute & 32) = 0)
OR ((MP.Attribute & 32768) > 0))
	IF	NOT EXISTS (SELECT * FROM #VolumeList) AND NOT EXISTS (SELECT * FROM #CopyCleanup)
		GOTO CX_EXIT
/**************** Check for recyclable media ********************************************/
	INSERT	INTO #VolHasChunk
SELECT  V.VolumeId,	MIN(C.flags & 256)/*AllAged*/
	FROM 	#VolumeList V, archChunk C WITH (NOLOCK)
	WHERE 	C.volumeId = V.VolumeId
	GROUP	BY V.VolumeId
	/* A volume is not recyclable if it has any non-aged chunk */
	UPDATE	#VolumeList
	SET		Recyclable = (CASE WHEN T.AllAged = 0 THEN 0 ELSE V.Recyclable END), HasChunk = 1
	FROM	#VolumeList V, #VolHasChunk T
	WHERE	V.VolumeId = T.VolumeId
	/* Check recyclable optical media */
	IF	EXISTS (SELECT * FROM #VolumeList WHERE Recyclable = 1 AND NumberOfSides > 1)
	BEGIN
		/* Get the other volumes of recyclable optical media */
		SELECT	V.VolumeId, V.VolumeFlags, V.VolumeFullReason, V.MediaId, V.MediaSideId, V.MediaGroupId,
				T.NumberOfSides, T.IsWormMedia, T.IsInMediaGroup, T.MediaTypeId, T.MediaFlags,
				T.LibraryId, T.LastWriteLibraryId, T.SpareGroupId,
				0 AS CapacityFreedMB, (CASE WHEN V.VolumeFlags = 1 THEN 0 ELSE 1 END) AS Recyclable, 0 AS HasChunk, T.origCCId, T.isOverWriteIfDiffCC
		INTO	#OpticalVol
		FROM	MMVolume V WITH (NOLOCK), #VolumeList T
		WHERE	V.MediaId = T.MediaId
		AND		V.VolumeId != T.VolumeId
		AND		T.Recyclable = 1
		AND		T.NumberOfSides > 1
		DELETE	#OpticalVol
		FROM	#VolumeList
		WHERE	#OpticalVol.VolumeId = #VolumeList.VolumeId
		TRUNCATE TABLE #VolHasChunk
		INSERT	INTO #VolHasChunk
SELECT  V.VolumeId,	MIN(C.flags & 256)/*AllAged*/
		FROM 	#OpticalVol V, archChunk C WITH (NOLOCK)
		WHERE 	C.volumeId = V.VolumeId
		GROUP	BY V.VolumeId
		UPDATE	#OpticalVol
		SET		Recyclable = (CASE WHEN T.AllAged = 0 THEN 0 ELSE V.Recyclable END), HasChunk = 1
		FROM	#OpticalVol V, #VolHasChunk T
		WHERE	V.VolumeId = T.VolumeId
		UPDATE	#VolumeList
		SET		Recyclable = (CASE WHEN T.Recyclable = 0 THEN 0 ELSE V.Recyclable END),
				HasChunk = (CASE WHEN T.HasChunk = 1 THEN 1 ELSE V.HasChunk END)
		FROM	#VolumeList V, #OpticalVol T
		WHERE	V.MediaId = T.MediaId
		INSERT	INTO #VolumeList
		SELECT	VolumeId, VolumeFlags, VolumeFullReason, MediaId, MediaSideId, MediaGroupId,
				0 /* SIDBStoreId */, 0 /* MountPathTypeId */, NumberOfSides, IsWormMedia,
				IsInMediaGroup, MediaTypeId, MediaFlags, LibraryId, LastWriteLibraryId,
				SpareGroupId, CapacityFreedMB, Recyclable, HasChunk, origCCId, isOverWriteIfDiffCC
		FROM	#OpticalVol
		WHERE	Recyclable = 1
		DROP TABLE #OpticalVol
	END
	SELECT	@numMediaRecycled = COUNT(DISTINCT MediaId)
	FROM	#VolumeList
	WHERE	Recyclable = 1
AND		MediaTypeId != 10001
	/* Check warm media */
	UPDATE	#VolumeList
	SET		Mediaflags = 2/*MEDIA_FLAG_BAD*/
	WHERE	Recyclable = 1
	AND		IsWormMedia > 0
AND		MediaTypeId != 10001
/* Put a recyclable worm media to a 8 so it will not be used again */
	UPDATE	#VolumeList
	SET		MediaFlags = 3/*MEDIA_FLAG_DEPRECATED*/,
			SpareGroupId = SG.SpareGroupId
	FROM	#VolumeList V, MMSpareGroup SG WITH (NOLOCK)
	WHERE	V.Recyclable = 1
	AND		V.IsWormMedia > 0
AND		V.MediaTypeId != 10001
	AND		SG.LibraryId = V.LastWriteLibraryId
AND		SG.SpareGroupType = 8
	UPDATE	#VolumeList
SET		VolumeFlags = (CASE WHEN MediaTypeId != 10001 THEN 5/*VOL_IDLE*/ ELSE 6/*VOL_RECYCLE*/ END)
	WHERE	Recyclable = 1
	/* Set MediaGroupId = 0 for recyclable empty non-magnetic media */
	/* so these volumes will not be used for writing */
	/* For 9.0, we don't set MediaGroupId = 0 for recyclable magnetic volumes. Need MediaGroupId for Dedupe. */
	/*
	For index backups we delete the archive files and chunks directly from DB before the media gets recycled.
	Such media, when they come for recycle they won't have any chunk so HasChunk will be 0,
	but if the row in MMDeletedAF for the media has CapacityFreedMB > 0 we want to treat it like a media that has chunks and is getting recycled.
	Hence retain mediaGroupId so that media stays associated with the same storage policy/copy.
        But note that since chunks are deleted we will reset the PhysicalBytesMB and LogicalBytesMB of the media to 0 in later queries based on HasChunk = 0.
	*/
	UPDATE	#VolumeList
	SET		MediaGroupId = 0
	FROM	#VolumeList T
	WHERE	T.Recyclable = 1
AND		T.MediaTypeId <> 10001
	AND		NOT EXISTS (SELECT * FROM #VolumeList WHERE MediaId = T.MediaId AND (HasChunk = 1 OR CapacityFreedMB > 0))
	declare @l_shouldNotCountCCMMediaParam	nvarchar(256)
	declare @shouldNotCountCCMMedia	integer
	set @l_shouldNotCountCCMMediaParam	=	ISNULL ( (select value from GXGlobalParam where name like 'CNDoNotUseCCMMediaCount'), '')
	if (@l_shouldNotCountCCMMediaParam = '' OR @l_shouldNotCountCCMMediaParam = '0')
		set @shouldNotCountCCMMedia	=	0
	else
		set @shouldNotCountCCMMedia	=	1
	/* For updating MMLibraryHistory
	INSERT	INTO #LibHistory
	SELECT	LibraryId, 0, SUM(CapacityFreedMB)
	FROM	#VolumeList
WHERE	MediaTypeId = 10001 AND CapacityFreedMB > 0
	GROUP BY LibraryId
	*/
	INSERT	INTO #LibHistory
	SELECT	DISTINCT LastWriteLibraryId, COUNT(DISTINCT MediaId), 0
	FROM	#VolumeList, APP_CommCell CC WITH (READUNCOMMITTED)
WHERE	Recyclable = 1 AND MediaTypeId != 10001
		AND
		(
			(@shouldNotCountCCMMedia = 0)
			OR
			-- Filter out volumes that have
			(
				(origCCId in (0,2)) OR
				(isOverWriteIfDiffCC = 1) OR
				/* For MR 56367, do not filter out non-simpana media if above option is not set */
(origCCId > 2 AND origCCId = CC.id AND CC.type <> 1)
			)
		)
	GROUP BY LastWriteLibraryId
	/* Clean MMDeletedAF table for non-magnetic volumes and recyclable magnetic volumes */
	/* MMDeletedAF entries for Magnetic volumes will be removed by MLM after having deleted chunk/volume from disk */
	INSERT	INTO #VolCleanup
	SELECT	VolumeId
	FROM	#VolumeList V
			INNER JOIN IdxSIDBStore I WITH (NOLOCK) ON V.SIDBStoreId = I.SIDBStoreId
WHERE	MediaTypeId != 10001
		OR	(Recyclable = 1 AND V.SIDBStoreId <= 0 AND MountPathTypeId != 1)/*MOUNT_PATH_CENTERA*/
		-- Cleanup entries for Volume which are recyclable from MMDelAF for dedup enabled cloud storage.
		-- 7/29/2014 Enable granular pruning in cloud. Do not clean up entries with MPType=7
		-- 10/2017 Clean up rows only for MPs where granular pruning is not enabled. Below delete from #volCleanup takes care of checking
		-- if the MP is granular pruning enabled or not.
		OR (Recyclable = 1 AND V.SIDBStoreId > 0 AND MountPathTypeId = 7) /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
OR (Recyclable = 1 AND V.SIDBStoreId > 0 AND (I.flags & 2097152) > 0)
	/* Clean MMDeletedAF table for magnetic library with no-pruning option enabled */
	INSERT INTO #VolCleanupNoPruningLib
	SELECT VolumeId
	FROM	#VolumeList V
			INNER JOIN #NoPruningLibrary N ON V.MediaSideId = N.MediaSideId
	IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE (name = 'MMS2_CONFIG_ENABLE_REMOVABLE_MEDIA_PRUNING') AND value > 0)
	BEGIN
		DELETE C
		FROM #VolCleanup C, #VolumeList V
		WHERE C.VolumeId = V.VolumeId
AND ((V.MediaTypeId > 11001) AND (V.MediaTypeId < 11999))
		AND V.VolumeFlags <> 5/*VOL_IDLE*/	-- Any volume which is already marked idle will be cleaned up from MMDAF. Media will get reused as if tape is repicked.
		DELETE DAF
		FROM MMDeletedAF DAF
			INNER JOIN #VolumeList V ON DAF.VolumeId = V.VolumeId
		WHERE DAF.ArchChunkId = 0 -- Delete the VolId > 0 and chunk=0 rows only
AND ((V.MediaTypeId > 11001) AND (V.MediaTypeId < 11999))
		AND V.VolumeFlags <> 5 /*VOL_IDLE*/ -- If vol is not idle then we can cleanup the row from deletedAF since that vol is not getting marked in DB.
	END
	/* Ignore the volumes which are Object-based Cloud Storage */
	DELETE FROM #VolCleanup
	FROM #VolCleanup VC INNER JOIN MMVolume VOL ON VC.VolumeId = VOL.VolumeId
		INNER JOIN MMMountPath MP ON VOL.MediaSideId = MP.MediaSideId
		INNER JOIN MMMountPathToStorageDevice MPSD ON MP.MountPathId = MPSD.MountPathId
		INNER JOIN MMDevice DEV ON MPSD.DeviceId = DEV.DeviceId
	WHERE MP.MountPathTypeId = 7 /* MOUNT_PATH_EXTERNAL_REMOTE_HOST */
		-- Do not remove entries which are dedup enabled. Those entries should remain in #VolCleanup and be eventually cleaned up from MMDelAF below
		-- 7/29/2014 Enable granular pruning in cloud. Below is not needed as we will not insert entries with StoreId > 0 above
		-- AND VOL.SIDBStoreId = 0
		/*
		TYPE_SAN_MAGNETIC_REMOTE_HOST_CARINGO_CASTOR
		TYPE_SAN_MAGNETIC_REMOTE_HOST_DELL_DX_OBJECTSTORAGE
		*/
		AND DEV.DeviceTypeId > 41 /* TYPE_SAN_MAGNETIC_REMOTE_HOST_OBJECT_BASE_START */
		AND DEV.DeviceTypeId < 60 /* TYPE_SAN_MAGNETIC_REMOTE_HOST_OBJECT_BASE_END */
	DELETE FROM #VolCleanup
	FROM #VolCleanup VC INNER JOIN MMVolume VOL ON VC.VolumeId = VOL.VolumeId
		INNER JOIN MMMountPath MP ON VOL.MediaSideId = MP.MediaSideId
	WHERE MP.MountPathTypeId = 7 /* MOUNT_PATH_EXTERNAL_REMOTE_HOST */
		-- Remove entries which are related to non-dedup so that granular pruning can be done.
		-- Or remove entries which are dedup and enabled for granular pruning.
AND ((VOL.SIDBStoreId = 0) OR (VOL.SIDBStoreId > 0 AND (MP.Attribute & 32) > 0))
	-- Clean up entries which are on static shared MP with micro pruning disabled
	INSERT INTO #VolCleanup
	SELECT V.VolumeId
	FROM	#VolumeList V
			INNER JOIN IdxSIDBStore I WITH (NOLOCK) ON V.SIDBStoreId = I.SIDBStoreId
			INNER JOIN MMMountPath MP ON V.MediaSideId = MP.MediaSideId
WHERE ((MP.Attribute & 32768) > 0)
		AND (V.Recyclable = 1 AND V.SIDBStoreId > 0 AND MP.MountPathTypeId = 4) /*MOUNT_PATH_SHARED_STATIC*/
	-- added here so that entries for those volumes are cleaned up.
	INSERT INTO #VolCleanup
	SELECT VolumeId
	FROM #VolCleanupNoPruningLib
/********************* Flag Recyclable Volumes AND Media ********************************/
BEGIN TRANSACTION
	/* Set MediaFlags for worm media and mark media as aged and not in any media group */
	/*
	For index backups we delete the archive files and chunks directly from DB before the media gets recycled.
	Such media, when they come for recycle they won't have any chunk so HasChunk will be 0,
	but if the row in MMDeletedAF for the media has CapacityFreedMB > 0 we want to treat it like a media that has chunks and is getting recycled.
	Hence set IsAged = 1 for such media as they are technically aged media.
        But note that since chunks are deleted we will reset the PhysicalBytesMB and LogicalBytesMB of the media to 0 in later queries based on HasChunk = 0.
	*/
	UPDATE	MMMedia
	SET		SpareGroupId = T.SpareGroupId,
			MediaFlags = CASE WHEN T.MediaFlags = 5 /*MEDIA_FLAG_RESERVED_BY_JOB*/ THEN 1 /*MEDIA_FLAG_GOOD*/ ELSE T.MediaFlags END,
			IsAged = (CASE WHEN HasChunk = 1 OR CapacityFreedMB > 0 THEN 1 ELSE MMMedia.IsAged END),
Attributes = MMMedia.Attributes & ~134217728 & ~1,
			ScheduleRunId = 0,
			RetentionFlags = 0,
			RetentionExpireTime = 0,
			IsInMediaGroup = 0
	FROM	#VolumeList T, MMVolume V WITH (UPDLOCK)
				-- the inner join with mmvolume having an update lock is itentional! (even though
				-- the query does not reference it) - issue is that when we marked the media as
				-- aged, that RM could pick this media marking it assigned and the volume as active.
				-- (see form F3710). If we lock all the relevant entries in MMVolume
				-- with an update lock, this cannot happen.
	WHERE	MMMedia.MediaId = T.MediaId AND V.MediaId = MMMedia.MediaId
AND		T.Recyclable = 1 AND T.MediaTypeId <> 10001
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		raiserror ('UPDATE MMMedia failed!', 16,1)
		SELECT 0
		RETURN
	END
	/* Mark non-magnetic media erasable if the SP copy is FORERASE_ONPRUNE */
	UPDATE	MMMediaSide
	SET		IsErasable = 1
	FROM	(SELECT	MediaId
			FROM	#VolumeList V,
					archStream S WITH (NOLOCK),
					archGroupCopy C WITH (NOLOCK)
			WHERE	S.MediaGroupId = V.MediaGroupId
			AND		V.Recyclable = 1
AND		V.MediaTypeId != 10001
			AND		C.id = S.archGroupCopyId
AND		(C.flags & 64) > 0) AS T
	WHERE	MMMediaSide.MediaId = T.MediaId
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		raiserror ('UPDATE MMMediaSide failed!', 16,1)
		SELECT 0
		RETURN
	END
	/*Update size for empty non-magnetic media*/
	UPDATE MMMediaSide SET LogicalBytesMB = 0, PhysicalBytesMB = 0, FreeBytesMB = TotalSpaceMB
	FROM MMMediaSide MS INNER JOIN #VolumeList V ON MS.MediaSideId = V.MediaSideId
WHERE V.Recyclable = 1 AND V.MediaTypeId != 10001 AND V.HasChunk = 0
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		raiserror ('UPDATE MMMediaSide failed!', 16,1)
		SELECT 0
		RETURN
	END
	/* Set VolumeFlags to VOL_IDLE (non-magnetic) or VOL_RECYCLE (magnetic) */
	/* Set MediaGroupId = 0 for magnetic volumes and empty non-magnetic media */
	/* Set SpareGroupId for bad or worm media */
	/* Set size to 0 for empty non-magnetic media */
	UPDATE	MMVolume
	SET		VolumeFlags = T.VolumeFlags,
			MediaGroupId = T.MediaGroupId,
Attributes = (Attributes & ~(8 | 16)),
PhysicalBytesMB = (CASE WHEN T.MediaTypeId != 10001 AND T.HasChunk = 0 THEN 0 ELSE PhysicalBytesMB END),
LogicalBytesMB = (CASE WHEN T.MediaTypeId != 10001 AND T.HasChunk = 0 THEN 0 ELSE LogicalBytesMB END)
	FROM	#VolumeList T
	WHERE	MMVolume.VolumeId = T.VolumeId
	AND		T.Recyclable = 1
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		raiserror ('UPDATE MMVolume failed!',16,1)
		SELECT 0
		RETURN
	END
	/* Check if these volumes can be updated with size since no physical */
	UPDATE MMVolume
	SET RMSpareStatusUpdateTime = @now
	FROM #VolCleanupNoPruningLib T
	WHERE MMVolume.VolumeId = T.VolumeId
	IF @@ERROR <> 0
	BEGIN
		ROLLBACK TRANSACTION
		raiserror('UPDATE MMVolume RMSpareStatusUpdateTime failed!', 16, 1)
		SELECT 0
		RETURN
	END
	COMMIT TRANSACTION
	/* Use the cursor to insert into mmlibraryhistory at the end - forward port of change made for form 3865.
	INSERT	INTO MMLibraryHistory (
			LibraryId, HistoryType, TimeStart, NumberOfSoftErrors, NumberOfHardErrors,
			NumberOfMediaUsed, NumberOfMediaFreed, DataWritten, DataRead, NumberOfBackups,
			NumberOfRestores, CapacityFreedMB, Modified, Version)
	SELECT	LibraryId, 1, 0, 0, 0, 0, NumberOfMediaFreed, 0, 0, 0, 0, CapacityFreedMB, 0, 0
	FROM	#LibHistory
	*/
	/* Populate the table for DataAging Alert Info */
	IF @i_JobId > 0
	BEGIN
		INSERT	INTO #RecyclableMedia
		SELECT	DISTINCT M.MediaId, M.BarCode
		FROM		MMMedia M, #VolumeList V
		WHERE		M.MediaId = V.MediaId
		AND			V.Recyclable = 1
AND			M.MediaTypeId != 10001
		EXEC daPopulateAlertInfo @i_JobId, @i_CommCellId, 1, 0, 0
	END
/****************************************************************************************/
CX_EXIT:
	/* Clean invalid or dangling MMDeletedAF table entries */
	INSERT	INTO #VolCleanup
	SELECT	DISTINCT DAF.VolumeId
	FROM	MMDeletedAF DAF LEFT OUTER JOIN MMVolume V WITH (NOLOCK)
		ON	V.VolumeId = DAF.VolumeId
	WHERE	V.VolumeId IS NULL
	-- DELETE FROM MMDeletedAF
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxRowsToPruneInBatch) D
    	FROM    MMDeletedAF D
    	WHERE  D.SIDBStoreId = 0 AND D.VolumeId = 0
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			BREAK
		END
		IF @RowCount = 0
			BREAK
	END
	-- DELETE FROM MMDeletedAF
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxRowsToPruneInBatch) D
    	FROM    MMDeletedAF D INNER JOIN  #VolCleanup T ON D.VolumeId = T.VolumeId
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			BREAK
		END
		IF @RowCount = 0
			BREAK
	END
	/*** Cleanup entries with VolId = 0 for stores which are marked as prunable */
	-- DELETE FROM MMDeletedAF
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxRowsToPruneInBatch)D
		FROM MMDeletedAF D WITH (PAGLOCK)
			LEFT OUTER JOIN IdxSIDBStore I ON D.SIDBStoreId = I.SIDBStoreId
WHERE D.SIDBStoreId > 0 AND ((I.flags & 256 > 0) OR (I.SIDBStoreId IS NULL))
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			BREAK
		END
		IF @RowCount = 0
			BREAK
	END
	-- DELETE FROM MMDeletedArchFileTracking
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxRowsToPruneInBatch)D
		FROM MMDeletedArchFileTracking D WITH (PAGLOCK)
			LEFT OUTER JOIN IdxSIDBStore I ON D.SIDBStoreId = I.SIDBStoreId
WHERE D.SIDBStoreId > 0 AND ((I.flags & 256 > 0) OR (I.SIDBStoreId IS NULL))
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			BREAK
		END
		IF @RowCount = 0
			BREAK
	END
	/* Cleanup entries for stores which are sealed and corrupted */
	/* Removing without checking for Config param to retain ddbbkp of sealed stores is ok because during validation
	   we will mark the AF as invalid if it does not exist in MMDAF. Basically all the rows being deleted below will have
	   to be pruned while reconstructing sealed store.
	   Reconstructing sealed stores is corner case anyway.
	*/
	/* Undo this change as there already exists a cleanup mechanism for the rows which are processed by online stores.
		Check - MMCleanDeletedAF.sp
	*/
	WHILE (1 = 1)
	BEGIN
		-- DELETE FROM MMDeletedAF
		DELETE TOP (@maxRowsToPruneInBatch) D
		FROM MMDeletedAF D
			INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON D.VolumeId = V.VolumeId
			INNER JOIN IdxSIDBStore I WITH (READUNCOMMITTED) ON D.SIDBStoreId = I.SIDBStoreId
		WHERE (V.VolumeFlags = 6 /*VOL_RECYCLE*/ OR D.VolumeId = 0)
		AND D.SIDBStoreId > 0
		AND I.SealedTime > 0
		AND I.Status = 1
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			BREAK
		END
		IF @RowCount = 0
			BREAK
	END
	WHILE (1 = 1)
	BEGIN
		-- DELETE FROM MMDeletedArchFileTracking
		DELETE TOP (@maxRowsToPruneInBatch) D
		FROM MMDeletedArchFileTracking D
			INNER JOIN IdxSIDBStore I WITH (READUNCOMMITTED) ON D.SIDBStoreId = I.SIDBStoreId
		WHERE D.SIDBStoreId > 0
		AND I.SealedTime > 0
		AND I.Status = 1
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			BREAK
		END
		IF @RowCount = 0
			BREAK
	END
	-- DELETE FROM MMDeletedAF for rows which do not have MPId > 0
	WHILE (1 = 1)
	BEGIN
	    DELETE TOP (@maxRowsToPruneInBatch) D
    	FROM    MMDeletedAF D INNER JOIN  #CopyCleanup T ON D.CopyId = T.CopyId
		WHERE D.MountPathId = 0 and D.VolumeId = 0
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			BREAK
		END
		IF @RowCount = 0
			BREAK
	END
	INSERT INTO MMDeletedAF (archFileId, VolumeId, Status, Retry, copyId, cclip,
			CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt)
SELECT DAFT.archFileId, 0, 2, 0, DAFT.CopyId, '',
			0, 0, 0, DAFT.SIDBStoreId, DAFT.CommCellId, DAFT.DeletedTime, DAFT.FailureErrorCode, DAFT.SubStoreBitField, 0, 0, 0
	FROM MMDeletedArchFileTracking DAFT WITH (READUNCOMMITTED)
		LEFT OUTER JOIN MMDeletedAF DAF WITH (READUNCOMMITTED) ON DAF.archFileId = DAFT.archFileId AND DAF.CommCellId = DAFT.CommCellId AND DAF.SIDBStoreId = DAFT.SIDBStoreId
	WHERE DAF.archFileId IS NULL
	DELETE DAFT
	FROM MMDeletedArchFileTracking DAFT
		LEFT OUTER JOIN MMDeletedAF DAF WITH (READUNCOMMITTED) ON DAF.archFileId = DAFT.archFileId AND DAF.CommCellId = DAFT.CommCellId AND DAF.SIDBStoreId = DAFT.SIDBStoreId
	WHERE DAF.archChunkId = 0
	/* Mark PROCESSED so the same entry will not be processed again */
	IF	EXISTS (SELECT VolumeId FROM #VolumeList)
		UPDATE	MMDeletedAF WITH (PAGLOCK)
SET		status = (status | 256 | 1)
		FROM	#VolumeList T
		WHERE	MMDeletedAF.VolumeId = T.VolumeId
	/* This change will not be neccessary when the QNet libraryhistory trigger is fixed */
	IF EXISTS (SELECT * FROM #LibHistory)
	BEGIN
		DECLARE	@tmpLibraryId		INT
		DECLARE	@tmpNumOfMediaFreed	INT
		DECLARE	@tmpCapacityFreedMB	INT
		DECLARE	libHistCursor CURSOR FOR
				SELECT	LibraryId, SUM (NumberOfMediaFreed), SUM(CapacityFreedMB)
				FROM	#LibHistory
				GROUP BY LibraryId
		OPEN	libHistCursor
		FETCH	NEXT FROM libHistCursor
		INTO	@tmpLibraryId, @tmpNumOfMediaFreed, @tmpCapacityFreedMB
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			INSERT INTO MMLibraryHistory (LibraryId, HistoryType, TimeStart,
								NumberOfSoftErrors, NumberOfHardErrors,	NumberOfMediaUsed, NumberOfMediaFreed,
								DataWritten, DataRead, NumberOfBackups,	NumberOfRestores, CapacityFreedMB,
								Modified, Version)
			VALUES (@tmpLibraryId, 1, 0, 0, 0, 0, @tmpNumOfMediaFreed, 0, 0, 0, 0, @tmpCapacityFreedMB, 0, 0)
		FETCH	NEXT FROM libHistCursor
		INTO	@tmpLibraryId, @tmpNumOfMediaFreed, @tmpCapacityFreedMB
		END
		CLOSE		libHistCursor
		DEALLOCATE	libHistCursor
	END
	IF OBJECT_ID('tempdb.dbo.#VolumeList') IS NOT NULL DROP TABLE #VolumeList
	IF OBJECT_ID('tempdb.dbo.#VolHasChunk') IS NOT NULL DROP TABLE #VolHasChunk
	IF OBJECT_ID('tempdb.dbo.#VolCleanup') IS NOT NULL DROP TABLE #VolCleanup
	IF OBJECT_ID('tempdb.dbo.#LibHistory') IS NOT NULL DROP TABLE #LibHistory
	IF OBJECT_ID('tempdb.dbo.#RecyclableMedia') IS NOT NULL DROP TABLE #RecyclableMedia
	IF OBJECT_ID('tempdb.dbo.#RVIDArchChunks') IS NOT NULL DROP TABLE #RVIDArchChunks
	IF OBJECT_ID('tempdb.dbo.#NoPruningLibrary') IS NOT NULL DROP TABLE #NoPruningLibrary
	IF OBJECT_ID('tempdb.dbo.#VolCleanupNoPruningLib') IS NOT NULL DROP TABLE #VolCleanupNoPruningLib
	IF OBJECT_ID('tempdb.dbo.#CopyCleanup') IS NOT NULL DROP TABLE #CopyCleanup
	SELECT	@numMediaRecycled
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'RecycleVolumesInDeletedAF')
	delete from GxQscripts where name = 'RecycleVolumesInDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RecycleVolumesInDeletedAF')
	delete from GXDBVersions where aliasname = 'RecycleVolumesInDeletedAF'
GO

insert into GXDBVersions values(2, 'RecycleVolumesInDeletedAF',  '00010125000200250000', 'RecycleVolumesInDeletedAF', '00010125000200250000')
GO

