

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMUpdateStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMUpdateStatus.sp,v $ $Id: RMUpdateStatus.sp,v 1.8.304.2 2018/03/20 00:00:50 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMUpdateStatus <<<'

IF EXISTS (select * from sysobjects where name='RMUpdateStatus')
	drop procedure RMUpdateStatus
IF EXISTS (select * from GxQscripts where name='RMUpdateStatus')
	delete from GxQscripts where name = 'RMUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMUpdateStatus')
	delete from GXDBVersions where aliasname = 'RMUpdateStatus'
GO
print '... Creating Procedure: RMUpdateStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMUpdateStatus
  @i_dummy integer
AS
-- Following are the "columns" returned, in the order in which they are returned
	DECLARE @l_UpdateIntervalMin INTEGER
	SET @l_UpdateIntervalMin = isnull((select value from MMConfigs where name = 'MMS2_CONFIG_RM_FULLSTATUSUPDATE_INTERVAL_MINUTES'), 10)
	DECLARE @l_NowTime INTEGER
	DECLARE @l_CompareTime INTEGER
	SET @l_NowTime  =  dbo.getUnixTime(getUTCDate())
	SET @l_CompareTime =  @l_NowTime - @l_UpdateIntervalMin*60
	-- for an explanation of this stored procedure and
	-- how it works, refer to the graph in the 7.0 RM word document
	-- which is around page 8.
	-- (It makes use of triggers acting in the background)
	-- use temp table - for some reason selecting and then updating is like 10x faster than having the where in the update
	DECLARE @lt_RMStatus TABLE (id INTEGER, RMStatus INTEGER)
	-- MMHOST
	INSERT INTO @lt_RMStatus
SELECT MMHost.ClientId, RMStatus = ( CASE WHEN MMHost.MmHostSoftState = 1 AND MMHost.MmHostEnabled = 1 then 0 ELSE 1 END ) |
( CASE WHEN IA.Softstate = 1 AND IA.Enabled = 1 then 0 ELSE 32 END )
	FROM MMHost, IdxAccessPath IA INNER JOIN IdxCache IC ON IC.IdxCacheId = IA.IdxCacheId AND IC.IdxCacheType = 1
	WHERE IA.ClientId = MMHost.ClientId AND
(MMHost.RMStatus >= 1073741824 OR MMHost.RMStatusUpdateTime < @l_CompareTime )
	UPDATE MMHost
	SET RMStatus = tt.RMStatus, RMStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMHost.ClientId = tt.id
	DELETE FROM @lt_RMStatus
	-- MMMasterPool
	INSERT INTO @lt_RMStatus
SELECT MMMasterPool.MasterPoolId, RMStatus = ( CASE WHEN L.LibrarySoftState = 1 AND L.LibraryEnabled = 1 AND L.LibraryBroken = 0 then 0 ELSE 2 END ) |
( CASE WHEN MMMasterPool.MasterPoolSoftState = 1 AND MMMasterPool.MasterPoolEnabled = 1 then 0 ELSE 16 END )
	FROM MMMasterPool, MMLibrary L
	WHERE MMMasterPool.LibraryId = L.LibraryId AND
(MMMasterPool.RMStatus >= 1073741824 OR MMMasterPool.RMStatusUpdateTime < @l_CompareTime )
	UPDATE MMMasterPool
	SET RMStatus = tt.RMStatus, RMStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMMasterPool.MasterPoolId = tt.id
	DELETE FROM @lt_RMStatus
	-- MMDrivePool
	INSERT INTO @lt_RMStatus
SELECT MMDrivePool.DrivePoolId,  RMStatus = ( MMDrivePool.RMStatus & (32 | 1 | 2 | 16)) |
( CASE WHEN DrivePoolSoftState = 1 AND DrivePoolEnabled = 1 then 0 ELSE 8 END )
	FROM MMDrivePool
WHERE RMStatus >= 1073741824 OR RMStatusUpdateTime < @l_CompareTime
	UPDATE MMDrivePool
	SET RMStatus = tt.RMStatus, RMStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMDrivePool.DrivePoolId = tt.id
	DELETE FROM @lt_RMStatus
	-- MMMountPath
	INSERT INTO @lt_RMStatus
SELECT MMMountPath.MountPathId, RMStatus = ( RMStatus & (2 | 16 | 32 | 1 | 2 | 16 | 8)) |
( CASE WHEN IsEnabled = 1 AND IsOffline = 0 then 0 ELSE 64 END )
	FROM MMMountPath
WHERE RMStatus >= 1073741824  OR RMStatusUpdateTime < @l_CompareTime
	UPDATE MMMountPath
	SET RMStatus = tt.RMStatus, RMStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMMountPath.MountPathId = tt.id
	DELETE FROM @lt_RMStatus
	-- MMDevice
	INSERT INTO @lt_RMStatus
SELECT MMDevice.DeviceId, RMStatus = (RMStatus & 2 | 16 | 32 | 1 | 2 | 16 | 8 | 64)  |
( CASE WHEN DeviceBroken = 0 AND DeviceEnabled = 1 then 0 ELSE 512 END )
	FROM MMDevice
WHERE RMStatus >= 1073741824  OR RMStatusUpdateTime < @l_CompareTime
	UPDATE MMDevice
	SET RMStatus = tt.RMStatus, RMStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMDevice.DeviceId = tt.id
	DELETE FROM @lt_RMStatus
	-- MMDeviceController
	INSERT INTO @lt_RMStatus
SELECT MMDeviceController.DeviceControllerId, RMStatus = (RMStatus & (2 | 16 | 64 | 512 | 32 | 1)) |
( CASE WHEN DeviceControllerEnabled = 1 then 0 ELSE 1024 END )
	 FROM MMDeviceController
WHERE RMStatus >= 1073741824  OR RMStatusUpdateTime < @l_CompareTime
	UPDATE MMDeviceController
	SET RMStatus = tt.RMStatus, RMStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMDeviceController.DeviceControllerId = tt.id
	DELETE FROM @lt_RMStatus
	-- MMDrive
	INSERT INTO @lt_RMStatus
	SELECT MMDrive.DriveId, RMStatus = ( CASE WHEN DriveSoftState  = 1 AND DriveEnabled = 1
AND MountStatus NOT IN (4, 2, 3) then 0 ELSE 4 END )
	FROM MMDrive
WHERE RMStatus >= 1073741824  OR RMStatusUpdateTime < @l_CompareTime
	UPDATE MMDrive
	SET RMStatus = tt.RMStatus, RMStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMDrive.DriveId = tt.id
	DELETE FROM @lt_RMStatus
	-- MMDriveController
	INSERT INTO @lt_RMStatus
SELECT MMDriveController.DriveControllerId, RMStatus = (RMStatus & (32 | 1 | 2 | 16 | 8 | 256 | 4))  |
( CASE WHEN DriveControllerSoftState = 1 AND DriveControllerEnabled = 1 then 0 ELSE 128 END )
	FROM MMDriveController
WHERE RMStatus >= 1073741824  OR RMStatusUpdateTime < @l_CompareTime
	UPDATE MMDriveController
	SET RMStatus = tt.RMStatus, RMStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMDriveController.DriveControllerId = tt.id
	-- Media update
	-- step 1 - everything media and library option related
	DECLARE @lt_MediaStatus TABLE (MediaId Integer, RMSpareStatus Integer)
	INSERT INTO @lt_MediaStatus
	SELECT M.MediaId,
		-- set magnetic bit
(CASE WHEN MediaTypeId = 10001 then 1 ELSE 0 END) |
		-- set IsInIEPort bit
(CASE WHEN IsNull(MS.SlotType, 0) > 1 then 2048 ELSE 0 END) |
		--  set isDuplicateBarCode bit
(CASE WHEN (IsNull(MS.MediaStatus,0) & 1) <> 0 then 4096 ELSE 0 END ) |
		-- set is doing inventory bit
(CASE WHEN IsNull(MS.InventoryStatus, 0) = 1 then 131072 else 0 END)
	FROM MMMedia M  LEFT OUTER JOIN MMSlot MS ON MS.MediaId = M.MediaId
	WHERE  M.MediaId <> 0 AND
((RMSpareStatus & 1073741824) <> 0 OR RMSpareStatusUpdateTime < @l_CompareTime OR RMSpareStatus<0)
	-- media specific updates are taken care of by the trigger - following are bits taken care of in the trigger
	-- so that they do not need to be updated here
	-- RMSPARESTATUS_ISBADORDEPRECABLE | RMSPARESTATUS_NOTINLIB | RMSPARESTATUS_ISINMEDIAGROUP | RMSPARESTATUS_DIFFERENTCOMMCELL
	UPDATE MMMedia
	SET RMSpareStatus = tt.RMSpareStatus, RMSpareStatusUpdateTime = @l_NowTime
	FROM @lt_MediaStatus as tt
	WHERE MMMedia.MediaId = tt.MediaId
	-- step 2 - stuck in drive bits - do this for all drives as the number of rows will be minimal
	UPDATE MMMedia
SET RMSpareStatus = M.RMSpareStatus | 8192,
			RMSpareStatusUpdateTime = @l_NowTime
	FROM MMDrive D INNER JOIN MMMedia M ON D.MediaId = M.MediaId
WHERE M.MediaTypeId <> 10001 AND
				(D.DriveSoftState = 0 or D.DriveEnabled = 0 or D.DriveBroken = 1 or D.MountStatus = 4)
				AND M.MediaId > 0
	-- step 3 -- volumes
	DELETE FROM @lt_RMStatus
	INSERT INTO @lt_RMStatus
SELECT VolumeId, RMSpareStatus = ( case when RecordingFormatId = 10001 then 1
												else
RMSpareStatus & (512 | 128 | 1024 | 65536 | 2048 | 4096 | 8192 | 1024)
												end
											)
	FROM MMVolume
WHERE VolumeId > 0 AND ((RMSpareStatus & 1073741824) <> 0  OR RMSpareStatusUpdateTime < @l_CompareTime)
	UPDATE MMVolume
	SET RMSpareStatus = tt.RMStatus, RMSpareStatusUpdateTime = @l_NowTime
	FROM @lt_RMStatus tt
	WHERE MMVolume.VolumeId = tt.id
	-- step 4 - mark dummy media spare status to 0 indicating that the spare status has been updated
	UPDATE MMMedia
	SET RMSpareStatus = 0,
			RMSpareStatusUpdateTime = @l_NowTime
	WHERE MediaId = 0 AND RMSpareStatus <> 0
GO

IF EXISTS (select * from GxQscripts where name = 'RMUpdateStatus')
	delete from GxQscripts where name = 'RMUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMUpdateStatus')
	delete from GXDBVersions where aliasname = 'RMUpdateStatus'
GO

insert into GXDBVersions values(2, 'RMUpdateStatus',  '00010008030400020000', 'RMUpdateStatus', '00010008030400020000')
GO

