

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMUpdateReservationRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMUpdateReservationRequest.sp,v $ $Id: RMUpdateReservationRequest.sp,v 1.8.2.2 2018/03/20 00:06:42 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMUpdateReservationRequest()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMUpdateReservationRequest <<<'

IF EXISTS (select * from sysobjects where name='RMUpdateReservationRequest')
	drop procedure RMUpdateReservationRequest
IF EXISTS (select * from GxQscripts where name='RMUpdateReservationRequest')
	delete from GxQscripts where name = 'RMUpdateReservationRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMUpdateReservationRequest')
	delete from GXDBVersions where aliasname = 'RMUpdateReservationRequest'
GO
print '... Creating Procedure: RMUpdateReservationRequest'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMUpdateReservationRequest
  @i_JobId int,
  @i_JobIdBulk varchar(max),
  @i_RequestId int,
  @i_Priority int,
  @i_Status int
AS
  DECLARE @o_ErrorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	set @o_ErrorCode = 0
	if (@i_priority > 0)
	begin
		if (@i_JobId is not null and @i_JobId > 0 and exists (select * from RMReservationRequest where JobId = @i_JobId))
		or (@i_RequestId is not null and @i_RequestId > 0	and exists (select * from RMReservationRequest where RequestId = @i_RequestId))
		begin
			update RMReservationRequest
			set priority = @i_priority
			where (JobId = @i_JobId or @i_JobId = -1)
			and		(RequestId = @i_RequestId or @i_RequestId = -1)
		end
		else if len(@i_JobIdBulk) > 0
		begin
			-- bulk update
			declare @updatepriority varchar(max)
			set @updatepriority = 'update RMReservationRequest set priority = ' + cast(@i_priority as varchar(20)) + ' where JobId in (' + @i_JobIdBulk + ')'
			exec (@updatepriority)
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
			end
		end
	end
if (@i_Status > 0 and @i_Status != 0)
	begin
		/*
if @i_Status = 4 and @i_RequestId is not NULL and @i_RequestId > 0
		begin
			delete RMReservationRequest where RequestId = @i_RequestId
		end
		*/
		if (@i_JobId is not null and @i_JobId > 0 and exists (select * from RMJobControl  with (readuncommitted) where JobId = @i_JobId))
		begin
			update RMJobControl set Status = @i_Status, RequestTime = dbo.GetUnixTime(getutcdate()) where JobId = @i_JobId
		end
		else if len(@i_JobIdBulk) > 0
		begin
			-- bulk update
			declare @updatestatus varchar(max)
			set @updatestatus = 'update RMJobControl set Status = ' + cast(@i_Status as varchar(20)) + ' where JobId in (' + @i_JobIdBulk + ')'
			exec (@updatestatus)
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
			end
		end
	end
  select @o_ErrorCode
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMUpdateReservationRequest')
	delete from GxQscripts where name = 'RMUpdateReservationRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMUpdateReservationRequest')
	delete from GXDBVersions where aliasname = 'RMUpdateReservationRequest'
GO

insert into GXDBVersions values(2, 'RMUpdateReservationRequest',  '00010008000200020000', 'RMUpdateReservationRequest', '00010008000200020000')
GO

