

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMSubmitReservationRequests.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMSubmitReservationRequests.sp,v $ $Id: RMSubmitReservationRequests.sp,v 1.15.2.13 2020/05/18 18:45:38 chandru Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMSubmitReservationRequests()
--  +========================================================================+
--
--	This stored procedure is used for Dash copy reservation and follows the new logic for Dash Copy handler.
--	Based on the reservation request Id, it can do source and destinaiton reservation or destination reservation only.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMSubmitReservationRequests')
BEGIN
	print '>>> Drop Stored Procedure: RMSubmitReservationRequests <<<'
	drop procedure RMSubmitReservationRequests
END
IF EXISTS (select * from GxQscripts where name='RMSubmitReservationRequests')
	delete from GxQscripts where name = 'RMSubmitReservationRequests'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMSubmitReservationRequests')
	delete from GXDBVersions where aliasname = 'RMSubmitReservationRequests'
GO
print '... Creating Procedure: RMSubmitReservationRequests'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMSubmitReservationRequests
  @i_jobId int,
  @i_jobType int,
  @i_streamReaderId int,
  @i_registrySetting varchar(max)
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_RequestId integer;
  DECLARE @o_CopyId integer;
  DECLARE @o_StreamNum integer;
  DECLARE @o_ClientId integer;
  DECLARE @o_MediaAgentName varchar(1024);
  DECLARE @o_LibraryId integer;
  DECLARE @o_LibraryName varchar(128);
  DECLARE @o_LibraryAliasName NVARCHAR(128);
  DECLARE @o_isMagnetic integer;
  DECLARE @o_BarCode varchar(256);
  DECLARE @o_StreamReaderId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	set @o_RequestId = 0
set @o_ErrorCode = 0
set @o_FailureType = 1
	set @o_CopyId = 0
	set @o_StreamNum = 0
	set @o_ClientId = 0
	set @o_MediaAgentName = ''
	set @o_LibraryId = 0
	set @o_LibraryName = ''
	set @o_LibraryAliasName = ''
	set @o_isMagnetic = 0
	set @o_Barcode = ''
  /*#include "JobManager/cvjob.h"*/
  declare @BKPJOB int
  declare @CSDRBKPJOB int
  declare @AUXCOPYJOB int
  declare @SYNTHFULLJOB int
  declare @ARCHCHECKJOB int
  declare @MEDIAREFRESHINGJOB int
  declare @DEDUPDBSYNCJOB int
  declare @DASHCOPYJOB int
  set @BKPJOB = 1
  set @CSDRBKPJOB = 4
  set @AUXCOPYJOB = 6
  set @SYNTHFULLJOB = 7
  set @ARCHCHECKJOB = 12
  set @MEDIAREFRESHINGJOB = 25
  set @DEDUPDBSYNCJOB = 26
  set @DASHCOPYJOB = 37
  -- Job OpType and subOpType
  declare @AUXCOPY2 int = 104
  declare @ARCHIVECHECK2 int = 106
  declare @MEDIAREFRESHING2 int = 127
  declare @SYNTHFULL 	int = 14
  declare @DEDUPDBSYNC_DASH 	int = 131
  DECLARE @reservationRequestXml	XML
  DECLARE @sourceArgsXml		XML
  DECLARE @destinationArgsXml	XML
  SET @sourceArgsXml = ''
  SET @destinationArgsXml = ''
  SET @reservationRequestXml = ''
  DECLARE @requestCategory int
  SET @requestCategory = 0
  -- For now, used the setting based on Dash copy properties
  DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS INT = 60
  SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 60)
  DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS    INT = 10
  -- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
  SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
  DECLARE @tblStreamReaderList TABLE (StreamReaderId int)
  DECLARE @tblStreamReservationError TABLE (
	ErrorCode			integer,
	FailureType			integer,
	RequestId			integer,
	CopyId				integer,
	StreamNum			integer,
	ClientId			integer,
MediaAgentName		varchar(1024),
	LibraryId			integer,
LibraryName			varchar(128),
LibraryAliasName	NVARCHAR(128),
	isMagnetic			integer,
BarCode				varchar(256),
	StreamReaderId		integer
	)
  -- General parameters
  DECLARE @commCellId		int
  DECLARE @jobId			int
  DECLARE @jobType			int
  DECLARE @jobOpType		int
  DECLARE @jobSubOpType		int
  DECLARE @jobPhase			int
  DECLARE @archGroupId		int
  DECLARE @copyId			int
  DECLARE @priority			int
  DECLARE @preEmptable		int
  DECLARE @scheduleRunId	int
  SET @commCellId = 0
  SET @jobId = 0
  SET @jobType = 0
  SET @jobOpType = 0
  SET @jobSubOpType = 0
  SET @jobPhase = 0
  SET @archGroupId = 0
  SET @copyId = 0
  SET @priority = 0
  SET @preEmptable = 0
  SET @scheduleRunId = 0
  IF EXISTS (SELECT * FROM JMJobInfo WITH (NOLOCK) WHERE JobId = @i_jobId)
  BEGIN
	  SELECT	@commCellId = ISNULL(admin.commCellId, 2),
				@jobId = @i_jobId,
				@jobType = @i_jobType,
				@jobOpType = ISNULL(job.opType, 0),
				@jobSubOpType = ISNULL(job.subOpType, 0),
				@jobPhase = ISNULL(job.currentPhase, 0),
				@archGroupId = ISNULL(admin.archGrpID, 0),
				@copyId = 0,
				@priority = ISNULL(job.combPriority, 0),
				@preEmptable = ISNULL(job.preemptable, 0),
				@scheduleRunId = ISNULL(tm.jobRequestId, 0)
	  FROM	(select * from JMJobInfo WITH (NOLOCK) where jobId = @i_jobId) job
			LEFT JOIN JMAdminJobInfoTable admin WITH (NOLOCK) ON Job.JobId = admin.jobId
			LEFT JOIN TM_Jobs tm WITH (NOLOCK) ON tm.JobId = job.JobId
  END
  ELSE
  BEGIN
SET @o_ErrorCode = 464
  	SELECT @o_RequestId = 0, @o_CopyId = 0, @o_StreamNum = 0,
			@o_clientId = 0, @o_mediaAgentName = '',
			@o_libraryId = 0, @o_libraryName = '', @o_libraryAliasName = '',
			@o_barcode = ''
	INSERT INTO @tblStreamReservationError
	select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
			 @o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName,
			 @o_isMagnetic, @o_Barcode, @i_streamReaderId
	goto exit_error;
  END
  IF @jobType = @ARCHCHECKJOB AND @jobSubOpType IS NOT NULL AND @jobSubOpType > 0
	SET @jobOpType = @jobSubOpType
  IF @jobType = @MEDIAREFRESHINGJOB AND @jobSubOpType IS NOT NULL AND @jobSubOpType > 0
	SET @jobOpType = @jobSubOpType
  IF @jobType = @DASHCOPYJOB AND @jobSubOpType IS NOT NULL AND @jobSubOpType > 0
	SET @jobOpType = @jobSubOpType
  IF @jobType = @DEDUPDBSYNCJOB AND @jobSubOpType IS NOT NULL AND @jobSubOpType > 0
	SET @jobOpType = @jobSubOpType
  DECLARE @dedupeValidate INT = 0
  DECLARE @dataValidate INT = 0
  DECLARE @defragment INT = 0
  DECLARE @orphanListing INT = 0
  DECLARE	@opId INT = 0
  IF @jobOpType = @ARCHIVECHECK2
  BEGIN
	    SELECT	@opId = id
        FROM	JMOpTable WITH (READUNCOMMITTED)
        WHERE	operation=31 /*ARCHIVECHECK*/
		SELECT	@dedupeValidate = [Validate Dedupe Data],
				@dataValidate =  [Verify Data],
				@orphanListing = [Orphan Chunk listing],
				@defragment = [Defragment Data]
		FROM
			(SELECT	phase, name
			FROM	JMPhase WITH (READUNCOMMITTED)
			WHERE	opTableId = @opId) AS JP
			PIVOT
			(
			MAX(phase)
			FOR name IN ([Validate Dedupe Data], [Verify Data], [Orphan Chunk listing], [Defragment Data])
			) p;
        SELECT	@jobPhase = ISNULL(currentPhase, 0)
        FROM	jmjobinfo WITH (NOLOCK)
		WHERE	jobId = @i_jobId
  END
  IF @jobOpType NOT IN (@AUXCOPY2, @ARCHIVECHECK2, @SYNTHFULL, @MEDIAREFRESHING2, @DEDUPDBSYNC_DASH)
	OR (@jobType = @ARCHCHECKJOB AND @jobPhase NOT IN (@dedupeValidate, @dataValidate, @orphanListing, @defragment))
  BEGIN
SET @o_ErrorCode = 322
  	SELECT @o_RequestId = 0, @o_CopyId = 0, @o_StreamNum = 0,
			@o_clientId = 0, @o_mediaAgentName = '',
			@o_libraryId = 0, @o_libraryName = '', @o_libraryAliasName = '',
			@o_barcode = ''
	INSERT INTO @tblStreamReservationError
	select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
			 @o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName,
			 @o_isMagnetic, @o_Barcode, 0
	goto exit_error;
  END
  -- Do mulitple reservation at once
  -- If given streamReaderId is not set, pick all the created new stream Readers
  IF @i_streamReaderId = 0
  BEGIN
	INSERT INTO @tblStreamReaderList
	SELECT 	DISTINCT StreamReaderId
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_jobId
	AND		Status = 0 /*NOT RESERVED, NOT INITIALIZED*/
  END
PICK_NEXT_STREAMREADER:
  IF EXISTS (SELECT * FROM @tblStreamReaderList)
  BEGIN
	SELECT @i_streamReaderId = MIN (StreamReaderId ) FROM @tblStreamReaderList
	DELETE @tblStreamReaderList WHERE StreamReaderId = @i_streamReaderId
  END
  -- This should not happen
  IF @i_streamReaderId = 0
  BEGIN
SET @o_ErrorCode = 20024
  	SELECT @o_RequestId = 0, @o_CopyId = 0, @o_StreamNum = 0,
			@o_clientId = 0, @o_mediaAgentName = '',
			@o_libraryId = 0, @o_libraryName = '', @o_libraryAliasName = '',
			@o_barcode = ''
	INSERT INTO @tblStreamReservationError
	select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
			 @o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName,
			 @o_isMagnetic, @o_Barcode, 0
	goto exit_error;
  END
  -- Read part variables
  DECLARE @segmentId		int
  DECLARE @volId			int
  DECLARE @DrvPoolId		int
  DECLARE @mediaAgentId		int
DECLARE @mediaAgentName	varchar(1024)
  DECLARE @mediaId			int
  DECLARE @MediaGrpId		int
  DECLARE @reservationType	int
  DECLARE @bestcaseReserve	int
  DECLARE @checkConcurrency	int
  DECLARE @reservisDummyReservationType	int
  DECLARE @destinationMediaGroupId		int
  DECLARE @resBitMask		int
  DECLARE @isMultipleCopies int
  DECLARE @copyList XML
  SET @isMultipleCopies = 0
  SET @copyList = ''
  DECLARE @isForSnapCopyData int = 0
  IF @i_streamReaderId > 0
  BEGIN
	-- When doing parallel copy, different destination copy may start from different volume and chunk even within the same segment.
	-- It is because chunks can be copied previously partially or completed by different job or in different conditions (such as resources are not enough for all destiantions).
	-- But since these chunks are put into the same segment, we can assume all the volume/chunk can be accessed by the same MediaAgent/DrivePool.
	-- So checking the only one chunk/volume for the source Media Agent will be enough.
	SELECT TOP 1
		@copyId = SrcCopyId,
		@segmentId = SegmentId,
		@volId = FirstVolumeId,
		@DrvPoolId = 0,
		@mediaAgentId = 0,
		@mediaAgentName = 0,
		@mediaId = 0,
		@mediaGrpId = 0,
@reservationType = 1,
		@bestcaseReserve = 1,
		@checkConcurrency = 0,
		@reservisDummyReservationType = 0,
		@destinationMediaGroupId = 0,
@resBitMask = 4
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	StreamReaderId = @i_StreamReaderId
	AND		JobId = @i_jobId
	ORDER BY CommCellId, FirstChunkId
	-- Check if this is for snap copy
	SELECT @isForSnapCopyData = CASE WHEN b.isSnapCopy = 1 AND a.SrcStreamNum != 1 THEN 1 ELSE 0 END
	FROM ArchJobStreamStatus a WITH (NOLOCK), ArchGroupCopy b WITH (NOLOCK)
	WHERE	a.StreamReaderId = @i_StreamReaderId
	AND		a.JobId = @i_jobId
	AND		a.DestCopyId = b.Id
  END
  ELSE
  BEGIN
    -- This should not happen
SET @o_ErrorCode = 20024
  	SELECT @o_RequestId = 0, @o_CopyId = 0, @o_StreamNum = 0,
			@o_clientId = 0, @o_mediaAgentName = '',
			@o_libraryId = 0, @o_libraryName = '', @o_libraryAliasName = '',
			@o_barcode = ''
	INSERT INTO @tblStreamReservationError
	select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
			 @o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName,
			 @o_isMagnetic, @o_Barcode, @i_streamReaderId
	goto exit_error;
  END
  DECLARE @preferredDestCopyId	int
  DECLARE @preferredMediaAgentId	int
  SET @preferredDestCopyId = 0
  SET @preferredMediaAgentId = 0
  DECLARE @destCopyAndDP	TABLE (
	copyId			integer,
	datapathId		integer,
	mediaAgentId	integer,
	drivepoolId		integer,
	drivepoolType	integer,
	ndmpClientId	integer
  )
  DELETE FROM @destCopyAndDP
  DECLARE @getMAAndDPForVolumeResult TABLE (
	retCode			integer,
mediaAgentName	varchar(1024),
	clientId		integer,
	nasClientId		integer,
	clientReleaseId	integer,
filerName		varchar(1024),
	hostId			integer,
	drivepoolId		integer,
	drivepoolType	integer,
	libraryId		integer,
	libraryTypeId	integer,
	libraryAttribute integer,
libraryName			varchar(128),
libraryAliasName	nvarchar(128),
barcode			varchar(256),
	volumeId		integer,
	mediaLocation	integer,
	jobOpType		integer,
	failureType		integer
  )
  DELETE from @getMAAndDPForVolumeResult
  IF (@segmentId > 0 AND @isForSnapCopyData = 1 AND @jobOpType = @AUXCOPY2)
  BEGIN
	-- Source Media Agent should be decided already at this point
	SELECT 	TOP 1 @DrvPoolId = SrcDrivePoolId,
			@mediaAgentId = SrcMAId
	FROM	ArchChunkToReplicate WITH (NOLOCK)
	WHERE	adminJobId = @i_jobId
	AND		SegmentId = @segmentId
AND		Status IN (0)
	IF @mediaAgentId > 0
		SELECT @mediaAgentName = name FROM App_Client WITH (NOLOCK) WHERE Id = @mediaAgentId
	UPDATE ArchJobStreamStatus
	SET		SrcMAId = @mediaAgentId,
			SrcDrivePoolId = @DrvPoolId
	WHERE	StreamReaderId = @i_StreamReaderId
	AND		JobId = @i_jobId
  END
  ELSE IF @volId > 0
  BEGIN
	-- Maybe this should be picked from ArchJobStreamStatus table
	SET @o_CopyId = @copyId
	SELECT @o_StreamNum = srcStreamNum FROM	ArchJobStreamStatus stream WITH (NOLOCK) WHERE jobId = @i_jobId AND StreamReaderId = @i_StreamReaderId
	SELECT @o_isMagnetic = CASE WHEN RecordingFormatId = 10001 THEN 1 ELSE 0 END FROM MMVolume WITH (NOLOCK) WHERE VolumeId = @volId
	IF @jobOpType = @AUXCOPY2 OR @jobOpType= @SYNTHFULL OR  @jobOpType= @MEDIAREFRESHING2
    BEGIN
  	    -- Decide soruce volume and source media agent and Drive pool
	    INSERT INTO @destCopyAndDP
	    SELECT DISTINCT stream.DestCopyId, dp.DataPathId, dp.HostClientId, dp.DrivePoolId, drivepool.DrivePoolType, ISNULL(ndmp.clientId, 0)
	    FROM	ArchJobStreamStatus stream WITH (NOLOCK)
			    INNER JOIN MMDataPath dp WITH (NOLOCK) ON stream.jobId = @i_jobId AND DestCopyId = dp.CopyId AND stream.StreamReaderId = @i_StreamReaderId AND stream.DestCopyId > 0
			    INNER JOIN MMDrivePool drivepool WITH (NOLOCK) on dp.DrivePoolId = drivepool.DrivePoolId
			    LEFT JOIN MMNDMPHostInfo ndmp WITH (NOLOCK) on drivepool.NDMPHostId > 0 AND drivepool.NDMPHostId = ndmp.NDMPHostId
			    INNER JOIN MMHost host WITH (NOLOCK) ON dp.HostClientId = host.ClientId
WHERE	dp.Flag & 4 = 4
AND		dp.Flag & 16 = 0
	    AND		host.MMHostSoftState > 0 AND host.MMHostEnabled > 0
	    -- Decide the destination media agent Id
	    -- If one destination copy, shoudld be based on data path configuration and current reservation status
	    -- If there are multiple copies, should check all the data path configuration and reservation, also whether using the same media agent for all copies.
	    SELECT @preferredDestCopyId = a.copyId
	    FROM (SELECT DISTINCT copyId FROM @destCopyAndDP) a
		    INNER JOIN ArchGroupCopy copy WITH (NOLOCK) ON a.copyId = copy.Id
		    LEFT JOIN archJobStreamStatus stream WITH (NOLOCK) ON stream.StreamReaderId = @i_StreamReaderId AND stream.JobId = @i_jobId AND a.copyId = DestCopyId
	    order by
		    -- Make sure current volume is needed for the destination copy
		    CASE WHEN ISNULL(stream.FirstVolumeId, 0) = @volId THEN 0 ELSE 1 END,
		    copy.copy,
		    a.CopyId
    END
    ELSE IF @jobOpType = @ARCHIVECHECK2 OR @jobOpType = @DEDUPDBSYNC_DASH
    BEGIN
        SET @preferredMediaAgentId = 0
        SET @preferredDestCopyId = 0
    END
	-- The first attempt doesn't consider destination media agent Id.
	-- Inside, load-balance or lan-free will be considered.
	delete from @getMAAndDPForVolumeResult
	insert into @getMAAndDPForVolumeResult
	exec mms2getmaanddpforvolume @volId, 0, 0 /*@preferredMediaAgentId*/, @preferredDestCopyId, @jobId, 1
	if not exists (select * from @getMAAndDPForVolumeResult where retCode = 0)
	begin
		select @o_ErrorCode = retCode, @o_FailureType = failureType, @o_RequestId = 0,
			@o_clientId = clientId, @o_mediaAgentName = mediaAgentName,
			@o_libraryId = libraryId, @o_libraryName = libraryName, @o_libraryAliasName = libraryAliasName,
			@o_barcode = barcode
		from @getMAAndDPForVolumeResult
		where retCode != 0
		INSERT INTO @tblStreamReservationError
		select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
				 @o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName,
				 @o_isMagnetic, @o_Barcode, @i_streamReaderId
		declare @now int
		set @now = dbo.GetUnixTime(GetUTCDate())
		DECLARE @currentMediaId int = 0
		SELECT @currentMediaId = MediaId FROM MMVolume WITH (NOLOCK) WHERE VolumeId = @volId
		-- If we cannot find media agent for current volume, wait for sometime for retry and allow other volumes continue.
        IF @jobOpType = @AUXCOPY2
        BEGIN
		    UPDATE	ArchChunkToReplicate
SET		Status = 3,
				    -- There is no need to add skip count in this case
				    --SkippedCount += 1,
				    SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
				    ErrorCode = @o_ErrorCode,
				    Modified = @now
		    FROM	archChunkToReplicate
		    WHERE	adminJobId = @i_jobId
		    AND		MediaId = @currentMediaId
AND		Status IN (0)
		    AND		SegmentId not in (select SegmentId from ArchJobStreamStatus with (nolock) where jobId = @i_jobId and segmentId > 0 and StreamReaderId != @i_StreamReaderId)
        END
		ELSE IF @jobOpType = @MEDIAREFRESHING2
        BEGIN
		    UPDATE	ArchChunkToReplicate
SET		Status = 3,
				    -- There is no need to add skip count in this case
				    --SkippedCount += 1,
				    SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
				    ErrorCode = @o_ErrorCode,
				    Modified = @now
		    FROM	archChunkToReplicate
		    WHERE	adminJobId = @i_jobId
		    AND		MediaId = @currentMediaId
AND		@o_ErrorCode = 273
AND		Status IN (0)
        END
        ELSE IF @jobOpType = @ARCHIVECHECK2
        BEGIN
		    UPDATE	ArchChunkToVerify2
SET		Status = 3,
				    -- There is no need to add skip count in this case
				    --SkippedCount += 1,
				    SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
				    ErrorCode = @o_ErrorCode,
				    Modified = @now
		    FROM	ArchChunkToVerify2
		    WHERE	adminJobId = @i_jobId
		    AND		MediaId = @currentMediaId
AND		Status IN (0)
		    AND		SegmentId not in (select SegmentId from ArchJobStreamStatus with (nolock) where jobId = @i_jobId and segmentId > 0 and StreamReaderId != @i_StreamReaderId)
        END
		ELSE IF @jobOpType = @SYNTHFULL
		BEGIN
		    UPDATE	ArchChunkToSF
SET		Status = 3,
				    -- There is no need to add skip count in this case
				    --SkippedCount += 1,
				    SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
				    ErrorCode = @o_ErrorCode,
				    Modified = @now
		    FROM	ArchChunkToSF
		    WHERE	adminJobId = @i_jobId
		    AND		MediaId = @currentMediaId
AND		Status IN (0)
		    AND		SegmentId not in (select SegmentId from ArchJobStreamStatus with (nolock) where jobId = @i_jobId and segmentId > 0 and StreamReaderId != @i_StreamReaderId)
		END
        ELSE IF @jobOpType = @DEDUPDBSYNC_DASH
        BEGIN
		    UPDATE	R
SET		Status = 3,
				    -- There is no need to add skip count in this case
				    --SkippedCount += 1,
				    SkippedForSeconds = (@SKIP_INTERVAL_ON_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
				    ErrorCode = @o_ErrorCode,
				    Modified = @now
		    FROM	ArchChunkToRecoverDDB R
		    WHERE	adminJobId = @i_jobId
		    AND		MediaId = @currentMediaId
AND		Status IN (0)
		    AND		SegmentId not in (select SegmentId from ArchJobStreamStatus with (nolock) where jobId = @i_jobId and segmentId > 0 and StreamReaderId != @i_StreamReaderId)
        END
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE jobId = @i_jobId AND StreamReaderId = @i_StreamReaderId
		goto exit_error
	end
	else
	begin
		select TOP 1 @o_ErrorCode = retCode, @o_FailureType = failureType, @o_RequestId = 0,
			@o_clientId = clientId, @o_mediaAgentName = mediaAgentName,
			@o_libraryId = libraryId, @o_libraryName = libraryName, @o_libraryAliasName = libraryAliasName,
			@o_barcode = barcode
		from @getMAAndDPForVolumeResult
		where retCode = 0
	end
	-- Refer code CVMMDBVolInfo::getMediaAgentByVolumeForAuxCopy from MediaManger code for picking media agent
	/*
	-- If the source MA is offline from
	IF @preferredDestCopyId > 0
	AND NOT EXISTS (SELECT DataPathId
				FROM @destCopyAndDP a, @getMAAndDPForVolumeResult result, MMHost host WITH (NOLOCK)
				WHERE	a.copyId = @preferredDestCopyId
				AND		(
							(a.ndmpClientId = 0 AND a.mediaAgentId = result.clientId)
							OR
							(a.ndmpClientId > 0 AND a.ndmpClientId = result.nasClientId)
						)
				AND		(a.mediaAgentId = host.ClientId OR a.ndmpClientId = host.ClientId)
				AND		host.MmHostSoftState = 1
				AND		host.MmHostEnabled = 1
			)
	BEGIN
		-- Pick a different destination media agent
		SELECT @preferredMediaAgentId = a.clientId
		FROM
			(
				SELECT DISTINCT host.ClientId clientId
				FROM @destCopyAndDP a, MMHost host WITH (NOLOCK)
				WHERE	copyId = @preferredDestCopyId
				AND		(a.mediaAgentId = host.ClientId OR a.ndmpClientId = host.ClientId)
				AND		host.MmHostSoftState = 1
				AND		host.MmHostEnabled = 1
			) a,
			MMVolume vol WITH (NOLOCK), MMMedia media WITH (NOLOCK), MMMasterPool mp WITH (NOLOCK), MMDrivePool dp WITH (NOLOCK), MMNDMPHostInfo ndmp WITH (NOLOCK)
		WHERE	vol.VolumeId = @volId
		AND		vol.MediaId = media.MediaId
		AND		media.LibraryId = mp.LibraryId
		AND		mp.MasterPoolId = dp.MasterPoolId
		AND		(dp.NDMPHostId = 0 OR dp.NDMPHostId = ndmp.NDMPHostId)
		AND		(
					(dp.NDMPHostId = 0 AND dp.ClientId = a.clientId)
					OR
					(dp.NDMPHostId > 0 AND dp.ClientId = ndmp.ClientId)
				)
		AND		a.clientId = dp.clientId
		IF @preferredMediaAgentId > 0
		AND	NOT EXISTS (SELECT * FROM @getMAAndDPForVolumeResult WHERE @preferredMediaAgentId = clientId OR @preferredMediaAgentId = nasClientId)
		BEGIN
			DELETE FROM @getMAAndDPForVolumeResult
		END
		insert into @getMAAndDPForVolumeResult
		exec mms2getmaanddpforvolume @volId, 0, @preferredMediaAgentId, @preferredDestCopyId, @jobId, 1
		if not exists (select * from @getMAAndDPForVolumeResult where retCode = 0)
		begin
			select @o_ErrorCode = retCode, @o_FailureType = failureType, @o_RequestId = 0,
				@o_clientId = clientId, @o_mediaAgentName = mediaAgentName,
				@o_libraryId = libraryId, @o_libraryName = libraryName, @o_libraryAliasName = libraryAliasName,
				@o_barcode = barcode
			from @getMAAndDPForVolumeResult
			where retCode != 0
			INSERT INTO @tblStreamReservationError
			select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
					 @o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName,
					 @o_isMagnetic, @o_Barcode, @i_streamReaderId
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE jobId = @i_jobId AND StreamReaderId = @i_StreamReaderId
			goto exit_error
		end
		else
		begin
			select TOP 1 @o_ErrorCode = retCode, @o_FailureType = failureType, @o_RequestId = 0,
				@o_clientId = clientId, @o_mediaAgentName = mediaAgentName,
				@o_libraryId = libraryId, @o_libraryName = libraryName, @o_libraryAliasName = libraryAliasName,
				@o_barcode = barcode
			from @getMAAndDPForVolumeResult
			where retCode = 0
		end
	END
	*/
	-- Now we know which media agent and drive pool to use for the source volume
	SELECT	TOP 1 @DrvPoolId = drivePoolId,
			@mediaAgentId = clientId,
			@mediaAgentName = mediaAgentName
	FROM	@getMAAndDPForVolumeResult
	WHERE	retCode = 0
	UPDATE ArchJobStreamStatus
	SET		SrcMAId = @mediaAgentId,
			SrcDrivePoolId = @DrvPoolId
	WHERE	StreamReaderId = @i_StreamReaderId
	AND		JobId = @i_jobId
	--AND		FirstVolumeId = @volId
  END
  -- Write part variables
  DECLARE @appNum			int
  DECLARE @appType			int
  DECLARE @dataType			int
  DECLARE @maxMXCount			int
  DECLARE @numStreams			int
  DECLARE @bkpLevel			int
  DECLARE @markActiveMediaFull			int
  DECLARE @forceMarkActiveMediaFull	int
  DECLARE @extraRestoreDrive			int
  DECLARE @extraRestoreDrivePoolId		int
  DECLARE @phaseFirstAttemptTime		bigint
  DECLARE @markMediaFullOnSuccess		int
  DECLARE @failIfSecondaryCopyError	int
  DECLARE @multiCopyReserve			int
  DECLARE @isForRemainingStreams		int
  DECLARE @doNotAllowOtherSchedule		int
  DECLARE @singleStream				int
  DECLARE @dataMultiStream			int
  DECLARE @maxDataMultiStream		int
  DECLARE @preferredDrivePoolId		int
  DECLARE @inClientId				int
  DECLARE @currentSIDBStoreId		int
  DECLARE @xmlCopyInfoList			int
  SET @markActiveMediaFull = 0
SET @markActiveMediaFull = cast(dbo.GetJobOption(@jobId, 1254818451) as int)
  SET @failIfSecondaryCopyError = 0
SET @failIfSecondaryCopyError = cast(dbo.GetJobOption(@jobId, 1936975364) as int)
  SET @markMediaFullOnSuccess = 0
SET @markMediaFullOnSuccess = cast(dbo.GetJobOption(@jobId, 2041323881) as int)
  -- Refer to structure RmAllocateStreamArgs_t for more info
  DECLARE @RmDestinationArgs TABLE (
	StreamReaderId	int,
	commCellId		int,
	jobId			bigint,
	jobType			int,
	jobOpType		int,
	archGroupId		int,
	copyId			int,
	priority		int,
	preEmptable		int,
	scheduleRunId	int,
	appNum			int,
	appType			int,
	dataType		int,
	bkpLevel		int,
	maxMXCount		int,
	numStreams		int,
	singleStream	int,
	siloCopyId					int,
	preferredMediaAgentId		int,
	preferredDrivePoolId		int,
	currentSIDBStoreId			int,
	bestcaseReserve				int,
	markActiveMediaFull			int,
	forceMarkActiveMediaFull	int,
	extraRestoreDrive			int,
	extraRestoreDrivePoolId		int,
	phaseFirstAttemptTime		bigint,
	markMediaFullOnSuccess		int,
	failIfSecondaryCopyError	int,
	multiCopyReserve			int,
	isForRemainingStreams		int,
	doNotAllowOtherSchedule		int,
	primary key (commCellId, jobId, CopyId, StreamReaderId)
  )
  DELETE FROM @RmDestinationArgs
  INSERT INTO @RmDestinationArgs (
	StreamReaderId,
	commCellId, jobId, jobType, jobOpType,
	archGroupId, copyId,
	priority, preEmptable, scheduleRunId,
	appNum, appType, dataType, bkpLevel,
	maxMXCount, numStreams, singleStream,
	siloCopyId, preferredMediaAgentId, preferredDrivePoolId, currentSIDBStoreId,
	bestcaseReserve,
	markActiveMediaFull,
	forceMarkActiveMediaFull,
	extraRestoreDrive,
	extraRestoreDrivePoolId,
	phaseFirstAttemptTime,
	markMediaFullOnSuccess,
	failIfSecondaryCopyError,
	multiCopyReserve,
	isForRemainingStreams,
	doNotAllowOtherSchedule
  )
  SELECT	StreamReaderId,
		@commCellId, jobId, @jobType, @jobOpType,
		@archGroupId, DestCopyId,
		@priority, @preEmptable, @scheduleRunId,
		0, 0, 0, 0,
		(SELECT MaxMultiplex FROM ArchGroupCopy WITH (NOLOCK) WHERE Id = DestCopyId), 1, DestStreamNum,
		0, SrcMAId, SrcDrivePoolId, destSIDBStoreId,
		1,
		@markActiveMediaFull,
		0,
		0,
		0,
		0,
		@markMediaFullOnSuccess,
		@failIfSecondaryCopyError,
		0,
		0,
		0
  FROM	ArchJobStreamStatus WITH (NOLOCK)
  WHERE
	StreamReaderId = @i_StreamReaderId
	AND JobId = @i_jobId
	AND DestCopyId > 0
	AND Status = 0 /*NOT RESERVED, NOT INITIALIZED*/
  UPDATE @RmDestinationArgs SET multiCopyReserve = 1
  WHERE StreamReaderId IN (SELECT StreamReaderId FROM @RmDestinationArgs GROUP BY StreamReaderId HAVING COUNT(*) > 1)
  -- If there is no destination information for the given streamreader, only do read reservation
  IF NOT EXISTS (SELECT * FROM @RmDestinationArgs)
  OR (@segmentId > 0 AND @isForSnapCopyData = 1 AND @jobOpType = @AUXCOPY2)
  OR (@jobType = @ARCHCHECKJOB AND @jobOpType = @ARCHIVECHECK2 AND @jobPhase IN (@dedupeValidate, @orphanListing, @defragment))
  BEGIN
	  -- For Snap copy data
	  IF (@segmentId > 0 AND @isForSnapCopyData = 1 AND @jobOpType = @AUXCOPY2)
	  BEGIN
		SET @sourceArgsXml =
			(
				SELECT	@volId volId,
						@DrvPoolId	DrvPoolId,
						@mediaAgentName mediaAgentName,
						@mediaId mediaId,
						@MediaGrpId MediaGrpId,
						@jobId jobId,
						@jobOpType jobOpType,
						@priority priority,
						@preEmptable preEmptable,
						@bestcaseReserve bestcaseReserve,
						@reservationType rtype,
						--@checkConcurrency checkConcurrency,
						--@reservisDummyReservationType reservisDummyReservationType,
						@destinationMediaGroupId destinationMediaGroupId,
						@copyId copyId,
						@resBitMask resBitMask
				for XML RAW('ResourceManager_RmReserveVolAndDriveArgs_t'), TYPE
			)
		SET @reservationRequestXml = @sourceArgsXml
SET @requestCategory	= 8
	  END
	  -- if there is only source side info, do read reservation anyway
	  ELSE IF @i_streamReaderId > 0
	  AND @volId > 0 AND @copyId > 0 AND @DrvPoolId > 0 AND @mediaAgentId > 0
	  --AND EXISTS (SELECT VolumeId FROM MMVolume WITH (NOLOCK) WHERE VolumeId = @volId AND RecordingFormatId != 10001)
	  BEGIN
		SET @sourceArgsXml =
			(
				SELECT	@volId volId,
						@DrvPoolId	DrvPoolId,
						@mediaAgentName mediaAgentName,
						@mediaId mediaId,
						@MediaGrpId MediaGrpId,
						@jobId jobId,
						@jobOpType jobOpType,
						@priority priority,
						@preEmptable preEmptable,
						@bestcaseReserve bestcaseReserve,
						@reservationType rtype,
						--@checkConcurrency checkConcurrency,
						--@reservisDummyReservationType reservisDummyReservationType,
						@destinationMediaGroupId destinationMediaGroupId,
						@copyId copyId,
						@resBitMask resBitMask
				for XML RAW('ResourceManager_RmReserveVolAndDriveArgs_t'), TYPE
			)
		SET @reservationRequestXml = @sourceArgsXml
SET @requestCategory	= 8
	  END
	  -- Vol is 0
	  ELSE IF (@jobType = @ARCHCHECKJOB AND @jobOpType = @ARCHIVECHECK2 AND @jobPhase IN (@dedupeValidate, @orphanListing, @defragment))
	  BEGIN
		SET @sourceArgsXml =
			(
				SELECT	0 volId,
						0	DrvPoolId,
						@mediaAgentName mediaAgentName,
						0 mediaId,
						0 MediaGrpId,
						@jobId jobId,
						@jobOpType jobOpType,
						@priority priority,
						@preEmptable preEmptable,
						0 bestcaseReserve,
						@reservationType rtype,
						--@checkConcurrency checkConcurrency,
						--@reservisDummyReservationType reservisDummyReservationType,
						@destinationMediaGroupId destinationMediaGroupId,
						@copyId copyId,
						@resBitMask resBitMask
				for XML RAW('ResourceManager_RmReserveVolAndDriveArgs_t'), TYPE
			)
		SET @reservationRequestXml = @sourceArgsXml
SET @requestCategory	= 8
	  END
	  ELSE
	  BEGIN
		SET @sourceArgsXml = ''
	  END
  END
  ELSE IF @i_streamReaderId > 0
  BEGIN
		-- If current volume is a tape and there is destination info, need to create both source and destination reservations
		IF @volId > 0 AND EXISTS (SELECT VolumeId FROM MMVolume WITH (NOLOCK) WHERE VolumeId = @volId AND RecordingFormatId != 10001)
		AND @copyId > 0 AND @DrvPoolId > 0 AND @mediaAgentId > 0
		BEGIN
			SET @sourceArgsXml =
				(
					SELECT	@volId volId,
							@DrvPoolId	DrvPoolId,
							@mediaAgentName mediaAgentName,
							@mediaId mediaId,
							@MediaGrpId MediaGrpId,
							@jobId jobId,
							@jobOpType jobOpType,
							@priority priority,
							@preEmptable preEmptable,
							@bestcaseReserve bestcaseReserve,
							@reservationType rtype,
							--@checkConcurrency checkConcurrency,
							--@reservisDummyReservationType reservisDummyReservationType,
							@destinationMediaGroupId destinationMediaGroupId,
							@copyId copyId,
							@resBitMask resBitMask
					for XML RAW('sourceArgs'), TYPE
				)
		END
		ELSE
		BEGIN
			SET @sourceArgsXml = ''
		END
  		SELECT @isMultipleCopies = COUNT(DISTINCT copyId) FROM @RmDestinationArgs WHERE StreamReaderId = @i_streamReaderId
		IF @isMultipleCopies > 1
		BEGIN
			SET @copyList =
			(
				SELECT	DISTINCT copyId copyId,
						singleStream	streamNum,
						preferredDrivePoolId preferredDrivePoolId,
						maxMXCount maxMXCount
				FROM	@RmDestinationArgs
				WHERE	StreamReaderId = @i_StreamReaderId
				for XML RAW('copyInfoList'), TYPE
			)
			SET @destinationArgsXml =
				(
					SELECT	--appNum,
							--dataType,
							@archGroupId agroupNumber,
							0 copyId,
							0 maxMXCount,
							@commCellId commCellId,
							@jobId jobId,
							1 numStreams,
							@bestcaseReserve bestcaseReserve,
							@markActiveMediaFull markActiveMediaFull,
							--forcedMarkActiveMediaFull,
							@priority priority,
							@preEmptable preEmptable,
							--extraRestoreDrive,
							--extraRestoreDrivePoolId,
							0 singleStream,
							--checkConcurrency,
							@jobType jobType,
							--bkpLevel,
							--appType,
							--phaseFirstAttemptTime,
							@markMediaFullOnSuccess markMediaFullOnSuccess,
							1 dataMultiStream,
							--maxDataMultiStream,
							@isMultipleCopies multiCopyReserve,
							@failIfSecondaryCopyError failIfSecondaryCopyError,
							0 preferredDrivePoolId,
							0 isForRemainingStreams,
							--clientTokenId,
							@mediaAgentId inClientId,
							@scheduleRunId scheduleRunId,
							0 doNotAllowOtherSchedule --,
							--doPrelimReserveCheck,
							--currentSIDBStoreId,
					for XML RAW('destinationArgs'), TYPE
				)
			SET @destinationArgsXml = REPLACE(CAST(@destinationArgsXml AS VARCHAR(MAX)), '/>', '>' + CAST(@copyList AS VARCHAR(MAX)) + '</destinationArgs>')
		END
		-- This is not a parallel copy reservation
		ELSE
		BEGIN
			SET @destinationArgsXml =
				(
					SELECT	TOP 1
							--appNum,
							--dataType,
							@archGroupId agroupNumber,
							copyId copyId,
							maxMXCount maxMXCount,
							@commCellId commCellId,
							@jobId jobId,
							1 numStreams,
							@bestcaseReserve bestcaseReserve,
							@markActiveMediaFull markActiveMediaFull,
							--forcedMarkActiveMediaFull,
							@priority priority,
							@preEmptable preEmptable,
							--extraRestoreDrive,
							--extraRestoreDrivePoolId,
							singleStream singleStream,
							--checkConcurrency,
							@jobType jobType,
							--bkpLevel,
							--appType,
							--phaseFirstAttemptTime,
							@markMediaFullOnSuccess markMediaFullOnSuccess,
							1 dataMultiStream,
							--maxDataMultiStream,
							@isMultipleCopies multiCopyReserve,
							@failIfSecondaryCopyError failIfSecondaryCopyError,
							preferredDrivePoolId preferredDrivePoolId,
							0 isForRemainingStreams,
							--clientTokenId,
							@mediaAgentId inClientId,
							@scheduleRunId scheduleRunId,
							0 doNotAllowOtherSchedule --,
							--doPrelimReserveCheck,
							--currentSIDBStoreId,
					FROM	@RmDestinationArgs
					WHERE	StreamReaderId = @i_StreamReaderId
					for XML RAW('destinationArgs'), TYPE
				)
		END
		SET @reservationRequestXml = '<ResourceManager_RmAuxcopyReservationArgs_t>' + CAST(@sourceArgsXml AS VARCHAR(MAX)) + CAST(@destinationArgsXml AS VARCHAR(MAX)) + '</ResourceManager_RmAuxcopyReservationArgs_t>'
SET @requestCategory	= 8
  END
  SET @o_ErrorCode	= 0
  SET @o_FailureType = 0
  SET @o_RequestId	= 0
  DECLARE @tblRequestId TABLE (requestId int)
  DECLARE @tmpXml varchar(max)
  SET @tmpXml = CAST(@reservationRequestXml as VARCHAR(MAX))
  IF LEN(@tmpXml) > 0
  BEGIN
	INSERT INTO RMReservationRequest
	(
		ErrorCode, FailureType, RequestTime, FailureAttempts, ShouldFailRequest, MaxNumOfAttempts, MaxNumOfReservedStreams,
		JobId, CommCellId, ScheduleRunId,
		UseSCDataPath,
		JobType, JobOpType, iDAType,
		PhaseFirstAttemptTime, CopyId, Priority, RequestCategory,
		RegistrySetting,
		XmlParams,
		ReservationResults
	)
	VALUES
	(
		-1, -1, dbo.GetUnixTime(getutcdate()), 0, -1, 1, -1,
		@jobId, @commCellId, @scheduleRunId,
		0,
		@jobType, @jobOpType, 0,
		0, 0, @Priority, @RequestCategory,
		@i_registrySetting,
		@tmpXml,
			''
	)
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
set @o_FailureType = 2
  		SELECT @o_RequestId = 0, @o_CopyId = 0, @o_StreamNum = 0,
				@o_clientId = 0, @o_mediaAgentName = '',
				@o_libraryId = 0, @o_libraryName = '', @o_libraryAliasName = '',
				@o_barcode = ''
		INSERT INTO @tblStreamReservationError
		select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
				 @o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName,
				 @o_isMagnetic, @o_Barcode, @i_streamReaderId
		goto exit_error
	end
	SELECT @o_RequestId = @@identity
  END
  -- Successfully created reservation request at this point
  IF @o_RequestId > 0
  BEGIN
	IF EXISTS (SELECT 1 FROM ArchJobStreamStatus WHERE StreamReaderId = @i_StreamReaderId AND JobId = @i_jobId)
	BEGIN
		UPDATE ArchJobStreamStatus
		SET ReservationRequestId = @o_RequestId
		WHERE	StreamReaderId = @i_StreamReaderId
		AND		JobId = @i_jobId
set @o_ErrorCode = 0
set @o_FailureType = 1
		INSERT INTO @tblStreamReservationError
		select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
					@o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName,
					@o_isMagnetic, @o_Barcode, @i_streamReaderId
	END
	ELSE
	BEGIN
		-- For some reason the entry is gone (may be due to timeout), don't return error.
		-- It should be auto recovered later
		DELETE FROM RMReservationRequest WHERE RequestId = @o_RequestId
	END
  END
exit_error:
  -- If there is still other StreamReader need to be processed, do a
  IF EXISTS (SELECT * FROM  @tblStreamReaderList WHERE StreamReaderId != @i_streamReaderId)
  BEGIN
		SET @o_ErrorCode	= 0
		SET @o_FailureType = 0
		SET @o_RequestId	= 0
		GOTO PICK_NEXT_STREAMREADER
  END
  ELSE
  BEGIN
	-- Remove all the stream readers that don't have reservation reqeust created
	DELETE	ArchJobStreamStatus
	WHERE	JobId = @i_jobId
	AND		Status = 0 /*NOT RESERVED, NOT INITIALIZED*/
	AND		ReservationRequestId = 0
	-- There is at least one successful reservation request, return no error
	IF EXISTS (SELECT * FROM @tblStreamReservationError WHERE ErrorCode = 0 AND StreamReaderId > 0 AND RequestId > 0)
	BEGIN
SET @o_ErrorCode	= 0
SET @o_FailureType	= 1
		SET @o_RequestId	= 0
	END
	ELSE
	BEGIN
SELECT TOP 1 @o_ErrorCode =  ErrorCode,  @o_FailureType	= 1
		FROM @tblStreamReservationError
		WHERE  ErrorCode = 0
		ORDER BY StreamReaderId
	END
  END
  IF @i_jobId > 0 AND NOT EXISTS (SELECT JobId FROM RMJobControl WHERE JobId = @i_jobId)
  BEGIN
	INSERT INTO RMJobControl
	(
		JobId, CommCellId, ErrorCode, FailureType, RequestTime, FailureAttempts,
		Priority, NoOfReservedStreams, Status, FailureReason
	)
	VALUES
	(
		@i_jobId, @commCellId, -1, -1, dbo.GetUnixTime(getutcdate()), 0,
@priority, 0, 1, ''
	)
  END
  ELSE IF EXISTS (SELECT JobId FROM RMJobControl WHERE JobId = @i_jobId)
  BEGIN
	DECLARE @isJobRunning INT = 1
	EXEC 	RMIsJobOnRunningState @i_JobId, @commCellId, @isJobRunning output
	UPDATE RMJobControl
SET Status = 1,
		ErrorCode = -1,
		FailureType = -1,
		FailureReason = '',
		RequestTime = dbo.GetUnixTime(getutcdate())
	WHERE	JobId = @i_jobId
AND		(@isJobRunning != 0 OR Status != 4)
  END
  SELECT * FROM @tblStreamReservationError
  /*
	select @o_ErrorCode, @o_FailureType, @o_RequestId, @o_CopyId, @o_StreamNum,
				@o_ClientId, @o_MediaAgentName, @o_LibraryId, @o_LibraryName, @o_LibraryAliasName, @o_isMagnetic, @o_Barcode
  */
 return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMSubmitReservationRequests')
	delete from GxQscripts where name = 'RMSubmitReservationRequests'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMSubmitReservationRequests')
	delete from GXDBVersions where aliasname = 'RMSubmitReservationRequests'
GO

insert into GXDBVersions values(2, 'RMSubmitReservationRequests',  '00010015000200130000', 'RMSubmitReservationRequests', '00010015000200130000')
GO

