

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMSubmitLSDriveRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMSubmitLSDriveRequest.sp,v $ $Id: RMSubmitLSDriveRequest.sp,v 1.6.208.1 2017/02/10 21:53:35 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMSubmitLSDriveRequest <<<'

IF EXISTS (select * from sysobjects where name='RMSubmitLSDriveRequest')
	drop procedure RMSubmitLSDriveRequest
IF EXISTS (select * from GxQscripts where name='RMSubmitLSDriveRequest')
	delete from GxQscripts where name = 'RMSubmitLSDriveRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMSubmitLSDriveRequest')
	delete from GXDBVersions where aliasname = 'RMSubmitLSDriveRequest'
GO
print '... Creating Procedure: RMSubmitLSDriveRequest'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMSubmitLSDriveRequest
  @i_dummy integer
AS
/*
-- This temp table should be created and populated from caller
if object_id('tempdb.dbo.#tmpLibServerDriveReq') is not null DROP TABLE #tmpLibServerDriveReq
CREATE TABLE #tmpLibServerDriveReq (
	RMRequestId		INT,
	jobId 				INT,
	commCellId 		INT,
	libraryId			INT,
	driveNumber 	VARCHAR(MAX),
	driveCnt			INT,
	PRIMARY KEY (RMRequestId, jobId, commCellId, libraryId, preferredDriveList)
)
*/
	DECLARE @errorCode 	INTEGER
	SET			@errorCode	= 0
	IF EXISTS (	SELECT requestId
							FROM MMSharedDriveAllocation SDA WITH (NOLOCK), #tmpLibServerDriveReq TMP
							WHERE SDA.RMRequestId = TMP.RMRequestId
							AND		SDA.jobId = TMP.jobId
							AND 	SDA.commCellId = TMP.commCellId
							AND		SDA.libraryId = TMP.libraryId
							AND		SDA.preferredDriveList = TMP.driveNumber
							AND		SDA.drivesRequested > 0
AND		SDA.requestStatus IN (1, 4))
	BEGIN
		--Submit new request only for any additional drives
		UPDATE #tmpLibServerDriveReq
		SET driveCnt = driveCnt - SDA.drivesRequested
		FROM #tmpLibServerDriveReq TMP, (SELECT RMRequestId, jobId, commCellId, libraryId, preferredDriveList, SUM(drivesRequested) AS drivesRequested
										 FROM MMSharedDriveAllocation WITH (NOLOCK)
										 WHERE  drivesRequested > 0
AND	requestStatus IN (1, 4)
										 GROUP BY RMRequestId, jobId, commCellId, libraryId, preferredDriveList) AS SDA
		WHERE SDA.RMRequestId = TMP.RMRequestId
		AND		SDA.jobId = TMP.jobId
		AND 	SDA.commCellId = TMP.commCellId
		AND		SDA.libraryId = TMP.libraryId
		AND		SDA.preferredDriveList = TMP.driveNumber
		AND		TMP.driveCnt > 0
		SET @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO CX_EXIT
		UPDATE MMSharedDriveAllocation
		SET lastReadyTime = dbo.GetUnixTime(GETUTCDATE())
		FROM MMSharedDriveAllocation SDA, #tmpLibServerDriveReq TMP
		WHERE SDA.RMRequestId = TMP.RMRequestId
		AND		SDA.jobId = TMP.jobId
		AND 	SDA.commCellId = TMP.commCellId
		AND		SDA.libraryId = TMP.libraryId
		AND		SDA.preferredDriveList = TMP.driveNumber
AND		SDA.requestStatus IN (1, 4)
		SET @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO CX_EXIT
	END
	--Submit new request for required drives
	INSERT INTO MMSharedDriveAllocation (RMRequestId, jobId, commCellId, priority, libraryId, drivesRequested, preferredDriveList, requestStatus, failureReason, flags, jobStartTime, lastReadyTime, requestTime, lastModifiedTime)
SELECT DISTINCT TMP.RMRequestId, TMP.jobId, TMP.commCellId, JM.combPriority, TMP.libraryId, TMP.driveCnt, ISNULL(TMP.driveNumber, ''), 1, 0, 0, JM.jobStartTime, dbo.GetUnixTime(GETUTCDATE()), dbo.GetUnixTime(GETUTCDATE()), 0
	FROM #tmpLibServerDriveReq TMP, JMJobInfo JM WITH (NOLOCK)
	WHERE TMP.jobId = JM.jobId
	AND		TMP.commCellId = JM.commCellId
	AND		TMP.driveCnt > 0
	SET @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO CX_EXIT
CX_EXIT:
	-- SELECT @errorCode
	RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMSubmitLSDriveRequest')
	delete from GxQscripts where name = 'RMSubmitLSDriveRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMSubmitLSDriveRequest')
	delete from GXDBVersions where aliasname = 'RMSubmitLSDriveRequest'
GO

insert into GXDBVersions values(2, 'RMSubmitLSDriveRequest',  '00010006020800010000', 'RMSubmitLSDriveRequest', '00010006020800010000')
GO

