

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMSubmitExchangeVolumeByDDB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMSubmitExchangeVolumeByDDB.sp,v $ $Id: RMSubmitExchangeVolumeByDDB.sp,v 1.1.2.2 2020/04/20 17:01:13 pnara Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMSubmitExchangeVolumeByDDB
--  +========================================================================+
--
--	This stored procedure is used for exchanging volume by DDB.
--	It checks if existing reservation volume DDB and the new DDB, if they are same then nothing will be done
--	If different then submits RM request to exchange volume.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMSubmitExchangeVolumeByDDB')
BEGIN
	print '>>> Drop Stored Procedure: RMSubmitExchangeVolumeByDDB <<<'
	drop procedure RMSubmitExchangeVolumeByDDB
END
IF EXISTS (select * from GxQscripts where name='RMSubmitExchangeVolumeByDDB')
	delete from GxQscripts where name = 'RMSubmitExchangeVolumeByDDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMSubmitExchangeVolumeByDDB')
	delete from GXDBVersions where aliasname = 'RMSubmitExchangeVolumeByDDB'
GO
print '... Creating Procedure: RMSubmitExchangeVolumeByDDB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMSubmitExchangeVolumeByDDB
  @i_jobId int,
  @i_RCId int,
  @i_appId int,
  @i_registrySetting varchar(max)
AS
  DECLARE @o_errorCode integer;
  DECLARE @o_exchanged integer;
  DECLARE @o_jobId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @o_errorCode = 0
	set @o_exchanged = 0
	--Return if skip param is set
	IF EXISTS(SELECT 1 FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'SkipExchangeVolumeByDDB' AND modified = 0 AND value = 'true')
		goto exit_error
	DECLARE @reservationId	int = 0
	DECLARE @copyId			int = 0
	DECLARE @volumeId			int = 0
	DECLARE @streamSIDBStoreId int = 0
	DECLARE @appSIDBStoreId 	int = 0
	SELECT	@o_jobId = RJ.jobId_l,
			@reservationId = R.ReservationId,
			@copyId	= R.copyId,
			@volumeId = R.volumeId,
			@streamSIDBStoreId = V.SIDBStoreId
	FROM	MMResourceToJob RJ WITH(READUNCOMMITTED),
			MMResource R WITH(READUNCOMMITTED),
			MMVolume V WITH(READUNCOMMITTED)
	WHERE	RJ.RCId = @i_RCId
			AND RJ.ReservationId = R.ReservationId
			AND R.VolumeId = V.VolumeId
	--Non dedupe no exchange is needed
	IF @streamSIDBStoreId = 0
		goto exit_error
	SELECT	@appSIDBStoreId = SIDBStoreId
	FROM	archSubclientCopyDDBMap WITH(READUNCOMMITTED)
	WHERE	appId = @i_appId AND copyId = @copyId
	--Add mapping if missing
	if @appSIDBStoreId = 0
	begin
		IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL DROP TABLE #lt_archCreateCopySubClientDDBMApOutput
		CREATE TABLE #lt_archCreateCopySubClientDDBMApOutput (xmlOutput XML)
		IF object_id('tempdb.dbo.#inputApps') is not null DROP TABLE #inputApps
			CREATE TABLE #inputApps -- only populate appID and copyID if this table is being created in the caller
			(
				appId	 INT,
				copyId	 INT,
				appTypeId	INT,
				instanceId	INT,
				clientId  INT,
				clientstatus INT,
				releaseId INT,
				servicePack INT
			)
		INSERT INTO #inputApps(appId, copyId)
		SELECT @i_appId, @copyId
		exec archCreateCopySubClientDDBMAp ''
		IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL DROP TABLE #lt_archCreateCopySubClientDDBMApOutput
		SELECT	@appSIDBStoreId = SIDBStoreId
		FROM	archSubclientCopyDDBMap WITH(READUNCOMMITTED)
		WHERE	appId = @i_appId AND copyId = @copyId
		--
		-- Fail the job if mapping is missing
		--
		IF @appSIDBStoreId = 0
		BEGIN
set @o_errorCode = 485
			goto exit_error
		END
	end
	--App and Stream DDB are same then no exchange is needed
	IF @appSIDBStoreId = @streamSIDBStoreId
		goto exit_error
	--
	-- Submit exchange reservation request
	--
	DECLARE @requestId int = 0
	DECLARE @reservationRequestXml	XML = ''
	DECLARE @commCellId       int = 0
	DECLARE @jobType          int = dbo.GetJobTypeForJobID(@o_jobId)
	DECLARE @jobOpType        int = 0
	DECLARE @priority         int = 0
	DECLARE @scheduleRunId    int = 0
	SELECT	@commCellId = commCellId,
			@jobOpType = opType,
			@priority = combPriority
    FROM  	JMJobInfo WITH (NOLOCK)
	WHERE	jobId = @o_jobId
	SELECT 	@scheduleRunId = jobRequestId
	FROM	TM_Jobs WITH (NOLOCK)
	WHERE	JobId = @o_jobId
  	SET @reservationRequestXml =
	(
		SELECT	@volumeId oldVolumeId,
				@reservationId	reservationId,
42047 volumeFullReason,
				@appSIDBStoreId newSIDBStoreId,
				0 startNewMedia,
				0 doNotAllowOtherSchedule
		for XML RAW('ResourceManager_RmExchangeVolumeArgs_t'), TYPE
	)
	INSERT INTO RMReservationRequest
	(
		ErrorCode, FailureType, RequestTime, FailureAttempts, ShouldFailRequest, MaxNumOfAttempts, MaxNumOfReservedStreams,
		JobId, CommCellId, ScheduleRunId, UseSCDataPath,
		JobType, JobOpType, iDAType, PhaseFirstAttemptTime, CopyId,
		Priority, RequestCategory, RegistrySetting, XmlParams, ReservationResults
	)
	VALUES
	(
		-1, -1, dbo.GetUnixTime(getutcdate()), 0, -1, 1, -1,
		@o_jobId, @commCellId, @scheduleRunId, 0,
		@jobType, @jobOpType, 0, 0, 0,
@Priority, 5, @i_registrySetting, CAST(@reservationRequestXml as varchar(max)), ''
	)
	if @@ERROR > 0
	begin
set @o_errorCode = 415
		goto exit_error
	end
	SELECT @requestId = scope_identity()
	--
	-- Successfully created reservation request at this point
	-- Wait for request to get processed
	-- Check request status every 500 milliseconds
	--
	DECLARE @startTime datetime = getdate()
	IF OBJECT_ID('tempdb..#lt_RMQueryReservationRequestOutput') IS NOT NULL DROP TABLE #lt_RMQueryReservationRequestOutput
		CREATE TABLE #lt_RMQueryReservationRequestOutput (ErrorCode int, FailureType int, ReservationResults nvarchar(max))
	WHILE (1 > 0)
	BEGIN
		WAITFOR DELAY '00:00:00.500'
		INSERT INTO #lt_RMQueryReservationRequestOutput
		EXEC RMQueryReservationRequest @requestId
		SELECT 	@o_errorCode = ErrorCode
		FROM	#lt_RMQueryReservationRequestOutput
		IF @o_errorCode >= 0 --success or failure
			BREAK
IF DATEDIFF(mi, @startTime, getdate()) > 2
		BEGIN
SET @o_errorCode = 2002
			BREAK
		END
		TRUNCATE TABLE #lt_RMQueryReservationRequestOutput
	END
	IF OBJECT_ID('tempdb..#lt_RMQueryReservationRequestOutput') IS NOT NULL DROP TABLE #lt_RMQueryReservationRequestOutput
IF @o_errorCode = 0
		SET @o_exchanged = 1
exit_error:
select @o_errorCode, @o_exchanged, @o_jobId
return @o_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMSubmitExchangeVolumeByDDB')
	delete from GxQscripts where name = 'RMSubmitExchangeVolumeByDDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMSubmitExchangeVolumeByDDB')
	delete from GXDBVersions where aliasname = 'RMSubmitExchangeVolumeByDDB'
GO

insert into GXDBVersions values(2, 'RMSubmitExchangeVolumeByDDB',  '00010001000200020000', 'RMSubmitExchangeVolumeByDDB', '00010001000200020000')
GO

