

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMRestoreCachingReserve.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMRestoreCachingReserve.sp,v $ $Id: RMRestoreCachingReserve.sp,v 1.6.12.3 2018/03/20 20:02:10 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMRestoreCachingReserve()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMRestoreCachingReserve <<<'

IF EXISTS (select * from sysobjects where name='RMRestoreCachingReserve')
	drop procedure RMRestoreCachingReserve
IF EXISTS (select * from GxQscripts where name='RMRestoreCachingReserve')
	delete from GxQscripts where name = 'RMRestoreCachingReserve'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMRestoreCachingReserve')
	delete from GXDBVersions where aliasname = 'RMRestoreCachingReserve'
GO
print '... Creating Procedure: RMRestoreCachingReserve'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMRestoreCachingReserve
  @i_volumeid int,
  @i_drivepoolid int,
  @i_jobid_l int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_reservationid integer;
  DECLARE @o_driveid integer;
  DECLARE @o_rcid integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @o_ErrorCode = 0
set @o_reservationid = 0
set @o_driveid = 0
set @o_rcid = 0
declare @reservationid integer
declare @drivepoolid integer
declare @driveid integer
declare @rcid integer
declare @mediaid integer
declare @mediagroupid integer
declare @recordingformatid integer
if @i_volumeid = 0 or @i_drivepoolid = 0 or @i_jobid_l = 0
begin
set @o_ErrorCode = 103
  goto exit_done
end
select @mediaid = mediaid, @mediagroupid = mediagroupid, @recordingformatid = recordingformatid
from mmvolume where volumeid = @i_volumeid
if @mediaid is null or @mediaid = 0
begin
set @o_ErrorCode = 401
end
if @recordingformatid = 10001
begin
set @o_ErrorCode = 30006
  goto exit_done
end
-----------------------------------------------
-- only run this code for non magnetic media --
-----------------------------------------------
-- check media
set @reservationid = isnull((select top 1 reservationid from mmresourcetojob
							 where  jobid_l = @i_jobid_l and inuse = 0 and reservationtype = 1 and releasetime != 0
							and reservationid in (select reservationid from mmresource
							 where volumeid = @i_volumeid)), 0)
if @reservationid > 0
begin
  -- voluem is cached reserved for the job, check drive
  select @drivepoolid = drivepoolid, @driveid = driveid
  from mmresource
  where reservationid = @reservationid
  -- check drive pool and drive
  if not exists (
					select * from mmdrivecontroller
					where driveid = @driveid and drivepoolid = @i_drivepoolid
					and drivecontrollersoftstate = 1
					and drivecontrollerenabled = 1
					and driveaccessible = 1
				)
  begin
	-- drive the volume is reserved with cannot be accessed via drive pool passed in
	-- zero out the volume id for the reservation and continue
	update mmresource
	set volumeid = 0, mediaid = 0, mediagroupid = 0
	where reservationid = @reservationid
	set @reservationid = 0
	goto cont_volnotcached
  end
  -- volume and drive are good, update inuse and return
  set @o_reservationid = @reservationid
  set @o_driveid = @driveid
  select @o_rcid = rcid
  from mmresourcetojob
  where jobid_l = @i_jobid_l
  and reservationid = @o_reservationid
  and inuse = 0
  if @drivepoolid != @i_drivepoolid
	update mmresource set drivepoolid = @i_drivepoolid
	where reservationid = @reservationid
  update mmresourcetojob set inuse = 1
  where rcid = @o_rcid
  goto exit_done
end
	-- Check if the media reserved by other job or not
 	declare @isReservable int
 	set @isReservable = 0
 	exec RMIsVolumeReservable 0, @i_jobid_l, @i_volumeid, 0, @i_drivepoolid, 0, 0, 0,
 														1 /*RM_RESERVE_TYPE_READ*/, 1, 0,
 														@isReservable output, @o_ErrorCode output
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
		goto exit_done
	end
if @isReservable = 0 OR @o_ErrorCode != 0
	begin
	  goto exit_done
	end
cont_volnotcached:
declare @drivecount integer
declare @drivelist table (reservationid int, rcid int, driveid int, volumeid int, releasetime int)
insert into @drivelist
select a.reservationid, b.rcid, a.driveid, a.volumeid, b.releasetime
from mmresource a, mmresourcetojob b
where b.jobid_l = @i_jobid_l and b.reservationtype = 1 and b.inuse = 0 and b.releasetime != 0
and a.reservationid = b.reservationid
and a.intrjobid_l = 0
and a.driveid in (
					select driveid from mmdrivecontroller
					where drivepoolid = @i_drivepoolid
					and (drivecontrollersoftstate + drivecontrollerenabled + driveaccessible) = 3
				)
order by a.volumeid, b.releasetime
select @drivecount = @@rowcount
-- check drive
if @drivecount > 0
begin
  -- there are some drives cached,
  -- pick a drive from available cached drives
  select top 1	@o_reservationid = reservationid,
				@o_driveid = driveid,
				@o_rcid = rcid
  from @drivelist
  update mmresource
  set volumeid = @i_volumeid, mediaid = @mediaid, mediagroupid = @mediagroupid, drivepoolid = @i_drivepoolid
  where reservationid = @o_reservationid
  and driveid = @o_driveid
  update mmresourcetojob
  set ReserveBitMask = 4, inuse = 1, releasetime = 0
  where rcid = @o_rcid
  goto exit_done
end
exit_done:
	--IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
		select @o_ErrorCode, @o_reservationid, @o_driveid, @o_rcid
	--END
GO

IF EXISTS (select * from GxQscripts where name = 'RMRestoreCachingReserve')
	delete from GxQscripts where name = 'RMRestoreCachingReserve'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMRestoreCachingReserve')
	delete from GXDBVersions where aliasname = 'RMRestoreCachingReserve'
GO

insert into GXDBVersions values(2, 'RMRestoreCachingReserve',  '00010006001200030000', 'RMRestoreCachingReserve', '00010006001200030000')
GO

